/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 5)
/******************************************************************************/
(use "main")
(use "controls")
(use "cycle")
(use "game")
(use "feature")
(use "obj")
(use "inv")
(use "door")
(use "jump")
(use "menubar")
/******************************************************************************/
(instance public rm005 of Rm
 (properties
  picture scriptNumber
  // Set up the rooms to go to/come from here
		north 0
		east 0
		south 3
		west 0
 )
 (method (init)
		// same in every script, starts things up
  (super:init())
  (self:setScript(RoomScript))

  		// Check which room ego came from and position it
  (switch(gPreviousRoomNumber)
            /******************************************************
             * Put the cases here for the rooms ego can come from *
             ******************************************************/
   (default
    (send gEgo:
  	 posn(166 180)
  	 loop(3)
    )
   )
  )

		// Set up the ego
  SetUpEgo()
  (send gEgo:init())
        (clerk:init())
       (if(== Coins 2)
        (aBoy2:
         init()
         setCycle(Fwd)
        )
        (tv:
         init()
         setCycle(Fwd)
        )
       )(else
        (aBoy1:init())
       )
       (self:setRegions(700))

        /****************************************
         * Set up the room's music to play here *
         ****************************************/ /*
		(send gTheMusic:
			prevSignal(0)
			stop()
			number(scriptNumber)
			loop(-1)
			play()
		)*/

        /**************************************************
         * Add the rest of your initialization stuff here *
         **************************************************/

 )
)

/******************************************************************************/
(instance RoomScript of Script
 (properties)
 (method (handleEvent pEvent)
  (var dyingScript)
  (super:handleEvent(pEvent))

        /*****************************************
         * Handle the possible said phrases here *
         *****************************************/
  (if(Said('insert>'))
   (if(Said('/coin'))
    (if(== Coins 1)
     Print("You are too old to play on the arcade.")
    )(else
     Print("You don't have a coin to play on the arcade.")
    )
   )
   (if(Said('/credit'))
    Print("Too sad! You can't insert your credit card to play on the arcade.")
   )
  )
  (if(Said('take/arcade'))
    Print("You can't take the arcade because it's too big. Good try anyway.")
   (if(== Arcade 0)
    = Arcade(+ Arcade 1)
    = gScore(+ gScore 1)
   )
  )
  (if(Said('look>'))
   (if(Said('/child,boy'))
    (if(== Coins 2)
     Print("The boy's playing on the arcade. Don't bother him.")
    )(else
     Print("The boy's near the arcade. He looks upset.")
    )
    )(else
    (if(Said('/clerk,man'))
     Print("The clerk is waiting your command.")
     )(else
      (if(Said('/menu'))
       Print("You can only command hamburgers and colas.")
      )(else
       (if(Said('/arcade'))
        Print("The arcade is used to keep the kids busy.")
       )(else
        (if(Said('[ /* , !* ]'))
         Print(
         "You are inside the McJoe restaurant. "+
         "A clerk is behind the counter. "+
         "A kid is near the arcade. "+
         "You see a menu on the wall."
        )
       )
      )
     )
    )
   )
  )
  (if(Said('talk,say>'))
   (if(Said('/clerk,man'))
    (if(< (send gEgo:distanceTo(clerk)) 20)
     Print("\"Welcome to McJoe. May I help you?\""  #title "A clerk:")
    )(else
     Print("Get closer to the clerk if you want to talk with him.")
    )
   )
   (if(Said('/kid,boy'))
    (if(< (send gEgo:distanceTo(aBoy1)) 20)
     (if(< Coins 2)
      Print("\"Too bad. I'm out of coins.\""  #title "A boy:")
     )(else
      Print("He's too busy to speak to you at the moment.")
     )
    )(else
     Print("Get closer to the boy if you want to speak with him.")
    )
   )
  )
  (if(Said('give>'))
   (if(Said('/coin'))
    (if(<> Coins 1)
     Print("You don't have it")
    )(else
     (if(< (send gEgo:distanceTo(clerk)) 20)
      Print("The clerk does not need coins.")
     )(
      (if(< (send gEgo:distanceTo(aBoy1)) 20)
       (if (== Coins 1)
        Print("You give the coin to the boy")
        Print("\"Thank you mister.\""  #title "A boy:")
        = Coins 2
        = gScore (+ gScore 2)
        (send gEgo:put(INV_COIN scriptNumber))
        (aBoy1:hide())
        (aBoy2:
         init()
         setCycle(Fwd)
        )
        (tv:
         init()
         setCycle(Fwd)
        )
       )
      )
     )
    )
   )
  )
  (if(Said('buy>'))
   (if(Said('/cola'))
    (if(< (send gEgo:distanceTo(clerk)) 20)
     (if(> Cola 0)
      Print("You don't need another cola.")
     )(else
      Print("Using your credit card, you pay the cola to the clerk.")
      (send gEgo:get(INV_COLA))
      (= Cola(+ Cola 1))
      (= gScore(+ gScore 2))
     )
    )(else
     Print("Get closer to the clerk if you want to buy something.")
    )
   )
   (if(Said('/hamburger'))
    (if(< (send gEgo:distanceTo(clerk)) 20)
     (if(> Hamburger 0)
      Print("You don't need another hamburger.")
     )(else
      Print("Using your credit card, you pay the hamburger to the clerk.")
      (send gEgo:get(INV_HAMBURGER))
      (= Hamburger(+ Hamburger 1))
      (= gScore(+ gScore 2))
     )
    )(else
     Print("Get closer to the clerk if you want to buy something.")
    )
   )
  )
 )
)
(instance clerk of Act
  (properties
    y 130
    x 125
    view 9
  )
)
(instance aBoy1 of Act
  (properties
    y 116
    x 201
    view 16
    loop 0
  )
)
(instance aBoy2 of Act
  (properties
    y 116
    x 201
    view 16
    loop 1
  )
)
(instance tv of Act
  (properties
    y 89
    x 199
    view 18
  )
)
/******************************************************************************/
