/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 6)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
(local
 poorc64=0
)
/******************************************************************************/
(instance public rm006 of Rm
 (properties
		picture 16 //scriptNumber
		north 0
		east 0
		south 0
		west 0
 )
 (method (init)
  (super:init())
  (self:setScript(RoomScript))
   (switch(gPreviousRoomNumber)
   (default
    (send gEgo:
      posn(289 177)
      loop(1)
    )
   )
  )
  SetUpEgo()
  (send gEgo:init())
  (aMan:
   init()
   setCycle(Walk)
   setMotion(MoveTo 233 138 RoomScript)
  )
 )
)
/******************************************************************************/
(instance RoomScript of Script
 (properties)
 (method (handleEvent pEvent)
  //(var dyingScript)
  (super:handleEvent(pEvent))
  (if(Said('take>'))
   (if(Said('/c64'))
    (if(== poorc64 0)
     (if(< (send gEgo:distanceTo(aMan)) 30)
      (aMan:hide())
      Print("You save your beloved computer from recycling.")
      (send gRoom:newRoom(7))
     )(else
      Print("Unless you are Mister Fantastic, you can't save your computer from this distance.")
     )
    )(else
     Print("It's too late to save your Commodore 64. What a shame.")
    )
   )(else
    (if(Said('[ /* , !* ]'))
     Print("Take what?")
    )
   )
  )
  (if(Said('look>'))
   (if(Said('/c64'))
    (if(== poorc64 0)
     Print("Your Commodore 64 is going to get recycled if you do not something to do.")
    )(else
     Print("Your Commodore is recyled into toaster.")
    )
   )(else
    (if(Said('[ /* , !* ]'))
     Print("It's not the time to look around, it's the time to save your computer.")
    )
   )
  )
 )
 (method (changeState newState)
  (var dyingScript)
   = state newState
  (switch (state)
   (case 0
    //Print("This is state 0! The room has started!")
   )
   (case 1
    //Print("The view has moved to it's first position!")
    (aMan:hide())
    (ShakeScreen(2 ssFULL_SHAKE))
    (Toaster:
     init()
     setMotion(MoveTo 278 138 RoomScript)
     = poorc64 1
    )
   )
   (case 2
    = dyingScript ScriptID(DYING_SCRIPT)
    (send dyingScript:
     caller(3)
     Print("Too late! Your Commodore 64 was recycled into toaster. You failed to save your computer.")
     register("Game over! Thank you for playing \"DG: I want my C64 back\".")
     (send gGame:setScript(dyingScript))
    )
   )
  )
 )
)
(instance aMan of Act
  (properties
   y 138
   x 52
   /* y 170
    x 52*/
    view 10
  )
)
(instance Toaster of Act
  (properties
   y 138
   x 233
   /* y 170
    x 52*/
    view 11
  )
)
/******************************************************************************/
