/******************************************************************************
 SCI Template Game
 By Brian Provinciano
 ******************************************************************************
 dying.sc
 Contains a public script instance to handle when the ego dies.
 ******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script DYING_SCRIPT)
/******************************************************************************/
(use "main")
(use "controls")
(use "dcicon")
(use "cycle")
(use "obj")
/******************************************************************************/
(instance public DyingScript of Script
 (properties)
 (method (changeState newState)
  (var mbResult, message)
   = state newState
  (if(== state 0)
   ProgramControl()
   //(send gTheMusic:fade())
   (send gRoom:setScript(0))
   	//Load(rsSOUND 2)
   	= seconds 3
  )(else
   (if(== state 1)
  	/*(send gTheSoundFX:stop())
  	(send gTheMusic:
  	 number(2)
  	 loop(1)
  	 priority(-1)
  	 play()*/
  	//)
                // The following lines give a typical Sierra style
                // message box telling the player that they have died.
                // You can customize it to your liking.
	(if(<> NULL caller)
     Load(rsVIEW caller)
  	 (deadIcon:view(caller))
    )(else
  	 Load(rsVIEW DYING_SCRIPT)
     (deadIcon:view(DYING_SCRIPT))
    )
    (if(<> NULL register)
  	 = message register
   	)(else
  	 = message "Partie terminee! Merci d'avoir joue a: \"DG: I want my C64 back\"."
    )
  	(if(Print(
  					message
  	   				#font gDeadFont
  					#icon deadIcon
  					#button "Continuer." 0
  					#button "Besoin d'aide?" 1
  	     	 )
       )
       Print(
  			 "Si vous avez besoin d'aide a ce jeu, veuiller "+
  			 "consulter DGFC64.TXT pour plus de details.\n\nRobin Gravel"
  			)
  	)
   	(while(1)
  	 = mbResult Print(
  	                    "Sauvegarder toujours! Sauvegarder souvent."
  	                    #title "Les paroles de Robin Gravel:"
  						#font gDeadFont
  						#button " Restaurer "  1
  						#button "Recommencer"  2
  						#button "  Quitter  " 3
  					 )
  					 (switch(mbResult)
  						(case 1
  							(if(<> (send gGame:restore()) -1) 
  								return
  							)
		    			)
		    			(case 2
  							(send gGame:restart())
  							return
		    			)
		    			(case 3
		    				= gQuitGame TRUE
		    				return
		    			)
	 )
	)
   )
  )
 )
)
/******************************************************************************/
(instance deadIcon of DCIcon
	(properties)
	(method (init)
		(super:init())
		(if(== gRoomNumberExit 540)
			= cycler (End:new())
			(send cycler:init(self))
		)
	)
)
/******************************************************************************/
