/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 4)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
/******************************************************************************/
(instance public rm004 of Rm
	(properties
		picture scriptNumber
		north 0
		east 1
		south 0
		west 0
	)
	(method (init)
		(super:init())
		(self:setScript(RoomScript))

		(switch(gPreviousRoomNumber)
            /******************************************************
             * Put the cases here for the rooms ego can come from *
             ******************************************************/
            (case east
  				(send gEgo:
  					posn(310 160)
  					loop(1)
  				)
  			)
		)

		SetUpEgo()
		(send gEgo:init())
        (aMan:init())
     (self:setRegions(700))

	)
)
/******************************************************************************/
(instance RoomScript of Script
 (properties)
 (method (handleEvent pEvent)
  (var dyingScript)
  (super:handleEvent(pEvent))

        /*****************************************
         * Handle the possible said phrases here *
         *****************************************/
  (if(Said('give>'))
   (if(Said('/hamburger'))
    (if(== Hamburger 0)
     Print("Vous n'avez pas de ca.")
    )(else
     (if(== Guard 0)
      Print("\"Je n'ai pas faim en ce moment. Merci quand meme.\"" #title "Le gardien:")
     )(else
      Print("Vous donnez un hamburger au gardien.")
      (= Hamburger(+ Hamburger 1))
      (if(== Cola 2)
       Print("\"Merci. Vous pouvez entrer dans ce batiment.\"" #title "Le gardien:")
       (= Guard(+ Guard 1))
      )(else
       Print("\"J'ai soif. J'ai besoin de boire quelque chose.\"" #title "Le gardien:")
      )
      (= gScore(+ gScore 3))
      (send gEgo:put(INV_HAMBURGER scriptNumber))
     )
    )
   )
   (if(Said('/cola'))
    (if(== Cola 0)
     Print("Vous n'avez pas de cola.")
    )(else
     (if(== Guard 0)
      Print("\"Non merci. J'ai pas soif.\"" #title "Le gardien:")
     )(else
      Print("Vous donnez le cola au gardien.")
      (= Cola(+ Cola 1))
      (if(== Hamburger 2)
       Print("\"Merci. Tu peux entrer dans le batiment.\"" #title "Le gardien:")
       (= Guard(+ Guard 1))
      )(else
       Print("\"J'ai faim. J'ai besoin de grignoter quelque chose.\"" #title "Le gardien:")
      )
      (= gScore(+ gScore 2))
      (send gEgo:put(INV_COLA scriptNumber))
     )
    )
   )
  )
  (if(Said('look>'))
   (if(Said('/guard, man'))
    Print("Le gardien ne fait entrer que les personnes autorisees.")
   )(else
    (if(Said('[ /* , !* ]'))
     Print("Vous etes devant un centre de recyclage. Un gardien surveille la porte.")
    )
   )
  )
  (if(Said('talk/man, guard'))
   (if(< (send gEgo:distanceTo(aMan)) 40)
    (if(== Guard 2)
     Print("\"Maintenant tu peux y aller.\"" #title "Le gardien:")
    )(
     (if(== Guard 1)
      Print("\"Va-t-en ou j'appelle la police.\"" #title "Le gardien:")
     )(else
      (if(== Guard 0)
       Print("\"Ma femme va me preparer de bons plats ce soir.\"" #title "Le gardien:")
       Print("\"He toi! Qu'est ce que tu veux?\"" #title "Le gardien:")
       Print("\"J'ai affaire au centre de recyclage pour recuperer mon Commodore 64.\"" #title "DG:")
       Print("\"Non tu n'y entreras pas. Seule les personnes autorisees peuvent y entrer.\n\n"+
             "Desole petit. Je ne fais que mon travail.\"" #title "Le gardien:")
       = Guard (+ Guard 1)
     )
    )
    )
   )(else
    Print("Vous ne voulez pas crier au gardien. Approchez vous de lui.")
   )
  )
  (if(Said('open/door'))
   (if(send gEgo:inRect(24 88 74 94))
    (if(not(== Guard 2))
     Print("\"Je ne peux pas entrer au centre de recyclage avec ce gardien qui fait sa ronde.\"" #title"DG:")
    )(else
     (send gRoom:newRoom(6))
    )
   )(else
    Print("Approchez vous de la porte.")
   )
  )
 )
)
(instance aMan of Act
  (properties
    y 90
    x 76
    view 4
  )
)
/******************************************************************************/
