'$DYNAMIC
'$INCLUDE: '3d_new.bi'
DEFINT A-Z
DECLARE SUB LoadData (LN%)
DECLARE SUB finished (n%)
DECLARE SUB SetUpAll ()
DECLARE SUB MakeFloor ()
DECLARE SUB MakeWall ()
DECLARE SUB GetInput ()
DECLARE SUB DoWallSliding (th%, Angle%, vel%, dummy%)
DECLARE SUB RotateY (p1%, p2%, p3%, dummy%)
DECLARE FUNCTION ClipIt% (j%)
DECLARE SUB DoFCTmap (j%, M%)
DECLARE SUB DoWTmap (i%, M%)
DECLARE FUNCTION IsOnScreen% (x1%, y1%, x2%, y2%, x3%, y3%)
DECLARE SUB MakeBackgr (Times%, Direction%)
DECLARE SUB TransAll (index%, kx%, kz%, dummy%)
DECLARE SUB OpenDoor ()
DECLARE SUB DOSpr (i%, dummy%)
DECLARE SUB DoSFX ()
DECLARE SUB ScrollTex (ScrollN%, Handle%)
DECLARE SUB ChangeTex (N1%, N2%, Handle%, dummy%)
DECLARE SUB DoVisible ()
DECLARE SUB EnemyHandle ()
DECLARE SUB LoadStats ()
DECLARE SUB SaveStats ()
DECLARE SUB LoadED ()
DECLARE SUB SaveED ()

TYPE IndexType
depth AS INTEGER
ind AS INTEGER
END TYPE
TYPE EnemyType
H AS INTEGER
A AS INTEGER
i AS INTEGER
END TYPE
TYPE PolyType
x1 AS INTEGER
y1 AS INTEGER
z1 AS INTEGER
x2 AS INTEGER
y2 AS INTEGER
z2 AS INTEGER
x3 AS INTEGER
y3 AS INTEGER
z3 AS INTEGER
x4 AS INTEGER
y4 AS INTEGER
z4 AS INTEGER
in AS INTEGER
px AS INTEGER
pz AS INTEGER
t AS INTEGER
END TYPE

DIM SHARED Sine%(360), Cosine%(360)
DIM SHARED ViewX%, ViewZ%, Yangle%, swing%, SprHAnim1%, SprHAnim2%
DIM SHARED tex%(8200), tex2%(8200), add1%(16), KT%(64)
DIM SHARED NofFloors%, FloorBytes%, NofWalls%, WallBytes%, CeilBytes%, DoorBytes%, SpriteBytes%
DIM SHARED Tri(450) AS PolyType, index(400) AS IndexType
DIM SHARED TriOFF&, TriCOFF&, TriDOFF&, TriSOFF&, TexOFF&, TexOFF2&, TFF&(20), T4100&(20), IndOFF&
DIM SHARED FloorH%, WallH%, CeilH%, DoorH%, SpriH%, TexFH%, TexWH%, TexC1H%, TexC2H%, TexSPH%, Tseg%, Toff%, Tseg2%, Toff2%, IndH%, NumbH%, EnemyH%
DIM SHARED PXadd%(8, 8), PZadd%(8, 8)
DIM SHARED FaceH%, NFace%, FlagFace%, NofDoors%, SPRa1%, SPRa2%, SPRa1F%, SPRa2F%, TsaSEG%, TsaOFF%
DIM SHARED xx1%, xx2%, xx3%, xx4%, zz1%, zz2%, zz3%, zz4%
DIM SHARED TfNumber%, TCNumber%, TWnumber%, StartC%, EndC%, StartD%, EndD%, StartS%, EndS%, TC%
DIM SHARED Back%, ChangeF%(1), ScrollF%, ScrollW%, ChangeW%(1), ScrollC%, ChangeC%(1), BackScroll%
DIM SHARED LevelN%, ExitX%, ExitZ%, ExitAng%, EnterX%, EnterZ%, LevCH%
DIM SHARED PZX1%(16), PZX2%(16), PZZ1%(16), PZZ2%(16)
DIM SHARED txx%(32), tyy1%(32), tyy2%(32), tyy3%(32)
DIM SHARED ptz%(1, 32)
DIM SHARED tx%(8, 8), ty%(8, 8), t1y%(8, 8), dtz%(8)
DIM SHARED CurWeap%, WeapAnim%, WeapFlag%, Health%, BalmAnim%, BalmN%, BalmSwing%
DIM SHARED FPS%, FPSCount%, FPSPrint%, FPSShow%, BarShow%, MessText AS STRING * 32, MessTime%, LoadIt%
DIM SHARED WeapCarry%(1 TO 4), WeapAttack%(1 TO 4), WeapHit1%(1 TO 4), WeapHit2%(1 TO 4), WeapDamage%(1 TO 4)
DIM SHARED Enemy%, NofEnemy%, EnemyHealth%(1 TO 10), EnemyNumber%(1 TO 10), EnemyWalk%(1 TO 10), EnemyDie%(1 TO 10), EnemyDamage%(1 TO 10), Enemies(1 TO 30) AS EnemyType
DIM SHARED EnemySpeed%(1 TO 10), EnemyRange%(1 TO 10), EnemySH%(1 TO 10), EnemyEH%(1 TO 10), EnemyGHit%(1 TO 10)
DIM SHARED BeenHere%(1 TO 10)

IF DQBinit(15, 0, 0) THEN finished 1
DQBinitVGA
DQBinstallKeyboard
DQBsetTextureSize 128

dummy& = SETMEM(-2048)
IF DQBcreateBMap(1, 1, 4) THEN finished 1

SetUpAll
LoadData LevelN%
SaveStats

DO
DoVisible
MakeFloor
DQBcopyBlendLayer 2 - (Back% > 0), 1, 1
MakeWall
EnemyHandle
GetInput
DoSFX
LOOP

REM $STATIC
SUB ChangeTex (N1%, N2%, Handle%, dummy%)
dummy% = VSMoveXMS%(TexOFF&, 0, TFF&(N1%), Handle%, 16400)
dummy% = VSMoveXMS%(TFF&(N1%), Handle%, TFF&(N2%), Handle%, 16400)
dummy% = VSMoveXMS(TFF&(N2%), Handle%, TexOFF&, 0, 16400)
END SUB

FUNCTION ClipIt% (j%)
IF Tri(j%).z1 < -Tri(j%).y1 AND Tri(j%).z2 < -Tri(j%).y2 AND Tri(j%).z3 < -Tri(j%).y3 AND Tri(j%).z4 < -Tri(j%).y4 THEN ClipIt% = 1: EXIT FUNCTION
IF Tri(j%).z1 < Tri(j%).y1 AND Tri(j%).z2 < Tri(j%).y2 AND Tri(j%).z3 < Tri(j%).y3 AND Tri(j%).z4 < Tri(j%).y4 THEN ClipIt% = 1: EXIT FUNCTION
IF Tri(j%).x1 < -Tri(j%).z1 AND Tri(j%).x2 < -Tri(j%).z2 AND Tri(j%).x3 < -Tri(j%).z3 AND Tri(j%).x4 < -Tri(j%).z4 THEN ClipIt% = 1: EXIT FUNCTION
IF Tri(j%).z1 < Tri(j%).x1 AND Tri(j%).z2 < Tri(j%).x2 AND Tri(j%).z3 < Tri(j%).x3 AND Tri(j%).z4 < Tri(j%).x4 THEN ClipIt% = 1: EXIT FUNCTION
IF Tri(j%).z1 <= 0 AND Tri(j%).z2 <= 0 AND Tri(j%).z3 <= 0 AND Tri(j%).z4 <= 0 THEN ClipIt% = 1
END FUNCTION

SUB DoFCTmap (j%, M%)
LE% = (ABS(Tri(j%).x1 + Tri(j%).x2 + Tri(j%).x3 + Tri(j%).x4) + ABS(Tri(j%).z1 + Tri(j%).z2 + Tri(j%).z3 + Tri(j%).z4)) \ 4
SELECT CASE LE%
CASE 0 TO 128
f% = 8: FF% = 7: KF% = 16
CASE 129 TO 255
f% = 4: FF% = 3: KF% = 32
CASE ELSE
f% = 1: FF% = 0: KF% = 128
END SELECT

FOR dz% = 1 TO f%:  dtz%(dz%) = dtz%(dz% - 1) + KF%: NEXT dz%
TPP& = Tri(j%).in * 100&

FOR dx% = 0 TO f%: FOR dz% = 0 TO f%
NZ1% = Tri(j%).z1 + PZadd%(dx%, dz%) \ f%
IF NZ1% <= 0 THEN NZ1% = 1
tx%(dx%, dz%) = 160 + ((Tri(j%).x1 + PXadd%(dx%, dz%) \ f%) * 160&) \ NZ1%
ty%(dx%, dz%) = TC% + 3200 \ NZ1%: t1y%(dx%, dz%) = TC% - TPP& \ NZ1%
NEXT dz%, dx%
		
IF M% = 1 THEN
IF TfNumber% <> Tri(j%).t THEN dummy% = VSMoveXMS(TexOFF&, 0, TFF&(Tri(j%).t), TexFH%, 16400): TfNumber% = Tri(j%).t
FOR dx% = 0 TO FF%: FOR dz% = 0 TO FF%
	x1% = tx%(dx%, dz%): y1% = ty%(dx%, dz%)
	x2% = tx%(add1%(dx%), dz%): y2% = ty%(add1%(dx%), dz%)
	x3% = tx%(add1%(dx%), add1%(dz%)): y3% = ty%(add1%(dx%), add1%(dz%))
	IF IsOnScreen%(x1%, y1%, x2%, y2%, x3%, y3%) THEN
		 DQBttri 1, x1%, y1%, x2%, y2%, x3%, y3%, dtz%(dx%), dtz%(dz%), dtz%(add1%(dx%)), dtz%(dz%), dtz%(add1%(dx%)), dtz%(add1%(dz%)), Tseg%, Toff%
	END IF
	x2% = x3%: y2% = y3%: x3% = tx%(dx%, add1%(dz%)): y3% = ty%(dx%, add1%(dz%))
	IF IsOnScreen%(x1%, y1%, x2%, y2%, x3%, y3%) THEN
		 DQBttri 1, x1%, y1%, x2%, y2%, x3%, y3%, dtz%(dx%), dtz%(dz%), dtz%(add1%(dx%)), dtz%(add1%(dz%)), dtz%(dx%), dtz%(add1%(dz%)), Tseg%, Toff%
	END IF
NEXT dz%, dx%
END IF
   
IF Tri(j%).in = 0 THEN EXIT SUB
IF Tri(j%).in > 140 AND f% = 8 THEN EXIT SUB

IF TCNumber% <> Tri(j%).t THEN dummy% = VSMoveXMS(TexOFF2&, 0, TFF&(-Tri(j%).t * (M% = 2)), -((M% = 1) * TexC1H% + (M% = 2) * TexC2H%), 16400): TCNumber% = Tri(j%).t
IF M% = 2 THEN Bl% = (LE% \ 64): IF Bl% > 4 THEN Bl% = 4

FOR dx% = 0 TO FF%: FOR dz% = 0 TO FF%
x1% = tx%(dx%, dz%): y1% = t1y%(dx%, dz%)
x2% = tx%(add1%(dx%), dz%): y2% = t1y%(add1%(dx%), dz%)
x3% = tx%(add1%(dx%), add1%(dz%)): y3% = t1y%(add1%(dx%), add1%(dz%))
IF IsOnScreen%(x1%, y1%, x2%, y2%, x3%, y3%) THEN
DQBttri 1, x1%, y1%, x2%, y2%, x3%, y3%, dtz%(dx%), dtz%(dz%), dtz%(add1%(dx%)), dtz%(dz%), dtz%(add1%(dx%)), dtz%(add1%(dz%)), Tseg2%, Toff2%
IF M% = 2 AND Bl% > 0 THEN DQBbtri 1, x1%, y1%, x2%, y2%, x3%, y3%, Bl%, 1
END IF
x2% = x3%: y2% = y3%: x3% = tx%(dx%, add1%(dz%)): y3% = t1y%(dx%, add1%(dz%))
IF IsOnScreen%(x1%, y1%, x2%, y2%, x3%, y3%) THEN
DQBttri 1, x1%, y1%, x2%, y2%, x3%, y3%, dtz%(dx%), dtz%(dz%), dtz%(add1%(dx%)), dtz%(add1%(dz%)), dtz%(dx%), dtz%(add1%(dz%)), Tseg2%, Toff2%
IF M% = 2 AND Bl% > 0 THEN DQBbtri 1, x1%, y1%, x2%, y2%, x3%, y3%, Bl%, 1
END IF
NEXT dz%, dx%
END SUB

SUB DoSFX
IF CurWeap% THEN
DEF SEG = DQBmapLayer(13)
	IF WeapAnim% < WeapCarry%(CurWeap%) THEN
		WeapAnim% = WeapAnim% + 1: WeapFlag% = 0: LoadIt% = 1
	ELSEIF WeapAnim% = WeapCarry%(CurWeap%) AND WeapFlag% = 0 THEN
		WeapFlag% = 1: LoadIt% = 1
	ELSEIF WeapAnim% > WeapCarry%(CurWeap%) AND WeapAnim% < WeapAttack%(CurWeap%) THEN
		BLOAD "DATA\LOADS\WEAP\weap" + LTRIM$(STR$(CurWeap%)) + "_" + LTRIM$(STR$(WeapAnim%)) + ".dat", 0
		WeapAnim% = WeapAnim% + 1
		IF WeapAnim% = WeapAttack%(CurWeap%) THEN WeapAnim% = WeapCarry%(CurWeap%): WeapFlag% = 0
	END IF
IF LoadIt% THEN BLOAD "DATA\LOADS\WEAP\weap" + LTRIM$(STR$(CurWeap%)) + "_" + LTRIM$(STR$(WeapAnim%)) + ".dat", 0
DQBcopyTransLayer 13, 1
END IF
   
LoadIt% = ASC(RIGHT$(TIME$, 1)): BalmAnim% = (BalmAnim% + 1) MOD 3

IF FPSShow% THEN
	IF FPS% = LoadIt% THEN
	FPSCount% = FPSCount% + 1
	ELSE
	FPS% = LoadIt%: FPSPrint% = FPSCount% + 2: FPSCount% = 0
	END IF
dummy% = VSMoveXMS%(TexOFF&, 0, (FPSPrint% \ 10) * 512, NumbH%, 500): DQBput 1, 50, 0, Tseg%, Toff%
dummy% = VSMoveXMS%(TexOFF&, 0, (FPSPrint% MOD 10) * 512, NumbH%, 500): DQBput 1, 60, 0, Tseg%, Toff%
dummy% = VSMoveXMS%(TexOFF&, 0, 6000, NumbH%, 1500): DQBput 1, 0, 0, Tseg%, Toff%
END IF

IF ABS(MessTime% - LoadIt%) < 5 THEN
FOR i% = 0 TO 31
	DEF SEG = VARSEG(MessText): L% = PEEK(VARPTR(MessText) + i%)
	IF L% > 32 THEN
	DEF SEG = Tseg%: BLOAD "DATA\LOADS\FONTS\" + CHR$(L%) + ".dat", Toff%
	DQBput 1, x% + 5, 20, Tseg%, Toff%
	x% = x% + tex%(0) \ 8
	ELSE
	x% = x% + 16
	END IF
NEXT i%
ELSE
MessText = ""
END IF

IF BarShow% THEN
dummy% = VSMoveXMS%(TexOFF&, 0, (Health% \ 100) * 512, NumbH%, 500): DQBput 1, 75, 180, Tseg%, Toff%
dummy% = VSMoveXMS%(TexOFF&, 0, ((Health% MOD 100) \ 10) * 512, NumbH%, 500): DQBput 1, 85, 180, Tseg%, Toff%
dummy% = VSMoveXMS%(TexOFF&, 0, (Health% MOD 10) * 512, NumbH%, 500): DQBput 1, 95, 180, Tseg%, Toff%
Load% = (Health% \ 20): IF Load% > 4 THEN Load% = 4
	IF FlagFace% <> Load% THEN
		FlagFace% = Load%: DEF SEG = Tseg%
		FOR i% = 0 TO 7
		BLOAD "DATA\LOADS\FACE\face" + LTRIM$(STR$(Load%)) + "_" + LTRIM$(STR$(i%)) + ".dat", Toff%
		dummy% = VSMoveXMS%(i% * 1500, FaceH%, TexOFF&, 0, 1500)
		NEXT i%
	 END IF
dummy% = VSMoveXMS%(TexOFF&, 0, NFace% * 1500, FaceH%, 1500): DQBfPut 1, 37, 164, Tseg%, Toff%
dummy% = VSMoveXMS%(TexOFF&, 0, 8000 + BalmAnim% * 1000, NumbH%, 1000): DQBsPut 1, 217, 163, Tseg%, Toff%, 40, 40
dummy% = VSMoveXMS%(TexOFF&, 0, (BalmN% \ 100) * 512, NumbH%, 500): DQBput 1, 253, 180, Tseg%, Toff%
dummy% = VSMoveXMS%(TexOFF&, 0, ((BalmN% MOD 100) \ 10) * 512, NumbH%, 500): DQBput 1, 263, 180, Tseg%, Toff%
dummy% = VSMoveXMS%(TexOFF&, 0, (BalmN% MOD 10) * 512, NumbH%, 500): DQBput 1, 273, 180, Tseg%, Toff%
DQBcopyTransLayer 14, 1
END IF
DQBcopyLayer 1, 0: DQBcopyLayer 15, 4

IF SPRa1% > -1 THEN SPRa1F% = (SPRa1F% + 1) MOD SPRa1%
IF SPRa2% > -1 THEN SPRa2F% = (SPRa2F% + 1) MOD SPRa2%
BalmSwing% = (BalmSwing% + 15) MOD 180
IF Health% > 100 THEN Health% = Health% - 1

IF DQBkey(1) THEN
DEF SEG = DQBmapLayer(1)
BLOAD "DATA\LOADS\MESSAGE\doyou.dat", 0
DQBcopyLayer 0, 10: DQBcopyTransLayer 1, 0
DO
IF DQBkey(&H15) THEN DQBcopyLayer 10, 0: finished 0
IF DQBkey(&H31) THEN EXIT DO
LOOP
END IF

IF ScrollF% > -1 THEN ScrollTex ScrollF%, TexFH%
IF ScrollW% > -1 THEN ScrollTex ScrollW%, TexWH%
IF ScrollC% > -1 THEN ScrollTex ScrollC%, TexC2H%
IF ChangeF%(0) > -1 THEN ChangeTex ChangeF%(0), ChangeF%(1), TexFH%, dummy%
IF ChangeW%(0) > -1 THEN ChangeTex ChangeW%(0), ChangeW%(1), TexWH%, dummy%
IF ChangeC%(0) > -1 THEN ChangeTex ChangeC%(0), ChangeC%(1), TexC2H%, dummy%

IF Back% THEN
IF BackScroll% THEN MakeBackgr 1, 1
DQBxPut 9, 0, 0, 319, 49, 1, 0, 0: DQBxPut 9, 0, 50, 319, 99, 1, 0, 50
END IF

IF ABS(ExitX% - ViewX%) + ABS(ExitZ% - ViewZ%) < 40 THEN
IF DQBkey(&H39) THEN
DEF SEG = DQBmapLayer(10): BLOAD "DATA\LOADS\MESSAGE\Loading.dat", 0: DQBcopyTransLayer 10, 0: DQBclearLayer 10: DQBwait 15
SaveED
BeenHere%(LevelN%) = 1: LevCH% = 1: LevelN% = LevelN% + 1: MessText = ""
	IF LevelN% = 5 THEN LevelN% = 1
LoadData LevelN%
IF BeenHere%(LevelN%) THEN LoadED
SaveStats
ELSE
IF BeenHere%(LevelN% + 1) = 0 THEN MessTime% = LoadIt%: MessText = "Press SPACE to enter"
END IF
END IF

IF Health% = 0 THEN
LevCH% = 1: MessText = "": LoadData LevelN%: LoadStats
IF BeenHere%(LevelN%) THEN LoadED
FOR j% = 0 TO 65: FOR i% = 0 TO 255
OUT &H3C7, i%: r% = INP(&H3C9): g% = INP(&H3C9): b% = INP(&HC39)
r% = r% + (r% > 50) - (r% < 50)
OUT &H3C8, i%: OUT &H3C9, r%: OUT &H3C9, 0: OUT &H3C9, 0
NEXT i%: DQBwait 2: NEXT j%
DIM k(768) AS STRING * 1
DEF SEG = VARSEG(k(0)): BLOAD "DATA\LOADS\PAL\palette.dat", VARPTR(k(0))
FOR i% = 0 TO 255: OUT &H3C8, i%: OUT &H3C9, ASC(k(i% * 3)): OUT &H3C9, ASC(k(i% * 3 + 1)): OUT &H3C9, ASC(k(i% * 3 + 2)): NEXT i%
END IF

IF ABS(EnterX% - ViewX%) + ABS(EnterZ% - ViewZ%) < 40 AND DQBkey(&H39) = -1 AND LevelN% > 1 THEN
DEF SEG = DQBmapLayer(10): BLOAD "DATA\LOADS\MESSAGE\Loading.dat", 0: DQBcopyTransLayer 10, 0: DQBclearLayer 10: DQBwait 15
SaveED
BeenHere%(LevelN%) = 1: LevCH% = 1: LevelN% = LevelN% - 1
LoadData LevelN%
LoadED
ViewX% = ExitX%: ViewZ% = ExitZ%: Yangle% = ExitAng%: MessText = ""
SaveStats
END IF
END SUB

SUB DOSpr (i%, dummy%)
x1% = 160 + (160& * Tri(i%).x1) \ Tri(i%).z1
y1% = TC% - (100& * Tri(i%).y1) \ Tri(i%).z1
y2% = TC% - (100& * Tri(i%).y2) \ Tri(i%).z1
d% = y1% - y2%
IF d% > 10 AND IsOnScreen%(x1%, y1%, x1%, y2%, x1% + d%, y1%) = 1 THEN
Ptx% = 63
IF Tri(i%).t < 9 THEN dummy% = VSMoveXMS(TexOFF2&, 0, TFF&(Tri(i%).t), TexSPH%, 16400): Ptx% = 127
IF Tri(i%).t = 9 THEN dummy% = VSMoveXMS(TexOFF2&, 0, T4100&(SPRa1F%), SprHAnim1%, 4100)
IF Tri(i%).t = 10 THEN dummy% = VSMoveXMS(TexOFF2&, 0, T4100&(SPRa2F%), SprHAnim2%, 4100)
IF Tri(i%).t = 11 THEN
dummy% = VSMoveXMS%(TexOFF2&, 0, 8000 + BalmAnim% * 1000, NumbH%, 1000)
DQBboxf 6, 128, 0, 192, 64, 0
DQBfPut 6, 128, 0, Tseg2%, Toff2%
DQBget 6, 128, 0, Ptx% + 128, Ptx%, Tseg2%, Toff2%
END IF
IF Tri(i%).t = 12 THEN dummy% = VSMoveXMS(TexOFF2&, 0, (Tri(i%).pz - 1) * 16400&, EnemyH%, 16400): Ptx% = 127

sd% = (4 - d% \ 30)
IF sd% > 0 THEN
	DQBfPut 6, 128, 0, Tseg2%, Toff2%
	DQBfilterBox 6, 128, 0, 256, 127, sd%, 1
	DQBget 6, 128, 0, Ptx% + 128, Ptx%, Tseg2%, Toff2%
END IF
DQBsPut 1, x1% - d% \ 2, y2%, Tseg2%, Toff2%, d%, d%
TCNumber% = -1
END IF
END SUB

SUB DoVisible
DQBclearLayer 11
px% = 154 - ViewX% \ 8: py% = 116 - ViewZ% \ 8: MinA% = Yangle% - 48: MaxA% = Yangle% + 48
FOR z% = MinA% TO MaxA%
	A% = z%: P% = 0
	IF A% < 0 OR A% > 359 THEN A% = A% - SGN(A%) * 360
	DO
	P% = P% + 1: x% = px% - (P% * Sine(A%)) \ 32: y% = py% - (P% * Cosine(A%)) \ 32
	LOOP UNTIL DQBpoint(12, x%, y%)
	DQBline 11, px%, py%, x%, y%, 50
NEXT z%
END SUB

SUB DoWallSliding (th%, Angle%, vel%, dummy%)
		pz% = 116 - (ViewZ% + (th% * Cosine%(Angle%) \ 256)) \ 8
		px% = 154 - (ViewX% + (th% * Sine%(Angle%) \ 256)) \ 8
		vz% = ViewZ% + (vel% * Cosine%(Angle%)) \ 256
		vx% = ViewX% + (vel% * Sine%(Angle%)) \ 256
		IF DQBpoint(4, px%, pz%) = 0 THEN ViewZ% = vz%: ViewX% = vx%: EXIT SUB
		IF DQBpoint(4, 154 - ViewX% \ 8, pz%) = 0 THEN ViewZ% = vz%: EXIT SUB
		IF DQBpoint(4, px%, 116 - ViewZ% \ 8) = 0 THEN ViewX% = vx%: EXIT SUB
END SUB

SUB DoWTmap (i%, M%)
IF Tri(i%).in = 3 OR Tri(i%).in = 0 THEN SWAP Tri(i%).x2, Tri(i%).x3: SWAP Tri(i%).z2, Tri(i%).z3: Flag% = 1
LE% = (ABS(Tri(i%).x1 + Tri(i%).x2 + Tri(i%).x3 + Tri(i%).x4) + ABS(Tri(i%).z1 + Tri(i%).z2 + Tri(i%).z3 + Tri(i%).z4)) \ 4

SELECT CASE LE%
	CASE 0 TO 64
	f% = 32: FF% = 31
	CASE 65 TO 312
	f% = 16: FF% = 15
	CASE 313 TO 405
	f% = 8: FF% = 7
	CASE 406 TO 512
	f% = 4: FF% = 3
	CASE ELSE
	f% = 2: FF% = 1
END SELECT

px1% = Tri(i%).x2 - Tri(i%).x1: PZ1% = Tri(i%).z2 - Tri(i%).z1: TPP1& = Tri(i%).y4 * 100&: TPP2& = TPP1& - 6400

FOR dx% = 0 TO f%
xp% = Tri(i%).x1 + K1% \ f%: ZP% = Tri(i%).z1 + K2% \ f%
IF ZP% <= 0 THEN ZP% = 1
txx%(dx%) = 160 + (xp% * 160&) \ ZP%
tyy1%(dx%) = TC% - TPP2& \ ZP% + 1: tyy2%(dx%) = TC% - TPP1& \ ZP% - 1: tyy3%(dx%) = 6400 \ ZP%
ptz%(0, dx%) = KT%(dx%) \ f%: ptz%(1, dx%) = 127 - ptz%(0, dx%)
K1% = K1% + px1%: K2% = K2% + PZ1%
NEXT dx%
	 
IF TWnumber% <> Tri(i%).t AND Tri(i%).t < 7 THEN dummy% = VSMoveXMS(TexOFF&, 0, TFF&(Tri(i%).t), TexWH%, 16400): TWnumber% = Tri(i%).t
IF Tri(i%).t > 6 THEN
	dummy% = VSMoveXMS(TexOFF2&, 0, TFF&(Tri(i%).t), TexWH%, 16400)
	DQBfPut 6, 0, 0, Tseg2%, Toff2%
	sh% = LE% \ 64: IF sh% > 4 THEN sh% = 4
	IF sh% > 0 THEN DQBfilterBox 6, 0, 0, 127, 127, sh%, 1
	TCNumber% = -1
END IF

IF Tri(i%).t > 6 AND Tri(i%).pz <> 0 THEN Flag% = 1 - Flag%
st% = 1: et% = f%: kdx% = -1: P% = 1
IF Flag% = 1 THEN st% = 0: et% = FF%: kdx% = 1: P% = 0

FOR dx% = st% TO et%
ddx% = dx% + kdx%: pxs% = ABS(txx%(dx%) - txx%(ddx%)): pys% = tyy1%(dx%) - tyy2%(dx%)
	IF pxs% > 0 AND IsOnScreen%(txx%(dx%), tyy2%(dx%), txx%(dx%), tyy1%(dx%), txx%(dx%) + pxs%, tyy1%(dx%)) = 1 THEN
		zdx% = txx%(dx%) + pxs%: zdy% = tyy2%(dx%) + pys%
		IF Tri(i%).t < 7 THEN
		DQBttri 1, txx%(dx%), tyy2%(dx%), txx%(dx%), zdy%, zdx%, zdy%, ptz%(P%, dx%), 0, ptz%(P%, dx%), 127, ptz%(P%, ddx%), 127, Tseg%, Toff%
		DQBttri 1, txx%(dx%), tyy2%(dx%), zdx%, zdy%, zdx%, tyy2%(dx%), ptz%(P%, dx%), 0, ptz%(P%, ddx%), 127, ptz%(P%, ddx%), 0, Tseg%, Toff%
					x1% = txx%(dx%): x2% = zdx%
					y1% = tyy2%(dx%): y2% = zdy%
					IF x1% < 0 THEN
					x1% = 0
					ELSEIF x1% > 319 THEN
					x1% = 319
					END IF
					IF y1% < 0 THEN
					y1% = 0
					ELSEIF y1% > 199 THEN
					y1% = 199
					END IF
					IF x2% < 0 THEN
					x2% = 0
					ELSEIF x2% > 319 THEN
					x2% = 319
					END IF
					IF y2% < 0 THEN
					y2% = 0
					ELSEIF y2% > 199 THEN
					y2% = 199
					END IF
		sh% = 4 - tyy3%(dx%) \ 20
		IF x2% > x1% AND y2% > y1% AND sh% > 0 THEN DQBfilterBox 1, x1%, y1%, x2%, y2%, sh%, 1
		ELSE
		DQBget 6, ptz%(P%, dx%), 0, ptz%(P%, ddx%), 127, Tseg2%, Toff2%
		DQBsPut 1, txx%(dx%), tyy2%(dx%), Tseg2%, Toff2%, pxs%, pys%
		END IF
	END IF
NEXT dx%
END SUB

SUB EnemyHandle
IF Enemy% = 0 THEN EXIT SUB
FOR i% = 1 TO NofEnemy%
dummy% = VSMoveXMS%(TriOFF&, 0, Enemies(i%).i, SpriH%, 32)
Anim% = Enemies(i%).A: LE% = ABS(Tri(0).x1 - ViewX%) + ABS(Tri(0).z1 - ViewZ%)

IF Enemies(i%).H > 0 THEN
	SELECT CASE Anim%
	CASE 1
		IF LE% > EnemyRange%(Enemy%) THEN
		Enemies(i%).A = 2
		ELSE
		Enemies(i%).A = EnemyWalk%(Enemy%) + 1
		END IF
	CASE 2 TO EnemyWalk%(Enemy%)
		Enemies(i%).A = Enemies(i%).A + 1
		IF Enemies(i%).A = EnemyWalk(Enemy%) + 1 THEN Enemies(i%).A = 1
		IF LE% < EnemyRange%(Enemy%) THEN Enemies(i%).A = EnemyWalk(Enemy%) + 1
	CASE EnemyWalk%(Enemy%) + 1 TO EnemyDie%(Enemy%) - 2
		Enemies(i%).A = Enemies(i%).A + 1
		IF Enemies(i%).A >= EnemySH%(Enemy%) AND Enemies(i%).A <= EnemyEH%(Enemy%) AND LE% < EnemyRange%(Enemy%) THEN
		Health% = Health% - EnemyDamage(Enemy%)
		IF Health% < 0 THEN Health% = 0
		END IF
		IF Enemies(i%).A = EnemyDie%(Enemy%) - 1 THEN Enemies(i%).A = 1
	CASE EnemyDie%(Enemy%) TO EnemyNumber%(Enemy%) - 1
		Enemies(i%).A = Enemies(i%).A + 1
		IF Enemies(i%).A = EnemyNumber%(Enemy%) THEN Enemies(i%).H = 0
	CASE EnemyGHit%(Enemy%)
		Enemies(i%).A = 1
	END SELECT
		
		IF Enemies(i%).A > 1 AND Enemies(i%).A < EnemyWalk(Enemy%) + 1 THEN
		x% = SGN(ViewX% - Tri(0).x1): z% = SGN(ViewZ% - Tri(0).z1)
		IF (CurWeap% > 0 AND WeapAnim% > WeapCarry%(CurWeap%) + 3 AND LE% < 100) OR Enemies(i%).H < 20 THEN
		x% = -x%: z% = -z%
		ELSE
		IF ABS(ViewX% - Tri(0).x1) <= EnemySpeed%(Enemy%) THEN x% = 0
		IF ABS(ViewZ% - Tri(0).z1) <= EnemySpeed%(Enemy%) THEN z% = 0
		END IF
		IF DQBpoint(4, 154 - (Tri(0).x1 + x% * (EnemySpeed%(Enemy%) + 4)) \ 8, 116 - Tri(0).z1 \ 8) = 0 THEN
		Tri(0).x1 = Tri(0).x1 + x% * EnemySpeed%(Enemy%): Tri(0).x2 = Tri(0).x1: Tri(0).x3 = Tri(0).x1: Tri(0).x4 = Tri(0).x1
		ELSE
		x% = 0
		END IF
		IF DQBpoint(4, 154 - Tri(0).x1 \ 8, 116 - (Tri(0).z1 + z% * (EnemySpeed%(Enemy%) + 4)) \ 8) = 0 THEN
		Tri(0).z1 = Tri(0).z1 + z% * EnemySpeed%(Enemy%): Tri(0).z2 = Tri(0).z1: Tri(0).z3 = Tri(0).z1: Tri(0).z4 = Tri(0).z1
		ELSE
		z% = 0
		END IF
		IF x% = 0 AND z% = 0 THEN Enemies(i%).A = 1
		END IF

		IF Enemies(i%).A < EnemyNumber%(Enemy%) THEN
			x% = 154 - Tri(0).x1 \ 8: y% = 116 - Tri(0).z1 \ 8
			DQBboxf 4, x% - 2, y% - 2, x% + 2, y% + 2, 1
		END IF
	   
		IF CurWeap% > 0 AND (WeapAnim% = WeapHit1%(CurWeap%) OR WeapAnim% = WeapHit2%(CurWeap%)) AND LE% < 50 AND Enemies(i%).A < EnemyDie%(Enemy%) THEN
		p1% = Tri(0).x1: p2% = 0: p3% = Tri(0).z1: RotateY p1%, p2%, p3%, 0
			IF p3% > 0 THEN
			p1% = 160 + (p1% * 160&) \ p3%
				IF ABS(160 - p1%) < 80 THEN
				Enemies(i%).H = Enemies(i%).H - WeapDamage%(CurWeap%)
					dummy% = VSMoveXMS%(TexOFF&, 0, 11000, NumbH%, 1000)
					DQBsPut 1, p1% + 20, 40, Tseg%, Toff%, 90, 90
					dummy% = VSMoveXMS%(TexOFF&, 0, 12000, NumbH%, 1000)
					DQBsPut 1, p1% + 30, 60, Tseg%, Toff%, 100, 100
					dummy% = VSMoveXMS%(TexOFF&, 0, 13000, NumbH%, 1000)
					DQBsPut 1, p1% - 10, 80, Tseg%, Toff%, 120, 120
				END IF
				IF Enemies(i%).H <= 0 THEN
				Enemies(i%).H = 1: Enemies(i%).A = EnemyDie%(Enemy%)
				ELSE
				Enemies(i%).A = EnemyGHit%(Enemy%)
				END IF
			END IF
		END IF

Tri(0).pz = Enemies(i%).A
dummy% = VSMoveXMS%(Enemies(i%).i, SpriH%, TriOFF&, 0, 32)
END IF
NEXT i%
END SUB

SUB finished (n%)
IF n% = 0 THEN
DQBcopyLayer 0, 2
DEF SEG = DQBmapLayer(1)
	FOR i% = 0 TO 3
	BLOAD "DATA\LOADS\QUIT\quit" + LTRIM$(STR$(i%)) + ".dat", 0
	DQBcopyLayer 2, 0: DQBcopyTransLayer 1, 0
	DQBwait 10
	NEXT i%
DQBcopyLayer 0, 1
DEF SEG = Tseg%: BLOAD "DATA\LOADS\QUIT\quit4.dat", Toff%
	FOR i% = 10 TO 120
	DQBcopyLayer 1, 2
	DQBsPut 2, 160 - i% \ 2, 100 - i% \ 2, Tseg%, Toff%, i%, i%
	DQBcopyLayer 2, 0
	DQBwait 1
	NEXT i%
DEF SEG
END IF
	IF n% = 0 THEN DEF SEG = &HA000: BLOAD "DATA\LOADS\PAL\atte3.dat", 0: DO: LOOP UNTIL DQBinkey$ > "": DQBclose
	IF n% = 1 THEN DQBclose: CLS : LOCATE 10, 1: PRINT DQBerror$
	IF n% = 2 THEN DQBclose: CLS : LOCATE 10, 1: PRINT "Not enough XMS memory"
dummy& = SETMEM(2048)
dummy% = VSDeallocateXMS%(FloorH%)
dummy% = VSDeallocateXMS%(WallH%)
dummy% = VSDeallocateXMS%(TexFH%)
dummy% = VSDeallocateXMS%(TexWH%)
dummy% = VSDeallocateXMS%(TexC1H%)
dummy% = VSDeallocateXMS%(TexC2H%)
dummy% = VSDeallocateXMS%(CeilH%)
dummy% = VSDeallocateXMS%(DoorH%)
dummy% = VSDeallocateXMS%(FaceH%)
dummy% = VSDeallocateXMS%(SpriH%)
dummy% = VSDeallocateXMS%(TexSPH%)
dummy% = VSDeallocateXMS%(SprHAnim1%)
dummy% = VSDeallocateXMS%(SprHAnim2%)
dummy% = VSDeallocateXMS%(IndH%)
dummy% = VSDeallocateXMS%(NumbH%)
dummy% = VSDeallocateXMS%(EnemyH%)
END
END SUB

SUB GetInput
STATIC rotvel%, horizvel%, turnvel%, strvel%, Shift%
IF LevCH% THEN LevCH% = 0: rotvel% = 0: horizvel% = 0: turnvel% = 0: strvel% = 0:
	 
	  Shift% = DQBkey(&H36) - 1
	  IF DQBkey(75) = -1 AND DQBkey(&H38) = 0 THEN turnvel% = -6 * Shift%
	  IF DQBkey(77) = -1 AND DQBkey(&H38) = 0 THEN turnvel% = 6 * Shift%
	  IF DQBkey(72) THEN horizvel% = -8 * Shift%
	  IF DQBkey(80) THEN horizvel% = 8 * Shift%
	  IF DQBkey(52) = -1 OR (DQBkey(77) = -1 AND DQBkey(&H38) = -1) THEN strvel% = -8 * Shift%
	  IF DQBkey(51) = -1 OR (DQBkey(75) = -1 AND DQBkey(&H38) = -1) THEN strvel% = 8 * Shift%
	  IF DQBkey(&H35) THEN rotvel% = 18
	  OpenDoor
	 
	  IF turnvel% THEN Yangle% = (360 + Yangle% - turnvel%) MOD 360: k% = -SGN(turnvel%): MakeBackgr ABS(turnvel% + turnvel% \ 2), k%: turnvel% = turnvel% + k% + k% + k%
	  IF horizvel% THEN DoWallSliding 16 * SGN(horizvel%), Yangle%, horizvel%, 0: horizvel% = horizvel% - SGN(horizvel%)
	  IF strvel% THEN DoWallSliding 16 * SGN(strvel%), (Yangle% + 90) MOD 360, strvel%, 0: strvel% = strvel% - SGN(strvel%)
	  IF rotvel% THEN Yangle% = (Yangle% + 10) MOD 360: rotvel% = rotvel% - 1: MakeBackgr 20, 1
	  IF horizvel% OR strvel% THEN swing% = (swing% - 45 * Shift%) MOD 360

	  IF DQBkey(&H2) = -1 AND CurWeap% <> 1 THEN CurWeap% = 1: WeapAnim% = 0: MessTime% = LoadIt%: MessText = "Dagger selected"
	  IF DQBkey(&H3) = -1 AND CurWeap% <> 2 THEN CurWeap% = 2: WeapAnim% = 0: MessTime% = LoadIt%: MessText = "Short sword selected"
	  IF DQBkey(&H4) = -1 AND CurWeap% <> 3 THEN CurWeap% = 3: WeapAnim% = 0: MessTime% = LoadIt%: MessText = "Battle axe selected"
	  IF DQBkey(&H5) = -1 AND CurWeap% <> 4 THEN CurWeap% = 4: WeapAnim% = 0: MessTime% = LoadIt%: MessText = "Heavy sword selected"
	  IF DQBkey(&H1D) = -1 AND CurWeap% > 0 AND WeapAnim% = WeapCarry%(CurWeap%) THEN WeapAnim% = WeapCarry%(CurWeap%) + 1
	  IF DQBkey(&H1D) = -1 AND CurWeap% = 0 THEN MessTime% = LoadIt%: MessText = "Weapon is not in use"
	  IF DQBkey(&H23) = -1 AND CurWeap% > 0 AND WeapAnim% = WeapCarry(CurWeap%) THEN CurWeap% = 0: WeapAnim% = 0: MessTime% = LoadIt%: MessText = "Hide the weapon"
	  IF DQBkey(&H1C) THEN
		IF BalmN% = 0 THEN MessTime% = LoadIt%: MessText = "You are out of elixirs"
		IF BalmN% > 0 THEN BalmN% = BalmN% - 1: Health% = Health% + 25: MessTime% = LoadIt%: MessText = "Elixir has been used"
	  END IF
	 
	  IF DQBkey(&H21) THEN
	  FPSShow% = 1 - FPSShow%: MessTime% = LoadIt%
	  IF FPSShow% = 1 THEN
	  MessText = "FPS counter enabled"
	  ELSE
	  MessText = "FPS counter disabled"
	  END IF
	  END IF
	 
	  IF DQBkey(&H30) THEN
	  BarShow% = 1 - BarShow%: MessTime% = LoadIt%
	  IF BarShow% = 1 THEN
	  MessText = "Show the status bar"
	  ELSE
	  MessText = "Hide the status bar"
	  END IF
	  END IF
	 
	  IF Shift% = -2 THEN NFace% = 6: EXIT SUB
	  IF turnvel% > 0 THEN NFace% = 7: EXIT SUB
	  IF turnvel% < 0 THEN NFace% = 5: EXIT SUB
	  IF horizvel% AND NFace% < 4 THEN NFace% = 1 + NFace%: EXIT SUB
	  IF horizvel% AND NFace% = 4 THEN EXIT SUB
	  NFace% = 0
END SUB

FUNCTION IsOnScreen% (x1%, y1%, x2%, y2%, x3%, y3%)
IF x1% < 0 AND x2% < 0 AND x3% < 0 THEN EXIT FUNCTION
IF x1% > 319 AND x2% > 319 AND x3% > 319 THEN EXIT FUNCTION
IF y1% < 0 AND y2% < 0 AND y3% < 0 THEN EXIT FUNCTION
IF y1% > 199 AND y2% > 199 AND y3% > 199 THEN EXIT FUNCTION
IsOnScreen% = 1
END FUNCTION

SUB LoadData (LN%)
DIM n%(4), H%(4), b%(4), P$(4)
DIM FileN AS STRING * 16

path$ = "DATA\LEVELS\LEVEL" + LTRIM$(STR$(LN%)) + "\": NofEnemy% = 0
P$(0) = "FLOOR\": P$(1) = "WALL\": P$(2) = "CEILING\": P$(3) = "DOOR\": P$(4) = "SPRITE\"

DEF SEG = VARSEG(NofFloors%): BLOAD path$ + P$(0) + "nf.dat", VARPTR(NofFloors%)
DEF SEG = VARSEG(NofWalls%): BLOAD path$ + P$(1) + "nw.dat", VARPTR(NofWalls%)
DEF SEG = VARSEG(NofCeilings%): BLOAD path$ + P$(2) + "nc.dat", VARPTR(NofCeilings%)
DEF SEG = VARSEG(NofDoors%): BLOAD path$ + P$(3) + "nd.dat", VARPTR(NofDoors%)
DEF SEG = VARSEG(NofSprites%): BLOAD path$ + P$(4) + "ns.dat", VARPTR(NofSprites%)

n%(0) = NofFloors%: n%(1) = NofWalls%: n%(2) = NofCeilings%: n%(3) = NofDoors%: n%(4) = NofSprites%
H%(0) = FloorH%: H%(1) = WallH%: H%(2) = CeilH%: H%(3) = DoorH%: H%(4) = SpriH%

FOR t% = 0 TO 4: FOR i% = 0 TO n%(t%)
DEF SEG = VARSEG(Tri(i%).x1): BLOAD path$ + P$(t%) + LTRIM$(STR$(i%)) + ".dat", VARPTR(Tri(i%).x1)
IF t% = 0 THEN index(i%).depth = 154 - Tri(i%).x1 \ 8: index(i%).ind = 116 - Tri(i%).z1 \ 8
IF t% = 4 AND Tri(i%).t = 12 THEN NofEnemy% = NofEnemy% + 1: Enemies(NofEnemy%).i = i% * 32: Enemies(NofEnemy%).A = 1
NEXT i%
b%(t%) = 32 * (n%(t%) + 1)
dummy% = VSMoveXMS(0, H%(t%), TriOFF&, 0, b%(t%))
NEXT t%
dummy% = VSMoveXMS(0, IndH%, IndOFF&, 0, 1600)

FloorBytes% = b%(0): WallBytes% = b%(1): CeilBytes% = b%(2): DoorBytes% = b%(3): SpriteBytes% = b%(4)
StartC% = NofWalls% + 1: EndC% = StartC% + NofCeilings%: TriCOFF& = VARSEG(Tri(StartC%)) * 65536 + VARPTR(Tri(StartC%))
StartD% = EndC% + 1: EndD% = StartD% + NofDoors%: TriDOFF& = VARSEG(Tri(StartD%)) * 65536 + VARPTR(Tri(StartD%))
StartS% = EndD% + 1: EndS% = StartS% + NofSprites%: TriSOFF& = VARSEG(Tri(StartS%)) * 65536 + VARPTR(Tri(StartS%))

DEF SEG = DQBmapLayer(4): BLOAD path$ + "MAP\map1.dat", 0: DQBcopyLayer 4, 15
DEF SEG = DQBmapLayer(5): BLOAD path$ + "MAP\map2.dat", 0
DEF SEG = DQBmapLayer(12): BLOAD path$ + "MAP\map3.dat", 0

path$ = path$ + "GFX\": P$ = "DATA\LOADS\TEXTURES\"

DEF SEG = VARSEG(Back%): BLOAD path$ + "Back.dat", VARPTR(Back%)
DEF SEG = VARSEG(BackScroll%): BLOAD path$ + "BackScr.dat", VARPTR(BackScroll%)
DEF SEG = VARSEG(ChangeF%(0)): BLOAD path$ + "ChangeF.dat", VARPTR(ChangeF%(0))
DEF SEG = VARSEG(ChangeW%(0)): BLOAD path$ + "ChangeW.dat", VARPTR(ChangeW%(0))
DEF SEG = VARSEG(ChangeC%(0)): BLOAD path$ + "ChangeC.dat", VARPTR(ChangeC%(0))
DEF SEG = VARSEG(ScrollF%): BLOAD path$ + "ScrollF.dat", VARPTR(ScrollF%)
DEF SEG = VARSEG(ScrollW%): BLOAD path$ + "ScrollW.dat", VARPTR(ScrollW%)
DEF SEG = VARSEG(ScrollC%): BLOAD path$ + "ScrollC.dat", VARPTR(ScrollC%)
DEF SEG = VARSEG(Ftex%): BLOAD path$ + "Ftex.dat", VARPTR(Ftex%)
DEF SEG = VARSEG(Wtex%): BLOAD path$ + "Wtex.dat", VARPTR(Wtex%)
DEF SEG = VARSEG(C1tex%): BLOAD path$ + "C1tex.dat", VARPTR(C1tex%)
DEF SEG = VARSEG(C2tex%): BLOAD path$ + "C2tex.dat", VARPTR(C2tex%)
DEF SEG = VARSEG(Spr%): BLOAD path$ + "Spr.dat", VARPTR(Spr%)
DEF SEG = VARSEG(SPRa1%): BLOAD path$ + "SprA1.dat", VARPTR(SPRa1%)
DEF SEG = VARSEG(SPRa2%): BLOAD path$ + "SprA2.dat", VARPTR(SPRa2%)
DEF SEG = VARSEG(ViewX%): BLOAD path$ + "ViewX.dat", VARPTR(ViewX%): EnterX% = ViewX%
DEF SEG = VARSEG(ViewZ%): BLOAD path$ + "ViewZ.dat", VARPTR(ViewZ%): EnterZ% = ViewZ%
DEF SEG = VARSEG(Yangle%): BLOAD path$ + "Yangle.dat", VARPTR(Yangle%)
DEF SEG = VARSEG(ExitX%): BLOAD path$ + "ExitX.dat", VARPTR(ExitX%)
DEF SEG = VARSEG(ExitZ%): BLOAD path$ + "ExitZ.dat", VARPTR(ExitZ%)
DEF SEG = VARSEG(ExitAng%): BLOAD path$ + "ExitAng.dat", VARPTR(ExitAng%)
DEF SEG = VARSEG(Enemy%): BLOAD path$ + "Enemy.dat", VARPTR(Enemy%)
	IF Enemy% THEN
		FOR i% = 1 TO EnemyNumber%(Enemy%)
		DEF SEG = Tseg%: BLOAD "DATA\LOADS\ENEMY\e" + LTRIM$(STR$(Enemy%)) + "_" + LTRIM$(STR$(i%)) + ".dat", Toff%
		dummy% = VSMoveXMS%((i% - 1) * 16400&, EnemyH%, TexOFF&, 0, 16400)
		NEXT i%
		FOR i% = 1 TO NofEnemy%: Enemies(i%).H = EnemyHealth%(Enemy%): NEXT i%
	END IF

n%(0) = Ftex%: n%(1) = C1tex%: n%(2) = C2tex%: n%(3) = Wtex%: n%(4) = Spr%
P$(0) = "Ftex": P$(1) = "C1tex": P$(2) = "C2tex": P$(3) = "Wtex": P$(4) = "Spr"
H%(0) = TexFH%: H%(1) = TexC1H%: H%(2) = TexC2H%: H%(3) = TexWH%: H%(4) = TexSPH%

FOR i% = 0 TO 12: FOR j% = 0 TO 4
		IF i% <= n%(j%) THEN
			DEF SEG = VARSEG(FileN): BLOAD path$ + P$(j%) + LTRIM$(STR$(i%)) + ".dat", VARPTR(FileN)
			k$ = P$ + FileN
			IF j% = 4 THEN k$ = "DATA\LOADS\SPR\" + FileN
			DEF SEG = Tseg%: BLOAD k$, Toff%
			dummy% = VSMoveXMS(TFF&(i%), H%(j%), TexOFF&, 0, 16400)
		END IF
NEXT j%, i%

n%(1) = -1: n%(2) = -1
IF SPRa1% > -1 THEN n%(1) = SPRa1%: H%(1) = SprHAnim1%: P$(1) = "SprA1F": SPRa1F% = 0
IF SPRa2% > -1 THEN n%(2) = SPRa2%: H%(2) = SprHAnim2%: P$(2) = "SprA2F": SPRa2F% = 0
FOR j% = 1 TO 2
	IF n%(j%) > -1 THEN
		DEF SEG = VARSEG(FileN): BLOAD path$ + P$(j%) + ".dat", VARPTR(FileN)
		f$ = "\" + LTRIM$(RTRIM$(FileN))
		FOR i% = 1 TO n%(j%)
		DEF SEG = Tseg%: BLOAD "DATA\LOADS\SPR" + f$ + f$ + "_" + LTRIM$(STR$(i%)) + ".dat", Toff%
		dummy% = VSMoveXMS(T4100&(i% - 1), H%(j%), TexOFF&, 0, 4100)
		NEXT i%
	END IF
NEXT j%

IF Back% THEN
DEF SEG = DQBmapLayer(7): BLOAD "DATA\LOADS\BACKGR\ba" + LTRIM$(STR$(Back%)) + "_1.dat", 0
DEF SEG = DQBmapLayer(8): BLOAD "DATA\LOADS\BACKGR\ba" + LTRIM$(STR$(Back%)) + "_2.dat", 0
MakeBackgr 1, 1: DQBcopyLayer 9, 1
END IF
END SUB

SUB LoadED
L$ = LTRIM$(STR$(LevelN%)): P$ = "DATA\TEMP\": DEF SEG = VARSEG(Tri(0))
BLOAD P$ + "door" + L$ + ".dat", VARPTR(Tri(0))
dummy% = VSMoveXMS(0, DoorH%, TriOFF&, 0, DoorBytes%)
BLOAD P$ + "sprite" + L$ + ".dat", VARPTR(Tri(0))
dummy% = VSMoveXMS(0, SpriH%, TriOFF&, 0, SpriteBytes%)
DEF SEG = VARSEG(Enemies(1)): BLOAD P$ + "enemy" + L$ + ".dat", VARPTR(Enemies(1))
DEF SEG = DQBmapLayer(15): BLOAD P$ + "map" + L$ + ".dat": DQBcopyLayer 15, 4
END SUB

SUB LoadStats
DIM Player%(10)
DEF SEG = VARSEG(Player%(0))
BLOAD "DATA\TEMP\Player" + LTRIM$(STR$(LevelN%)) + ".dat", VARPTR(Player%(0))
Health% = Player%(0)
BalmN% = Player%(1)
CurWeap% = Player%(2)
WeapAnim% = Player%(3)
ViewX% = Player%(4)
ViewZ% = Player%(5)
Yangle% = Player%(6)
END SUB

SUB MakeBackgr (Times%, Direction%)
STATIC br%, First%, ax%, bx%
IF First% = 0 THEN : ax% = 7: bx% = 8: First% = 1
IF Times% * Back% = 0 THEN EXIT SUB
FOR i% = 1 TO Times%
br% = br% + Direction%
IF br% = -1 THEN SWAP ax%, bx%: br% = 319
IF br% = 320 THEN SWAP ax%, bx%: br% = 0
NEXT i%
		DQBxPut ax%, br%, 0, 319, 49, 9, 0, 0
		DQBxPut bx%, 0, 0, br%, 49, 9, 319 - br%, 0
		DQBxPut ax%, br%, 50, 319, 99, 9, 0, 50
		DQBxPut bx%, 0, 50, br%, 99, 9, 319 - br%, 50
END SUB

SUB MakeFloor
dummy% = VSMoveXMS(TriOFF&, 0, 0, FloorH%, FloorBytes%)
dummy% = VSMoveXMS(IndOFF&, 0, 0, IndH%, 1600)

TC% = Sine%(swing%) \ 92 + 100: TfNumber% = -1: TCNumber% = -1
RotateY Tri(0).x1, Tri(0).y1, Tri(0).z1, 0
RotateY Tri(0).x2, Tri(0).y2, Tri(0).z2, 0
RotateY Tri(0).x3, Tri(0).y3, Tri(0).z3, 0
RotateY Tri(0).x4, Tri(0).y4, Tri(0).z4, 0
RotateY Tri(0).px, Tri(0).in, Tri(0).pz, 0

px1% = Tri(0).x2 - Tri(0).x1: PZ1% = Tri(0).z2 - Tri(0).z1
px2% = Tri(0).x3 - Tri(0).x1: PZ2% = Tri(0).z3 - Tri(0).z1
FOR i% = 1 TO 8: ii% = i% - 1
PZX1%(i%) = PZX1%(ii%) + px1%: PZX2%(i%) = PZX2%(ii%) + px2%
PZZ1%(i%) = PZZ1%(ii%) + PZ1%: PZZ2%(i%) = PZZ2%(ii%) + PZ2%
NEXT i%
FOR i% = 0 TO 8: FOR j% = 0 TO 8: PXadd%(i%, j%) = PZX1%(i%) + PZX2%(j%): PZadd%(i%, j%) = PZZ1%(i%) + PZZ2%(j%): NEXT j%, i%

IF ClipIt%(0) = 0 THEN DoFCTmap 0, 1
xx1% = Tri(0).x1 - Tri(0).px: xx2% = Tri(0).x2 - Tri(0).px: xx3% = Tri(0).x3 - Tri(0).px: xx4% = Tri(0).x4 - Tri(0).px
zz1% = Tri(0).z1 - Tri(0).pz: zz2% = Tri(0).z2 - Tri(0).pz: zz3% = Tri(0).z3 - Tri(0).pz: zz4% = Tri(0).z4 - Tri(0).pz

FOR i% = 1 TO NofFloors%
px1% = index(i%).depth: py1% = index(i%).ind: ignore% = 0: px18% = px1% - 8: py18% = py1% - 8
IF DQBpoint(11, px1%, py1%) < 50 THEN
	IF DQBpoint(11, px18%, py1%) < 50 THEN
		IF DQBpoint(11, px18%, py18%) < 50 THEN
			IF DQBpoint(11, px1%, py18%) < 50 THEN
			   IF DQBpoint(11, px1% - 4, py1% - 4) < 50 THEN ignore% = 1
			END IF
		END IF
	END IF
END IF

IF ignore% = 0 THEN
RotateY Tri(i%).px, Tri(i%).in, Tri(i%).pz, 0
TransAll i%, Tri(i%).px, Tri(i%).pz, 0
IF ClipIt%(i%) = 0 THEN DoFCTmap i%, 1
END IF
NEXT i%
END SUB

REM $DYNAMIC
SUB MakeWall
TWnumber% = -1: TCNumber% = -1

IF WallBytes% THEN
dummy% = VSMoveXMS(TriOFF&, 0, 0, WallH%, WallBytes%)
FOR i% = 0 TO NofWalls%
ignore% = 0
IF LevelN% = 2 THEN
	px1% = 154 - Tri(i%).x1 \ 8: py1% = 116 - Tri(i%).z1 \ 8
	IF Tri(i%).in = 0 OR Tri(i%).in = 3 THEN
	px2% = 154 - Tri(i%).x3 \ 8: py2% = 116 - Tri(i%).z3 \ 8
	ELSE
	px2% = 154 - Tri(i%).x2 \ 8: py2% = 116 - Tri(i%).z2 \ 8
	END IF
	px5% = (px1% + px2%) \ 2: py5% = (py1% + py2%) \ 2
	IF DQBpoint(11, px1%, py1%) < 50 THEN
		IF DQBpoint(11, px2%, py2%) < 50 THEN
			   IF DQBpoint(11, px5%, py5%) < 50 THEN ignore% = 1
		END IF
	END IF
END IF
IF ignore% = 0 THEN
RotateY Tri(i%).x1, Tri(i%).y1, Tri(i%).z1, 0
RotateY Tri(i%).x2, Tri(i%).y2, Tri(i%).z2, 0
RotateY Tri(i%).x3, Tri(i%).y3, Tri(i%).z3, 0
RotateY Tri(i%).x4, Tri(i%).y4, Tri(i%).z4, 0
IF ClipIt%(i%) = 1 THEN ignore% = 1
END IF
IF ignore% = 0 THEN
z1% = Tri(i%).z1: z2% = Tri(i%).z2: z3% = Tri(i%).z3: z4% = Tri(i%).z4
		 IF z1% <= 0 THEN z1% = 1
		 IF z2% <= 0 THEN z2% = 1
		 IF z3% <= 0 THEN z3% = 1
		 IF z3% <= 0 THEN z4% = 1
		x1% = (Tri(i%).x1 * 160&) \ z1%: y1% = (Tri(i%).y1 * 100&) \ z1%
		x2% = (Tri(i%).x2 * 160&) \ z2%: y2% = (Tri(i%).y2 * 100&) \ z2%
		x3% = (Tri(i%).x3 * 160&) \ z3%: y3% = (Tri(i%).y3 * 100&) \ z3%
		ign% = CLNG(x1% - x2%) * (y3% - y1%) < CLNG(y2% - y1%) * (x1% - x3%)
		IF Tri(i%).t < 7 OR Tri(i%).t > 9 THEN
		ignore% = ign%
		ELSE
		Tri(i%).pz = ign%
		END IF
END IF

IF ignore% = 0 THEN
		index(NofDraw%).ind = i%
		index(NofDraw%).depth = (z1% + z2% + z3% + z4%)
		NofDraw% = NofDraw% + 1
END IF
NEXT i%
END IF

IF CeilBytes% THEN
dummy% = VSMoveXMS(TriCOFF&, 0, 0, CeilH%, CeilBytes%)
FOR i% = StartC% TO EndC%
RotateY Tri(i%).y3, ky%, Tri(i%).y4, 0
TransAll i%, Tri(i%).y3, Tri(i%).y4, 0
IF ClipIt%(i%) = 0 THEN
		index(NofDraw%).ind = i%
		index(NofDraw%).depth = (Tri(i%).z1 + Tri(i%).z2 + Tri(i%).z3 + Tri(i%).z4)
		NofDraw% = NofDraw% + 1
END IF
NEXT i%
END IF

IF DoorBytes% THEN
dummy% = VSMoveXMS(TriDOFF&, 0, 0, DoorH%, DoorBytes%)
FOR i% = StartD% TO EndD%
RotateY Tri(i%).x1, Tri(i%).y1, Tri(i%).z1, 0
RotateY Tri(i%).x2, Tri(i%).y2, Tri(i%).z2, 0
RotateY Tri(i%).x3, Tri(i%).y3, Tri(i%).z3, 0
RotateY Tri(i%).x4, Tri(i%).y4, Tri(i%).z4, 0
ignore% = ClipIt%(i%)
IF Tri(i%).pz = 9 THEN ignore% = 1
IF ignore% = 0 THEN
		index(NofDraw%).ind = i%
		z1% = Tri(i%).z1: z2% = Tri(i%).z2: z3% = Tri(i%).z3: z4% = Tri(i%).z4
		IF z1% <= 0 THEN z1% = 1
		IF z2% <= 0 THEN z2% = 1
		IF z3% <= 0 THEN z3% = 1
		IF z3% <= 0 THEN z4% = 1
		index(NofDraw%).depth = (z1% + z2% + z3% + z4%)
		NofDraw% = NofDraw% + 1
END IF
NEXT i%
END IF

IF SpriteBytes% THEN
dummy% = VSMoveXMS(TriSOFF&, 0, 0, SpriH%, SpriteBytes%)
FOR i% = StartS% TO EndS%
	IF Tri(i%).t = 11 THEN
		IF Tri(i%).pz = 1 THEN
		LE% = ABS(Tri(i%).x1 - ViewX%) + ABS(Tri(i%).z1 - ViewZ%)
		IF LE% < 46 THEN
		Tri(i%).pz = 0: BalmN% = BalmN% + 1
		OFFI& = VARSEG(Tri(i%)) * 65536 + VARPTR(Tri(i%))
		dummy% = VSMoveXMS%((i% - StartS%) * 32, SpriH%, OFFI&, 0, 32)
		MessTime% = LoadIt%: MessText = "Get an elixir"
		END IF
		Tri(i%).y1 = Tri(i%).y1 + Sine(BalmSwing%) \ 32
		Tri(i%).y2 = Tri(i%).y2 + Sine(BalmSwing%) \ 32
		END IF
	END IF
RotateY Tri(i%).x1, Tri(i%).y1, Tri(i%).z1, 0
TransAll i%, Tri(i%).x1, Tri(i%).z1, 0
IF ClipIt%(i%) = 0 THEN
		index(NofDraw%).ind = i%
		IF Tri(i%).z1 <= 0 THEN Tri(i%).z1 = 1
		index(NofDraw%).depth = 4 * Tri(i%).z1
		NofDraw% = NofDraw% + 1
END IF
NEXT i%
END IF

DQBsort VARSEG(index(0)), VARPTR(index(0)), NofDraw%, 4, 0
NofDraw% = NofDraw% - 1

FOR j% = 0 TO NofDraw%
in% = index(NofDraw% - j%).ind
IF Tri(in%).px = 1 THEN
DoFCTmap in%, 2
ELSEIF Tri(in%).px = 0 THEN
DoWTmap in%, 1
ELSEIF Tri(in%).px = 2 THEN
IF Tri(in%).pz THEN DOSpr in%, 0
END IF
NEXT j%
END SUB

REM $STATIC
SUB OpenDoor
dummy% = VSMoveXMS(TriOFF&, 0, 0, DoorH%, DoorBytes%)
FOR i% = 0 TO NofDoors%
px% = (Tri(i%).x1 + Tri(i%).x2 + Tri(i%).x3 + Tri(i%).x4) \ 4
pz% = (Tri(i%).z1 + Tri(i%).z2 + Tri(i%).z3 + Tri(i%).z4) \ 4
IF ABS(ViewX% - px%) + ABS(ViewZ% - pz%) < 64 AND DQBkey(&H39) = -1 AND Tri(i%).pz = 0 THEN Tri(i%).pz = 1
	IF Tri(i%).pz > 0 AND Tri(i%).pz < 9 THEN
		Tri(i%).y1 = Tri(i%).y1 + 8: Tri(i%).y2 = Tri(i%).y2 + 8
		Tri(i%).y3 = Tri(i%).y3 + 8: Tri(i%).y4 = Tri(i%).y4 + 8
		Tri(i%).pz = Tri(i%).pz + 1
			IF Tri(i%).pz = 9 THEN
			kx% = 146 - px% \ 8: kz% = 108 - pz% \ 8
			DQBget 5, kx%, kz%, kx% + 16, kz% + 16, Tseg%, Toff%
			DQBfPut 15, kx%, kz%, Tseg%, Toff%
			END IF
	END IF
NEXT i%
dummy% = VSMoveXMS(0, DoorH%, TriOFF&, 0, DoorBytes%)
END SUB

SUB RotateY (p1%, p2%, p3%, dummy%)
p1% = p1% - ViewX%: p3% = p3% - ViewZ%
TempX% = (CLNG(p1%) * Cosine%(Yangle%) - CLNG(p3%) * Sine%(Yangle%)) \ 256
p3% = (CLNG(p1%) * Sine%(Yangle%) + CLNG(p3%) * Cosine%(Yangle%)) \ 256: p1% = TempX%
END SUB

SUB SaveED
L$ = LTRIM$(STR$(LevelN%)): P$ = "DATA\TEMP\": DEF SEG = VARSEG(Tri(0))
dummy% = VSMoveXMS(TriOFF&, 0, 0, DoorH%, DoorBytes%)
BSAVE P$ + "door" + L$ + ".dat", VARPTR(Tri(0)), DoorBytes%
dummy% = VSMoveXMS(TriOFF&, 0, 0, SpriH%, SpriteBytes%)
BSAVE P$ + "sprite" + L$ + ".dat", VARPTR(Tri(0)), SpriteBytes%
DEF SEG = VARSEG(Enemies(1)): BSAVE P$ + "enemy" + L$ + ".dat", VARPTR(Enemies(1)), 180
DEF SEG = DQBmapLayer(15): BSAVE P$ + "map" + L$ + ".dat", 0, 64000
END SUB

SUB SaveStats
DIM Player%(10)
Player%(0) = Health%
Player%(1) = BalmN%
Player%(2) = CurWeap%
Player%(3) = WeapAnim%
Player%(4) = ViewX%
Player%(5) = ViewZ%
Player%(6) = Yangle%
DEF SEG = VARSEG(Player%(0))
BSAVE "DATA\TEMP\Player" + LTRIM$(STR$(LevelN%)) + ".dat", VARPTR(Player%(0)), 16
END SUB

SUB ScrollTex (ScrollN%, Handle%)
dummy% = VSMoveXMS%(TexOFF&, 0, TFF&(ScrollN%), Handle%, 16400)
DQBfPut 10, 0, 0, Tseg%, Toff%
DQBfPut 10, 128, 0, Tseg%, Toff%
DQBget 10, 2, 0, 129, 127, Tseg%, Toff%
dummy% = VSMoveXMS(TFF&(ScrollN%), Handle%, TexOFF&, 0, 16400)
END SUB

SUB SetUpAll
DIM k(768) AS STRING * 1
DIM bl1(255) AS STRING * 1, bl2(255) AS STRING * 1, bl3(255) AS STRING * 1, bl4(255) AS STRING * 1

P$ = "DATA\LOADS\": p2$ = P$ + "ARRAYS\"
DEF SEG = VARSEG(k(0)): BLOAD P$ + "PAL\palette.dat", VARPTR(k(0))
DEF SEG = VARSEG(bl1(0)): BLOAD P$ + "PAL\blend1.dat", VARPTR(bl1(0))
DEF SEG = VARSEG(bl2(0)): BLOAD P$ + "PAL\blend2.dat", VARPTR(bl2(0))
DEF SEG = VARSEG(bl3(0)): BLOAD P$ + "PAL\blend3.dat", VARPTR(bl3(0))
DEF SEG = VARSEG(bl4(0)): BLOAD P$ + "PAL\blend4.dat", VARPTR(bl4(0))

FOR i% = 0 TO 255
OUT &H3C8, i%: i3% = i% * 3
OUT &H3C9, ASC(k(i3%)): OUT &H3C9, ASC(k(i3% + 1)): OUT &H3C9, ASC(k(i3% + 2))
DQBsetBMap 1, 1, i%, ASC(bl1(i%))
DQBsetBMap 1, 2, i%, ASC(bl2(i%))
DQBsetBMap 1, 3, i%, ASC(bl3(i%))
DQBsetBMap 1, 4, i%, ASC(bl4(i%))
NEXT i%

DEF SEG = &HA000: BLOAD P$ + "LOADING\load2.dat", 0
DEF SEG = DQBmapLayer(2): BLOAD P$ + "PAL\scr1.dat", 0
DEF SEG = DQBmapLayer(3): BLOAD P$ + "PAL\scr2.dat", 0
DEF SEG = DQBmapLayer(14): BLOAD P$ + "PAL\bardown.dat", 0
DEF SEG = VARSEG(Sine%(0)): BLOAD p2$ + "sine.dat", VARPTR(Sine%(0))
DEF SEG = VARSEG(Cosine%(0)): BLOAD p2$ + "cosine.dat", VARPTR(Cosine%(0))
DEF SEG = VARSEG(add1%(0)): BLOAD p2$ + "add.dat", VARPTR(add1%(0))
DEF SEG = VARSEG(KT%(0)): BLOAD p2$ + "kt127.dat", VARPTR(KT%(0))
DEF SEG = VARSEG(TFF&(0)): BLOAD p2$ + "tff.dat", VARPTR(TFF&(0))
DEF SEG = VARSEG(T4100&(0)): BLOAD p2$ + "t4100.dat", VARPTR(T4100&(0))
DEF SEG = VARSEG(WeapCarry%(1)): BLOAD p2$ + "WeapC.dat", VARPTR(WeapCarry%(1))
DEF SEG = VARSEG(WeapAttack%(1)): BLOAD p2$ + "WeapA.dat", VARPTR(WeapAttack%(1))
DEF SEG = VARSEG(WeapHit1%(1)): BLOAD p2$ + "WeapHit1.dat", VARPTR(WeapHit1%(1))
DEF SEG = VARSEG(WeapHit2%(1)): BLOAD p2$ + "WeapHit2.dat", VARPTR(WeapHit2%(1))
DEF SEG = VARSEG(WeapDamage%(1)): BLOAD p2$ + "WeapDam.dat", VARPTR(WeapDamage%(1))

TriOFF& = VARSEG(Tri(0)) * 65536 + VARPTR(Tri(0))
TexOFF& = VARSEG(tex%(0)) * 65536 + VARPTR(tex%(0))
TexOFF2& = VARSEG(tex2%(0)) * 65536 + VARPTR(tex2%(0))
IndOFF& = VARSEG(index(0)) * 65536 + VARPTR(index(0))
Tseg% = VARSEG(tex%(0)): Toff% = VARPTR(tex%(0))
Tseg2% = VARSEG(tex2%(0)): Toff2% = VARPTR(tex2%(0))
dummy% = VSDetectXMS%
FaceH% = VSAllocateXMS%(16)
FloorH% = VSAllocateXMS%(16)
WallH% = VSAllocateXMS%(16)
CeilH% = VSAllocateXMS%(16)
DoorH% = VSAllocateXMS%(2)
SpriH% = VSAllocateXMS%(2)
TexSPH% = VSAllocateXMS%(66)
SprHAnim1% = VSAllocateXMS%(48)
SprHAnim2% = VSAllocateXMS%(48)
TexFH% = VSAllocateXMS%(200)
TexWH% = VSAllocateXMS%(200)
TexC1H% = VSAllocateXMS%(17)
TexC2H% = VSAllocateXMS%(66)
IndH% = VSAllocateXMS%(2)
NumbH% = VSAllocateXMS%(14)
EnemyH% = VSAllocateXMS%(750)
LevelN% = 4: CurWeap% = 1: Health% = 100: FlagFace% = -1: BarShow% = 1

EnemyHealth%(1) = 100: EnemyNumber%(1) = 20: EnemyWalk%(1) = 5: EnemyDie%(1) = 11: EnemyDamage%(1) = 9
EnemyGHit%(1) = 10: EnemySpeed%(1) = 6: EnemyRange%(1) = 46: EnemySH%(1) = 10: EnemyEH%(1) = 10

EnemyHealth%(2) = 160: EnemyNumber%(2) = 41: EnemyWalk%(2) = 13: EnemyDie%(2) = 30: EnemyDamage%(2) = 4
EnemyGHit%(2) = 14: EnemySpeed%(2) = 5: EnemyRange%(2) = 52: EnemySH%(2) = 18: EnemyEH%(2) = 20

DEF SEG = Tseg%
FOR i% = 0 TO 9
BLOAD P$ + "MESSAGE\" + LTRIM$(STR$(i%)) + ".dat", Toff%
dummy% = VSMoveXMS%(i% * 512, NumbH%, TexOFF&, 0, 500)
IF i% < 3 THEN
BLOAD P$ + "PAL\balm" + LTRIM$(STR$(i%)) + ".dat", Toff%: dummy% = VSMoveXMS%(8000 + i% * 1000, NumbH%, TexOFF&, 0, 1000)
BLOAD P$ + "PAL\blood" + LTRIM$(STR$(i%)) + ".dat", Toff%: dummy% = VSMoveXMS%(11000 + i% * 1000, NumbH%, TexOFF&, 0, 1000)
END IF
NEXT i%
BLOAD P$ + "MESSAGE\fps.dat", Toff%
dummy% = VSMoveXMS%(6000, NumbH%, TexOFF&, 0, 1500)
END SUB

SUB TransAll (index%, kx%, kz%, dummy%)
Tri(index%).x1 = xx1% + kx%: Tri(index%).x2 = xx2% + kx%: Tri(index%).x3 = xx3% + kx%: Tri(index%).x4 = xx4% + kx%
Tri(index%).z1 = zz1% + kz%: Tri(index%).z2 = zz2% + kz%: Tri(index%).z3 = zz3% + kz%: Tri(index%).z4 = zz4% + kz%
END SUB

