DEFINT A-Z
'$DYNAMIC
'$INCLUDE: 'cai3.bi'
'$INCLUDE: 'gslib.bi'
'$INCLUDE: 'ds4qb2.bi'
'$bas: 'Battle.bas'
'$bas: 'Support1.bas'
'$bas: 'Ds4qb2.bas'
'$lib: 'Cai3.lib'
'$end_meta

DECLARE FUNCTION Center% (Talk$)
DECLARE SUB StaticMap ()
DECLARE SUB EffectLayer (Effect%)
DECLARE SUB ItemQuery (ItemID%, ItemData AS ANY)
DECLARE SUB LevelUp ()
DECLARE FUNCTION NpcVisible% (NPC%)
DECLARE SUB LoadBkg (sFile$)
DECLARE FUNCTION BYTE% (sTemp$)
DECLARE SUB LoadMusic (file$, Channel%)
DECLARE FUNCTION SaveLoadInput% (SaveL%)
DECLARE SUB GiveMajorSpell ()
DECLARE SUB BoatShop ()
DECLARE SUB PaletteFade (R%, g%, b%)
DECLARE SUB PartyOrder ()
DECLARE SUB PartySwitch (Char1$, Slot%, Switch%)
DECLARE SUB TimerEvent ()
DECLARE SUB Spritelayer (ExtraX%, ExtraY%)
DECLARE SUB CheckScript2 ()
DECLARE SUB BoatMovement (Dir%)
DECLARE SUB LoadChests (file$)
DECLARE SUB MessageBar (Phrase$)
DECLARE FUNCTION Quant% (MaxQuant%)
DECLARE SUB FontLoad (file$)
DECLARE SUB Shop ()
DECLARE SUB LoadMember (sFile$, Number%)
DECLARE SUB Script (file$)
DECLARE SUB Refinery ()
DECLARE SUB DrawMenuBack (Menu$, SubMenu%)
DECLARE SUB Inn (Cost%)
DECLARE FUNCTION ChoiceBox% ()
DECLARE FUNCTION Continue% ()
DECLARE SUB DialogBox (Flip%, x1%, y1%, x2%, y2%, col%)
DECLARE FUNCTION PlayerSelect% ()
DECLARE SUB Battle (DisableRun%, BattleType%)
DECLARE SUB HeroMenu ()
DECLARE SUB GetTime ()
DECLARE FUNCTION GiveItem% (Itm$)
DECLARE SUB MenuBox (Menu%)
DECLARE SUB MainMenu ()
DECLARE SUB DrawMainMenu ()
DECLARE SUB ShowDormant ()
DECLARE SUB NewGame ()
DECLARE SUB ScrollScreen ()
DECLARE SUB ShowSprite (FileName$, x%, y%, Number%, Size%, PutType)
DECLARE SUB ShowChar (Show%, Handle%, x%, y%)
DECLARE SUB LoadTiles (FileName$)
DECLARE SUB VisiblePlane (xDir, yDir)
DECLARE SUB ViewMap (Warp AS TileDataTYPE)
DECLARE SUB GameLoop ()
DECLARE SUB gsprint (Flip%, xpos%, ypos%, Text$, col%)
DECLARE SUB SaveLoad (file$, SL%)
DECLARE SUB FadePal (Direction%)
DECLARE SUB LoadPal ()
DECLARE SUB InitStats ()
DECLARE SUB MainLoop ()

CLEAR

DIM SHARED Pal(256) AS PalTYPE, Buffer&(15999), PartDef%(8), Act%(1 TO 6)
DIM SHARED Party(1 TO 5) AS CharTYPE, Enemy(1 TO 3) AS EnemyTYPE
DIM SHARED ItemPrice%(1 TO 8), SaleItem$(1 TO 8), Item(1 TO 2, 1 TO 18) AS ItemListTYPE
DIM SHARED Fontstr$(256), NumAtks%(1 TO 3), Haste%(1 TO 3)
DIM SHARED Magic(1 TO 5, 1 TO 20) AS STRING * 11, SPNeed%(1 TO 5, 1 TO 20)
DIM SHARED EneAtk(1 TO 3, 1 TO 5) AS STRING * 11
DIM SHARED ChestStatus%(1 TO 70)

SCREEN 13

gsfill &HA000, 0, 0

PRINT "Here you may disable music if it's"
PRINT "causing problems..."
INPUT "1.Enable 2.Disable"; Choice%

SELECT CASE Choice%
	CASE 1
		PRINT "Music Enabled...": gswait 50
		MusicOff% = False
	CASE 2
		PRINT "Music Disabled...": gswait 50
		MusicOff% = True
	CASE ELSE
		PRINT "Invaild option Music Disabled...": gswait 50
		MusicOff% = True
END SELECT

gsfill &HA000, 0, 0

LOCATE 1, 1: PRINT "Loading... Please wait."
InitDS4QB

OPEN "ds4qb2.dat" FOR OUTPUT AS #1
	WRITE #1, "music\select.wav"
	WRITE #1, "music\illegal.wav"
	WRITE #1, "music\hslash.wav"
	WRITE #1, "music\eslash.wav"
	WRITE #1, "music\venosoft.wav"
CLOSE #1
DSLoadSample

gsinit
MainLoop

ShutDownDS4QB

SUB BoatMovement (Dir%)

	SELECT CASE Dir%
		CASE FaceRIGHT               ' Code for right arrow key.
			DEF SEG = 0: POKE &H41A, PEEK(&H41C): DEF SEG 'clear keyboard buffer
			NPCs(CameraOn%).byFacing = CHR$(FaceRIGHT)
			SELECT CASE BYTE(Map(NPCs(CameraOn%).x + 1, NPCs(CameraOn%).y).byLayer2)
				CASE 19, 21
					'Do Nothing
				CASE ELSE
					SELECT CASE BYTE(Map(NPCs(CameraOn%).x + 1, NPCs(CameraOn%).y).byLayer1)
						CASE 20, 25 TO 32, 45 TO 60
							VisibleX% = VisibleX% + 1
							NPCs(CameraOn%).x = NPCs(CameraOn%).x + 1
							Boat.x = Boat.x + 1
							VisiblePlane 19, 0
							Moved% = True
							ShowDormant
						CASE 1, 8 TO 16, 33 TO 44
							LoadMusic MapInfo.sMapMusic, 1
							Map(Boat.x, Boat.y).bWalkable = True
							Boat.BoatOn = False
							NPCs(CameraOn%).sSet = "nick.set"
							VisibleX% = VisibleX% + 1
							NPCs(CameraOn%).x = NPCs(CameraOn%).x + 1
							VisiblePlane 19, 0
							Moved% = True
							ShowDormant
					END SELECT
			END SELECT
		CASE FaceLEFT               ' Code for left arrow key.
			DEF SEG = 0: POKE &H41A, PEEK(&H41C): DEF SEG 'clear keyboard buffer
			NPCs(CameraOn%).byFacing = CHR$(FaceLEFT)
			SELECT CASE BYTE(Map(NPCs(CameraOn%).x - 1, NPCs(CameraOn%).y).byLayer2)
				CASE 19, 21
					'Do Nothing
				CASE ELSE
					SELECT CASE BYTE(Map(NPCs(CameraOn%).x - 1, NPCs(CameraOn%).y).byLayer1)
						CASE 20, 25 TO 32, 45 TO 60
							VisibleX% = VisibleX% - 1
							NPCs(CameraOn%).x = NPCs(CameraOn%).x - 1
							Boat.x = Boat.x - 1
							VisiblePlane -19, 0
							Moved% = True
							ShowDormant
						CASE 1, 8 TO 16, 33 TO 44
							LoadMusic MapInfo.sMapMusic, 1
							Map(Boat.x, Boat.y).bWalkable = True
							Boat.BoatOn = False
							NPCs(CameraOn%).sSet = "nick.set"
							VisibleX% = VisibleX% - 1
							NPCs(CameraOn%).x = NPCs(CameraOn%).x - 1
							VisiblePlane -19, 0
							Moved% = True
							ShowDormant
					END SELECT
			END SELECT
		CASE FaceDOWN               ' Code for down arrow key.
			DEF SEG = 0: POKE &H41A, PEEK(&H41C): DEF SEG 'clear keyboard buffer
			NPCs(CameraOn%).byFacing = CHR$(FaceDOWN)
			SELECT CASE BYTE(Map(NPCs(CameraOn%).x, NPCs(CameraOn%).y + 1).byLayer2)
				CASE 19, 21
					'Do Nothing
				CASE ELSE
					SELECT CASE BYTE(Map(NPCs(CameraOn%).x, NPCs(CameraOn%).y + 1).byLayer1)
						CASE 20, 25 TO 32, 45 TO 60
							VisibleY% = VisibleY% + 1
							NPCs(CameraOn%).y = NPCs(CameraOn%).y + 1
							Boat.y = Boat.y + 1
							VisiblePlane 0, 19
							Moved% = True
							ShowDormant
						CASE 1, 8 TO 16, 33 TO 44
							LoadMusic MapInfo.sMapMusic, 1
							Map(Boat.x, Boat.y).bWalkable = True
							Boat.BoatOn = False
							NPCs(CameraOn%).sSet = "nick.set"
							VisibleY% = VisibleY% + 1
							NPCs(CameraOn%).y = NPCs(CameraOn%).y + 1
							VisiblePlane 0, 19
							Moved% = True
							ShowDormant
					END SELECT
			END SELECT
		CASE FaceUP               ' Code for up arrow key.
			DEF SEG = 0: POKE &H41A, PEEK(&H41C): DEF SEG 'clear keyboard buffer
			NPCs(CameraOn%).byFacing = CHR$(FaceUP)
			SELECT CASE BYTE(Map(NPCs(CameraOn%).x, NPCs(CameraOn%).y - 1).byLayer2)
				CASE 19, 21
					'Do Nothing
				CASE ELSE
					SELECT CASE BYTE(Map(NPCs(CameraOn%).x, NPCs(CameraOn%).y - 1).byLayer1)
						CASE 20, 25 TO 32, 45 TO 60
							VisibleY% = VisibleY% - 1
							NPCs(CameraOn%).y = NPCs(CameraOn%).y - 1
							Boat.y = Boat.y - 1
							VisiblePlane 0, -19
							Moved% = True
							ShowDormant
						CASE 1, 8 TO 16, 33 TO 44
							LoadMusic MapInfo.sMapMusic, 1
							Map(Boat.x, Boat.y).bWalkable = True
							Boat.BoatOn = False
							NPCs(CameraOn%).sSet = "nick.set"
							VisibleY% = VisibleY% - 1
							NPCs(CameraOn%).y = NPCs(CameraOn%).y - 1
							VisiblePlane 0, -19
							Moved% = True
							ShowDormant
					END SELECT
			END SELECT
	END SELECT

END SUB

SUB BoatShop

	DialogBox True, 0, 135, 319, 199, 56
	gsprint 1, 5, 140, "Portmaster: Hm?  Ah you need ", 31
	gsprint 1, 5, 150, "a ship?  I'm selling one for ", 31
	gsprint 1, 5, 160, "50,000 cal.", 31
	gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0

	Result% = ChoiceBox%

	IF Result% THEN
		IF Cal& >= 50000 THEN
				DialogBox True, 0, 135, 319, 199, 56
				gsprint 1, 5, 140, "Portmaster: Thank you very much.  The ", 31
				gsprint 1, 5, 150, "ship will be waiting outside.", 31
				gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
				Cal& = Cal& - 50000
				WHILE INKEY$ <> CHR$(13): WEND
				Boat.x = 60: Boat.y = 19
				PartDef%(0) = 57
			ELSEIF Cal& < 50000 THEN
				CALL ShowDormant
				DialogBox True, 0, 135, 319, 199, 56
				gsprint 1, 5, 140, "Portmaster: Can't give it ta' ya for  ", 31
				gsprint 1, 5, 150, "free.  Sorry...", 31
				gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
				WHILE INKEY$ <> CHR$(13): WEND
		END IF
	END IF

	IF NOT Result% THEN
		DialogBox True, 0, 135, 319, 199, 56
		gsprint 1, 5, 140, "Portmaster: Well the ships will be ", 31
		gsprint 1, 5, 150, "here for you.", 31
		gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
		WHILE INKEY$ <> CHR$(13): WEND
	END IF

END SUB

FUNCTION BYTE (sTemp$)

	BYTE = ASC(sTemp$)

END FUNCTION

FUNCTION Continue

   CursorX% = 5: CursorY% = 30
   DO
		SELECT CASE SaveLoadInput%(1)
			CASE 30
				SaveLoad "save1.sav", 2
				ChoiceMade% = True
				Continue% = True
			CASE 95
				SaveLoad "save2.sav", 2
				ChoiceMade% = True
				Continue% = True
			CASE 160
				SaveLoad "save3.sav", 2
				ChoiceMade% = True
				Continue% = True
			CASE 0
				ChoiceMade% = True
				Continue% = False
		END SELECT
   LOOP UNTIL ChoiceMade%

END FUNCTION

SUB DrawMainMenu

	gsboxf VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), 0, 0, 319, 199, 0
	DEF SEG = VARSEG(Buffer&(0)): BLOAD "title.fsi", VARPTR(Buffer&(0)): DEF SEG
	DialogBox True, 108, 80, 202, 162, 56
	gsprint 1, 130, 100, "New Game", 31
	gsprint 1, 130, 120, "Continue", 31
	gsprint 1, 130, 140, "Quit", 31
	ShowSprite "pointer.spr", CursorX%, CursorY%, 0, 20, 0
	gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0

END SUB

REM $STATIC
SUB EffectLayer (Effect%)

	SELECT CASE Effect%
		CASE 1
			CloudX% = CloudX% + 1
			IF CloudX% = 320 THEN CloudX% = -72: CloudY% = INT(RND * 120) + 30
			ShowSprite "cloud.til", CloudX%, CloudY%, 0, 72, 1
		CASE 2
			ShowSprite "world.til", 243, 123, 0, 76, 1
			gspset 243 + NPCs(CameraOn%).x, 123 + NPCs(CameraOn%).y, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), 31
	END SELECT

END SUB

REM $DYNAMIC
SUB GameLoop

	DO
		'LOCATE 1, 1: PRINT NPCs(CameraOn%).x; " "; NPCs(CameraOn%).y; " Story:"; PartDef%(0)
		SELECT CASE INKEY$
			CASE "l"                              'level up cheat menu
				LevelUp
			CASE "m"                              'Cal increase cheat
				Cal& = Cal& + 10000
				IF Cal& > 999999 THEN Cal& = 999999
			CASE "p"
				PartDef(0) = PartDef(0) + 1
			CASE "r"                              'toogle running
				IF RunOff% THEN
						RunOff% = False
					ELSE
						RunOff% = True
				END IF
			CASE CHR$(0) + CHR$(71)               ' Code for Home key
				HeroMenu
			CASE CHR$(0) + CHR$(77)               ' Code for right arrow key.
				DEF SEG = 0: POKE &H41A, PEEK(&H41C): DEF SEG 'clear keyboard buffer
				NPCs(CameraOn%).byFacing = CHR$(FaceRIGHT)
				IF Map(NPCs(CameraOn%).x + 1, NPCs(CameraOn%).y).bWalkable AND NOT Boat.BoatOn THEN
						VisibleX% = VisibleX% + 1
						Map(NPCs(CameraOn%).x, NPCs(CameraOn%).y).bWalkable = True
						NPCs(CameraOn%).x = NPCs(CameraOn%).x + 1
						Map(NPCs(CameraOn%).x, NPCs(CameraOn%).y).bWalkable = False
						VisiblePlane 19, 0
						Moved% = True
						IF NPCs(CameraOn%).x = Boat.x AND NPCs(CameraOn%).y = Boat.y AND RTRIM$(MapInfo.sMapName) = "Paravia" THEN
							Map(Boat.x, Boat.y).bWalkable = False
							Boat.BoatOn = True
							NPCs(CameraOn%).sSet = "boat.set"
							LoadMusic "boat.it", 1
						END IF
					ELSEIF Boat.BoatOn THEN
						BoatMovement FaceRIGHT
				END IF
			CASE CHR$(0) + CHR$(75)               ' Code for left arrow key.
				DEF SEG = 0: POKE &H41A, PEEK(&H41C): DEF SEG 'clear keyboard buffer
				NPCs(CameraOn%).byFacing = CHR$(FaceLEFT)
				IF Map(NPCs(CameraOn%).x - 1, NPCs(CameraOn%).y).bWalkable AND NOT Boat.BoatOn THEN
						VisibleX% = VisibleX% - 1
						Map(NPCs(CameraOn%).x, NPCs(CameraOn%).y).bWalkable = True
						NPCs(CameraOn%).x = NPCs(CameraOn%).x - 1
						Map(NPCs(CameraOn%).x, NPCs(CameraOn%).y).bWalkable = False
						VisiblePlane -19, 0
						Moved% = True
						IF NPCs(CameraOn%).x = Boat.x AND NPCs(CameraOn%).y = Boat.y AND RTRIM$(MapInfo.sMapName) = "Paravia" THEN
							Map(Boat.x, Boat.y).bWalkable = False
							Boat.BoatOn = True
							NPCs(CameraOn%).sSet = "boat.set"
							LoadMusic "boat.it", 1
						END IF
					ELSEIF Boat.BoatOn THEN
						BoatMovement FaceLEFT
				END IF
			CASE CHR$(0) + CHR$(80)               ' Code for down arrow key.
				DEF SEG = 0: POKE &H41A, PEEK(&H41C): DEF SEG 'clear keyboard buffer
				NPCs(CameraOn%).byFacing = CHR$(FaceDOWN)
				IF Map(NPCs(CameraOn%).x, NPCs(CameraOn%).y + 1).bWalkable AND NOT Boat.BoatOn THEN
						VisibleY% = VisibleY% + 1
						Map(NPCs(CameraOn%).x, NPCs(CameraOn%).y).bWalkable = True
						NPCs(CameraOn%).y = NPCs(CameraOn%).y + 1
						Map(NPCs(CameraOn%).x, NPCs(CameraOn%).y).bWalkable = False
						VisiblePlane 0, 19
						Moved% = True
						IF NPCs(CameraOn%).x = Boat.x AND NPCs(CameraOn%).y = Boat.y AND RTRIM$(MapInfo.sMapName) = "Paravia" THEN
							Map(Boat.x, Boat.y).bWalkable = False
							Boat.BoatOn = True
							NPCs(CameraOn%).sSet = "boat.set"
							LoadMusic "boat.it", 1
						END IF
					ELSEIF Boat.BoatOn THEN
						BoatMovement FaceDOWN
				END IF
			CASE CHR$(0) + CHR$(72)               ' Code for up arrow key.
				DEF SEG = 0: POKE &H41A, PEEK(&H41C): DEF SEG 'clear keyboard buffer
				NPCs(CameraOn%).byFacing = CHR$(FaceUP)
				IF Map(NPCs(CameraOn%).x, NPCs(CameraOn%).y - 1).bWalkable AND NOT Boat.BoatOn THEN
						VisibleY% = VisibleY% - 1
						Map(NPCs(CameraOn%).x, NPCs(CameraOn%).y).bWalkable = True
						NPCs(CameraOn%).y = NPCs(CameraOn%).y - 1
						Map(NPCs(CameraOn%).x, NPCs(CameraOn%).y).bWalkable = False
						VisiblePlane 0, -19
						Moved% = True
						IF NPCs(CameraOn%).x = Boat.x AND NPCs(CameraOn%).y = Boat.y AND RTRIM$(MapInfo.sMapName) = "Paravia" THEN
							Map(Boat.x, Boat.y).bWalkable = False
							Boat.BoatOn = True
							NPCs(CameraOn%).sSet = "boat.set"
							LoadMusic "boat.it", 1
						END IF
					ELSEIF Boat.BoatOn THEN
						BoatMovement FaceUP
				END IF
			CASE CHR$(13)                          ' Code for the Enter Key
				NPCThere% = False
				ChestThere% = False
				FOR i% = 0 TO NumNPCs - 1
					IF i% <> CameraOn% AND NpcVisible(i%) THEN
						Face% = BYTE(NPCs(i%).byFacing)
						IF BYTE(NPCs(CameraOn%).byFacing) = FaceUP AND NPCs(CameraOn%).x = NPCs(i%).x AND NPCs(CameraOn%).y - 1 = NPCs(i%).y THEN
								NPCs(i%).byFacing = CHR$(FaceDOWN)
								NPCThere% = True: EXIT FOR
							ELSEIF BYTE(NPCs(CameraOn%).byFacing) = FaceDOWN AND NPCs(CameraOn%).x = NPCs(i%).x AND NPCs(CameraOn%).y + 1 = NPCs(i%).y THEN
								NPCs(i%).byFacing = CHR$(FaceUP)
								NPCThere% = True: EXIT FOR
							ELSEIF BYTE(NPCs(CameraOn%).byFacing) = FaceLEFT AND NPCs(CameraOn%).x - 1 = NPCs(i%).x AND NPCs(CameraOn%).y = NPCs(i%).y THEN
								NPCs(i%).byFacing = CHR$(FaceRIGHT)
								NPCThere% = True: EXIT FOR
							ELSEIF BYTE(NPCs(CameraOn%).byFacing) = FaceRIGHT AND NPCs(CameraOn%).x + 1 = NPCs(i%).x AND NPCs(CameraOn%).y = NPCs(i%).y THEN
								NPCs(i%).byFacing = CHR$(FaceLEFT)
								NPCThere% = True: EXIT FOR
						END IF
					END IF
				NEXT i%
				IF NPCThere% THEN
					ShowDormant
					Scr$ = NPCs(i%).sScript
					IF INSTR(Scr$, ".scr") THEN
						Script "npcs\" + Scr$
					END IF
					IF i% <= NumNPCs - 1 THEN NPCs(i%).byFacing = CHR$(Face%)
				END IF
				FOR i% = 1 TO NumChests%
					IF Chest(i%).x = NPCs(CameraOn%).x AND Chest(i%).y = NPCs(CameraOn%).y - 1 THEN
							ChestThere% = True
						ELSEIF Chest(i%).x = NPCs(CameraOn%).x AND Chest(i%).y = NPCs(CameraOn%).y + 1 THEN
							ChestThere% = True
						ELSEIF Chest(i%).x = NPCs(CameraOn%).x - 1 AND Chest(i%).y = NPCs(CameraOn%).y THEN
							ChestThere% = True
						ELSEIF Chest(i%).x = NPCs(CameraOn%).x + 1 AND Chest(i%).y = NPCs(CameraOn%).y THEN
							ChestThere% = True
						ELSE
							ChestThere% = False
					END IF
					SELECT CASE Chest(i%).ChType
						CASE 0
							IF ChestThere% AND NOT ChestStatus%(Chest(i%).Number) THEN
								Result% = GiveItem(RTRIM$(Chest(i%).Title))
								DialogBox True, 0, 135, 319, 199, 56
								gsprint 1, 5, 140, "You aquired a " + RTRIM$(Chest(i%).Title) + ".", 31
								gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
								WHILE INKEY$ <> CHR$(13): WEND
								ChestStatus%(Chest(i%).Number) = -1
							END IF
						CASE -1
							IF ChestThere% AND NOT ChestStatus%(Chest(i%).Number) THEN
								DialogBox True, 0, 135, 319, 199, 56
								gsprint 1, 5, 140, "A SP Spring! Party SP increased", 31
								gsprint 1, 5, 150, "by " + RTRIM$(Chest(i%).Title) + ".", 31
								gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
								FOR j% = 1 TO 5
									IF Party(j%).OnTeam THEN
										Party(j%).SPMAX = Party(j%).SPMAX + VAL(Chest(i%).Title)
									END IF
								NEXT j%
								WHILE INKEY$ <> CHR$(13): WEND
								ChestStatus%(Chest(i%).Number) = -1
							END IF
					END SELECT
				NEXT i%
				IF NOT NPCThere% AND NOT ChestThere% AND PartDef%(0) > 51 THEN
					IF BYTE(Map(NPCs(CameraOn%).x, NPCs(CameraOn%).y).byLayer1) = 4 OR RTRIM$(MapInfo.sMapName) = "Paravia" THEN
						PartyOrder
					END IF
				END IF
		END SELECT

		IF BYTE(Map(NPCs(CameraOn%).x, NPCs(CameraOn%).y).byScriptID) <> 0 THEN
			ScriptFile$ = Scripts(BYTE(Map(NPCs(CameraOn%).x, NPCs(CameraOn%).y).byScriptID)).sFileName
			Entered% = JustEntered%
			Mov% = Moved%

			Script "data\" + ScriptFile$
			IF NOT Lost% THEN
				JustEntered% = Entered%
				Moved% = Mov%
			END IF
		END IF

		IF Moved% THEN
			Moved% = False
			JustEntered% = False
			IF BYTE(Map(NPCs(CameraOn%).x, NPCs(CameraOn%).y).byWarpID) <> 0 THEN
					MapFile$ = Warps(BYTE(Map(NPCs(CameraOn%).x, NPCs(CameraOn%).y).byWarpID)).sFileName
					DIM TempWarp AS TileDataTYPE
					TempWarp = Warps(BYTE(Map(NPCs(CameraOn%).x, NPCs(CameraOn%).y).byWarpID))
					ViewMap TempWarp
					FadePal 1
					JustEntered% = True
				ELSEIF BYTE(Map(NPCs(CameraOn%).x, NPCs(CameraOn%).y).byRegionID) <> 0 AND NOT Boat.BoatOn THEN
					RANDOMIZE TIMER
					BattleChance% = INT(RND * 20) + 1
					IF BattleChance% = 1 THEN
						Bkg$ = Regions(BYTE(Map(NPCs(CameraOn%).x, NPCs(CameraOn%).y).byRegionID)).sFileName
						LoadBkg Bkg$
						Battle 0, 0
						IF NOT Lost% THEN
							FadePal 0
							ShowDormant
							FadePal 1
						END IF
					END IF
			END IF
		END IF
		IF NOT Lost% THEN
			ShowDormant
		END IF
	LOOP UNTIL Quit% OR Lost%
	Quit% = False: Lost% = False: BossFight% = False: Timed.TimerOn = False
	FadePal 0

	IF EffectDark% THEN
		FOR i% = 1 TO 10
			PaletteFade 1, 1, 1
		NEXT i%
		EffectDark% = False
	END IF

	MapInfo.sMapMusic = ""
	LoadMusic "intro.it", 1

END SUB

SUB GiveMajorSpell

	'Party member major spell learning
	PartyTitle$ = RTRIM$(Party(1).Title)

	SELECT CASE RTRIM$(MapInfo.sMapName)
		CASE "Earthfane F6"
			Spell$ = "Rockfall"
			SpellNum% = 13
		CASE "Firefane F6"
			Spell$ = "Magma Blast"
			SpellNum% = 6
		CASE "Windfane F6"
			Spell$ = "Trinado"
			SpellNum% = 18
	END SELECT

	Magic$(1, SpellNum%) = Spell$
	SPNeed%(1, SpellNum%) = 50

END SUB

SUB HeroMenu

	RANDOMIZE TIMER
	DIM ItemD AS ItemTYPE
	DIM SpellD AS SpellTYPE

	CursorX% = 225: CursorY% = 20: CharTurn% = 0
	MenuBox 0
	DO
		SELECT CASE INKEY$
			CASE CHR$(0) + CHR$(72)
				DEF SEG = 0: POKE &H41A, PEEK(&H41C): DEF SEG 'clear keyboard buffer
				CursorY% = CursorY% - 10
				IF CursorY% = 10 THEN CursorY% = 20
				MenuBox 0
				DSPlaySample 1
			CASE CHR$(0) + CHR$(80)
				DEF SEG = 0: POKE &H41A, PEEK(&H41C): DEF SEG 'clear keyboard buffer
				CursorY% = CursorY% + 10
				IF CursorY% = 100 THEN CursorY% = 90
				MenuBox 0
				DSPlaySample 1
			CASE CHR$(13)
				IF CursorY% = 20 THEN
					DO
						CharTurn% = PlayerSelect%
						CursorX% = 225: CursorY% = 20
						IF CharTurn% THEN
							MenuBox 3
							WHILE INKEY$ <> CHR$(0) + CHR$(83): WEND
						END IF
						Done% = True
					LOOP UNTIL Done%
					Done% = False: CharTurn% = 0: MenuBox 0
				END IF

				IF CursorY% = 30 THEN
					CursorX% = 174: CursorY% = 10: MenuBox 4
					DO
						SELECT CASE INKEY$
							CASE CHR$(0) + CHR$(72)
								DEF SEG = 0: POKE &H41A, PEEK(&H41C): DEF SEG 'clear keyboard buffer
								CursorY% = CursorY% - 10
								IF CursorY% = 0 THEN CursorY% = 10
								MenuBox 4
								DSPlaySample 1
							CASE CHR$(0) + CHR$(80)
								DEF SEG = 0: POKE &H41A, PEEK(&H41C): DEF SEG 'clear keyboard buffer
								CursorY% = CursorY% + 10
								IF CursorY% = 190 THEN CursorY% = 180
								MenuBox 4
								DSPlaySample 1
							CASE CHR$(13)
								ItemNum% = CursorY% / 10
								IF Item(ItemPage%, ItemNum%).Quantity <> 0 THEN
									TempX% = CursorX%: TempY% = CursorY%
									DO
										Result% = PlayerSelect%
										IF Result% = 0 THEN Done% = True
										IF Result% <> 0 THEN
											IF NOT Party(Result%).Alive AND Item(ItemPage%, ItemNum%).ItemID = 16 THEN Done% = True
											IF Party(Result%).Alive AND Item(ItemPage%, ItemNum%).ItemID <> 16 THEN Done% = True
										END IF
									LOOP UNTIL Done%
									Done% = False
									IF Result% <> 0 THEN
										ItemQuery Item(ItemPage%, ItemNum%).ItemID, ItemD
										SELECT CASE RTRIM$(ItemD.ItemTYPE)
											CASE "Heal"
												Party(Result%).HP = Party(Result%).HP + ItemD.ItemPower
												IF Party(Result%).HP > Party(Result%).HPMax THEN Party(Result%).HP = Party(Result%).HPMax
												IF RTRIM$(ItemD.Title) = "Revive" THEN Party(Result%).Alive = True
											CASE "SP Heal"
												Party(Result%).SP = Party(Result%).SP + ItemD.ItemPower
												IF Party(Result%).SP > Party(Result%).SPMAX THEN Party(Result%).SP = Party(Result%).SPMAX
											CASE "Heal/SP"
												Party(Result%).HP = Party(Result%).HP + ItemD.ItemPower
												IF Party(Result%).HP > Party(Result%).HPMax THEN Party(Result%).HP = Party(Result%).HPMax
												Party(Result%).SP = Party(Result%).SPMAX + ItemD.ItemPower
												IF Party(Result%).SP > Party(Result%).SPMAX THEN Party(Result%).SP = Party(Result%).SPMAX
											CASE "Armor"
												CanI% = GiveItem(RTRIM$(Party(Result%).ArmName))
												IF CanI% THEN
														Party(Result%).ArmName = RTRIM$(ItemD.Title)
														Party(Result%).ArmDF = ItemD.ItemPower
													ELSEIF NOT CanI% THEN
														gsboxf &HA000, 0, 1, 135, 319, 199, 55
														gsbox &HA000, 0, 1, 135, 319, 199, 24
														gsbox &HA000, 0, 2, 136, 318, 198, 27
														gsbox &HA000, 0, 3, 137, 317, 197, 26
														gsprint 0, 5, 140, "You can't equip the Armor", 31
														gsprint 0, 5, 150, "because of lack of item", 31
														gsprint 0, 5, 160, "space!", 31
												END IF
											CASE "Stat"
												SELECT CASE RTRIM$(ItemD.Title)
													CASE "Str. Potion"
														Party(Result%).ST = Party(Result%).ST + ItemD.ItemPower
													CASE "Dex. Potion"
														Party(Result%).Dex = Party(Result%).Dex + ItemD.ItemPower
													CASE "MStr. Potion"
														Party(Result%).MS = Party(Result%).MS + ItemD.ItemPower
													CASE "HP Potion"
														Party(Result%).HPMax = Party(Result%).HPMax + ItemD.ItemPower
												END SELECT
											CASE "Runic"
												CanI% = GiveItem(RTRIM$(Party(Result%).RunicEq))
												IF RTRIM$(Party(Result%).RunicEq) = "" THEN CanI% = True
												IF CanI% THEN
														Party(Result%).RunicEq = RTRIM$(ItemD.Title)
													ELSEIF NOT CanI% THEN
														gsboxf &HA000, 0, 1, 135, 319, 199, 55
														gsbox &HA000, 0, 1, 135, 319, 199, 24
														gsbox &HA000, 0, 2, 136, 318, 198, 27
														gsbox &HA000, 0, 3, 137, 317, 197, 26
														gsprint 0, 5, 140, "You can't equip the Runic", 31
														gsprint 0, 5, 150, "because of lack of item", 31
														gsprint 0, 5, 160, "space!", 31
												END IF
											CASE "Status"
												SELECT CASE RTRIM$(ItemD.Title)
													CASE "Antidote"
														IF Party(Result%).Status = 2 THEN Party(Result%).Status = 1
												END SELECT
											CASE "Key"
												UsedItm = True
											CASE ELSE
												UsedItm = True
										END SELECT
										IF NOT UsedItm THEN
											Item(ItemPage%, ItemNum%).Quantity = Item(ItemPage%, ItemNum%).Quantity - 1
											IF Item(ItemPage%, ItemNum%).Quantity = 0 THEN Item(ItemPage%, ItemNum%).ItemID = 0
										END IF
									END IF
									UsedItm = False
									CursorX% = TempX%: CursorY% = TempY%: MenuBox 4
								END IF
							CASE CHR$(0) + CHR$(83)
								Done% = True
						END SELECT
					LOOP UNTIL Done%
					Done% = False: CursorX% = 225: CursorY% = 20
					CharTurn% = 0: MenuBox 0
				END IF

				IF CursorY% = 40 THEN
					CharTurn% = PlayerSelect%
					IF NOT CharTurn% THEN Done% = True
					IF CharTurn% <> 0 THEN
						CursorX% = 174: CursorY% = 10: MenuBox 6
						Done% = False
					END IF
					DO
						SELECT CASE INKEY$
							CASE CHR$(0) + CHR$(72)
								DEF SEG = 0: POKE &H41A, PEEK(&H41C): DEF SEG 'clear keyboard buffer
								CursorY% = CursorY% - 10
								IF CursorY% = 0 THEN CursorY% = 10
								MenuBox 6
								DSPlaySample 1
							CASE CHR$(0) + CHR$(80)
								DEF SEG = 0: POKE &H41A, PEEK(&H41C): DEF SEG 'clear keyboard buffer
								CursorY% = CursorY% + 10
								IF CursorY% = 190 THEN CursorY% = 180
								MenuBox 6
								DSPlaySample 1
							CASE CHR$(13)
								SpNum% = CursorY% / 10
								FileNum% = FREEFILE
								OPEN "data\spells.mag" FOR BINARY AS #FileNum%
									GET #FileNum%, , NumSpells%
									FOR i% = 1 TO NumSpells
										GET #FileNum%, , SpellD
										IF RTRIM$(SpellD.Title) = RTRIM$(Magic(CharTurn%, SpNum%)) THEN EXIT FOR
									NEXT i%
								CLOSE #FileNum%
								TempX% = CursorX%: TempY% = CursorY%
								IF SPNeed(CharTurn%, SpNum%) <> 0 AND RTRIM$(SpellD.AtkType) = "Heal" AND Party(CharTurn%).SP >= SpellD.SP THEN
									DO
										Temp% = CharTurn%
										CharTurn% = 0
										Result% = PlayerSelect%
										CharTurn% = Temp%
										IF Result% = 0 THEN Done% = True
										IF Result% <> 0 THEN
											IF NOT Party(Result%).Alive AND RTRIM$(Magic(CharTurn%, SpNum%)) = "Revive" THEN Done% = True
											IF Party(Result%).Alive AND RTRIM$(Magic(CharTurn%, SpNum%)) <> "Revive" THEN Done% = True
										END IF
									LOOP UNTIL Done%
									Done% = False
									IF Result% <> 0 THEN
										IF NOT Party(Result%).Alive THEN Party(Result%).Alive = True
										Party(CharTurn%).SP = Party(CharTurn%).SP - SpellD.SP
										Damage% = (Party(CharTurn%).MS * SpellD.Power + (INT(RND * Party(CharTurn%).MS))) / 2
										Party(Result%).HP = Party(Result%).HP + Damage%
										IF Party(Result%).HP > Party(Result%).HPMax THEN Party(Result%).HP = Party(Result%).HPMax
									END IF
								END IF
								CursorX% = TempX%: CursorY% = TempY%: MenuBox 6
							CASE CHR$(0) + CHR$(83)
								Done% = True
						END SELECT
					LOOP UNTIL Done%
					Done% = False: CursorX% = 225: CursorY% = 20
					CharTurn% = 0: MenuBox 0
				END IF

				IF CursorY% = 50 THEN
					MenuBox 5
					WHILE INKEY$ <> CHR$(0) + CHR$(83): WEND
					MenuBox 0
				END IF

				IF CursorY% = 60 THEN
					DO
						CharTurn% = PlayerSelect
						IF CharTurn% = 0 THEN Switch% = False: EXIT DO
						DestSwitch% = PlayerSelect
						IF DestSwitch% = 0 THEN
								CharTurn% = 0
							ELSE
								Switch% = True: EXIT DO
						END IF
					LOOP
					IF Switch% THEN
						SWAP Party(CharTurn%), Party(DestSwitch%)
						FOR i% = 1 TO 20
							SWAP Magic(CharTurn%, i%), Magic(DestSwitch%, i%)
							SWAP SPNeed%(CharTurn%, i%), SPNeed%(DestSwitch%, i%)
						NEXT i%
					END IF
					CursorX% = 225: CursorY% = 20
					CharTurn% = 0: MenuBox 0
				END IF

				IF CursorY% = 70 THEN MenuDone% = True: Quit% = True

				IF CursorY% = 80 THEN
					IF INSTR(MapInfo.sMapName, "Paravia") OR BYTE(Map(NPCs(CameraOn%).x, NPCs(CameraOn%).y).byLayer1) = 4 THEN
						CursorY% = 89: CursorX% = 90
						MenuBox 1
						DO
							SELECT CASE INKEY$
								CASE CHR$(0) + CHR$(72)
									DEF SEG = 0: POKE &H41A, PEEK(&H41C): DEF SEG 'clear keyboard buffer
									CursorY% = CursorY% - 10
									IF CursorY% = 79 THEN CursorY% = 89
									MenuBox 1
									DSPlaySample 1
								CASE CHR$(0) + CHR$(80)
									DEF SEG = 0: POKE &H41A, PEEK(&H41C): DEF SEG 'clear keyboard buffer
									CursorY% = CursorY% + 10
									IF CursorY% = 109 THEN CursorY% = 99
									MenuBox 1
									DSPlaySample 1
								CASE CHR$(13)
									IF CursorY% = 89 THEN
										CursorX% = 5: CursorY% = 30
										DO
											SELECT CASE SaveLoadInput%(2)
												CASE 30
													SaveLoad "save1.sav", 1
												CASE 95
													SaveLoad "save2.sav", 1
												CASE 160
													SaveLoad "save3.sav", 1
												CASE 0
													Done% = True
											END SELECT
										LOOP UNTIL Done%
									END IF

									IF CursorY% = 99 THEN Done% = True
							END SELECT
						LOOP UNTIL Done%
						Done% = False: CursorX% = 225: CursorY% = 20: MenuBox 0
					END IF
				END IF
				IF CursorY% = 90 THEN MenuDone% = True
		END SELECT
	LOOP UNTIL MenuDone%
	ShowDormant

END SUB

SUB InitStats

	FOR i% = 1 TO 4
		Party(i%).Title = "": Party(i%).HP = 0: Party(i%).HPMax = 0
		Party(i%).ST = 0: Party(i%).DF = 0: Party(i%).Dex = 0
		Party(i%).NextLv = 0: Party(i%).MS = 0: Party(i%).WepAtk = 0
		Party(i%).MDF = 0: Party(i%).Lev = 0: Party(i%).Vit = 0
		Party(i%).WepName = "": Party(i%).ArmName = "": Party(i%).ArmDF = 0
		Party(i%).Alive = False: Party(i%).Ex = 0: Party(i%).RunicEq = ""
		Party(i%).OnTeam = False: Party(i%).SP = 0: Party(i%).SPMAX = 0
		Party(i%).Status = 1
		FOR j% = 1 TO 20
			Magic$(i%, j%) = "": SPNeed%(i%, j%) = 0
		NEXT j%
	NEXT i%

	FileNum% = FREEFILE
	OPEN "data\nick.chr" FOR BINARY AS #FileNum%
		GET #FileNum%, , Ver
		GET #FileNum%, , Party(1)
	CLOSE #FileNum%
	Party(1).OnTeam = True: Party(1).Alive = True
	Party(1).Status = 1

	Cal& = 300

	Time.TotalTime = 0
	Time.TimePlayed = ""
	Time.TimeOn = 0

	FOR i% = 0 TO 2
		PartDef%(i%) = 0
	NEXT i%

	Boat.BoatOn = False
	Boat.x = 0
	Boat.y = 0

	FOR i% = 1 TO 18
		Item(1, i%).ItemID = 0
		Item(1, i%).Quantity = 0
	NEXT i%

	FOR i% = 1 TO 50
		ChestStatus%(i%) = 0
	NEXT i%

	DialogCol% = 56
	Item(1, 1).ItemID = 1
	Item(1, 1).Quantity = 5

	Result% = GiveItem("SP Potion")
	Result% = GiveItem("Life Runic")

END SUB

SUB Inn (Cost%)

	Result% = ChoiceBox%

	IF Result% THEN
		IF Cal& >= Cost% THEN
				FOR i% = 1 TO 5
					IF Party(i%).OnTeam THEN
						Party(i%).Status = 1
						Party(i%).Alive = True
						Party(i%).HP = Party(i%).HPMax
						Party(i%).SP = Party(i%).SPMAX
					END IF
				NEXT i%
				FadePal 0: CLS
				LoadMusic "rest.mod", 1
				gswait 230: ShowDormant
				LoadMusic MapInfo.sMapMusic, 1
				FadePal 1
				DialogBox True, 0, 135, 319, 199, 56
				gsprint 1, 5, 140, "Innkeeper: I hope you had a fine rest.", 31
				gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
				Cal& = Cal& - Cost%
				WHILE INKEY$ <> CHR$(13): WEND
			ELSEIF Cal& < Cost% THEN
				CALL ShowDormant
				DialogBox True, 0, 135, 319, 199, 56
				gsprint 1, 5, 140, "Innkeeper: You don't have enoght Cal.", 31
				gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
				WHILE INKEY$ <> CHR$(13): WEND
		END IF
	END IF

	IF NOT Result% THEN
		DialogBox True, 0, 135, 319, 199, 56
		gsprint 1, 5, 140, "Innkeeper: Oh that's too bad. Come", 31
		gsprint 1, 5, 150, "again!", 31
		gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
		WHILE INKEY$ <> CHR$(13): WEND
	END IF

END SUB

REM $STATIC
SUB ItemQuery (ItemID%, ItemData AS ItemTYPE)

	DIM TempItem AS ItemTYPE

	IF ItemID% = 0 THEN
		ItemData = TempItem
		EXIT SUB
	END IF

	FileNum% = FREEFILE
	OPEN "data\items.itm" FOR BINARY AS #FileNum%
		GET #FileNum%, , NumItems%
		FOR i% = 1 TO ItemID%
			GET #FileNum%, , ItemData
		NEXT i%
	CLOSE #FileNum%

END SUB

REM $DYNAMIC
SUB LevelUp

	DIM SpellD AS SpDatTYPE

	CursorX% = 7: CursorY% = 20
	Refresh% = True: PartyOrdered% = False
	DO
		IF Refresh% THEN
			DialogBox True, 0, 0, 319, 199, 56
			y1% = 15: y2% = 25: y3% = 35
			FOR i% = 1 TO 5
				IF Party(i%).OnTeam THEN
				SELECT CASE Party(i%).Status
					CASE 1
						col% = 31
					CASE 2
						col% = 74
				END SELECT
				ShowSprite Party(i%).Portrait, 25, y1%, 0, 20, 0
				gsprint 1, 70, y1%, Party(i%).Title, col%
				gsprint 1, 110, y1%, "Level:" + STR$(Party(i%).Lev), col%
				gsprint 1, 70, y2%, "HP:" + STR$(Party(i%).HP) + "/" + STR$(Party(i%).HPMax), 31
				gsprint 1, 70, y3%, "SP:" + STR$(Party(i%).SP) + "/" + STR$(Party(i%).SPMAX), 31
				y1% = y1% + 30: y2% = y2% + 30: y3% = y3% + 30
				END IF
			NEXT i%
			IF PlayerSel% <> 0 THEN
				ShowSprite "pointer.spr", OldX%, OldY%, 0, 20, 0
			END IF
			ShowSprite "pointer.spr", CursorX%, CursorY%, 0, 20, 0
			gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
			Refresh% = False
		END IF
		SELECT CASE INKEY$
			CASE CHR$(0) + CHR$(80)               ' Code for down arrow key.
				CursorY% = CursorY% + 34
				IF CursorY% = 190 THEN CursorY% = 156
				Refresh% = True
			CASE CHR$(0) + CHR$(72)               ' Code for up arrow key.
				CursorY% = CursorY% - 34
				IF CursorY% = -14 THEN CursorY% = 20
				Refresh% = True
			CASE CHR$(13)                          ' Code for the Enter Key
				Refresh% = True
				IF CursorY% = 20 THEN
						i% = 1
					ELSEIF CursorY% = 54 THEN
						i% = 2
					ELSEIF CursorY% = 88 THEN
						i% = 3
					ELSEIF CursorY% = 122 THEN
						i% = 4
					ELSEIF CursorY% = 156 THEN
						i% = 5
				END IF
				Party(i%).Ex = Party(i%).NextLv
				IF Party(i%).Ex > 999999 THEN Party(i%).Ex = 999999
				IF Party(i%).Ex >= Party(i%).NextLv AND Party(i%).Lev < 99 AND Party(i%).OnTeam THEN
					MessageBar RTRIM$(Party(i%).Title) + " gained a level!"
					WHILE INKEY$ <> CHR$(13): WEND
					FileNum% = FREEFILE
					OPEN "data\" + Party(i%).Bonus FOR INPUT AS #FileNum%
						INPUT #FileNum%, BaseEx%, ST%, DF%, Dex%, MS%, MDF%, Vit%
					CLOSE #FileNum%
					Party(i%).Lev = Party(i%).Lev + 1
					Party(i%).NextLv = BaseEx% * Party(i%).Lev ^ 2
					Party(i%).ST = Party(i%).ST + INT(RND * ST%)
					Party(i%).DF = Party(i%).DF + INT(RND * DF%)
					Party(i%).HPMax = Party(i%).HPMax + Party(i%).Vit
					Party(i%).HP = Party(i%).HP + Party(i%).Vit
					Party(i%).Dex = Party(i%).Dex + INT(RND * Dex%)
					Party(i%).MS = Party(i%).MS + INT(RND * MS%)
					Party(i%).MDF = Party(i%).MDF + INT(RND * MDF%)
					Party(i%).Vit = Party(i%).Vit + INT(RND * Vit%)
					FileNum% = FREEFILE
					OPEN "data\" + Party(i%).SpellData FOR BINARY AS #FileNum%
						GET #FileNum%, , NumSpells%
						FOR j% = 1 TO NumSpells
							GET #FileNum%, , SpellD
							IF Party(i%).Lev >= SpellD.Level AND RTRIM$(Party(i%).RunicEq) = RTRIM$(SpellD.Runic) OR RTRIM$(SpellD.Runic) = "None" THEN
								IF RTRIM$(Magic$(i%, SpellD.Subscript)) <> RTRIM$(SpellD.Title) THEN
									Magic$(i%, SpellD.Subscript) = RTRIM$(SpellD.Title)
									SPNeed%(i%, SpellD.Subscript) = SpellD.SP
									MessageBar RTRIM$(Party(i%).Title) + " learned " + RTRIM$(SpellD.Title)
									WHILE INKEY$ <> CHR$(13): WEND
								END IF
							END IF
						NEXT j%
					CLOSE #FileNum%
				END IF
			CASE CHR$(0) + CHR$(83)
				EXIT SUB
		END SELECT
	LOOP

END SUB

SUB LoadMember (sFile$, Level%)

	RANDOMIZE TIMER
	DIM SpellD AS SpDatTYPE
	DIM Ver AS INTEGER
	DIM Member AS CharTYPE

	FOR i% = 1 TO 5
		SELECT CASE RTRIM$(Party(i%).Title)
			CASE "Nick", "Cerl", "Ariel", "Dane"
				'Do nothing
			CASE ELSE
				FileNum% = FREEFILE
				OPEN "data\" + sFile$ FOR BINARY AS #FileNum%
					GET #FileNum%, , Ver
					GET #FileNum%, , Party(i%)
				CLOSE #FileNum%
				Party(i%).OnTeam = True: Party(i%).Alive = True: Party(i%).Status = 1
				OPEN "data\" + Party(i%).Bonus FOR INPUT AS #FileNum%
					INPUT #FileNum%, BaseEx%, ST%, DF%, Dex%, MS%, MDF%, Vit%
				CLOSE #FileNum%
				FOR j% = Party(i%).Lev TO Level% - 1
					Party(i%).Lev = Party(i%).Lev + 1
					Party(i%).NextLv = BaseEx% * Party(i%).Lev ^ 2
					Party(i%).ST = Party(i%).ST + INT(RND * ST%)
					Party(i%).DF = Party(i%).DF + INT(RND * DF%)
					Party(i%).HPMax = Party(i%).HPMax + Party(i%).Vit
					Party(i%).HP = Party(i%).HP + Party(i%).Vit
					Party(i%).Dex = Party(i%).Dex + INT(RND * Dex%)
					Party(i%).MS = Party(i%).MS + INT(RND * MS%)
					Party(i%).MDF = Party(i%).MDF + INT(RND * MDF%)
					Party(i%).Vit = Party(i%).Vit + INT(RND * Vit%)
					FileNum% = FREEFILE
					OPEN "data\" + Party(i%).SpellData FOR BINARY AS #FileNum%
						GET #FileNum%, , NumSpells%
						FOR h% = 1 TO NumSpells
							GET #FileNum%, , SpellD
							IF Party(i%).Lev = SpellD.Level AND RTRIM$(Party(i%).RunicEq) = RTRIM$(SpellD.Runic) OR RTRIM$(SpellD.Runic) = "None" THEN
								Magic$(i%, SpellD.Subscript) = RTRIM$(SpellD.Title)
								SPNeed%(i%, SpellD.Subscript) = SpellD.SP
							END IF
						NEXT h%
					CLOSE #FileNum%
				NEXT j%
				Party(i%).Ex = BaseEx% * (Party(i%).Lev - 1) ^ 2
				EXIT FOR
		END SELECT
	NEXT i%

END SUB

REM $STATIC
SUB LoadMusic (file$, Channel%)

	DSRemoveMusic Channel%
	DSLoadMusic "music\" + file$, 1, Channel%, 1, 0

END SUB

REM $DYNAMIC
SUB MainLoop

	LoadPal
	FontLoad "normal.fnt"
	FadePal 0
	DEF SEG = &HA000: BLOAD "venosoft.fsi", 0: DEF SEG
	FadePal 1
	DSPlaySample 5
	gswait 100
	FadePal 0
	LoadMusic "intro.it", 1
	DEF SEG = VARSEG(Buffer&(0)): BLOAD "title.fsi", VARPTR(Buffer&(0)): DEF SEG
	gsprint 1, 126, 171, "Press Enter...", 30
	gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
	FadePal 1
	WHILE INKEY$ = CHR$(13): WEND
	WHILE INKEY$ <> CHR$(13): WEND
	DO
		ItemPage% = 1
		MainMenu
		IF PlayGame% THEN
			Time.TimeStarted = TIMER
			GameLoop
			CursorX% = 115: CursorY% = 100
			DrawMainMenu
			FadePal 1
		END IF
	LOOP UNTIL ExitGame%
	FadePal 0

END SUB

REM $STATIC
SUB MainMenu

	IF NOT PlayGame THEN
		CursorX% = 115: CursorY% = 100
		DrawMainMenu
		RunOff% = True
	END IF
	PlayGame% = False
	DO
		SELECT CASE INKEY$
			CASE CHR$(0) + CHR$(72)
				CursorY% = CursorY% - 20
				IF CursorY% = 80 THEN CursorY% = 100
				DrawMainMenu
				DSPlaySample 1
			CASE CHR$(0) + CHR$(80)
				CursorY% = CursorY% + 20
				IF CursorY% = 160 THEN CursorY% = 140
				DrawMainMenu
				DSPlaySample 1
			CASE CHR$(13)
				ChoiceMade% = True
				IF CursorY% = 100 THEN
						PlayGame% = True
						NewGame
					ELSEIF CursorY% = 120 THEN
						Result% = Continue%
						IF Result% THEN PlayGame% = True
						IF NOT Result% THEN PlayGame% = False
					ELSEIF CursorY% = 140 THEN
						ExitGame% = True
				END IF
		END SELECT
	LOOP UNTIL ChoiceMade%
	ChoiceMade% = False

END SUB

REM $DYNAMIC
SUB MenuBox (Menu%)

	DIM ItemD AS ItemTYPE

	CALL GetTime: StaticMap
	DialogBox True, 0, 0, 210, 199, 56

	DialogBox True, 211, 0, 319, 110, 56

	DialogBox True, 211, 140, 319, 179, 56

	DialogBox True, 170, 180, 319, 199, 56

	y1% = 15: y2% = 25: y3% = 35
	FOR i% = 1 TO 3
		IF Party(i%).OnTeam THEN
			SELECT CASE Party(i%).Status
				CASE 1
					col% = 31
				CASE 2
					col% = 74
			END SELECT
			gsprint 1, 70, y1%, Party(i%).Title, col%
			gsprint 1, 110, y1%, "Level:" + STR$(Party(i%).Lev), col%
			gsprint 1, 70, y2%, "HP:" + STR$(Party(i%).HP) + "/" + STR$(Party(i%).HPMax), 31
			gsprint 1, 70, y3%, "SP:" + STR$(Party(i%).SP) + "/" + STR$(Party(i%).SPMAX), 31
		END IF
		y1% = y1% + 30: y2% = y2% + 30: y3% = y3% + 30
	NEXT i%

	gsprint 1, 240, 20, "Stats", 31
	gsprint 1, 240, 30, "Item", 31
	gsprint 1, 240, 40, "Magic", 31
	gsprint 1, 240, 50, "Weapons", 31
	gsprint 1, 240, 60, "Order", 31
	gsprint 1, 240, 70, "End Game", 31
	IF MapInfo.sMapName <> "Paravia" THEN gsprint 1, 240, 80, "Save", 25
	IF INSTR(MapInfo.sMapName, "Paravia") OR BYTE(Map(NPCs(CameraOn%).x, NPCs(CameraOn%).y).byLayer1) = 4 THEN gsprint 1, 240, 80, "Save", 31
	gsprint 1, 240, 90, "Exit", 31
	gsprint 1, 216, 145, "Time: " + Time.TimePlayed, 31
	gsprint 1, 216, 155, "Cal:" + STR$(Cal&), 31
	gsprint 1, 175, 184, MapInfo.sMapName, 31
	IF Party(1).OnTeam THEN ShowSprite Party(1).Portrait, 25, 10, 0, 20, 0
	IF Party(2).OnTeam THEN ShowSprite Party(2).Portrait, 25, 44, 0, 20, 0
	IF Party(3).OnTeam THEN ShowSprite Party(3).Portrait, 25, 78, 0, 20, 0

	IF Menu% = 1 OR Menu% = 2 THEN
		DialogBox True, 64, 48, 256, 144, 56
	END IF

	IF Menu% = 1 THEN
		IF Board% > 0 THEN gsprint 1, 69, 53, "Save Point...", 31
		gsprint 1, 74, 69, "Do you wish to save?", 31
		gsprint 1, 105, 89, "[Yes]", 31: gsprint 1, 105, 99, "[No]", 31
	END IF

	IF Menu% = 2 THEN
		gsprint 1, 69, 53, "Which slot...", 31
		gsprint 1, 105, 89, "[Slot 1]", 31: gsprint 1, 105, 99, "[Slot 2]", 31
		gsprint 1, 105, 109, "[Slot 3]", 31
	END IF

	IF Menu% = 4 THEN
		DialogBox True, 168, 0, 319, 199, 56

		FOR i% = 1 TO 18
			ItemQuery Item(ItemPage%, i%).ItemID, ItemD
			gsprint 1, 191, 10 * i%, ItemD.Title, 31
			IF Item(ItemPage%, i%).Quantity <> 0 THEN gsprint 1, 191, 10 * i%, SPACE$(12) + STR$(Item(ItemPage%, i%).Quantity), 31
		NEXT i%
		CharTurn% = CursorY% / 10
		ItemQuery Item(ItemPage%, CharTurn%).ItemID, ItemD
		IF CharTurn% <= 15 THEN y% = 160
		IF CharTurn% > 15 THEN y% = 130
		CharTurn% = 0
		DialogBox True, 0, y, 319, y + 18, 56
		gsprint 1, Center(RTRIM$(ItemD.Description)), y% + 4, RTRIM$(ItemD.Description), 31
	END IF

	IF Menu% = 6 THEN
		DialogBox True, 168, 0, 319, 199, 56

		FOR i% = 1 TO 20
			gsprint 1, 191, 10 * i%, Magic$(CharTurn%, i%), 31
			IF SPNeed%(CharTurn%, i%) <> 0 THEN gsprint 1, 191, 10 * i%, SPACE$(12) + STR$(SPNeed%(CharTurn%, i%)), 31
		NEXT i%
	END IF

	IF Menu% = 7 THEN
		SELECT CASE CharTurn%
			CASE 1
				ShowSprite "pointer.spr", 7, 20, 0, 20, 0
			CASE 2
				ShowSprite "pointer.spr", 7, 54, 0, 20, 0
			CASE 3
				ShowSprite "pointer.spr", 7, 88, 0, 20, 0
		END SELECT
	END IF
	ShowSprite "pointer.spr", CursorX%, CursorY%, 0, 20, 0

	IF Menu% = 3 THEN
		DialogBox True, 80, 18, 266, 196, 56
		SELECT CASE RTRIM$(Party(CharTurn%).Title)
			CASE "Nick"
				Name1$ = "Nick Ambrioth"
			CASE "Cerl"
				Name1$ = "Cerl Ambrioth"
			CASE "Ariel"
				Name1$ = "Ariel Serin"
			CASE "Dane"
				Name1$ = "Dane Cirace"
			CASE "Edwin"
				Name1$ = "Edwin Senil"
		END SELECT
		SELECT CASE Party(CharTurn%).Status
			CASE 1
				col% = 31
			CASE 2
				col% = 74
		END SELECT
		gsprint 1, 85, 23, Name1$, col%
		gsprint 1, 85, 33, "Level:" + STR$(Party(CharTurn%).Lev), 31
		gsprint 1, 85, 43, "HP:" + STR$(Party(CharTurn%).HP) + "/" + STR$(Party(CharTurn%).HPMax), 31
		gsprint 1, 85, 53, "SP:" + STR$(Party(CharTurn%).SP) + "/" + STR$(Party(CharTurn%).SPMAX), 31
		gsprint 1, 85, 63, "Strenght:" + STR$(Party(CharTurn%).ST), 31
		gsprint 1, 85, 73, "Dexterity:" + STR$(Party(CharTurn%).Dex), 31
		gsprint 1, 85, 83, "Vitality:" + STR$(Party(CharTurn%).Vit), 31
		gsprint 1, 85, 93, "Magic Str.:" + STR$(Party(CharTurn%).MS), 31
		gsprint 1, 85, 103, "Magic Def.:" + STR$(Party(CharTurn%).MDF), 31

		gsprint 1, 85, 123, "Attack:" + STR$(Party(CharTurn%).ST + Party(CharTurn%).WepAtk), 31
		gsprint 1, 85, 133, "Defense:" + STR$(Party(CharTurn%).DF + Party(CharTurn%).ArmDF), 31
		gsprint 1, 85, 143, "Weapon: " + Party(CharTurn%).WepName, 31
		gsprint 1, 85, 153, "Armor: " + Party(CharTurn%).ArmName, 31
		gsprint 1, 85, 163, "Runic: " + Party(CharTurn%).RunicEq, 31
		gsprint 1, 85, 173, "Exp:" + STR$(Party(CharTurn%).Ex), 31
		gsprint 1, 85, 183, "Exp Left:" + STR$(Party(CharTurn%).NextLv - Party(CharTurn%).Ex), 31
	END IF

	IF Menu% = 5 THEN
		DialogBox True, 1, 1, 270, 199, 56

		gsprint 1, 25, 10, Party(1).Title, 31
		gsprint 1, 25, 20, "Weapon: " + Party(1).WepName, 31
		gsprint 1, 25, 30, "Atk:" + STR$(Party(1).WepAtk) + " >" + STR$(Party(1).Lev), 31

		IF Party(2).OnTeam THEN
			gsprint 1, 25, 50, Party(2).Title, 31
			gsprint 1, 25, 60, "Weapon: " + Party(2).WepName, 31
			gsprint 1, 25, 70, "Atk:" + STR$(Party(2).WepAtk) + " >" + STR$(Party(2).Lev), 31
		END IF

		IF Party(3).OnTeam THEN
			gsprint 1, 25, 90, Party(3).Title, 31
			gsprint 1, 25, 100, "Weapon: " + Party(3).WepName, 31
			gsprint 1, 25, 110, "Atk:" + STR$(Party(3).WepAtk) + " >" + STR$(Party(3).Lev), 31
		END IF

	END IF

	gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0

END SUB

REM $STATIC
SUB NewGame

	CameraOn% = 0
	DSRemoveMusic 1
	LoadMusic "fate.it", 1
	FadePal 0
	gsfill &HA000, 0, 0
	gsprint 0, 100, 100, "The Rith Saga...", 31
	FadePal 1
	gswait 100
	FadePal 0
	gsfill &HA000, 0, 0
	gsprint 0, 0, 0, "Chapter 1's Summary: Cai's Quest", 31
	gsprint 0, 15, 10, "In year 1200 of Rith History, a boy", 31
	gsprint 0, 5, 20, "named Cai met with destiny...  Seeing  ", 31
	gsprint 0, 5, 30, "his father killed he vowed to defeat   ", 31
	gsprint 0, 5, 40, "the man who had slain him, the dictator", 31
	gsprint 0, 5, 50, "Magnus.  However Cai was intertwined   ", 31
	gsprint 0, 5, 60, "into the fate of Rith as Magnus with   ", 31
	gsprint 0, 5, 70, "the help of the evil prophet Viatar,   ", 31
	gsprint 0, 5, 80, "tried to awaken a powerful Runic of    ", 31
	gsprint 0, 5, 90, "destruction...  Cai Ambrioth stopped   ", 31
	gsprint 0, 5, 100, "the Cosmic Runic with the aid of Kyra ", 31
	gsprint 0, 5, 110, "Serene and the Fate Runic...and faded ", 31
	gsprint 0, 5, 120, "into history...", 31
	FadePal 1
	WHILE INKEY$ = "": WEND
	FadePal 0
	gsfill &HA000, 0, 0
	gsprint 0, 0, 0, "Chapter 2's Summary: Cai's Quest 2", 31
	gsprint 0, 15, 10, "In year 1250 of Rith History, Nick", 31
	gsprint 0, 5, 20, "Ambrioth, the Son of Cai, had to stop  ", 31
	gsprint 0, 5, 30, "yet another threat to Paravia and      ", 31
	gsprint 0, 5, 40, "Rith's safety.  The prophet Viatar had ", 31
	gsprint 0, 5, 50, "not been killed by Cai and he was using", 31
	gsprint 0, 5, 60, "the insane son of Magnus to exact      ", 31
	gsprint 0, 5, 70, "revenge... Fane wanted to use the      ", 31
	gsprint 0, 5, 80, "awesome power of the Comsic Sword/Runic", 31
	gsprint 0, 5, 90, "pair to meld Rith with a passing star. ", 31
	gsprint 0, 5, 100, "Falling in love with Cerl, Nick       ", 31
	gsprint 0, 5, 110, "defeated Fane and his father died in  ", 31
	gsprint 0, 5, 120, "peace...", 31
	FadePal 1
	WHILE INKEY$ = "": WEND
	FadePal 0
	gsfill &HA000, 0, 0
	gsprint 0, 0, 0, "Chapter 3's Summary: Clans of Rith", 31
	gsprint 0, 15, 10, "In year 1245 of Rith History, on the", 31
	gsprint 0, 5, 20, "continent of Aventor, Sakura Depthsheld", 31
	gsprint 0, 5, 30, "awoke to destiny...  her clan was      ", 31
	gsprint 0, 5, 40, "attacked by Clan Grevier.  In the      ", 31
	gsprint 0, 5, 50, "ensuing battle she and her father were ", 31
	gsprint 0, 5, 60, "cast out and her father was later      ", 31
	gsprint 0, 5, 70, "killed by Clan leader Saveril Grevier. ", 31
	gsprint 0, 5, 80, "As Sakura finds out later on, it's her ", 31
	gsprint 0, 5, 90, "destiny to destory Saveril and hence   ", 31
	gsprint 0, 5, 100, "the reason Saveril wanted her clan    ", 31
	gsprint 0, 5, 110, "dead. It also seems yet another       ", 31
	gsprint 0, 5, 120, "prophet wants to use the Runics for   ", 31
	gsprint 0, 5, 130, "evil purposes. Sakura stops the prophet", 31
	gsprint 0, 5, 140, "and Saveril...thus restoring peace to  ", 31
	gsprint 0, 5, 150, "Aventor...", 31
	FadePal 1
	WHILE INKEY$ = "": WEND
	FadePal 0
	gsfill &HA000, 0, 0
	gsprint 0, 0, 0, "Chapter 4's Summary: Cai's Quest 3", 31
	gsprint 0, 15, 10, "Fate has yet to inscribe this chapter", 31
	gsprint 0, 5, 20, "into Rith's history... but here, year  ", 31
	gsprint 0, 5, 30, "1255 of Rith's History... let the      ", 31
	gsprint 0, 5, 40, "writing commence...", 31
	FadePal 1
	WHILE INKEY$ = "": WEND
	InitStats
	MapFile$ = "caiclan2.map"
	DIM Temp AS TileDataTYPE
	Temp.sFileName = "caiclan2.map"
	Temp.x = 15
	Temp.y = 16
	ViewMap Temp
	FadePal 1
	Map(NPCs(1).x, NPCs(1).y).bWalkable = True
	Script "data\edwin.scr"

END SUB

FUNCTION NpcVisible (NPC%)

	IF PartDef(BYTE(NPCs(NPC%).byFlag)) = NPCs(NPC%).iWhenEnabled OR NPCs(NPC%).iWhenEnabled = -1 THEN
			NpcVisible = True
		ELSE
			NpcVisible = False
			Map(NPCs(NPC%).x, NPCs(NPC%).y).bWalkable = True
	END IF

END FUNCTION

SUB PartyOrder

	CursorX% = 7: CursorY% = 20
	Refresh% = True: PartyOrdered% = False
	DO
		IF Refresh% THEN
			DialogBox True, 0, 0, 319, 199, 56
			y1% = 15: y2% = 25: y3% = 35
			FOR i% = 1 TO 5
				SELECT CASE Party(i%).Status
					CASE 1
						col% = 31
					CASE 2
						col% = 74
				END SELECT
				ShowSprite Party(i%).Portrait, 25, y1%, 0, 20, 0
				gsprint 1, 70, y1%, Party(i%).Title, col%
				gsprint 1, 110, y1%, "Level:" + STR$(Party(i%).Lev), col%
				gsprint 1, 70, y2%, "HP:" + STR$(Party(i%).HP) + "/" + STR$(Party(i%).HPMax), 31
				gsprint 1, 70, y3%, "SP:" + STR$(Party(i%).SP) + "/" + STR$(Party(i%).SPMAX), 31
				y1% = y1% + 30: y2% = y2% + 30: y3% = y3% + 30
			NEXT i%
			IF PlayerSel% <> 0 THEN
				ShowSprite "pointer.spr", OldX%, OldY%, 0, 20, 0
			END IF
			ShowSprite "pointer.spr", CursorX%, CursorY%, 0, 20, 0
			gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
			Refresh% = False
		END IF
		SELECT CASE INKEY$
			CASE CHR$(0) + CHR$(80)               ' Code for down arrow key.
				CursorY% = CursorY% + 34
				IF CursorY% = 190 THEN CursorY% = 156
				Refresh% = True
			CASE CHR$(0) + CHR$(72)               ' Code for up arrow key.
				CursorY% = CursorY% - 34
				IF CursorY% = -14 THEN CursorY% = 20
				Refresh% = True
			CASE CHR$(13)                          ' Code for the Enter Key
				Refresh% = True
				IF PlayerSel% = 0 THEN
						IF CursorY% = 20 THEN
								PlayerSel% = 1
							ELSEIF CursorY% = 54 THEN
								PlayerSel% = 2
							ELSEIF CursorY% = 88 THEN
								PlayerSel% = 3
							ELSEIF CursorY% = 122 THEN
								PlayerSel% = 4
							ELSEIF CursorY% = 156 THEN
								PlayerSel% = 5
						END IF
						OldX% = CursorX%: OldY% = CursorY%
					ELSE
						IF CursorY% = 20 THEN
								PlayerSel2% = 1
							ELSEIF CursorY% = 54 THEN
								PlayerSel2% = 2
							ELSEIF CursorY% = 88 THEN
								PlayerSel2% = 3
							ELSEIF CursorY% = 122 THEN
								PlayerSel2% = 4
							ELSEIF CursorY% = 156 THEN
								PlayerSel2% = 5
						END IF
						SWAP Party(PlayerSel%), Party(PlayerSel2%)
						FOR i% = 1 TO 20
							SWAP Magic(PlayerSel%, i%), Magic(PlayerSel2%, i%)
							SWAP SPNeed%(PlayerSel%, i%), SPNeed%(PlayerSel2%, i%)
						NEXT i%
						PlayerSel% = 0: PlayerSel2% = 0
				END IF
			CASE CHR$(0) + CHR$(83)
				PartyOrdered% = True
		END SELECT
	LOOP UNTIL PartyOrdered%

END SUB

SUB PartySwitch (Char1$, Slot%, Switch%)

	SELECT CASE Switch%
		CASE 0
			FOR i% = 1 TO 5
				IF RTRIM$(Party(i%).Title) = RTRIM$(Char1$) THEN
					Party(i%).HP = Party(i%).HPMax
					Party(i%).Alive = False
					Party(i%).OnTeam = False
					EXIT FOR
				END IF
			NEXT i%
		CASE -1
			FOR i% = 1 TO 5
				IF RTRIM$(Party(i%).Title) = RTRIM$(Char1$) THEN
					Party(i%).Alive = True
					Party(i%).OnTeam = True
					EXIT FOR
				END IF
			NEXT i%
		CASE 2
			'Do Nothing
	END SELECT

	IF NOT Slot% = 0 THEN
		FOR i% = 1 TO 5
			IF RTRIM$(Party(i%).Title) = RTRIM$(Char1$) THEN
				SWAP Party(i%), Party(Slot%)
				FOR j% = 1 TO 20
					SWAP Magic(i%, j%), Magic(Slot%, j%)
					SWAP SPNeed%(i%, j%), SPNeed%(Slot%, j%)
				NEXT j%
				EXIT FOR
			END IF
		NEXT i%
	END IF

END SUB

REM $DYNAMIC
FUNCTION PlayerSelect%

	CursorX% = 7: CursorY% = 20
	MenuBox 7
	FOR i% = 1 TO 3
		IF Party(i%).OnTeam THEN Temp% = Temp% + 1
	NEXT i%
	EndY% = -14 + (Temp% * 34)
	DO
		SELECT CASE INKEY$
			CASE CHR$(0) + CHR$(72)
				CursorY% = CursorY% - 34
				IF CursorY% = -14 THEN CursorY% = 20
				MenuBox 7
			CASE CHR$(0) + CHR$(80)
				CursorY% = CursorY% + 34
				IF CursorY% = EndY% + 34 THEN CursorY% = EndY%
				MenuBox 7
			CASE CHR$(13)
				IF CursorY% = 20 THEN
						PlayerSelect% = 1
					ELSEIF CursorY% = 54 THEN
						PlayerSelect% = 2
					ELSEIF CursorY% = 88 THEN
						PlayerSelect% = 3
				END IF
					Done% = True
			CASE CHR$(0) + CHR$(83)
				PlayerSelect% = False: Done% = True
		END SELECT
	LOOP UNTIL Done%

END FUNCTION

REM $STATIC
FUNCTION SaveLoadInput% (SaveL%)

	DIM Time1(3) AS TimeTYPE
	DIM Party1(3) AS CharTYPE
	DIM Party2(3) AS CharTYPE
	DIM Party3(3) AS CharTYPE
	DIM Header1 AS STRING * 7
	DIM Header2 AS STRING * 7
	DIM Header3 AS STRING * 7

	DIM MapFile1 AS STRING * 12
	DIM MapFile2 AS STRING * 12
	DIM MapFile3 AS STRING * 12

	DIM MapName1 AS STRING * 30
	DIM MapName2 AS STRING * 30
	DIM MapName3 AS STRING * 30

	WHILE INKEY$ <> "": WEND
	FileNum% = FREEFILE
	OPEN "saved\save1.sav" FOR BINARY AS #FileNum%
		GET #FileNum%, , Header1$
		IF RTRIM$(Header1$) = "Data" THEN
			GET #FileNum%, , Time1(0)
			GET #FileNum%, , MapName1$
			GET #FileNum%, , MapFile1$
			GET #FileNum%, , Cal1&

			FOR i% = 0 TO 2
				GET #FileNum%, , Party1(i%)
			NEXT i%
		END IF
	CLOSE #FileNum%

	OPEN "saved\save2.sav" FOR BINARY AS #FileNum%
		GET #FileNum%, , Header2$
		IF RTRIM$(Header2$) = "Data" THEN
			GET #FileNum%, , Time1(1)
			GET #FileNum%, , MapName2$
			GET #FileNum%, , MapFile2$
			GET #FileNum%, , Cal2&

			FOR i% = 0 TO 2
				GET #FileNum%, , Party2(i%)
			NEXT i%
		END IF
	CLOSE #FileNum%

	OPEN "saved\save3.sav" FOR BINARY AS #FileNum%
		GET #FileNum%, , Header3$
		IF RTRIM$(Header3$) = "Data" THEN
			GET #FileNum%, , Time1(2)
			GET #FileNum%, , MapName3$
			GET #FileNum%, , MapFile3$
			GET #FileNum%, , Cal3&

			FOR i% = 0 TO 2
				GET #FileNum%, , Party3(i%)
			NEXT i%
		END IF
	CLOSE #FileNum%

	Refresh% = True: ChoiceMade% = False
	DO
		IF Refresh% THEN
			DEF SEG = VARSEG(Buffer&(0)): BLOAD "continue.fsi", VARPTR(Buffer&(0)): DEF SEG
			IF RTRIM$(Header1$) = "Data" THEN
					ShowSprite Party1(0).Portrait, 25, 15, 0, 32, 0
					IF Party1(1).OnTeam THEN ShowSprite Party1(1).Portrait, 57, 15, 0, 32, 0
					IF Party1(2).OnTeam THEN ShowSprite Party1(2).Portrait, 89, 15, 0, 32, 0
					gsprint 1, 160, 15, Party1(0).Title, 31
					gsprint 1, 230, 15, "Time:" + Time1(0).TimePlayed, 31
					gsprint 1, 160, 25, "Lev:" + STR$(Party1(0).Lev), 31
					gsprint 1, 230, 25, "Cal:" + STR$(Cal1&), 31
					gsprint 1, 180, 45, MapName1$, 31
				ELSEIF Header1$ = "No Data" THEN
					gsprint 1, 135, 30, "No Data", 31
			END IF
			IF RTRIM$(Header2$) = "Data" THEN
					ShowSprite Party2(0).Portrait, 25, 80, 0, 32, 0
					IF Party2(1).OnTeam THEN ShowSprite Party2(1).Portrait, 57, 80, 0, 32, 0
					IF Party2(2).OnTeam THEN ShowSprite Party2(2).Portrait, 89, 80, 0, 32, 0
					gsprint 1, 160, 80, Party2(0).Title, 31
					gsprint 1, 230, 80, "Time:" + Time1(1).TimePlayed, 31
					gsprint 1, 160, 90, "Lev:" + STR$(Party2(0).Lev), 31
					gsprint 1, 230, 90, "Cal:" + STR$(Cal2&), 31
					gsprint 1, 180, 110, MapName2$, 31
				ELSEIF Header2$ = "No Data" THEN
					gsprint 1, 135, 95, "No Data", 31
			END IF
			IF RTRIM$(Header3$) = "Data" THEN
					ShowSprite Party3(0).Portrait, 25, 145, 0, 32, 0
					IF Party3(1).OnTeam THEN ShowSprite Party3(1).Portrait, 57, 145, 0, 32, 0
					IF Party3(2).OnTeam THEN ShowSprite Party3(2).Portrait, 89, 145, 0, 32, 0
					gsprint 1, 160, 145, Party3(0).Title, 31
					gsprint 1, 230, 145, "Time:" + Time1(2).TimePlayed, 31
					gsprint 1, 160, 155, "Lev:" + STR$(Party3(0).Lev), 31
					gsprint 1, 230, 155, "Cal:" + STR$(Cal3&), 31
					gsprint 1, 180, 175, MapName3$, 31
				ELSEIF Header3$ = "No Data" THEN
					gsprint 1, 135, 160, "No Data", 31
			END IF
			ShowSprite "pointer.spr", CursorX%, CursorY%, 0, 20, 0
			gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
			Refresh% = False
		END IF
		SELECT CASE INKEY$
			CASE CHR$(0) + CHR$(80)               ' Code for down arrow key.
				CursorY% = CursorY% + 65
				IF CursorY% = 225 THEN CursorY% = 160
				Refresh% = True
				DSPlaySample 1
			CASE CHR$(0) + CHR$(72)               ' Code for up arrow key.
				CursorY% = CursorY% - 65
				IF CursorY% = -35 THEN CursorY% = 30
				Refresh% = True
				DSPlaySample 1
			CASE CHR$(13)
				IF CursorY% = 30 THEN
						SELECT CASE SaveL%
							CASE 1
								IF RTRIM$(Header1$) = "Data" THEN
									SaveLoadInput% = 30
									ChoiceMade% = True
								END IF
							CASE 2
								SaveLoadInput% = 30
								ChoiceMade% = True
						END SELECT
					ELSEIF CursorY% = 95 THEN
						SELECT CASE SaveL%
							CASE 1
								IF RTRIM$(Header2$) = "Data" THEN
									SaveLoadInput% = 95
									ChoiceMade% = True
								END IF
							CASE 2
								SaveLoadInput% = 95
								ChoiceMade% = True
						END SELECT
					ELSEIF CursorY% = 160 THEN
						SELECT CASE SaveL%
							CASE 1
								IF RTRIM$(Header3$) = "Data" THEN
									SaveLoadInput% = 160
									ChoiceMade% = True
								END IF
							CASE 2
								SaveLoadInput% = 160
								ChoiceMade% = True
						END SELECT
				END IF
			CASE CHR$(0) + CHR$(83)
				SaveLoadInput% = 0: ChoiceMade% = True
		END SELECT
	LOOP UNTIL ChoiceMade%

END FUNCTION

REM $DYNAMIC
SUB ShowChar (Show%, Handle%, x%, y%)

	IF Show = False THEN
		SELECT CASE BYTE(NPCs(Handle%).byFacing)
			CASE FaceUP
				ShowSprite NPCs(Handle%).sSet, x%, y%, 3, 20, 0
			CASE FaceDOWN
				ShowSprite NPCs(Handle%).sSet, x%, y%, 0, 20, 0
			CASE FaceLEFT
				ShowSprite NPCs(Handle%).sSet, x%, y%, 9, 20, 0
			CASE FaceRIGHT
				ShowSprite NPCs(Handle%).sSet, x%, y%, 6, 20, 0
		END SELECT
		EXIT SUB
	END IF

	IF Move(Handle%).MoveType% = 30 THEN Move(Handle%).MoveType% = 0
	IF BYTE(NPCs(Handle%).byFacing) = FaceDOWN THEN
			IF Move(Handle%).MoveType% < 12 THEN
					ShowSprite NPCs(Handle%).sSet, x%, y%, 1, 20, 0
					Move(Handle%).MoveType% = Move(Handle%).MoveType% + 1
				ELSEIF Move(Handle%).MoveType% > 11 AND Move(Handle%).MoveType% < 20 THEN
					ShowSprite NPCs(Handle%).sSet, x%, y%, 0, 20, 0
					Move(Handle%).MoveType% = Move(Handle%).MoveType% + 1
				ELSE
					ShowSprite NPCs(Handle%).sSet, x%, y%, 2, 20, 0
					Move(Handle%).MoveType% = Move(Handle%).MoveType% + 1
			END IF
		ELSEIF BYTE(NPCs(Handle%).byFacing) = FaceUP THEN
			IF Move(Handle%).MoveType% < 12 THEN
					ShowSprite NPCs(Handle%).sSet, x%, y%, 4, 20, 0
					Move(Handle%).MoveType% = Move(Handle%).MoveType% + 1
				ELSEIF Move(Handle%).MoveType% > 11 AND Move(Handle%).MoveType% < 20 THEN
					ShowSprite NPCs(Handle%).sSet, x%, y%, 3, 20, 0
					Move(Handle%).MoveType% = Move(Handle%).MoveType% + 1
				ELSE
					ShowSprite NPCs(Handle%).sSet, x%, y%, 5, 20, 0
					Move(Handle%).MoveType% = Move(Handle%).MoveType% + 1
			END IF
		ELSEIF BYTE(NPCs(Handle%).byFacing) = FaceRIGHT THEN
			IF Move(Handle%).MoveType% < 12 THEN
					ShowSprite NPCs(Handle%).sSet, x%, y%, 7, 20, 0
					Move(Handle%).MoveType% = Move(Handle%).MoveType% + 1
				ELSEIF Move(Handle%).MoveType% > 11 AND Move(Handle%).MoveType% < 20 THEN
					ShowSprite NPCs(Handle%).sSet, x%, y%, 6, 20, 0
					Move(Handle%).MoveType% = Move(Handle%).MoveType% + 1
				ELSE
					ShowSprite NPCs(Handle%).sSet, x%, y%, 8, 20, 0
					Move(Handle%).MoveType% = Move(Handle%).MoveType% + 1
			END IF
		ELSEIF BYTE(NPCs(Handle%).byFacing) = FaceLEFT THEN
			IF Move(Handle%).MoveType% < 12 THEN
					ShowSprite NPCs(Handle%).sSet, x%, y%, 10, 20, 0
					Move(Handle%).MoveType% = Move(Handle%).MoveType% + 1
				ELSEIF Move(Handle%).MoveType% > 11 AND Move(Handle%).MoveType% < 20 THEN
					ShowSprite NPCs(Handle%).sSet, x%, y%, 9, 20, 0
					Move(Handle%).MoveType% = Move(Handle%).MoveType% + 1
				ELSE
					ShowSprite NPCs(Handle%).sSet, x%, y%, 11, 20, 0
					Move(Handle%).MoveType% = Move(Handle%).MoveType% + 1
			END IF
	END IF

END SUB

REM $STATIC
SUB ShowDormant

	StaticMap
	TimerEvent
	IF JustEntered% THEN
		DialogBox True, 0, 180, 149, 199, 56
		gsprint 1, 5, 184, MapInfo.sMapName, 31
	END IF
	gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0

END SUB

SUB SpaceShip

	DialogBox True, 0, 135, 319, 199, 56
	gsprint 1, 5, 140, "Inventor: Ah Sir Nick.  If your ready  ", 31
	gsprint 1, 5, 150, "to go we're ready to send you off.  The", 31
	gsprint 1, 5, 160, "price is 5000 cal.", 31
	gsprint 1, 5, 170, "", 31
	gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0

	Result% = ChoiceBox%

	IF Result% THEN
		IF Cal& >= 5000 THEN
				DialogBox True, 0, 135, 319, 199, 56
				gsprint 1, 5, 140, "Inventor: Thank you Sir Nick.  Hop     ", 31
				gsprint 1, 5, 150, "aboard if you please.", 31
				gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
				Cal& = Cal& - 5000
				WHILE INKEY$ <> CHR$(13): WEND
				PartDef%(0) = 62
				Script "data\blastoff.scr"
			ELSEIF Cal& < 5000 THEN
				CALL ShowDormant
				DialogBox True, 0, 135, 319, 199, 56
				gsprint 1, 5, 140, "Inventor: I'm sorry Sir Nick, but we", 31
				gsprint 1, 5, 150, "seriously do need the money.", 31
				gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
				WHILE INKEY$ <> CHR$(13): WEND
		END IF
	END IF

	IF NOT Result% THEN
		DialogBox True, 0, 135, 319, 199, 56
		gsprint 1, 5, 140, "Inventor: Any time your ready Sir Nick.", 31
		gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
		WHILE INKEY$ <> CHR$(13): WEND
	END IF

END SUB

SUB StaticMap

	a% = 0: b% = 0
	FOR y% = VisibleY% TO VisibleY% + 9
		FOR x% = VisibleX% TO VisibleX% + 15
			VMap = BYTE(Map(x%, y%).byLayer1)
			gssprite a% * 20, b% * 20, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(Tiles(VMap * 202)), VARPTR(Tiles(VMap * 202))
			VMap = BYTE(Map(x%, y%).byLayer2)
			IF VMap <> 0 THEN
				gssprite a% * 20, b% * 20, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(Tiles(VMap * 202)), VARPTR(Tiles(VMap * 202))
			END IF

			IF RTRIM$(MapInfo.sMapName) = "Paravia" THEN
				IF Boat.x = x% AND Boat.y = y% AND NOT Boat.BoatOn THEN
					ShowSprite "Boat.set", a% * 20, b% * 20, 0, 20, 0
				END IF
			END IF

			a% = a% + 1
			IF a% = 16 THEN a% = 0

		NEXT x%
		b% = b% + 1
		IF b% = 10 THEN b% = 0

	NEXT y%

	DEF SEG = 0: POKE &H41A, PEEK(&H41C): DEF SEG 'clear keyboard buffer
	IF RTRIM$(MapInfo.sMapName) = "Boat" THEN
		DEF SEG = VARSEG(Buffer&(0)): BLOAD "bkgs\boat.b", VARPTR(Buffer&(0)): DEF SEG
	END IF

	ShowChar False, CameraOn%, 160, 100
	Spritelayer 0, 0

	IF RunOff% THEN gswait 1

	a% = 0: b% = 0
	FOR y% = VisibleY% TO VisibleY% + 9
		FOR x% = VisibleX% TO VisibleX% + 15

			VMap = BYTE(Map(x%, y%).byLayer3)
			IF VMap <> 0 THEN
				gssprite a% * 20, b% * 20, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(Tiles(VMap * 202)), VARPTR(Tiles(VMap * 202))
			END IF

			a% = a% + 1
			IF a% = 16 THEN a% = 0

		NEXT x%
		b% = b% + 1
		IF b% = 10 THEN b% = 0

	NEXT y%

	IF RTRIM$(MapInfo.sMapName) = "Paravia" THEN
		EffectLayer 1
		EffectLayer 2
	END IF

END SUB

REM $DYNAMIC
SUB VisiblePlane (xDir, yDir)

	IF BYTE(NPCs(CameraOn%).byFacing) = FaceUP THEN AddY% = 2: AddX% = 2
	IF BYTE(NPCs(CameraOn%).byFacing) = FaceDOWN THEN AddY% = -2: AddX% = 2
	IF BYTE(NPCs(CameraOn%).byFacing) = FaceLEFT THEN AddX% = 2: AddY% = 2
	IF BYTE(NPCs(CameraOn%).byFacing) = FaceRIGHT THEN AddX% = -2: AddY% = 2

	FOR MovY% = yDir TO 0 STEP AddY%

		FOR MovX% = xDir TO 0 STEP AddX%

			a% = -1: b% = -1
			FOR y% = VisibleY% - 1 TO VisibleY% + 10

				FOR x% = VisibleX% - 1 TO VisibleX% + 16

					VMap = BYTE(Map(x%, y%).byLayer1)
					gssprite a% * 20 + MovX%, b% * 20 + MovY%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(Tiles(VMap * 202)), VARPTR(Tiles(VMap * 202))
					VMap = BYTE(Map(x%, y%).byLayer2)
					IF VMap <> 0 THEN
						gssprite a% * 20 + MovX%, b% * 20 + MovY%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(Tiles(VMap * 202)), VARPTR(Tiles(VMap * 202))
					END IF

					IF RTRIM$(MapInfo.sMapName) = "Paravia" THEN
						IF Boat.x = x% AND Boat.y = y% AND NOT Boat.BoatOn THEN
							ShowSprite "Boat.set", a% * 20 + MovX%, b% * 20 + MovY%, 0, 20, 0
						END IF
					END IF

					a% = a% + 1
					IF a% = 17 THEN a% = -1

				NEXT x%
				b% = b% + 1
				IF b% = 11 THEN b% = -1

			NEXT y%
			DEF SEG = 0: POKE &H41A, PEEK(&H41C): DEF SEG 'clear keyboard buffer
			IF RTRIM$(MapInfo.sMapName) = "Boat" THEN
				DEF SEG = VARSEG(Buffer&(0)): BLOAD "bkgs\boat.b", VARPTR(Buffer&(0)): DEF SEG
			END IF

			ShowChar True, 0, 160, 100
			Spritelayer MovX%, MovY%

			IF RunOff% THEN gswait 1
			a% = -1: b% = -1
			FOR y% = VisibleY% - 1 TO VisibleY% + 10

				FOR x% = VisibleX% - 1 TO VisibleX% + 16

					VMap = BYTE(Map(x%, y%).byLayer3)
					IF VMap <> 0 THEN
						gssprite a% * 20 + MovX%, b% * 20 + MovY%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(Tiles(VMap * 202)), VARPTR(Tiles(VMap * 202))
					END IF

					a% = a% + 1
					IF a% = 17 THEN a% = -1

				NEXT x%
				b% = b% + 1
				IF b% = 11 THEN b% = -1

			NEXT y%

			IF RTRIM$(MapInfo.sMapName) = "Paravia" THEN
				EffectLayer 1
				EffectLayer 2
			END IF

			TimerEvent
			gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0
		NEXT MovX%

	NEXT MovY%

END SUB

