{ Created by Alexander Larkin.
  E-mail:     avlarkin@writeme.com
  Internet:   http://www.geocities.com/SiliconValley/6235/tpdl.htm
}

{$G+}
{$M 16384,160000,160000}
uses AvlCrt,MyMouse,GoodFont,MyEnCode,Dos;

const images=400;
      MyOwnPal: array[0..5,0..2] of byte=
      ((0,0,0),
       (0,0,0),
       (63,63,63),
       (63,0,0),
       (0,63,0),
       (0,0,63));

{************************ COLORS CONSTANTS **********************************}
    ColorBG: boolean=false;   {If transparent image background               }
    ColBG: word=256;          {256      - mean auto transparent color detect
                               0..255   - change this colors                 }
    ToColor: byte=0;          {0..255   - color to change to                 }
    LastColor: byte=252;      {0..255   - last color to use                  }
    FindColors: boolean=true; {Search (compare )in created colors mode on/off}
    FreeCol: word=17;         {0..255   - current free color                 }
    SrcCol: byte=17;          {First avaliable color                         }
    TheSame: byte=3;          {1..10 - equal constant                        }
    TheMost: boolean=false;   {Search for best color on/off                  }
{*********************END COLORS CONSTANTS **********************************}

      CurMou: boolean=false;

      heads: string='    '+#13+#10+#13+#10+
                    'Alexander Larkin Graphic file.'+#13+#10+
                    'internet:      http://www.geocities.com/SiliconValley/6235/tpdl.htm'+#13+#10+
                    'e-mail:        avlarkin@writeme.com'+#13+#10+#13+#10+#13+#10;


type

     pxl=record
          x,y: word;
         end;

     Brd=array[0..25] of pxl;                   {Border line pixels         }

     ImageHeader=record
                 ImageType: byte;               {0 - compressed             }
                 Ps: longint;                   {Image offset               }
                 Name: string[8];               {Image name                 }
                 Size: word;                    {Compressed size            }
                 Border: Brd;                   {Border line pixels         }
                 PictureType: byte;
                 {Bits 1..3:}
                                                {1 - standart               }
                                                {2 - one place              }
                                                {3 - move one               }
                                                {4 - image, full size       }
                                                {5 - hero                   }
                 {Bit 4 - mean left                                         }
                 {Bit 5 - background visible                                }
                 {Bit 6 - automatic decompress before use                   }
                 {Bit 7 - picture type byte initializated                   }
                 Pixels: byte;                  {Pixels in border plus 1    }
                end;

var od,s: string;
    palf: array[0..255,0..2] of byte;
    ImagesIs,FileMem,colpal: word;
    Header: array[0..Images] of ImageHeader;
    ImagePointer: array[0..images] of pointer;
    GFO: boolean;
    GFNalg,GFN: string;
    MemSize: longint;
    CurImg: word;
    Bgp: pointer;
    Crs: word;
    ModeNow: byte;
    OLDSCR: pointer;
    ImageShow: boolean;
    OKQuit: boolean;
    FUCOL: word;
    LUCOL: integer;
    OneBMP: boolean;
    LmGet: word;
    DtChg: boolean;

Function MemorySize: longint;
var w: word;
begin
 asm
  mov ah,48h
  mov bx,65535
  int 21h
  mov w,bx
 end;
MemorySize:=longint(w)*16;
end;

Procedure MyMove1(P,P1: pointer; w: word);
begin
 asm
  push ds
  push di
  push cx
  mov ds,Word Ptr P[2]
  mov si,Word Ptr P
  mov es,Word Ptr P1[2]
  mov di,Word Ptr P1
  mov cx,w
  cld
  @NextT:
  repz movsb
  jcxz @Done
  jmp @NextT
  @Done:
  pop cx
  pop di
  pop ds
 end;
end;

Procedure MyMove(P,P1: pointer; w: word);
begin
 asm
  push ds
  push di
  push cx
  mov ds,Word Ptr P[2]
  mov si,Word Ptr P
  mov es,Word Ptr P1[2]
  mov di,Word Ptr P1
  add di,w
  dec di
  add si,w
  dec si
  mov cx,w
  std
  @NextT:
  repz movsb
  jcxz @Done
  jmp @NextT
  @Done:
  pop cx
  pop di
  pop ds
 end;
end;

function stw(w: word): string;
var s: string;
begin
 str(w,s);
 stw:=s;
end;

function stl(l: longint): string;
var s: string;
begin
 str(l,s);
 stl:=s;
end;

{34}procedure setput(kindput: byte); assembler;
asm
{2} mov dx,3ceh
{2} mov al,3
{10}out dx,al
{4} mov al,kindput
{2} inc dx
{10}out dx,al
end;


procedure putpixel(x,y: integer; color: byte);
begin
 asm
  push di
  mov cx,x
  mov dx,y
  mov bl,color
  mov ax,PageBase
  mov es,ax
  mov ax,(320/4)
  mul dx
  push cx
  shr cx,1
  shr cx,1
  add ax,cx
  mov di,ax
  pop cx
  and cl,3
  mov ah,1
  shl ah,cl
  mov dx,3c4h
  mov al,2
  out dx,ax
  mov bh,cl
  inc bh
  call SetRPlaneAsm
  mov bh,es:[di]
  mov es:[di],bl
  pop di
 end;
end;

procedure Line(x1,y1,x2,y2: integer; colornow: byte);
var dx,dy,sx,sy,d,d1,d2,x,y,i: integer;
begin
 dx:=abs(x2 - x1);
 dy:=abs(y2 - y1);
 if (dx=0) and (dy=0) then
  begin
   if (x1<MaxX) and (y1<MaxY) and (x1>=0) and (y1>=0) then putpixel(x1,y1,colornow);
   exit;
  end;
 if x2>=x1 then sx:=1 else sx:=-1;
 if y2>=y1 then sy:=1 else sy:=-1;

 if dy<=dx then
  begin
   d:=(dy shl 1) - dx;
   d1:=dy shl 1;
   d2:=(dy-dx) shl 1;
   if (x1<MaxX) and (y1<MaxY) and (x1>=0) and (y1>=0) then putpixel(x1,y1,ColorNow);
   x:=x1+sx;
   y:=y1;
   i:=1;
   repeat
    if d>0 then
     begin
      d:=d+d2;
      y:=y+sy;
     end else d:=d+d1;
   if (x<MaxX) and (y<MaxY) and (x>=0) and (y>=0) then putpixel(x,y,ColorNow);
    i:=i+1;
    x:=x+sx;
   until (i>dx);
  end else
  begin
   d:=(dx shl 1) - dy;
   d1:=dx shl 1;
   d2:=(dx-dy) shl 1;
   if (x1<MaxX) and (y1<MaxY) and (x1>=0) and (y1>=0) then putpixel(x1,y1,ColorNow);
    x:=x1;
    y:=y1+sy;
    i:=1;
    repeat
     if d>0 then
      begin
       d:=d+d2;
       x:=x+sx;
      end else d:=d+d1;
   if (x<MaxX) and (y<MaxY) and (x>=0) and (y>=0) then putpixel(x,y,ColorNow);
     i:=i+1;
     y:=y+sy;
    until (i>dy);
  end;
end;

function stb(b: byte): string;
var s: string;
begin
 str(b,s);
 stb:=s;
end;

function strl(r: real): string;
var s: string;
begin
 str(r:0:2,s);
 strl:=s;
end;

function vl(s: string): word;
var w: word;
    i: integer;
begin
while (s<>'') and (not (s[1] in['0'..'9'])) do delete(s,1,1);
while (s<>'') and (not (s[length(s)] in['0'..'9'])) do delete(s,length(s),1);
val(s,w,i);
if i=0 then vl:=w else vl:=65535;
end;

procedure freeAlg;
begin
if FileMem<>0 then
 begin
  AVLWriteLn(stw(ImagesIs)+' images unloaded from memory.');
  asm
   mov ah,49h
   mov es,FileMem
   int 21h
   mov FileMem,0
   mov gfo,0
  end;
 end;
end;

Procedure BIOSSetPalette(ColF,ColT: byte; var pal);
begin
 if ColT=0 then exit;
 MemW[sseg:sptr-14]:=word(ColF);
 MemW[sseg:sptr-12]:=word(ColT);
 MemW[sseg:sptr-10]:=seg(pal);
 MemW[sseg:sptr-8]:=ofs(pal)+ColF*3;
 INLine($B4/$10/$B0/$12/$83/$EC/$10/$5B/$59/$07/$5A/$83/$C4/$08/$CD/$10);
end;

Procedure SaveScreen(var BGp: pointer);
const SCR: pointer=ptr($B800,0);
begin
 getmem(bgp,5000);
 MyMove(SCR,BGp,4000);
 crs:=memw[$40:$50];
end;

Procedure LoadScreen(var BGp: pointer);
const SCR: pointer=ptr($B800,0);
begin
 MyMove(BGp,SCR,4000);
 memw[$40:$50]:=crs;
 freemem(bgp,5000);
end;

function equ(a,b: string): boolean;
const
 c: string='abcdefghijklmnopqrstuwvxyz';
 d: string='ABCDEFGHIJKLMNOPQRSTUWVXYZ';
var w: byte;
begin
equ:=true;
 if length(a)=length(b) then
  begin
   for w:=1 to length(a) do
     if not (
             (a[w]=b[w]) or
             ((pos(a[w],c)<>0) and (b[w]=d[pos(a[w],c)])) or
             ((pos(a[w],d)<>0) and (b[w]=c[pos(a[w],d)]))
            ) then equ:=false;
  end else equ:=false;
end;

function ReadCommand(var s: string): byte;
var ch: char;
    s1: string;
begin
s1:='';

Repeat
 ch:=AVLReadKey;
 if ch=#0 then AVLReadKey;
 if (not (ch in[#0..#31])) and (Length(s1)<40) then s1:=s1+ch;
 if (ch=#8) and (length(s1)>0) then Delete(s1,Length(s1),1);
 AVLGotoXy(16,CurY);
 AVLWrite(s1+' ');
 AVLGotoXy(CurX-1,CurY);
Until ch in[#13,#27];

While (s1<>'') and (s1[1]=' ') do Delete(s1,1,1);
While (s1<>'') and (s1[length(s1)]=' ') do Delete(s1,length(s1),1);


if (ch=#13) and (s1='') then s1:='-l '+stw(CurImg);

While (s1<>'') and (s1[1]<>'-') do Delete(s1,1,1);
if (s1<>'') and (s1[1]='-') then
 begin
  if (length(s1)>1) then
   begin
    Delete(s1,1,1);
    ReadCommand:=ord(UpCase(S1[1]));
   end else ReadCommand:=241;
 end else ReadCommand:=240;

While (s1<>'') and (s1[length(s1)]=' ') do Delete(s1,Length(s1),1);
s:='';
if pos(' ',s1)<>0 then
 Repeat
  s:=s1[length(s1)]+s;
  Delete(s1,length(s1),1);
 Until S1[Length(s1)]=' ';

AVLWriteLn('');
end;

procedure OutPutFileMenuHelp;
begin
  AVLWriteln('');
  AVLWriteln('');
  AVLWriteln('**************************** FILE MENU HELP SCREEN ***************************');
  AVLTextColor(2);
  AVLWriteLn('                                   Usage:');
  AVLWriteLn('Command              Description');
  AVLTextColor(7);
  AVLWriteLn(' -R file_name.alg    Load ALG file to memory');
  AVLWriteLn(' -W [file_name.alg]  Save images and information from memory to ALG file');
  AVLWriteLn(' -O file_name.alg    Load broken ALG file or old format ALG file to memory.');
  AVLWriteLn(' -L [image_name]     Shows images names or information about one image');
  AVLWriteLn(' -A                  Load all BMP files from current directory to memory');
  AVLWriteLn(' -B file_name.bmp    Load picture from BMP file to memory');
  AVLWriteLn(' -S                  Turn on or turn off show image mode (for -B option)');
  AVLWriteLn(' -G file_name.aai    Get information about images from AAI file to memory');
  AVLWriteLn(' -P file_name.aai    Put information about images from memory to AAI file');
  AVLWriteLn(' -C                  Configurate current palette mixer constants');
  AVLWriteLn(' -Z directory_name   Change current directory.');
  AVLWriteLn(' -?                  Output this help screen');
  AVLWriteLn(' -X                  Exit from FILE MENU to MAIN PROGRAM');
  AVLWriteln('');
  AVLWriteln('');
end;

procedure OutPutMoreInfo;
begin
  AVLWriteln('');
  AVLWriteln('');
  AVLWriteLn('This ALGEDIT program is graphic editor. This program created specialy for');
  AVLWriteLn('people who like to create fast and not twinkle graphic. Everything is done');
  AVLWriteLn('for you. Now you can take some BMP files created by digital camera or by');
  AVLWriteLn('yourself. Load this files with this program and create ALG file. Take Turbo');
  AVLWriteLn('Pascal 7.0 language and use it to create very nice programs!');
  AVLWriteLn('');
  AVLWriteLn('AGLEDIT program able you to use one palette for many images.');
  AVLWriteLn('You can output many images at once.');
  AVLWriteLn('');
  AVLWriteLn('Very good compression used in ALG graphic file format. It able you to use about');
  AVLWriteLn('three times more graphic in your games and programs.');
  AVLWriteLn('');
  AVLWriteLn('Specialy for games you may create image border for picture in ALG file.');
  AVLWriteLn('This border able you to know if a hero of your game stay somewhere or if he');
  AVLWriteLn('fly to nowhere.');
  AVLWriteLn('');
  AVLWriteLn('Press any key to continue...');
  while AVLKeyPressed do AVLReadKey;
  AVLReadKey;
  while AVLKeyPressed do AVLReadKey;
  AVLWriteLn('');
  AVLWriteLn('It is very easy to use ALG file. Example:');
  AVLWriteLn('');
  AVLWriteLn('{$M 8192,90000,90000}');
  AVLWriteLn('uses goodvga;');
  AVLWriteLn('begin');
  AVLWriteLn(' TurnOnAutoDecompression;');
  AVLWriteLn(' if LoadALGFile(''fastfile.alg'')<>0 then WriteLn(''Cannot load images file'');');
  AVLWriteLn(' Set_320x200;              {Turn on 320x200x256 mode}');
  AVLWriteLn(' SetAlgPalette;            {Load palette from ALG file}');
  AVLWriteLn(' PutImage(0,0,Image(0));   {Put this image to the screen}');
  AVLWriteLn(' ReadLn;                   {Wait for enter key}');
  AVLWriteLn(' CloseGoodVga;             {Restore text screen and clean memory in heap}');
  AVLWriteLn(' FreeAlg;                  {Clean other memory reserved for ALG file}');
  AVLWriteLn('end.');
  AVLWriteLn('');
  AVLWriteLn('');
  AVLWriteLn('All this created by Alexander Larkin.');
  AVLWriteLn('E-mail:       avlarkin@writeme.com');
  AVLWriteLn('WWW:          http://www.geocities.com/SiliconValley/6235/tpdl.htm');
  AVLWriteLn('');
 end;

procedure OutPutHelp;
begin
  AVLWriteln('');
  AVLWriteln('');
  AVLWriteln('******************************** HELP SCREEN *********************************');
  AVLWriteLn('ALG files editor by Alexander Larkin. Created on 29/06/1998.');
  AVLWriteLn('');
  AVLTextColor(2);
  AVLWriteLn('                                   Usage:');
  AVLWriteLn('Key                  Description');
  AVLTextColor(7);
  AVLWriteLn(' ENTER               Shows information about next image');
  AVLTextColor(2);
  AVLWriteLn('Command              Description');
  AVLTextColor(7);
  AVLWriteLn(' -F                  Enter file menu (save or load ALG, AAI and BMP files)');
  AVLWriteLn(' -L [image_name]     Shows images names or information about one image');
  AVLWriteLn(' -E image_name       Edit everything in current image (enter to EDIT MENU)');
  AVLWriteLn(' -Z directory_name   Change current directory.');
  AVLWriteLn(' -?                  Output this help screen');
  AVLWriteLn(' -I                  More information about this program');
  AVLWriteLn(' -X                  Exit from this program');
  AVLWriteln('******************************************************************************');
  AVLWriteln('');
  AVLWriteln('');
end;

procedure OutError(b: byte; fn: string);
begin
 if b=25 then exit; {no error}
 AVLWriteLn('');
 if b<>0 then AVLWrite('ERROR:   ');
 case b of
  0: AVLWriteLn(' OK. Done.');
  1: AVLWriteLn('Cannot open file '+fn);
  2: AVLWriteLn('Seek error in file '+fn);
  3: AVLWriteLn('Not enough memory.');
  4: AVLWriteLn('Wrong offset in file '+fn);
  5: AVLWriteLn('Cannot read file '+fn);
  6: AVLWriteLn('To many images or there is no images in file '+fn);
  7: AVLWriteLn('Cannot read palette from file '+fn);
  8: AVLWriteLn('Wrong ALG file header');
  9: AVLWriteLn('There is no images in memory. Load ALG or BMP file first.');
  10: AVLWriteLn('Image '+fn+' not found.');
  11: AVLWriteLn('ALG file '+fn+' not created. Images not saved.');
  12: AVLWriteLn('Corrupted ALG file. Cannot load file '+fn);
  13: AVLWriteLn('Unknown image type. Cannot use image '+fn);
  14: AVLWriteLn('Mouse driver not detected.');
  15: AVLWriteLn('Cannot load graphic font.');
     16: AVLWriteLn(fn+' - cannot read from file');
     17: AVLWriteLn(fn+' - this file is not BMP file');
     18: AVLWriteLn(fn+' - too big BMP file');
     19: AVLWriteLn(fn+' - wrong image width in this BMP file');
     20: AVLWriteLn(fn+' - wrong palette size in this BMP file');
     21: AVLWriteLn(fn+' - cannot read palette from this BMP file');
     22: AVLWriteLn(fn+' - cannot read image. Corrupted BMP file');
     23: AVLWriteLn(fn+' - wrong image width. Corrupted BMP file header');
     24: AVLWriteLn(fn+' - cannot read extendet bytes. Bad BMP file.');
     25: AVLWriteLn('NO ERRORS');
     26: AVLWriteLn(fn+' - cannot translate image to 4 planes format.');
  27: AVLWriteLn('Wrong numerical value. Numerical value is number from 0 to 255.');
  28: AVLWriteLn('To big numerical value. It must be from 0 to 255.');
  29: AVLWriteLn('First free color cannot be lower than first avaliable color.');
  30: AVLWriteLn('Wrong numerical values. It must be from 1 to 20.');
     31: AVLWriteLn(fn+' - IMAGE ADDITION CANCELED.');
     32: AVLWriteLn(fn+' - not enough free memory to load this image.');
     33: AVLWriteLn(fn+' - cannot create ALG memory block.');
   34: AVLWriteLn(fn+' - cannot open this AAI file.');
   35: AVLWriteLn(fn+' - this file is not AAI file.');
  240: AVLWriteLn('Command not entered.');
  241: AVLWriteLn('Command not found.');
  242: AVLWriteLn('Unknown command.');
  0..255: AVLWriteLn('Unknown error. Cannot understand this command.');
 end;
 if b<>0 then AVLWriteLn('');
end;

procedure DirChange(s: string);
var s1: string;
    cs: word;
    DirInfo: SearchRec;
begin
  AVLWriteln('');
  {$I-}
  GetDir(0,s1);
  {$I+}
  if IoResult=0 then AVLWriteLn('Current directory: '+s1) else
                     AVLWriteLn('Cannot get current directory.');

  if (pos(s,'\')=0) and (s<>'') and (pos(s,':')=0) and (pos(s,'/')=0) then
   begin
    if (s1<>'') and (s1[length(s1)]<>'\') then s1:=s1+'\';
    s1:=s1+s;
    s:=s1;
   end;

  if equ(s,'..') then
   begin
    if s1[length(s1)]='\' then delete(s1,length(s1),1);
    if pos('\',s1)<>0 then
     begin
      repeat delete(s1,length(s1),1) until (s1[length(s1)]='\') or (s1='');
      if (s1<>'') and (s1[length(s1)]='\') then delete(s1,length(s1),1);
     end;
     s:=s1;
   end;

  {$I-}
  ChDir(s);
  {$I+}
  If IoResult<>0 then AVLWriteLn('Cannot change current directory to '+s) else
   begin
     {$I-}
     GetDir(0,s1);
     {$I+}
    if IoResult=0 then AVLWriteLn('Current directory changed to '+s1) else
                       AVLWriteLn('Cannot get current directory.');
   end;

  AVLWriteLn('');

   cs:=0;
   s1:='';
   FindFirst('*.*', AnyFile, DirInfo);
   while DosError=0 do
    begin
     if DirInfo.attr and Directory=Directory then
      begin
       s1:=s1+DirInfo.name;
       While (Length(s1) mod 10<>0) and (length(s1)<70) do s1:=s1+' ';
       if length(s1)>=70 then
        begin
         AVLWriteLn(s1);
         s1:='';
         if cs>15 then
          begin
           AVLWriteLn('Press any key...');
           AVLReadKey;
           While AVLKeyPressed do AVLReadKey;
           cs:=0;
          end;
        end;
      end;
     FindNext(DirInfo);
    end;
   AVLWriteLn(s1);
   AVLWriteLn('');


end;

function picturetype(b: byte): string;
var s: string;
begin
s:='';
if b and 128=0 then picturetype:='Picture type byte not initializated.' else
 begin
  if b and 15=1 then s:=s+'STANDART (1);    ';
  if b and 15=2 then s:=s+'NOT MOVABLE (2); ';
  if b and 15=3 then s:=s+'MOVABLE (3);     ';
  if b and 15=4 then s:=s+'BACKGROUND (4);  ';
  if b and 15=5 then s:=s+'HERO (5);        ';
  if b and 15 in[0,6..15] then s:=s+'UNKNOWN;        ';
  if b and 16=16 then s:=s+'Left;  ' else s:=s+'Right; ';
  if b and 32=32 then s:=s+'BG visible;   ' else s:=s+'BG invisible; ';
  if b and 64=64 then s:=s+'ADBU ON ' else s:=s+'ADBU OFF';
  picturetype:=s;
 end;
end;

function ChangeMemory(sz: word): boolean;
var b: byte;
begin
AVLWriteLn('Old ALG memory block size: '+stl(longint(LMGET) div 64)+' KBs');
AVLWriteLn('New ALG memory block size: '+stl(longint(sz) div 64)+' KBs');
if MemorySize+longint(LMGET)*16<longint(sz)*16 then
 begin
  ChangeMemory:=false;
  exit;
 end;
LMGET:=sz;
    asm
     mov ax,FileMem
     mov es,ax
     mov ah,04ah
     mov bx,sz
     int 21h
     xor cl,cl
     jnb @OkDone
     mov cl,255
     @OkDone:
     mov b,cl
    end;
ChangeMemory:=true;
if b<>0 then AVLWriteLn('WARNING: Something wrong with memory.');
DtChg:=true;
end;

Function OpenFile(var f: file; fn: string): boolean;
var way: string;
begin
if fn='' then OpenFile:=False else
 begin
  Assign(f,fn);
  GFN:=fn;
  {$I-}
  Reset(f,1);
  {$I+}
  if IoResult<>0 then
   begin
    Way:=ParamStr(0);
    While (Way<>'') and (not (Way[Length(Way)] in['/','\']))
                         do delete(Way,Length(Way),1);
    Assign(f,way+fn);
    GFN:=way+fn;
    {$I-}
    Reset(f,1);
    {$I+}
   end;
  If IoResult<>0 then OpenFile:=False else OpenFile:=true;
 end;
end;

procedure BuildTable;
var sz: word;
begin
 if ImagesIs>0 then
 for sz:=0 to ImagesIs-1 do
 ImagePointer[sz]:=ptr(FileMem+Header[sz].ps div 16,Header[sz].ps mod 16);
end;

function Standart2Planes(P: pointer; w,h: word): boolean;
var P1: pointer;
    nowpl,endpl,ckl,b: byte;
    w1,y,x: word;
    l: longint;
begin
Standart2Planes:=false;
if w>=1000 then exit;
l:=MaxAvail;
if l<=65000 then exit;
l:=0;
if h>254 then exit;
if longint(w)*longint(h)>65000 then exit;
getmem(P1,65002);
memw[seg(P1^):ofs(P1^)]:=w;
memw[seg(P1^):ofs(P1^)+2]:=h;
l:=l+4;

nowpl:=0;
endpl:=w mod 4;

  for ckl:=1 to 4 do
  begin
    if 0<endpl-nowpl then w1:=w div 4+1 else w1:=w div 4;
    memw[seg(P1^):ofs(P1^)+l]:=w1;
    l:=l+2;
     for y:=0 to h-1 do
       for x:=0 to w1-1 do
         begin
          b:=mem[seg(P^):ofs(P^)+x*4+ckl-1+y*w+4];
          mem[seg(P1^):ofs(P1^)+l]:=b;
          l:=l+1;
         end;
   nowpl:=nowpl+1;
   if nowpl>3 then begin; nowpl:=0; endpl:=0;  end;
  end;

MyMove1(p1,p,65000);
freemem(P1,65002);
if longint(memw[seg(P^):ofs(P^)])*
   longint(memw[seg(P^):ofs(P^)+2])>65000 then exit;
if memw[seg(P^):ofs(P^)+4]>160 then exit;
Standart2Planes:=true;
 DtChg:=true;
end;

procedure OutPutSCCHelp;
begin
  AVLWriteln('');
  AVLWriteln('');
  AVLWriteln('*********************** SET COLOR CONSTANTS MENU HELP *********************');
  AVLTextColor(2);
  AVLWriteLn('                                   Usage:');
  AVLWriteLn('Command             Description');
  AVLTextColor(7);
  AVLWriteLn(' -F number          Set current first free color');
  AVLWriteLn(' -S number          Set first color number (for search, option C)');
  AVLWriteLn(' -Q number          Set last color for use (from 0 to 252)');
  AVLWriteLn(' -D                 Set default values.');
  AVLWriteLn(' -B                 Turn on/off background color change mode');
  AVLWriteLn(' -B number          Set current background color for option B');
  AVLWriteLn(' -B AUTO            Automatic background color detect');
  AVLWriteLn(' -T number          Set new background color');
  AVLWriteLn(' -C                 Turn on/off compare colors search mode');
  AVLWriteLn(' -I litnumber       Set equal constant');
  AVLWriteLn(' -G                 Turn on/off search for best color mode');
  AVLWriteLn(' -L                 Show current and default values for this constants');
  AVLWriteLn(' -Z directory_name  Change current directory.');
  AVLWriteLn(' -?                 Output this help screen');
  AVLWriteLn(' -x                 Exit from SET COLOR CONSTANTS MENU to FILE MENU');
  AVLTextColor(6);
  AVLWriteLn('NUMBER is numerical value from 0 to 255');
  AVLWriteLn('LITNUMBER is numerical value from 1 to 20;    AUTO is the word "AUTO"');
  AVLTextColor(7);
  if FileMem=0 then
   begin
    AVLWriteLn('Change this values to find more information about it.');
    AVLWriteLn('This values automaticly changes to new one when you load next BMP file.');
   end else
   begin
    AVLWriteLn('It is not recomendated to change this values now. You can corrupt already');
    AVLWriteLn('loaded images. Default values able you to load any number of BMP files.');
   end;
end;

procedure OutPutSetPictureType(CurImg: word);
begin
  AVLWriteln('');
  AVLWriteln('');
  AVLWriteln('*********************** SET PICTURE TYPE BYTE MENU HELP *******************');
  AVLTextColor(2);
  AVLWriteLn('                                   Usage:');
  AVLWriteLn('Command             Description');
  AVLTextColor(7);
  AVLWriteLn(' -1                 Set standart picture type (just image)');
  AVLWriteLn(' -2                 Set one place picture type (not movable image)');
  AVLWriteLn(' -3                 Set movable picture type (stone or other object)');
  AVLWriteLn(' -4                 Set full size picture type (background image)');
  AVLWriteLn(' -5                 Set hero picture type (object under player control)');
  AVLWriteLn(' -a                 Set this image orientation as right or as left');
  AVLWriteLn(' -b                 Set background visible or invisible.');
  AVLWriteLn(' -c                 Turn on/off automatic decompress before use');
  AVLWriteLn(' -n NAME            Set picture to NAME');
  AVLWriteLn(' -j                 Turn on ADBU (look above) for all images.');
  AVLWriteLn(' -x                 Exit from SET PICTURE TYPE BYTE MENU to PICTURE EDIT');
  AVLWriteLn('');
  AVLWriteLn('Current picture name is '+Header[CurImg].name+' and it is number is '+stw(CurImg));
  AVLWriteLn(PictureType(Header[CurImg].PictureType));
  AVLWriteLn('');
  AVLWriteLn('It is recomendated to turn on ADBU if you are going to use 386 computers...');
  AVLWriteLn('');
end;

procedure BGChange(s: string);
var w: word;
    i: integer;
begin
  AVLWriteln('');
  if (s='') and ColorBG then
   begin
    AVLWriteLn('Background color change mode turned off.');
    AVLWriteLn('');
    AVLWriteLn('Default value for this option is OFF');
    ColorBg:=false;
    exit;
   end;
  if (s='') and (ColorBG=false) then
   begin
    AVLWriteLn('Background color change mode turned on.');
    AVLWriteLn('');
    AVLWriteLn('Default value for this option is OFF');
    ColorBg:=true;
    exit;
   end;
  if equ(s,'AUTO') then
   begin
    ColBG:=256;
    AVLWriteLn('Auto background detect mode turned on.');
    AVLWriteLn('In next loaded BMP file every pixel with the same color');
    AVLWriteLn('as in the left upper corner of the image');
   end else
   begin
    Val(s,w,i);
    if i<>0 then
     begin
      OutError(27,'');
      exit;
     end;
    if w>255 then
     begin
      OutError(28,'');
      exit;
     end;
    ColBG:=w;
    AVLWriteLn('In the next loaded BMP file every pixel with color '+stw(ColBg));
   end;
    AVLWriteLn('will be changed to new color '+stw(ToColor)+'.');
    AVLWriteLn('You may change new color number now by option -T');
   if ColorBG=false then
    begin
     AVLWriteLn('');
     AVLWriteLn('This option will not take effect! Turn on background color change');
     AVLWriteLn('mode first. Use -B option to turn it on.');
    end;
   AVLWriteLn('');
   AVLWriteLn('Default value for this option is auto detect. Use -B AUTO to turn it on.');
 DtChg:=true;
end;

procedure ToColorDo(s: string);
var b: byte;
    i: integer;
begin
    Val(s,b,i);
    if i<>0 then
     begin
      OutError(27,'');
      exit;
     end;
    ToColor:=b;
AVLWriteLn('');
AVLWriteLn('Current color for background is '+stw(ToColor));
AVLWriteLn('Use option -B [COLORNUM] to configurate background color change mode.');
AVLWriteLn('COLORNUM is numerical values from 0 to 255. This is the color for change.');
   if ColorBG=false then
    begin
     AVLWriteLn('');
     AVLWriteLn('This option will not take effect! Turn on background color change');
     AVLWriteLn('mode first. Use -B option to turn it on.');
    end;
AVLWriteLn('');
AVLWriteLn('Default value for this color is 0');
 DtChg:=true;
end;

function OnOff(b: boolean): string;
begin
 if b then OnOff:='On' else OnOff:='Off';
end;

procedure ColConstInfo;
begin
 AVLWriteLn('');
 AVLTextColor(2);
 AVLWriteLn('Default         Description                              Current value');
 AVLTextColor(7);
 AVLWriteLn('');
 AVLWriteLn('(OFF)           Back ground change mode:                 '+OnOff(ColorBg));
 if ColBg=256 then
 AVLWriteLn('(AUTO DETECT)   Back ground color for change:            AUTO DETECT') else
 AVLWriteLn('(AUTO DETECT)   Back ground color for change:            '+stb(byte(ColBg)));
 AVLWriteLn('(0)             New color for background:                '+stb(ToCOlor));
 AVLWriteLn('(ON)            Search (compare) in created colors mode: '+OnOff(FindColors));
 AVLWriteLn('(17)            Current free color:                      '+stw(FreeCol));
 AVLWriteLn('(17)            First avaliable color (for search):      '+stb(SrcCol));
 AVLWriteLn('(252)           Last color for use:                      '+stb(LastColor));
 AVLWriteLn('(3)             Equal constant:                          '+stb(TheSame));
 AVLWriteLn('(OFF)           Search for best color mode:              '+OnOff(TheMost));
 AVLWriteLn('');
end;

Procedure DefaultValues;
begin
    ColorBG:=false;           {If transparent image background               }
    ColBG:=256;               {256      - mean auto transparent color detect
                               0..255   - change this colors                 }
    ToColor:=0;               {0..255   - color to change to                 }
    FindColors:=true;         {Search (compare )in created colors mode on/off}
    FreeCol:=17;              {0..255   - current free color                 }
    SrcCol:=17;               {First avaliable color                         }
    TheSame:=3;               {1..10 - equal constant                        }
    LastColor:=252;
    TheMost:=false;           {Search for best color on/off                  }
    ColConstInfo;
 DtChg:=true;
end;

Procedure CompareModeOnOff;
begin
 AVLWriteLn('');
 if FindColors then
  begin
   AVLWriteLn('Search (compare) in created colors mode turned off');
   FindColors:=false;
  end else
  begin
   AVLWriteLn('Search (compare) in created colors mode turned on');
   FindColors:=true;
  end;
 AVLWriteLn('');
 AVLWriteLn('This mode make this program to use old color from created');
 AVLWriteLn('palette if it is the same as new one found in BMP file.');
 AVLWriteLn('Turn this mode on if you are going to use standart palette as is.');
 AVLWriteLn('');
 AVLWriteLn('Default value for this mode is ON');
 DtChg:=true;
end;

procedure FirstColor(s: string);
var rc,b: byte;
    i: integer;
begin
 Val(s,b,i);
    if i<>0 then
     begin
      OutError(27,'');
      exit;
     end;
    if b<SrcCol then
     begin
      OutError(29,'');
      exit;
     end;
 AVLWriteLn('');
 FreeCol:=b;
 AVLWriteLn('First free color changed to '+stb(b));
 AVLWriteLn('');
 AVLWriteLn('This is the first free color that can be reserved for new color found in');
 AVLWriteLn('BMP file. Be sure that color '+stb(b)+' is not already reserved for some images');
 AVLWriteLn('in current ALG file.');
 if LUCOL<>-1 then AVLWriteLn('Last used color in current palette is '+stb(LUCOL)) else
                   AVLWriteLn('There is no used colors in current palette. Load BMP file first.');
 if LUCOL+1>17 then rc:=LUCOL+1 else rc:=17;
 if (b<>LUCOL) and (LUCOL<255) then AVLWriteLn('It is recomendated to set first free color to '+stb(rc)) else
 if (b<>LUCOL) and (LUCOL=255) and (TheMost=false) then
 AVLWriteLn('Palette overflow! Turn on search for best color mode now!');
 if (b<>LUCOL) and (LUCOL=255) and (TheMost=true) then
 AVLWriteLn('Palette overflow. This is not a problem. Search for best color mode turned');
 if (b<>LUCOL) and (LUCOL=255) and (TheMost=true) then
 AVLWriteLn('on now. Old color in palette should be found for any color found in BMP file');
 AVLWriteLn('');
 AVLWriteLn('Default value for first free color is 17');
 DtChg:=true;
end;

procedure SrcColorSet(s: string);
var rc,b: byte;
    i: integer;
begin
 Val(s,b,i);
    if i<>0 then
     begin
      OutError(27,'');
      exit;
     end;
 AVLWriteLn('');
 SrcCol:=b;
 AVLWriteLn('First avaliable color changed to '+stb(b));
 AVLWriteLn('');
 AVLWriteLn('This is the first color that can be used for color found in BMP file.');
 AVLWriteLn('This color should be already reserved by some images to make possible');
 AVLWriteLn('to use it for color found in BMP file.');
 if SrcCol>=FreeCol then AVLWriteLn('This mode is turned off now, because of avaliable color value is higher');
 if SrcCol>=FreeCol then AVLWriteLn('than first free color value (or equal).') else
  begin
   AVLWriteLn('Compare search will be used for colors from '+stb(SrcCol)+' to '+stb(FreeCol-1));
   AVLWriteLn('This program will make this search for any color found in BMP file.');
  end;
 if FUCOL<>256 then AVLWriteLn('First used color in current palette is '+stb(FUCOL)) else
                    AVLWriteLn('There is no colors in current palette. Load BMP file first.');
 if FUCOL=256 then rc:=FreeCol else rc:=FUCOL;
 if (b<>LUCOL) and (LUCOL<255) then AVLWriteLn('It is recomendated to set avaliable color to '+stb(rc)) else
 if (b<>LUCOL) and (LUCOL=255) and (TheMost=false) then
 AVLWriteLn('Palette overflow! Turn on search for best color mode now!');
 if (b<>LUCOL) and (LUCOL=255) and (TheMost=true) then
 AVLWriteLn('Palette overflow. This is not a problem. Search for best color mode turned');
 if (b<>LUCOL) and (LUCOL=255) and (TheMost=true) then
 AVLWriteLn('on now. Old color in palette should be found for any color found in BMP file');
 AVLWriteLn('');
 AVLWriteLn('Default value for avaliable color is 17');
 DtChg:=true;
end;

procedure EqualConstSet(s: string);
var b: byte;
    i: integer;
begin
 Val(s,b,i);
    if i<>0 then
     begin
      OutError(27,'');
      exit;
     end;
    if (b=0) or (b>20) then
     begin
      OutError(30,'');
      exit;
     end;
 AVLWriteLn('');
 TheSame:=b;
 AVLWriteLn('Equal constant changed to '+stb(b));
 AVLWriteLn('This constant used by compare colors search mode.');
 AVLWriteLn('Two colors are used as the same one if (R+G+B) div CNST=(R1+G1+B1) div CNST');
 AVLWriteLn('CNST is equal constant and R+G+B are summ of color components intensivity.');
 AVLWriteLn('');
 AVLWriteLn('Higher value for this constant mean less quality and more avaliable colors.');
 AVLWriteLn('Value 1 for this constant mean real colors and less avaliable colors.');
 AVLWriteLn('');
 AVLWriteLn('Avaliable values for this constant are from 1 to 20.');
 AVLWriteLn('');
 AVLWriteLn('Default value for this constant is 3');
end;

Procedure TheMostSet;
begin
 AVLWriteLn('');
 if TheMost=false then
  begin
   AVLWriteLn('Search for best color mode turned on.');
   TheMost:=true;
  end else
  begin
   AVLWriteLn('Search for best color mode turned off.');
   TheMost:=false;
  end;
 AVLWriteLn('This program do not reserve new colors if this mode turned on.');
 if TheMost then AVLWriteLn('It is recomendated to turn off this mode.');
 AVLWriteLn('This mode automaticly turned on when palette overflow happens.');
 AVLWriteLn('');
 AVLWriteLn('This mode make this program to use the best color from current palette');
 AVLWriteLn('for new color found in BMP file in any case.');
 AVLWriteLn('');
 if TheMost and (FreeCol<=SrcCol) then
  begin
   AVLWriteLn('This mode will not take effect, because of avaliable color value is higher');
   AVLWriteLn('than first free color value (or equal).');
   AVLWriteLn('');
  end;
 AVLWriteLn('Default value for this mode is OFF');
end;

Procedure SetLastCol;
var b: byte;
    i: integer;
begin
 AVLWriteLn('');
 Val(s,b,i);
 if b<FreeCol then
  Begin
   AVLWriteLn('Cannot set last color to '+stw(b));
   b:=FreeCol;
   if b<SrcCol then b:=SrcCol;
   AVLWriteLn('First free color or first color for search is '+stw(b));
   AVLWriteLn('I set last color to '+stw(b));
   AVLWriteLn('');
  End;
 if b>252 then
  Begin
   AVLWriteLn('Cannot set last color to value '+stw(b));
   b:=252;
   AVLWriteLn('Value must be lower, than 253');
   AVLWriteLn('I set last color to '+stw(b));
  End;
 LastColor:=b;
 AVLWriteLn('');
 AVLWriteLn('Last color is the size of palette.');
 AVLWriteLn('This program will not use any colors after color '+stw(b));
 AVLWriteLn('');
 AVLWriteLn('Default value for last color is 252');
end;


procedure SetColConst;
var w: word;
    OKQuit: boolean;
begin
  AVLWriteLn('');
  AVLWriteLn('');
  AVLWriteLn('Entered to SET COLOR CONSTANTS MENU program module.');
  AVLWriteLn('');
    OKQUIT:=false;
     repeat
      AVLWriteLn('Enter -? for help');
      AVLTextColor(2);
      AVLWrite('COLORS  CMD  ');
      AVLTextColor(7);
      AVLWrite('> ');
      w:=ReadCommand(s);
       case w of
        76: ColConstInfo;           {L}
        66: BGChange(s);            {B}
        67: CompareModeOnOff;       {C}
        68: DefaultValues;          {D}
        84: ToColorDo(s);           {T}
        83: SrcColorSet(s);         {S}
        73: EqualConstSet(s);       {I}
        70: FirstColor(s);          {F}
        71: TheMostSet;             {G}
        81: SetLastCol;             {Q}
        63: OutPutSCCHelp;          {?}
        72: OutPutSCCHelp;          {H}
        88: OKQUIT:=true;           {X}
        90: DirChange(s);           {Z}
        0..255: OutError(w,'');
       end;
     until OKQUIT;
    AVLWriteLn('');
    AVLWriteLn('Came back to FILE MENU program module.');
    AVLWriteLn('');
end;

procedure SetValue(CurImg: word; b: byte);
begin
Header[CurImg].PictureType:=Header[CurImg].PictureType and 240;
Header[CurImg].PictureType:=Header[CurImg].PictureType or b;
Header[CurImg].PictureType:=Header[CurImg].PictureType or 128;
DtChg:=true;
end;

procedure SetOrient(CurImg: word);
begin
Header[CurImg].PictureType:=Header[CurImg].PictureType xor 16;
Header[CurImg].PictureType:=Header[CurImg].PictureType or 128;
DtChg:=true;
end;

procedure BGOnOff(CurImg: word);
begin
Header[CurImg].PictureType:=Header[CurImg].PictureType xor 32;
Header[CurImg].PictureType:=Header[CurImg].PictureType or 128;
DtChg:=true;
end;

procedure ADBUonoff(CurImg: word);
begin
Header[CurImg].PictureType:=Header[CurImg].PictureType xor 64;
Header[CurImg].PictureType:=Header[CurImg].PictureType or 128;
DtChg:=true;
end;

procedure ADBUonall;
var w: word;
begin
 if ImagesIs>0 then
 for w:=0 to ImagesIs-1 do if Header[w].PictureType and 64=0 then
 ADBUonoff(w);
 DtChg:=true;
end;

procedure SetName(CurImg: word;s: string);
var b: byte;
begin
if length(s)>8 then
 begin
  AVLWriteLn(s+' is to long name. No more than 8 characters.');
  exit;
 end;
if length(s)=0 then
 begin
  AVLWriteLn('Usage:      -N NAME');
  AVLWriteLn('NAME is any name you want.');
  AVLWriteLn('Example:    -N IMAGE1');
  exit;
 end;
for b:=1 to length(s) do if (not (s[1] in['a'..'z','A'..'Z','_','0'..'9'])) then
 begin
  AVLWriteLn('Bad character '+s[b]+' in name '+s);
  AVLWriteLn('Use characters ''a''..''z'',''A''..''Z'',''_'',''0''..''9''');
  exit;
 end;
Header[CurImg].name:=s;
DtChg:=true;
end;

procedure PictureTypeByte(iw: word);
var w: word;
    OKQuit: boolean;
begin
  AVLWriteLn('');
  AVLWriteLn('');
  AVLWriteLn('Entered to SET PICTURE TYPE BYTE program module.');
  AVLWriteLn('');
    OKQUIT:=false;
     repeat
      OutPutSetPictureType(iw);
      AVLWriteln('******************************************************************************');
      AVLTextColor(2);
      AVLWrite('SET BYTE CMD ');
      AVLTextColor(7);
      AVLWrite('> ');
      w:=ReadCommand(s);
       case w of
        49..53: SetValue(iw,w-48);
        65:     SetOrient(iw);       {A}
        66:     BgOnOff(iw);         {B}
        67:     ADBUonoff(iw);       {C}
        78:     SetName(iw,s);       {N}
        88:     OKQUIT:=true;        {X}
        74:     ADBUonall;           {J}
        90:     DirChange(s);        {Z}
        0..255: OutError(w,'');
       end;
     until OKQUIT;
    AVLWriteLn('');
    AVLWriteLn('Came back to PICTURE EDIT program module.');
    AVLWriteLn('');
end;

procedure ExtrImg(w: word; rl: boolean); Forward;

function LoadBMPFile(fn: string): byte;
   type
    bmfh=record case byte of
       1:(bm:array[0..53] of byte);
       2:(bft:integer;
          bsize:longint;
          r1,r2:word;
          bp:longint;
          Bis:longint;
          Biw:longint;
          Bih:longint;
          Bip,Bib:word;
          Bic,Bisize,BixP,BiyP,BiClrU,BiClrI:longint;
          );
       end;

var f: file;
    ReadPAL: array[0..255,0..3] of byte;
    BMPPal: array[0..255,0..2] of byte;
    HDR: bmfh;
    ys,y,rx,x1,y1,num: word;
    err,b: byte;
    P,OldP,A: pointer;
    BUF: array[0..20] of byte;
    w,wd,h,mb,yw: word;
    t: array[0..2] of byte;
    ch: char;
    w1,as,MAvail,tblsz: word;
    l1,imgsz,l: longint;
    tp: pointer;

Procedure CreatePalette(A: pointer; pln: boolean);
var bt: byte;
    w: word;
    Done: boolean;
    Dif,DifNow: word;
    DifNum: byte;
    BG: boolean;
    BGcol: byte;
    lft,rgh: byte;
    n,w1,yn: word;
    ee: byte;
    bf: array[0..255] of byte;
    fpln,y1,x1: word;
    b: byte;

begin

if colorBG and (colBG=256) then bg:=false else if colorBG then
 begin
  bg:=true;
  BGcol:=byte(colBG);
 end;

x1:=MemW[seg(A^):ofs(A^)];
y1:=MemW[seg(A^):ofs(A^)+2];
A:=Ptr(Seg(A^),Ofs(A^)+4);
yn:=0;
if pln then fpln:=1 else fpln:=0;

 for w:=1 to x1*y1+(byte(pln) and 1 * 8) do
  begin
   if w=fpln then
    begin
     fpln:=w+MemW[Seg(A^):Ofs(A^)+w-1]*y1+2;
     w:=w+2;
    end;
   bt:=mem[Seg(A^):Ofs(A^)+w-1];
   if not bg then
    begin
     BGcol:=bt;
     bg:=true;
    end;

   Done:=false;
   Dif:=65535;

   if (bt=BGcol) and ColorBG then
    begin
     mem[Seg(A^):Ofs(A^)+w-1]:=ToColor;
     Done:=true;
    end;

   if (not Done) and FindColors and (FreeCol>SrcCol) then
    for b:=SrcCol to FreeCol-1 do if
    (BMPPal[bt,0] div thesame*thesame=PalF[b,0] div thesame*thesame) and
    (BMPPal[bt,1] div thesame*thesame=PalF[b,1] div thesame*thesame) and
    (BMPPal[bt,2] div thesame*thesame=PalF[b,2] div thesame*thesame) then
     begin
      mem[Seg(A^):Ofs(A^)+w-1]:=b;
      Done:=true;
     end;

   if (Done=false) and (FreeCol>=LastColor) and (TheMost=false) then
    begin
     TheMost:=true;
     AvlWriteLn('');
     AvlWriteLn('');
     AvlWriteLn('*****************************************************************************');
     AvlWriteLn('Palette overflow!!! "Search for best color" mode turned on. Using old colors.');
     AvlWriteLn('Try to increase "Equal colors" constant.');
     AvlWriteLn('    (the last three colors (253,254,255) used for special purpose)');
     AvlWriteLn('*****************************************************************************');
     AvlWriteLn('');
    end;

   if (Done=false) and TheMost and (FreeCol>SrcCol) then
    begin
      for b:=SrcCol to FreeCol-1 do
       begin
        DifNow:=abs(PalF[b,0]-BMPPal[bt,0])+
                abs(PalF[b,1]-BMPPal[bt,1])+
                abs(PalF[b,2]-BMPPal[bt,2]);
        if DifNow<Dif then
         begin
          Dif:=DifNow;
          DifNum:=b;
         end;
       end;
     mem[Seg(A^):Ofs(A^)+w-1]:=DifNum;
     Done:=true;
    end;

   if (Done=false) and (FreeCol<255) then
    begin
     if LuCol<FreeCol then LuCol:=FreeCol;
     if FUCol>FreeCol then FUCol:=FreeCol;
     PalF[FreeCol,0]:=BMPPal[bt,0];
     PalF[FreeCol,1]:=BMPPal[bt,1];
     PalF[FreeCol,2]:=BMPPal[bt,2];
     mem[Seg(A^):Ofs(A^)+w-1]:=FreeCol;
     Done:=true;
     Inc(FreeCol);
    end;

  end;

A:=Ptr(Seg(A^),Ofs(A^)-4);
ColPal:=FUCol*256+LuCol;
end;

begin
t[0]:=20;
t[1]:=63;
t[2]:=63;
err:=0;
LoadBMPFile:=25;
if pos('.',fn)=0 then fn:=fn+'.BMP';
 If not OpenFile(f,fn) then
  begin
   OutError(1,fn);
   exit;
  end;
  BlockRead(f,HDR,54,num); LoadBmpFile:=16;
 if num<>54 then begin
                  close(f);
                  exit;
                 end;
 LoadBmpFile:=17;
 if HDR.BFT<>19778 then
  begin
   close(f);
   exit;
  end;
 LoadBmpFile:=18;
 if (HDR.BIH<>240) and (HDR.bsize>68000) then
  begin
   close(f);
   exit;
  end;

 LoadBmpFile:=19;
 rx:=HDR.BIW;
 x1:=rx;
 HDR.BIW:=(HDR.BSIZE-HDR.BP) div HDR.BIH;
 if HDR.BIH=240 then HDR.BIH:=200;
 y1:=HDR.BIH;

 if (HDR.BIW=0) or (HDR.BIW>9999) then
  begin
   close(f);
   exit;
  end;

 LoadBmpFile:=20;
 BlockRead(f,ReadPAL,(HDR.BP-54),num);
 if num<>HDR.BP-54 then
  begin
   close(f);
   exit;
  end;

 LoadBmpFile:=21;

 for b:=0 to (HDR.BP-54) div 4-1 do
  begin
   BMPPal[b,0]:=ReadPal[b,2] div 4;
   BMPPal[b,1]:=ReadPal[b,1] div 4;
   BMPPal[b,2]:=ReadPal[b,0] div 4;
  end;

 LoadBmpFile:=10;
 if rx*HDR.BIH>64000 then
  begin
   close(f);
   exit;
  end;

  if MemorySize<rx*HDR.BIH+12+3000 then
   begin
    LoadBmpFile:=32;
    close(f);
    exit;
   end;


 GetMem(A,65535);
 OldP:=A;
 A:=Ptr(Seg(A^),Ofs(A^)+HDR.BIH*rx+4);

 for y:=1 to HDR.BIH do
  begin
   A:=Ptr(Seg(A^),Ofs(A^)-rx);
   BlockRead(f,A^,rx,num);
   if num<>rx then err:=22;
   if (HDR.BIW<rx) then err:=23;
   num:=0;
   if err=0 then BlockRead(f,BUF,HDR.BIW-rx,num);
   if num<>HDR.BIW-rx then err:=24;
   if err<>0 then
    begin
     A:=OldP;
     LoadBmpFile:=err;
     FreeMem(A,65535);
     close(f);
     exit;
    end;
  end;

A:=Ptr(Seg(A^),Ofs(A^)-4);

LoadBmpFile:=26;
if not Standart2planes(A,rx,HDR.BIH) then
 begin
  FreeMem(A,65535);
  Close(f);
  exit;
 end;

 If ImageShow then
  begin
   SaveScreen(BGp);
    if ModeNow=0 then Set_320x200;
    if ModeNow=1 then Set_320x240;
    if ModeNow=2 then Set_320x400;
    if ModeNow=0 then Ys:=160 else
    if ModeNow=1 then Ys:=200 else Ys:=360;
    CVM(0);
    yw:=YH;
    YH:=Ys+40-1;
    BiosSETPalette(0,255,BMPPal);
    BiosSETPalette(253,1,ptr(seg(t)-48,ofs(t)+9)^);
    TransparentColor:=0;

       Set_Visual_Page(1);
       Set_Active_Page(0);
       PutImage(0,0,A,nil,0);
     If OneBMP=false then
      begin
       ColNow:=253;
       OutTextXy(10,Ys,'Press');
       OutTextXy(10,Ys+2, '          [ 1 ]   - to set colors constants');
       OutTextXy(10,Ys+13,'          [ 2 ]   - to add image using current colors constants');
       OutTextXy(10,Ys+24,'          [ 3 ]   - to cancel addition');
       ColNow:=7;

        Set_Visual_Page(0);
         repeat
          ch:=AVLReadKey;
         until ch in['1','2','3',#27];
      end else
      begin
       ColNow:=253;
       OutTextXy(90,Ys,'Wait or press any key...');
       ColNow:=7;
       Set_Visual_Page(0);
       ch:='2';
       for w1:=1 to 25 do
        begin
         w:=MemW[$40:$6C];
         Repeat until (w<>MemW[$40:$6C]) or AVLKeyPressed;
        end;
       While AVLKeyPressed do AVLReadKey;
      end;
   yh:=yw;
   InLine($B8/$03/$00/$CD/$10);    { mov ax,013h; int 10h   }
   LoadScreen(BGp);
  end else
  begin
   if OneBMP=false then
    begin
     AVLWriteLn('Press');
     AVLWriteLn('      [1] - to set colors constants');
     AVLWriteLn('      [2] - to add image using current colors constants');
     AVLWriteLn('      [3] - to cancel addition');
      repeat
       ch:=AVLReadKey;
      until ch in['1','2','3',#27];
    end else ch:='2';
  end;

LoadBmpFile:=25;

if ch=#27 then ch:='3';

if ch='1' then SetColConst;
if ch<>'3' then
 begin
  AVLWrite('Wait... ');
  CreatePalette(A,true);
  AVLWriteLn('Done. Image palette added to standart palette.');
   if FileMem=0 then
    begin
     MemSize:=length(heads);
     mb:=MemSize div 16+2;
     LMGET:=mb;
     P:=nil;
       asm
        mov ah,48h
        mov bx,mb
        int 21h
        jc @NoMemory
        mov word ptr P[2],ax
        @NoMemory:
        mov MAvail,bx
       end;
     if p=nil then
      begin
       AVLWriteLn('Free memory size:                '+stw(MAvail div 64)+' KB');
       AVLWriteLn('Need memory to create ALG block: '+stw(mb div 64)+' KB');
       FreeMem(A,65535);
       Close(F);
       LoadBmpFile:=32;
       exit;
      end else AVLWriteLn('ALG memory block successfuly created.');
     FileMem:=seg(P^);
     heads[5]:=chr(length(heads));
     as:=0;
     for num:=6 to length(heads)-2 do as:=as+ord(heads[num]);
     heads[length(heads)-1]:=chr(as div 256);
     heads[length(heads)]:=chr(as mod 256);
     MyMove(addr(Heads[1]),P,length(heads));
    end;
  MemSize:=MemSize+x1*y1+12;
  mb:=MemSize div 16+2;
   if Not ChangeMemory(mb) then
    begin
     FreeMem(A,65535);
     Close(F);
     LoadBmpFile:=32;
     exit;
    end;
    AVLWriteLn('Allocated memory block size changed.');

  Header[ImagesIs].ImageType:=1;
  l1:=0;
  w:=65535;
  if ImagesIs>0 then
   begin
    l:=Header[ImagesIs-1].size;
    l1:=Header[ImagesIs-1].ps;
    w:=ImagesIs-1;
   end else
   begin
    l:=0;
    l1:=length(heads);
    GFO:=true;
   end;
  tblsz:=MemW[FileMem+l1 div 16:l1 mod 16+4] and 32767;
  imgsz:=tblsz*8+l+8;
  if (w<>65535) and (Header[w].ImageType=1) then
   begin
    wd:=MemW[FileMem+l1 div 16:l1 mod 16];
    h:=MemW[FileMem+l1 div 16:l1 mod 16+2];
    ImgSz:=wd*h+4+8;
   end else if w=65535 then ImgSz:=0;
  TP:=Ptr(FileMem+(l1+imgsz) div 16,(l1+imgsz) mod 16);

  Header[ImagesIs].Ps:=l1+imgsz;
  while Pos('.',fn)<>0 do delete(fn,Length(fn),1);
  Header[ImagesIs].Name:=fn;
  ImgSz:=MemW[Seg(A^):Ofs(A^)]*MemW[Seg(A^):Ofs(A^)+2]+12;
  Header[ImagesIs].Size:=ImgSz;
  Header[ImagesIs].PictureType:=0;
  Header[ImagesIs].Pixels:=0;
  ImagePointer[ImagesIs]:=TP;

  Inc(ImagesIs);
  MyMove(A,TP,ImgSz);

  A:=OldP;
  FreeMem(A,65535);
  ExtrImg(ImagesIs-1,false);

  tblsz:=MemW[FileMem+Header[ImagesIs-1].ps div 16:
              Header[ImagesIs-1].ps mod 16+4] and 32767;
  imgsz:=tblsz*8+Header[ImagesIs-1].size+8;
  wd:=MemW[FileMem+Header[ImagesIs-1].ps div 16:
           Header[ImagesIs-1].ps mod 16];
  h:=MemW[FileMem+Header[ImagesIs-1].ps div 16:
          Header[ImagesIs-1].ps mod 16+2];
  if imgsz/(wd*h+12)*100>100 then
   Begin
    AvlWriteLn('Compressed image is bigger than normal image.');
    AvlWriteLn('Trying to exatract image...');
    ExtrImg(ImagesIs-1,true);
   End;
 end else
 begin
  LoadBmpFile:=31;
  FreeMem(A,65535);
  Close(F);
  exit;
 end;
LoadBmpFile:=0;
Close(f);
DtChg:=true;
end;

Procedure LoadAllBMPFiles;
var DirInfo: searchrec;
    W: word;
 begin
  OneBMP:=true;
  w:=0;
  FindFirst('*.BMP', Archive, DirInfo);
   while DosError = 0 do
    begin
     inc(w);
     OutError(LoadBMPFile(DirInfo.Name),DirInfo.Name);
     FindNext(DirInfo);
    end;
  AVLWriteLn('');
  AVLWriteLn(stw(w)+' BMP files loaded. Use -L option in MAIN MENU mode to see the');
  AVLWriteLn('list of successfuly loaded pictures. Use -X option now to exit from');
  AVLWriteLn('FILE MENU to MAIN MENU mode.');
  AVLWriteLn('');
  OneBMP:=false;
 end;

procedure LoadAlgFile(fn: string; bb: boolean);
var f: file;
    FullNum,l: longint;
    sz,num,MAvail: word;
    p: pointer;
    b: byte;
    s: string;
    as: word;
    t1,t: longint;
begin
t:=0;
if pos('.',fn)=0 then fn:=fn+'.ALG';
 If not OpenFile(f,fn) then
  begin
   OutError(1,fn);
   exit;
  end;
 GfnAlg:=gfn;

 FreeALG;
 FullNum:=0;
 BlockRead(f,l,4,num); t:=t+num;
 if FileSize(f)<l then
  begin
   close(f);
   OutError(12,fn);
   exit;
  end;
 BlockRead(f,b,1,num); t:=t+num;
 s[0]:=chr(b-5);
 BlockRead(f,s[1],b-5,num); t:=t+num;
 as:=0;
 if length(s)>2 then for num:=1 to length(s)-2 do as:=as+ord(s[num]);
 if bb and
 ((as div 256<>ord(s[length(s)-1])) or (as mod 256<>ord(s[length(s)])))
                                     then OutError(8,'') else
 begin
  {$I-}
  seek(f,0);
  {$I+}
  if ioresult<>0 then OutError(2,fn);
  FullNum:=FullNum+Num;
  MemSize:=l;
  sz:=l div 16+2;
  LMGET:=sz;
  P:=nil;
   asm
    mov ah,48h
    mov bx,sz
    int 21h
    jc @NoMemory
    mov word ptr P[2],ax
    @NoMemory:
    mov MAvail,bx
    end;
  if p=nil then
   begin
    AVLWriteLn('Free memory size:              '+stw(MAvail div 64)+' KB');
    AVLWriteLn('Need memory to load this file: '+stw(sz div 64)+' KB');
   end else AVLWriteLn('Reserved '+stw(sz div 64)+' KB of memory for this file');
  if p=nil then OutError(3,'') else
  begin
   FileMem:=seg(P^);
   AVLWrite('Reading images from file '+fn+' to memory...');
   while (num<>0) and (l>0) do
    begin
     if l>65520 then sz:=65520 else sz:=l;
     blockread(f,P^,sz,num); t:=t+num;
     FullNum:=FullNum+num;
     P:=ptr(seg(P^)+4095,ofs(P^));
     l:=l-num;
    end;
   AVLWriteLn(' - done');
  if FilePos(f)<>MemSize then OutError(4,fn);
  if num<>0 then BlockRead(f,ImagesIs,2,num); t:=t+num;
  FullNum:=FullNum+Num;
  if num<>0 then BlockRead(f,Header,ImagesIs*SizeOf(ImageHeader),num); t:=t+num;
  FullNum:=FullNum+Num;
  if num=0 then OutError(5,fn) else
   begin
    if (ImagesIs>Images) or (ImagesIs=0) then
     OutError(6,fn) else
     begin
      AVLWrite('Creating possition table for images... ');
      BuildTable;
      AVLWriteLn(' - done');
      GFO:=true;
      AVLWriteLn('Ok. '+stw(ImagesIs)+' images loaded from file '+fn);
      AVLWrite('Reading palette... ');
      blockread(f,colpal,2,num); t:=t+num;
      if num<>2 then OutError(7,fn) else
       begin
        BlockRead(f,palf,768,num); t:=t+num;
        if num<>768 then OutError(7,fn) else AVLWriteLn(' - done');
        AVLWriteLn('');
       end;
      BlockRead(f,ColorBg,1,num); t:=t+num;
      BlockRead(f,ColBG,2,num); t:=t+num;
      BlockRead(f,ToColor,1,num); t:=t+num;
      BlockRead(f,FindColors,1,num); t:=t+num;
      BlockRead(f,FreeCol,2,num); t:=t+num;
      BlockRead(f,SrcCol,1,num); t:=t+num;
      BlockRead(f,TheSame,1,num); t:=t+num;
      BlockRead(f,TheMost,1,num); t:=t+num;
      BlockRead(f,t1,4,num);
      LastColor:=0;
      BlockRead(f,LastColor,1,num);
      if LastColor=0 then LastColor:=252;

      FUCol:=ColPal div 256;
      LuCol:=ColPal mod 256;
       If ColPal=0 then
        begin
         LUCOL:=-1;
         FUCOL:=256;
        end;
     end;
   end;
  end;
 end;
Close(f);
end;

procedure SaveAlgFile(fn: string);
var f: file;
    s,l: longint;
    sz,num: word;
    P: pointer;
    ch: char;
    i: integer;
begin
s:=0;
if not GFO then OutError(9,'') else
 begin
  if fn<>'' then if pos('.',fn)=0 then fn:=fn+'.ALG';
  if fn='' then fn:=GFNalg;
  assign(f,fn);
  {$I-}
  if fn<>'' then reset(f,1);
  {$I+}
  if fn='' then
   begin
    AVLWriteLn('Please don''t forget to enter new file name.');
    exit;
   end;
  if (ioresult=0) and (fn<>'') then
   begin
    close(f);
    AVLWriteLn('');
    AVLWriteLn('Do you want to overwrite file '+fn+'? [Y]/[N]');
    repeat ch:=AVLReadKey until ch in['n','N','y','Y',' '];
    if ch in['n','N',' '] then
     begin
      OutError(11,fn);
      exit;
     end;
   end;
  {$I-}
  rewrite(f,1);
  {$I+}
  If IoResult<>0 then
   begin
    OutError(11,fn);
    exit;
   end;

  AVLWriteLn('');
  AVLWrite('Saving '+Stw(ImagesIs)+' images... ');
    P:=Ptr(FileMem,0);
    l:=MemSize;
    MemL[seg(P^):ofs(P^)]:=MemSize;
     repeat
      if l>65520 then sz:=65520 else sz:=word(l);
      blockwrite(f,P^,sz,num); s:=s+num;
      P:=ptr(seg(P^)+4095,ofs(P^));
      l:=l-num;
     until (num=0) or (l=0);
  BlockWrite(f,ImagesIs,2,Num); s:=s+num;
  BlockWrite(f,Header,ImagesIs*SizeOf(ImageHeader),num); s:=s+num;
  BlockWrite(f,ColPal,2,num); s:=s+num;
  BlockWrite(f,Palf,768,num); s:=s+num;

  BlockWrite(f,ColorBg,1,num); s:=s+num;
  BlockWrite(f,ColBG,2,num); s:=s+num;
  BlockWrite(f,ToColor,1,num); s:=s+num;
  BlockWrite(f,FindColors,1,num); s:=s+num;
  BlockWrite(f,FreeCol,2,num); s:=s+num;
  BlockWrite(f,SrcCol,1,num); s:=s+num;
  BlockWrite(f,TheSame,1,num); s:=s+num;
  BlockWrite(f,TheMost,1,num); s:=s+num;
  BlockWrite(f,s,4,num);
  BlockWrite(f,LastColor,1,num);

  if num=0 then AVLWriteLn(' - cannot write to file. Disk full? ') else
                AVLWriteLn(' - OK. File '+fn+' created.');
  {$I-}
  close(f);
  {$I+}
  i:=IoResult;
 end;
DtChg:=false;
end;

function imagetype(b: byte): string;
begin
 case b of
  0: ImageType:='compressed, 4 plane VGA mode optimizated';
  1: ImageType:='as is, 4 plane VGA mode optimizated';
  2: ImageType:='compressed, standart BIOS mode optimizated';
  3: ImageType:='as is, standart BIOS mode optimizated';
  4..255: ImageType:='unknown';
 end;
end;

procedure ShowNames(i: string);
var cds,w,h,wd,tblsz,imgsz: word;
    s: string[11];
    s1: string[90];
    fb: byte;
begin
s1:='';
if not GFO then OutError(9,'') else
 begin
  if i='' then
   begin
    AVLWriteLn('');
    if ImagesIs>0 then for w:=0 to ImagesIs-1 do
     begin
      s:=Header[w].name;
      while length(s)<10 do s:=s+' ';
      s1:=s1+s;
      if length(s1)>75 then
       begin
        Delete(s1,length(s1),1);
        Delete(s1,length(s1),1);
        AVLWriteLn(s1);
        s1:='';
       end;

        if (w mod 64=0) and (w<>0) then
         begin
          AVLWriteLn('');
          AVLWriteLn('Press any key...');
          AVLReadKey;
         end;
     end;
    Delete(s1,length(s1),1);
    Delete(s1,length(s1),1);
    AVLWriteLn(s1);
    AVLWriteLn('');
   end else
   begin
    AVLWriteLn('');
    w:=0;
    if (i<>'') and (i[1] in['0'..'9']) then w:=vl(i) else
    if ImagesIs>0 then while (not equ(i,Header[w].name)) and (w<ImagesIs) do inc(w);
    if w>=ImagesIs then OutError(10,i) else
     begin
      CurImg:=w+1;
      AvlWriteLn('Image name:                '+Header[w].name);
      AvlWriteLn('Image number:              '+stw(w));
      AvlWriteLn('Image type:                '+imagetype(Header[w].ImageType));
      AvlWriteLn('Image offset in ALG file:  '+stl(Header[w].ps));
      AvlWriteLn('Picture type:              '+picturetype(Header[w].picturetype));
      AvlWrite('Pixels in image border:    ');
      if Header[w].Pixels=0 then
      AvlWriteLn('No border. Add one first (Usage -A in PICTURE EDIT)') else
      AvlWriteLn(stw(word(Header[w].Pixels-1)));
      wd:=MemW[FileMem+Header[w].ps div 16:Header[w].ps mod 16];
      h:=MemW[FileMem+Header[w].ps div 16:Header[w].ps mod 16+2];
      AvlWriteLn('Picture width:             '+stw(wd));
      AvlWriteLn('Picture height:            '+stw(h));
      if Header[w].imagetype=0 then
      begin
      AvlWriteLn('          Technical information about image compression...');
      AvlWriteLn('Picture size only (compressed):  '+stw(Header[w].size));
      tblsz:=MemW[FileMem+Header[w].ps div 16:Header[w].ps mod 16+4] and 32767;
      imgsz:=tblsz*8+Header[w].size+8;
      cds:=MemW[FileMem+Header[w].ps div 16:Header[w].ps mod 16+6+tblsz*8];
      fb:=Mem[FileMem+Header[w].ps div 16:Header[w].ps mod 16+8+tblsz*8];
      AvlWriteLn('Compression table size:          '+stw(tblsz));
      AvlWriteLn('Image header size:               '+stw(tblsz*8+8));
      AvlWriteLn('Uncompressed image size:         '+stw(wd*h+12));
      AvlWriteLn('Full (compressed) image size:    '+stw(imgsz));
      AvlWriteLn('Compressed:                      '+strl(imgsz/(wd*h+12)*100)+'%');
      AvlWriteLn('Codes in image:                  '+stw(cds));
        if w+1<ImagesIs then
         begin
          AvlWriteLn('Next image offset (calculated):  '+stl(imgsz+Header[w].ps));
          AvlWriteLn('Next image offset (real):        '+stl(Header[w+1].ps));
         end;
      end else
       begin
        AvlWriteLn('Full image size (calculated):           '+stw(wd*h+12));
        AvlWriteLn('Image size (real):                      '+stw(Header[w].size));
        if w+1<ImagesIs then
         begin
          AvlWriteLn('Next image offset (calculated):  '+stl(wd*h+12+Header[w].ps));
          AvlWriteLn('Next image (real):               '+stl(Header[w+1].ps));
         end;
       end;
     end;
   end;
 end;
end;

procedure MoveDown(o: longint; sz: word);
var mv,o1: longint;
    PFr,PTo: pointer;
    mr: word;
begin
 mv:=MemSize-o;
 PFr:=ptr(FileMem+o div 16,o mod 16);
 o1:=o-longint(sz);
 PTo:=ptr(FileMem+o1 div 16,o1 mod 16);
  repeat
   if mv>64000 then mr:=64000 else mr:=word(mv);
   MyMove1(PFr,PTo,mr);
   PFr:=Ptr(Seg(PFr^)+mr div 16,Ofs(PFr^)+mr mod 16); {Na stol'ko na skol'ko}
   PTo:=Ptr(Seg(PTo^)+mr div 16,Ofs(PTo^)+mr mod 16); {podvinuto}
   mv:=mv-mr;
  until mv=0;
end;

procedure MoveUp(o: longint; sz: word);
var mv,o1: longint;
    PFr,PTo: pointer;
    mr: word;
begin
 if ImagesIs=0 then exit;
 mv:=MemSize-o-longint(sz); {MemSize - uvelichennyi razmer}
 if mv>64000 then mr:=64000 else mr:=mv;
 o1:=MemSize-longint(mr)-longint(sz);
 o:=o1+longint(sz);
 PFr:=ptr(FileMem+o1 div 16,o1 mod 16);
 PTo:=ptr(FileMem+o div 16,o mod 16);
  repeat
   MyMove(PFr,Pto,mr);
   mv:=mv-mr;          {Na stol'ko na skol'ko nado budet dvigat'!}
   if mv>64000 then mr:=64000 else mr:=mv;
   PFr:=Ptr(Seg(PFr^)-mr div 16-1,Ofs(PFr^)+(16-mr mod 16));
   PTo:=Ptr(Seg(PTo^)-mr div 16-1,Ofs(PTo^)+(16-mr mod 16));
  until mv=0;
end;

procedure DeleteImage(ww: word; var bb: boolean);
var mv,mb,IImgSz,tblsz,wd,h,w1: word;
    iname: string[8];
    sz: longint;
    PTO,PFR: pointer;
begin
 if Header[ww].ImageType in[0,2] then ExtrImg(ww,true);
 if Header[ww].ImageType in[0,2] then
  begin
   AVLWriteLn('Cannot extract this image.');
   AVLWriteLn('Cannot delete this image.');
   exit;
  end;
 iname:=Header[ww].name;
 bb:=true;
      wd:=MemW[FileMem+Header[ww].ps div 16:Header[ww].ps mod 16];
      h:=MemW[FileMem+Header[ww].ps div 16:Header[ww].ps mod 16+2];
      AVLWriteLn('X:          '+stw(wd));
      AVLWriteLn('Y:          '+stw(H));
      IImgSz:=wd*h+12;
      AVLWriteLn('Image size: '+stw(IImgSz)+'    (calculated)');
      AVLWriteLn('Image size: '+stw(Header[ww].size)+'    (real)');

    if ww+1<ImagesIs then
    begin
     AVLWrite('Moving images in memory... ');
      sz:=MemSize-Header[ww+1].ps;
      PTO:=ptr(FileMem+Header[ww].ps div 16,Header[ww].ps mod 16);
      PFR:=ptr(FileMem+(Header[ww].ps+IImgSz) div 16,(Header[ww].ps+IImgSz) mod 16);
       repeat
        if sz>64000 then mv:=64000 else mv:=word(sz);
        MyMove1(PFR,PTO,mv);
        PTO:=ptr(seg(PTO^)+mv div 16,ofs(PTO^)+mv mod 16);
        PFR:=ptr(seg(PFR^)+mv div 16,ofs(PFR^)+mv mod 16);
        sz:=sz-longint(mv);
       until sz=0;
    end;

     AVLWriteLn(' - done.');

 Dec(ImagesIs);
 if ImagesIs>=ww+1 then for w1:=ww to ImagesIs-1 do
  begin
   Header[w1]:=Header[w1+1];
   Header[w1].ps:=Header[w1].ps-longint(IImgSz);
  end;
 BuildTable;
 MemSize:=MemSize-longint(IImgSz);
 mb:=MemSize div 16+2;
 if Not ChangeMemory(mb) then AVLWriteLn('Cannot change allocated memory size.');
 AVLWriteLn('Allocated memory size changed.');
 AVLWriteLn(stw(ImagesIs)+' images use '+stw(mb div 64)+' KBS of memory.');
 AVLWriteLn('Image '+iname+' with number '+stw(ww)+' deleted.');
 AVLWriteLn('This image size was '+stw(IImgSz)+' bytes.');
 AVLWriteLn('');
 DtChg:=true;
end;

procedure ExtrImg(w: word; rl: boolean);
var P,IPnt: pointer;
    szm,sz: word;
    w1,mb: word;
    SzWas: longint;
    Tblsz: word;
    prc: real;
begin
 AVLWriteLn('');
 if (not (Header[w].ImageType in[0,2])) and rl then
  begin
   AVLWriteLn('Cannot extract image. This image is not compressed. Compress image first.');
   AVLWriteLn('');
   exit;
  end;
 if (not (Header[w].ImageType in[1,3])) and (rl=false) then
  begin
   AVLWriteLn('Cannot compress image. This image already compressed. Extract it first.');
   AVLWriteLn('');
   exit;
  end;
  if rl then AVLWriteLn(Header[w].name+' - compressed image.') else
             AVLWriteLn(Header[w].name+' - as is (not compressed) image');
  GetMem(P,65535);
  IPnt:=ImagePointer[w];
  if longint(seg(IPnt^))*16+longint(ofs(IPnt^))<>Header[w].ps+longint(FileMem)*16 then
   begin
    AVLWriteLn('Incorrect image memory offset. Save images. Exit program. Restart computer.');
    FreeMem(P,65535);
    exit;
   end;
    if rl then
     begin
      tblsz:=MemW[FileMem+Header[w].ps div 16:Header[w].ps mod 16+4] and 32767;
      szwas:=tblsz*8+Header[w].size+8;
     end;
  if not rl then szwas:=Header[w].size;
  if rl then AVLWrite('Trying to extract image...');
  if not rl then AVLWrite('Compressing image...');
  if rl then
  asm
    push bp
    push ds
     push word ptr IPnt[2]
     pop es
     push word ptr IPnt
     pop bx
     push word ptr P
     pop si
     push word ptr P[2]
     pop ds
     push word ptr es:[bx]
     pop word ptr ds:[si]
     push word ptr es:[bx+2]
     pop word ptr ds:[si+2]
     add bx,4
     add si,4
      Call DeCompress {ES:BX -> DS:SI}
    pop ds
    pop bp
  end else
  begin
   sz:=szwas;
   IPnt:=Ptr(Seg(IPnt^),Ofs(IPnt^)+4);
   sz:=sz-4;
   EnCode(IPnt,P,sz,tblsz);
   IPnt:=Ptr(Seg(IPnt^),Ofs(IPnt^)-4);
   szm:=sz;
   sz:=sz+4+2+tblsz*8+2;
  end;
 if rl then sz:=Memw[seg(P^):ofs(P^)]*Memw[seg(P^):ofs(P^)+2]+12;
 AVLWriteLn(' - done.');
 if rl and ((Memw[seg(P^):ofs(P^)]>1000) or (Memw[seg(P^):ofs(P^)+2]>1000)) then
     begin
      FreeMem(P,65535);
      AVLWriteLn('Cannot extract image. Corrupted image. Exit program and restart computer.');
      AVLWriteLn('');
      exit;
     end;

   if SzWas>Sz then
    begin
     AVLWrite('Changing images offset... ');
     if (w+1<ImagesIs) then MoveDown(Header[w+1].ps,SzWas-sz);
     AVLWriteLn(' - done.');
    end;

   MemSize:=MemSize+(longint(Sz)-Longint(SzWas));
   mb:=MemSize div 16+2;
   if Not ChangeMemory(mb) then
    begin
     FreeMem(P,65535);
     AVLWriteLn('Cannot extract image. Not enough free memory.');
     if not rl then
      begin
       AVLWriteLn('Images in memory corrupted. Exit program and restart computer.');
       AVLWriteLn('You may save memory to new ALG file before exit.');
      end;
     exit;
    end;
    AVLWriteLn('Allocated memory block size changed.');

    if rl then szm:=sz;
    Header[w].size:=szm;

   if Sz>SzWas then
    begin
     AVLWrite('Changing images offset... ');
     if (w+1<ImagesIs) then MoveUp(Header[w+1].ps,sz-SzWas);
     AVLWriteLn(' - done.');
    end;

   if rl then MyMove(P,IPnt,sz) else
    begin
     IPnt:=Ptr(Seg(IPnt^),Ofs(IPnt^)+4);
     tblsz:=tblsz or 32768;
     MyMove(addr(tblsz),IPnt,2);
     tblsz:=tblsz and 32767;
     IPnt:=Ptr(Seg(IPnt^),Ofs(IPnt^)+2);
     MyMove(addr(TimesTable),IPnt,tblsz*8);
     IPnt:=Ptr(Seg(IPnt^),Ofs(IPnt^)+tblsz*8);
     MyMove(addr(SZwas),IPnt,2);
     IPnt:=Ptr(Seg(IPnt^),Ofs(IPnt^)+2);
     MyMove(P,IPnt,szm);
     IPnt:=Ptr(Seg(IPnt^),Ofs(IPnt^)-8-tblsz*8);
    end;

    AVLWrite('Creating images offset table... ');
    If ImagesIs>w+1 then for w1:=w+1 to ImagesIs-1 do
      Header[w1].ps:=Header[w1].ps+longint(Sz)-longint(SzWas);
    BuildTable;
    AVLWriteLn(' - done.');

 FreeMem(P,65535);
 if rl then Inc(Header[w].ImageType) else Dec(Header[w].ImageType);
 prc:=100;
 if not rl then if SzWas<>0 then prc:=Sz/SzWas*100;
 if not rl then AVLWriteLn('Ok. Image compressed ('+strl(prc)+'%). Done.');
 if rl then AVLWriteLn('Ok. Image extracted. Done.');
 DtChg:=true;
end;

procedure SaveToPcxFile(iw: word; fn: string);
type pcxbi=record case integer of
       1:(bm:array[0..127] of byte);
       2:( pcx_id  : byte;   { 0) 0x0a = ZSoft .PCX file          }
           pcx_ver : byte;   { 1) 0x05 = PC PaintBrush 3.0        }
           encode  : byte;   { 2) 0x01 = RLE                      }
           bpp     : byte;   { 3) 0x01 = bits/pixel why VGA16=1?  }
           left    : word;   { 4-5) Window Left                   }
           top     : word;   { 6-7) Window Top                    }
           right   : word;   { 8-9) Window Right                  }
           bott    : word;   { 10-11) Window Bottom               }
           xres    : word;   { 12-13) Horizontal resolution       }
           yres    : word;   { 14-15) Vertical resolution         }
           rgb     : array[0..15,1..3] of byte;  { (R-G-B) values }
           resv    : byte;   { 64) Reserved                       }
           bplanes : byte;   { 65) Number of bit planes, VGA16=4  }
           bpl     : word;   { 66-67) # of bytes/line, VGA16=80   }
           ptype   : word;   { 68-69) palette type, color=1       }
           unused  : array[70..127] of byte;
           );
         end;

var pheader       : pcxbi;
    f             : file;
    fg,fw         : longint;
    w,num         : word;
    x,y,xs,ys,h,tb: word;
    b,z,c,cnt     : byte;
    palrad        : array[0..255,0..2] of byte;
    r             : registers;
    icmp          : boolean;
    ch            : char;
    i             : integer;

function GetPxl(x,y: word): byte;
var P: pointer;
    pl: byte;
    w,h,d,sr,w1: word;
begin
 P:=ImagePointer[iw];
 pl:=x mod 4;
 w:=memw[seg(P^):ofs(P^)];
 h:=memw[seg(P^):ofs(P^)+2];
 sr:=4;
 if pl>0 then sr:=sr+memw[seg(P^):ofs(P^)+sr]*h+2;
 if pl>1 then sr:=sr+memw[seg(P^):ofs(P^)+sr]*h+2;
 if pl>2 then sr:=sr+memw[seg(P^):ofs(P^)+sr]*h+2;
 w1:=memw[seg(P^):ofs(P^)+sr];
 sr:=sr+w1*y+2;
 sr:=sr+x div 4;
 GetPxl:=mem[seg(P^):ofs(P^)+sr];
end;

begin
if fn='' then fn:=Header[iw].name;
if fn='' then
 begin
  AVLWriteLn('Incorrect file name '+fn);
  exit;
 end;
fg:=0;
fw:=0;
x:=memw[seg(ImagePointer[iw]^):ofs(ImagePointer[iw]^)];
y:=memw[seg(ImagePointer[iw]^):ofs(ImagePointer[iw]^)+2];
if longint(longint(x)*
   longint(y))>64012 then
   begin
    AVLWriteLn('Cannot show image. Corrupted image.');
    exit;
   end;

 pheader.pcx_id:=10;
 pheader.pcx_ver:=5;
 pheader.encode:=1;
 pheader.bpp:=8;
 pheader.left:=0;
 pheader.top:=0;
 pheader.bott:=y-1;
 pheader.right:=x-1;
 pheader.xres:=320;
 pheader.yres:=200;
 pheader.bplanes:=1;
 pheader.bpl:=(x) div 2*2;
 if pheader.bpl<>(x) then pheader.bpl:=pheader.bpl+2;
 pheader.ptype:=1;

 if pos('.',fn)=0 then fn:=fn+'.PCX';
 assign(f,fn);
 {$I-}
 reset(f,1);
 {$I+}
 if IoResult=0 then
  begin
   AVLWrite('File '+fn+' already exist. Overwrite it? [Y] [N] ');
   repeat
    ch:=AVLReadKey;
   until ch in['n','N','y','Y'];
   AVLWriteLn(ch);
   if ch in['n','N'] then exit;
   {$I-}
   close(f);
   {$I+}
   i:=IoResult;
  end;

 {$I-}
 rewrite(f,1);
 {$I+}
 if IoResult<>0 then
  begin
   AVLWriteLn('Cannot create file '+fn);
   exit;
  end;

 if Header[iw].ImageType in[0,2] then
  begin
   ExtrImg(iw,true);
   ICMP:=true;
  end else ICMP:=false;

 AVLWriteLn('');
 AVLWrite('Creating '+fn+' file... ');

 blockwrite(f,pheader.bm,128,num); fg:=fg+num; fw:=fw+128;
 xs:=x;
 ys:=y;
 tb:=pheader.bplanes*pheader.bpl;
 w:=0;
 h:=0;

 repeat
  cnt:=1;
  c:=getpxl(w,h);
  while (c=getpxl(w+cnt,h)) and (cnt<63) and (cnt+w<x) do cnt:=cnt+1;

  if ((cnt>1) or (c and 192=192)) and (w<xs) then
   begin
    w:=w+cnt;
    b:=192+cnt;
    blockwrite(f,b,1,num); fg:=fg+num; fw:=fw+1;
    blockwrite(f,c,1,num); fg:=fg+num; fw:=fw+1;
   end else if (w<xs) then
   begin
    w:=w+1;
    blockwrite(f,c,1,num); fg:=fg+num; fw:=fw+1;
   end else if (w>=tb) then
   begin
    h:=h+1;
    w:=0;
   end else
   begin
    c:=0;
    blockwrite(f,c,1,num); fg:=fg+num; fw:=fw+1;
    w:=w+1;
     if w>=tb then
      begin
       h:=h+1;
       w:=0;
      end;
   end;
 until h>=ys;

 mymove1(addr(palf),addr(palrad),768);
 for w:=0 to 255 do for b:=0 to 2 do palrad[w,b]:=palrad[w,b] * 4;
 b:=12;
 blockwrite(f,b,1,num); fg:=fg+num; fw:=fw+1;
 blockwrite(f,palrad,768,num); fg:=fg+num; fw:=fw+768;
 {$I-}
 close(f);
 {$I+}
 i:=IoResult;
 AVLWriteLn(' - done.');
 if ICMP then ExtrImg(iw,false);
 AVLWriteLn('');
 if fw<>fg then
  begin
   AVLWriteLn('ERROR: Cannot write to file '+fn);
   AVLWriteLn('Disk full?');
   {$I-}
   erase(f);
   {$I+}
   if IoResult<>0 then AVLWriteLn('ERROR: cannot erase file '+fn);
  end else AVLWriteLn(fn+' file created.');
end;

procedure AddBorder(w: word; msm: byte);
var P: pointer;
    j,MBP: byte;
    ch: char;
    oy,w1,ww: word;
    pxl: byte;
    PMX,PMY,BLX,BLY: integer;
    LOut: boolean;
    s1: string;
    bb: byte;
    Yw,Ys: word;
begin
if longint(longint(memw[seg(ImagePointer[w]^):ofs(ImagePointer[w]^)])*
   longint(memw[seg(ImagePointer[w]^):ofs(ImagePointer[w]^)+2]))>64012 then
   begin
    AVLWriteLn('Cannot show image. Corrupted image.');
    exit;
   end;

if msm<>2 then
 begin
  DtChg:=true;
  LOut:=false;
  BLX:=32000;
  ch:=#0;
  if Header[w].Pixels<>0 then
   begin
    AVLWriteLn('');
    AVLWriteLn('Old border detected. Do you want to');
    AVLWriteLn('  1) Edit this border');
    AVLWriteLn('  2) Erase this border and start new one');
    AVLWriteLn('  3) Cancel this operation without changes');
    AVLWrite('');
     Repeat
      ch:=AVLReadKey;
     until ch in['1','2','3'];
     AVLWriteLn(ch);
     if ch='3' then exit;
     if ch='2' then
      begin
       Header[w].Pixels:=0;
       for w1:=0 to 25 do
        begin
         Header[w].Border[w1].x:=0;
         Header[w].Border[w1].y:=0;
        end;
      end;
     if ch='1' then
      begin
       BLX:=Header[w].Border[Header[w].Pixels-1].x;
       BLY:=Header[w].Border[Header[w].Pixels-1].y;
      end;
   end; {if ...Pixels<>0}
 end; {if MSM<>2}

if (msm=0) then if not InitMouse then
   begin
    OutError(14,'');
    exit;
   end;

    if Header[w].imagetype>1 then OutError(13,Header[w].name);
    SaveScreen(BGp);
    if ModeNow=0 then Set_320x200;
    if ModeNow=1 then Set_320x240;
    if ModeNow=2 then Set_320x400;
    if ModeNow=0 then Ys:=160 else
    if ModeNow=1 then Ys:=200 else Ys:=360;
    CVM(0);
    BiosSETPalette(ColPal div 256,ColPal mod 256,Palf);
    BiosSETPalette(0,5,MyOwnPal);
    getmem(p,64002);
    if Header[w].picturetype and 64=64 then TransparentColor:=0 else
                                            TransparentColor:=1;
     for pxl:=0 to (msm and 2 div 2 xor 1) do
      begin
       Set_Visual_Page(pxl xor 1);
       Set_Active_Page(pxl);
       if Header[w].imagetype=0 then PutImage(0,0,ImagePointer[w],P,1);
       if Header[w].imagetype=1 then PutImage(0,0,ImagePointer[w],P,0);
       if (Header[w].PixelS>0) and ((msm=2) or (ch='1')) then
        begin
           for w1:=1 to Header[w].PixelS-1 do
               line(Header[w].Border[w1-1].x,Header[w].Border[w1-1].y,
                    Header[w].Border[w1].x,Header[w].Border[w1].y,4);
           if msm=2 then line(Header[w].Border[w1].x,Header[w].Border[w1].y,
                              Header[w].Border[0].x,Header[w].Border[0].y,4);
        end;
       yw:=YH;
       YH:=Ys+40-1;
       ColNow:=4;
       if msm<2 then OutTextXy(140,Ys,'Usage:');
       ColNow:=3;
       if msm=0 then
        begin
         OutTextXy(1,Ys+12,'Left mouse button:                  new pixel and line');
         OutTextXy(1,Ys+24,'Right mouse button or ESC:       when done');
        end else if msm=1 then
        begin
         OutTextXy(1,Ys+9,'arrows keys:            move cursor');
         OutTextXy(1,Ys+19,'space bar  key:         new pixel and line');
         OutTextXy(1,Ys+28,'esc:                       when done');
        end else
        begin
         OutTextXy(110,Ys,'Press any key...');
        end;
       YH:=yw;
      end;

    Set_Active_Page(0);
    if msm=2 then Set_Visual_Page(0);


    if msm<>2 then
     begin
      if (msm=0) then MouseInit(true) else MouseInit(false);
      mouse_off;
         if CURMOU then mouse_on(true) else
          begin
           if (msm=0) then mouse_on(false);
           SetPut(24);
           PMX:=MouseX;
           PMY:=MouseY;
           Line(PMX-5,PMY,PMX+5,PMY,255);
           Line(PMX,PMY-5,PMX,PMY+5,255);
           SetPut(0);
          end;

        repeat
         repeat until MouseB and LeftB=0;
         While AVLKeyPressed do AVLReadKey;
         MBP:=0;
          repeat
           if not AVLKeyPressed and (msm=1) then for j:=1 to 8 do
            begin
             ww:=memw[$40:$6C];
             repeat until (memw[$40:$6C]<>ww) or AVLKeyPressed;
            end;
           if not AVLKeyPressed then chcoor(0);
          until AVLKeyPressed or ((msm=0) and (MouseB<>0)) or
                (MouseX<>PMX) or (MouseY<>PMY);
         if (msm=0) then MBP:=MouseB;

         if CURMOU then mouse_off else
          begin
           SetPut(24);
           Line(PMX-5,PMY,PMX+5,PMY,255);
           Line(PMX,PMY-5,PMX,PMY+5,255);
           SetPut(0);
          end;

         SetPut(24);
         if LOut and (BLX<>32000) then Line(BLX,BLY,PMX,PMY,255);
         SetPut(0);

         if BLX<>32000 then LOut:=true;

          if AVLKeyPressed then
           begin
            ch:=AVLReadKey;
            if ch=#27 then MBP:=RightB;
            if ch=' ' then MBP:=LeftB;
            if ch=#0 then
             begin
              ch:=AVLReadKey;
              if (msm=1) then
               begin
                if (ch='H') then chcoor(1);
                if (ch='P') then chcoor(2);
                if (ch='M') then chcoor(3);
                if (ch='K') then chcoor(4);
               end;
             end;
           end;

         PMX:=MouseX;
         PMY:=MouseY;

        if MBP and LeftB=LeftB then
         begin
          pxl:=Header[w].Pixels;
          if pxl<=24 then
           begin
            CopyPage(VPage xor 1);
            Set_Active_Page(VPage xor 1);

            oy:=yh;
            yh:=ys+38;
            s1:='';
            for bb:=0 to pxl do s1:=s1+'*';
            ColNow:=2;
            OutTextXy(150,ys+32,s1);
            yh:=oy;

            BLX:=PMX;
            BLY:=PMY;
            Header[w].Border[pxl].x:=BLX;
            Header[w].Border[pxl].y:=BLY;
            if pxl>0 then
              line(Header[w].Border[pxl-1].x,Header[w].Border[pxl-1].y,
                   Header[w].Border[pxl].x,Header[w].Border[pxl].y,4);
            inc(pxl);
            Header[w].Pixels:=pxl;
            Set_Visual_Page(VPage xor 1);
           end;
         end;

        SetPut(24);
        if BLX<>32000 then Line(BLX,BLY,PMX,PMY,255);
        SetPut(0);

         if CURMOU then mouse_on(true) else
          begin
           SetPut(24);
           Line(PMX-5,PMY,PMX+5,PMY,255);
           Line(PMX,PMY-5,PMX,PMY+5,255);
           SetPut(0);
          end;

        until MBP and RightB=RightB;
      if (msm=0) then MouseKill(true) else MouseKill(false);
     end else AVLReadKey; {If MSM<>2}
    freemem(p,64002);
    InLine($B8/$03/$00/$CD/$10);    { mov ax,013h; int 10h   }
    LoadScreen(BGp);
    if MSM<>2 then
     begin
      AVLWriteLn('');
      AVLWriteLn('Edition done. Usage -V to view the result.');
      AVLWriteLn('Usage -A or -K to edit or to remove border.');
      AVLWriteLn('');
     end;
end;

procedure OutPutEditHelp;
begin
  AVLWriteln('');
  AVLWriteln('');
  AVLWriteln('************************** PICTURE EDIT HELP SCREEN **************************');
  AVLTextColor(2);
  AVLWriteLn('                                   Usage:');
  AVLWriteLn('Command             Description');
  AVLTextColor(7);
  AVLWriteLn(' -n                 Switch to next image.');
  AVLWriteLn(' -p                 Switch to previous image.');
  AVLWriteLn(' -d                 Delete current image and exit to MAIN PROGRAM');
  AVLWriteLn(' -a                 Add border to image (need mouse, in graphic mode)');
  AVLWriteLn(' -k                 Add border to image (with keyboard, in graphic mode)');
  AVLWriteLn(' -v                 View current image and its border (in graphic mode)');
  AVLWriteLn(' -l                 Shows information about this image');
  AVLWriteLn(' -c                 Configurate picture type byte');
  AVLWriteLn(' -0                 Extract this image');
  AVLWriteLn(' -1                 Compress this image (very fast algorithm by A. Larkin!)');
  AVLWriteLn(' -7                 Select graphic modeX 320x200x256 (text help over picture)');
  AVLWriteLn(' -8                 Select graphic modeX 320x240x256 (with text help, default)');
  AVLWriteLn(' -9                 Select graphic modeX 320x400x256 (with text help)');
  AVLWriteLn(' -m                 Change mouse cursor. If invisible or twinkle, try this.');
  AVLWriteLn(' -q file_name       Save current image to file in PCX format');
  AVLWriteLn(' -z directory_name  Change current directory.');
  AVLWriteLn(' -x                 Exit from PICTURE EDIT to MAIN PROGRAM');
end;

procedure ChMCur;
begin
 CurMou:=not CurMou;
 if CurMou then
  begin
   AVLWriteLn('Standart (arrow) mouse cursor selected. This cursor always work correct,');
   AVLWriteLn('but it may twinkle sometimes when you move mouse.');
  end;
 if not CurMou then
  begin
   AVLWriteLn('Additional (two lines) mouse cursor selected. This cursor do not twinkle,');
   AVLWriteLn('but it may be invisible with some kinds of ALG files. (THIS IS DEFAULT CURSOR)');
  end;
 AVLWriteLn('');
 AVLWriteLn('This program use mouse cursor in graphic modes. You may turn on graphic');
 AVLWriteLn('with few commands like -A or -K.');
end;

procedure ShowModeOnOff;
begin
 ImageShow:=not ImageShow;
 if ImageShow then
  begin
   AVLWriteLn('Image show mode turned on. Each loaded BMP file will be showen in');
   AVLWriteLn('current graphic mode. Use -B option to see the result of this mode.');
  end;
 if not ImageShow then
  begin
   AVLWriteLn('Image show mode turned off. You may load BMP files with option -B.');
   AVLWriteLn('The picture will not be showen before adding it to ALG memory block.');
  end;
 AVLWriteLn('');
 AVLWriteLn('Use -B [File_Name.BMP] to see the result of this image show mode.');
 AVLWriteLn('[File_Name.BMP] is any 256 colors BMP file.');
 AVLWriteLn('');
end;

procedure EditImage(i: string);
var OKQUIT: boolean;
    w,iw: word;
begin
if not GFO then OutError(9,'') else
 begin
  AVLWriteLn('');
  w:=0;
  if i='' then
   begin
    if CurImg>0 then i:=stw(CurImg-1) else i:='0';
   end;
  if (i<>'') and (i[1] in['0'..'9']) then w:=vl(i) else
  if ImagesIs>0 then while (not equ(i,Header[w].name)) and (w<ImagesIs) do inc(w);
  if w>=ImagesIs then OutError(10,i) else
   begin
    iw:=w;
    AVLWriteLn('');
    AVLWriteLn('Entered to PICTURE EDIT program module.');
    AVLWriteLn('');
    OKQUIT:=false;
     repeat
      AVLWriteln('******************************************************************************');
      AVLWriteLn('Free memory: '+stl(MemorySize));
      AVLWriteLn('Enter -? for help');
      AVLTextColor(2);
      AVLWrite('PICTURE EDIT ');
      AVLTextColor(7);
      AVLWrite('> ');
      w:=ReadCommand(s);
       case w of
        65: AddBorder(iw,0);        {A}
        68: DeleteImage(iw,OKQUIT); {D}
        78: if iw+1<ImagesIs then inc(iw) else
            AVLWriteLn('NO MORE IMAGES');{N}
        80: if iw>0 then dec(iw) else
            AVLWriteLn('ALREADY AT FIRST IMAGE'); {P}
        67: PictureTypeByte(iw);    {C}
        75: AddBorder(iw,1);        {K}
        86: AddBorder(iw,2);        {V}
        63: OutPutEditHelp;         {?}
        72: OutPutEditHelp;         {H}
        76: ShowNames(stw(iw));     {L}
        88: OKQUIT:=true;           {X}
        48: ExtrImg(iw,true);       {0}
        49: ExtrImg(iw,false);      {1}
        55: ModeNow:=0;             {7}
        56: ModeNow:=1;             {8}
        57: ModeNow:=2;             {9}
        77: ChMCur;                 {M}
        90: DirChange(s);           {Z}
        81: SaveToPcxFile(iw,s);    {Q}
        0..255: OutError(w,'');
       end;
      if w=55 then AVLWriteLn('Not standart 4 planes VGA modeX 320x200x256 selected (without help).');
      if w=56 then AVLWriteLn('Not standart 4 planes VGA modeX 320x240x256 selected (without help).');
      if w=57 then AVLWriteLn('Not standart 4 planes VGA modeX 320x400x256 selected (with help text).');
      if w in[56,57] then AVLWriteLn('The graphic commands will work in this mode now. For example -A command');
      if w in[56,57] then AVLWriteLn('is graphic command (command that turn on graphic screen).');
     until OKQUIT;
    AVLWriteLn('');
    AVLWriteLn('Came back to MAIN PROGRAM module.');
    AVLWriteLn('');
   end;
 end;
end;

procedure LoadAAIFile(fn: string);
var f: file;
    l: longint;
    Border: Brd;
    W,W1,Num1,Num: word;
    s: string[8];
    b1,b: byte;

begin
 w:=0;
 If pos('.',fn)=0 then fn:=fn+'.AAI';
 If not OpenFile(f,fn) then
  begin
   OutError(34,fn);
   exit;
  end;
 Reset(f,1);
 BlockRead(f,l,4,num);
 if (num<>4) or (l<>123454321) then
  begin
   Close(f);
   OutError(35,fn);
   exit;
  end;
   repeat
    BlockRead(f,s,9,num);
    if s<>'EOF' then
     begin
      BlockRead(f,Border,SizeOf(Border),num);
      BlockRead(f,b,1,num1);
      BlockRead(f,b1,1,num1);
      if (num<>SizeOf(Border)) or (num1<>1) then
       begin
        Close(f);
        OutError(36,fn);
        exit;
       end;
      for w1:=0 to ImagesIs-1 do if s=Header[w1].name then
       begin
        w:=w+1;
        Header[w1].border:=border;
        Header[w1].PictureType:=b;
        Header[w1].Pixels:=b1;
        AVLWriteLn(s+' picture number is '+stw(w1)+'. This picture border updated to new one.');
       end;
     end;
   until s='EOF';
 Close(f);
 AVLWriteLn('');
 AVLWriteLn(stw(w)+' pictures borders updated.');
 AVLWriteLn(fn+' file read done.');
 AVLWriteLn('');
end;

procedure SaveAAIFile(fn: string);
var f: file;
    w,wr,nm,l: longint;
    ch: char;
    num: word;
begin
 wr:=0;
 nm:=0;
 If Pos('.',fn)=0 then fn:=fn+'.AAI';
 If OpenFile(f,fn) then
  begin
   AVLWrite('File '+fn+' already exist. Do you want to overwrite it?  [Y]/[N]  ');
    Repeat
     Ch:=AVLReadKey;
    until Ch in['y','n','Y','N'];
   Close(f);
   AVLWriteLn(ch);
   if ch in['n','N'] then exit;
  end;
 {$I-}
 ReWrite(f,1);
 {$I+}
 if IoResult<>0 then
  begin
   AVLWriteLn('Cannot create file '+fn);
   exit;
  end else AVLWriteLn(fn+' file created.');
 l:=123454321;
 BlockWrite(f,l,4,num); Wr:=Wr+4; Nm:=Nm+num;
 for w:=0 to ImagesIs-1 do
  begin
   BlockWrite(f,Header[w].name,9,num); Wr:=Wr+9; Nm:=Nm+num;
   BlockWrite(f,Header[w].Border,SizeOf(Brd),num); Wr:=Wr+SizeOf(Brd); Nm:=Nm+num;
   BlockWrite(f,Header[w].PictureType,1,num); Wr:=Wr+1; Nm:=Nm+num;
   BlockWrite(f,Header[w].Pixels,1,num); Wr:=Wr+1; Nm:=Nm+num;
  end;
 s:='EOF';
 BlockWrite(f,s,9,num); Wr:=Wr+9; Nm:=Nm+num;
 Close(f);
 if Wr<>Nm then
  begin
   Erase(f);
   AVLWriteLn('Corrupted file '+fn+' erased.');
   AVLWriteLn('Cannot write to file. Disk full?');
  end;
end;

procedure FileMenu;
var OKQUIT: boolean;
    w: word;
begin
  AVLWriteLn('');
  AVLWriteLn('');
  AVLWriteLn('Entered to FILE MENU program module.');
  AVLWriteLn('');
    OKQUIT:=false;
     repeat
      AVLWriteln('******************************************************************************');
      AVLWriteLn('Free memory: '+stl(MemorySize));
      AVLWriteLn('Enter -? for help');
      AVLTextColor(2);
      AVLWrite('FILE COMMAND ');
      AVLTextColor(7);
      AVLWrite('> ');
      w:=ReadCommand(s);
       case w of
        63: OutPutFileMenuHelp;          {?}
        72: OutPutFileMenuHelp;          {H}
        67: SetColConst;                 {C}
        76: ShowNames(s);                {L}
        88: OKQUIT:=true;                {X}
        82: LoadAlgFile(s,true);         {R}
        79: LoadAlgFile(s,false);        {O}
        87: SaveAlgFile(s);              {W}
        71: LoadAAIFile(s);              {G}
        80: SaveAAIFile(s);              {P}
        66: OutError(LoadBMPFile(s),s);  {B}
        65: LoadAllBMPfiles;             {A}
        83: ShowModeOnOff;               {S}
        90: DirChange(s);                {Z}
        0..255: OutError(w,'');
       end;
     until OKQUIT;
    AVLWriteLn('');
    AVLWriteLn('Came back to MAIN PROGRAM module.');
    AVLWriteLn('');
end;

function CanExit: boolean;
var ch: char;
begin
    AvlWriteLn('Data not saved. Are you sure you want to quit?');
    AvlWriteLn('Press Y for quit.');
    AvlWriteLn('Press N or ESC to continue.');
     repeat
      ch:=avlreadkey;
     until ch in[#27,'n','N','y','Y'];
    if ch in['n','N',#226,#146,#27] then CanExit:=false else CanExit:=true;
end;

var w,w1: word;

begin
DtChg:=false;
GfnAlg:='DEFAULT.ALG';
Gfn:='';
ColPal:=0;
{$I-}
GetDir(0,od);
{$I+}
If IoResult<>0 then;
LUCOL:=-1;
FUCOL:=256;
SaveScreen(OLDscr);
ModeNow:=1;
OKQUIT:=false;
CurImg:=0;
Clear(1792);
AVLGotoXy(1,1);
AVLTextBackGround(0);
getmem(InitFont,23000);
 asm
  jmp @NOFP
  call FontPointer
  @NOFP:
  mov ax,SEG(FontPointer)
  mov es,ax
  mov bx,OFFSET(FontPointer)
  add bx,3
  mov ax,WORD PTR InitFont[2]
  push dx
  push ds
  mov si,WORD PTR InitFont
  mov ds,ax
  mov word ptr ds:[0],0
  cmp byte ptr es:[bx],239
  je @FNDOK
  add bx,7
  cmp byte ptr es:[bx],239
  jne @BadCode
  @FNDOK:
  push bp
  call DeCompress
  pop bp
  @BadCode:
  pop ds
  pop dx
 end;
if memw[seg(InitFont^):ofs(InitFont^)]<>17232 then
 begin
  OutError(15,'');
  AVLWriteLn('Error. Program terminated.');;
  halt;
 end;
 repeat
  AVLWriteln('******************************************************************************');
  AVLWriteLn('Free memory: '+stl(MemorySize));
  AVLWriteLn('Enter -? for help');
  AVLTextColor(2);
  AVLWrite('ENTER COMMAND');
  AVLTextColor(7);
  AVLWrite('> ');
  w:=ReadCommand(s);
   case w of
    70: FileMenu;       {F}
    76: ShowNames(s);   {L}
    69: EditImage(s);   {E}
    63: OutPutHelp;     {?}
    72: OutPutHelp;     {H}
    88: OKQUIT:=true;   {X}
    90: DirChange(s);   {Z}
    73: OutPutMoreInfo; {I}
    0..255: OutError(w,'');
   end;
  if OKQUIT and DtChg and (CanExit=false) then OKQUIT:=false;
 until OKQUIT;
FreeALG;
LoadScreen(OLDscr);
freemem(InitFont,23000);
{$I-}
ChDir(od);
{$I+}
If IoResult<>0 then;
end.