Unit AlgHigh;

INTERFACE

Function LoadAlgHigh(fn: string): byte;

IMPLEMENTATION

var ExtFileMem: word;
    ExtMemSize: longint;

Function OpenFile(var f: file; fn: string): boolean;
var way: string;
begin
if fn='' then OpenFile:=False else
 begin
  Assign(f,fn);
  {$I-}
  Reset(f,1);
  {$I+}
  if IoResult<>0 then
   begin
    Way:=ParamStr(0);
    While (Way<>'') and (not (Way[Length(Way)] in['/','\']))
                         do delete(Way,Length(Way),1);
    Assign(f,way+fn);
    {$I-}
    Reset(f,1);
    {$I+}
   end;
  If IoResult<>0 then OpenFile:=False else OpenFile:=true;
 end;
end;


Function LoadAlgHigh(fn: string): byte;
Var f: file;
    err: byte;
    sz,t,l: longint;
    as,num: word;
    ir: integer;
    b: byte;
    s: string;
Begin
t:=0;

if pos('.',fn)=0 then fn:=fn+'.ALG';
 If not OpenFile(f,fn) then
  begin
   LoadAlgHigh:=1;
   exit;
  end;

 BlockRead(f,l,4,num); t:=t+num;
 if FileSize(f)<l then
  begin
   {$I-}
   close(f);
   {$I+}
   ir:=IoResult;
   LoadAlgHigh:=2;
   exit;
  end;
 BlockRead(f,b,1,num); t:=t+num;
 s[0]:=chr(b-5);
 BlockRead(f,s[1],b-5,num); t:=t+num;
 as:=0;
 if length(s)>2 then for num:=1 to length(s)-2 do as:=as+ord(s[num]);
 if (as div 256<>ord(s[length(s)-1])) or (as mod 256<>ord(s[length(s)]))
                                     then err:=8 else
 begin
  {$I-}
  seek(f,0);
  {$I+}
  if ioresult<>0 then err:=2;

  if ExtFileMem=0 then
   begin
    ExtMemSize:=l;
    sz:=l div 1024+1;
    If XMSInstalled then
     begin
      XMSInit;
      if not XMSAllocate(ExtFileMem,sz) then err:=15;
     end else err:=14;
   end;


End;


End.