{ ************************** Introduction **********************************
  Created on 10/6/1998 for program TEACHER.PAS. This unit have the same
  procedures and functions like in CRT. This procedures and functions use
  BIOS.

  Author name:        Alexander Larkin
  E-mail address:     avlarkin@writeme.com
  Internet address:   http://www.geocities.com/SiliconValley/6235/tpdl.htm
}

unit AVLcrt;
INTERFACE

uses dos; {It is possible to use Build-in assembler instead of "Registers"
and "Intr" from unit DOS. I think that it is better to do so, but I use
here unit DOS, because I would not like to use Build-in assembler in such
an easy and little program as this one.                                    }

const
    FgColor: byte=7;      {Current foreground color                        }
    BgColor: byte=0;      {Current background color                        }
    CurX: word=1;         {Current coordinates                             }
    CurY: word=1;         {Current coordinates                             }
    GMode: boolean=false; {Graphic mode flag                               }

var
    NextKey: byte;     {Used by ReadKey function                           }

Procedure AVLClrScr;
Procedure AVLGotoXy(x,y: word);
Procedure AVLWrite(s: string);
Procedure AVLWriteln(s: string);
Procedure AVLTextBackGround(b: byte);
Procedure AVLTextColor(b: byte);
Function  AVLReadKey: char;
Function  AVLKeyPressed: boolean;
Procedure AVLDelay(w: word);
Function  AVLSt(i: integer): string;

{Next few function and procedure not from unit CRT, but use BIOS too.      }
procedure set_mode320x200;
procedure set_modetxt80x25;
procedure BiosPaletteSet(ColF,ColT: byte; Var Pal);
              { ColF - first color
                ColT - last color
                Pal  - FULL palette (more than ColT colors. Each color are
                three components. Look TEACHER.PAS source code for more info
                about colors.                                              }

IMPLEMENTATION

Procedure AVLGotoXy(x,y: word);
var R: registers;
begin
 CurX:=x;
 CurY:=y;
 R.AH:=02;          {Function number 2                }
 R.BH:=0;           {Page number (0 for graphic mode) }
 R.DH:=y mod 256-1; {Row                              }
 R.DL:=x mod 256-1; {Column                           }
 Intr($10,R);       {Call BIOS graphic interrupt      }
end;

Procedure WriteChar(ch: char);
var R: registers;
begin
 AVLGotoXy(CurX,CurY);
 R.AH:=09;        {Bios function 09 - put character      }
 R.AL:=ord(ch);   {Character to write                    }
 R.BH:=BgColor;   {BackGround color in graphic mode 13h  }
 R.BL:=FgColor;   {Foreground color in graphic mode 13h  }
 R.CX:=1;         {Number of characters for output       }
 Intr($10,R);     {Call BIOS graphic interrupt           }
 if CurX=79 then
  begin
   CurX:=0;
   CurY:=CurY+1;
  end;
 AVLGotoXy(CurX+1,CurY);
end;

Procedure AVLWrite(s: string);
var b: byte;
begin
for b:=1 to length(s) do WriteChar(s[b]);
end;

Procedure AVLWriteln(s: string);
var b: byte;
begin
for b:=1 to length(s) do WriteChar(s[b]);
AVLGotoXy(1,CurY+1);
if CurY>=25 then
 begin
  WriteLn;
  while CurY>=25 do CurY:=CurY-1;
 end;
end;

Procedure AVLTextBackGround(b: byte);
begin
 if GMode then BgColor:=b else
  begin
   FgColor:=FgColor and 15;
   FgColor:=FgColor or (b shl 3);
   BgColor:=0;
  end;
end;

Procedure AVLTextColor(b: byte);
begin
 FgColor:=FgColor and 240;
 b:=b and 15;
 FgColor:=FgColor or b;
end;

Function AVLReadKey: char;
var R: registers;
begin
if NextKey<>0 then
 begin
  AVLReadKey:=Chr(NextKey);
  NextKey:=0;
 end else
 begin
   R.AH:=00;        {BIOS function 0                }
   Intr($16,R);     {Call BIOS keyboard interrupt   }
   if R.AL<>0 then AVLReadKey:=Chr(R.AL) else
    begin
     NextKey:=R.AH;
     AVLReadKey:=#0;
    end;
 end;
end;

Function AVLKeyPressed: boolean;
var R: registers;
begin
 R.AH:=01;          {BIOS function 1                               }
 Intr($16,R);       {Call BIOS keyboard interrupt                  }
 {ZF flag return FALSE when there is a key in BIOS keyboard buffer }
 if R.Flags and 64<>64 then AVLKeyPressed:=true else AVLKeyPressed:=false;
 if NextKey<>0 then AVLKeyPressed:=true;
end;

Function AVLSt(i: integer): string;
var s: string;
begin
 Str(i,s);
 AVLSt:=s;
end;

Procedure AVLDelay(w: word);
var CC,CC1,TimeGone: word;
begin
 CC:=memw[$40:$6C];
  repeat
   CC1:=memw[$40:$6C];
   if CC>CC1 then TimeGone:=CC-CC1 else TimeGone:=CC1-CC;
  until (TimeGone*54>=w) or AVLKeyPressed;
end;

{set VGA mode 320x200x256                                                    }
procedure set_mode320x200;
var R: registers;
begin
 R.ax:=$13;
 intr($10,R);
 GMode:=true;
 FGColor:=FGColor and 15;
end;

{set usualy 80x25x16 text mode                                               }
procedure set_modetxt80x25;
var R: registers;
begin
 R.ax:=$3;
 intr($10,R);
 GMode:=false;
 BGColor:=0;
 FGColor:=7;
end;

procedure BiosPaletteSet(ColF,ColT: byte; Var Pal);
var R: registers;
begin
    R.AH:=$10;
    R.AL:=$12;
    R.BX:=ColF;
    R.CX:=ColT;
    R.ES:=seg(Pal);
    R.DX:=ofs(Pal)+ColF*3;
    intr($10,R);
end;

Procedure AVLClrScr;
var x,y: byte;
begin
 for y:=1 to 25 do
 for x:=1 to 80 do
  begin
   AVLGotoXy(x,y);
   AVLWrite(' ');
  end;
 AVLGotoXy(1,1);
end;

end.