unit bitswork;
INTERFACE

var PrcWriteBits: byte;
    PrcReadBits: byte;

procedure ReadNBitsESDI; {assembler;}
procedure WriteNBitsESBX; {assembler;}

IMPLEMENTATION

{              PrcReadBits - number of bits to read                        }
{              CL          - bit possition in word numerical value ES:[DI] }
{              ES:DI       - base address of array for read                }
{****************************** RETURN ************************************}
{              DX          - PrcReadBits bits value                        }
{              DI          - offset of array for read                      }
{              CL          - bit possition in word numerical value ES:[DI] }
procedure ReadNBitsESDI; assembler;
asm
  push ax
{  mov PrcReadBits,dl}
  push cx
  xor ch,ch       { CH to zero (CH is current bit possition in AX register) }
  xor ax,ax       { AX to zero (procedure return PrcReadBits value in AX)   }

  @ReadNext:      { Here "read and add bits" code begins                    }
  mov dx,es:[di]  { Read current word value from ES:[DI] to DX register     }

   push cx        { Save CX. ( Here CL is bit possition in DX and CH in AX) }

{******************Example for code that going below************************}
{ "x" here are bits. All values ("6" and "7") are example values here.      }
{                                                                           }
{ CL         =      6                                                       }
{ ES:[DI]    =    x x x x x x x x | x x x x x x x x | x x x x x x x x | x x }
{                                                                           }
{ CH         =      7                                                       }
{ AX         =      x x x x x x x x | x x x x x x x x                       }
{                                                                           }
{ In this example we should put bit 6 of ES:[DI] to bit 7 of AX.            }
{ To count how many bits we could move we use formula NBTM=abs(CL-CH).      }
{ After this we have to move NBTM bits from ES:[DI] to the right or         }
{ to the left. If CH>=CL then we move it to the right. If CH<CL then        }
{ we move it to the left.                                                   }

   cmp ch,cl         { Compare to know if move right (SHR) or left (SHL)    }
   jl @OkGo
     xchg ch,cl      { CL=CH and CH=CL. Changing one to other.              }
     sub cl,ch
     shl dx,cl       { Move bits left                                       }
  jmp @MoveBitsDone
  @OkGo:
     sub cl,ch
     shr dx,cl       { Move bits right                                      }
  @MoveBitsDone:

  pop cx           { Load CX. (Here CL is bit possition in DX and CH in AX) }

 or ax,dx          { Move bits from DX to changable bits of AX. This make   }
                   { moved to AX bits not changable.                        }

                   { After SHR M or SHL M still alive (16-M) bits.          }
 add ch,16         { (16-CL) is number of translated bits. So possition     }
                   { CH := CH+(16-CL) = CH+16-CL                            }
 sub ch,cl

 cmp ch,PrcReadBits{ Done if PrcReadBits bits at AX filled                  }
 ja @OkDone        { Here CH="number of Bits written". So if all bits
                     are written then jump to @OkDone. Other case read
                     next word numerical value to done PrcReadBits bits.    }

 add di,2          { Other case next step and next word value in ES:[DI]    }
 xor cl,cl         { New possition in word values ES:[DI] is zero           }

 jmp @ReadNext     { Jump and read few more bits to AX                      }

 @OkDone:

 mov dx,65535      { Just cut bits in AX after PrcReadBits bit              }
 mov cl,16
 sub cl,PrcReadBits
 shr dx,cl
 and ax,dx
 mov dx,ax

 pop cx            { Load previous (before call procedure) bit possition    }
 add cl,PrcReadBits{ Change bit possition in ES:[DI] for this procedure     }
 and cl,15
 pop ax
end;

{             PrcWriteBits - number of bits to write                       }
{             CH           - bit possition in word numerical value ES:[BX] }
{             ES:BX        - base address of array for write               }
{             AX           - code for write                                }
{****************************** RETURN ************************************}
{             BX           - offset of array for read                      }
{             CH           - bit possition in word numerical value ES:[BX] }
{                                                                          }
{ Be sure that word numerical value by address ES:BX equal to 0!           }
{ This procedure make current ES:BX equal to zero, but you should          }
{ add MOV Word Ptr ES:[BX],0 before calling this procedure first time.     }
procedure WriteNBitsESBX; assembler;
asm
  push dx
  push cx
  xor cl,cl       { CL to zero (CL is current bit possition in ES:BX)       }

  @ReadNext:      { Here "read and add bits" code begins                    }
  mov dx,ax       { Read current word value from AX to DX register          }

   push cx        { Save CX. ( CL is bit possition in ES:BX and CH in AX)   }

{******************Example for code that going below************************}
{ "x" here are bits. All values ("6" and "7") are example values here.      }
{                                                                           }
{ CH         =      6                                                       }
{ AX         =    x x x x x x x x | x x x x x x x x | x x x x x x x x | x x }
{                                                                           }
{ CL         =      7                                                       }
{ ES:BX      =      x x x x x x x x | x x x x x x x x                       }
{                                                                           }
{ In this example we should put bit 6 of AX to bit 7 of ES:BX.              }
{ To count how many bits we could move we use formula NBTM=abs(CL-CH).      }
{ After this we have to move NBTM bits from AX to the right or              }
{ to the left. If CL>CH then we move it to the right. If CL<=CH then        }
{ we move it to the left.                                                   }

   cmp ch,cl         { Compare to know if move right (SHR) or left (SHL)    }
   jl @OkGo
     xchg ch,cl      { CL=CH and CH=CL. Changing one to other.              }
     sub cl,ch
     shl dx,cl       { Move bits left                                       }
  jmp @MoveBitsDone
  @OkGo:
     sub cl,ch
     shr dx,cl       { Move bits right                                      }
  @MoveBitsDone:

  pop cx          { Load CX. ( CL is bit possition in ES:BX and CH in AX)   }

 or ES:[BX],dx    { Move bits from DX to changable bits of ES:[BX]. This    }
                  { make moved to AX bits not changable.                    }

                  { After SHR M or SHL M still alive (16-M) bits.          }
 add cl,16        { (16-CH) is number of translated bits. So possition     }
                  { CL := CL+(16-CH) = CL+16-CH                            }
 sub cl,ch

 cmp cl,PrcWriteBits{ Done if PrcWriteBits bits at AX filled               }
 ja @OkDone       { Here CL="number of Bits written". So if all bits
                     are written then jump to @OkDone. Other case read
                     next word numerical value to done PrcWriteBits bits.  }

 add bx,2         { Other case next step and next word value in ES:[DI]    }
 mov Word Ptr ES:[BX],0  {!!!!  Current value in ES:[BX] should be 0  !!!!}
                         {!! It is because of OR ES:[BX],DX (see above) !!}
 xor ch,ch        { New possition in word values ES:[BX] is zero           }

 jmp @ReadNext    { Jump and read few more bits to AX                      }

 @OkDone:

 pop cx           { Load previous (before call procedure) bit possition    }
 add ch,PrcWriteBits{ Change bit possition in ES:[BX] for this procedure   }
 and ch,15
 pop dx
end;

end.