{$M 8192,65535,65535}
{BMP to Image of Back Ground translater}

const

    LCOL: byte=200;
    ToColor: byte=0;          {0..255   - color to change to                 }
    FindColors: boolean=true; {Search (compare )in created colors mode on/off}
    FreeCol: word=129;        {0..255   - current free color                 }
    SrcCol: byte=129;         {First avaliable color                         }
    TheSame: byte=3;          {1..10 - equal constant                        }
    TheMost: boolean=false;   {Search for best color on/off                  }

function LoadBMPFile(fn,fnout: string): byte;
   type
    bmfh=record case byte of
       1:(bm:array[0..53] of byte);
       2:(bft:integer;
          bsize:longint;
          r1,r2:word;
          bp:longint;
          Bis:longint;
          Biw:longint;
          Bih:longint;
          Bip,Bib:word;
          Bic,Bisize,BixP,BiyP,BiClrU,BiClrI:longint;
          );
       end;

var f,f1: file;
    ReadPAL: array[0..255,0..3] of byte;
    BMPPal: array[0..255,0..2] of byte;
    palf: array[0..255,0..2] of byte;
    y,y1,x1,RX,num: WORD;
    HDR: bmfh;
    b: byte;
    A,PTO: pointer;
    BUF: array[0..20] of byte;
    Planes: array[0..3] of word;
    Ch: array[0..2] of char;
    Wr: longint;

procedure CreatePalette(P: pointer; w: word);
var difnum,b,bt: byte;
    done: boolean;
    difnow,dif: word;

begin
 if w>0 then
 for w:=0 to w-1 do
  begin
   bt:=mem[Seg(A^):Ofs(A^)+w];
   Done:=false;

   Dif:=65535;

   if (not Done) and FindColors and (FreeCol>SrcCol) then
    for b:=SrcCol to FreeCol-1 do if
    (BMPPal[bt,0] div thesame*thesame=PalF[b,0] div thesame*thesame) and
    (BMPPal[bt,1] div thesame*thesame=PalF[b,1] div thesame*thesame) and
    (BMPPal[bt,2] div thesame*thesame=PalF[b,2] div thesame*thesame) then
     begin
      mem[Seg(A^):Ofs(A^)+w]:=b;
      Done:=true;
     end;

   if (Done=false) and (FreeCol>=LCol) and (TheMost=false) then
    begin
     TheMost:=true;
     WriteLn('');
     WriteLn('');
     WriteLn('*****************************************************************************');
     WriteLn('Palette overflow!!! "Search for best color" mode turned on. Using old colors.');
     WriteLn('Try to increase "Equal colors" constant.');
     WriteLn('*****************************************************************************');
     WriteLn('');
    end;

   if (Done=false) and TheMost and (FreeCol>SrcCol) then
    begin
      for b:=SrcCol to FreeCol-1 do
       begin
        DifNow:=abs(PalF[b,0]-BMPPal[bt,0])+
                abs(PalF[b,1]-BMPPal[bt,1])+
                abs(PalF[b,2]-BMPPal[bt,2]);
        if DifNow<Dif then
         begin
          Dif:=DifNow;
          DifNum:=b;
         end;
       end;
     mem[Seg(A^):Ofs(A^)+w]:=DifNum;
     Done:=true;
    end;

   if (Done=false) and (FreeCol<255) then
    begin
     PalF[FreeCol,0]:=BMPPal[bt,0];
     PalF[FreeCol,1]:=BMPPal[bt,1];
     PalF[FreeCol,2]:=BMPPal[bt,2];
     mem[Seg(A^):Ofs(A^)+w]:=FreeCol;
     Done:=true;
     Inc(FreeCol);
    end;
  end;
end;

procedure AddPlanes(w: word);
var w1,nowpl,endpl: word;
    ckl: byte;
begin
nowpl:=0;
endpl:=w mod 4;
  for ckl:=1 to 4 do
  begin
    if nowpl<endpl then w1:=w div 4+1 else w1:=w div 4;
    Planes[ckl-1]:=w1;
    nowpl:=nowpl+1;
    if nowpl>3 then begin; nowpl:=0; endpl:=0;  end;
  end;
end;

procedure Standart2Plane(A,P: pointer);
var w1,w: word;
    f,f1,b,ckl: byte;
    l: word;
begin
l:=0;
  for ckl:=1 to 4 do
  begin
    w1:=planes[ckl-1];
    f:=mem[seg(A^):ofs(A^)+ckl-1];
    f1:=mem[seg(A^):ofs(A^)+ckl-1+4];
    if w1>0 then for w:=0 to w1-1 do
     begin
      b:=mem[seg(A^):ofs(A^)+w*4+ckl-1];
      mem[seg(P^):ofs(P^)+l]:=b;
      inc(l);
     end;
    mem[seg(P^):ofs(P^)+l]:=f;
    inc(l);
    mem[seg(P^):ofs(P^)+l]:=f1;
    inc(l);
  end;
end;

begin
if pos('.',fn)=0 then fn:=fn+'.BMP';
if pos('.',fnout)=0 then fnout:=fnout+'.IBG';
assign(f,fn);
{$I-}
reset(f,1);
{$I+}
If IoResult<>0 then
 begin
  WriteLn('Cannot find file '+fn);
  halt;
 end;
 BlockRead(f,HDR,54,num);
 if HDR.BFT<>19778 then
  begin
   close(f);
   WriteLn('Bad BMP file');
   halt;
  end;
assign(f1,fnout);
{$I-}
rewrite(f1,1);
{$I+}
If IoResult<>0 then
 begin
  WriteLn('Cannot create file '+fnout);
  close(f);
  halt;
 end;
 rx:=HDR.BIW;
 rx:=rx div 4*4;
 WriteLn('Wait...');

 x1:=rx;
 HDR.BIW:=(HDR.BSIZE-HDR.BP) div HDR.BIH;
 y1:=HDR.BIH;

 BlockRead(f,ReadPAL,(HDR.BP-54),num);

 for b:=0 to (HDR.BP-54) div 4-1 do
  begin
   BMPPal[b,0]:=ReadPal[b,2] div 4;
   BMPPal[b,1]:=ReadPal[b,1] div 4;
   BMPPal[b,2]:=ReadPal[b,0] div 4;
  end;

 GetMem(A,30000);
 GetMem(PTO,30000);
 ch[0]:='I';
 ch[1]:='B';
 ch[2]:='G';
 wr:=0;
 BlockWrite(f1,ch,3,num); wr:=wr+num;
 BlockWrite(f1,rx,2,num); wr:=wr+num;
 BlockWrite(f1,HDR.BIH,2,num); wr:=wr+num;
 AddPlanes(rx);
 for b:=0 to 3 do
  begin
   blockwrite(f1,planes[b],2,num); wr:=wr+num;
  end;

 for y:=1 to HDR.BIH do
  begin
   BlockRead(f,A^,rx,num);
   BlockRead(f,BUF,HDR.BIW-rx,num);
   CreatePalette(A,RX);
   Standart2plane(A,PTO);
   BlockWrite(f1,PTO^,rx+8,num); wr:=wr+num;
  end;

 BlockWrite(f1,SrcCol,1,num); wr:=wr+num;
 BlockWrite(f1,FreeCol,1,num); wr:=wr+num;
 BlockWrite(f1,PalF,768,num); wr:=wr+num;
 BlockWrite(f1,wr,4,num);
 FreeMem(A,30000);
 FreeMem(PTO,30000);

Close(f);
Close(f1);
WriteLn('Ok. Done');
end;


begin
if ParamCount<2 then
 begin
  WriteLn;
  WriteLn('BMP to IBG translater by Alexander Larkin.');
  WriteLn(' ( any IBG file use colors from 129 to 200 )');
  WriteLn('Usage:    BMP2IBG filename.BMP filename.IBG');
  WriteLn;
  WriteLn('filename.IBG is new file name.');
  WriteLn('filename.BMP is standart 256 colors BMP file.');
  WriteLn;
  WriteLn(' Author e-mail:   larkin@titov.msk.ru');
  WriteLn;
  halt;
 end;
LoadBmpFile(ParamStr(1),ParamStr(2));
end.