(* CMF-Player fr Soundblaster, bentigt SBFMDRV *)
(* Autor: Ren Lobsiger, CH-8105 Regensdorf      *)
(* Datum: 17.11.91                               *)
(* Compiler: Turbo Pascal                        *)
(* Dieser Source-Code kann frei verwendet werden *)

{CMF-Player fr Soundblaster
 ===========================

Damit der teuer erworbene Soundblaster Developer Kit nicht nur nutzlos
herumsteht habe ich versucht einige Routinen fr Turbo-Pascal zu schreiben.
Mit dem Objekt CMFPlayer kann auf einfache Art Musik in eigene Pascal-
Programme eingebaut werden. Zwei Beispielprogramme zeigen wie das Objekt
angewendet wird.

Die in ca. 3 Stunden entstandenen Programme sind keineswegs vollstndig.
Wenn ich einmal wieder Zeit und Lust habe, bastle ich noch etwas daran
herum. Ich hoffe aber trotzdem, dass die Programmzeilen fr irgendjemanden
ntzlich sind. Auf jeden Fall wnsche ich viel Spass.



Ren Lobsiger, Holenbachstr. 25, CH-8105 Regensdorf}

UNIT CMFPas;
INTERFACE
USES DOS;

const
    CmfMusic: boolean=false;

var RegSave1,RegSave2,RegSave3,RegSave4,RegSave5,RegSave6,RegSave7: word;

TYPE CMFBuffer = ARRAY[0..maxInt] OF BYTE;
     CMFHeader = RECORD
                   id: ARRAY[0..3] OF CHAR;
                   vers,
                   subVers: BYTE;
                   instrOffset: INTEGER;
                   musicOffset: INTEGER;
                   ticks: INTEGER;
                   clock: INTEGER;
                   titleOffset: INTEGER;
                   composerOffset: INTEGER;
                   remarkOffset: INTEGER;
                   usedChannels: ARRAY[1..16] OF BYTE;
                   nrOfInstr: INTEGER;
                   tempo: INTEGER;
                   otherInfo: ARRAY[0..maxInt] OF CHAR;
                 END;


TYPE CMFPlayer = OBJECT
                   ok:            BOOLEAN;
                   intNum:        INTEGER;
                   r:             Registers;
                   ctMusicStatus: BYTE;
                   cmfFileBuffer: ^CMFBuffer;
                   cmfHeader:     ^CMFHeader;
                   size:          LONGINT;

                   CONSTRUCTOR Init( iNum: INTEGER );
                   DESTRUCTOR  Done;
                   FUNCTION    LoadFile( name: STRING ): INTEGER;
                   PROCEDURE   ReleaseBuffer;
                   PROCEDURE   PlayMusic(var Freq: word);
                   PROCEDURE   StopMusic;
                   FUNCTION    Finished: BOOLEAN;
                 END;

FUNCTION FileExist( name: STRING ): BOOLEAN;

IMPLEMENTATION

FUNCTION FileExist( name: STRING ): BOOLEAN;
VAR res: INTEGER;
    f: FILE;
BEGIN
{$I-}
  ASSIGN(f,name); RESET(f);
  res := IORESULT;
{$I+}
  IF res = 0 THEN CLOSE(f);
  FileExist := (res=0);
END;  { FileExist }

(******************************* CMFPlayer ****************************)

CONSTRUCTOR CMFPlayer.Init( iNum: INTEGER );
TYPE Info = RECORD
              dummy: ARRAY[0..2] OF CHAR;
              id:    ARRAY[0..4] OF CHAR;
            END;
VAR p: POINTER;

  FUNCTION TestVector: BOOLEAN;
  BEGIN
    GetIntVec(intNum,p);
    p := PTR(SEG(p^),$100);
    TestVector := (Info(p^).id = 'FMDRV');
  END;  { TestVector }

BEGIN  { Init }
  IF iNum > 0 THEN intNum := iNum ELSE intNum := $80;
  size := 0;
  ctMusicStatus := 0;
  ok := TestVector;
END;  { Init }


Procedure CallIntr(IntNum: word; R: registers);
begin
     asm
      mov regsave1,ss
      mov regsave2,sp
      mov regsave3,bp
      mov regsave4,si
      mov regsave5,di
      mov regsave6,dx
      mov regsave7,ds
     end;
    INTR(IntNum,r);
     asm
      mov ds,regsave7
      mov dx,regsave6
      mov di,regsave5
      mov si,regsave4
      mov bp,regsave3
      mov sp,regsave2
      mov ss,regsave1
     end;
end;

DESTRUCTOR CMFPlayer.Done;
BEGIN
  IF ok THEN BEGIN
    StopMusic;
    r.BX := 8;  (* Reset driver *)
    CallIntr(IntNum,r);
    ReleaseBuffer;
  END;
END;  { Done }

FUNCTION CMFPlayer.LoadFile( name: STRING ): INTEGER;
VAR f: FILE;
BEGIN
  StopMusic;
  ReleaseBuffer;
  IF FileExist(name) THEN BEGIN
    ASSIGN(f,name); RESET(f,1);
    size := FileSize(f);
    GetMem(cmfFileBuffer,size);
    BLOCKREAD(f,cmfFileBuffer^,size);
    cmfHeader := @cmfFileBuffer^;
    CLOSE(f);
    IF cmfHeader^.id = 'CTMF' THEN BEGIN
      LoadFile := 0;
    END ELSE BEGIN
      LoadFile := 2;
      FreeMem(cmfFileBuffer,size); size := 0;
    END;
  END ELSE
    LoadFile := 1;
END;  { LoadFile }


PROCEDURE CMFPlayer.ReleaseBuffer;
BEGIN
  IF size > 0 THEN FreeMem(cmfFileBuffer,size);
  size := 0;
END;   { ReleaseBuffer }

PROCEDURE CMFPlayer.PlayMusic(var freq: word);
VAR n: INTEGER;
BEGIN
(* ctMusicStatus - Adresse setzen *)
  r.BX := 1;
  r.DX := SEG(ctMusicStatus);
  r.AX := OFS(ctMusicStatus);
  CallIntr(IntNum,r);
  StopMusic;
  IF size = 0 THEN EXIT;
(* SetDriverClockRate *)
  r.BX := 4;
  r.AX := 1193180 DIV cmfHeader^.clock;
  CallIntr(IntNum,r);
  freq:=cmfHeader^.clock;
(* Set Instrument Table *)
  r.BX := 2;
  r.CX := cmfHeader^.nrOfInstr;
  n := cmfHeader^.instrOffset;
  r.DX := SEG(cmfFileBuffer^[n]);
  r.AX := OFS(cmfFileBuffer^[n]);
  CallIntr(IntNum,r);
(* Play Music *)
  r.BX := 6;
  n := cmfHeader^.musicOffset;
  r.DX := SEG(cmfFileBuffer^[n]);
  r.AX := OFS(cmfFileBuffer^[n]);
  CallIntr(IntNum,r);
END;   { PlayMusic }


PROCEDURE CMFPlayer.StopMusic;
BEGIN
(* stop music *)
  r.BX := 7;
  CallIntr(IntNum,r);
END;  { StopMusic }

FUNCTION CMFPlayer.Finished: BOOLEAN;
BEGIN
  Finished := (ctMusicStatus = 0);
END;  { Finished }

END.



