UNIT GetInfo;

INTERFACE
uses dos,newmouse;

Procedure OutAllInfo;

IMPLEMENTATION

TYPE

 bcb = RECORD
        prcb   : word;
        nxcb   : word;
        ldrv   : byte;
        action : byte;
        lsect  : longint;
        nf     : byte;
        secf   : word;
        pdrv   : pointer;
        fill2  : word;
        fill3  : byte;
        buf    : array[0..511] of byte;
       END;

 bcbptr = ^bcb;

 bcblnk = RECORD
           bxval    : word;
           pagebase : bcbptr;
           usrs     : byte;
           fill     : longint;
          END;

 bcblkp = ^bcblnk;

 bufctl = RECORD
           lnkptr   : bcblkp;
           pgs      : word;
           fill1    : longint;
           fill2    : word;
           emsflg   : byte;
           emshdl   : word;
           emsppg   : byte;
          END;
 bcptr = ^bufctl;

 nam8 = array[1..8] of char;

 mcb = RECORD
         flag    : char;
         owner   : word;
         siz     : word;
         junk    : array[5..7] of byte;
         name    : nam8;
       END;

 mcbptr = ^mcb;

 dpb = RECORD
         drvc     : byte;
         dunit    : byte;
         bps      : integer;
         spc      : byte;
         pwr2     : byte;
         rsrvs    : integer;
         nfats    : byte;
         dirsiz   : word;
         fus      : word;
         tcc      : word;
         spf      : word;
         fds      : word;
         drvr     : pointer;
         mcode    : byte;
         accflg   : byte;
         nxt      : pointer;
         lastused : word;
         filler   : word;
       END;

 dpbptr=^dpb;

 chn = RECORD
         nxtlnk : pointer;
         nmbr   : integer;
       END;
 chnptr = ^chn;

 dcb = RECORD
         nusers   : integer;
         mode     : integer;
         datrb    : byte;
         dvatr    : byte;
         atrb2    : byte;
         pdrvr    : pointer;
         frstc    : word;
         modtm    : word;
         moddt    : word;
         totsiz   : longint;
         curpos   : longint;
         clsctr   : word;
         curcls   : word;
         dirsec   : word;
         dirndx   : byte;
         name     : array[0..7] of char;
         ext      : array[0..3] of char;
         fill2    : word;
         fill3    : word;
         fill4    : word;
         owner    : word;
         fill5    : word;
         fill6    : word;
         fill7    : word;
         fill8    : word;
       END;

 dcbptr = ^dcb;

 ldt = RECORD
         name     : array[0..67] of char;
         code     : byte;
         mydpb    : dpbptr;
         dirclu   : word;
         filler2  : word;
         filler3  : word;
         patlen   : word;
         filler4  : word;
         filler5  : word;
         filler6  : word;
         filler7  : word;
       END;

 ldtptr = ^ldt;

 cvt = RECORD
         curbfr    : bcbptr;
         memchn    : mcbptr;
         pdrvs     : dpbptr;
         dcbchn    : dcbptr;
         clkdev    : pointer;
         condev    : pointer;
         secsiz    : integer;
         bfrchn    : bcblkp;
         ldrvs     : ldtptr;
         fcbchn    : chnptr;
         filler    : integer;
         npdrvs    : byte;
         nldrvs    : byte;
       END;

 cvtptr = ^cvt;

 dtstr = string[8];
 pstrg = string[9];
 memst = string[12];

 VAR
  cvtbase : cvtptr;
  curbuf  : bcbptr;
  curmcb  : mcbptr;
  curdpb  : dpbptr;
  curchn  : chnptr;
  curdcb,
  curfcb  : dcbptr;
  curldt  : ldtptr;
  bcbctr,
  dcbctr  : integer;
  PawsFlag: Boolean;
  lctr    : integer;
  KbdIntVec : Procedure;
  DosFreeVec: Procedure;
  KeyIs     : boolean;

function hexn(b:byte) : char;
  begin
    b := b and 15;
    if b>9 then inc(b,7);
    hexn := chr(b+48);
  end;

function hexb(b:byte) : string;
  begin
   hexb := hexn(b shr 4) + hexn(b);
  end;

function hexw(w:word) : string;
begin
 hexw := hexb(w shr 8) + hexb(w);
end;

function hexl(l:longint) : string;
begin
 hexl := hexw(l shr 16) + hexw(l);
end;

procedure outcstr( var s : nam8 );
  VAR
    i: integer;
  BEGIN
    i:=1;
    while (s[i] <> #0) and (i < 9) do
      begin
        write(s[i]);
        inc(i);
      end;
  END;

procedure holdup;
  BEGIN
   if PawsFlag then
     begin
      inc(lctr);
      if lctr>10 then
        begin
          lctr:=0;
          While KeyPressed do readkey;
          readkey;
        end;
     end;
  END;

function xp( P: pointer ): pstrg;
 begin
  xp := hexw(seg(P^)) + ':' + hexw(ofs(P^));
 end;

PROCEDURE dmp(f:pointer);
var
 x : ^byte;
 i : integer;
 c: char;
begin
  x:=f;
  write(xp(f),'> ');
  for i:=0 to 15 do
    begin
      write( hexb(x^));
      if i=7 then write('-')
             else write(' ');
      x:=pointer(longint(x)+1);
    end;
  write('   ');
  x:=f;
  for i:=0 to 15 do
    begin
      c:=char($7f and x^);
      if c<' ' then c:='.';
      write(c);
      if i=7 then write(' ');
      x:=pointer(longint(x)+1);
    end;
  writeln;
  holdup;
end;

procedure dpbtrc(a: pointer);
var
  ofsv:word;

 procedure dpbrpt;
  begin
    writeln;
    holdup;
    write('Drive ',char (curdpb^.drvc+ord('A')) );
    write(': (unit ', curdpb^.dunit,' of driver at ',xp(curdpb^.drvr) );
    writeln(') media code = ',hexb(curdpb^.mcode) );
    holdup;
    write(' ', curdpb^.bps:3,' bytes per sector,');
    write(' ',curdpb^.spc+1:2, ' sectors per cluster,');
    writeln(' ',curdpb^.tcc-1:4,' total cluster count');
    holdup;
    write(' Res sectors: ',curdpb^.rsrvs,' ');
    write(' ',curdpb^.nfats, ' FAT''s, ', curdpb^.spf:2, ' sec ea ');
    write(' FAT entry: ');
    IF (curdpb^.tcc) > $0FFC
      then write( 16)
      else write(12);
    writeln(' bits Root: ', curdpb^.dirsiz:3,' entries');
    holdup;
    write(' First root sector: ',hexw(curdpb^.fds)  );
    write(' First data sector: ',hexw(curdpb^.fus)  );
    writeln(' Last cluster used: ',hexw(curdpb^.lastused));
    holdup;
  end;

begin
  curdpb := a;
  ofsv :=0;
  writeln;
  holdup;
  writeln('DRIVE PARAMETER BLOCK (DPB) DATA--');
  holdup;
  while (ofsv <> $FFFF) do
   begin
    ofsv:=word(longint(curdpb^.nxt));
    dpbrpt;
    curdpb:=dpbptr(curdpb^.nxt);
   end;
  write(#12);
end;

procedure bcbtrc2(a : pointer);
  VAR
    ofsv : word;
    ofst : word;

    procedure bcbrpt(a:bcbptr);
       var
         i: integer;
         x: pointer;

         begin
          writeln;
          holdup;
          inc(bcbctr);
          write('Buffer Control Block ',bcbctr:2,' at ',xp(a));
          write('        Prev: ',hexw(a^.prcb));
          writeln('        Next: ',hexw(a^.nxcb));
          holdup;
          write('      Logical ''',char(ord('A')+a^.ldrv));
          write(':'',      Sector ',hexl(a^.lsect));
          writeln('      Action code: ',hexb(a^.action));
          holdup;
          write('      NFATS: ',hexb(a^.nf));
          write('            SPF: ',hexw(a^.secf));
          writeln('          DPB address: ',xp(A^.pdrv));
          holdup;
          write('           FILL2: ', hexw(a^.fill2));
          writeln('             FILL3: ',hexb(a^.fill3));
          holdup;
          x := addr(bcbptr(a)^.buf[0]);
          for i:=0 to 31 do
            dmp(pointer(longint(x)+(i shl 4)));
        end;

      begin
        bcbctr:=0;
        ofsv:=0;
        ofst:=ofs(a^);
        WHILE (ofsv <> ofst) do
          begin
           ofsv:=bcbptr(a)^.nxcb;
           bcbrpt(a);
           a:=ptr(seg(a^),ofsv);
          end;
        write(#12);
      end;

      procedure bcbtrc1(a:pointer);

       procedure bcbtrl(a:bcblkp);
         begin
           writeln;
           holdup;
           writeln( 'Page base is at ',xp(a^.pagebase));
           holdup;
           write('BX Val = ',hexw(A^.bxval));
           write('       Users = ',hexb(a^.usrs));
           writeln('       Fill = ',hexl(a^.fill));
           holdup;
           bcbtrc2(a^.pagebase);
         end;

         begin
          writeln('Link table is at ',xp(bcptr(a)^.lnkptr));
          holdup;
          write('Page count = ',bcptr(a)^.pgs:4);
          write('     Fill1 = ',hexl(bcptr(a)^.fill1));
          writeln('      Fill2 = ',hexw(bcptr(a)^.fill2));
          holdup;
          write('EMS flag = ',hexb(bcptr(a)^.emsflg));
          write('          Handle = ', hexw(bcptr(a)^.emshdl));
          writeln('     PhysPg = ',hexb(bcptr(a)^.emsppg));
          holdup;
          bcbtrl(bcptr(a)^.lnkptr);
         end;

         procedure dcbtrc(t: dtstr; a:pointer);
         var
         ofsv: word;

         function f_tm(n: word): dtstr;
         var
         buf: dtstr;
         b: byte;
         begin
           b:=((n shr 11) and 31);
           buf[1]:=char((b div 10) + 48);
           buf[2]:=char((b mod 10) + 48);
           buf[3]:=':';
           b:=((n shr 5) and 63);
           buf[4]:=char((b div 10) + 48);
           buf[5]:=char((b mod 10) + 48);
           buf[6]:=':';
           b:=((n shl 1) and 63);
           buf[7]:=char((b div 10) + 48);
           buf[8]:=char((b mod 10) + 48);
           f_tm:=buf;
         end;

         function f_dt(n: word): dtstr;
         var
          buf: dtstr;
          b: byte;
          begin
            b:=((n shr 5) and 15);
            buf[1]:=char((b div 10)+48);
            buf[2]:=char((b mod 10)+48);
            buf[3]:='/';
            b:=(n and 31);
            buf[4]:=char((b div 10)+48);
            buf[5]:=char((b mod 10)+48);
            buf[6]:='/';
            b:=((n shr 9) and 15) + 80;
            buf[7]:=char((b div 10)+48);
            buf[8]:=char((b mod 10)+48);
            f_dt:=buf;
          end;

         procedure dcbrpt(var t: dtstr; n: integer);
          type
            acctyp = array[0..3] of string[7];
          const
            actyp : acctyp = ('READ','WRITE','R/W','unknow');
          var
            isdvc: boolean;

          begin
            while (n>0) do
            begin
              inc(dcbctr);
              writeln;
              holdup;
              write(t,' ',dcbctr:2);
              if (curdcb^.name[0] = #0) then
               begin
                 writeln(' at ',xp(curdcb),' not used since bootup');
                 holdup;
               end
               else
               begin
                 isdvc:=(curdcb^.dvatr and 128)<>0;
                 write(' for ');
                 if isdvc
                   then write('device ')
                   else write('file   ');
                 write(curdcb^.name[0],curdcb^.name[1],curdcb^.name[2]);
                 write(curdcb^.name[3],curdcb^.name[4],curdcb^.name[5]);
                 write(curdcb^.name[6],curdcb^.name[7]);
                 if (not isdvc) then
                   write(' at ',xp( curdcb ));
                   write(' shows ',curdcb^.nusers);
                   writeln(' OPENs');
                   holdup;
                   write('  Opened for ',actyp[3 and (curdcb^.mode)]);
                   write('  access');
                   if ($FFFC and (curdcb^.mode))<>0 then
                     write(' (',hexw(curdcb^.mode),')');
                   writeln(' by process ',hexw(curdcb^.owner));
                   holdup;
                   if (isdvc) then
                     begin
                       write('  Device driver at ',xp(curdcb^.pdrvr));
                       write('  is in ');
                       if ((curdcb^.dvatr) and 32)<>0 then write('Raw')
                                                      else write('Cooked');
                       write(' mode and is ');
                       if ((curdcb^.dvatr) and 64)=0 then write('not ');
                       writeln('ready');
                       holdup;
                     end
                   else
                     begin
                       write(' File is on drive ',char(ord('A') + ((curdcb^.dvatr) and 31)));
                       write(': (driver at ',xp(curdcb^.pdrvr));
                       write(') and has ');
                       if ((curdcb^.dvatr) and 64)<>0 then write('not ');
                       writeln('been written to.');
                       holdup;
                       writeln('  File''s attribute byte = ',hexb(curdcb^.datrb));
                       holdup;
                     end;
                   write('  Mod Time/date: ');
                   write(f_tm(curdcb^.modtm),', ');
                   writeln(f_dt(curdcb^.moddt));
                   holdup;
                   write  ('     First Cluster:   ',hexw(curdcb^.frstc),' ');
                   write  ('     Prev Clesters:   ',curdcb^.clsctr:4,' ');
                   writeln('   Current cluster:   ',hexw(curdcb^.curcls),' ');
                   holdup;
                   write  ('    Directory size:',curdcb^.totsiz:6,' ');
                   writeln('   curr byte count:',curdcb^.curpos:6);
                   holdup;
                 end;
                 curdcb:=pointer(longint(curdcb)+sizeof(dcb)-1);
                 dec(n);
               end;
             end;

        begin
          curchn:=chnptr(a);
          dcbctr:=0;
          ofsv:=0;
          while (ofsv<>$FFFF) do
            begin
              ofsv:=word(longint(curchn^.nxtlnk));
              curdcb:=dcbptr(longint(curchn)+sizeof(chn));
              writeln;
              holdup;
              write('Link at ',xp(curchn),' contains ');
              writeln(curchn^.nmbr,' ',t,'s--');
              holdup;
              dcbrpt(t,curchn^.nmbr);
              curchn:=chnptr(curchn^.nxtlnk);
            end;
          write(#12);
        end;

procedure memtrc(A: pointer);
  VAR
   z: longint;

   procedure memrpt(s,o,a: word; var n: nam8);
     function memu(a: word): memst;
      var
        x: char;
        begin
         x:=char(mem[a:0]);
         case x OF
          #$CD:
            memu:='Program';
          'A'..'Z':
            memu:='Environment';
          else
            memu:='Data';
          end;
        end;

      begin
        z:=longint(s) shl 3;
        write(z:6,' bytes ');
        if (o<>0) then
         begin
           write('USED by proc ',hexw(o));
           write(', at ',hexw(a),':000, for ',memu(a));
           if n[1] in ['A'..'Z'] then
            begin
              write('. Pgm name: ');
              outcstr(n);
              writeln;
            end
           else
            writeln('. No program name');
         end
       else
         writeln('FREE at ',hexw( a ),':0000');
         holdup;
     end;

 begin
   curmcb:=mcbptr(a);
   writeln;
   holdup;
   writeln('MEMORY ALLOCATION CHAIN');
   holdup;
   WHILE (curmcb^.flag='M') do
     begin
      memrpt(curmcb^.siz,curmcb^.owner,SEG(curmcb^)+1,curmcb^.name);
      curmcb := ptr(seg(curmcb^)+(curmcb^.siz+1),0);
     end;
   if (curmcb^.flag<>'Z') then
    begin
      writeln(#13,#10,'MEMORY ALLOCATION ERROR at ',xp(curmcb) );
      halt(255);
    end;
  memrpt(curmcb^.siz,curmcb^.owner, SEG(curmcb^)+1,curmcb^.name);
  write(#12);
end;


procedure ldttrc(a: ldtptr; n: byte);

  procedure ldtrpt(l: ldtptr; d: byte);
    var
      ldrive: char;
      i: integer;
    begin
      ldrive:=chr($41+d);
      if (l^.code and byte($40))=0 then
       writeln('Logical Drive ',ldrive,' not yet defined')
      else
        begin
          write ( 'Logical Drive ',ldrive);
          writeln(' = Physical drive ',l^.name[0]);
          holdup;
          write('The current (full) pathspec is: ');
          i:=0;
          repeat
           write(l^.name[i]);
           inc(i);
          until (l^.name[i]=#0);
          writeln;
        end;
      holdup;
      if (l^.code=$50) then
        writeln( 'Code = 0x50 -- result of SUBST command')
      else if (l^.code = $40) then
        writeln( 'Code = 0x40 -- physical (or aliased) device')
      else
        writeln( 'Code = 0x',hexb(l^.code),' -- unknown');
      holdup;
      writeln('Directory Cluster = ',hexw(l^.dirclu));
      holdup;
      writeln('Path Length to ingnore = ',hexw( l^.patlen));
      holdup;
      write   ('Filler2 = ',hexw(l^.filler2),'  ');
      write   ('Filler3 = ',hexw(l^.filler3),'  ');
      writeln ('Filler4 = ',hexw(l^.filler4),'  ');
      holdup;
      write   ('Filler5 = ',hexw(l^.filler5),'  ');
      write   ('Filler6 = ',hexw(l^.filler6),'  ');
      writeln ('Filler7 = ',hexw(l^.filler7),'  ');
      holdup;
      writeln;
      holdup;
    end;

var o: byte;

begin
  curldt := a;
  writeln;
  holdup;
  writeln('LOGICAL DRIVE TABLES (set by LASTDRIVE=, SUBST, etc.):');
  holdup;
  dec(n);
  for o:=0 to n do
    begin
      ldtrpt(curldt,o);
      curldt := ptr(seg(curldt^),(ofs(curldt^) + sizeof(ldt)));
    end;
  write(#12);
END;

procedure OutAllInfo;
var bytewas: byte;
    b: registers;
begin

 b.ah:=$30;
 MsDos(b);
 if b.al<>4 then
  begin
   writeln('Wrong DOS version: ',b.al,'.',b.ah);
   holdup;
   writeln;
   holdup;
  end;
 PawsFlag:=ParamCount = 0;
 lctr:=0;
 writeln('Configuration Varibles, DOS version ',b.al,'.',b.ah);
 holdup;
 b.ah:=$52;
 msdos(b);
 cvtbase:=ptr(b.es,b.bx-8);

 writeln;
 holdup;
 writeln('CVT is located at ',xp(cvtbase));
 writeln('VIDEO MODE WAS ',bytewas);
 holdup;
 write('No. of Phys Drives (at ',xp(@cvtbase^.npdrvs));
 writeln('): ',cvtbase^.npdrvs);
 holdup;
 write('No. of Log. Drives (at ',xp(@cvtbase^.nldrvs));
 writeln('): ',cvtbase^.nldrvs);
 holdup;
 write   ('Clock Device (ptr at ',xp(@cvtbase^.clkdev));
 writeln ('): ',xp(cvtbase^.clkdev));
 holdup;
 write  ('    CON Device (ptr at ',xp(@cvtbase^.condev));
 writeln('): ',xp(cvtbase^.condev));
 holdup;
 write  ('    Sector Size(?) (at ',xp(@cvtbase^.secsiz));
 writeln('):       ',hexw(cvtbase^.secsiz));
 holdup;
 write(  '      FCBs to keep (at ',xp(@cvtbase^.filler));
 writeln('):      ',hexw(cvtbase^.filler));
 holdup;
 write(  '1.    Memory Chain (ptr at ',xp(@cvtbase^.memchn));
 writeln('): ',xp(cvtbase^.memchn));
 holdup;
 write(  '2.       DCB Chain (ptr at ',xp(@cvtbase^.dcbchn));
 writeln('):  ',xp(cvtbase^.dcbchn));
 holdup;
 write(  '3.       DPB Chain (ptr at ',xp(@cvtbase^.pdrvs));
 writeln('):  ',xp(cvtbase^.pdrvs));
 holdup;
 write(  '4.       FCB Chain (ptr at ',xp(@cvtbase^.fcbchn));
 writeln('):  ',xp(cvtbase^.fcbchn));
 holdup;
 write(  '5.       LDT Chain (ptr at ',xp(@cvtbase^.ldrvs));
 writeln('):  ',xp(cvtbase^.ldrvs));
 holdup;
 write(  '6.  Current Buffer (ptr at ',xp(@cvtbase^.curbfr));
 writeln('):  ',xp(cvtbase^.curbfr));
 holdup;
 write(  '7.  Buffer Chain  (link at ',xp(@cvtbase^.bfrchn));
 writeln('):  ',xp(cvtbase^.bfrchn));
 holdup;

 writeln;
 holdup;
 writeln('TRACING       MCB Chain===');
 holdup;
 memtrc(cvtbase^.memchn);

 writeln;
 holdup;
 writeln('TRACING       DCB Chain===');
 holdup;
 dcbtrc('DCB',cvtbase^.dcbchn);

 writeln;
 holdup;
 writeln('TRACING       DPB Chain===');
 holdup;
 dpbtrc(cvtbase^.pdrvs);

 writeln;
 holdup;
 writeln('TRACING       FCB Chain===');
 holdup;
 dcbtrc('FCB',cvtbase^.fcbchn);

 writeln;
 holdup;
 writeln('TRACING       LDT Chain===');
 holdup;
 ldttrc(cvtbase^.ldrvs,cvtbase^.nldrvs);

 writeln;
 holdup;
 writeln('TRACING Buffer Chain from current buffer===');
 holdup;
 bcbtrc2(cvtbase^.curbfr);

 writeln;
 holdup;
 writeln('TRACING Buffer Chain thru EMS lonk record===');
 holdup;
 bcbtrc1(cvtbase^.bfrchn);
end;

end.

