{$M 16384,185000,185000}
uses smix,detect,CMFpas,AVLMusic,goodvga,newmouse,xmsscrll,gamestrc,scrtext,playgame,getsb;

const
      RIGHTPCTMAX : byte=5;
      LEFTPCTMAX  : byte=5;

      LeftPush: word=65535;
      RightPush: word=65535;

    XMSRequired   = 400;    {XMS memory required to load the sounds (KBytes) }
    SharedEMB     = true;
      {TRUE:   All sounds will be stored in a shared EMB}
      {FALSE:  Each sound will be stored in a separate EMB}
    NumSounds = 11;

    CurLev: word=0;

      DeathC: array[0..9] of string[50]=
      ('Death is always something fast...',
       'It is time to begin your life again...',
       'Do not ask me where your grave is...',
       'Think before doing something...',
       'Do not drive so fast as you like...',
       'A donkey can live longer than hero like you...',
       'This live is short and nice...',
       'Everything you saw was true...',
       'Be more clever next time...',
       'There is no anyone who saw your death...');

var
      Snd: array[0..NumSounds-1] of PSound;
      BaseIO: word; IRQ, DMA, DMA16: byte;
      SB: boolean;
      OldTimer,OldKeyboard: pointer;
      PrgName: string;
      Ret: byte;

      DriverAlready: boolean;
      NoMusic: boolean;
      SbDetect: boolean;

      l: longint;

      dm: pointer;


{$F+}

  function LoadSounds: byte;
    var
      i: integer;
      ld: boolean;
    begin
      if not(InitXMS) then LoadSounds:=1 else
          begin
            if GetFreeXMS < XMSRequired then LoadSounds:=2 else
                begin
                  if SharedEMB then InitSharing;
                  if not(OpenSoundResourceFile('GAME.SND')) then LoadSounds:=3 else
                   begin
                    ld:=true;
                    if not LoadSound(Snd[0], 'ETOMNE') then ld:=false;
                    if not LoadSound(Snd[1], 'GNIDA') then ld:=false;
                    if not LoadSound(Snd[2], 'HOROSHO') then ld:=false;
                    if not LoadSound(Snd[3], 'CANNON') then ld:=false;
                    if not LoadSound(Snd[4], 'LASER') then ld:=false;
                    if not LoadSound(Snd[5], 'OTVALI') then ld:=false;
                    if not LoadSound(Snd[6], 'BUM') then ld:=false;
                    if not LoadSound(Snd[7], 'SOPLI') then ld:=false;
                    if not LoadSound(Snd[8], 'UAAA') then ld:=false;
                    if not LoadSound(Snd[9], 'UMRESH') then ld:=false;
                    if not LoadSound(Snd[10], 'WELCOME') then ld:=false;
                    CloseSoundResourceFile;
                    LoadSounds:=0;
                    if not ld then LoadSounds:=4;
                   end;
                end;
          end;
    end;

function TrySb: byte;
begin
  TrySb:=0;
  if not (GetSettings(BaseIO, IRQ, DMA, DMA16)) then TrySb:=1 else
  if not(InitSB(BaseIO, IRQ, DMA, DMA16)) then TrySb:=2;
end;


function TurnOnSB: boolean;
begin
TurnOnSB:=false;
 case TrySB of
 1: writeln('Error initializing:  Invalid or non-existant BLASTER environment variable');
 2: begin
     writeln('Error initializing sound card');
     writeln('Incorrect base IO address, sound card not installed, or broken');
    end;
 0: begin
     InitMixing;
     case loadsounds of
      0:     begin
              TurnOnSB:=true;
              writeln('Sound blaster library by Ethan Brodsky initializated.');
             end;
      1:     begin
              writeln('Error initializing extended memory');
              writeln('HIMEM.SYS must be installed');
             end;
      2:     begin
              writeln('Insufficient free XMS');
              writeln('You are probably running this game from the protected mode IDE');
              writeln('Run it from the command line or read the documentation');
             end;
      3:     writeln('Error loading sound resource file');
      4:     writeln('Cannot load one of the sounds.');
     end;
    end;
 end;
end;


Procedure InstallMusic;
var w,w1: word;
    b: byte;
Begin
  WriteLn('Sound blaster must be initialized or this program will not find it.');
  if SbDetect then FindSb;
  OldTimer:=GetIntVec($8);
  OldKeyBoard:=GetIntVec($9);
  CmfMusic:=true;
  SetIoAddress(HexStr(SbInt));
  DriverAlready:=false;
  if (NoMusic or (not InitAvlMusic)) then DriverAlready:=true;
  if DriverAlready then WriteLn(' (music driver already installed or cannot install music driver)');
   Begin
    CMFplay.Init(DriverInterrupt);
    if not CMFplay.Ok then CmfMusic:=false;
   End;
  sb:=false;
  if CmfMusic then
   Begin
    CMFplay.done;
{if TurnOnSB=false then WriteLn('Cannot initializate sound card.') else sb:=true;}
   End;
End;

Procedure CloseMusic;
Begin
 if CmfMusic then
  Begin
   CmfMusic:=false;
   SetIntVec($8,OldTimer);
   SetIntVec($9,OldKeyBoard);
   CMFplay.done;
   if DriverAlready=false then SetIntVec(DriverInterrupt,nil);
   CMFplay.ok:=false;
  End;
End;

  procedure Shutdown;
    begin
      ShutdownMixing;
      StopDAC;
      ShutdownSB;
    end;

  procedure FreeSounds;
    var
      i: integer;
    begin
      for i := 0 to NumSounds-1 do
        if Snd[i]<>nil then FreeSound(Snd[i]);
      if SharedEMB then ShutdownSharing;
    end;

Procedure KillSounds;
Begin
 if sb then
  begin
   Shutdown;
   FreeSounds;
  end;
End;


  procedure OurExitProc; far;
 {If the program terminates with a runtime error before the memory         }
 {is deallocated, then the memory will still be allocated, and will be lost}
 {until the next reboot.  This exit procedure is ALWAYS called upon program}
 {termination and will deallocate memory if necessary.                     }
    begin
      ExitProc := OldExitProc; {Chain to next exit procedure}
      HaltIsOn:=false;
      TimerOn:=false;
      CloseGoodVga;
    if ErrorIs then
    Begin
      FreeAlg;
      WriteLn;
      WriteLn('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!');
      WriteLn('Error while running this program.');
      WriteLn(ErrorString);
     End;
      WriteLn(ErrorString);
      WriteLn('Trying to terminate this program...');
      Write('Mouse..');
       Kill_Mouse;
      Write('Keyboard..');
       KillKeyBoard;
      Write('Music..');
      CloseMusic;
      Write('Timer..');
      KillTimer;
      Write('Sounds..');
      KillSounds;
      Write('Himem..');
       CloseIBG;
      WriteLn;
      if LVLOBJS<>0 then FreeMem(LEVOBJ,LVLOBJS);
      FreeMem(LEVOBJsaved,sizeof(OBJECTtype)*MAXOBJECTS);
      halt(1);
    end;

{$F-}

Procedure Death;
var w: word;
    cp,b: byte;
begin
 cp:=0;
 Set_Active_Page(cp);
 CvmPage(cp,8);
 SetColor(12);
 SetBGColor(0);
 b:=random(9);
 OutTextXy(0,0,DeathC[b]);
 SetColor(10);
 OutTextXy(1,1,DeathC[b]);
 OutTextXy(1,100,'Press any key...');
 if DeathImage<>65535 then PutAlgImage(1,140,DeathImage) else
 OutTextXy(1,140,'Just death... You know it.');
 Set_Visual_Page(cp);
 SetBGColor(8);
 repeat until readkey in[#27,' ','a'..'z','A'..'Z','0'..'1',#13];
 CvmPage(cp,8);
 SetBallCnst;
end;

Procedure ResetLevel;
Begin
   { SND next level }
{   if sb then StartSound(Snd[8], 8, false);}
   LoadDate('data.dat',byte(NextLevel));
   SetConstants;
End;

Procedure OutBugHelp;
Begin
 WriteLn;
 WriteLn('******************** BUG FIX HELP');
 WriteLn;
 WriteLn('Usage:     game.exe [options]');
 WriteLn('Example:   game.exe -m -s');
 WriteLn;
 WriteLn(' -M  - low memory mode (do not load graphic pictures to memory)');
 WriteLn(' -S  - safe mode (do not detect sound blaster, so do not froze computer)');
 WriteLn(' -G  - use 320x200x256 instead of 320x240x256 mode (about video card)');
 WriteLn(' -N  - no music (do not load default SBFM driver for sound blaster)');
 WriteLn(' -I  - don''t use INT 8 (turn on this switch if this game froze computer)');
 WriteLn(' -A  - output to the screen only nearest objects to the ball');
 WriteLn(' -H  - output this bug gix help');
 WriteLn;
 WriteLn('******************** end of BUG FIX HELP');
 WriteLn;
 Halt;
End;

Procedure ReadParameters;
var b: byte;
    s: string;
    ch: char;
Begin
 for b:=1 to ParamCount do
  Begin
   s:=ParamStr(b);
   if length(s)>=2 then ch:=s[2] else ch:=#255;
   ch:=UpCase(ch);
    case ch of
     'M': LoadPictures:=false;
     'H': OutBugHelp;
     'G': LowMode:=true;
     'I': InInt:=false;
     'A': AroundEnough:=true;
     'S': SbDetect:=false;
     'N': NoMusic:=true;
     #0..#255: OutBugHelp;
    End;
  End;
End;

begin
 while(KeyPressed) do ReadKey;

 randomize;
 LowMode:=false;
 NoMusic:=false;
 SbDetect:=true;
 if ParamCount>0 then ReadParameters;
 PrgName:=ParamStr(0);

  OldExitProc := ExitProc;
  ExitProc := @OurExitProc;

 InstallMusic;

 Randomize;
 WriteLn;
 WriteLn('***************************** '+PrgName+' executed');
 WriteLn('You have 1750 seconds now to play this demo version of the game');
 WriteLn;
 Write('Starting game from file DATA.DAT (press any key to continue)... ');

AlgMemWas:=MemorySize;
MemWas:=MaxAvail;

InitTimer;
InitKeyBoard;

{if sb then StartSound(Snd[10], 10, false);}

SaveScreen;       {SaveScree}
{ GetMem(dm,DEMOSIZE+300);}

if LowMode then Set_320x200 else Set_320x240;      {InitGraph}
LoadDate('data.dat',CurLev);
SetConstants;


repeat

 ret:=BallGame(CurLev,false,false,Dm);
 case ret of
  1: Begin
      ResetLevel;
     End;
  2: Begin
      inc(CurLev);
      ResetLevel;
     End;
  3: Begin
      Death;
      ResetLevel;
     End;
  7: Begin
      DoLevelOff:=true;
      ResetLevel;
      if ((ll.LVL.Demo<>nil) and ll.LVL.Demo^.Success) then
       Begin
        BallGame(CurLev,false,true,ll.LVL.Demo);
        ret:=1;
        ResetLevel;
       End;
      DoLevelOff:=false;
     End;
 End;
until ret=0;

      KillTimer;
      KillKeyBoard;
      CloseMusic;
      CloseGoodVga;
      LoadScreen;
      FreeAlg;
      KillSounds;
      CloseIBG;

 WriteLn(' - OK');
 WriteLn('');
 WriteLn(' Images of Russian city Chernogolovka used in this game.');
 WriteLn(' Some pictures drawed by Lena Petrova and other created by me.');
 if CmfMusic then WriteLn('(I found this music on internet)');
 WriteLn('                         programmer Alexander Larkin');
 if notAVL then
  Begin
   WriteLn;
   WriteLn('You pressed the TAB key or you changed DATA.DAT file or you');
   WriteLn('changed LEVEL2.LVL file, so you have not got the surprise');
   WriteLn('for the third level. Try to play again and not to press TAB.');
  End;
 WriteLn('Usage  game -h  for bug fix help');
 WriteLn('Thanx for playing this game.');
 WriteLn('***************************** '+PrgName+' terminated.');
 ExitProc := OldExitProc; {Chain to next exit procedure}
 halt(0);
 AvlMusicDriver; {Do not call this procedure!}
end.