{   Created by Alexander Larkin.
    E-mail:      avlarkin@writeme.com
    Internet:    http://www.geocities.com/SiliconValley/6235/tpdl.htm
}

unit GetSb;

INTERFACE

var SBInt,SBIrq: word;
    SBdma,SBdma16: byte;

Function FindSB: boolean;
Function HexStr(w: word): string;
Procedure LittleWait;

IMPLEMENTATION

const addresses: array[0..6] of word=($200,$210,$220,$230,$240,$250,$260);

const WAIT_TIME=$2; { in 1/9 of second }
      DSP_INTRQ_CMD=$F2;
        ORG_INT2_ADDX: longint=0;
        ORG_INT3_ADDX: longint=0;
        ORG_INT5_ADDX: longint=0;
        ORG_INT7_ADDX: longint=0;

var    b: byte;

Procedure LittleWait; Assembler;
Asm
 Push ES
 Push BX
 Push AX
 Push CX

 mov bx,$40
 mov es,bx
 mov bx,06ch
 mov ax,es:[bx]
 mov cx,1

@OneMore:
 cmp ax,es:[bx]
 je @OneMore
 dec cx
 cmp cx,0
 jne @OneMore

 Pop CX
 Pop AX
 Pop BX
 Pop ES
End;

Procedure RestoreInterrupt; Assembler;
Asm
                CLI

                MOV    CL,AL

                ADD    AL,8        { calculate interrupt vector addx }
                CBW
                SHL    AL,1
                SHL    AL,1
                MOV    DI,AX

                PUSH   ES          { restore interrupt vector }
                XOR    AX,AX
                MOV    ES,AX
                MOV    AX,DS:[BX]
                MOV    ES:[DI],AX

                MOV    AX,DS:[BX+2]
                MOV    ES:[DI+2],AX

                POP    ES

                MOV    AH,1
                SHL    AH,CL

                IN     AL,21H
                OR     AL,AH
                OUT    21H,AL

                STI
End;

Procedure WriteDSP; Assembler;
Asm
                PUSH   CX

                MOV    AH,AL          { save value in AL for later }

                MOV    CX,WAIT_TIME

@WD10:
                IN     AL,DX          { check to see if DSP is ready }
                OR     AL,AL
                JNS    @WD20          { if sign set, DSP not write ready }
                CALL   LITTLEWAIT
                LOOP   @WD10

@WD20:
                CMP    CX,0
                JE     @NotReady

                MOV    AL,AH          { restore AL }
                OUT    DX,AL          { send byte to DSP }

@NotReady:
                POP    CX
End;

Procedure ReadDSPTime; Assembler;
Asm
                PUSH   CX
                PUSH   DX

                MOV    DX,SBInt
                ADD    DL,0EH        { DX = DSP data available port 2xEh }

                MOV    CX,WAIT_TIME  { load timeout value into CX }

@RDT10:
                IN     AL,DX         { check to see if DSP is ready }
                OR     AL,AL
                JS     @RDT20        { if sign set, then DSP read ready }
                CALL   LITTLEWAIT
                LOOP   @RDT10        { not ready, keep waiting }

                STC                  { set error, DSP read timeout }
                JMP    @RDT90        { exit }

@RDT20:
                SUB    DL,4          { DX = DSP read data port 2xAh }
                IN     AL,DX         { read byte from DSP }
                CLC                  { clear error }

@RDT90:
                POP    DX
                POP    CX
End;


Function ResetDSP: boolean; Assembler;
asm
                XOR    CH,CH
                MOV    DX,SBInt
                ADD    DL,6         { DX = DSP reset port 2x6h }
                MOV    AL,1
                OUT    DX,AL        { write 1, then wait 3 micro-seconds }

                IN     AL,DX        { read value from DSP }
@RDSP05:
                INC    AL
                JNZ    @RDSP05      { wait until AL = 0 }
                CALL   LittleWait

                OUT    DX,AL        { write 0 }
                CALL   LittleWait

                MOV    CL,4H         { set reset timeout value }

@RDSP10:
                CALL   ReadDSPTime   { read from DSP }
                CMP    AL,0AAH       { if byte is 0AAh then }
                JE     @RDSP20       {   DSP is reset, exit }

                Call   LittleWait
                LOOP   @RDSP10       { not reset, try again }

                XOR    AX,AX         { set I/O failure error (false) }
                JMP    @RDSP90       { exit; }

@RDSP20:
                MOV    AX,0FFh       { true to AX, no error }

@RDSP90:
                OR     AX,AX         { set flags for return }
End;

Procedure Dummy_DMA_ISR; Assembler;
Asm
                PUSH   AX
                PUSH   DS

                MOV    AX,SEG SBInt    { Data segment to AX register }
                MOV    DS,AX

                MOV    SBIrq,DX    { update interrupt variable with }
                                   { number of interrupt called }
                MOV    DX,SBInt
                ADD    DX,0EH      { DX = DSP data available port 2xEh }
                IN     AL,DX       { acknowledge DSP interrupt }

                MOV    AL,20H      { send EOI (end of interrupt) to }
                OUT    20H,AL      { interrupt controller port 20h }

                POP    DS
                POP    AX
                POP    DX
                IRET               { interrupt return }
End;

Procedure Dummy_Dma_INT2; far; Assembler;
Asm
                PUSH   DX
                MOV    DX,2
                JMP    DUMMY_DMA_ISR
End;

Procedure Dummy_Dma_Int3; far; Assembler;
Asm
                PUSH   DX
                MOV    DX,3
                JMP    DUMMY_DMA_ISR
End;

Procedure Dummy_Dma_Int5; far; Assembler;
Asm
                PUSH   DX
                MOV    DX,5
                JMP    DUMMY_DMA_ISR
End;

Procedure Dummy_Dma_Int7; far; Assembler;
Asm
                PUSH   DX
                MOV    DX,7
                JMP    DUMMY_DMA_ISR
End;

Procedure SetupInterrupt; Assembler;
Asm
                PUSH   BX
                PUSH   CX
                PUSH   DX

                CLI

                MOV    CL,AL       { preserve interrupt number for use }

                ADD    AL,8        { calculate interrupt vector addx }
                CBW
                SHL    AL,1
                SHL    AL,1
                MOV    DI,AX

                PUSH   ES          { setup and preserve interrupt }
                XOR    AX,AX
                MOV    ES,AX
                MOV    AX,ES:[DI]
                MOV    DS:[BX],AX
                MOV    ES:[DI],DX

                MOV    AX,ES:[DI+2]
                MOV    DS:[BX+2],AX
                MOV    ES:[DI+2],CS

                POP    ES

                MOV    AH,1        { enable interrupt control mask-bit }
                SHL    AH,CL
                NOT    AH

                IN     AL,21H
                AND    AL,AH
                OUT    21H,AL

                STI

                POP    DX
                POP    CX
                POP    BX
End;

Function CheckSBInt: boolean; Assembler;
Asm
                push   ds
                push   bp
                mov    bp,sp

                IN     AL,21H                       { save port mask }
                MOV    CX,AX
                PUSH   CX

                MOV    AL,2                         { setup end of DMA }
                MOV    DX,OFFSET DUMMY_DMA_INT2     { interrupts for all }
                MOV    BX,OFFSET ORG_INT2_ADDX      { possible IRQs }
                CALL   SetupInterrupt               { (2, 3, 5, and 7) }

                MOV    AL,3
                MOV    DX,OFFSET DUMMY_DMA_INT3
                MOV    BX,OFFSET ORG_INT3_ADDX
                CALL   SetupInterrupt

                MOV    AL,5
                MOV    DX,OFFSET DUMMY_DMA_INT5
                MOV    BX,OFFSET ORG_INT5_ADDX
                CALL   SetupInterrupt

                MOV    AL,7
                MOV    DX,OFFSET DUMMY_DMA_INT7
                MOV    BX,OFFSET ORG_INT7_ADDX
                CALL   SetupInterrupt

                MOV    SBIrq,0          { reset current IRQ }

                MOV    DX,SBInt
                ADD    DX,0CH           { DX = DSP write port 2xCh }
                MOV    AL,DSP_INTRQ_CMD { AL = interrupt request command }
                CALL   WriteDSP         { write command to DSP }

                XOR    AX,AX           { assume success }
                MOV    CX,WAIT_TIME    { load timeout value into CX }
                CLD

                MOV    AX,0FFh      { set sound blaster found }

@VI10:
                CMP    SBIrq,0      { see if interrupt has been changed }
                JNE    @VI90        { if so, continue }
                CALL   LITTLEWAIT
                LOOP   @VI10           { if not, keep waiting }

                MOV    AX,0            { set DMA failure error }

@VI90:
                PUSH   AX              { save result variable }

                MOV    AL,2                         { restore end of DMA }
                MOV    BX,OFFSET ORG_INT2_ADDX      { interrupts }
                CALL   RestoreInterrupt

                MOV    AL,3
                MOV    BX,OFFSET ORG_INT3_ADDX
                CALL   RestoreInterrupt

                MOV    AL,5
                MOV    BX,OFFSET ORG_INT5_ADDX
                CALL   RestoreInterrupt

                MOV    AL,7
                MOV    BX,OFFSET ORG_INT7_ADDX
                CALL   RestoreInterrupt

                POP    AX              { restore result }

                OR     AX,AX

                POP    CX              { set back interrupts mask byte }
                PUSH   AX
                MOV    AL,CL
                OUT    21H,AL
                POP    AX

                mov    sp,bp
                pop    bp
                pop    ds
End;

Function FindSB: boolean;
var fnd: boolean;
Begin
WriteLn('SB detect program by Alexander Larkin created on 1/10/1999');
b:=0;
 Repeat
  SBInt:=addresses[b];
  Fnd:=CheckSBInt;
  if Fnd then
   Begin
    Write('SB found on address 0x',HexStr(SBInt),'h and on IRQ ',SBIrq,'.     ');
    if ResetDsp then WriteLn('SB initializated') else
     Begin
      WriteLn('Cannot initializate SB');
      Fnd:=false;
     End;
   End else
 Inc(b);
 Until (b=(sizeof(addresses) div 2-1)) or Fnd;
if fnd=false then
 Begin
  SbInt:=$220;
  SbIrq:=5;
  SbDma:=1;
 End;
FindSb:=fnd;
End;

Function HexStr(w: word): string;
const hx: string[16]='0123456789ABCDEF';
var w1: word;
    s: string;
Begin
 s:='';
 w1:=4096;
 repeat
  s:=s+hx[w div w1+1];
  w:=w mod w1;
  w1:=w1 div 16;
 until w1=0;
 while (s<>'') and (s[1]='0') and (length(s)>2) do delete(s,1,1);
 HexStr:=s;
End;

End.