{This unit created by Alexander Larkin. Under construction! Ask me
for the latest version, please. I appreciate you to send me your
comments about this unit.

 Alexander Larkin
 E-Mail:    larkin@titov.msk.ru
 WWW:       http://www.geocities.com/SiliconValley/6235/avlgraph.htm
            http://larkin.spa.umn.edu/avlgraph.htm
}

Unit GoodVga;

{$G+}
{This turn on 286 computer instructions use.}
{Are 286 computer instructions avaliable on your computer? I think so too}

INTERFACE
Uses GoodFont;

var HaltIsOn: boolean;
    TryHalt: procedure;
    ScrSaved: boolean;
    bin: string[10];
    LoadPictures: boolean;
    ErrorString: string;

Procedure BIOS1SetPalette(ColF,ColT: byte; var pal);
{Save text screen. Use it before turning graphic on}
Procedure SaveScreen;
{Restore text scrren. Use this after SaveScreen and in text mode}
Procedure LoadScreen;
{This close everything and clean memory and restore text screen}
Procedure CloseGoodVga;
{Clean text screen in text mode}
Procedure Clear(clr: word);
{Clean palette in graphic mode}
Procedure CleanPal;
{Switch to graphic mode 320x400x256. There are 2 video pages in this mode}
Procedure Set_320x400;
{Switch to graphic mode 320x240x256. There are 3 video pages in this mode}
Procedure Set_320x240;
{Switch to graphic mode 320x200x256. There are 4 video pages in this mode}
Procedure Set_320x200;
{Set XOR, AND, OR or NORMAL put. Use this for lines and pixels}
Procedure setput(kindput: byte);
{This procedure set current graphic write plane (B is number from 0 to 3)}
Procedure SetWPlane(b: byte);
{Set current visual page number to specified number}
Procedure set_visual_page(page: byte);
{Set current active page number to specified number}
Procedure set_active_page(page: byte);
{Clean screen in graphic mode (all pages) with color CLR}
Procedure CVM(clr: byte);
{Clean one video page in graphic mode (param: page, color number)}
procedure CVMpage(w: byte; clr: byte);
{Copy current video page to video page PDST}
Procedure CopyPage(pdst: byte);
{Put image PFR to coordinates X,Y}
procedure PutImage(x,y: integer; P: pointer);
{This procedure output img number num from ALG block or border if no img}
procedure PutAlgImage(x,y: integer; num: word);
{Get image from X,Y,X1,Y1 to P}
Procedure GetImage(x,y,x1,y1: integer; P: pointer);
{Out text text line S to coordinates X,Y}
Procedure OutTextXY(x,y: integer; s: string);
{This function return width of text line S}
Function Width(s: string): word;
{This function return height of text line}
Function Height: word;
{Change current text font to other one}
Procedure SetFont(w: word);
{Load ALG file to memory. It do not use HEAP! It reserve some free memory.
Be sure that your program do not reserve all memory. This function need
enough free memory to load ALG file. This function return error code.
Use LoadAlgError procedure to understand this code. The 0 is OK code.
You may load many ALG files (one after other). This procedure use one
memory block and change in size when you load next ALG file}
Function LoadAlgFile(fn: string): byte;
{If LoadAlgFiles function returned "Not enough memory" message, then
try this procedure. This procedure try to clean MEMORY block and to
reload all ALG files that are in memory (without decompression). It
load the latest ALG file (that was not enough memory for) too.
( compressed images are much smaller, but it is slow to output it.
  For the most of the times it is enough memory to load compressed
  images, when there is no enough memory to load decompressed images )}
Function ReloadAlgFiles: byte;
{Load palette from ALG file. This function return error code. Use
LoadAlgError procedure to understand this code.
  Return:
    0     - OK (files loaded)
    other - standart ALG error (LoadAlgError tells you about it) }
Function LoadAlgPalette(fn: string): byte;
{Return string for error code}
Function LoadAlgError(b: byte): string;
{This function extract one image in memory and return true if it is
 successfuly extracted}
Function ExtractImage(w: word): boolean;
{This procedure clean ALG file. Do not forger to call it before exit.}
Procedure FreeAlg;
{Set color for graphic (lines, text and pixels)}
Procedure SetColor(b: byte);
{Set background color for graphic (text)}
Procedure SetBGColor(b: byte);
{Specialy for OutTextXY procedure. This turn on slow flow color (every new
 line of text is in a new color). Text color increment every time.}
Procedure SetCycleColor(b: boolean);
{Load NUMCOL colors from PAL. The first color for load is ColF
 (it must be first in PAL array)}
Procedure BIOSSetPalette(ColF,NumCol: byte; var pal);
{This function return POINTER to image in ALG block. Use
 PutImage(x,y,Image(n)) after LoadAlgFile(s) to output image
 to the screen. X,Y is coordinates. N is image number. S is
 ALG file name here.}
Function Image(W: word): pointer;
{This function return number of images in memory}
Function ImageNum: word;
{This function return name of image W from ALG block}
Function ImageName(W: word): string;
{This function return width of image W from ALG block}
Function ImageWidth(W: word): word;
{This function return height of image W from ALG block}
Function ImageHeight(W: word): word;
{This function switch current palette to palette from ALG file.
 Call this after LoadAlgFile and before PutImage procedures.}
Procedure SetAlgPalette;
{This procedure turn on very nice palette. Call it in graphic mode
 before lines or pixels output.}
Procedure SetPaletteRaduga;
{This function return how many times line with ends X,Y,X1,Y1
 cross the image from ALG block with coordinates X2,Y2.
 X2,Y2 is image from ALG block coordinates}
Function ImageCross(x,y,x1,y1,x2,y2: longint; num: word): word;
{This function return true if this image have border.
 NUM is number of the image from ALG memory block.}
Function ImageBorder(num: word): boolean;
{This function return true if image number NUM with corrdinates X1,Y1
 cross image number NUM1 with coordinates X2,Y2}
Function ObjectCross(num,num1: word; x1,y1,x2,y2: longint): boolean;
{This function return true if graphic mode turned on}
Function GraphOn: boolean;
{This function return current graphic mode number}
Function GetGraphMode: byte;
{This function return current active page number}
Function APageNum: byte;
{This function return current visual page number}
Function VPageNum: byte;
{This function return current transparent color}
Function TransparentColor: byte;
{This procedure set transparent color to B. It work for PUTIMAGE and
 OUTTEXTXY procedures. You may put sprites (images without background).
 Use 255 to turn on AUTO DETECT transparent background color.}
Procedure SetTransparentColor(b: byte);
{This function return graphic screen width}
Function GetMaxX: word;
{This function return graphic screen height}
Function GetMaxY: word;
{This procedure put pixel to coordinates X,Y (for graphic modes only)}
Procedure putpixel(x,y: integer);
{This function return current colors constant}
Function getpixel(x,y: integer): byte;
{This function return current colors constant}
Function GetColor: word;
{This function load current colors constant (the same is SetColor and
 SetBgColor)}
Procedure LoadColor(w: word);
{This procedure output line with ends X1,Y1,X2,Y2 in graphic mode}
Procedure Line(x1,y1,x2,y2: integer);
{This procedure output image border to coordinates X,Y. Image is image
 from ALG block with number NUM}
Procedure OutBorder(x,y: integer; num: word);
{This procedure set right down screen corner coodinates to X,Y}
Procedure RightDownCorner(x,y: integer);
{This function able you to load graphic font from file S}
Function LoadFontFile(s: string): boolean;
{This function clean memory reserved by different graphic fonts}
Procedure CloseFonts;
{This function return false if graphic library cannot be initializated}
Function BadVGA: boolean;
{This procedure able you to set standart BIOS screen modes.
 Use SetVideoMode(3) to switch current video mode to text mode (80x25x16)}
Procedure SetVideoMode(b: byte);
{This function return free memory size (not HEAP size, but memory size)}
Function MemorySize: longint;
{This function return video memory base address (standart is 0A000h)}
Function BasePage: word;
{This function copy something from block P to buffer memory block. Return
 false in there in not enough memory}
Function PutToBuffer(P: pointer; w: word): boolean;
{This function return something from buffer memory block to P memory block.
 Return false if buffer memory block size lower than W}
Function GetFromBuffer(P: pointer; w: word): boolean;
{This function return buffer size}
Function BufferSize: word;
{This procedure clear (release) auto decompression buffer.
 You do not need to call this procedure.}
Procedure TurnOffAutoDecompression;
{This function create (allocate) new auto decompression buffer}
Function TurnOnAutoDecompression: boolean;
{This set the auto decompression buffer size}
Procedure SetBufferSize(w: word);

{Put this in graphic cycle before Set_Visual_Page call and before
 Set_Active_Page call. (do not wait for anything under Windows 98
 on Sony notebook computers for some reasons)}
Procedure WaitVRetrace;

{Put this in graphic cycle after Set_Visual_Page call}
Procedure WaitRetrace;

{This procedure save current palette to P. It need 768 bytes of memory.}
Procedure SavePalette(var P);

IMPLEMENTATION

const
      mxsize: word=0;
      PBufSize: word=65535;
      Images=500;
      xh: word=319;
      yh: word=199;
      colnow: word=7;
      cycle: byte=0;
      TrCOL: byte=255; {255 mean automatic load}
      pagebase: word=$a000;
      pagesize: word=16000;
      RPlanes:      array[1..4] of byte=(1,2,3,4);
      WPlanes:      array[1..4] of byte=(1,2,4,8);
      BytesPerLine=80;
      GMODE: byte=255;  {0=320x200; 1=320x240; 2=320x400}
      vpage: byte=0;
      apage: byte=0;
      FontNow: pointer=nil;
      ClearAlgList: boolean=true;
      ADBU: boolean=true;
      CGV: boolean=false;
      REload: boolean=false;

const DefaultPal: array[0..16,0..2] of byte=
(
{(Red,Green,Blue)}       {comments}
(0,0,0),                 {0  black        }
(0,0,42),                {1  blue         }
(0,42,0),                {2  green        }
(0,42,42),               {3  Cyan         }
(42,0,0),                {4  Red          }
(42,0,42),               {5  Magenta      }
(42,21,0),               {6  Brown        }
(32,32,32),              {7  LightGray    }
(12,12,12),              {8  DarkGray     }
(21,21,63),              {9  LightBlue    }
(21,63,21),              {10 LightGreen   }
(21,63,63),              {11 LightCyan    }
(63,21,21),              {12 LightRed     }
(63,21,63),              {13 LightMagenta }
(63,63,21),              {14 Yellow       }
(63,63,63),              {15 White        }
(0,0,0));                {16 Black        }


type
     Colors=record
              FCol,BCol: byte;
              FColOld: byte;
              Cycle: byte;
             end;

     pxl=record
          x,y: word;
         end;

     Brd=array[0..25] of pxl;                   {Border line pixels         }

     ImageHeader=record
                 ImageType: byte;               {0 - compressed             }
                 Ps: longint;                   {Image offset               }
                 Name: string[8];               {Image name                 }
                 Size: word;                    {Compressed size            }
                 Border: Brd;                   {Border line pixels         }
                 PictureType: byte;
                 Pixels: byte;                  {Pixels in border plus 1    }
                end;

     ManyImages=array[0..Images] of ImageHeader;

Var PalZero,InitFont,BGS: Pointer;
    Crs: word;
    GraphMode: boolean;
    FntIs,PZ: boolean;
    MaxY: word;

    LoadFonts: array[0..9] of pointer;
    LoadFontsSize: array[0..9] of word;
    LastFont: word;

    FileMem: word;
    MemSize: longint;
    ImagesIs: word;

    Header: ^ManyImages;
    HeaderIs: boolean;
    HSZ: word;

    ColPal: word;
    palf: array[0..255,0..2] of byte;
    PBuf: pointer;
    ImagePointer: array[0..Images] of pointer;

    err,PBufOn: byte;
    CURPB: word;

    BadVershina: word;
    Vershina: boolean;
    bgp: pointer;

    LmGet: word;

    AlgFileName: array[0..19] of string[20];
    AlgFilesLoaded: word;

{$F+,S-}

{34}procedure setput(kindput: byte); assembler;
asm
{2} mov dx,3ceh
{2} mov al,3
{10}out dx,al
{4} mov al,kindput
{2} inc dx
{10}out dx,al
end;

Procedure WaitRetrace; assembler;
asm
     MOV  DX,3DAh
@L1: IN   AL,DX
     TEST AL,08h
     JNZ  @L1
@L2: IN   AL,DX
     TEST AL,08h
     JZ   @L2
end;

Procedure WaitVRetrace; assembler;
asm
     MOV  DX,3DAh
@L1: IN   AL,DX
     TEST AL,08h
     JNZ  @L1
end;

(*
Procedure WaitVRetrace; assembler;
asm
     xor ax,ax
     mov es,ax
     mov dx,es:[463h] {DX:=$3d4}
     add dx,6         {DX:=$3da}

@L1: IN   AL,DX
     TEST AL,08h
     JNZ  @L1
end;

Procedure WaitRetrace; assembler;
asm
     xor ax,ax
     mov es,ax
     mov dx,es:[463h]  {DX:=$3d4}
     add dx,6          {DX:=$3da}

@L1: IN   AL,DX
     TEST AL,08h
     JNZ  @L1
@L2: IN   AL,DX
     TEST AL,08h
     JZ   @L2
end;*)


Procedure BIOSSetPalette(ColF,NumCol: byte; var pal); Assembler;
     asm
      mov ax,Word Ptr Pal[2]
      mov es,ax
      mov ah,10h
      mov al,12h
      mov bl,ColF       {Col from}
      xor bh,bh
      mov cl,NumCol     {Col num}
      xor ch,ch
      mov dx,Word Ptr Pal
      int 10h
     end;

Procedure SetPaletteRaduga;
var rr,gg,bb,k: word;
    palrad: array[16..257,0..2] of byte;

       procedure setrgb(color,r,g,b: byte);
        begin
         palrad[color,0]:=r;
         palrad[color,1]:=g;
         palrad[color,2]:=b;
        end;

    begin
      rr:=63;
      gg:=0;
      bb:=0;
      k:=16;

      for gg:=0 to 63 do begin
      k:=k+1;


      palrad[k,0]:=rr;
      palrad[k,1]:=gg;
      palrad[k,2]:=bb;
      end;

      for rr:=63 downto 32 do begin

      k:=k+1;
      palrad[k,0]:=rr;
      palrad[k,1]:=gg;
      palrad[k,2]:=bb;

      bb:=bb+1;
      end;

      for bb:=32 downto 0 do begin
      k:=k+1;
      palrad[k,0]:=rr;
      palrad[k,1]:=gg;
      palrad[k,2]:=bb;

      end;

      for gg:=63 downto 0 do begin
      k:=k+1;
      palrad[k,0]:=rr;
      palrad[k,1]:=gg;
      palrad[k,2]:=bb;

      bb:=bb+1;
      end;

      for rr:=rr downto 0 do begin
      k:=k+1;
      palrad[k,0]:=rr;
      palrad[k,1]:=0;
      palrad[k,2]:=63;

      end;

      for rr:=16 downto 3 do begin
      k:=k+1;
      palrad[k,0]:=round(rr*3.3);
      palrad[k,1]:=round(rr*3.3);
      palrad[k,2]:=round(rr*3.3);
      end;
     BIOSSetPalette(17,240,PalRad);
    end;

Procedure SaveScreen;
const SCR: pointer=ptr($B800,0);
begin
 if HaltIsOn then TryHalt;
 if scrsaved then exit;
 if MaxAvail<5000 then exit;
 getmem(bgp,5000);
 move(SCR^,BGp^,4000);
 crs:=memw[$40:$50];
 scrsaved:=true;
end;

Procedure LoadScreen;
const SCR: pointer=ptr($B800,0);
begin
 if HaltIsOn then TryHalt;
 if scrsaved then
  begin
   move(BGp^,SCR^,4000);
   memw[$40:$50]:=crs;
   freemem(bgp,5000);
   scrsaved:=false;
  end;
end;

procedure CloseFonts;
var w: word;
begin
if LastFont>0 then for w:=0 to LastFont-1 do
   FreeMem(LoadFonts[w],LoadFontsSize[w]);
end;

procedure CloseGoodVga;
var w: word;
begin
 if HaltIsOn then TryHalt;
if CGV then exit;
if LastFont>0 then for w:=0 to LastFont-1 do
   FreeMem(LoadFonts[w],LoadFontsSize[w]);
if pbufon=255 then
 begin
  FreeMem(PBuf,CurPB);
  pbufon:=0;
  CurPB:=0;
 end;
if GraphMode then
 asm
  mov ah,0
  mov al,3
  int 10h
 end;
if ScrSaved then LoadScreen;
if PZ then freemem(PalZero,768);
if FntIs then freemem(InitFont,23000);
CGV:=true;
end;

{Decompress block from ES:[BX] to DS:[SI]}
procedure DeCompress; Assembler;
asm
{********************************************}
   mov ax,word ptr es:[bx]{Table size to AX}
   and ax,32767
   add bx,2
   mov bp,bx
   xor di,di
   mov cl,3
   shl ax,cl
   add bx,ax
   mov dx,word ptr es:[bx]{Number of codes to ax}
   add bx,2
   mov cl,0
   mov al,byte ptr es:[bx]

@NextStep:
   mov ch,al
   shr ch,cl
   and ch,1
   inc cl
   cmp cl,8
   jne @ClOk
   xor cl,cl
   inc bx
   mov al,byte ptr es:[bx]
   @ClOk:
   cmp ch,1
   je @GoRightSubTree

   mov di,word ptr es:[bp+di+4]
   cmp word ptr es:[bp+di+2],0ffffh
   je @NextStep

   jmp @AddCode

   @GoRightSubTree:

   mov di,word ptr es:[bp+di+6]
   cmp word ptr es:[bp+di+2],0ffffh
   je @NextStep

  @AddCode:

   mov ah,byte ptr es:[bp+di+2]
   mov byte ptr ds:[si],ah
   xor di,di
   inc si
   dec dx
   cmp dx,0
   jne @NextStep

{********************************************}
end;

{30}procedure setRPlaneAsm; assembler; {input BH - planes}
 asm
{2}  mov dx,3ceh
{2}  mov al,4
{10} out dx,al
{2}  add dx,1
{2}  sub bh,1
{2}  mov al,bh
{10} out dx,al
 end;

procedure putpixel(x,y: integer);
begin
 asm
  mov cx,xh
  cmp x,cx
  jae @NoPP
  mov cx,yh
  cmp y,cx
  jae @NoPP
  push di
  mov cx,x
  mov dx,y
  mov bl,byte ptr ColNow
  mov ax,PageBase
  mov es,ax
  mov ax,(320/4)
  mul dx
  push cx
  shr cx,1
  shr cx,1
  add ax,cx
  mov di,ax
  pop cx
  and cl,3
  mov ah,1
  shl ah,cl
  mov dx,3c4h
  mov al,2
  out dx,ax
  mov bh,cl
  inc bh
  call SetRPlaneAsm
  mov bh,es:[di]
  mov es:[di],bl
  pop di
  @NOPP:
 end;
end;

function getpixel(x,y: integer): byte;
var b: byte;
begin
 asm
  mov cx,xh
  cmp x,cx
  jae @NoPP
  mov cx,yh
  cmp y,cx
  jae @NoPP
  push di
  mov cx,x
  mov dx,y
  mov bl,byte ptr ColNow
  mov ax,PageBase
  mov es,ax
  mov ax,(320/4)
  mul dx
  push cx
  shr cx,1
  shr cx,1
  add ax,cx
  mov di,ax
  pop cx
  and cl,3
  mov ah,1
  shl ah,cl
  mov dx,3c4h
  mov al,2
  out dx,ax
  mov bh,cl
  inc bh
  call SetRPlaneAsm
  mov bh,es:[di]
  pop di
  mov b,bh
  @NOPP:
 end;
GetPixel:=b;
end;

{393271}procedure Clear(clr: word); assembler; {clean video memory}
{0.024 second on 386 SX 16}
asm
   cmp CGV,1
   je @Next
{2}      mov cx,2000          {set cx to clean length}
{2}      mov ax,0b800h        {start address}
{2}      mov es,ax            {move ax to segment register}
{2}      xor di,di            {set di to zero}
{4}      mov ax,clr           {set ax to zero}
{2}      cld                  {cleaning}
@again:
{393210} rep stosw            {cleaning}
{5}      jcxz @next
         jmp @again
@next:
end;

{77}procedure SetRWMode(R,W: byte); assembler;
asm
{2} mov dx,3ceh                   {read MODE value}
{2} mov al,5
{10}out dx,al
{2} inc dx
{12}in al,dx
{2} mov bl,al
{2} and bl,244                    {turn off bits 0,1,3}

{2} mov dx,3ceh                   {set MODE value}
{2} mov al,5
{10}out dx,al
{2} inc dx
{4} mov al,w
{2} and al,3
{4} mov ah,r
{2} and ah,1
{3} shl ah,3
{2} or al,ah
{2} or al,bl
{10}out dx,al
end;

procedure CleanPal; Assembler;
asm
   cmp CGV,1
   je @StopNow
 cmp GraphMode,0
 je @StopNow
 mov ax,WORD PTR PalZero[2]
 mov es,ax
 mov ah,10h
 mov al,12h
 mov bx,0
 mov cx,255
 mov dx,WORD PTR PalZero
 int 10h
 @StopNow:
end;

{~400}procedure set_320x400; assembler;             {You can use 2 video pages!}
{1/40000 second on 386 SX 16}
asm
   cmp CGV,1
   je @EndNow
     mov GraphMode,255
{2}  push di            {save DI}

{2}  mov ax,0013h       {set standart mode 13h (320*200*256) using BIOS}
{>33}int 10h
     call CleanPal

{2}  mov dx,3c4h        {chosing register of memory structure}
{2}  mov al,4
{11} out dx,al

{2}  inc dx             {reading register of memory structure}
{13} in al,dx

{2}  and al,11110111b   {set bit D4 to zero}       {I do not understand bit D4}
                    {set bit D3 to one:}
{2}  or al,00000100b    {turn off addressation of even and odd planes of memory}
{11} out dx,al          {writing to register new value}
 {after set new value to this register, video memory like in BIOS mode
 10h and 12h except, for every pixel one byte of memory}

{2}  mov dx,3ceh        {chosing register: working mode of graphic controler}
{2}  mov al,5
{11} out dx,al

{2}  inc dx             {reading it's value}
{13} in al,dx
                    {set bit D5 to zero}
{2}  and al,11101111b   {turn off addressation of even and odd planes of memory}
{11} out dx,al

{2}  dec dx             {chosing register of different things of graphic conroler}
{2}  mov al,6
{11} out dx,al

{2}  inc dx             {reading it's value}
{13} in al,dx
                    {set bit D2 to zero}
{2}  and al,11111101b   {turn off bit that control odd with even planes}
{11} out dx,al

{2}  mov dx,3d4h        {chosing register: height text characters, controler ELT}
{2}  mov al,9
{11} out dx,al
{2}  inc dx
{13} in al,dx
{2}  and al,01100000b   {turn off double scaning}
{11} out dx,al

{2}  dec dx             {chosing register: coordinates underline characters}
{2}  mov al,14h
{11} out dx,al

{2}  inc dx             {turn off double words addressation to video memory}
{13} in al,dx
{2}  and al,10111111b
{11} out dx,al

{2}  dec dx             {chosing register of mode control}
{2}  mov al,17h
{11} out dx,al

{2}  inc dx             {turn on byte addressation to video memory}
{13} in al,dx
{2}  or al,01000000b
{11} out dx,al
{4}  pop di             {load DI}
{     push 0
     call cvm}
     mov pagebase,0a000h
     mov pagesize,32000
     mov gmode,2
     mov xh,319
     mov yh,399
     mov MaxY,399
      push 0
      push 17
      push SEG DefaultPal
      push OFFSET DefaultPal
      call BiosSetPalette
     @EndNow:
end;

procedure set_320x240;                      {You can use 3 video pages!}
const CRTCTable: array[1..10] of word=(
                                       $0D06,
                                       $3E07,
                                       $4109,
                                       $EA10,
                                       $AC11,
                                       $DF12,
                                       $0014,
                                       $E715,
                                       $0616,
                                       $E317
                                      );
var w: byte;
begin
if CGV then exit;
GraphMode:=true;
InLine($B8/$13/$00/$CD/$10);    { mov ax,013h; int 10h   }
CleanPal;
{CVM(0);}
PageBase:=$A000;
PageSize:=$4B00;
port[$3C4]:=4;              {EGA_SEQUENCER, 4, 6}
port[$3C4+1]:=6;
port[$3D4]:=$17;            {EGA_CRTC, 17h, E3h}
port[$3D4+1]:=$E3;
port[$3D4]:=$14;            {EGA_CRTC, 14h, 0}
port[$3D4+1]:=0;

port[$3C4]:=0;              {EGA_SEQUENCER, 0, 1}
port[$3C4+1]:=1;
port[$3C2]:=$E3;

port[$3C4]:=0;              {EGA_SEQUENCER, 0, 3}
port[$3C4+1]:=3;
port[$3D4]:=$11;            {EGA_CRTC, 11h, w}
w:=port[$3D4+1] and $7F;
port[$3D4]:=$11;            {EGA_CRTC, 11h, w and 7Fh}
port[$3D4+1]:=w;

for w:=1 to 10 do portw[$3D4]:=CRTCTable[w];

port[$3C4]:=2;              {EGA_SEQUENCER, EGA_MAP_MASK, 0Fh}
port[$3C4+1]:=$0F;
BIOSSetPalette(0,17,DefaultPal);
GMODE:=1;
xh:=319;
yh:=239;
MaxY:=239;
end;

procedure Set_320x200; assembler;             {You can use 4 video pages!}
asm
   cmp CGV,1
   je @EndNow
 push di            {save DI}

 mov ax,0013h       {set standart mode 13h (320*200*256) using BIOS}
 int 10h
 call CleanPal

 mov DX,3C4h
 mov AL,4
 out DX,AL

 mov DX,3C4h+1
 mov AL,6
 out DX,AL

 mov DX,3D4h
 mov AL,17h
 out DX,AL

 mov DX,3D4h+1
 mov AL,0E3h
 out DX,AL

 mov DX,3D4h
 mov AL,14h
 out DX,AL

 mov DX,3D4h+1
 mov AL,0h
 out DX,AL

 pop di

{     push 0
     call cvm}

 mov gmode,0
 mov GraphMode,255
 mov xh,319
 mov yh,199
 mov MaxY,199
 mov PageBase,0A000h
 mov PageSize,19200
 push 0
 push 17
 push SEG DefaultPal
 push OFFSET DefaultPal
 call BiosSetPalette
 @EndNow:
end;

{32}procedure SetWPlaneAsm; assembler; {input: BL - planes}
asm
{4} {mov GetWPlane,bl}
                  {turn on writing pixels to n color planes,}
{2} mov dx,03c4h
{2} mov al,2
{10}out dx,al        {will write to second register in port 03c4h}

{2} inc dx
{2} mov al,bl
{10}out dx,al        {writing planes to register: permision of write plane}
end;

procedure SetWPlane(b: byte);
begin
 if b<4 then b:=WPlanes[b+1] else b:=15;
 asm
  mov bl,b
  call SetWPlaneAsm
 end;
end;

{134}procedure set_visual_page(page: byte); assembler;
asm
   cmp CGV,1
   je @EndNow
@next:
{2}   mov dx,03dah
{13}  in ax,dx
{2}   and ax,08h
{2}   cmp ax,0
{~20} je @next
{2}   mov ax,0ch
{2}   mov dx,03d4h
{11}  out dx,ax
{4}   mov al,page
{2}   xor ah,ah
{4}   mov bx,PageSize
{2}   xor dx,dx
{14}  mul bx
{2}   mov bx,ax
{3}   shr ax,8
{2}   mov dx,03d5h
{11}  out dx,ax
{2}   mov ax,0dch
{2}   mov dx,03d4h
{11}  out dx,ax
{2}   and bx,0fh
{2}   mov ax,bx
{2}   mov dx,03d5h
{11}  out dx,ax
      mov al,page
      mov vpage,al
@EndNow:
end;

{43}procedure set_active_page(page: byte); assembler;
asm
   cmp CGV,1
   je @EndNow
{2}      xor dx,dx
{4}      mov bx,PageSize      {begin ax:=$A000+pdst*(PageSize div 16)}
{3}      shr bx,4
{4}      mov al,page
{2}      xor ah,ah
{14}     mul bx
{2}      add ax,0a000h        {end   ds:=$A000+pdst*(PageSize div 16)}
{4}      mov pagebase,ax
         mov al,page
         mov apage,al
 @EndNow:
end;

{393271}procedure CVM(clr: byte); assembler; {clean video memory}
{0.024 second on 386 SX 16}
asm
   cmp CGV,1
   je @EndNow
{2}      mov bl,0fh           {turn on write pixels to all 4 color planes}
{40}     call SetWPlaneasm;   {}
{2}      mov cx,32768         {set cx to clean length}
{2}      mov ax,0a000h        {start address}
{2}      mov es,ax            {move ax to segment register}
{2}      xor di,di            {set di to zero}
{4}      mov al,clr           {set ax to zero}
         mov ah,al
{2}      cld                  {cleaning}
@again:
{393210} rep stosw            {cleaning}
{5}      jcxz @next
         jmp @again
@next:
 @EndNow:
end;

procedure CopyPage(pdst: byte); assembler;
asm
   cmp CGV,1
   je @EndNow
{4} mov bl,15              {Set write to all 4 planes}
{40}Call SetWPlaneAsm

{2}push 0
{2}push 1
{87}call SetRWMode         {Set read mode to 0, write mode to 1}

push ds
push bp

         mov al,BytesPerLine   {BEGIN      ax:=GetMaxY*BytesPerLine}
         xor ah,ah
         xor dx,dx
         mov bx,MaxY
         mul bx                {END        ax:=GetMaxY*BytesPerLine}
         mov cx,ax


{2}      xor dx,dx
{4}      mov bx,PageSize      {begin ds:=$A000+pdst*(PageSize div 16)}
{3}      shr bx,4
{4}      mov al,pdst
{2}      xor ah,ah
{14}     mul bx
{2}      add ax,0a000h
         mov bx,0
         mov ds,PageBase
         mov es,ax
         mov bp,0
                              {end   ds:=$A000+pdst*(PageSize div 16)}

         mov si,bp
         mov di,bx
{         shr cx,2}

         cld

         @again:
         repz movsb  {COPY  CX times from DS:SI to ES:DI}
{         db 0f3h,066h,0a5h} {REPZ MOVSD}
         jcxz @next
         loop @again
         @next:

pop bp
pop ds

{2}push 0
{2}push 0
{87}call SetRWMode         {Set read mode to 0, write mode to 0}
@EndNow:
end;

procedure PutImageAsm(x,y: integer; Pfr: pointer); assembler;
var aa,bb,ww: word;
    tc: byte;
    maxx,maxy: integer;
asm
   cli
   push word ptr Pbuf[2]
   pop bb
   push word ptr Pbuf
   pop aa
   push xh
   push yh
   pop MaxY
   pop MaxX

   mov bl,TrCOL
   mov tc,bl

{2}push di
{2}push si
{2}push bp
{2}push ds

{4}mov bx,word(Pfr)         {bx:=ofs(P^)}
{4}mov es,word(Pfr+2)       {es:=seg(P^)}
   mov ax,es
   cmp ax,0
   je @NoOutAtAll

    mov ax,x
    cmp ax,MaxX
    jg @nooutatall

    add ax,es:[bx]
    cmp ax,0
    jl @nooutatall

{4} mov ax,y              {begin  bp:=(BytesPerLine*y) mod 16}

    cmp ax,MaxY
    jg @nooutatall

    push ax
    add ax,es:[bx+2]
    cmp ax,0
    pop ax
    jl @nooutatall


   {*****}
   mov si,word ptr es:[bx+4]
   and si,32768
   cmp si,32768
   jne @NotCompressed
   cmp bb,0 {There is no buffer for decompresion. Cannot output image}
   je @nooutatall

   push ax
   mov si,es:[bx+2]
   mov ax,es:[bx]
   mul si
   cmp ax,PBufSize
   pop ax
   ja @nooutatall {the buffer is to small}

    mov ds,bb
    mov si,aa
     push word ptr es:[bx]
     push word ptr es:[bx+2]
     pop word ptr ds:[si+2]
     pop word ptr ds:[si]
     add bx,4
     add si,4
    call DeCompress
    pop ds
    pop bp
     mov ax,y
     mov bx,aa       {bx:=ofs(P^)}
     mov es,bb       {es:=seg(P^)}
    push bp
    push ds
   {*****}

@NotCompressed:

    mov dl,byte ptr TC
    cmp dl,255
    jne @TCok
{4} mov dl,byte ptr es:[bx+6]
    @TCok:
    xor dh,dh
    push dx {Save transperent color for al}

    push ax {save y (in dx)}

    cmp ax,0
    jl @yinttype
    jmp @noytype

    @yinttype:
    push bx
    mov bx,65535
    sub bx,ax
    add bx,1
    mov ax,bx
    pop bx

    @noytype:

{4} mov cl,80             {begin  ax:=(BytesPerLine*y) div 16+PageBase}
{2} xor ch,ch
{2} xor dx,dx
{14}mul cx
{2} mov cx,16
{2} xor dx,dx
{22}div cx

{4}  mov cx,x              {begin  ax:=ax+x div 4}
     mov di,cx

     cmp cx,0
     jl @inttype           {if integer(cx)<0 then goto @intttype}

{2}  push cx
{3}  shr cx,2
{2}  mov si,cx
     add si,32768
{4}  pop cx
     jmp @sidone

     @inttype:
     push cx
     push bx
     mov bx,65535
     sub bx,cx
     mov cx,bx
     shr cx,2
     mov si,32767
     sub si,cx
     pop bx
     pop cx

@sidone:

{2} add si,dx             {end    si:=(BytesPerLine*y) mod 16}

    pop dx {Load Y}
    cmp dx,0
    jl @int_sub_instead
{4} add ax,pagebase       {end    ax:=(BytesPerLine*y) div 16+PageBase}
    jmp @subdone
    @int_sub_instead:

    push dx {Save Y}
    mov dx,ax
    mov ax,pagebase
    sub ax,dx
    pop dx  {Load Y}

    @subdone:

    sub ax,2048

{2}push ax                {begin  ds:=ax}


{2} and cx,3              {First plane where to put}
{2} mov ch,cl
{2} add ch,4


{4}pop ds                 {end    ds:=ax}
   pop ax {Load in al transperent color}

{4} mov ah,es:[bx+2]      {end    ah:=height (height from 0 to 255!)}
{2} add bx,4


   @1:
{2}push bx                    {begin  SetWPlane(WPlanes[cl and 3+1])}
{2}push dx
{2}push ax
{2}push cx

{2} and cl,3
{2} mov bl,1
{2} xor bh,bh
{3} shl bl,cl
{40}call SetWPlaneAsm
{4}pop cx
{4}pop ax
{4}pop dx
{4}pop bx                     {end    SetWPlane(WPlanes[cl and 3+1])}

{2}push si
{2}push cx

   push di

   sub ch,cl
   mov cl,4
   sub cl,ch
   xor ch,ch
   add di,cx

{2}mov cx,Word Ptr es:[bx]
   mov Word Ptr ww,cx
{2}add bx,2
{2}mov cl,ah
   xor ch,ch

   push ax
   push dx
    @2:
       cmp dx,MaxY
       ja @nostringout

{2}    push cx
{2}    push si
       push di
{2}    mov cx,0

        @3:

       cmp di,MaxX
       ja @noout           {If word(di)>319 then goto @noout}

{2}    mov ah,es:[bx]

{2}    cmp ah,al
{7}    je @noout

{2}    mov ds:[si],ah

@noout:
       add di,4

{2}      inc si
@nooutadd:

{2}      inc bx

{2}      inc cx
{2}      cmp cx,ww
{7}     jne @3
       pop di
{4}    pop si
{4}    pop cx

jmp @normoutdone

   @nostringout:
   add bx,ww

   @normoutdone:
   inc dx

{2}    add si,80
{2}   dec cx

{2}  cmp cx,0
{7} jne @2
   pop dx
   pop ax

   pop di
{4}pop cx
{4}pop si

{2}inc cl                     {next plane}

{2}cmp cl,4
{7}jne @ok
{2}inc si
@ok:


{2}cmp cl,ch
{7}jne @1

@nooutatall:

{4}pop ds
 {4}pop bp
{4}pop si
{4}pop di
sti
end;

procedure PutImage(x,y: integer; P: pointer);
Begin
PutImageAsm(x,y,P);
End;

procedure PutAlgImage(x,y: integer; num: word);
Begin
if LoadPictures then PutImageAsm(x,y,Image(num)) else
OutBorder(x,y,num);
End;

procedure TextPutImage(x,y: integer; P: pointer); assembler;
var ww: word;
    tc: byte;
    Col: colors;
    maxx,maxy: integer;
asm
   cmp CGV,1
   je @EndNow
   push xh
   push yh
   pop MaxY
   pop MaxX

   push Word Ptr ColNow
   pop Word Ptr Col
   mov bl,Col.FCol
   mov Col.FColOld,bl
   mov bl,TrCOL
   mov tc,bl
   mov bl,Cycle
   mov col.Cycle,bl

{2}push di
{2}push si
{2}push bp
{2}push ds

{4}mov bx,word(P)         {bx:=ofs(P^)}
{4}mov es,word(P+2)       {es:=seg(P^)}

    mov ax,x
    cmp ax,MaxX
    jg @nooutatall

    add ax,es:[bx]
    cmp ax,0
    jl @nooutatall

{4} mov ax,y              {begin  bp:=(BytesPerLine*y) mod 16}

    cmp ax,MaxY
    jg @nooutatall

    push ax
    add ax,es:[bx+2]
    cmp ax,0
    pop ax
    jl @nooutatall
        {Not compressed}
    mov dl,byte ptr TC
    cmp dl,255
    jne @TCok
{4} mov dl,byte ptr es:[bx+6]
    @TCok:
    xor dh,dh
    push dx {Save transperent color for al}

    push ax {save y (in dx)}

    cmp ax,0
    jl @yinttype
    jmp @noytype

    @yinttype:
    push bx
    mov bx,65535
    sub bx,ax
    add bx,1
    mov ax,bx
    pop bx

    @noytype:

{4} mov cl,80             {begin  ax:=(BytesPerLine*y) div 16+PageBase}
{2} xor ch,ch
{2} xor dx,dx
{14}mul cx
{2} mov cx,16
{2} xor dx,dx
{22}div cx

{4}  mov cx,x              {begin  ax:=ax+x div 4}
     mov di,cx

     cmp cx,0
     jl @inttype           {if integer(cx)<0 then goto @intttype}

{2}  push cx
{3}  shr cx,2
{2}  mov si,cx
     add si,32768
{4}  pop cx
     jmp @sidone

     @inttype:
     push cx
     push bx
     mov bx,65535
     sub bx,cx
     mov cx,bx
     shr cx,2
     mov si,32767
     sub si,cx
     pop bx
     pop cx

@sidone:

{2} add si,dx             {end    si:=(BytesPerLine*y) mod 16}

    pop dx {Load Y}
    cmp dx,0
    jl @int_sub_instead
{4} add ax,pagebase       {end    ax:=(BytesPerLine*y) div 16+PageBase}
    jmp @subdone
    @int_sub_instead:

    push dx {Save Y}
    mov dx,ax
    mov ax,pagebase
    sub ax,dx
    pop dx  {Load Y}

    @subdone:

    sub ax,2048

{2}push ax                {begin  ds:=ax}


{2} and cx,3              {First plane where to put}
{2} mov ch,cl
{2} add ch,4


{4}pop ds                 {end    ds:=ax}
   pop ax {Load in al transperent color}

{4} mov ah,es:[bx+2]      {end    ah:=height (height from 0 to 255!)}
{2} add bx,4


   @1:
{2}push bx                    {begin  SetWPlane(WPlanes[cl and 3+1])}
{2}push dx
{2}push ax
{2}push cx

{2} and cl,3
{2} mov bl,1
{2} xor bh,bh
{3} shl bl,cl
{40}call SetWPlaneAsm
{4}pop cx
{4}pop ax
{4}pop dx
{4}pop bx                     {end    SetWPlane(WPlanes[cl and 3+1])}

{2}push si
{2}push cx

   push di

   sub ch,cl
   mov cl,4
   sub cl,ch
   xor ch,ch
   add di,cx

{2}mov cx,Word Ptr es:[bx]
   mov Word Ptr ww,cx
{2}add bx,2
{2}mov cl,ah

   mov ch,Col.FColOld
   mov Col.FCol,ch

   xor ch,ch

   push ax
   push dx

    @2:

       cmp Col.Cycle,255
       jne @ThisNormal
        add byte ptr Col.FCol,3
       @ThisNormal:

       cmp dx,MaxY
       ja @nostringout

{2}    push cx
{2}    push si
       push di
{2}    mov cx,0

        @3:

       cmp di,MaxX
       ja @noout           {If word(di)>319 then goto @noout}

{2}    mov ah,es:[bx]

        cmp ah,1
        jne @Text1
        mov ah,Col.BCol
        jmp @OkPut
 @Text1:
        mov ah,Col.FCol
 @OkPut:

{2}    cmp ah,al
{7}    je @noout

{2}    mov ds:[si],ah

@noout:
       add di,4

{2}      inc si
@nooutadd:

{2}      inc bx

{2}      inc cx
{2}      cmp cx,ww
{7}     jne @3

       pop di
{4}    pop si
{4}    pop cx

jmp @normoutdone

   @nostringout:
   add bx,ww

   @normoutdone:
   inc dx

{2}    add si,80
{2}   dec cx

{2}  cmp cx,0
{7} jne @2
   pop dx
   pop ax

   pop di
{4}pop cx
{4}pop si

{2}inc cl                     {next plane}

{2}cmp cl,4
{7}jne @ok
{2}inc si
@ok:

{2}cmp cl,ch
{7}jne @1

@nooutatall:

{4}pop ds
{4}pop bp
{4}pop si
{4}pop di
@EndNow:
end;

Procedure TurnOffAutoDecompression;
begin
 if HaltIsOn then TryHalt;
 If PBufOn=255 then
  begin
   PBufOn:=0;
   freemem(PBuf,CurPB);
   CurPB:=0;
   PBuf:=nil;
  end;
end;

Procedure SetBufferSize(w: word);
begin
 PBufSize:=w;
end;

Function BufferSize: word;
begin
 BufferSize:=PBufSize;
end;

Function TurnOnAutoDecompression: boolean;
begin
 if HaltIsOn then TryHalt;
 TurnOnAutoDecompression:=false;
 if PBufOn=255 then TurnOffAutoDecompression;
 if PBufOn=0 then
  Begin
   CurPB:=PBufSize;
   If MaxAvail<CurPB then exit;
   TurnOnAutoDecompression:=true;
   PBufOn:=255;
   GetMem(PBuf,CurPB);
  End;
end;

procedure GetImage(x,y,x1,y1: integer; P: pointer);
var w,h,a,b,w1,xd4: word;
    bb,nowpl,endpl: byte;
    DSP: pointer;
begin
if CGV then exit;
w:=abs(x1-x) div 4;
h:=abs(y1-y);
memw[seg(P^):ofs(P^)]:=w;
memw[seg(P^):ofs(P^)+2]:=h;
P:=ptr(seg(P^),ofs(P^)+4);
nowpl:=x mod 4;
endpl:=x1 mod 4;
xd4:=x div 4;

for b:=1 to 4 do
begin
if 0<endpl-nowpl then w1:=w+1 else w1:=w;
memw[seg(P^):ofs(P^)]:=w1;
P:=ptr(seg(P^),ofs(P^)+2);
bb:=RPlanes[nowpl+1];
asm
mov bh,bb
call SetRPlaneAsm
end;

for a:=y to y1-1 do
 begin
  DSP:=ptr(PageBase,a*BytesPerLine+xd4);
  move(DSP^,P^,w1);
  P:=ptr(seg(P^),ofs(P^)+w1);
 end;

nowpl:=nowpl+1;
if nowpl>3 then begin; nowpl:=0; xd4:=xd4+1; endpl:=0;  end;
end;
end;

function putchar(x,y: integer; ch: char): word;
var db: word;
    P: pointer;
    B: byte;
begin
 if HaltIsOn then TryHalt;
 if (ord(ch)<32) or (ord(ch)>240) or (FontNow=nil) then
  begin
   PutChar:=2;
   exit;
  end;
 db:=memw[seg(FontNow^):ofs(FontNow^)+7];
 db:=memw[seg(FontNow^):ofs(FontNow^)+db+2+(ord(ch)-32)*4];
 P:=ptr(seg(FontNow^),ofs(FontNow^)+db);
 b:=TrCOL;
 if ColNow shr 8=0 then TrCOL:=0 else TrCOL:=254;
 TextPutImage(x,y,P);           {(background) 255 is transparent color}
 TrCOL:=b;
 putchar:=memw[seg(P^):ofs(P^)];
end;

Procedure OutTextXY(x,y: integer; s: string);
var b: byte;
    x1: word;
begin
if CGV then exit;
x1:=x;
if s<>'' then for b:=1 to length(s) do x:=x+putchar(x,y,s[b]);
end;

function charwidth(ch: char): word;
var db: word;
    P: pointer;
    B: byte;
begin
 if HaltIsOn then TryHalt;
 if (ord(ch)<32) or (ord(ch)>240) or (FontNow=nil) then
  begin
   CharWidth:=2;
   exit;
  end;
 db:=memw[seg(FontNow^):ofs(FontNow^)+7];
 db:=memw[seg(FontNow^):ofs(FontNow^)+db+2+(ord(ch)-32)*4];
 P:=ptr(seg(FontNow^),ofs(FontNow^)+db);
 charwidth:=memw[seg(P^):ofs(P^)];
end;

function Height: word;
var db: word;
    P: pointer;
    B: byte;
begin
 if HaltIsOn then TryHalt;
 if (FontNow=nil) then
  begin
   Height:=0;
   exit;
  end;
 db:=memw[seg(FontNow^):ofs(FontNow^)+7];
 db:=memw[seg(FontNow^):ofs(FontNow^)+db+2];
 P:=ptr(seg(FontNow^),ofs(FontNow^)+db);
 Height:=memw[seg(P^):ofs(P^)+2];
end;

Function Width(s: string): word;
var b: byte;
    x1: word;
begin
 if HaltIsOn then TryHalt;
if CGV then exit;
x1:=0;
for b:=1 to length(s) do x1:=x1+charwidth(s[b]);
Width:=x1;
end;

procedure SetFont(w: word);
begin
if CGV then exit;
if w=0 then FontNow:=InitFont else if w<10 then FontNow:=LoadFonts[w];
if FontNow=nil then FontNow:=InitFont;
end;

Function OpenFile(var f: file; fn: string): boolean;
var way: string;
begin
 if HaltIsOn then TryHalt;
if fn='' then
 begin
  OpenFile:=False;
 end else
 begin
  Assign(f,fn);
  {$I-}
  Reset(f,1);
  {$I+}
  if IoResult<>0 then
   begin
    Way:=ParamStr(0);
    While (Way<>'') and (not (Way[Length(Way)] in['/','\']))
                         do delete(Way,Length(Way),1);
    Assign(f,way+fn);
    {$I-}
    Reset(f,1);
    {$I+}
   end;
  If IoResult<>0 then OpenFile:=False else OpenFile:=true;
 end;
end;

function LoadFontFile(s: string): boolean;
var f: file;
    num,tblsz,cds: word;
begin
 if HaltIsOn then TryHalt;
LoadFontFile:=false;
 if PBufOn=0 then exit;
 if (OpenFile(f,s)=false) then exit;
   BlockRead(f,PBuf^,filesize(f),num);
   if num<>FileSize(f) then
    begin
     close(f);
     exit;
    end;
   close(f);
 tblsz:=memw[seg(Pbuf^):ofs(Pbuf^)];
 cds:=memw[seg(Pbuf^):ofs(Pbuf^)+tblsz*8+2];
 LoadFontsSize[LastFont]:=cds;
 if MemAvail<cds then exit;
 GetMem(LoadFonts[LastFont],LoadFontsSize[LastFont]);
 asm
  mov es,Word Ptr PBuf[2]
  mov bx,Word Ptr PBuf
  push ds
  push bp
  mov dl,byte ptr LastFont
  xor dh,dh
  mov di,dx
  mov cl,2
  shl di,cl
  mov si,Word Ptr LoadFonts[di]
  mov ds,Word Ptr LoadFonts[di+2]
  call DeCompress
  pop bp
  pop ds
 end;
 inc(LastFont);
 LoadFontFile:=true;
end;

procedure freeAlg;
begin
if HaltIsOn then TryHalt;
if LoadPictures then
if FileMem<>0 then
 begin
  asm
   mov ah,49h
   mov es,FileMem
   int 21h
   mov FileMem,0
  end;
 End;
 Begin
  if ClearAlgList then AlgFilesLoaded:=0;
  if HSZ<>0 then FillChar(Header^,HSZ,0);
  if HSZ<>0 then FreeMem(Header,HSZ);
  LMGET:=0;
  HSZ:=0;
  Header:=nil;
  colpal:=0;
  FillChar(PalF,768,0);
  ImagesIs:=0;
  MXsize:=0;
  TurnOffAutoDecompression;
 end;
end;

function BuildTable: boolean;
var sz: word;
    err: boolean;
begin
 if not LoadPictures then exit;
 err:=false;
 if ImagesIs>0 then
 for sz:=0 to ImagesIs-1 do if err=false then
 if (Header^[sz].ps>0) and (Header^[sz].ps<16777216) then
 ImagePointer[sz]:=ptr(FileMem+Header^[sz].ps div 16,Header^[sz].ps mod 16) else
 err:=true;
 BuildTable:=not err;
end;

Procedure MyMove1(P,P1: pointer; w: word);
begin
 asm
  push ds
  push di
  push cx
  mov ds,Word Ptr P[2]
  mov si,Word Ptr P
  mov es,Word Ptr P1[2]
  mov di,Word Ptr P1
  mov cx,w
  cld
  @NextT:
  repz movsb
  jcxz @Done
  jmp @NextT
  @Done:
  pop cx
  pop di
  pop ds
 end;
end;

procedure MoveDown(o: longint; sz: word);
var mv,o1: longint;
    PFr,PTo: pointer;
    mr: word;
begin
 mv:=MemSize-o;
 PFr:=ptr(FileMem+o div 16,o mod 16);
 o1:=o-longint(sz);
 PTo:=ptr(FileMem+o1 div 16,o1 mod 16);
  repeat
   if mv>64000 then mr:=64000 else mr:=word(mv);
   MyMove1(PFr,PTo,mr);
   PFr:=Ptr(Seg(PFr^)+mr div 16,Ofs(PFr^)+mr mod 16); {Na stol'ko na skol'ko}
   PTo:=Ptr(Seg(PTo^)+mr div 16,Ofs(PTo^)+mr mod 16); {podvinuto}
   mv:=mv-mr;
  until mv=0;
end;

Procedure MyMove(P,P1: pointer; w: word);
begin
 asm
  push ds
  push di
  push cx
  mov ds,Word Ptr P[2]
  mov si,Word Ptr P
  mov es,Word Ptr P1[2]
  mov di,Word Ptr P1
  add di,w
  add si,w
  mov cx,w
  inc cx
  std
  @NextT:
  repz movsb
  jcxz @Done
  jmp @NextT
  @Done:
  pop cx
  pop di
  pop ds
 end;
end;

procedure MoveUp(o: longint; sz: word);
var mv,o1: longint;
    PFr,PTo: pointer;
    mr: word;
begin
 if ImagesIs=0 then exit;
 mv:=MemSize-o-longint(sz); {MemSize - uvelichennyi razmer}
 if mv>64000 then mr:=64000 else mr:=mv;
 o1:=MemSize-longint(mr)-longint(sz);
 o:=o1+longint(sz);
 PFr:=ptr(FileMem+o1 div 16,o1 mod 16);
 PTo:=ptr(FileMem+o div 16,o mod 16);
  repeat
   MyMove(PFr,Pto,mr);
   mv:=mv-mr;          {Na stol'ko na skol'ko nado budet dvigat'!}
   if mv>64000 then mr:=64000 else mr:=mv;
   PFr:=Ptr(Seg(PFr^)-mr div 16-1,Ofs(PFr^)+(16-mr mod 16));
   PTo:=Ptr(Seg(PTo^)-mr div 16-1,Ofs(PTo^)+(16-mr mod 16));
  until mv=0;
end;

Function MemorySize: longint;
var w: word;
begin
 asm
  mov ah,48h
  mov bx,65535
  int 21h
  mov w,bx
 end;
MemorySize:=longint(w)*16;
end;

function ChangeMemory(sz: word): boolean;
var b: byte;
begin
if not LoadPictures then exit;
if MemorySize+longint(LMGET)*16<longint(sz)*16 then
 begin
  ChangeMemory:=false;
  exit;
 end;
LMGET:=sz;
    asm
     mov ax,FileMem
     mov es,ax
     mov ah,04ah
     mov bx,sz
     int 21h
     xor cl,cl
     jnb @OkDone
     mov cl,255
     @OkDone:
     mov b,cl
    end;
if b=0 then ChangeMemory:=true else ChangeMemory:=false;
end;

function ExtractImage(w: word): boolean;
var IPnt: pointer;
    szm,sz: word;
    w1,mb: word;
    SzWas: longint;
    cds,Tblsz: word;
begin
if not LoadPictures then exit;
ExtractImage:=false;
if w>=ImagesIs then exit;
 if (not (Header^[w].ImageType in[0,2])) then
  begin
   ExtractImage:=true;
   exit;
  end;
 if PBufOn=0 then exit;
  IPnt:=ImagePointer[w];
  if longint(seg(IPnt^))*16+longint(ofs(IPnt^))<>Header^[w].ps+longint(FileMem)*16 then exit;
      tblsz:=MemW[FileMem+Header^[w].ps div 16:Header^[w].ps mod 16+4] and 32767;
      cds:=MemW[FileMem+Header^[w].ps div 16:Header^[w].ps mod 16+6+tblsz*8]+12;
      if cds>CURPB then exit;
      szwas:=tblsz*8+Header^[w].size+8;
  asm
    push bp
    push ds
     push word ptr IPnt[2]
     pop es
     push word ptr IPnt
     pop bx
     push word ptr PBuf
     pop si
     push word ptr PBuf[2]
     pop ds
     push word ptr es:[bx]
     pop word ptr ds:[si]
     push word ptr es:[bx+2]
     pop word ptr ds:[si+2]
     add bx,4
     add si,4
      Call DeCompress {ES:BX -> DS:SI}
    pop ds
    pop bp
  end;
 sz:=Memw[seg(PBuf^):ofs(PBuf^)]*Memw[seg(PBuf^):ofs(PBuf^)+2]+12;
 if ((Memw[seg(PBuf^):ofs(PBuf^)]>1000) or (Memw[seg(PBuf^):ofs(PBuf^)+2]>1000)) then exit;

   if SzWas>Sz then if (w+1<ImagesIs) then MoveDown(Header^[w+1].ps,SzWas-sz);

   MemSize:=MemSize+(longint(Sz)-Longint(SzWas));
   mb:=MemSize div 16+1;
   if Not ChangeMemory(mb) then exit;
    szm:=sz;
    Header^[w].size:=szm;

   if Sz>SzWas then if (w+1<ImagesIs) then MoveUp(Header^[w+1].ps,sz-SzWas);

   Move(PBuf^,IPnt^,sz);
    If ImagesIs>w+1 then for w1:=w+1 to ImagesIs-1 do
      Header^[w1].ps:=Header^[w1].ps+longint(Sz)-longint(SzWas);
    if not BuildTable then ExtractImage:=false;

 Inc(Header^[w].ImageType);
 ExtractImage:=true;
end;

function LoadAlgPalette(fn: string): byte;
var f: file;
    b,b1,err: byte;
    l: longint;
    ch: char;
    s: string;
    as,num: word;
    IIs: word;
    CFr,CL,z,z1: byte;
    palf1: array[0..255,0..2] of byte;
    ir: integer;
begin
 err:=0;
 if HaltIsOn then TryHalt;
 LoadAlgPalette:=9;
 if CGV then exit;
 if pos('.',fn)=0 then fn:=fn+'.ALG';
 If not OpenFile(f,fn) then
  begin
   LoadAlgPalette:=1;
   exit;
  end;
 BlockRead(f,l,4,num);
 if FileSize(f)<l then
  begin
   {$I-}
   close(f);
   {$I+}
   ir:=IoResult;
   LoadAlgPalette:=2;
   exit;
  end;
 BlockRead(f,b,1,num);
 s[0]:=chr(b-5);
 BlockRead(f,s[1],b-5,num);
 as:=0;
 if length(s)>2 then for num:=1 to length(s)-2 do as:=as+ord(s[num]);
 if (as div 256<>ord(s[length(s)-1])) or (as mod 256<>ord(s[length(s)]))
                                     then err:=8 else
 begin
  {$I-}
  seek(f,l);
  {$I+}
  if ioresult<>0 then err:=2 else
   begin
    if num<>0 then BlockRead(f,IIs,2,num);
    {$I-}
    seek(f,longint(2+l+longint(IIs)*sizeof(ImageHeader)));
    {$I+}
    if ioresult<>0 then err:=2 else
     begin
      b1:=0;
      b:=0;
      if ColPal<>0 then CFr:=ColPal div 256 else CFr:=255;
      if ColPal<>0 then CL:=ColPal mod 256 else CL:=0;
      blockread(f,b,1,num);
      blockread(f,b1,1,num);
      if byte(b1)>byte(b) then err:=13 else
       begin
        z:=byte(b1);
        z1:=byte(b);
        if CFr<byte(b1) then b1:=word(CFr);
        if b<CL then b:=CL;
        colpal:=byte(b1)*256+byte(b);
       end;

      if num<>1 then err:=7 else
       begin
        BlockRead(f,palf1,768,num);
        if (num=768) and (err=0) then for b:=z to z1 do
         begin
          palf[b,0]:=palf1[b,0];
          palf[b,1]:=palf1[b,1];
          palf[b,2]:=palf1[b,2];
         end;
        if num<>768 then err:=7;
       end;
     end;
   end;
 end;
{$I-}
Close(f);
{$I+}
ir:=IoResult;
LoadAlgPalette:=err;
end;

function LoadAlgFile(fn: string): byte;
var f: file;
    RealSize,OldSize,FullNum,l: longint;
    HSZold,IIs,IWas,tblsz,cds,w,w1,sz,num,MAvail: word;
    p: pointer;
    z,z1,CFr,CL,err,b: byte;
    s: string;
    b1: word;
    as: word;
    ll,t1,t: longint;
    extr: boolean;
    PP,OldP: pointer;
    palf1: array[0..255,0..2] of byte;
    w2: word;
    ir: integer;
    EXTIMG: boolean;
begin
 if HaltIsOn then TryHalt;
err:=0;
if CGV then
 begin
  mxsize:=0;
  LoadAlgFile:=9;
  exit;
 end;
LoadAlgFile:=0;
t:=0;
if pos('.',fn)=0 then fn:=fn+'.ALG';
 If not OpenFile(f,fn) then
  begin
   LoadAlgFile:=1;
   exit;
  end;

 FullNum:=0;
 BlockRead(f,l,4,num); t:=t+num;
 if FileSize(f)<l then
  begin
   {$I-}
   close(f);
   {$I+}
   ir:=IoResult;
   LoadAlgFile:=2;
   exit;
  end;
 BlockRead(f,b,1,num); t:=t+num;
 s[0]:=chr(b-5);
 BlockRead(f,s[1],b-5,num); t:=t+num;
 as:=0;
 if length(s)>2 then for num:=1 to length(s)-2 do as:=as+ord(s[num]);
 if (as div 256<>ord(s[length(s)-1])) or (as mod 256<>ord(s[length(s)]))
                                     then err:=8 else
 begin
  {$I-}
  seek(f,0);
  {$I+}
  if ioresult<>0 then err:=2;
  FullNum:=FullNum+Num;
  if FileMem=0 then
   begin
    MemSize:=l;
    sz:=l div 16+1;
    P:=nil;
    if LoadPictures then
     asm
      mov ah,48h
      mov bx,sz
      int 21h
      jc @NoMemory
      mov word ptr P[2],ax
      @NoMemory:
      mov MAvail,bx
     end;
    if LoadPictures then
    FileMem:=seg(P^);
    if FileMem<>0 then LMGET:=sz;
   end else
   begin
    OldSize:=MemSize;
    MemSize:=MemSize+l;
    sz:=MemSize div 16+1;
    if LoadPictures then
    if not ChangeMemory(sz) then p:=nil else p:=ptr(FileMem+OldSize div 16,
                                                    OldSize mod 16);
   end;
  RealSize:=l;

  if REload=false then
   Begin
     AlgFileName[AlgFilesLoaded]:=fn;
     if AlgFilesLoaded<20 then Inc(AlgFilesLoaded);
   End;

  if ((p=nil) and LoadPictures) then err:=3 else
  begin
   num:=1;
   while (num<>0) and (l>0) do
    begin
     if l>65520 then sz:=65520 else sz:=l;
     if LoadPictures then
      Begin
       blockread(f,P^,sz,num); t:=t+num;
      End else
      Begin
       t:=t+sz;
       Seek(f,FilePos(f)+sz);
      End;
     if LoadPictures then FullNum:=FullNum+num else FullNum:=FullNum+sz;
     if LoadPictures then
     P:=ptr(seg(P^)+4095,ofs(P^));
     if LoadPictures then l:=l-num else l:=l-sz;
     if LoadPictures then if l=0 then num:=0;
    end;
  if FilePos(f)<>RealSize then err:=4;
  BlockRead(f,IIs,2,num); t:=t+num;
  IWas:=ImagesIs;
  ImagesIs:=ImagesIs+IIs;

  if (HeaderIs=false) and (MaxAvail>=ImagesIs*SizeOf(ImageHeader)) then
   begin
    HSZ:=ImagesIs*SizeOf(ImageHeader);
    getmem(Header,HSZ);
    HeaderIs:=true;
   end else if HeaderIs then
   begin
    if MaxAvail<ImagesIs*SizeOf(ImageHeader) then err:=11 else
     begin
      HSZold:=HSZ;
      HSZ:=ImagesIs*SizeOf(ImageHeader);
      GetMem(PP,HSZ);
      OLDP:=Header;
      Header:=PP;
      move(OLDP^,Header^,HSZold);
      FreeMem(OLDP,HSZold);
     end;
   end else err:=11;

  FullNum:=FullNum+Num;
  if (num<>0) and (ImagesIs<=Images) and (err=0) then
    BlockRead(f,Header^[IWas],IIs*SizeOf(ImageHeader),num); t:=t+num;


    if LoadPictures then
    if IWas>0 then if ImagesIs>IWas then for w2:=IWas to ImagesIs-1 do
    Header^[w2].ps:=Header^[w2].ps+OldSize;

    if not LoadPictures then
    if ImagesIs>0 then
    for w2:=0 to ImagesIs-1 do Header^[w2].ps:=0;

  FullNum:=FullNum+Num;
  if err=0 then if (num<>IIs*SizeOf(ImageHeader)) then err:=5 else
  if err=0 then
   begin
    if (ImagesIs>Images) or (ImagesIs=0) or (IWas>=ImagesIs) then
     err:=6 else
     begin
      if LoadPictures then
      if err=0 then if not BuildTable then err:=12;
      extr:=true;
     if LoadPictures then MXSize:=0;
     if LoadPictures then
      for w1:=IWas to ImagesIs-1 do
       begin {decompress for cycle}
        if Header^[w1].ImageType in[0,2] then
         begin
          tblsz:=MemW[FileMem+Header^[w1].ps div 16:Header^[w1].ps mod 16+4] and 32767;
          cds:=MemW[FileMem+Header^[w1].ps div 16:Header^[w1].ps mod 16+6+tblsz*8]+12;
         end;

        EXTIMG:=false;

        if extr and (err=0) then
        if Header^[w1].PictureType and 128=128 then
        if Header^[w1].PictureType and 64=64 then
        if ADBU then
         Begin
          if cds>CurPB then
           Begin
             TurnOffAutoDecompression;
             SetBufferSize(cds);
             if Not TurnOnAutoDecompression then err:=3;
           End;
          if not ExtractImage(w1) then
           begin
            ll:=MemorySize;
            bin:=Header^[w1].name;
            err:=10;
            EXTR:=false;
           end;
          EXTIMG:=true;
         End;
         if (EXTIMG=false) and (cds>MXSize) and
         (Header^[w1].ImageType in[0,2]) then MXSize:=Cds;
       end; {Decompress cycle}


      b1:=0;
      b:=0;
      if ColPal<>0 then CFr:=ColPal div 256 else CFr:=255;
      if ColPal<>0 then CL:=ColPal mod 256 else CL:=0;
      blockread(f,b,1,num); t:=t+num;
      blockread(f,b1,1,num); t:=t+num;
      if byte(b1)>byte(b) then err:=13 else
       begin
        z:=byte(b1);
        z1:=byte(b);
        if CFr<byte(b1) then b1:=word(CFr);
        if b<CL then b:=CL;
        colpal:=byte(b1)*256+byte(b);
       end;

      if num<>1 then err:=7 else
       begin
        BlockRead(f,palf1,768,num); t:=t+num;
        if (num=768) and (err=0) then for b:=z to z1 do
         begin
          palf[b,0]:=palf1[b,0];
          palf[b,1]:=palf1[b,1];
          palf[b,2]:=palf1[b,2];
         end;
        if num<>768 then err:=7;
       end;
      BlockRead(f,b1,1,num); t:=t+num;
      BlockRead(f,b1,2,num); t:=t+num;
      BlockRead(f,b1,1,num); t:=t+num;
      BlockRead(f,b1,1,num); t:=t+num;
      BlockRead(f,b1,2,num); t:=t+num;
      BlockRead(f,b1,1,num); t:=t+num;
      BlockRead(f,b1,1,num); t:=t+num;
      BlockRead(f,b1,1,num); t:=t+num;
      BlockRead(f,t1,4,num);
      BlockRead(f,b1,1,num);
     end;
   end;
  end;
 end;
{$I-}
Close(f);
{$I+}
ir:=IoResult;

if (err=0) and (ImagesIs>0) and (IWas<ImagesIs) then
for w:=IWas to ImagesIs-1 do if Header^[w].pixels>2 then
 begin
  if Header^[w].pixels=26 then
   Begin
    err:=16;
   End else
   Begin
    Header^[w].border[Header^[w].pixels].x:=Header^[w].border[0].x;
    Header^[w].border[Header^[w].pixels].y:=Header^[w].border[0].y;
    inc(Header^[w].pixels);
   End;
 end;
if err<>0 then
 Begin
  ClearAlgList:=false;
  FreeALG;
  ClearAlgList:=true;
 End;
  TurnOffAutoDecompression;
  SetBufferSize(MXsize);
  if Not TurnOnAutoDecompression then err:=3;
LoadAlgFile:=err;
end;

Function ReloadAlgFiles: byte;
var w: word;
    b: byte;
    l: longint;
Begin
 ClearAlgList:=false;
 FreeAlg;
 l:=MemorySize;
 ClearAlgList:=true;
 if AlgFilesLoaded>0 then
  begin
   ADBU:=false;
   b:=0;
   REload:=true;
   for w:=0 to AlgFilesLoaded-1 do if b=0 then b:=LoadAlgFile(AlgFileName[w]);
   REload:=false;
   ADBU:=true;
  end;
 ReloadAlgFiles:=b;
End;

Function LoadAlgError(b: byte): string;
begin
 case b of
  0: LoadAlgError:='ALG file successfuly loaded. No errors.';
  1: LoadAlgError:='Cannot open ALG file. ';
  2: LoadAlgError:='Seek error in ALG file. ';
  3: LoadAlgError:='Not enough memory for this ALG file. ';
  4: LoadAlgError:='Wrong offset in ALG file. ';
  5: LoadAlgError:='Cannot read ALG file. ';
  6: LoadAlgError:='To many images or there is no images in this ALG file. ';
  7: LoadAlgError:='Cannot read palette from ALG file. ';
  8: LoadAlgError:='Wrong ALG file header';
  9: LoadAlgError:='Graphic program module not found.';
  10: LoadAlgError:='Cannot extract one of the images in ALG file.';
  11: LoadAlgError:='Not enough memory in HEAP to load this ALG file.';
  12: LoadAlgError:='Cannot load ALG file. Memory corrupted.';
  13: LoadAlgError:='Wrong palette size in this ALG file.';
  14: LoadAlgError:='Cannot find XMS (HIMEM) driver.';
  15: LoadAlgError:='Cannot allocate memory block in XMS';
  16: LoadAlgError:='To big border of image in ALG file';
  17..255: LoadAlgError:='Unknown.';
 end;
end;

Procedure SetColor(b: byte);
begin
 if HaltIsOn then TryHalt;
 ColNow:=ColNow and 65280;
 ColNow:=ColNow or b;
end;

Procedure SetCycleColor(b: boolean);
Begin
 if b then Cycle:=255 else Cycle:=0;
End;

Procedure SetBGColor(b: byte);
begin
 if HaltIsOn then TryHalt;
 ColNow:=ColNow and 255;
 ColNow:=ColNow or (b shl 8);
end;

Function Image(W: word): pointer;
begin
 if HaltIsOn then TryHalt;
 if w<ImagesIs then Image:=ImagePointer[w] else Image:=nil;
end;

Function ImageName(W: word): string;
begin
 if w<ImagesIs then ImageName:=Header^[w].name else ImageName:='UNKNOWN';
end;

Function ImageWidth(W: word): word;
var w1,md: word;
begin
 if not LoadPictures then
  Begin
   md:=0;
   if Header^[w].pixels>0 then
   for w1:=0 to Header^[w].pixels-1 do
   if Header^[w].border[w1].x>md then md:=Header^[w].border[w1].x;
   ImageWidth:=md;
  End else
  Begin
   if w<ImagesIs then ImageWidth:=memw[seg(ImagePointer[w]^):
   ofs(ImagePointer[w]^)] else ImageWidth:=0;
  End;
end;

Function ImageHeight(W: word): word;
var w1,md: word;
begin
 if not LoadPictures then
  Begin
   md:=0;
   if Header^[w].pixels>0 then
   for w1:=0 to Header^[w].pixels-1 do
   if Header^[w].border[w1].y>md then md:=Header^[w].border[w1].y;
   ImageHeight:=md;
  End else
  Begin
   if w<ImagesIs then ImageHeight:=memw[seg(ImagePointer[w]^):
   ofs(ImagePointer[w]^)+2] else ImageHeight:=0;
  End;
end;

Procedure BIOS1SetPalette(ColF,ColT: byte; var pal);
begin
 if HaltIsOn then TryHalt;
 MemW[sseg:sptr-14]:=word(ColF);
 MemW[sseg:sptr-12]:=word(ColT);
 MemW[sseg:sptr-10]:=seg(pal);
 MemW[sseg:sptr-8]:=ofs(pal)+ColF*3;
 INLine($B4/$10/$B0/$12/$83/$EC/$10/$5B/$59/$07/$5A/$83/$C4/$08/$CD/$10);
end;

{clean one page of video memory}
{<393271}procedure CVMpage(w: byte; clr: byte);
{Not more than 0.024 second on 386 SX 16 (look CVMP}
{320x200 (one page in mode 320x200) should take 0.006 second on 386 SX 16}
var ba: word;
begin
 if HaltIsOn then TryHalt;
if CGV then exit;
asm
{2}      mov bl,0fh           {turn on write pixels to all 4 color planes}
{40}     call SetWPlaneasm;   {}
end;
if (w>=0) and (w<4) then
 begin
  if w=0 then ba:=$A000;
  if w=1 then ba:=$A000+(pagesize div 16);   { offset = ( $A000 + n ) * 16 }
  if w=2 then ba:=$A000+(pagesize div 16)*2; { offset = ( $A000 + n ) * 16 }
  if w=3 then ba:=$A000+(pagesize div 16)*3; { offset = ( $A000 + n ) * 16 }

   asm
     mov ax,ba            {start address}
     mov es,ax            {move ax to segment register}
     xor di,di            {set di to zero}
     mov al,clr           {set ax to zero}
     mov ah,clr
     mov cx,pagesize      {set cx to clean length}
     shr cx,1
     cld                  {cleaning}
@again:
{393210} rep stosw        {cleaning}
{5}      jcxz @next
         jmp @again
@next:
   end;
 end;
end;

Procedure SetAlgPalette;
begin
 if HaltIsOn then TryHalt;
 Bios1SETPalette(ColPal div 256,ColPal mod 256-ColPal div 256+1,Palf);
end;

Procedure SetVideoMode(b: byte);
begin
 if HaltIsOn then TryHalt;
 asm
  mov ah,0
  mov al,b
  int 10h
 end;
 if b=3 then GMode:=255;
 if b=3 then GraphMode:=false;
end;

procedure ChVar(var a,b: longint);
var c: longint;
begin
 c:=a;
 a:=b;
 b:=c;
end;

function mul(a,b: longint): longint;
Begin
 if ((a=0) or (b=0)) then mul:=0 else mul:=a*b;
End;

function LinesCross(x1,y1,x2,y2,x3,y3,x4,y4: longint; var x0,y0: integer): boolean;
var a,b,c,d,d_: longint;
    a_,b_,c_: longint;
    x,y: longint;
begin
 if HaltIsOn then TryHalt;
 if Vershina then exit;
 a:=y2-y1; a_:=y4-y3;
 b:=x2-x1; b_:=x4-x3;
 c:=mul(y1,b)-mul(x1,a);  c_:=mul(y3,b_)-mul(x3,a_);
 d:=(mul(a,b_)-mul(a_,b));
 d_:=(mul(a,b_)-mul(a_,b));
 if d<>0 then x:=(-mul(c,b_)+mul(c_,b)) div d else x:=0;
 if d_<>0 then y:=-(-mul(a,c_)+mul(a_,c)) div d_ else y:=0;
 if ((x=x3) and (y=y3)) or ((x=x4) and (y=y4)) then
  Begin
   LinesCross:=false;
   Vershina:=true;
   Exit;
  End;

 if mul(a,b_)-mul(a_,b)<>0 then
  begin
   if x1>x2 then ChVar(x1,x2);
   if x3>x4 then ChVar(x3,x4);
   if y1>y2 then ChVar(y1,y2);
   if y3>y4 then ChVar(y3,y4);
   if (x>=x1) and
      (x<=x2) and
      (x>=x3) and
      (x<=x4) and
      (y>=y1) and
      (y<=y2) and
      (y>=y3) and
      (y<=y4) then
      begin
       LinesCross:=true;
       x0:=x {shr 5};
       y0:=y {shr 5};
      end else LinesCross:=false;
  end else LinesCross:=false;
end;

Function PutToBuffer(P: pointer; w: word): boolean;
begin
 if (PBufOn<>255) or (w>CurPb) then PutToBuffer:=false else
  begin
   if (P<>nil) and (w<>0) then move(P^,PBuf^,w);
   PutToBuffer:=true;
  end;
end;

Function GetFromBuffer(P: pointer; w: word): boolean;
begin
 if (PBufOn<>255) or (w>CurPb) then GetFromBuffer:=false else
  begin
   if (P<>nil) and (w<>0) then move(PBuf^,P^,w);
   GetFromBuffer:=true;
  end;
end;

Function ImageBorder(num: word): boolean;
begin
 if (Header^[num].Pixels<=2) then ImageBorder:=false else ImageBorder:=true;
end;

{Line
 Object coordinate
 Object number}
function ImageCross(x,y,x1,y1,x2,y2: longint; num: word): word;
var crs,w1: word;
    x0,y0: integer;
    xl,yl,xm,ym: longint;
begin
ImageCross:=0;
if x1<x then xl:=x1 else xl:=x;
if y1<y then yl:=y1 else yl:=y;
if x1>x then xm:=x1 else xm:=x;
if y1>y then ym:=y1 else ym:=y;
{if x1<x then chvar(x,x1);
if y1<y then chvar(y,y1);}
if (x2>xm) or (y2>ym) then exit;
if (x2<xl-ImageWidth(num)) or (y2<yl-ImageHeight(num)) then exit;
BadVershina:=0;
 repeat
  Vershina:=false;
  crs:=0;
  if Header^[num].Pixels>2 then
                for w1:=0 to Header^[num].Pixels-2 do
                crs:=crs+byte(LinesCross(longint(x),longint(y),
                                         longint(x1),longint(y1),
                longint(x2+Header^[num].border[w1].x),
                longint(y2+Header^[num].border[w1].y),
                longint(x2+Header^[num].border[w1+1].x),
                longint(y2+Header^[num].border[w1+1].y),x0,y0));
  if Vershina then
   begin
    if (x1>0) and (y1>=0) then
     begin
      y1:=y1+2;
      x1:=x1-2;
     end else
    if (x1<=0) and (y1>=0) then
     begin
      x1:=x1-2;
      y1:=y1-2;
     end else
    if (x1<=0) and (y1<=0) then
     begin
      x1:=x1+2;
      y1:=y1-2;
     end else
    if (x1>=0) and (y1<=0) then
     begin
      x1:=x1+2;
      y1:=y1+2;
      inc(BadVershina);
     end;
   end;
 until (BadVershina>=8) or (Vershina=false);
if BadVershina>=8 then crs:=0;
ImageCross:=crs;
end;

{Object 1 number
 Object 2 number
 Object 1 coordinate
 Object 2 coordinate}
function ObjectCross(num,num1: word; x1,y1,x2,y2: longint): boolean;
var w1: word;
    fnd: boolean;
begin
ObjectCross:=false;
if (x1 div 320<>x2 div 320) or (y1 div 200<>y1 div 200) then
 begin
  exit;
 end;
fnd:=false;
if (num<ImagesIs) and (num1<ImagesIs) then
 begin
   if Header^[num].Pixels>2 then
    for w1:=0 to Header^[num].Pixels-3 do if fnd=false then
     if ImageCross(x1+Header^[num].border[w1].x,
                   y1+Header^[num].border[w1].y,
                   x1+Header^[num].border[w1+1].x,
                   y1+Header^[num].border[w1+1].y,
                   x2,y2,num1)<>0 then fnd:=true;
 end;
ObjectCross:=fnd;
end;

Function GraphOn: boolean;
begin
 GraphOn:=GraphMode;
end;

Function APageNum: byte;
begin
 APageNum:=APage;
end;

Function VPageNum: byte;
begin
 VPageNum:=VPage;
end;

Function TransparentColor: byte;
begin
 TransparentColor:=TrCol;
end;

Procedure SetTransparentColor(b: byte);
begin
 TrCol:=b;
end;

Function GetColor: word;
begin
 GetColor:=ColNow;
end;

Procedure LoadColor(w: word);
begin
 ColNow:=w;
end;

Function GetMaxX: word;
begin
 GetMaxX:=xh;
end;

Function GetMaxY: word;
begin
 GetMaxY:=yh;
end;

procedure Line(x1,y1,x2,y2: integer);
var dx,dy,sx,sy,d,d1,d2,x,y,i: integer;
begin
 if HaltIsOn then TryHalt;
 dx:=abs(x2 - x1);
 dy:=abs(y2 - y1);
 if (dx=0) and (dy=0) then
  begin
   putpixel(x1,y1);
   exit;
  end;
 if x2>=x1 then sx:=1 else sx:=-1;
 if y2>=y1 then sy:=1 else sy:=-1;

 if dy<=dx then
  begin
   d:=(dy shl 1) - dx;
   d1:=dy shl 1;
   d2:=(dy-dx) shl 1;
   putpixel(x1,y1);
   x:=x1+sx;
   y:=y1;
   i:=1;
   repeat
    if d>0 then
     begin
      d:=d+d2;
      y:=y+sy;
     end else d:=d+d1;
     putpixel(x,y);
    i:=i+1;
    x:=x+sx;
   until i>dx;
  end else
  begin
   d:=(dx shl 1) - dy;
   d1:=dx shl 1;
   d2:=(dx-dy) shl 1;
   putpixel(x1,y1);
    x:=x1;
    y:=y1+sy;
    i:=1;
    repeat
     if d>0 then
      begin
       d:=d+d2;
       x:=x+sx;
      end else d:=d+d1;
     putpixel(x,y);
     i:=i+1;
     y:=y+sy;
    until i>dy;
  end;
end;

procedure OutBorder(x,y: integer; num: word);
var w: word;
begin
   case ((Header^[num].PictureType) and 15) of
    1: SetColor(7);  { STANDART    }
    2: SetColor(9);  { NOT MOVABLE }
    3: SetColor(13); { MOVABLE     }
    4: SetColor(7);  { BACKGROUND  }
    5: SetColor(12); { HERO        }
   end;
 if (x>XH) or (y>YH) or
    (x+ImageWidth(num)<0) or (y+ImageHeight(num)<0) then exit;
 if HaltIsOn then TryHalt;
    if Header^[num].Pixels>2 then
    for w:=0 to Header^[num].Pixels-2 do
       Line(x+Header^[num].Border[w].x,
            y+Header^[num].Border[w].y,
            x+Header^[num].Border[w+1].x,
            y+Header^[num].Border[w+1].y);
end;

procedure RightDownCorner(x,y: integer);
begin
 if HaltIsOn then TryHalt;
 xh:=x;
 yh:=y;
 MaxY:=y;
end;

Function GetGraphMode: byte;
begin
 GetGraphMode:=GMode;
end;

Function BadVGA: boolean;
begin
 BadVGA:=CGV;
end;

Function ImageNum: word;
begin
 ImageNum:=ImagesIs;
end;

Function BasePage: word;
begin
 BasePage:=PageBase;
end;

Procedure SavePalette(var p);
Begin
 asm
  mov ah,10h
  mov al,17h
  mov bx,0
  mov cx,256
  mov es,word ptr p[2]
  mov dx,word ptr P
  int 10h
 end;
End;

{$F-,S+}

Begin
ErrorString:='ERROR: unknown error.';
HaltIsOn:=false;
LoadPictures:=true;
LastFont:=0;
CGV:=false;
if MaxAvail<30000 then
 begin
  WriteLn('Not enough memory to load graphic.');
  CGV:=true;
  exit;
 end;
pbufon:=0;
getmem(InitFont,25000);
FontNow:=InitFont;
FntIs:=true;
getmem(PalZero,768);
pz:=true;
FillChar(PalZero^,768,0);
 asm
  jmp @NOFP
  call FontPointer
  @NOFP:
  mov ax,SEG(FontPointer)
  mov es,ax
  mov bx,OFFSET(FontPointer)
  add bx,3
  mov ax,WORD PTR InitFont[2]
  push dx
  push ds
  mov si,WORD PTR InitFont
  mov ds,ax
  push bp
  cmp byte ptr es:[bx],239
  je @FNDOK
  add bx,7
  cmp byte ptr es:[bx],239
  jne @BadCode
  @FNDOK:
  call DeCompress
  mov bl,0
  jmp @OkIs
  @BadCode:
  mov bl,1
  @OkIs:
  pop bp
  pop ds
  pop dx
  mov err,bl
 end;
if err=1 then
 begin
  WriteLn('Wrong program code. Cannot initializate graphic font.');
  CloseGoodVga;
  CGV:=true;
  exit;
 end;
End.