unit graph16;

INTERFACE

function getpixel16(x,y: word): byte;
procedure putpixel16(x,y: word; col: byte);
procedure OutTextXY16(x,y: word; s: string; col,col1: byte);
procedure SetWPlane16(planes: byte);
procedure setput16(kindput: byte);

IMPLEMENTATION

function getpixel16(x,y: word): byte;
const dd: array[0..3] of byte=(1,2,4,8);
var col,pl: byte;
begin
col:=0;
for pl:=3 downto 0 do
 begin
  port[$3CE]:=4;
  port[$3CE+1]:=pl;
  if mem[$A000:y*80+(x shr 3)] and $80 shr (x and 7)=$80 shr (x and 7) then col:=col+dd[pl];
 end;
getpixel16:=col;
end;

procedure putpixel16(x,y: word; col: byte);
begin
getpixel16(x,y);
port[$3CE]:=1;
port[$3CE+1]:=$0F;
port[$3CE]:=0;
port[$3CE+1]:=col;
port[$3CE]:=8;
port[$3CE+1]:=$80 shr (x and 7);
mem[$A000:y*80+(x shr 3)]:=1;
port[$3CE]:=1;
port[$3CE+1]:=$0;
port[$3CE]:=8;
port[$3CE+1]:=$FF;
end;

procedure OutTextXY16(x,y: word; s: string; col,col1: byte);
var b,b1,b2,ns: byte;
    s1: string;
begin
 for b:=1 to length(s) do
  begin
   ns:=ord(s[b]);
   if not ((ns>=65) and (ns<=90)) then
       case ns of
         33: ns:=28+65;
         46: ns:=27+65;
         45: ns:=30+65;
         64: ns:=29+65;
         48..57: ns:=ns-17+65;
         0..255: ns:=91;
       end;

   ns:=ns-65;
    for b1:=0 to 7 do
    begin
     s1:=shrift[b1+ns*8]+' ';
      for b2:=1 to 9 do
       begin
        if s1[b2]='/' then put_pixel(x+b2,y+b1,col) else put_pixel(x+b2,y+b1,col1);
       end;
    end;
      x:=x+9;
  end;
end;


procedure SetWPlane16(planes: byte); assembler;
asm
                    {turn on writing pixels to n color planes,}
 mov dx,3c4h        {writing planes to register: permision of writing plane}
 mov al,2
 out dx,al

 inc dx
 mov al,planes
 out dx,al
end;

procedure setput16(kindput: byte); assembler;
asm
 mov dx,3ceh
 mov al,3
 out dx,al
 mov al,kindput
 inc dx
 out dx,al
end;


end.