unit menus;

INTERFACE

Const
 ChrEverything=1;
 ChrNumbers=2;
 ChrLetters=3;
 ChrMoney=4;

{ *** STANDART OUTPUT PROCEDURES FOR TEXT MODE *** }

Procedure MGotoXy(x,y: integer);
{Set cursor position to x,y}
Procedure MWrite(s: string);
{The same as write}
Procedure MWriteLn(s: string);
{The same as WriteLn}
Procedure MColor(col: byte);
{This set current color}
Procedure MBGColor(col: byte);
{This set current background color}
Procedure MScrBgColor(col: byte);
{This set all screen background color}
Procedure MClrScr;
{This clean the screen}
Function MReadKey: char;
{This is the same as ReadKey}
Function MKeyPressed: boolean;
{This is the same as KeyPressed}
Procedure MSaveScreen;
{This procedure save text screen and cursor position}
Procedure MLoadScreen;
{This procedure load text screen and cursor position}

{ *** SPECIAL OBJECTS PROCEDURES FOR BUTTONS, INPUT TEXT AND OTHER *** }

{     The idea is this one:
          a) You add some objects to memory (buttons, input areas, other).
          b) You call the GetInfo procedure (it automaticle read all the
             information and out help until the user press "OK" button)
                 You must initialize "OK" button with AddStopButton proc.
          c) All the information is ready for you. You may read any
             entered fields with ReadInfo function}

type
      StandartType=record
                     NextOne: pointer;
                     PrevOne: pointer;
                     TP: byte;
                     x,y: integer;
                     col: byte;
                     BGcol: byte;
                     Txt: ^string;
                   end;

      GeneralButton=record {Type=1}
                     std: StandartType;
                     even: byte;
                    end;

      RadioButton=record {Type=1}
                   std: StandartType;
                  end;

      RadioButtonsList=record
                        NextOne: pointer;
                        PrevOne: pointer;
                        TP: byte; {Type=2}
                        Ind: ^string;
                        FirstButton: ^RadioButton;
                        InfoBlock: ^byte;
                        LastBut: pointer;
                        LastNum: byte;
                       end;

      EnterField=record {Type=3}
                  std: StandartType;
                  Ind: ^String;
                  TypeInput: byte; {1,2,3,4}
                  Lng: byte;
                  InfoBlock: ^string;
                 end;

      DateRecord=record
                  year,month,day: word;
                 end;

      EnterDateField=record {Type=4}
                      std: StandartType;
                      Ind: ^String;
                      Day: ^EnterField;
                      Month: ^EnterField;
                      Year: ^EnterField;
                     End;

Procedure ClearObjects;
{This procedure clear all objects from memory}
Procedure AddStopButton(x,y: integer; s: string; col,bgcol,even: byte);
{ This procedure is for "Cancel", "OK" and other general buttons.
  It must be at least one button like this one. The even is the
  number that return GetInfo procedure}
Procedure AddRadioButtonsList(ind: string);
{ This procedure create the radio buttons list. The Ind is the unique
  name of this list}
Procedure AddRadioButton(x,y: integer; s: string; col,bgcol: byte);
{ This add one radio button to the last created list }
Procedure AddReadField(ind: string; x,y: integer;
                       s: string; col,bgcol,lng,tp: byte);
{ This add input area.
   IND - this is the unique indentifier of this field
   LNG - this is maximum length for input text
   TP=1 - this is input for evething (letters, numbers, special characters)
   TP=2 - this is only for numbers
   TP=3 - this is only for letters and special characters
   TP=4 - money input field (number like xx.xxx) }
Procedure AddDateInputField(ind: string; x,y: integer;
                            s: string; col,bgcol: byte);
{ This is date input field.
   IND - this is the unique indentifier of this field}

Procedure AddCallProc(P: pointer);
{This procedure add the procedure that would be called every time
 the screen redraw (when user press the key). Use it to change
 values in time of menu work}

Function GetInfo: byte;
{ This is general procedure to read everything from created in memory
menu }

Procedure GetInfoPointer(var P: pointer; var size: word);
{ This procedure return information block size and set
  pointer P to the begining of the information block.
  Example (you may save information from menu to file with next code):
     GetInfoPointer(P,sz);
     BlockWrite(F,P^,sz);

     Call GetInfo procedure before this proceudure.
       [ This procedure do not copy anything to pointer P! This
         procedure set the pointer P to information block. ] }

Procedure SetInfoPointer(P: pointer);
{ This procedure sets the information block. Call it one step before
  GetInfo procedure. Be sure that pointer P show to correct block
  created using GetInfoPointer procedure.
     [ This procedure copy something from memory block that begin
       at P to information block ] }

Procedure InfoBlocksClear(clear: boolean);
{ This procedure sets if it must clear everything from information blocks
  before use or if it is already the values in information blocks}

Function SReadInfo(Ind: string): string;
{ This is general procedures to read information from menus field.
  Call these procedures after GetInfo procedure }

Procedure SWriteInfo(Ind,value: string);
{ This is general procedure to write information to menus field.
  Call this procedure after InitInformationBlock procedure and before
  GetInfo procedure }

Procedure InitInformationBlock;
{ This procedure do the same as GetInfo, but do not ask anything and
  put empty fields to information blocks. Call this procedure before
  GetInfo procedure. }

Procedure PushObjects;
{ This procedure save current objects information. }

Procedure PopObjects;
{ This procedure restore objects information. }

IMPLEMENTATION

Const ColNow: byte=7;
      Bf: byte=0;
      InfoSet: boolean=false;
      LPrc: word=0;
      IIB: boolean=false;

var XCur,YCur: integer;           { X,Y coordinates in text screen        }
    FirstObj: Pointer;            { Pointer to the first object           }
    OldHeap: Pointer;             { Heap before ClearObjects proc call    }
    LObj: Pointer;                { Pointer to the next object (nil)      }
    LastRadioList: pointer;       { Latest radio list                     }
    NextRadio: pointer;           { Pointer for next radio button in list }
    InfoBlock: pointer;           { Pointer to information block          }
    PrevOne: pointer;             { Pointer to previous block             }
    PrevButOne: pointer;          { Pointer to previous button            }
    PrevButNum: byte;             { The previous button number            }
    PrevButList: pointer;         { To remember it (for last But set )    }
    LastOne: pointer;             { Pointer to last block                 }
    BGP: pointer;                 { Pointer for text screen               }
    crs: word;                    { For cursor                            }
    ScrSaved: boolean;            { If text screen saved                  }
    prc: array[0..20] of pointer; { Array for procedures                  }
    vars: array[0..10] of pointer;{ Stack for objects                     }
    lvar: word;

Procedure AddStopButton(x,y: integer; s: string; col,bgcol,even: byte);
var Fld: ^GeneralButton;
Begin
 If FirstObj=nil then Mark(OldHeap);
 New(Fld);
 if LObj<>nil then move(Fld,LObj^,4);
 Fld^.std.NextOne:=nil;
 Fld^.std.TP:=1;
 Fld^.std.x:=x;
 Fld^.std.bgcol:=BGcol;
 Fld^.std.y:=y;
 GetMem(Fld^.std.Txt,length(s)+1);
 Fld^.std.Txt^:=s;
 Fld^.std.Col:=Col;
 Fld^.Even:=Even;
 if PrevOne<>nil then Fld^.std.PrevOne:=PrevOne else
                      Fld^.std.PrevOne:=nil;
 If FirstObj=nil then FirstObj:=Fld;
 LObj:=@Fld^.std.NextOne;
 PrevOne:=Fld;
End;

Procedure AddRadioButtonsList(ind: string);
var Fld: ^RadioButtonsList;
Begin
 if PrevButList<>nil then
  Begin
   move(PrevButOne,PrevButList^,4);
   PrevButList:=Ptr(Seg(PrevButList^),Ofs(PrevButList^)+4);
   move(PrevButNum,PrevButList^,1);
  End;
 PrevButNum:=0;
 If FirstObj=nil then Mark(OldHeap);
 New(Fld);
 if LObj<>nil then move(Fld,LObj^,4);
 Fld^.NextOne:=nil;
 Fld^.TP:=2;
 Fld^.LastBut:=nil;
 Fld^.LastNum:=0;
 GetMem(Fld^.Ind,length(ind)+1);
 Fld^.InfoBlock:=nil;
 Fld^.Ind^:=ind;
 Fld^.FirstButton:=nil;
 if PrevOne<>nil then Fld^.PrevOne:=PrevOne else
                      Fld^.PrevOne:=nil;
 If FirstObj=nil then FirstObj:=Fld;
 LObj:=@Fld^.NextOne;
 LastRadioList:=Fld;
 NextRadio:=@Fld^.FirstButton;
 PrevOne:=Fld;
 PrevButList:=@Fld^.LastBut;
 PrevButOne:=nil;
End;

Procedure AddRadioButton(x,y: integer; s: string; col,bgcol: byte);
var Fld: ^RadioButton;
Begin
 If LastRadioList=nil then exit;
 New(Fld);
 move(Fld,NextRadio^,4);
 NextRadio:=@Fld^.std.NextOne;
 Fld^.std.x:=x;
 Fld^.std.bgcol:=BGcol;
 Fld^.std.y:=y;
 Fld^.std.NextOne:=nil;
 GetMem(Fld^.std.Txt,length(s)+1);
 Fld^.std.Txt^:=s;
 Fld^.std.Col:=Col;
 if PrevButOne<>nil then Fld^.std.PrevOne:=PrevButOne else
                         Fld^.std.PrevOne:=nil;
 PrevButOne:=Fld;
 inc(PrevButNum);
End;

Procedure AddReadField(ind: string; x,y: integer;
                       s: string; col,bgcol,lng,tp: byte);
Var Fld: ^EnterField;
Begin
 If FirstObj=nil then Mark(OldHeap);
 New(Fld);
 if LObj<>nil then move(Fld,LObj^,4);
 Fld^.std.NextOne:=nil;
 Fld^.std.TP:=3;
 GetMem(Fld^.Ind,length(ind)+1);
 Fld^.Ind^:=ind;
 GetMem(Fld^.std.Txt,length(s)+1);
 Fld^.std.Txt^:=s;
 Fld^.std.x:=x;
 Fld^.std.y:=y;
 Fld^.std.col:=col;
 Fld^.std.bgcol:=BGcol;
 Fld^.lng:=lng;
 Fld^.InfoBlock:=nil;
 Fld^.TypeInput:=tp;
 if PrevOne<>nil then Fld^.std.PrevOne:=PrevOne else
                      Fld^.std.PrevOne:=nil;
 If FirstObj=nil then FirstObj:=Fld;
 LObj:=@Fld^.std.NextOne;
 PrevOne:=Fld;
End;

Procedure AddDateInputField(ind: string; x,y: integer;
                            s: string; col,bgcol: byte);
Var Fld: ^EnterDateField;
Begin
 If FirstObj=nil then Mark(OldHeap);
 New(Fld);
 if LObj<>nil then move(Fld,LObj^,4);
 Fld^.std.NextOne:=nil;
 Fld^.std.TP:=4;
 GetMem(Fld^.Ind,length(ind)+1);
 Fld^.Ind^:=ind;
 GetMem(Fld^.std.Txt,length(s)+1);
 Fld^.std.Txt^:=s;
 Fld^.std.x:=x;
 Fld^.std.y:=y;
 Fld^.std.col:=col;
 Fld^.std.bgcol:=BGcol;
 if PrevOne<>nil then Fld^.std.PrevOne:=PrevOne else
                      Fld^.std.PrevOne:=nil;
 If FirstObj=nil then FirstObj:=Fld;
 LObj:=@Fld^.std.NextOne;
 PrevOne:=Fld;
 AddReadField('!DTA!',x+length(s)+1,y,':',col,bgcol,2,ChrNumbers);
 Fld^.Day:=PrevOne;
 AddReadField('!DTA!',x+length(s)+4,y,'/',col,bgcol,2,ChrNumbers);
 Fld^.Month:=PrevOne;
 AddReadField('!DTA!',x+length(s)+7,y,'/',col,bgcol,4,ChrNumbers);
 Fld^.Year:=PrevOne;
End;

Procedure ClearObjects;
Begin
 If OldHeap=nil then exit;
 lprc:=0;
 InfoSet:=false;
 Release(OldHeap);
 FirstObj:=nil;
 OldHeap:=nil;
 LObj:=nil;
 LastRadioList:=nil;
 NextRadio:=nil;
 PrevOne:=nil;
 PrevButOne:=nil;
 PrevButList:=nil;
 IIB:=false;
End;

Procedure OutPutRadioButtons(Std: Pointer);
var F: ^RadioButtonsList;
    Cur: ^StandartType;
    Ch: char;
    b,slct: byte;
Begin
b:=0;
 F:=Std;
 if F^.InfoBlock<>nil then Slct:=F^.InfoBlock^ else Slct:=0;
 Cur:=ptr(seg(F^.FirstButton^),ofs((F^.FirstButton^)));
  Repeat
   MGotoXy(Cur^.x,Cur^.y);
   MColor(Cur^.Col);
   MBGColor(Cur^.BGCol);
   if Slct=b then ch:='*' else ch:=' ';
   MWrite(' ['+ch+'] '+Cur^.txt^+' ');
   Cur:=Cur^.NextOne;
   inc(b);
  Until Cur=nil;
End;

Function LNG(B: byte; s: string): string;
Begin
 while length(s)<b do s:=s+' ';
 LNG:=s;
End;

Procedure OutPutMenus;
Var s: ^StandartType;
    r: string;
    EF: ^EnterField;
    RB: ^RadioButtonsList;
    DT: ^EnterDateField;
Begin
 s:=FirstObj;

  while S<>nil do
   Begin
    MGotoXy(S^.x,S^.y);
    MColor(S^.col);
    MBGColor(S^.BGCol);
    EF:=ptr(seg(S^),ofs(S^));
    RB:=ptr(seg(S^),ofs(S^));
    DT:=ptr(seg(S^),ofs(S^));
    r:='';
    if S^.TP=3 then if EF^.InfoBlock<>nil then r:=EF^.InfoBlock^;
    if S^.TP=4 then if DT^.Day^.InfoBlock<>nil then
         r:=LNG(2,DT^.Day^.InfoBlock^)+'/'+
            LNG(2,DT^.Month^.InfoBLock^)+'/'+LNG(4,DT^.Year^.InfoBlock^);
    case S^.TP of
     1: MWrite('[ '+S^.txt^+' ]'+r);
     2: OutPutRadioButtons(S);
     3: MWrite(S^.txt^+r+' ');
     4: MWrite(S^.txt^+'  '+r+' ');
    end;
    s:=S^.NextOne;
   End;

End;

Procedure Ins(var S: string; ch: char; var ps,lng: byte);
Begin
 if length(s)>=lng then exit;
 if (ps>=length(s)) then s:=s+ch else Insert(ch,s,ps+1);
 Inc(ps);
End;

Function ReadStr(p: pointer): char;
var s: string;
    ch: char;
    lng,mx,tp: byte;
    h,ps: byte;
    c: ^EnterField;
    FKey: boolean;
    si: string[65];
Begin
 C:=ptr(seg(p^),ofs(p^));
 s:=C^.InfoBlock^;

 lng:=length(C^.std.txt^);
 tp:=C^.TypeInput;
 mx:=C^.lng;
 ps:=length(s);
 FKey:=true;

 Repeat
  MGotoXy(C^.std.x+lng,C^.std.y);
  MWrite(S);
  MBGColor(C^.std.BGCol);
  if length(s)<mx then MWrite(' ');
  MGotoXy(C^.std.x+ps+lng-1,C^.std.y+1);
  MWrite(' ~ ');

    MBGColor(8);
    MGotoXy(1,23);
    if tp=1 then si:='characters, numbers, ';
    if tp=2 then si:='numbers, ';
    if tp=3 then si:='characters, ';
    if tp=4 then si:='numbers, point, ';
    si:='Usage: arrows, '+si+'DEL, BackSpace';
    while length(si)<59 do si:=si+' ';

    MWrite(si);
    MBGColor(C^.std.BGCol);

  While MKeyPressed do MReadKey;
  CH:=MReadKey;
  if (ch in[#13,#27,#9]) and FKey then FKey:=false;
  MGotoXy(C^.std.x+ps+lng-1,C^.std.y+1);
  MWrite('   ');
  if ch=#0 then
   Begin
    ch:=MReadKey;
    if (ch=#77) and (ps<length(s)) then Inc(ps);
    if (ch=#75) and (ps>0) then Dec(ps);
    if (ch=#83) and (ps<length(s)) then Delete(S,ps+1,1);
    if (ch=#72) then ch:=#27;
    if (ch=#80) then ch:=#13;
    FKey:=false;
   End else
  Begin
   if FKey then
    Begin
     s:='';
     for h:=1 to mx do s:=s+' ';
     MGotoXy(C^.std.x+lng,C^.std.y);
     MWrite(S);
     s:='';
     ps:=0;
     FKey:=false;
    End;
    Begin
     if (ch in['0'..'9']) and (tp=2) then Ins(S,ch,ps,mx);
     if (ord(ch)>=32) and (tp=1) then Ins(S,ch,ps,mx);
     if (ord(ch)>=32) and (not (ch in['0'..'9'])) and (tp=3) then Ins(S,ch,ps,mx);
     if (ch in['0'..'9','.']) and (tp=4) then Ins(S,ch,ps,mx);
     if (ch=#8) and (ps>0) then
      Begin
       delete(s,ps,1);
       Dec(ps);
      End;
    End;
  End;
 Until CH in[#13,#9,#27];
  MGotoXy(C^.std.x+lng,C^.std.y);
  MWrite(S+' ');
C^.InfoBLock^:=s;
ReadStr:=ch;
End;

Function WorkWithRadioButtons(p: pointer): char;
var but: ^RadioButtonsList;
    OldCur,cur: ^StandartType;
    ch: char;
    Slct,b: byte;
Begin
 But:=ptr(seg(P^),ofs(P^));
 Cur:=ptr(seg(But^.FirstButton^),ofs((But^.FirstButton^)));
  Slct:=But^.InfoBlock^;
 B:=0;

  Repeat
   OutPutMenus;
   MColor(7);
   MBGColor(8);
    MGotoXy(1,23);
   MWrite('Usage: SpaceBar, arrows                                    ');
   MGotoXy(Cur^.x,Cur^.y);
   MColor(Cur^.Col);
   MBGColor(4);
   if Slct=b then ch:='*' else ch:=' ';
   MWrite(' ['+ch+'] '+Cur^.txt^+' ');

   While MKeyPressed do MReadKey;
   Ch:=MReadKey;
   if ch=#32 then But^.InfoBlock^:=b;
   Slct:=But^.InfoBlock^;
   if Ch=#0 Then
    Begin
     Ch:=MReadKey;
     if (Ch=#80) or (ch=#77) then
      Begin
       Cur:=Cur^.NextOne;
       inc(b);
       if Cur=nil then if ch=#77 then
        Begin
         Cur:=ptr(seg(But^.FirstButton^),ofs((But^.FirstButton^)));
         b:=0;
        End else ch:=#9;
      End;
     if (ch=#72) or (ch=#75) Then
      Begin
       Cur:=Cur^.PrevOne;
       If Cur=nil then
        Begin
         If ch=#75 then
          Begin
           b:=But^.LastNum-1;
           Cur:=Ptr(Seg(But^.LastBut^),Ofs(But^.LastBut^));
          End Else Ch:=#27;
        End Else Dec(b);
      End;
    End;
  Until ch in[#27,#13,#9,#8];
WorkWithRadioButtons:=ch;
End;

Function GetInfo: byte;
var Tp,Now: byte;
    S: ^StandartType;
    But: ^GeneralButton;
    chi,ch: char;
    prr: procedure;
    w: word;
Begin
 If PrevButList<>nil then
  Begin
   move(PrevButOne,PrevButList^,4);
   PrevButList:=Ptr(Seg(PrevButList^),Ofs(PrevButList^)+4);
   move(PrevButNum,PrevButList^,1);
  End;
 LastOne:=PrevOne;
 PrevOne:=nil;

 If IIB=false then InitInformationBlock;

 S:=FirstObj;
   Repeat
    ch:=#255;
    OutPutMenus;
    MBGColor(8);
    MColor(7);
    MGotoXy(1,22);
   MWrite('Usage: arrows, ENTER, ESC                                  ');
    MGotoXy(1,23);
   MWrite('                                                           ');
    MBGColor(S^.BGCol);
    MColor(S^.col);
    MBGColor(4);
    MGotoXy(S^.x,S^.y);
    case S^.TP of
     1: MWrite('[ '+S^.txt^+' ]');
     2: ch:=WorkWithRadioButtons(S);
     3: MWrite(S^.txt^+' ');
     4: MWrite(S^.txt^+' ');
    end;
    if ch=#8 then ch:=#27;

      While MKeyPressed do MReadKey;
      If S^.TP=3 then ch:=ReadStr(S) else if (not (S^.TP in [2,4])) then
       Repeat
        chi:=#255;
        ch:=MReadKey;
        If ch=#8 then ch:=#27;
        If ch=#0 then chi:=MReadKey;
        If Chi=#72 then ch:=#27;
        If Chi=#80 then ch:=#9;
       Until ch in[#13,#27,#9,#8];

    tp:=S^.tp;
    if not ((ch=#13) and (TP=1)) then
    if ch<>#27 then S:=S^.NextOne else if S^.PrevOne<>nil then
         S:=S^.PrevOne else S:=LastOne;
    if (ch=#27) and (S^.TP=4) then if S^.PrevOne<>nil then
         S:=S^.PrevOne else S:=LastOne;
    if S=nil then s:=FirstObj;
    if lprc>0 then for w:=0 to lprc-1 do
     begin
      @prr:=prc[w];
      if prc[w]<>nil then prr;
     end;
   Until (ch=#13) and (TP=1);
   But:=ptr(seg(s^),ofs(s^));
   GetInfo:=But^.Even;
End;

Procedure MGotoXy(x,y: integer);
Begin
 XCur:=x;
 YCur:=y;
End;

Procedure MWrite(s: string);
var b: byte;
Begin
  if s<>'' then For b:=1 to length(s) do
  Begin
   mem[$B800:word(YCur*160+XCur*2+word(b*2))]:=ord(s[b]);
   mem[$B800:word(YCur*160+XCur*2+word(b*2)+1)]:=ColNow;
  End;
 XCur:=XCur+Length(s);
 YCur:=YCur+XCur div 80;
 XCur:=XCur mod 80;
 YCur:=YCur mod 25;
 XCur:=XCur mod 80;
End;

Procedure MWriteLn(s: string);
Begin
MWrite(s);
Inc(YCur);
XCur:=0;
End;

Procedure MColor(col: byte);
Begin
 ColNow:=ColNow and 240;
 Col:=Col and 15;
 ColNow:=ColNow or Col;
End;

Procedure MBGColor(col: byte);
Begin
 Col:=Col mod 8;
 Col:=Col shl 4;
 ColNow:=ColNow and 15;
 ColNow:=ColNow or Col;
End;

Procedure MClrScr;
var p: pointer;
Begin
 p:=ptr($B800,0);
 FillChar(P^,4000,0);
End;

Procedure MScrBgColor(col: byte);
var w: word;
Begin
Col:=Col shl 4;
 For w:=0 to 2000 do mem[$B800:w*2+1]:=mem[$B800:w*2+1] or col;
End;

Function MReadKey: char;
var b,b1: byte;
Begin
 if Bf<>0 then
  Begin
   MReadKey:=chr(BF);
   BF:=0;
  End else
  Begin
   Asm
    mov ax,0
    int 16h
    mov b,al
    mov b1,ah
   End;
   MReadKey:=chr(b);
   if b=0 then bf:=b1;
  End;
end;

Function MKeyPressed: boolean;
Var KeyP: boolean;
Begin
   asm
    mov keyp,0
    mov ah,1
    int 16h
    jne @NOKEYS
    mov keyp,255
    @NOKEYS:
   end;
   MKeyPressed:=not Boolean(keyp);
End;

Procedure GetInfoPointer(var P: pointer; var size: word);
Var T: pointer;
Begin
 Mark(T);
 Size:=(Seg(T^)-Seg(InfoBLock^))*16+
       (integer(Ofs(T^))-Integer(Ofs(InfoBlock^)));
 P:=InfoBlock;
End;

Procedure SetInfoPointer(P: pointer);
Var T: pointer;
    Size: word;
Begin
 Mark(T);
 Size:=(Seg(T^)-Seg(InfoBLock^))*16+
       (integer(Ofs(T^))-Integer(Ofs(InfoBlock^)));
 Move(P^,InfoBlock^,Size);
 InfoSet:=true;
End;

Procedure InfoBlocksClear(clear: boolean);
Begin
 InfoSet:=clear;
End;

Function SReadInfo(Ind: string): string;
var Fnd: boolean;
    S: ^StandartType;
    EF: ^EnterField;
    RB: ^RadioButtonsList;
    DT: ^EnterDateField;
Begin
 Fnd:=false;
 S:=FirstObj;
   Repeat
    EF:=ptr(seg(S^),ofs(S^));
    RB:=ptr(seg(S^),ofs(S^));
    DT:=ptr(seg(S^),ofs(S^));
    If S^.TP=3 then if EF^.Ind^=Ind then Fnd:=true;
    If S^.TP=2 then if RB^.Ind^=Ind then Fnd:=true;
    If S^.TP=4 then if DT^.Ind^=Ind then Fnd:=true;
    If FND=false then S:=S^.NextOne;
   Until (S=nil) or Fnd;
 if S=nil then SReadInfo:='' else
 if S^.TP=3 then SReadInfo:=EF^.InfoBlock^ else
 if S^.TP=2 then SReadInfo:=chr(RB^.InfoBlock^+48) else
 if S^.TP=4 then SReadInfo:=DT^.Day^.InfoBlock^+'/'+
 DT^.Month^.InfoBLock^+'/'+DT^.Year^.InfoBlock^;
End;

Procedure SWriteInfo(Ind,value: string);
var Fnd: boolean;
    S: ^StandartType;
    EF: ^EnterField;
    RB: ^RadioButtonsList;
    DT: ^EnterDateField;
    r: string;
Begin
 Fnd:=false;
 S:=FirstObj;
   Repeat
    EF:=ptr(seg(S^),ofs(S^));
    RB:=ptr(seg(S^),ofs(S^));
    DT:=ptr(seg(S^),ofs(S^));
    If S^.TP=3 then if EF^.Ind^=Ind then Fnd:=true;
    If S^.TP=2 then if RB^.Ind^=Ind then Fnd:=true;
    If S^.TP=4 then if DT^.Ind^=Ind then Fnd:=true;
    If FND=false then S:=S^.NextOne;
   Until (S=nil) or Fnd;
 if S^.TP=3 then EF^.InfoBlock^:=Value else
 if S^.TP=2 then RB^.InfoBlock^:=Ord(Value[1])-48 else
 if S^.TP=4 then
  Begin
   r:=Value;
   Delete(r,pos('/',r),length(r)-pos('/',r)+1);
   DT^.Day^.InfoBlock^:=r;
   Delete(Value,1,length(r)+1);
   r:=Value;
   Delete(r,pos('/',r),length(r)-pos('/',r)+1);
   DT^.Month^.InfoBlock^:=r;
   Delete(value,1,length(r)+1);
   DT^.Year^.InfoBlock^:=value;
  End;
End;

Procedure MSaveScreen;
const SCR: pointer=ptr($B800,0);
begin
 if scrsaved then exit;
 if MaxAvail<5000 then exit;
 getmem(bgp,5000);
 move(SCR^,BGp^,4000);
 crs:=memw[$40:$50];
 scrsaved:=true;
end;

Procedure MLoadScreen;
const SCR: pointer=ptr($B800,0);
begin
 if scrsaved then
  begin
   move(BGp^,SCR^,4000);
   memw[$40:$50]:=crs;
   freemem(bgp,5000);
   scrsaved:=false;
  end;
end;

Procedure InitInformationBlock;
var
    S: ^StandartType;
    EF: ^EnterField;
    RB: ^RadioButtonsList;
Begin
 if IIB then exit;
 IIB:=true;
 Mark(InfoBLock);

 S:=FirstObj;
   Repeat
    EF:=ptr(seg(S^),ofs(S^));
    RB:=ptr(seg(S^),ofs(S^));
    If S^.TP=3 then
      Begin
       if EF^.InfoBlock=nil then
        Begin
         GetMem(EF^.InfoBlock,EF^.lng+1);
         if InfoSet=false then EF^.InfoBlock^:='';
        End;
      End;
    If S^.TP=2 then
      Begin
       if RB^.InfoBlock=nil then
        Begin
         GetMem(RB^.InfoBLock,1);
         If InfoSet=false then RB^.InfoBlock^:=0;
        End;
      End;
    S:=S^.NextOne;
   Until (S=nil);
End;

Procedure AddCallProc(P: pointer);
Begin
 Prc[lprc]:=P;
 inc(lprc);
End;

Procedure PushObjects;
var P: pointer;
Begin
 P:=@XCur;
 GetMem(Vars[LVar],134);
 move(P^,Vars[LVar]^,134);
 inc(LVar);
 Mark(OldHeap);
End;

Procedure PopObjects;
var P: pointer;
Begin
 P:=@XCur;
 dec(LVar);
 move(Vars[LVar]^,P^,134);
 FreeMem(Vars[LVar],134);
End;

End.