{$G+}
unit myencode;

INTERFACE

uses bitswork;


{A       - memory block to compress                                       }
{B       - memory block for compressed data                               }
{SZ      - number of bytes to compress. Return in SZ compressed data size }
{EnCode  - function return number of haffman codes                        }
function EnCode(a,b: pointer; var sz,tblsz: word): word;

{A       - compressed data                                                }
{B       - memory block for decompressed data                             }
{CODES   - number of compressed codes                                     }
{DeCode  - return deconmpressed data size in bytes                        }
function DeCode(a,b: pointer; codes: word): word;

const ReadBits=8;
      WriteBits=12;

      MaxReadSize=2 shl (ReadBits-1);
      MaxWriteSize=2 shl (WriteBits-1);

      OutCodesSize=2;


type TreeNode=record
               Weight: word;
               RealNum: word;
               RightNode: word;
               LeftNode: word;
              end;

var TimesTable: array[0..MaxReadSize*2-1] of TreeNode;

IMPLEMENTATION

type
     AddCode=record
              LengthInBits: byte;
              AddBits: array[0..OutCodesSize shl 2-2] of byte;
             end;

     Header=record
             Codes: word;         {Number of huffman codes after compression}
             Lng: word;           {Length of huffman codes in bytes         }
             TableSize: word;     {Size of boolean tree                     }
             CodeSizeInBits: byte;{Size of code (in bits) before compression}
             TreeTop: word;       {Pointer to tree top record (pointer=8n)  }
            end;


var OutCodes: array[0..MaxReadSize-1] of AddCode;
    b,a: pointer;
    head: header;
    f,f1: file;
    num: word;
    s: string;

{              DX          - number of bytes to work with.                 }
{              ES:BX       - pointer to read buffer                        }
{****************************** RETURN ************************************}
{              TimesTable  - updated table                                 }
procedure CreateRepeatTable; Assembler;
asm
cld                           { Begin:   Clean TimesTable   }
mov cx,MaxReadSize
shl cx,4
push es
push SEG TimesTable
pop es
mov di,OFFSET TimesTable
mov al,0
@ContinueRepHere:
 rep stosb
 jcxz @RepDoneHere
jmp @ContinueRepHere
@RepDoneHere:
pop es                        { End:     Clean TimesTable   }

cld                           { Begin:   Clean OutCodes     }
mov cx,MaxReadSize
shl cx,(OutCodesSize+1)
push es
push SEG OutCodes
pop es
mov di,OFFSET OutCodes
mov al,0
@ContinueRepHere1:
 rep stosb
 jcxz @RepDoneHere1
jmp @ContinueRepHere1
@RepDoneHere1:
pop es                        { End:     Clean OutCodes     }

mov si,2                     { Begin:  set real characters numbers in       }
mov cx,0                     {         TimesTable to 0,1,2,...,MaxReadSize. }
@NextTableEntry:
 mov Word Ptr TimesTable[si],cx
 add si,8
 inc cx
 cmp cx,MaxReadSize          { End:    set real characters numbers in       }
jne @NextTableEntry          {         TimesTable to 0,1,2,...,MaxReadSize. }

mov di,bx        { DI - offset of read buffer (ES:DI address)              }
mov bx,dx        { Number of bytes to work with                            }
xor cx,cx        { CL - bit possition in ES:DI (first time should be zero) }

@NextOne:         {Begin:  Count probabilities of different codes in buffer }
 call ReadNBitsEsDi          {Read one code from ES:DI to DX; CL - bit pos. }
 mov si,dx
 push cx
 mov cl,3
 shl si,cl                    {SI:=SI*8 (TimesTable is 4 words records table)}
 pop cx
{TimesTable is table where number of equal codes from buffer saved.
 For example if there are 15 characters "A" that ASCII code is 65, then
 TimesTable[65] should be equal to 15.                                      }
 inc Word Ptr TimesTable[si]
 cmp di,bx                   {Check if evething read from buffer            }
 jbe @NextOne     {End:    Count probabilities of different codes in buffer }
end;


{            TimesTable  - probabilities of different codes in buffer array }
{            DX          - current sort table size                          }
{****************************** RETURN *************************************}
{            TimesTable  - updated table                                    }
procedure SortRepeatTable; assembler;
asm
 xor di,di                           { DI - flag that show if table sorted  }
 mov cl,3
 shl dx,cl                           { DX - length of current sort table    }
 sub dx,8
 mov si,0                            { SI - current possition in sort table }

@NextTurn:
   cmp si,dx                         { Check if current table sort done     }
   je @NextSearch
  mov bx,word ptr TimesTable[si]     { Read two codes from table            }
  mov cx,word ptr TimesTable[si+8]
  add si,8
   cmp bx,cx                         { Check if have to sort this two codes }
   jae @NextTurn
  mov di,1
  mov word ptr TimesTable[si-8],cx   { Sort two codes. Change it possitions.}
  mov word ptr TimesTable[si],bx     { Put one code to possition of second  }
                                     { and second to possition of first.    }
                                     { Code length is 4 word (or 8 bytes).  }
  push word ptr TimesTable[si-6]     { So we four times put to stack        }
  push word ptr TimesTable[si+2]     { two words and load in the same order.}
  pop word ptr TimesTable[si-6]
  pop word ptr TimesTable[si+2]

  push word ptr TimesTable[si-4]
  push word ptr TimesTable[si+4]
  pop word ptr TimesTable[si-4]
  pop word ptr TimesTable[si+4]

  push word ptr TimesTable[si-2]
  push word ptr TimesTable[si+6]
  pop word ptr TimesTable[si-2]
  pop word ptr TimesTable[si+6]

   jmp @NextTurn                     { Time to check next code in sort table}

@NextSearch:                         { Come here if current sort done       }
   cmp di,0
   je @SortDone                      { Check if sort table already sorted   }
  xor di,di
  mov si,0                           { Prepare for next sort                }
  sub dx,8                           { Next sort should be shorter          }
   cmp dx,0
   jne @NextTurn                     { Check if everything done or next sort}

@SortDone:
end;

{              OutCodes    - table with codes                              }
{              BX          - pointer to values in table                    }
{              DI          - boolean. True if have to add 1 or false.      }
{****************************** RETURN ************************************}
{              OutCodes    - updated table                                 }
procedure AddOneBitToOutCodes; assembler;
asm
 mov cl,OutCodesSize+1             {Begin:    add one bit to OutCodes[bx] }
 shl bx,cl
 mov ch,byte ptr OutCodes[bx]
 inc Byte Ptr OutCodes[bx]
 mov dl,8 shl (OutCodesSize+1) - 1
 sub dl,ch
 mov ch,dl
 mov cl,3
 shr dl,cl
 xor dh,dh
 add bx,dx
 shl dl,cl
 sub dl,ch
 mov cl,dl
 add cl,7
 mov ax,80h
 cmp DI,0
 je @AddZero
 shr al,cl
 or Byte Ptr OutCodes[bx],al
 jmp @AddDone
 @AddZero:
 shr al,cl
 xor al,0ffh
 and Byte Ptr OutCodes[bx],al      {End:      add one bit to OutCodes[bx] }
 @AddDone:
end;


{          SI          - pointer (pointer=8n) to the tree leave             }
{          TimesTable  - probabilities of different codes in buffer array   }
{                      - here this is boolean tree of huffman codes too     }
{          OutCodes    - table with huffman codes                           }
{****************************** RETURN *************************************}
{          OutCodes    - updated table                                      }
procedure RecursionAddBitsToHuffmanCodes; assembler;
asm
 push di
 mov di,0
@NextSubTree:
 push di

{OOOOOOOOOOOOOOOOO   Recursion here begins...   OOOOOOOOOOOOOOOOOOOOOOOOOOOO}

 mov bx,di
 shl bx,1
 mov bx,word ptr TimesTable[bx+si+4]

 push 0ffffh
 push bx

@NextRecursionStep:
 mov ax,word ptr TimesTable[bx+2]
 cmp ax,0ffffh
 je @GoLeftNow
 cmp ax,0fffeh
 je @GoRightNow
 pop bx
 cmp bx,0ffffh
 je @RecursionDone
 cmp ax,0fffdh
 je @NextRecursionStep

 push bx
 mov bx,ax
 call AddOneBitToOutCodes;
 pop bx

 jmp @NextRecursionStep

@GoLeftNow:
 mov word ptr TimesTable[bx+2],0fffeh
 push bx
 mov bx,word ptr TimesTable[bx+4]
 jmp @NextRecursionStep

@GoRightNow:
 mov word ptr TimesTable[bx+2],0fffdh
 push bx
 mov bx,word ptr TimesTable[bx+6]
 jmp @NextRecursionStep

{OOOOOOOOOOOOOOOOOOO   Recursion here ends!   OOOOOOOOOOOOOOOOOOOOOOOOOOOOOO}

@RecursionDone:

{BEGIN ********** Correct reqursion flags in TimesTable *******************}

 push si

  mov di,2
  mov si,MaxReadSize*2
  mov cl,3
  shl si,cl
  add si,2

@CorrectNextOne:
  cmp word ptr TimesTable[di],0fffdh
  jne @WithoutCorrect
  mov word ptr TimesTable[di],0ffffh
  @WithoutCorrect:
  add di,8
  cmp di,si
  jne @CorrectNextOne

 pop si

{END   ********** Correct reqursion flags in TimesTable *******************}

 pop di
 inc di
 cmp di,2
 jne @NextSubTree
 pop di

end;

{            TimesTable  - probabilities of different codes in buffer array }
{                        - here this is boolean tree of huffman codes too   }
{            DX          - current sort table size (only general trees)     }
{            DI          - real sort table size (with subtrees)             }
{****************************** RETURN *************************************}
{            TimesTable  - updated table                                    }
{            DI          - updated real sort table size                     }
{            DX          - updated current sort table size                  }
procedure BuildTree; assembler;
asm
 mov si,dx
 sub si,2                            { SI:=DX-2                             }
 mov cl,3
 shl si,cl                           { SI:=SI*8 (one record size is 8)      }
 shl di,cl                           { DI:=DI*8                             }


 push word ptr TimesTable[si]        {Begin:     TimesTable[di div 8]:=     }
 pop word ptr TimesTable[di]         {           TimesTable[si div 8]       }
 push word ptr TimesTable[si+2]
 pop word ptr TimesTable[di+2]
 push word ptr TimesTable[si+4]
 pop word ptr TimesTable[di+4]
 push word ptr TimesTable[si+6]      {End:       TimesTable[di div 8]:=     }
 pop word ptr TimesTable[di+6]       {           TimesTable[si div 8]       }

{ TimesTable[0+8n] = TimesTable[8n div 8].Weight    - probability           }
{ TimesTable[2+8n] = TimesTable[8n div 8].RealNum   - real character number }
{                                                     for last tree entry or}
{                                                     0ffffh for tree leaves}
{ TimesTable[4+8n] = TimesTable[8n div 8].RightNode - 0 for last tree entry }
{                                                     or pointer to left    }
{                                                     subtree (pointer=8n)  }
{ TimesTable[6+8n] = TimesTable[8n div 8].LeftNode  - 0 for last tree entry }
{                                                     or pointer to right   }
{                                                     subtree (pointer=8n)  }

 mov ax,word ptr TimesTable[si+8]
 mov bx,word ptr TimesTable[si]
 add ax,bx                           {AX:=summ of smallest two probabilities}

 mov word ptr TimesTable[si],ax
 mov word ptr TimesTable[si+2],0ffffh{ Create new tree leave with two       }
 mov word ptr TimesTable[si+4],di    { subtrees.                            }
 mov word ptr TimesTable[si+6],si
 add word ptr TimesTable[si+6],8

 call RecursionAddBitsToHuffmanCodes { Add bits to all subtrees of created  }
                                     { tree leave.                          }

 mov cl,3
 shr di,cl
 shr si,cl
 mov dx,si
 inc di
 inc dx
end;

{            ES:BX       - address of read buffer                           }
{            DX          - number of bytes to work with                     }
{****************************** RETURN *************************************}
{            OutCodes    - table with huffman codes                         }
procedure CreateHuffmanCodes; Assembler;
asm
   call CreateRepeatTable

   mov dx,MaxReadSize
   call SortRepeatTable
   mov si,MaxReadSize
   mov cl,3
   shl si,cl

   @TableShorter:
    sub si,8
    cmp word ptr TimesTable[si],0
   je @TableShorter

   shr si,cl
   inc si

   mov dx,si
   mov di,si

   @NextLeaveToTree:
    cmp dx,1
    je @TreeBuildDone
    call BuildTree
    push dx
    push di
     call SortRepeatTable
    pop di
    pop dx
    jmp @NextLeaveToTree



@TreeBuildDone:

   mov Head.TableSize,di
   mov Head.TreeTop,0


end;

procedure NormolizeCodes; assembler;
asm
 mov di,0

@TryNext:
 mov ch,byte ptr OutCodes[di]
 cmp ch,0
 je @NotThisOne

 mov si,di
 mov bx,di
 add bx,8
 inc si
 mov dh,8 shl (OutCodesSize+1)
 sub dh,ch
 mov dl,dh
 mov ch,dh
 mov cl,3
 shr dl,cl
 xor dh,dh
 add di,dx
 and ch,7
 mov cl,0

@NextBits:

{ CL is bit possition in write byte  }
{ CH is bit possition in read byte   }
{ DI is read offset                  }
{ SI is write offset                 }

 push cx

   mov dl,byte ptr OutCodes[di]

   cmp ch,cl         { Compare to know if move right (SHR) or left (SHL)    }
   jl @OkGo
     xchg ch,cl      { CL=CH and CH=CL. Changing one to other.              }
     sub cl,ch
     shr dl,cl       { Move bits right                                      }
     mov dh,8
     sub dh,cl

  jmp @MoveBitsDone
  @OkGo:
     sub cl,ch
     shl dl,cl       { Move bits left                                       }
     mov dh,8
     sub dh,cl

  @MoveBitsDone:

 pop cx
 or byte ptr OutCodes[si],dl
 add cl,dh
 add ch,dh
 cmp cl,8
 jl @NoAdd
 and cl,7
 inc si
@NoAdd:
 cmp ch,8
 jl @NoAdd1
 and ch,7
 inc di
@NoAdd1:

cmp di,bx
jne @NextBits
jmp @NoAddPlease

@NotThisOne:
 add di,OutCodesSize shl 2
@NoAddPlease:
 cmp di,MaxReadSize shl (OutCodesSize+1)
 jne @TryNext
end;

{            ES:DI       - address of read buffer                           }
{            SI:BX       - address of write buffer                          }
{            DX          - number of codes to work with                     }
{****************************** RETURN *************************************}
{            DX          - size in bytes                                    }
{            SI          - size in codes                                    }
procedure EnCoding; assembler;
var sg: word;
asm
mov sg,si
push es
push sg
pop es
mov Word Ptr ES:[BX],0     { See WriteNBitsEsBx (first value should be 0)  }
pop es
xor cx,cx        { CL - bit possition in ES:DI (first time should be zero) }
xor si,si

push bx

@NextOne:
 push dx
 push si
 call ReadNBitsEsDi          {Read one code from ES:DI to DX; CL - bit pos. }
 mov si,dx
 push cx

  mov cl,(OutCodesSize+1)
  shl si,cl
  mov dl,byte ptr OutCodes[si]

 @NextTwoBytes:
  mov ch,dl
  inc si
  mov ax,word ptr OutCodes[si]
  mov cl,4
  mov dh,dl
  shr dl,cl
  shl dl,cl
  mov cl,16
  cmp dl,0
  jne @OkToWrite
  sub dh,dl
  mov cl,dh
  @OkToWrite:
  mov byte ptr PrcWriteBits,cl
  mov dh,cl
  mov dl,ch
  pop cx
  push es
  push sg
  pop es
  call WriteNBitsEsBx
  pop es
  push cx
  sub dl,dh
  inc si
  cmp dl,0
  jne @NextTwoBytes

 pop cx
 pop si
 pop dx
 inc si
 cmp si,dx
 jbe @NextOne

 cmp ch,0            { If stoped at the middle of the word, then    }
je @DoneExit         { add one or two bytes to encoded data length. }
cmp ch,7
jg @AddTwo
 add bx,1
 jmp @DoneExit
@AddTwo:
 add bx,2
@DoneExit:

mov dx,bx

pop bx

sub dx,bx
end;

{            ES:DI       - address of read buffer                           }
{            SI:BX       - address of write buffer                          }
{            DX          - number of codes to work with                     }
{****************************** RETURN *************************************}
{            DX          - size in codes                                    }
{            SI          - size in bytes                                    }
procedure DeCoding; assembler;
var sg: word;
asm
mov ax,dx
mov sg,si
xor si,si
push es
push sg
pop es
mov Word Ptr ES:[BX],0     { See WriteNBitsEsBx (first value should be 0)  }
pop es
mov byte ptr PrcReadBits,1
xor dx,dx
xor cx,cx { CL is bit possition in ES:DI; CH is bit possition in ES:BX  }
push bx

@NextValue:

push si
push dx

@NextStep:
  call ReadNBitsESDI
  and dx,1

 cmp dl,1
 je @GoRightSubTree

 mov si,Word Ptr TimesTable[si+4]
 cmp Word Ptr TimesTable[si+2],0ffffh
je @NextStep

jmp @AddCode

 @GoRightSubTree:

 mov si,Word Ptr TimesTable[si+6]
 cmp Word Ptr TimesTable[si+2],0ffffh
je @NextStep

@AddCode:

push ax
mov ax,Word Ptr TimesTable[si+2]
push es
push sg
pop es
call WriteNBitsEsBx
pop es
pop ax

pop dx
pop si

inc dx
cmp dx,ax
jne @NextValue

mov si,bx
pop bx
sub si,bx

 cmp ch,0            { If stoped at the middle of the word, then    }
je @DoneExit         { add one or two bytes to encoded data length. }
cmp ch,7
jg @AddTwo
 add si,1
 jmp @DoneExit
@AddTwo:
 add si,2
@DoneExit:
end;

procedure AddMore(b: byte; num: word; var ps: word; a: pointer);
var psw: word;
begin
 for psw:=ps to ps+num-1 do mem[seg(A^):ofs(A^)+psw]:=b;
 ps:=ps+num;
end;

procedure OutBits(w: addcode; w1: word);
var b,a,c,d,ou: byte;
    NowIs: word;
    i: boolean;
begin
ou:=0;
i:=false;
b:=w.lengthinbits;
a:=b div 8;
d:=8-b mod 8;
a:=OutCodesSize shl 2-2-a;
for b:=a to OutCodesSize shl 2-2 do
 begin
  c:=w.addbits[b];
  if b=a then NowIs:=1 shl d else NowIs:=1;
  if NowIs<256 then
   repeat
    if c and NowIs=NowIs then write('1') else write('0');
    ou:=ou+1;
    NowIs:=NowIs*2;
    i:=true;
   until NowIs>128;
 end;
if i then
 begin
  {gotoxy(40,wherey);}
  writeln('      number=',w1,'        length=',ou);
 end;
end;

function EnCode(a,b: pointer; var sz,tblsz: word): word;
var num,lng,codes: word;
begin
num:=sz;
 asm
       mov dx,num
       sub dx,1
       mov es,Word Ptr a[2]
       mov bx,Word Ptr a
       push dx
       call CreateHuffmanCodes
       call NormolizeCodes
       pop dx
       mov di,Word Ptr a
       mov bx,Word Ptr b
       mov si,Word Ptr b[2]
       call EnCoding
       mov lng,dx
       mov codes,si
 end;
sz:=lng;
EnCode:=codes;
tblsz:=head.tablesize;
end;

function DeCode(a,b: pointer; codes: word): word;
var sz: word;
begin
 asm
    mov es,Word Ptr a[2]
    mov di,Word Ptr a
    mov bx,Word Ptr b
    mov si,Word Ptr b[2]
    mov byte ptr PrcWriteBits,ReadBits
    mov dx,codes
    call DeCoding
    mov sz,si
 end;
DeCode:=sz;
end;

begin
 PrcReadBits:=ReadBits;
 PrcWriteBits:=WriteBits;
end.