{
  Mouse unit by Alexander Larkin for text mode.

  e-mail:           larkin@titov.msk.ru
  internet:         http://larkin.spa.umn.edu
}

{$G+}
unit mymouse;
INTERFACE
uses dos;

type
      Colors=record
              FCol,BCol: byte;
             end;

const
      xh: word=319;
      yh: word=199;
      colnow: word=7;
      textput: word=0;
      transparentcolor: byte=255; {255 mean automatic load}
      pagebase: word=$a000;
      pagesize: word=19200;
      RPlanes:      array[1..4] of byte=(1,2,3,4);
      BytesPerLine=80;
      GMODE: byte=255;
      vpage: byte=0;
      apage: byte=0;


 MSensibility=1;  {From 1 to n
                   Bigger number - more sensibility.
                   Smaller number - less sensibility}
 MaxX: word=319;  {For graphic change it to 320 or 640}
 MaxY: word=199;  {For graphic change it to 200 or 480}

 LeftB=1;
 RightB=2;
 MiddleB=4;

var InitFont: pointer;

function mouseinit(f: boolean): boolean;
procedure mousekill(f: boolean);
procedure mouse_off;
procedure mouse_on(rl: boolean);
function MouseX: integer;
function MouseY: integer;
function MouseB: byte;
function mouse_in(x,y,x1,y1: integer): boolean;
procedure PutImage(x,y: integer; Pfr,P: pointer; Comp: byte);
procedure Clear(clr: word);  {clean video memory}
procedure Set_320x200;              {You can use 4 video pages!}
procedure set_320x240;              {You can use 3 video pages!}
procedure set_320x400;              {You can use 2 video pages!}
procedure SetWPlaneAsm;  {input: BL - planes}
procedure set_visual_page(page: byte);
procedure set_active_page(page: byte);
procedure CVM(clr: word); {clean video memory}
procedure setRPlaneAsm; {input BH - planes}
function initmouse: boolean;
procedure chcoor(b: byte);
procedure CopyPage(pdst: byte);
procedure DeCompress;
function OutTextXY(x,y: word; s: string): word;

IMPLEMENTATION

type
    MouseType=record case byte of
       1:(bytearray:array[0..199] of byte);
       2:(l,r,m:                boolean;
          s,s1:                 byte;
          Mouse,MON:            boolean;
          MX,MY,Xold,Yold:      integer;
          OldDx,OldEs,OldCx:    word;
          OldSi,OldDi:          integer;
          xh,yh:                integer;
          nooff:                boolean;
          dk,uk,lk,rk,bt:       word;
          mou: boolean;
          vpage,apage: byte;
          MCur,BGis: pointer;
          Show: boolean;
          sS: word;
          );
       end;

const
    Mouse_Interrupt        = $33;
    Left_Button_Released   = 4;
    Right_Button_Released  = $10;
    Left_Button_Pressed    = 2;
    Right_Button_Pressed   = 8;
    Mouse_Moving           = 1;


var mou: mousetype;
    PalZero: array [0..255,0..2] of byte;
    rlw: boolean;

procedure chcoor(b: byte);
begin
 if b=0 then Mou.sS:=0 else if Mou.SS<20 then Inc(Mou.Ss);
 if (b=1) and (Mou.MY-Mou.Ss>=0) then Mou.MY:=Mou.MY-Mou.Ss;
 if (b=1) and (Mou.MY-Mou.Ss<0) then Mou.MY:=0;
 if (b=2) and (Mou.MY+Mou.Ss<=199) then Mou.MY:=Mou.MY+Mou.sS;
 if (b=2) and (Mou.MY+Mou.Ss>199) then Mou.MY:=199;
 if (b=3) and (Mou.MX+Mou.Ss<=319) then Mou.MX:=Mou.MX+Mou.Ss;
 if (b=3) and (Mou.MX+Mou.Ss>319) then Mou.MX:=319;
 if (b=4) and (Mou.MX-Mou.Ss>=0) then Mou.MX:=Mou.MX-Mou.Ss;
 if (b=4) and (Mou.MX-Mou.Ss<0) then Mou.MX:=0;
end;

{30}procedure setRPlaneAsm; assembler; {input BH - planes}
 asm
{2}  mov dx,3ceh
{2}  mov al,4
{10} out dx,al
{2}  add dx,1
{2}  sub bh,1
{2}  mov al,bh
{10} out dx,al
 end;


{393271}procedure Clear(clr: word); assembler; {clean video memory}
{0.024 second on 386 SX 16}
asm
{2}      mov cx,2000          {set cx to clean length}
{2}      mov ax,0b800h        {start address}
{2}      mov es,ax            {move ax to segment register}
{2}      xor di,di            {set di to zero}
{4}      mov ax,clr           {set ax to zero}
{2}      cld                  {cleaning}
@again:
{393210} rep stosw            {cleaning}
{5}      jcxz @next
         jmp @again
@next:
end;

{77}procedure SetRWMode(R,W: byte); assembler;
asm
{2} mov dx,3ceh                   {read MODE value}
{2} mov al,5
{10}out dx,al
{2} inc dx
{12}in al,dx
{2} mov bl,al
{2} and bl,244                    {turn off bits 0,1,3}

{2} mov dx,3ceh                   {set MODE value}
{2} mov al,5
{10}out dx,al
{2} inc dx
{4} mov al,w
{2} and al,3
{4} mov ah,r
{2} and ah,1
{3} shl ah,3
{2} or al,ah
{2} or al,bl
{10}out dx,al
end;

procedure CopyPage(pdst: byte); assembler;
asm
{4} mov bl,15              {Set write to all 4 planes}
{40}Call SetWPlaneAsm

{2}push 0
{2}push 1
{87}call SetRWMode         {Set read mode to 0, write mode to 1}

push ds
push bp

         mov al,BytesPerLine   {BEGIN      ax:=GetMaxY*BytesPerLine}
         xor ah,ah
         xor dx,dx
         mov bx,MaxY
         mul bx                {END        ax:=GetMaxY*BytesPerLine}
         mov cx,ax


{2}      xor dx,dx
{4}      mov bx,PageSize      {begin ds:=$A000+pdst*(PageSize div 16)}
{3}      shr bx,4
{4}      mov al,pdst
{2}      xor ah,ah
{14}     mul bx
{2}      add ax,0a000h
         mov bx,0
         mov ds,PageBase
         mov es,ax
         mov bp,0
                              {end   ds:=$A000+pdst*(PageSize div 16)}

         mov si,bp
         mov di,bx
{         shr cx,2}

         cld

         @again:
         repz movsb  {COPY  CX times from DS:SI to ES:DI}
{         db 0f3h,066h,0a5h} {REPZ MOVSD}
         jcxz @next
         loop @again
         @next:

pop bp
pop ds

{2}push 0
{2}push 0
{87}call SetRWMode         {Set read mode to 0, write mode to 0}

end;


procedure CleanPal; Assembler;
asm
 mov ax,seg(PalZero)
 mov es,ax
 mov ah,10h
 mov al,12h
 mov bx,0
 mov cx,255
 mov dx,offset(PalZero)
 int 10h
end;

{~400}procedure set_320x400; assembler;             {You can use 2 video pages!}
{1/40000 second on 386 SX 16}
asm
{2}  push di            {save DI}

{2}  mov ax,0013h       {set standart mode 13h (320*200*256) using BIOS}
{>33}int 10h
     call CleanPal

{2}  mov dx,3c4h        {chosing register of memory structure}
{2}  mov al,4
{11} out dx,al

{2}  inc dx             {reading register of memory structure}
{13} in al,dx

{2}  and al,11110111b   {set bit D4 to zero}       {I do not understand bit D4}
                    {set bit D3 to one:}
{2}  or al,00000100b    {turn off addressation of even and odd planes of memory}
{11} out dx,al          {writing to register new value}
 {after set new value to this register, video memory like in BIOS mode
 10h and 12h except, for every pixel one byte of memory}

{2}  mov dx,3ceh        {chosing register: working mode of graphic controler}
{2}  mov al,5
{11} out dx,al

{2}  inc dx             {reading it's value}
{13} in al,dx
                    {set bit D5 to zero}
{2}  and al,11101111b   {turn off addressation of even and odd planes of memory}
{11} out dx,al

{2}  dec dx             {chosing register of different things of graphic conroler}
{2}  mov al,6
{11} out dx,al

{2}  inc dx             {reading it's value}
{13} in al,dx
                    {set bit D2 to zero}
{2}  and al,11111101b   {turn off bit that control odd with even planes}
{11} out dx,al

{2}  mov dx,3d4h        {chosing register: height text characters, controler ELT}
{2}  mov al,9
{11} out dx,al
{2}  inc dx
{13} in al,dx
{2}  and al,01100000b   {turn off double scaning}
{11} out dx,al

{2}  dec dx             {chosing register: coordinates underline characters}
{2}  mov al,14h
{11} out dx,al

{2}  inc dx             {turn off double words addressation to video memory}
{13} in al,dx
{2}  and al,10111111b
{11} out dx,al

{2}  dec dx             {chosing register of mode control}
{2}  mov al,17h
{11} out dx,al

{2}  inc dx             {turn on byte addressation to video memory}
{13} in al,dx
{2}  or al,01000000b
{11} out dx,al
{4}  pop di             {load DI}
     mov pagebase,0a000h
     mov pagesize,32000
end;

procedure set_320x240;                      {You can use 3 video pages!}
const CRTCTable: array[1..10] of word=(
                                       $0D06,
                                       $3E07,
                                       $4109,
                                       $EA10,
                                       $AC11,
                                       $DF12,
                                       $0014,
                                       $E715,
                                       $0616,
                                       $E317
                                      );
var w: byte;
begin
InLine($B8/$13/$00/$CD/$10);    { mov ax,013h; int 10h   }
CleanPal;
PageBase:=$A000;
PageSize:=$4B00;
port[$3C4]:=4;              {EGA_SEQUENCER, 4, 6}
port[$3C4+1]:=6;
port[$3D4]:=$17;            {EGA_CRTC, 17h, E3h}
port[$3D4+1]:=$E3;
port[$3D4]:=$14;            {EGA_CRTC, 14h, 0}
port[$3D4+1]:=0;

port[$3C4]:=0;              {EGA_SEQUENCER, 0, 1}
port[$3C4+1]:=1;
port[$3C2]:=$E3;

port[$3C4]:=0;              {EGA_SEQUENCER, 0, 3}
port[$3C4+1]:=3;
port[$3D4]:=$11;            {EGA_CRTC, 11h, w}
w:=port[$3D4+1] and $7F;
port[$3D4]:=$11;            {EGA_CRTC, 11h, w and 7Fh}
port[$3D4+1]:=w;

for w:=1 to 10 do portw[$3D4]:=CRTCTable[w];

port[$3C4]:=2;              {EGA_SEQUENCER, EGA_MAP_MASK, 0Fh}
port[$3C4+1]:=$0F;
GMODE:=1;
end;

procedure Set_320x200; assembler;             {You can use 4 video pages!}
asm
 push di            {save DI}

 mov ax,0013h       {set standart mode 13h (320*200*256) using BIOS}
 int 10h
 call CleanPal

 mov DX,3C4h
 mov AL,4
 out DX,AL

 mov DX,3C4h+1
 mov AL,6
 out DX,AL

 mov DX,3D4h
 mov AL,17h
 out DX,AL

 mov DX,3D4h+1
 mov AL,0E3h
 out DX,AL

 mov DX,3D4h
 mov AL,14h
 out DX,AL

 mov DX,3D4h+1
 mov AL,0h
 out DX,AL

 pop di
 mov gmode,0
 mov pagebase,0a000h
 mov pagesize,19200
end;

{32}procedure SetWPlaneAsm; assembler; {input: BL - planes}
asm
{4} {mov GetWPlane,bl}
                  {turn on writing pixels to n color planes,}
{2} mov dx,03c4h
{2} mov al,2
{10}out dx,al        {will write to second register in port 03c4h}

{2} inc dx
{2} mov al,bl
{10}out dx,al        {writing planes to register: permision of write plane}
end;

{134}procedure set_visual_page(page: byte); assembler;
asm
@next:
{2}   mov dx,03dah
{13}  in ax,dx
{2}   and ax,08h
{2}   cmp ax,0
{~20} je @next
{2}   mov ax,0ch
{2}   mov dx,03d4h
{11}  out dx,ax
{4}   mov al,page
{2}   xor ah,ah
{4}   mov bx,PageSize
{2}   xor dx,dx
{14}  mul bx
{2}   mov bx,ax
{3}   shr ax,8
{2}   mov dx,03d5h
{11}  out dx,ax
{2}   mov ax,0dch
{2}   mov dx,03d4h
{11}  out dx,ax
{2}   and bx,0fh
{2}   mov ax,bx
{2}   mov dx,03d5h
{11}  out dx,ax
      mov al,page
      mov vpage,al
end;

{43}procedure set_active_page(page: byte); assembler;
asm
{2}      xor dx,dx
{4}      mov bx,PageSize      {begin ax:=$A000+pdst*(PageSize div 16)}
{3}      shr bx,4
{4}      mov al,page
{2}      xor ah,ah
{14}     mul bx
{2}      add ax,0a000h        {end   ds:=$A000+pdst*(PageSize div 16)}
{4}      mov pagebase,ax
         mov al,page
         mov apage,al
end;

{393271}procedure CVM(clr: word); assembler; {clean video memory}
{0.024 second on 386 SX 16}
asm
{2}      mov bl,0fh           {turn on write pixels to all 4 color planes}
{40}     call SetWPlaneasm;   {}
{2}      mov cx,32768         {set cx to clean length}
{2}      mov ax,0a000h        {start address}
{2}      mov es,ax            {move ax to segment register}
{2}      xor di,di            {set di to zero}
{4}      mov ax,clr         {set ax to zero}
{2}      cld                  {cleaning}
@again:
{393210} rep stosw            {cleaning}
{5}      jcxz @next
         jmp @again
@next:
end;


procedure Cursor; assembler;
asm
db 11,0,15,0,3,0,1,0,0,1,0,0,1,0,0,1
db 1,0,1,2,0,1,2,0,1,2,0,1,2,1,1
db 2,2,1,2,1,1,1,0,1,1,0,0,0,1,0
db 0,1,0,0,0,3,0,1,0,0,2,0,0,2,0,0,2
db 0,0,2,1,0,2,2,0,2,2,0,2,2,0,2
db 2,1,2,2,1,2,2,0,1,2,0,0,1,0,0
db 1,0,0,0,0,2,0,0,0,1,0,2,0,2,0,2
db 0,2,1,2,2,2,2,2,2,2,1,1,2,0
db 2,0,2,0,2,0,1,2,0,0,0,0,0,1,0,2
db 0,2,0,2,0,2,1,2,2,2,2,1,1,0,1
db 0,1,0,2,0,2,0,1,95
end;

function mouse_in(x,y,x1,y1: integer): boolean;
begin
 if (mou.MX>x) and (mou.MX<x1) and (mou.MY>y) and (mou.MY<y1) then mouse_in:=true else mouse_in:=false;
end;

{Decompress block from ES:[BX] to DS:[SI]}
procedure DeCompress; Assembler;
asm
{********************************************}
   mov ax,word ptr es:[bx]{Table size to AX}
   and ax,32767
   add bx,2
   mov bp,bx
   xor di,di
   mov cl,3
   shl ax,cl
   add bx,ax
   mov dx,word ptr es:[bx]{Number of codes to ax}
   add bx,2
   mov cl,0
   mov al,byte ptr es:[bx]

@NextStep:
   mov ch,al
   shr ch,cl
   and ch,1
   inc cl
   cmp cl,8
   jne @ClOk
   xor cl,cl
   inc bx
   mov al,byte ptr es:[bx]
   @ClOk:
   cmp ch,1
   je @GoRightSubTree

   mov di,word ptr es:[bp+di+4]
   cmp word ptr es:[bp+di+2],0ffffh
   je @NextStep

   jmp @AddCode

   @GoRightSubTree:

   mov di,word ptr es:[bp+di+6]
   cmp word ptr es:[bp+di+2],0ffffh
   je @NextStep

  @AddCode:

   mov ah,byte ptr es:[bp+di+2]
   mov byte ptr ds:[si],ah
   xor di,di
   inc si
   dec dx
   cmp dx,0
   jne @NextStep

{********************************************}
end;

procedure PutImage(x,y: integer; Pfr,P: pointer; Comp: byte); assembler;
var TextO,ww: word;
    tc: byte;
    Col: colors;
    minx,miny,maxx,maxy: integer;
asm
   push xh
   push yh
   pop MaxY
   pop MaxX

   push Word Ptr ColNow
   pop Word Ptr Col
   push Word Ptr TextPut
   pop Word Ptr TextO
   mov bl,TransparentColor
   mov tc,bl

{2}push di
{2}push si
{2}push bp
{2}push ds

{4}mov bx,word(Pfr)         {bx:=ofs(P^)}
{4}mov es,word(Pfr+2)       {es:=seg(P^)}

    mov ax,x
    cmp ax,MaxX
    jg @nooutatall

    add ax,es:[bx]
    cmp ax,0
    jl @nooutatall

{4} mov ax,y              {begin  bp:=(BytesPerLine*y) mod 16}

    cmp ax,MaxY
    jg @nooutatall

    push ax
    add ax,es:[bx+2]
    cmp ax,0
    pop ax
    jl @nooutatall

 cmp Comp,0
 je @NotCompressed

   {*****}
{   cmp byte ptr es:[bx+4],255
   jne @NotCompressed}
    mov ds,word ptr P[2]
    mov si,word ptr P
     push word ptr es:[bx]
     push word ptr es:[bx+2]
     pop word ptr ds:[si+2]
     pop word ptr ds:[si]
     add bx,4
     add si,4
    call DeCompress
    pop ds
    pop bp
     mov ax,y
     mov bx,word(P)         {bx:=ofs(P^)}
     mov es,word(P+2)       {es:=seg(P^)}
    push bp
    push ds
   {*****}

@NotCompressed:

    mov dl,byte ptr TC
    cmp dl,255
    jne @TCok
{4} mov dl,byte ptr es:[bx+6]
    @TCok:
    xor dh,dh
    push dx {Save transperent color for al}

    push ax {save y (in dx)}

    cmp ax,0
    jl @yinttype
    jmp @noytype

    @yinttype:
    push bx
    mov bx,65535
    sub bx,ax
    add bx,1
    mov ax,bx
    pop bx

    @noytype:

{4} mov cl,80             {begin  ax:=(BytesPerLine*y) div 16+PageBase}
{2} xor ch,ch
{2} xor dx,dx
{14}mul cx
{2} mov cx,16
{2} xor dx,dx
{22}div cx

{4}  mov cx,x              {begin  ax:=ax+x div 4}
     mov di,cx

     cmp cx,0
     jl @inttype           {if integer(cx)<0 then goto @intttype}

{2}  push cx
{3}  shr cx,2
{2}  mov si,cx
     add si,32768
{4}  pop cx
     jmp @sidone

     @inttype:
     push cx
     push bx
     mov bx,65535
     sub bx,cx
     mov cx,bx
     shr cx,2
     mov si,32767
     sub si,cx
     pop bx
     pop cx

@sidone:

{2} add si,dx             {end    si:=(BytesPerLine*y) mod 16}

    pop dx {Load Y}
    cmp dx,0
    jl @int_sub_instead
{4} add ax,pagebase       {end    ax:=(BytesPerLine*y) div 16+PageBase}
    jmp @subdone
    @int_sub_instead:

    push dx {Save Y}
    mov dx,ax
    mov ax,pagebase
    sub ax,dx
    pop dx  {Load Y}

    @subdone:

    sub ax,2048

{2}push ax                {begin  ds:=ax}


{2} and cx,3              {First plane where to put}
{2} mov ch,cl
{2} add ch,4


{4}pop ds                 {end    ds:=ax}
   pop ax {Load in al transperent color}

{4} mov ah,es:[bx+2]      {end    ah:=height (height from 0 to 255!)}
{2} add bx,4


   @1:
{2}push bx                    {begin  SetWPlane(WPlanes[cl and 3+1])}
{2}push dx
{2}push ax
{2}push cx

{2} and cl,3
{2} mov bl,1
{2} xor bh,bh
{3} shl bl,cl
{40}call SetWPlaneAsm
{4}pop cx
{4}pop ax
{4}pop dx
{4}pop bx                     {end    SetWPlane(WPlanes[cl and 3+1])}

{2}push si
{2}push cx

   push di

   sub ch,cl
   mov cl,4
   sub cl,ch
   xor ch,ch
   add di,cx

{2}mov cx,Word Ptr es:[bx]
   mov Word Ptr ww,cx
{2}add bx,2
{2}mov cl,ah
   xor ch,ch

   push ax
   push dx
    @2:
       cmp dx,MaxY
       ja @nostringout

{2}    push cx
{2}    push si
       push di
{2}    mov cx,0

        @3:

       cmp di,MaxX
       ja @noout           {If word(di)>319 then goto @noout}

{2}    mov ah,es:[bx]

        cmp TextO,0
        je @OkPut
        cmp ah,1
        jne @Text1
        mov ah,Col.BCol
        jmp @OkPut
 @Text1:
        mov ah,Col.FCol
 @OkPut:

{2}    cmp ah,al
{7}    je @noout

{2}    mov ds:[si],ah

@noout:
       add di,4

{2}      inc si
@nooutadd:

{2}      inc bx

{2}      inc cx
{2}      cmp cx,ww
{7}     jne @3
       pop di
{4}    pop si
{4}    pop cx

jmp @normoutdone

   @nostringout:
   add bx,ww

   @normoutdone:
   inc dx

{2}    add si,80
{2}   dec cx

{2}  cmp cx,0
{7} jne @2
   pop dx
   pop ax

   pop di
{4}pop cx
{4}pop si

{2}inc cl                     {next plane}

{2}cmp cl,4
{7}jne @ok
{2}inc si
@ok:


{2}cmp cl,ch
{7}jne @1

@nooutatall:

{4}pop ds
 {4}pop bp
{4}pop si
{4}pop di
end;

procedure mget_image(x,y,x1,y1: word; P: pointer);
var w,h,a,b,w1,xd4: word;
    bb,nowpl,endpl: byte;
    DSP: pointer;
begin
w:=abs(x1-x) div 4;
h:=abs(y1-y);
memw[seg(P^):ofs(P^)]:=w;
memw[seg(P^):ofs(P^)+2]:=h;
P:=ptr(seg(P^),ofs(P^)+4);
nowpl:=x mod 4;
endpl:=x1 mod 4;
xd4:=x div 4;

for b:=1 to 4 do
begin
if 0<endpl-nowpl then w1:=w+1 else w1:=w;
memw[seg(P^):ofs(P^)]:=w1;
P:=ptr(seg(P^),ofs(P^)+2);
bb:=RPlanes[nowpl+1];
asm
mov bh,bb
call SetRPlaneAsm
end;

for a:=y to y1-1 do
 begin
  DSP:=ptr(PageBase,a*BytesPerLine+xd4);
  move(DSP^,P^,w1);
  P:=ptr(seg(P^),ofs(P^)+w1);
 end;

nowpl:=nowpl+1;
if nowpl>3 then begin; nowpl:=0; xd4:=xd4+1; endpl:=0;  end;
end;
{P:=ptr(seg(P^),ofs(P^)-4-w*h-8);}
end;

Procedure WaitVRetrace; assembler;
asm
     MOV  DX,3DAh
@L1: IN   AL,DX
     TEST AL,08h
     JNZ  @L1
end;

Procedure WaitRetrace; assembler;
asm
     MOV  DX,3DAh
@L1: IN   AL,DX
     TEST AL,08h
     JNZ  @L1
@L2: IN   AL,DX
     TEST AL,08h
     JZ   @L2
end;

procedure mouse_on(rl: boolean);
var was: byte;
begin
   if mou.mou=true then exit;
   Mou.Xold:=Mou.MX;
   Mou.Yold:=Mou.MY;
   if rl then
    begin
     mou.vpage:=VPage;
     mou.apage:=APage;
     Set_Active_Page(VPage);
     was:=TransparentColor;
     TransparentColor:=0;
     mget_image(mou.Xold,mou.Yold,mou.Xold+16,
                mou.Yold+16,mou.BGis);
     PutImage(mou.Xold,mou.Yold,mou.MCUR,nil,0);
     TransparentColor:=was;
     Set_Active_Page(mou.apage);
     mou.Mon:=true;
    end;
   mou.mou:=true;
end;

procedure mouse_off;
var was: word;
begin
   if mou.mou=false then exit;
   mou.apage:=APage;
   if Mou.mon then
    begin
     Set_Active_Page(vpage);
     was:=TransparentColor;
     TransparentColor:=250;
     PutImage(mou.Xold,mou.Yold,mou.BGis,nil,0);
     TransparentColor:=was;
     Set_Active_Page(apage);
     Mou.mon:=false;
    end;
   mou.mou:=false;
end;

{$F+}
PROCEDURE Mouse_Handler
           (Flags, CS, IP, AX, BX, CX, DX, SI, DI, DS, ES, BP :Word);
INTERRUPT;

BEGIN
mou.xh:=0;
mou.yh:=0;
mou.xh:=integer(integer(mou.rk)-integer(mou.lk));
mou.yh:=integer(integer(mou.uk)-integer(mou.dk));

if mou.xh=0 then if mou.oldSI<>0 then mou.xh:=integer(SI)-mou.oldSI else mou.xh:=0;
if mou.yh=0 then if mou.oldDI<>0 then mou.yh:=integer(DI)-mou.oldDI else mou.yh:=0;
   mou.xh:=mou.xh div MSensibility;
   mou.yh:=mou.yh div MSensibility;
mou.oldSI:=integer(SI);
mou.oldDI:=integer(DI);

if mou.Mou and
   ((mou.xh<>0) or (mou.yh<>0)) then
 begin
  rlw:=Mou.mon;
  if mou.mouse then mouse_off else mou.nooff:=true;

  if (mou.xh>=0) and (mou.MX+mou.xh<MaxX) then mou.MX:=mou.MX+mou.xh
  else if mou.xh>=0 then mou.MX:=MaxX;
  if (mou.yh>=0) and (mou.MY+mou.yh<Maxy) then mou.MY:=mou.MY+mou.yh
  else if mou.yh>=0 then mou.MY:=Maxy;
  if (mou.xh<0) and (mou.MX+mou.xh>=0) then mou.MX:=mou.MX+mou.xh
  else if mou.xh<0 then mou.MX:=0;
  if (mou.yh<0) and (mou.MY+mou.yh>=0) then mou.MY:=mou.MY+mou.yh
  else if mou.yh<0 then mou.MY:=0;

  if not mou.nooff then mouse_on(rlw);
 end;



   { DONE IN ASSEMBLY TO INCREASE SPEED }
  InLine (
    $8B/$E5/
    $5D/
    $07/
    $1F/
    $5F/
    $5E/
    $5A/
    $59/
    $5B/
    $58/
    $CB);
END; { PROCEDURE Mouse_Handler }
{$F-}

function initmouse: boolean;
VAR
  Reg : Registers;
BEGIN
      Reg.AX := 0;
      INTR (Mouse_Interrupt, Reg);
      mou.mouse := (Reg.AX <> 0);
      if mou.mouse then initmouse:=true else initmouse:=false;
END;

{############ INTERRUPT # 12 RESTORE PREVIOUS INTERRUPT CALL ############}
PROCEDURE Restore_Mouse_Interrupt_Handler;
VAR
  Reg : Registers;
BEGIN
  Reg.AX := $0C;
  { ANY OF THESE EventS WILL ACTIVATE THE INTERRUPT }
  Reg.CX := mou.OldCx;
  Reg.DX := mou.OldDx;
  Reg.ES := mou.OldEs;
  INTR (Mouse_Interrupt, Reg);
  mou.OldDx:=Reg.dx;
  mou.OldEs:=Reg.es;
  mou.OldCx:=Reg.cx;
END;

{############ INTERRUPT # 12 INSTALL MY OWN INTERRUPT CALL ############}
PROCEDURE Install_Mouse_Interrupt_Handler;
VAR
  Reg : Registers;
BEGIN
  Reg.AX := $14;
  { ANY OF THESE EventS WILL ACTIVATE THE INTERRUPT }
  Reg.CX := Left_Button_Released +
            Right_Button_Released +
            Left_Button_Pressed +
            Right_Button_Pressed +
            Mouse_Moving;

  Reg.DX := Ofs(Mouse_Handler);               { KEEP OLD VECTOR TABLE }
  Reg.ES := Seg(Mouse_Handler);
  INTR (Mouse_Interrupt, Reg);
  mou.OldDx:=Reg.dx;
  mou.OldEs:=Reg.es;
  mou.OldCx:=Reg.cx;
END;

function mouseinit(f: boolean): boolean;
var b: boolean;
begin
 getmem(mou.BGis,1000);
 Mou.MCur:=Addr(Cursor);
 Mou.Show:=false;
 Mou.Mou:=false;
 mou.oldSI:=0;
 mou.oldDI:=0;
 mou.MX:=MaxX div 2;
 mou.MY:=MaxY div 2;
 if f then
  begin
   b:=initmouse;
   if b then
    begin
     Install_Mouse_Interrupt_Handler;
     mouseinit:=b;
     mouse_on(true);
    end else mouseinit:=false;
  end else mouse_on(true);
end;

procedure mousekill(f: boolean);
begin
mouse_off;
freemem(mou.BGis,1000);
if f then restore_mouse_interrupt_handler;
end;

function MouseX: integer;
begin
 MouseX:=mou.mx;
end;

function MouseY: integer;
begin
 MouseY:=mou.my;
end;

function MouseB: byte;
      var R: registers;
          b: byte;
begin
    R.ax:=3;
    Intr(51,R);
    mou.l:=(R.bx mod 2) = 1;
    mou.r:=(R.bx div 2) = 1;
    mou.m:=(R.bx div 3) = 1;
    B:=byte(mou.l)+byte(mou.r)*2+byte(mou.m)*4;
    MouseB:=b;
end;

function putchar(x,y: word; ch: char): word;
var db: word;
    P: pointer;
    B: byte;
begin
 if (ord(ch)<32) or (ord(ch)>240) then
  begin
   PutChar:=2;
   exit;
  end;
 db:=memw[seg(InitFont^):ofs(InitFont^)+7];
 db:=memw[seg(InitFont^):ofs(InitFont^)+db+2+(ord(ch)-32)*4];
 P:=ptr(seg(InitFont^),ofs(InitFont^)+db);
 b:=TransparentColor;
 TransparentColor:=0;
 TextPut:=$ffff;
 PutImage(x,y,P,nil,0);           {(background) 255 is transparent color}
 TextPut:=0;
 TransparentColor:=b;
 putchar:=memw[seg(P^):ofs(P^)];
end;


function OutTextXY(x,y: word; s: string): word;
var b: byte;
    x1: word;
begin
x1:=x;
for b:=1 to length(s) do x:=x+putchar(x,y,s[b]);
OutTextXy:=x-x1;
end;

end.

