unit mysounds;

INTERFACE
uses smix,getsb,detect;

type
     SoundType=record
                rus: array[0..2] of PSound;  { Russian sounds }
                eng: array[0..2] of PSound;  { English sounds }
                num: word;    { Sound type    }
                l: byte;      { Number of sounds }
               end;

     AllSounds=record
                LevStart: word;
                TakeImage: word;
                BFD: word;
               end;

const
    MusFile        = 'GAME.SND'; { File with sounds }
    XMSRequired    = 1000;    {XMS memory required to load the sounds (KBytes) }
    SharedEMB      = true;
    CurSound: word = 0;
    MAXSound       = 20;
      {TRUE:   All sounds will be stored in a shared EMB}
      {FALSE:  Each sound will be stored in a separate EMB}

var SB: boolean;
    BaseIO: word; IRQ, DMA, DMA16: byte;
    Sounds: array[0..MaxSound] of SoundType;
    SND: AllSounds;
    Lang: boolean;

function TurnOnSB: boolean;
procedure KillSounds;
procedure FreeSounds;
procedure MyStartSound(num,tp: word; b: boolean; sn: word);

IMPLEMENTATION

  function LoadSounds: byte;
    var
      i: integer;
      ld: boolean;
    begin
         if not(InitXMS) then LoadSounds:=1 else
          begin
            if GetFreeXMS < XMSRequired then LoadSounds:=2 else
                begin
                  if SharedEMB then InitSharing;
                  if not(OpenSoundResourceFile(MusFile)) then LoadSounds:=3 else
                   begin
                    ld:=true;
                    LoadSounds:=0;
                    if not ld then LoadSounds:=4;
                   end;
                end;
          end;
    end;

function TrySb: byte;
begin
  TrySb:=0;
  BaseIO:=SBInt;
  IRQ:=SBIrq;
  DMA:=1;
  DMA16:=1;
  if not(InitSB(BaseIO, IRQ, DMA, DMA16)) then TrySb:=2;
end;


function TurnOnSB: boolean;
var SbOk: boolean;
begin
SbOk:=true;
TurnOnSB:=false;
 if TrySB=2 then
    begin
     SbOk:=true;
      if not(GetSettings(BaseIO,IRQ,DMA,DMA16)) then
     Begin
      SbOk:=false;
      writeln('Error initializing:  Invalid or non-existant BLASTER environment variable');
     End else if not(InitSB(BaseIO, IRQ, DMA, DMA16)) then
     Begin
      SbOk:=false;
      writeln('Error initializing sound card');
      writeln('Incorrect base IO address, sound card not installed, or broken');
     End;
    End;

 if SbOk then
    begin
     InitMixing;
     case loadsounds of
      0:     begin
              TurnOnSB:=true;
              writeln('Sound blaster library by Ethan Brodsky initializated.');
             end;
      1:     begin
              writeln('Error initializing extended memory');
              writeln('HIMEM.SYS must be installed');
             end;
      2:     begin
              writeln('Insufficient free XMS');
              writeln('You are probably running this game from the protected mode IDE');
              writeln('Run it from the command line or read the documentation');
             end;
      3:     writeln('Error loading sound resource file');
      4:     writeln('Cannot load one of the sounds.');
     end;
    end;
end;


  procedure Shutdown;
    begin
      ShutdownMixing;
{      StopDAC;}
      ShutdownSB;
    end;

  procedure FreeSounds;
    var
      i: integer;
      b: byte;
    begin
      if CurSound>0 then
      for i := 0 to CurSound-1 do
       if Sounds[i].l>0 then
        for b:=0 to Sounds[i].l-1 do
         Begin
          if Sounds[i].rus[b]<>nil then FreeSound(Sounds[i].rus[b]);
          if Sounds[i].eng[b]<>nil then FreeSound(Sounds[i].eng[b]);
         End;
     if SharedEMB then ShutdownSharing;
     FillChar(SND,SizeOf(SND),255);
    end;

Procedure KillSounds;
Begin
 if sb then
  begin
   CloseSoundResourceFile;
   Shutdown;
   FreeSounds;
  end;
End;

Procedure MyStartSound(num,tp: word; b: boolean; sn: word);
var t: byte;
Begin
 if (CurSound=0) or (num>CurSound-1) then exit;
 if Sounds[num].l>1 then t:=random(Sounds[num].l) else t:=0;
 if Lang then StartSound(Sounds[num].eng[t],sn,b) else
              StartSound(Sounds[num].rus[t],sn,b);
End;

Begin
FillChar(SND,SizeOf(SND),255);
FillChar(Sounds,SizeOf(Sounds),0);
Lang:=true;
End.
