unit newmouse;
INTERFACE
uses GoodVga,CmfPas;

var mousehnd: integer;

const CmfFreq: word=4096;
      CmfStarted: boolean=false;

type
StandartKeys=record
              ESC: boolean;
              numbers: array[1..10] of boolean;
              minus,plus: boolean;
              BackSpace: boolean;
              tab: boolean;
              chars1: array[1..10] of boolean;
              LeftScb,RightScb: boolean;
              Enter: boolean;
              ctrl: boolean;
              chars2: array[1..9] of boolean;
              tchkzpt: boolean;
              opostr: boolean;
              tilda: boolean;
              lshift: boolean;
              SlashRight: boolean;
              chars3: array[1..7] of boolean;
              zpt,tchk,slash: boolean;
              rshift: boolean;
              zvezda: boolean;
              alt: boolean;
              space: boolean;
              CapsLock: boolean;
              fkeys: array[1..10] of boolean;
              NumLock: boolean;
              ScrollLock: boolean;
              Home,Up,PgUp: boolean;
              KeyPadMinus: boolean;
              Left,KeyPad5,Right: boolean;
              KeyPadPlus: boolean;
              EndKey,Down,PgDn,Ins: boolean;
              DeleteKey: boolean;
             end;

var Key: ^StandartKeys;
    PrevKey: ^StandartKeys;
    TimerOn: boolean;
    NeedCall: byte;
    OldExitProc: pointer;
    PlayTime: longint;
    ErrorIs: boolean;
    NotAVL: boolean;
    CnstGame: word;

procedure SetTimerCnst(freq: word);
Procedure KeyBoardReset;
Procedure SetIntVec(b: byte; p: pointer);
Function GetIntVec(b: byte): pointer;
Procedure Init_Mouse;
Procedure MouseShow;
Procedure MouseHide;
Procedure Delay(l: word);
Procedure Kill_Mouse;
Procedure KillKeyboard;
Procedure InitKeyBoard;
Procedure InitTimer;
Procedure KillTimer;
procedure SetBar(x,y,x1,y1: word);
Function TimeConstant: word;
Function ReadKey: char;
Function KeyPressed: boolean;
Function MouseButton: byte;
Function RightButton: boolean;
Function LeftButton: boolean;
Function RightBPress: boolean;
Function LeftBPress: boolean;
Function MouseX: word;
Function MouseY: word;
Function MouseInBar(x,y,x1,y1: integer): boolean;
Procedure TimerProcedureOn(P: pointer);
Procedure TimerProcedureOff;
Function MemorySize: longint;
Function BigCounter: longint;
Function MousePointer: pointer;
Function KeyPush: boolean;
Procedure ResetTimerCnst;
Procedure SetTimeConstant(w: word);

IMPLEMENTATION

const TimerFreq: word=4096; {About 291 tiks per second}
      MaxX: word=319;
      MaxY: word=239;
      MinX: word=0;
      MinY: word=0;

type  MouseBlock=record
                  Mou: boolean;
                  Show: boolean;
                  APage: byte;
                  VPage: byte;
                  XOld,YOld: integer;
                  BGis: pointer;
                  BGcur: boolean;
                  MCur: pointer;
                  MX,MY: integer;
                  XH,YH: integer;
                  OldSI,OldDI: integer;
                  OldDX,OldES,OldCX: word;
                  LBut,RBut: boolean;
                  FLBut,FRBut: boolean;
                  PrevLBut,PrevRBut: boolean;
                  PrevBX: word;
                  InInt: boolean;
                 end;

  Keys=record case byte of
           1:(InfoBytes:array[1..255] of boolean);
           2:(a: StandartKeys;
              );
           end;

      KBDtype=record
               Key: keys;
               PrevKey: keys;
               KeyPressed: boolean;
               KeyBuf: array[0..255] of char;
               LKey: byte;
               move: byte;
               xa,ya: integer;
               ScrollLock: boolean;
               NumLock: boolean;
               CapsLock: boolean;
              end;

var  Mou: MouseBlock;
     Mouse: boolean;
     KBD: KBDtype;
     TimeCounter: longint;
     OldInt1C,OldInt9: pointer;
     Inc1C,Int9: boolean;
     Lights: byte;
     Timer18: word;
     TimeProc: procedure;
     Delaycnst,Cnst18: word;
     IMIH,KPSH: boolean;
     TimeStop: longint;
     INN: boolean;
     STOPHALT,RHalt: boolean;

    Int1C: boolean;
    MouseTimeProc: procedure;

{$F+,S-}

{############ INTERRUPT # 12 RESTORE PREVIOUS INTERRUPT CALL ############}
PROCEDURE Restore_Mouse_Interrupt_Handler; Assembler;
asm
 mov ax,0ch
 mov cx,mou.OldCX
 mov dx,mou.OldDX
 mov es,mou.OldES
 int 033h
 mov mou.OldDX,DX
 mov mou.OldES,ES
 mov mou.OldCX,CX
end;

Procedure RegisterHalt;
begin
 if inn then exit;
 if TimeConstant>TimeStop then PlayTime:=PlayTime+TimeConstant-TimeStop;
 TimeStop:=TimeConstant;
 if abs(PlayTime)>32000 then RHalt:=true;
 if STOPHALT or (RHalt=false) then exit;
 HaltIsOn:=false;
 STOPHALT:=true;
 RHalt:=false;

      CloseGoodVga;
      FreeAlg;

 WriteLn(' - Demo End');
 WriteLn('**************************************************************');
 WriteLn('1750 seconds demo finished.');
 WriteLn('Send request to this e-mail address: avlarkin@iname.ru');
 WriteLn;
 WriteLn('You''ll receive the latest and full version of this game!');
 WriteLn('More graphic and smart levels in this game.');
 WriteLn('Just send me e-mail.');
 WriteLn;
 WriteLn('Author of AVL GRAPH library is Alexander Larkin.');
 WriteLn('Send requst to receive the latest and full version of this library.');
 WriteLn;
 WriteLn;
 WriteLn('Thanks for using AVL GRAPH library demo version.');
 WriteLn('WWW:    http://www.geocities.com/SiliconValley/6235/tpdl.htm');
 WriteLn;
 halt;
end;

procedure SetBar(x,y,x1,y1: word);
begin
 MinX:=x;
 MinY:=y;
 MaxX:=x1;
 MaxY:=y1;
end;

procedure Kill_Mouse;
begin
 if Mouse=false then exit;
 Mouse:=false;
 if IMIH then Restore_Mouse_Interrupt_Handler;
 if mou.BGcur then if mou.BGis<>nil then freemem(mou.BGis,1000);
end;

procedure Delay(l: word);
var t,t1,dif: longint;
    b: byte;
begin
 if RHalt then if INN=false then RegisterHalt;
 b:=Test8086;
 Test8086:=0;
 if Int1c=false then
  begin
   t:=memw[$40:$6C];
    repeat
     t1:=memw[$40:$6C];
     if t1>t then dif:=t1-t else dif:=t-t1;
    until (dif>=l div 55);
  end else
  begin
   t:=TimeCounter;
    repeat
     t1:=TimeCounter;
     if t1>t then dif:=t1-t else dif:=t-t1;
    until (dif>=(longint(l) div delaycnst)) or (Key^.ESC);
  end;
 Test8086:=b;
end;

procedure mouse_off;
var was: byte;
begin
   if mou.mou=false then exit;
   if not GraphOn then exit;
   mou.apage:=APageNum;
   Set_Active_Page(mou.vpage);
   was:=TransparentColor;
   SetTransparentColor(250);
   if mou.BGcur then PutImage(mou.Xold,mou.Yold,mou.BGis);
   SetTransparentColor(was);
   Set_Active_Page(mou.apage);
   mou.mou:=false;
end;

procedure mouse_on;
var was: byte;
begin
 if not GraphOn then exit;
 if mou.mou then exit;
 Mou.Xold:=Mou.MX;
 Mou.Yold:=Mou.MY;
 mou.vpage:=VPageNum;
 mou.apage:=APageNum;
 Set_Active_Page(VPageNum);
 was:=TransparentColor;
 SetTransparentColor(0);
 if mou.BGcur then getimage(mou.Xold,mou.Yold,mou.Xold+16,
                            mou.Yold+16,mou.BGis);
 PutImage(mou.Xold,mou.Yold,mou.MCUR);
 SetTransparentColor(was);
 Set_Active_Page(mou.apage);
 mou.mou:=true;
end;

var b: byte;
    ws: boolean;

procedure TimerHandler; Interrupt;
  begin
   InLine($fa);  {CLI}
   ws:=INN;
   INN:=true;
   b:=test8086;
   test8086:=0;
   inc(TimeCounter);
   if TimeCounter mod cnst18=0 then inc(Timer18);

    if TimeCounter mod CnstGame=0 then if
    NeedCall<255 then inc(NeedCall);
    if (@TimeProc<>nil) and (NeedCall>0) and TimerOn then
     begin
      while NeedCall>0 do
       Begin
        TimeProc;
        if NeedCall>0 then dec(NeedCall);
       End;
     end;


     if (KBD.move<>0) and (TimeCounter mod 4=0) then
     begin
      if Mou.show then mouse_off;
      if (KBD.xa>0) and (mou.mx+KBD.xa<MaxX) then mou.mx:=mou.mx+KBD.move else
      if (KBD.xa>0) then Mou.mx:=MaxX;
      if (KBD.ya>0) and (mou.my+KBD.ya<MaxY) then mou.my:=mou.my+KBD.move else
      if (KBD.ya>0) then Mou.my:=MaxY;
      if (KBD.xa<0) and (mou.mx+KBD.xa>MinX) then mou.mx:=mou.mx-KBD.move else
      if (KBD.xa<0) then Mou.mx:=MinX;
      if (KBD.ya<0) and (mou.my+KBD.ya>MinY) then mou.my:=mou.my-KBD.move else
      if (KBD.ya<0) then Mou.my:=MinY;
      if Mou.show then mouse_on;
     end;

    { Timer ISR }
    {*** Refer to DDK and DPMI Specs for creating ISR's ***}
    test8086:=b;
    INN:=ws;
    InLine($fb);  {STI}
  end;

PROCEDURE Mouse_Handler
           (Flags, CS, IP, AX, BX, CX, DX, SI, DI, DS, ES, BP :Word);
INTERRUPT;

BEGIN
InLine($fa);  {CLI}
mousehnd:=10;
ws:=INN;
INN:=true;
if KBD.ScrollLock=false then
 begin
   if mou.LBut and (bx and 1=0) then mou.PrevLBut:=true;
   if mou.RBut and (bx and 2=0) then mou.PrevRBut:=true;
   if (not mou.LBut) and (bx and 1=1) then mou.FLBut:=true;
   if (not mou.RBut) and (bx and 2=2) then mou.FRBut:=true;
   mou.LBut:=boolean(bx and 1);
   mou.RBut:=boolean(bx and 2 div 2);

   mou.xh:=0;
   mou.yh:=0;

   if mou.oldSI<>0 then mou.xh:=integer(SI)-mou.oldSI else mou.xh:=0;
   if mou.oldDI<>0 then mou.yh:=integer(DI)-mou.oldDI else mou.yh:=0;
   mou.oldSI:=integer(SI);
   mou.oldDI:=integer(DI);

   if (mou.xh<>0) or (mou.yh<>0) then
    begin
      if Mou.Show then mouse_off;
      if (mou.xh>=0) and (mou.MX+mou.xh<maxx) then mou.MX:=mou.MX+mou.xh
      else if mou.xh>=0 then mou.MX:=maxx-1;
      if (mou.yh>=0) and (mou.MY+mou.yh<maxy) then mou.MY:=mou.MY+mou.yh
      else if mou.yh>=0 then mou.MY:=maxy-1;
      if (mou.xh<0) and (mou.MX+mou.xh>=MinX) then mou.MX:=mou.MX+mou.xh
      else if mou.xh<0 then mou.MX:=MinX;
      if (mou.yh<0) and (mou.MY+mou.yh>=MinY) then mou.MY:=mou.MY+mou.yh
      else if mou.yh<0 then mou.MY:=MinY;
      if Mou.Show then mouse_on;
    end;

   mou.InInt:=true;
 end; {If scroll-lock then keyboard mouse control}
  INN:=ws;
  InLine($fb);  {STI}

   { DONE IN ASSEMBLY TO INCREASE SPEED }
  InLine (
    $8B/$E5/
    $5D/
    $07/
    $1F/
    $5F/
    $5E/
    $5A/
    $59/
    $5B/
    $58/
    $CB);
END; { PROCEDURE Mouse_Handler }

function scan2char(kp: byte): char;
const  Standar: string=#27+'1234567890-='+#8+#9+'qwertyuiop[]'+#13+#255+
                       'asdfghjkl;'+#39+'`'+#255+'\zxcvbnm,./'+#255+'*'+
                       #255+' '+#255+#0+#0+#0+#0+#0+#0+#0+#0+#0+#0+#255+
                       #255+#0+#0+#0+'-'+#0+#255+#0+'+'+#0+#0+#0+#0+#0;
     WithShift: string=#27+'!@#$%^&*()_+'+#8+#9+'QWERTYUIOP{}'+#13+#255+
                       'ASDFGHJKL:"'+'~'+#255+'|ZXCVBNM<>?'+#255+'*'+
                       #255+' '+#255+#0+#0+#0+#0+#0+#0+#0+#0+#0+#0+#255+
                       #255+#0+#0+#0+'-'+#0+#255+#0+'+'+#0+#0+#0+#0+#0;

      SpecKey: string=#32+'            '+#32+#32+'            '+#32+#32+
                      '           '+' '+#32+'           '+#32+' '+
                      #32+' '+#32+';<=>?@ABCD'+#32+
                      #32+'GHI K'+#32+'M OPQRS';

var ch: char;

begin
   if (KBD.Key.a.lshift=false) and (KBD.Key.a.rshift=false) then
          ch:=Standar[kp] else
          ch:=WithShift[kp];
   if (ch<>#255) and (KBD.LKey<254) then
    begin
     KBD.KeyBuf[KBD.LKey]:=ch;
     inc(KBD.Lkey);
     if (ch=#0) then
      begin
       KBD.KeyBuf[KBD.LKey]:=SpecKey[kp];
       inc(KBD.LKey);
      end;
     KBD.KeyPressed:=true;
    end;
end;

var KP: byte;

procedure KeyHandler; interrupt;
  begin
   InLine($fa);  {CLI}
   ws:=INN;
   INN:=true;
   KP:=port[$60];

   if KP<128 then
    begin
     if KBD.Key.InfoBytes[KP]=false then KPSH:=true;
     KBD.Key.InfoBytes[KP]:=true;
    end else
    begin
     if KBD.Key.InfoBytes[KP-128]=true then KPSH:=true;
     KBD.Key.InfoBytes[KP-128]:=false;
     KBD.PrevKey.InfoBytes[KP-128]:=true;
    end;

    if KBD.ScrollLock and
       (KBD.Key.a.Right or
        KBD.Key.a.Left or
        KBD.Key.a.Down or
        KBD.Key.a.Up or
        KBD.Key.a.space or
        KBD.Key.a.alt or
        (Mou.LBut and (KBD.Key.a.space=false)) or
        (Mou.RBut and (KBD.Key.a.alt=false)))
        and GraphOn then
     begin
      if (mou.RBut=false) and KBD.Key.a.Alt then mou.FRBut:=true;
      if (mou.LBut=false) and KBD.Key.a.Space then mou.FLBut:=true;
      if mou.RBut and (KBD.Key.a.alt=false) then mou.PrevRBut:=true;
      if mou.LBut and (KBD.Key.a.space=false) then mou.PrevLBut:=true;
      if KBD.Key.a.alt then mou.RBut:=true else mou.RBut:=false;
      if KBD.Key.a.space then mou.LBut:=true else mou.LBut:=false;
      if KBD.move<10 then inc(KBD.move);
      if KBD.Key.a.Right then KBD.xa:=KBD.move else
      if KBD.Key.a.Left then KBD.xa:=-KBD.move else KBD.xa:=0;
      if KBD.Key.a.Down then KBD.ya:=KBD.move else
      if KBD.Key.a.Up then KBD.ya:=-KBD.move else KBD.ya:=0;
      mou.InInt:=true;
     end else
     begin
      KBD.move:=0;
      if KP<128 then scan2char(kp);
     end;

     if KBD.PrevKey.a.ScrollLock or
        KBD.PrevKey.a.NumLock or
        KBD.PrevKey.a.CapsLock then
      begin
       if KBD.PrevKey.a.ScrollLock then if KBD.ScrollLock then
          KBD.ScrollLock:=false else KBD.ScrollLock:=true;
       if KBD.PrevKey.a.NumLock then if KBD.NumLock then
          KBD.NumLock:=false else KBD.NumLock:=true;
       if KBD.PrevKey.a.CapsLock then if KBD.CapsLock then
          KBD.CapsLock:=false else KBD.CapsLock:=true;
       KBD.PrevKey.a.ScrollLock:=false;
       KBD.PrevKey.a.NumLock:=false;
       KBD.PrevKey.a.CapsLock:=false;
       port[$60]:=$ed;
       port[$60]:=byte(KBD.ScrollLock)+
                  byte(KBD.NumLock)*2+
                  byte(KBD.CapsLock)*4;
      end;
   INN:=ws;
   InLine($fb);  {STI}
port[$20]:=$20;
end;

procedure MouseHide;
begin
 Mou.show:=false;
 Mouse_off;
end;

procedure MouseShow;
begin
 Mouse_on;
 Mou.show:=true;
end;

procedure Cursor; assembler;
asm
db 11,0,15,0,3,0,16,0,0,16,0,0,16,0,0,16
db 16,0,16,15,0,16,15,0,16,15,0,16,15,16,16
db 15,15,16,15,16,16,16,0,16,16,0,0,0,16,0
db 0,16,0,0,0,3,0,16,0,0,15,0,0,15,0,0,15
db 0,0,15,16,0,15,15,0,15,15,0,15,15,0,15
db 15,16,15,15,16,15,15,0,16,15,0,0,16,0,0
db 16,0,0,0,0,2,0,0,0,16,0,15,0,15,0,15
db 0,15,16,15,15,15,15,15,15,15,16,16,15,0
db 15,0,15,0,15,0,16,2,0,0,0,0,0,16,0,15
db 0,15,0,15,0,15,16,15,15,15,15,16,16,0,16
db 0,16,0,15,0,15,0,16,95
end;

{############ INTERRUPT # 12 INSTALL MY OWN INTERRUPT CALL ############}
PROCEDURE Install_Mouse_Interrupt_Handler; Assembler;
asm
  mov AX,014h
  mov CX,127
  mov DX,Seg Mouse_Handler
  mov ES,DX
  mov DX,Offset Mouse_Handler               { KEEP OLD VECTOR TABLE }
  INT 033h
  mov mou.OldDx,dx;
  mov mou.OldEs,es;
  mov mou.OldCx,cx;
END;

procedure SetIntVec(b: byte; p: pointer); Assembler;
asm
 push ds
 mov ah,25h
 mov al,b
 mov ds,Word Ptr P[2]
 mov dx,Word Ptr P
 int 21h
 pop ds
end;

procedure Init_Mouse;
begin
 if MaxAvail<1000 then
  begin
   WriteLn('Not enough memory.');
   exit;
  end;
 getmem(mou.BGis,1000);
 mou.BGcur:=true;
 Mou.MX:=MaxX div 2;
 Mou.MY:=MaxY div 2;
 Mou.MCur:=Addr(Cursor);
 Mou.Show:=false;
 Mou.Mou:=false;
 SetBar(0,0,getmaxx,getmaxy);
 if meml[0:$33*4]<>0 then
  begin
   Install_Mouse_Interrupt_Handler;
   IMIH:=true;
  end else IMIH:=false;
 Mouse:=true;
end;

function ReadKey: char;
var b: byte;
begin
if RHalt then if INN=false then RegisterHalt;
if Int9=false then
 begin
  asm
   xor ah,ah
   int 16h
   mov b,al
  end;
  ReadKey:=chr(b);
 end else
  begin
   repeat until KBD.KeyPressed;
   if KBD.LKey>0 then
    begin
     Dec(KBD.Lkey);
     ReadKey:=KBD.KeyBuf[0];
     if KBD.LKey=0 then KBD.KeyPressed:=false else
       for b:=0 to KBD.LKey-1 do KBD.KeyBuf[b]:=KBD.KeyBuf[b+1];
    end;
  end;
end;

Procedure KeyBoardReset;
Begin
 KBD.LKey:=0;
 FillChar(Key^,SizeOf(StandartKeys),0);
 FillChar(PrevKey^,SizeOf(StandartKeys),0);
 KBD.KeyPressed:=false;
End;

function KeyPressed: boolean;
var keyp: byte;
begin
if RHalt then if INN=false then RegisterHalt;
KeyPressed:=false;
 if Int9=false then
  begin
   asm
    mov keyp,0
    mov ah,1
    int 16h
    jne @NOKEYS
    mov keyp,255
    @NOKEYS:
   end;
   KeyPressed:=not Boolean(keyp);
  end else if KBD.LKey>0 then KeyPressed:=true;
end;

function GetIntVec(b: byte): pointer;
var p: pointer;
begin
 asm
  mov ah,35h
  mov al,b
  int 21h
  mov Word Ptr P[2],es
  mov Word Ptr P,bx
 end;
GetIntVec:=P;
end;

procedure InitKeyBoard;
begin
 Lights:=mem[$40:$97] and 7;
 FillChar(KBD.Key,255,0);
 FillChar(KBD.PrevKey,255,0);
 KBD.ScrollLock:=false;
 KBD.CapsLock:=false;
 KBD.NumLock:=false;
 OldInt9:=GetIntVec($9);
 Int9:=true;
 SetIntVec($9,Addr(KeyHandler));
        port[$60]:=$ed;
        port[$60]:=byte(KBD.ScrollLock)+
                   byte(KBD.NumLock)*2+
                   byte(KBD.CapsLock)*4;
end;

Procedure KillKeyboard;
var b: byte;
begin
 if Int9 then
  begin
   Int9:=false;
   delay(5);
   memw[$40:$1A]:=memw[$40:$1C];
   SetIntVec($9,OldInt9);
       b:=Lights;
       port[$60]:=$ed;
       port[$60]:=b;
  end;
end;

procedure SetTimer(secc: word); {Set SEC counts per second}
begin
 asm
 mov al,00110110b
 out 43h,al
 mov cx,secc
 mov al,cl
 out 40h,al
 mov al,ch
 out 40h,al
 end;
end;

procedure SetTimerCnst(freq: word);
Begin
   cnst18:=round(65536/Freq);
   if cnst18=0 then cnst18:=1;
   cnstgame:=round(65536/Freq);
   if cnstgame=0 then cnstgame:=1;
   delaycnst:=round(65536/Freq/5.33);
   if delaycnst=0 then delaycnst:=1;
End;

Procedure ResetTimerCnst;
Begin
 if CmfMusic then SetTimerCnst(65535) else
                  SetTimerCnst(TimerFreq);
End;

procedure InitTimer;
begin
 if RHalt then if INN=false then RegisterHalt;
 @MouseTimeProc:=@TimerHandler;
 if CmfMusic=false then SetTimerCnst(TimerFreq) else
                        SetTimerCnst(CmfFreq);
 NeedCall:=0;
 OldInt1C:=GetIntVec($1c);
 Int1C:=true;
 Timer18:=memw[$40:$6C];
  SetIntVec($1c,Addr(TimerHandler));
  if CmfStarted=false then SetTimer(TimerFreq);
 TimerOn:=true;
end;

Procedure KillTimer;
begin
 if Int1C=false then exit;
 memw[$40:$6C]:=Timer18;
 if CmfMusic=false then SetTimer(0);
 Int1C:=false;
 SetIntVec($1c,OldInt1C);
end;

Function MouseButton: byte;
begin
 if RHalt then if INN=false then RegisterHalt;
 MouseButton:=Byte(Mou.LBut)+Byte(Mou.RBut)*2;
end;

Function RightBPress: boolean;
begin
 if RHalt then if INN=false then RegisterHalt;
 RightBPress:=Mou.FRBut;
 Mou.FRBut:=false;
end;

Function LeftBPress: boolean;
begin
 if RHalt then if INN=false then RegisterHalt;
 LeftBPress:=Mou.FLBut;
 Mou.FLBut:=false;
end;

Function RightButton: boolean;
begin
 if RHalt then if INN=false then RegisterHalt;
 RightButton:=Mou.PrevRBut;
 Mou.PrevRBut:=false;
end;

Function LeftButton: boolean;
begin
 if RHalt then if INN=false then RegisterHalt;
 LeftButton:=Mou.PrevLBut;
 Mou.PrevLBut:=false;
end;

Function MouseX: word;
begin
 if RHalt then if INN=false then RegisterHalt;
 MouseX:=Mou.MX;
end;

Function MouseY: word;
begin
 if RHalt then if INN=false then RegisterHalt;
 MouseY:=Mou.MY;
end;

Function TimeConstant: word;
begin
 if Int1C=false then TimeConstant:=Word(memw[$40:$6C]) else
                     TimeConstant:=Timer18;
end;

Procedure SetTimeConstant(w: word);
Begin
 if Int1C then Timer18:=w;
 TimeStop:=w;
End;

Function MouseInBar(x,y,x1,y1: integer): boolean;
begin
 if RHalt then if INN=false then RegisterHalt;
 if (mou.mx>x) and
    (mou.mx<x1) and
    (mou.my>y) and
    (mou.my<y1) then MouseInBar:=true else MouseInBar:=false;
end;

Procedure TimerProcedureOn(P: pointer);
begin
if RHalt then if INN=false then RegisterHalt;
 @TimeProc:=P;
end;

Procedure TimerProcedureOff;
begin
 if RHalt then if INN=false then RegisterHalt;
 @TimeProc:=nil;
end;

Function MemorySize: longint;
var w: word;
begin
 if RHalt then if INN=false then RegisterHalt;
 asm
  mov ah,48h
  mov bx,65535
  int 21h
  mov w,bx
 end;
MemorySize:=longint(w)*16;
end;

Function BigCounter: longint;
begin
 if RHalt then if INN=false then RegisterHalt;
 if INT1C then BigCounter:=TimeCounter else BigCounter:=0;
end;

Function MousePointer: pointer;
begin
 if RHalt then if INN=false then RegisterHalt;
 MousePointer:=MOU.MCUR;
end;

Function KeyPush: boolean;
begin
 if RHalt then if INN=false then RegisterHalt;
 KeyPush:=KPSH;
 KPSH:=false;
end;

{$F-,S+}

begin
 PlayTime:=0;
 mou.BGcur:=false;
 STOPHALT:=false;
 Key:=addr(KBD);
 PrevKey:=ptr(seg(KBD),ofs(KBD)+SizeOf(Keys));
 TimeStop:=TimeConstant;
 TryHalt:=RegisterHalt;
 HaltIsOn:=true;
 ErrorIs:=false;
 NOTavl:=false;
end.