unit XMSscrll;


INTERFACE

Function LoadIBGFile(s: string): byte;
Function CloseIBG: byte;
Procedure OutPutIBG(x,y: integer);
Function ReturnIBGError(b: byte): string;
Procedure SetIBGPalette;

IMPLEMENTATION
uses xms,goodvga;

type IBGtype=record
              ch: array[0..2] of char;
              w: word;
              h: word;
              pl: array[0..3] of word;
              size: word;
              hnd: word;
              load: boolean;
              FCol: byte;
              LCol: byte;
              Pal: array[0..255,0..2] of byte;
              sz: longint;
             end;

var IBG: IBGtype;

Function TWom(b: word): longint;
begin
 if b mod 2<>0 then inc(b);
 TWom:=longint(b);
end;

Function LoadIBGFile(s: string): byte;
var f: file;
    err: byte;
    rd: longint;
    mbf,num: word;
    MP: TMoveParams;
    P: pointer;
    MS,L: longint;
Begin
l:=0;
rd:=0;
err:=0;
if IBG.load then err:=CloseIBG;
IBG.Hnd:=0;
 if err=0 then If XMSInstalled then
  begin
   XMSInit;
   If MaxAvail>=30000 then
    begin
     GetMem(P,30000);
     Assign(f,s);
     {$I-}
      Reset(f,1);
     {$I+}
      If IoResult<>0 then err:=2 else
       begin
        BlockRead(f,IBG.CH,3,num); rd:=rd+num;
        BlockRead(f,IBG.W,2,num); rd:=rd+num;
        BlockRead(f,IBG.H,2,num); rd:=rd+num;
        BlockRead(f,IBG.PL,8,num); rd:=rd+num;
        if rd<>15 then err:=4 else
         begin
          if (IBG.CH[0]='I') and (IBG.CH[1]='B') and (IBG.CH[2]='G') then
           begin
            MS:=longint(IBG.W+8)*longint(IBG.H);
            IBG.Size:=(longint(IBG.W+8)*longint(IBG.H)) div 1024+2;
            if XMSAllocate(IBG.Hnd,IBG.Size) then
             begin
              repeat
               MP.SourceHandle := 0;
               MP.SourceOffset := LongInt(Addr(P^));
               MP.DestHandle   := IBG.Hnd;
               MP.DestOffset   := l;
               if MS>29000 then MBF:=29000 else MBF:=word(MS);
               BlockRead(f,P^,mbf,num); rd:=rd+num;
               MS:=MS-longint(num);
               MP.Length       := TWom(num);
               if not XMSMove(@MP) then err:=7;
               l:=l+num;
              until (err<>0) or (ms=0) or (num=0);
              if ms<>0 then err:=8;
               if err=0 then
                begin
                 BlockRead(f,IBG.FCol,1,num); rd:=rd+num;
                 BlockRead(f,IBG.LCol,1,num); rd:=rd+num;
                 BlockRead(f,IBG.Pal,768,num); rd:=rd+num;
                 BlockRead(f,IBG.sz,4,num);
                 if (num<>4) or (IBG.sz<>rd) then err:=9;
                end;
             end else err:=5;
           end else err:=3;
         end;
       end;
     FreeMem(P,30000);
    end else err:=6;
  end else err:=1;
if err=0 then IBG.load:=true else IBG.load:=false;
if (err<>0) and (IBG.Hnd<>0) then XMSFree(IBG.Hnd);
LoadIBGFile:=err;
end;

Function CloseIBG: byte;
Begin
 CloseIbg:=0;
 if IBG.load and (IBG.Hnd<>0) then
   if not XMSFree(IBG.Hnd) then CloseIbg:=10;
 if IBG.load=false then CloseIbg:=11;
 if IBG.load and (IBG.Hnd=0) then CloseIbg:=12;
 IBG.load:=false;
 IBG.Hnd:=0;
 IBG.ch[0]:=#255;
end;

Procedure OutPutIBG(x,y: integer);
var w,mv: byte;
    ftplz,plz,pl,ckl: byte;
    MB: TMoveParams;
    zd,l: longint;
    n,sco: word;
    okend,stm,ftm: boolean;
Begin
 if IBG.Load=false then exit;
 l:=0;
 sco:=0;
{ x:=x mod 320;
 y:=y mod (GetMaxY+1);}
 x:=x mod IBG.w;
 y:=y mod IBG.h;
 if x<0 then x:=IBG.w+x;
 if y<0 then y:=IBG.h+y;
 l:=longint(IBG.h-1)*longint(IBG.w+8)-longint(y*(IBG.w+8));
 pl:=x mod 4;
 zd:=0;
 if pl>0 then
  begin
   for pl:=0 to pl-1 do zd:=zd+IBG.pl[pl]+2;
   inc(pl);
  end;

 for ckl:=pl to pl+3 do
  begin
   plz:=x div 4;
   SetWPlane(ckl-pl);
   mv:=80;
   sco:=0;
   ftm:=true;
   stm:=false;
   okend:=false;

   repeat
    if stm then okend:=true;
    if IBG.pl[ckl mod 4]-plz<mv then w:=IBG.pl[ckl mod 4]-plz else w:=mv;
    if FTM then
     begin
      ftplz:=plz;
      mv:=mv-w;
      sco:=sco+word(w);
      plz:=0;
      if IBG.pl[ckl mod 4]-plz<mv then w:=IBG.pl[ckl mod 4]-plz else w:=mv;
      ftm:=false;
     end;
    MB.SourceHandle := IBG.Hnd;
    MB.SourceOffset := l+plz+zd;
    MB.DestHandle   := 0;
    MB.DestOffset   := longint(ptr(basepage,sco));
    MB.Length       := twom(w);

    if MB.Length<>0 then for n:=y+1 to y+(GetMaxY)+1 do
      begin
       XMSMove(@MB);
       if n mod IBG.h=0 then
        begin
         MB.SourceOffset:=longint(IBG.h-1)*longint(IBG.w+8)+(plz)+zd;
        end else MB.SourceOffset:=MB.SourceOffset-(IBG.w+8);
       MB.DestOffset:=Mb.DestOffset+longint(80);
      end;

    mv:=mv-w;
    sco:=sco+word(w);
    plz:=0;

    if (mv=0) and (stm=false) then
     begin
      mv:=80;
      sco:=0;
      plz:=ftplz;
      stm:=true;
     end;

   until okend;

   if ckl<>3 then zd:=zd+IBG.pl[ckl mod 4]+2;
   if ckl=3 then
     zd:=1;
  end;
end;

Procedure SetIBGPalette;
begin
 Bios1SETPalette(IBG.FCol,IBG.LCol-IBG.FCol+1,IBG.Pal);
end;

Function ReturnIBGError(b: byte): string;
Begin
case b of
 1: ReturnIBGError:='HIMEM driver not installed.';
 2: ReturnIBGError:='IBG file not found.';
 3: ReturnIBGError:='Bad IBG file.';
 4: ReturnIBGError:='Cannot read from IBG file.';
 5: ReturnIBGError:='Not enough extendet memory to load IBG file.';
 6: ReturnIBGError:='Not enough memory in HEAP to load IBG file.';
 7: ReturnIBGError:='Cannot move data block to extendet memory.';
 8: ReturnIBGError:='Incorrect IBG file size.';
 9: ReturnIBGError:='Cannot load IBG file. Corrupted IBG file.';
 10: ReturnIBGError:='Error while cleaning IBG memory block.';
 11: ReturnIBGError:='Cannot clean IBG memory block. Load IBG file first.';
 12: ReturnIBGError:='Cannot clean IBG memory block. Bad handler.';
end;
end;

end.