/* graphics.c --- Ascii drawings for hangit */

#include "defs.h"

#include <curses.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/ioctl.h>

#include "graphics.h"
#include "extutil.h"

void
init_curses (void)
{
  /* Initialize curses library.  */
  initscr ();                   /* initialize curses library */
  if (stdscr == 0)
    fatal ("Could not initialize curses");

  cbreak ();                    /* take chars one at a time */
  noecho ();                    /* don't echo chars on input */
  intrflush (stdscr, FALSE);
  keypad (stdscr, TRUE);        /* enable keypad mapping */
}

void
restore_terminal (void)
{
  /* This restores the terminal back to normal settings. */
  clear ();			/* clear screen */
  refresh ();			/* reveal changes */
  endwin ();			/* end the stdwin */
}

#ifdef __LINUX__
void
global_resize_screen (void)
{
  /* Handles screen resize for all situations.  Ian Jackson's dpkg
     project was consulted to determine the correct way to do this.
     It is available under the terms of the GNU GPL.  */
  struct winsize size;

  endwin ();
  initscr ();
  
  if (ioctl (fileno (stdout), TIOCGWINSZ, &size) != 0)
    fatal ("Failed to determine new screen coordinates");
  resizeterm (size.ws_row, size.ws_col);

  box (stdscr, 0, 0);           /* draw a box around the window */
  refresh ();
}
#endif /* Linux compilation */

void
print_score (void)
{
  /* Outputs score to stdscr. */
  char buffer[16] = "";

  sprintf (buffer, "Score: %d  ", score);	/* put score in buffer */
  mvaddstr (1, COLS - 16, buffer);
}

void
print_letter_list (char *letter_list)
{
  /* Prints the list of chars at bottom of screen. */
  char buffer[53] = "";		/* 26 * 2 + 1 */
  int i, maxlines, maxcols;

  if (!buffer[0])
    {				/* is buffer unmodified? */
      for (i = 0; i < 26; i++)
	{			/* all the chars, separated by spaces */
	  buffer[i * 2] = letter_list[i];
	  buffer[i * 2 + 1] = ' ';
	}
      buffer[52] = 0;		/* null-terminate */
    }

  getmaxyx (stdscr, maxlines, maxcols);
  mvaddstr (maxlines - 2, 2, buffer); /* put it on screen */
}

void
print_underscores (char *guessed_word)
{
  /* Makes and prints a string of underscores to show the # chars
     in the correct word. */
  char *buffer = (char *) xmalloc (word_length * 2);
  int i, maxlines, maxcols;

  for (i = 0; i < word_length; i++)	/* space out letter list */
    {
      buffer[i * 2] = guessed_word[i];
      buffer[i * 2 + 1] = ' ';
    }

  buffer[word_length * 2 - 1] = 0;	/* null-terminate */
  getmaxyx (stdscr, maxlines, maxcols);
  mvaddstr (maxlines - 6, 2, buffer);	/* put it to screen */
}

void
print_art (WINDOW * win, int number)
{
  /* Select which character to hang, or save coding
     time by printing empty gallows. */

  if (number == 7)
    {
      mvwaddstr (win, 0, 0, "     __________");
      mvwaddstr (win, 1, 0, "    |__________`\\");
      mvwaddstr (win, 2, 0, "     |         | |");
      mvwaddstr (win, 3, 0, "               | |");
      mvwaddstr (win, 4, 0, "               | |");
      mvwaddstr (win, 5, 0, "               | |");
      mvwaddstr (win, 6, 0, "               | |");
      mvwaddstr (win, 7, 0, "               | |");
      mvwaddstr (win, 8, 0, "               | |");
      mvwaddstr (win, 9, 0, "               | |");
      mvwaddstr (win, 10, 0, "               | |");
      mvwaddstr (win, 11, 0, "               | |");
      mvwaddstr (win, 12, 0, "              /' `\\");
      mvwaddstr (win, 13, 0, "           _/__/^\\__\\_");
      return;
    }

  switch (hangchar)
    {
    case 0:
      print_man (win, number);
      break;
    default:
      print_man (win, number);
    }
}

void
print_man (WINDOW * win, int number)
{
  /* The default drawing */
  switch (number)
    {
    case 6:
      mvwaddstr (win, 3, 0, "   /\"\"\"\\");
      mvwaddstr (win, 4, 0, "  ( o o )");
      mvwaddstr (win, 5, 0, "   \\._./");
      break;
    case 5:
      mvwaddstr (win, 5, 0, "  _\\._./_");
      mvwaddstr (win, 6, 0, " / .");
      mvwaddstr (win, 7, 0, "|_|");
      mvwaddstr (win, 8, 0, "@@");
      break;
    case 4:
      mvwaddstr (win, 5, 0, "  _\\._./_");
      mvwaddstr (win, 6, 0, " / .   . \\");
      mvwaddstr (win, 7, 0, "|_|     |_|");
      mvwaddstr (win, 8, 0, "@@       @@");
      break;
    case 3:
      mvwaddstr (win, 7, 0, "|_||   ||_|");
      mvwaddstr (win, 8, 0, "@@ |___| @@");
      break;
    case 2:
      mvwaddstr (win, 9, 0, "   |   |");
      mvwaddstr (win, 10, 0, "   | | |");
      mvwaddstr (win, 11, 0, "   | | |");
      break;
    case 1:
      mvwaddstr (win, 11, 0, " __|_|_|__");
      mvwaddstr (win, 12, 0, "|__/_|_\\__|");
      break;
    default:
      mvwaddstr (win, 3, 0, "   /\"\"\"\\");
      mvwaddstr (win, 4, 0, "  ( + + )");
      mvwaddstr (win, 5, 0, "  _\\._./_");
      mvwaddstr (win, 6, 0, " / .   . \\");
      mvwaddstr (win, 7, 0, "|_||   ||_|");
      mvwaddstr (win, 8, 0, "@@ |___| @@");
      mvwaddstr (win, 9, 0, "   |   |");
      mvwaddstr (win, 10, 0, "   | | |");
      mvwaddstr (win, 11, 0, " __|_|_|__");
      mvwaddstr (win, 12, 0, "|__/_|_\\__|");
    }
}

/*
  def print_python(win, lives): 
	if lives == 5:
		mvwaddstr(win,0, 0, "     __________")
		mvwaddstr(win,1, 0, "    |__________`\\")
		mvwaddstr(win,2, 0, "               | |")
		mvwaddstr(win,3, 0, "               | |")
		mvwaddstr(win,4, 0, "               | |")
		mvwaddstr(win,5, 0, "               | |")
		mvwaddstr(win,6, 0, "               | |")
		mvwaddstr(win,7, 0, "               | |")
		mvwaddstr(win,8, 0, "               | |")
		mvwaddstr(win,9, 0, "               | |")
		mvwaddstr(win,10, 0, "               | |")
		mvwaddstr(win,11, 0, "               | |")
		mvwaddstr(win,12, 0, "              /' `\\")
		mvwaddstr(win,13, 0, "           _/__/^\\__\\_")

	elif lives == 4:
		mvwaddstr(win,0, 0, "     __________")
		mvwaddstr(win,1, 0, "    |__________`\\")
		mvwaddstr(win,2, 0, "     |\\.       | |")
		mvwaddstr(win,3, 0, "   ./'.|       | |")
		mvwaddstr(win,4, 0, "   |. /'       | |")
		mvwaddstr(win,5, 0, "               | |")
		mvwaddstr(win,6, 0, "               | |")
		mvwaddstr(win,7, 0, "               | |")
		mvwaddstr(win,8, 0, "               | |")
		mvwaddstr(win,9, 0, "               | |")
		mvwaddstr(win,10, 0, "               | |")
		mvwaddstr(win,11, 0, "               | |")
		mvwaddstr(win,12, 0, "              /' `\\")
		mvwaddstr(win,13, 0, "           _/__/^\\__\\_")

	elif lives == 3:
		mvwaddstr(win,0, 0, "     __________")
		mvwaddstr(win,1, 0, "    |__________`\\")
		mvwaddstr(win,2, 0, "     |\\.       | |")
		mvwaddstr(win,3, 0, "   ./'.|       | |")
		mvwaddstr(win,4, 0, "   |. /'       | |")
		mvwaddstr(win,5, 0, " ./'.|         | |")
		mvwaddstr(win,6, 0, " |. .'         | |")
		mvwaddstr(win,7, 0, "               | |")
		mvwaddstr(win,8, 0, "               | |")
		mvwaddstr(win,9, 0, "               | |")
		mvwaddstr(win,10, 0, "               | |")
		mvwaddstr(win,11, 0, "               | |")
		mvwaddstr(win,12, 0, "              /' `\\")
		mvwaddstr(win,13, 0, "           _/__/^\\__\\_")

	elif lives == 2:
		mvwaddstr(win,0, 0, "     __________")
		mvwaddstr(win,1, 0, "    |__________`\\")
		mvwaddstr(win,2, 0, "     |\\.       | |")
		mvwaddstr(win,3, 0, "   ./'.|       | |")
		mvwaddstr(win,4, 0, "   |. /'       | |")
		mvwaddstr(win,5, 0, " ./'.|         | |")
		mvwaddstr(win,6, 0, " |. .'         | |")
		mvwaddstr(win,7, 0, " `\\ .`\\        | |")
		mvwaddstr(win,8, 0, "   `\\ .|       | |")
		mvwaddstr(win,9, 0, "               | |")
		mvwaddstr(win,10, 0, "               | |")
		mvwaddstr(win,11, 0, "               | |")
		mvwaddstr(win,12, 0, "              /' `\\")
		mvwaddstr(win,13, 0, "           _/__/^\\__\\_")

	elif lives == 1:
		mvwaddstr(win,0, 0, "     __________")
		mvwaddstr(win,1, 0, "    |__________`\\")
		mvwaddstr(win,2, 0, "     |\\.       | |")
		mvwaddstr(win,3, 0, "   ./'.|       | |")
		mvwaddstr(win,4, 0, "   |. /'       | |")
		mvwaddstr(win,5, 0, " ./'.|         | |")
		mvwaddstr(win,6, 0, " |. .'         | |")
		mvwaddstr(win,7, 0, " `\\ .`\\        | |")
		mvwaddstr(win,8, 0, "   `\\ .|       | |")
		mvwaddstr(win,9, 0, "    /'.`\\      | |")
		mvwaddstr(win,10, 0, "   |.   .|     | |")
		mvwaddstr(win,11, 0, "   `|   |'     | |")
		mvwaddstr(win,12, 0, "    `\\_/'     /' `\\")
		mvwaddstr(win,13, 0, "           _/__/^\\__\\_")

	else:
		mvwaddstr(win,0, 0, "     __________")
		mvwaddstr(win,1, 0, "    |__________`\\")
		mvwaddstr(win,2, 0, "     |\\.       | |")
		mvwaddstr(win,3, 0, "   ./'.|       | |")
		mvwaddstr(win,4, 0, "   |. /'       | |")
		mvwaddstr(win,5, 0, " ./'.|         | |")
		mvwaddstr(win,6, 0, " |. .'         | |")
		mvwaddstr(win,7, 0, " `\\ .`\\        | |")
		mvwaddstr(win,8, 0, "   `\\ .|       | |")
		mvwaddstr(win,9, 0, "    /'.`\\      | |")
		mvwaddstr(win,10, 0, "   |.   .|     | |")
		mvwaddstr(win,11, 0, "   `|+ +|'     | |")
		mvwaddstr(win,12, 0, "    `\\_/'     /' `\\")
		mvwaddstr(win,13, 0, "      ^    _/__/^\\__\\_")

def print_tux(win, lives):
	if lives == 5:
		mvwaddstr(win,0, 0, "      __________")
		mvwaddstr(win,1, 0, "     |__________`\\")
		mvwaddstr(win,2, 0, "       |        | |")
		mvwaddstr(win,3, 0, "                | |")
		mvwaddstr(win,4, 0, "                | |")
		mvwaddstr(win,5, 0, "                | |")
		mvwaddstr(win,6, 0, "                | |")
		mvwaddstr(win,7, 0, "                | |")
		mvwaddstr(win,8, 0, "                | |")
		mvwaddstr(win,9, 0, "                | |")
		mvwaddstr(win,10, 0, "                | |")
		mvwaddstr(win,11, 0, "                | |")
		mvwaddstr(win,12, 0, "               /' `\\")
		mvwaddstr(win,13, 0, "            _/__/^\\__\\_")

	elif lives == 4:
		mvwaddstr(win,0, 0, "      __________")
		mvwaddstr(win,1, 0, "     |__________`\\")
		mvwaddstr(win,2, 0, "       |        | |")
		mvwaddstr(win,3, 0, "     /'~`\\      | |")
		mvwaddstr(win,4, 0, "    | 0 0 |     | |")
		mvwaddstr(win,5, 0, "    | \\_/ |     | |")
		mvwaddstr(win,6, 0, "                | |")
		mvwaddstr(win,7, 0, "                | |")
		mvwaddstr(win,8, 0, "                | |")
		mvwaddstr(win,9, 0, "                | |")
		mvwaddstr(win,10, 0, "                | |")
		mvwaddstr(win,11, 0, "                | |")
		mvwaddstr(win,12, 0, "               /' `\\")
		mvwaddstr(win,13, 0, "            _/__/^\\__\\_")

	elif lives == 3:
		mvwaddstr(win,0, 0, "      __________")
		mvwaddstr(win,1, 0, "     |__________`\\")
		mvwaddstr(win,2, 0, "       |        | |")
		mvwaddstr(win,3, 0, "     /'~`\\      | |")
		mvwaddstr(win,4, 0, "    | 0 0 |     | |")
		mvwaddstr(win,5, 0, "    | \\_/ |     | |")
		mvwaddstr(win,6, 0, "   /'     `\\    | |")
		mvwaddstr(win,7, 0, "    .     .     | |")
		mvwaddstr(win,8, 0, "   |  /^\\  |    | |")
		mvwaddstr(win,9, 0, "   ( (   ) )    | |")
		mvwaddstr(win,10, 0, "                | |")
		mvwaddstr(win,11, 0, "      ---       | |")
		mvwaddstr(win,12, 0, "               /' `\\")
		mvwaddstr(win,13, 0, "            _/__/^\\__\\_")

	elif lives == 2:
		mvwaddstr(win,0, 0, "      __________")
		mvwaddstr(win,1, 0, "     |__________`\\")
		mvwaddstr(win,2, 0, "       |        | |")
		mvwaddstr(win,3, 0, "     /'~`\\      | |")
		mvwaddstr(win,4, 0, "    | 0 0 |     | |")
		mvwaddstr(win,5, 0, "    | \\_/ |     | |")
		mvwaddstr(win,6, 0, "   /'     `\\    | |")
		mvwaddstr(win,7, 0, "./' .     . `\\. | |")
		mvwaddstr(win,8, 0, "|_.|  /^\\  |._| | |")
		mvwaddstr(win,9, 0, "   ( (   ) )    | |")
		mvwaddstr(win,10, 0, "                | |")
		mvwaddstr(win,11, 0, "      ---       | |")
		mvwaddstr(win,12, 0, "               /' `\\")
		mvwaddstr(win,13, 0, "            _/__/^\\__\\_")

	elif lives == 1:
		mvwaddstr(win,0, 0, "      __________")
		mvwaddstr(win,1, 0, "     |__________`\\")
		mvwaddstr(win,2, 0, "       |        | |")
		mvwaddstr(win,3, 0, "     /'~`\\      | |")
		mvwaddstr(win,4, 0, "    | 0 0 |     | |")
		mvwaddstr(win,5, 0, "    | \\_/ |     | |")
		mvwaddstr(win,6, 0, "   /'     `\\    | |")
		mvwaddstr(win,7, 0, "./' .     . `\\. | |")
		mvwaddstr(win,8, 0, "|_.|  /^\  |._| | |")
		mvwaddstr(win,9, 0, "   ( (   ) )    | |")
		mvwaddstr(win,10, 0, "   AAA   AAA    | |")
		mvwaddstr(win,11, 0, "   \\A/---\\A/    | |")
		mvwaddstr(win,12, 0, "               /' `\\")
		mvwaddstr(win,13, 0, "            _/__/^\\__\\_")

	else:
		mvwaddstr(win,0, 0, "      __________")
		mvwaddstr(win,1, 0, "     |__________`\\")
		mvwaddstr(win,2, 0, "       |        | |")
		mvwaddstr(win,3, 0, "     /'~`\\      | |")
		mvwaddstr(win,4, 0, "    | + + |     | |")
		mvwaddstr(win,5, 0, "    | \\_/ |     | |")
		mvwaddstr(win,6, 0, "   /'     `\\    | |")
		mvwaddstr(win,7, 0, "./' .     . `\\. | |")
		mvwaddstr(win,8, 0, "|_.|  /^\  |._| | |")
		mvwaddstr(win,9, 0, "   ( (   ) )    | |")
		mvwaddstr(win,10, 0, "   AAA   AAA    | |")
		mvwaddstr(win,11, 0, "   \\A/---\\A/    | |")
		mvwaddstr(win,12, 0, "               /' `\\")
		mvwaddstr(win,13, 0, "            _/__/^\\__\\_")
*/

void
print_gameover (WINDOW * win)
{
  /* Print "Game Over" message. */
  mvwaddstr (win, 1, 2, "  ___            ____    ___  _ _ ____ ___  _ ");
  mvwaddstr (win, 2, 2, " /,-.\\ /^\\|\\   /| ___|  /   \\| | | ___| D )| |");
  mvwaddstr (win, 3, 2, "((  __| A | `V' | __|  (  O  | | | __||   \\|_|");
  mvwaddstr (win, 4, 2, " \\___/|_|_|_|_|_|____|  \\___/ \\./|____|_|\\_|_|");
}

void
print_welldone (WINDOW * win)
{
  /* Print "Well Done" message. */
  mvwaddstr (win, 1, 2, " _ _ _ ____ _   _     _    ___  _  _ ____ _");
  mvwaddstr (win, 2, 2, "| | | | ___| | | |   |  \\ /   \\| || | ___| |");
  mvwaddstr (win, 3, 2, "|     | __|| |_| |_  | D |  O  |  \\ | __||_|");
  mvwaddstr (win, 4, 2, "|/'^`\\|____|___|___| |__/ \\___/|_|\\_|____|_|");
}

void
print_bill (WINDOW * win, int number)
{
  /* This one's my personal favorite... */
  switch (number)
    {
    case 4:
      mvwaddstr (win, 3, 0, "   /\"\"\"\\");
      mvwaddstr (win, 4, 0, "  (\\o-o/)");
      mvwaddstr (win, 5, 0, "   \\._./");
      break;
    case 3:
      mvwaddstr (win, 5, 0, "  _\\._./_");
      mvwaddstr (win, 6, 0, " / .   . \\");
      mvwaddstr (win, 7, 0, "|_|     |_|");
      mvwaddstr (win, 8, 0, "@@       @@");
      break;
    case 2:
      mvwaddstr (win, 7, 0, "|_||M $||_|");
      mvwaddstr (win, 8, 0, "@@ |___| @@");
      break;
    case 1:
      mvwaddstr (win, 9, 0, "   |   |");
      mvwaddstr (win, 10, 0, "   | | |");
      mvwaddstr (win, 11, 0, " __|_|_|__");
      mvwaddstr (win, 12, 0, "|__/_|_\\__|");
      break;
    default:
      mvwaddstr (win, 3, 0, "   /\"\"\"\\");
      mvwaddstr (win, 4, 0, "  (\\+-+/)");
      mvwaddstr (win, 5, 0, "  _\\._./_");
      mvwaddstr (win, 6, 0, " / .   . \\");
      mvwaddstr (win, 7, 0, "|_||M $||_|");
      mvwaddstr (win, 8, 0, "@@ |___| @@");
      mvwaddstr (win, 9, 0, "   |   |");
      mvwaddstr (win, 10, 0, "   | | |");
      mvwaddstr (win, 11, 0, " __|_|_|__");
      mvwaddstr (win, 12, 0, "|__/_|_\\__|");
    }
}
