/* wordlist.c -- This file contains functions that facilitate the managing
  of word lists.  Currently, there is only a function that chooses a word from
  a given previously defined list.  This will be expanded later to include the
  management of an external wordlist database....  */

#include "defs.h"

#include <stdlib.h>
#include <string.h>
#include <time.h>
#ifdef __TEST__
# include <stdio.h>
#else /* not __TEST__ */
# include <curses.h>
#endif /* __TEST__ */

#include "extutil.h"
#include "wordlist.h"

/* Wordlists (separate with an end-of-line character, aka 'EOL'): */
/*
  Easy list:  cnt = 29
    1    2    3       4     5     6     7     8     9       10     11    12    13    14    15     16    17     18     19      20      21     22      23   24   25    26     27    28     29
*/
char easy[] =
  "CAT\nCAR\nMOUSE\nHORSE\nBIRD\nGIRL\nSTAR\nCAKE\nAPPLE\nFLOWER\nBOAT\nNOSE\nFOOD\nTREE\nHOUSE\nROOF\nOVEN\nORANGE\nCHAIR\nTEACHER\nBOOK\nTABLE\nLETTER\nEAR\nEYE\nROPE\nBEARD\nWATER\nBEAR";
/*
  Normal list:  cnt = 32
     1      2      3         4        5        6        7       8       9     10       11       12      13       14    15    16     17     18    19       20       21     22      23       24        25       26       27       28     29       30     31         32
*/
char normal[] =
  "RIBBON\nOCEAN\nRODENT\nCOMPUTER\nPENGUIN\nQUESTION\nRAZOR\nSCISSORS\nPEN\nMONKEY\nJOYSTICK\nSCREEN\nSPEAKER\nWHEEL\nSHOE\nPLANT\nJOKE\nTRUNK\nTRUCK\nRAILROAD\nENGINE\nBOMB\nPICTURE\nTELEPHONE\nNOTEPAD\nPENCIL\nCALENDAR\nCANDLE\nHANDLE\nMOVIE\nPUMPKIN\nCUPBOARD";
/*
  Star Wars list: cnt = 16
         1              2           3        4           5            6         7      8           9          10       11     12    13     14     15     16
*/
char starwars[] =
  "LUKE SKYWALKER\nOBI WAN KENOBI\nANAKIN\nHAN SOLO\nPRINCESS LEIA\nCHEWBACCA\nLANDO\nDODONNA\nJABBA THE HUT\nWEDGE\nPORKINS\nOWEN\nBERU\nGREDDO\nYODA\nWICKET";

unsigned int
count_words (char *wordlist)
{
  /* Count number of words available from list. */
  int cnt = 0, posi = 0, last = 0;

  while (1 == 1)
    {
      if (wordlist[posi] == 0)
	{
	  if (posi - 1 > last)	/* incr count as long as last char */
	    cnt++;		/*   was not a return char */
	  break;		/* exit loop upon encountering null terminator */
	}
      if (wordlist[posi] == '\n')
	{			/* end-of-item char found */
	  if (posi - 1 > last)	/* good syntax? (no 2 '\n's in a row) */
	    cnt++;		/* actual count of words */
	  last = posi;		/* keep track of pos of last one */
	}
      posi++;
    }

  return cnt;
}

unsigned int
find_word (char *wordlist, unsigned int place, unsigned int *pend)
{
  /* Return the starting position of the nth word, and
     put the end position (at '\n' char) in 'pend'.  */
  int cnt = 1, last = -1, end = 0;	/* initialize vars */

  /* Select certain word from list based on 'place'.  */
  while (1 == 1)
    {
      if (wordlist[end] == 0)	/* null encountered */
	break;
      if (wordlist[end] == '\n')
	{			/* EOL character found */
	  if (end - 1 > last)
	    {			/* check for syntax goofup (2 'EOL's) */
	      if (place == cnt)	/* correct place? */
		break;		/* good! break out of loop */
	      cnt++;		/* incr count of words */
	    }
	  last = end;		/* keep track of pos of last EOL */
	}
      end++;
    }

  *pend = end;
  return ++last;
}

char *
choose_word (int difficulty)
{
  /* Load a word from the given list randomly and return it.  */
  char *word, *wordlist;
  unsigned int cnt, rndnum, begin, end = 0;

  if (difficulty == 1)
    wordlist = easy;		/* pick word from easy list */
  else if (difficulty == 3)
    wordlist = starwars;	/* starwars list */
  else
    wordlist = normal;		/* or normal list */

  cnt = count_words (wordlist);	/* get number of words */

  if (cnt <= 0)			/* goofed up database probably */
    return 0;			/* send back NULL pointer */

  rndnum = getrand (1, cnt);	/* get a rnd # between 1 and cnt */

  begin = find_word (wordlist, rndnum, &end);
#ifdef __TEST__
  printf ("c:%2d r:%2d b:%3d e:%3d ", cnt, rndnum, begin, end);
#endif

  word = (char *) xmalloc (end - begin + 1);	/* allocate mem */
  strncpy (word, wordlist + begin, end - begin);	/* copy... */
  word[end - begin] = 0;	/* NULL terminate */

  return word;
}
