DECLARE SUB TBox (x%, y%, w%, t$)
DEFINT A-Z

'$INCLUDE: 'MYQBLIB.BI'
   DIM SHARED BasePort%, LenPort%, Channel%, IRQ%
   DIM SHARED ScreenMode%

   ' Mouse Mastering: HARDIN'BROTHERS:
   TYPE MouseRegs
      AX AS INTEGER
      BX AS INTEGER
      CX AS INTEGER
      DX AS INTEGER
      ES AS INTEGER
   END TYPE

   DIM SHARED MReg AS MouseRegs
   DIM SHARED MouseRoutine%(0 TO 19)
   DIM SHARED MouseReady%

   ' Mo de mi cosecha
   DIM SHARED MouseX AS INTEGER
   DIM SHARED MouseY AS INTEGER
   DIM SHARED vl%(0 TO 255, 0 TO 7)    ' Contiene la fuente

SUB Clg (n%)
   SELECT CASE n%
      CASE 0:
      CASE 1:  ' Fade out
      CASE 2:     ' Cuadraditos
         DEF SEG = 0
         POKE 1132, 0
         DEF SEG
         FOR i = 0 TO 10
            FOR x = 0 TO 16
               FOR y = 0 TO 10
                  LINE (x * 20 + i, y * 20 + i)-(19 + x * 20 - i, 19 + y * 20 - i), 0, B
               NEXT y
            NEXT x
            DEF SEG = 0
            WHILE PEEK(1132) < 1: WEND
            POKE 1132, 0
            DEF SEG
         NEXT i
   END SELECT
   CLS
END SUB

SUB DecodeRes (x%, y%, n$)
   PCOPY 0, 1
   f% = FREEFILE
   OPEN n$ FOR INPUT AS #f%
   WHILE NOT EOF(f%)
      LINE INPUT #f%, linea$
      o$ = ""
      FOR i% = 1 TO LEN(linea$)
         o$ = o$ + CHR$((ASC(MID$(linea$, i%, 1)) - 127) MOD 256)
      NEXT i%
      PCOPY 1, 0
      TBox x%, y%, 120, o$
      Wt
   WEND
   CLOSE f%
   PCOPY 1, 0
END SUB

SUB DecodeRes2 (x%, y%, w%, n$)
   PCOPY 0, 1
   f% = FREEFILE
   OPEN n$ FOR INPUT AS #f%
   WHILE NOT EOF(f%)
      LINE INPUT #f%, linea$
      IF LTRIM$(RTRIM$(linea$)) <> "" THEN
         o$ = ""
         FOR i% = 1 TO LEN(linea$)
            o$ = o$ + CHR$((ASC(MID$(linea$, i%, 1)) - 127) MOD 256)
         NEXT i%
         PCOPY 1, 0
         TBox x%, y%, w%, o$
         Wt
      END IF
   WEND
   CLOSE f%
   PCOPY 1, 0
END SUB

FUNCTION DMADone%
   Count% = INP(LenPort%)
   Count2% = INP(LenPort%)
   Count& = CLNG(Count% + 1) * CLNG(Count2% + 1)
   IF (Count& - 1) >= &HFFFF& THEN junk% = INP(DSPDataAvail%): DMADone% = -1
END FUNCTION

SUB DMAPlay (segment&, offset&, Length&, freq&)
   ' Transfers and plays the contents of the buffer.
   Length& = Length& - 1
   Page% = 0
   MemLoc& = segment& * 16 + offset&
   SELECT CASE Channel%
       CASE 0
          PgPort% = &H87
          AddPort% = &H0
          LenPort% = &H1
          ModeReg% = &H48
       CASE 1
          PgPort% = &H83
          AddPort% = &H2
          LenPort% = &H3
          ModeReg% = &H49
       CASE 2
          PgPort% = &H81
          AddPort% = &H4
          LenPort% = &H5
          ModeReg% = &H4A
       CASE 3
          PgPort% = &H82
          AddPort% = &H6
          LenPort% = &H7
          ModeReg% = &H4B
       CASE ELSE
          PRINT "DMA channels 0-3 only are supported."
          EXIT SUB
   END SELECT
   
   OUT &HA, &H4 + Channel%
   OUT &HC, &H0
   OUT &HB, ModeReg%
   OUT AddPort%, MemLoc& AND &HFF
   OUT AddPort%, (MemLoc& AND &HFFFF&) \ &H100
   IF (MemLoc& AND 65536) THEN Page% = Page% + 1
   IF (MemLoc& AND 131072) THEN Page% = Page% + 2
   IF (MemLoc& AND 262144) THEN Page% = Page% + 4
   IF (MemLoc& AND 524288) THEN Page% = Page% + 8
   OUT PgPort%, Page%
   OUT LenPort%, Length& AND &HFF
   OUT LenPort%, (Length& AND &HFFFF&) \ &H100
   OUT &HA, Channel%

   IF freq& < 23000 THEN
      TimeConst% = 256 - 1000000 \ freq&
      WriteDSP &H40
      WriteDSP TimeConst%
      WriteDSP &H14
      WriteDSP (Length& AND &HFF)
      WriteDSP ((Length& AND &HFFFF&) \ &H100)
   ELSE
      IF DSPVersion! >= 3 THEN
         TimeConst% = ((65536 - 256000000 \ freq&) AND &HFFFF&) \ &H100
         WriteDSP &H40
         WriteDSP TimeConst%
         WriteDSP (Length& AND &HFF)
         WriteDSP ((Length& AND &HFFFF&) \ &H100)
         WriteDSP &H91
      ELSE
         PRINT "You need a Sound Blaster with a DSP v3.x+ to play at high speed."
         EXIT SUB
      END IF
   END IF
END SUB

SUB DMAState (StopGo%)
   ' Stops or continues DMA play.
   IF StopGo% THEN WriteDSP &HD4 ELSE WriteDSP &HD0
END SUB

FUNCTION DSPVersion!
   ' Gets the DSP version.
   WriteDSP &HE1
   Temp% = ReadDSP%
   Temp2% = ReadDSP%
   DSPVersion! = VAL(STR$(Temp%) + "." + STR$(Temp2%))
END FUNCTION

SUB GetBLASTER (DMA%, BasePort%, IRQ%)
   ' This subroutine parses the BLASTER environment string and returns settings.
   IF LEN(ENVIRON$("BLASTER")) = 0 THEN PRINT "BLASTER environment variable not set.": EXIT SUB
   FOR Length% = 1 TO LEN(ENVIRON$("BLASTER"))
      SELECT CASE MID$(ENVIRON$("BLASTER"), Length%, 1)
         CASE "A"
           BasePort% = VAL("&H" + MID$(ENVIRON$("BLASTER"), Length% + 1, 3))
         CASE "I"
           IRQ% = VAL(MID$(ENVIRON$("BLASTER"), Length% + 1, 1))
         CASE "D"
           DMA% = VAL(MID$(ENVIRON$("BLASTER"), Length% + 1, 1))
      END SELECT
   NEXT
END SUB

SUB InitLib
  ' MOUSE ROUTINES: HARDIN'BROS
   MouseSetup
   MouseReady% = MouseInit
   ' PARA LA BLASTER:
   GetBLASTER Channel%, BasePort%, IRQ%
   i% = ResetDSP%
   SpeakerState 1
'   TocaWAV "DATA\WAKE.VOC", 44100
END SUB

SUB LoadFont (n$)
   DEF SEG = VARSEG(vl%(0, 0))
   BLOAD n$, VARPTR(vl%(0, 0))
   DEF SEG
END SUB

SUB MouseCall
   DEF SEG = VARSEG(MouseRoutine%(0))
   Addr% = VARPTR(MouseRoutine%(0))
   CALL Absolute(MReg, Addr%)
   DEF SEG
END SUB

SUB MouseGetPressInfo (LBtn%, RBtn%, MBtn%, Count%, HPosn%, VPosn%)
  IF MouseReady% THEN
    IF (LBtn% OR RBtn% OR MBtn%) <> 0 THEN
      MReg.AX = 5
      IF LBtn% THEN MReg.BX = 0
      IF RBtn% THEN MReg.BX = 1
      IF MBtn% THEN MReg.BX = 2
      MouseCall
      LBtn% = MReg.AX AND 1
      RBtn% = (MReg.AX AND 2) \ 2
      MBtn% = (MReg.AX AND 4) \ 4
      Count% = MReg.BX
      HPosn% = MReg.CX
      VPosn% = MReg.DX
    ELSE
      CALL MouseGetStatus(LBtn%, RBtn%, MBtn%, HPosn%, VPosn%)
      Count% = 0
    END IF
  ELSE
    LBtn% = 0: RBtn% = 0: MBtn% = 0
    Count% = 0
    HPosn% = -1: VPosn% = -1
  END IF
END SUB

SUB MouseGetReleaseInfo (LBtn%, RBtn%, MBtn%, Count%, HPosn%, VPosn%)
  IF MouseReady% THEN
    IF (LBtn% OR RBtn% OR MBtn%) <> 0 THEN
      MReg.AX = 6
      IF LBtn% THEN MReg.BX = 0
      IF RBtn% THEN MReg.BX = 1
      IF MBtn% THEN MReg.BX = 2
      MouseCall
      LBtn% = MReg.AX AND 1
      RBtn% = (MReg.AX AND 2) \ 2
      MBtn% = (MReg.AX AND 4) \ 4
      Count% = MReg.BX
      HPosn% = MReg.CX
      VPosn% = MReg.DX
    ELSE
      CALL MouseGetStatus(LBtn%, RBtn%, MBtn%, HPosn%, VPosn%)
      Count% = 0
    END IF
  ELSE
    LBtn% = 0: RBtn% = 0: MBtn% = 0
    Count% = 0
    HPosn% = -1: VPosn% = -1
  END IF
END SUB

SUB MouseGetStatus (LBtn%, RBtn%, MBtn%, HPosn%, VPosn%)
  IF MouseReady% THEN
    MReg.AX = 3
    MouseCall
    LBtn% = MReg.BX AND 1
    RBtn% = (MReg.BX AND 2) \ 2
    MBtn% = (MReg.BX AND 4) \ 4
    HPosn% = MReg.CX
    VPosn% = MReg.DX
  ELSE
    LBtn% = 0: RBtn% = 0: MBtn% = 0
    HPosn% = -1: VPosn% = -1
  END IF
END SUB

SUB mousehide
  IF MouseReady% THEN
    MReg.AX = 2
    MouseCall
  END IF
END SUB

FUNCTION MouseInit%
  DEF SEG = 0
  Sum% = 0
  FOR i% = &H33 * 4 TO &H33 * 4 + 3
    Sum% = Sum% + PEEK(i%)
  NEXT i%
  IF Sum% = 0 THEN
    MouseInit% = 0
    EXIT FUNCTION
  END IF
  MReg.AX = 0
  MouseCall
  IF MReg.AX = 0 THEN
    MouseInit% = 0
  ELSE
    MouseInit% = MReg.BX
  END IF
END FUNCTION

SUB MouseSetPosn (HPosn%, VPosn%)
  IF MouseReady% THEN
    MReg.AX = 4
    MReg.CX = HPosn%
    MReg.DX = VPosn%
    MouseCall
  END IF
END SUB

SUB MouseSetup
   MouseRoutine$ = CHR$(&H55) + CHR$(&H89) + CHR$(&HE5) + CHR$(&H56) + CHR$(&H8B)
   MouseRoutine$ = MouseRoutine$ + CHR$(&H76) + CHR$(&H6) + CHR$(&H8B) + CHR$(&H4)
   MouseRoutine$ = MouseRoutine$ + CHR$(&H8B) + CHR$(&H5C) + CHR$(&H2) + CHR$(&H8B)
   MouseRoutine$ = MouseRoutine$ + CHR$(&H4C) + CHR$(&H4) + CHR$(&H8B) + CHR$(&H54)
   MouseRoutine$ = MouseRoutine$ + CHR$(&H6) + CHR$(&H8E) + CHR$(&H44) + CHR$(&H8)
   MouseRoutine$ = MouseRoutine$ + CHR$(&HCD) + CHR$(&H33) + CHR$(&H8C) + CHR$(&H44)
   MouseRoutine$ = MouseRoutine$ + CHR$(&H8) + CHR$(&H89) + CHR$(&H54) + CHR$(&H6)
   MouseRoutine$ = MouseRoutine$ + CHR$(&H89) + CHR$(&H4C) + CHR$(&H4) + CHR$(&H89)
   MouseRoutine$ = MouseRoutine$ + CHR$(&H5C) + CHR$(&H2) + CHR$(&H89) + CHR$(&H4)
   MouseRoutine$ = MouseRoutine$ + CHR$(&H5E) + CHR$(&H5D) + CHR$(&HCB)
   DEF SEG = VARSEG(MouseRoutine%(0))
   Addr% = VARPTR(MouseRoutine%(0))
   FOR i = 0 TO 39
      a$ = MID$(MouseRoutine$, i + 1)
     POKE Addr% + i, ASC(a$)
   NEXT i
   DEF SEG
END SUB

SUB mouseshow
  IF MouseReady% THEN
    MReg.AX = 1
    MouseCall
  END IF
END SUB

FUNCTION ReadDSP%
' Reads a byte from the DSP
   DO
   LOOP UNTIL INP(BasePort% + 14) AND &H80
   ReadDSP% = INP(BasePort% + 10)
END FUNCTION

FUNCTION ResetDSP%
   PRINT "DSP Reset; Baseport:"; BasePort%
   ' Resets the DSP
   OUT BasePort% + 6, 1
   FOR Count% = 1 TO 4
      junk% = INP(BasePort% + 6)
   NEXT
   OUT BasePort% + 6, 0
   IF INP(BasePort% + 14) AND &H80 = &H80 AND INP(BasePort% + 10) = &HAA THEN
      ResetDSP% = -1
   ELSE
      ResetDSP% = 0
   END IF
END FUNCTION

SUB SetMode (mode%)
   ScreenMode% = mode%        ' Esto no hace ninguna comprobacin,
   SCREEN mode%               ' as que ten cuidadn...
END SUB

SUB SetStereo (OnOff%)
   OUT BasePort% + 4, &HE
   IF OnOff% THEN OUT BasePort% + 5, 2 ELSE OUT BasePort% + 5, 0
END SUB

SUB SpeakerState (OnOff%)
   ' Turns speaker on or off.
   IF OnOff% THEN WriteDSP &HD1 ELSE WriteDSP &HD3
END SUB

FUNCTION SpeakerStatus%
   OUT BasePort% + 4, &HD8
   IF INP(BasePort% + 5) = &HFF THEN SpeakerStatus% = -1 ELSE SpeakerStatus% = 0
END FUNCTION

SUB TocaWAV (file$, freq&)
   SpeakerState 1
   'MasterVolume 15, 15, 0
   DIM WavBuffer(1 TO 1) AS STRING * 20000
   FileName$ = file$
   OPEN FileName$ FOR BINARY AS #1
      GET #1, 44, WavBuffer(1)
      Length& = LOF(1) - 44
   CLOSE
   IF Length& > 20000 THEN Length& = 20000
   DMAPlay VARSEG(WavBuffer(1)), VARPTR(WavBuffer(1)), Length&, freq&
   DO: LOOP UNTIL DMADone%
   ERASE WavBuffer
END SUB

SUB TocaWAVBG (file$, freq&)
   IF NOT DMADone% THEN EXIT SUB
   DIM WavBuffer(1 TO 1) AS STRING * 20000
   FileName$ = file$
   OPEN FileName$ FOR BINARY AS #1
      GET #1, 44, WavBuffer(1)
      Length& = LOF(1) - 44
   CLOSE
   IF Length& > 20000 THEN Length& = 20000
   IF NOT DMADone% THEN EXIT SUB
   DMAPlay VARSEG(WavBuffer(1)), VARPTR(WavBuffer(1)), Length&, freq&
   ERASE WavBuffer
END SUB

SUB TocaWAVBGx (file$, freq&)
   'MasterVolume 15, 15, 0
   DIM WavBuffer(1 TO 1) AS STRING * 20000
   FileName$ = file$
   OPEN FileName$ FOR BINARY AS #1
      GET #1, 44, WavBuffer(1)
      Length& = LOF(1) - 44
   CLOSE
   IF Length& > 20000 THEN Length& = 20000
   IF NOT DMADone% THEN EXIT SUB
   DMAPlay VARSEG(WavBuffer(1)), VARPTR(WavBuffer(1)), Length&, freq&
   ERASE WavBuffer
END SUB

SUB Tp (x%, y%, c%, t$)
   FOR h% = 1 TO LEN(t$)
      m$ = MID$(t$, h%, 1)
      FOR k% = 0 TO 7
         v% = vl%(ASC(m$), k%)
         LINE (x%, y% + k%)-(x% + 4, y% + k%), c%, , CVI(CHR$(0) + CHR$(v%))
      NEXT k%
      x% = x% + 5
   NEXT h%
END SUB

SUB WaitTm (t!)
   tt! = TIMER
   WHILE tt! + t! > TIMER
   WEND
END SUB

SUB WriteDAC (byte%)
   ' Writes a byte to the DAC.
   WriteDSP &H10
   WriteDSP byte%
END SUB

SUB WriteDSP (byte%)
   ' Writes a byte to the DSP
   DO
   LOOP WHILE INP(BasePort% + 12) AND &H80
   OUT BasePort% + 12, byte%
END SUB

SUB Wt
   mouseshow
   DO
      LoopMidi
      MouseGetStatus l%, r%, m%, x%, y%
   LOOP WHILE (r% OR l% OR INKEY$ <> "")
   DO
      LoopMidi
      MouseGetStatus l%, r%, m%, x%, y%
   LOOP WHILE r% = 0 AND l% = 0 AND INKEY$ = ""
   IF ScreenMode% = 1 OR ScreenMode% = 7 OR ScreenMode% = 13 THEN MouseX = x% \ 2
   MouseY = y%
   mousehide
END SUB

SUB WtWSecs (seconds!)
   mouseshow
   DO
      LoopMidi
      MouseGetStatus l%, r%, m%, x%, y%
   LOOP WHILE (r% OR l% OR INKEY$ <> "")
   tempo! = TIMER
   DO
      LoopMidi
      MouseGetStatus l%, r%, m%, x%, y%
   LOOP WHILE r% = 0 AND l% = 0 AND INKEY$ = "" AND tempo! + seconds! > TIMER
   IF ScreenMode% = 1 OR ScreenMode% = 7 OR ScreenMode% = 13 THEN MouseX = x% \ 2
   MouseY = y%
   mousehide
END SUB

