'****************************************************************************
'* T_GRAPH.BAS
'* Graphics functions for TROOPERS.BAS
'* Version 0.5
'****************************************************************************
'* Coded by Ben Bosco of Aspect Productions
'****************************************************************************
DEFINT A-Z
'$DYNAMIC
'$INCLUDE: 'SOURCE\TRPRS.BI'
'$INCLUDE: 'SOURCE\_LIB.BI'

'***************************************************************************
' Returns the length (in pixels) of the specified string
'***************************************************************************
FUNCTION f.font.findwidth (str AS STRING)
   DIM iCurFont, iWid, i

   str = RTRIM$(str)

   iWid = 0
   FOR i = 1 TO LEN(str)
      iCurFont = ASC(MID$(str, i, 1)) - 32
      iWid = iWid + iFontWidth(iCurFont) + 1
   NEXT i
   f.font.findwidth = iWid
END FUNCTION

'***************************************************************************
' Loads the font image data into the font string
'***************************************************************************
FUNCTION f.font.load (strFileName AS STRING)
   DIM i, ii, l&

   ff = FREEFILE
   OPEN strFileName FOR BINARY AS ff: l& = LOF(ff): CLOSE ff
   IF l& = 0 THEN
      KILL strFileName
      f.font.load = FALSE
      EXIT FUNCTION
   END IF

   OPEN strFileName FOR BINARY AS ff
      GET ff, , strFont
      FOR ii = 0 TO 16 * 6
         GET ff, , iFontWidth(ii)
      NEXT ii
   CLOSE ff
   f.font.load = TRUE
END FUNCTION

'****************************************************************************
'* Loads image/sprite data from file
'****************************************************************************
FUNCTION f.main.loadspritebank (strFileName AS STRING, spr() AS spriteType, si)
   DIM numSprites, datasize AS LONG
   DIM image AS STRING * 1024
   
   f.main.loadspritebank = TRUE
   ff = FREEFILE
   OPEN strFileName FOR BINARY AS ff: l& = LOF(ff): CLOSE ff
   IF l& = 0 THEN
      KILL strFileName
      f.main.loadspritebank = FALSE
      EXIT FUNCTION
   END IF

   OPEN strFileName FOR BINARY AS ff
      GET ff, , numSprites

      datasize = 0
      GET ff, , spr(si)
      datasize = (spr(si).width * spr(si).hite) * numSprites
      spr(si).xmsOffset = curXMS

      DO
         GET ff, , image
         lhz.xmspaste VARSEG(image), VARPTR(image), curXMS, 1024
         IF datasize < 1024 THEN
            curXMS = curXMS + datasize
         ELSE
            curXMS = curXMS + 1024
         END IF
         datasize = datasize - 1024
      LOOP UNTIL datasize <= 0

   CLOSE ff
END FUNCTION

'****************************************************************************
'* Extracts and sets the palette information from a pcx image file
'****************************************************************************
FUNCTION f.pcx.getpal (strFileName AS STRING, pal AS STRING)
   DIM i

   f.pcx.getpal = TRUE

   ff = FREEFILE
   OPEN strFileName FOR BINARY AS ff: l& = LOF(ff): CLOSE ff
   IF l& = 0 THEN
      KILL strFileName
      f.pcx.getpal = FALSE
      EXIT FUNCTION
   END IF

   OPEN strFileName FOR BINARY AS ff
      GET ff, LOF(ff) - 767, pal
      FOR i = 0 TO 255
         r = ASC(MID$(pal, i * 3 + 1)) \ 4
         g = ASC(MID$(pal, i * 3 + 2)) \ 4
         b = ASC(MID$(pal, i * 3 + 3)) \ 4
         MID$(pal, i * 3 + 1) = CHR$(r)
         MID$(pal, i * 3 + 2) = CHR$(g)
         MID$(pal, i * 3 + 3) = CHR$(b)
      NEXT i
   CLOSE ff
END FUNCTION

'****************************************************************************
'* loads image data of pcx file into the specified buffer
'****************************************************************************
FUNCTION f.pcx.load (strFileName AS STRING, segBuffer)
   DIM numBytes, index
   DIM count AS LONG
   DIM curData AS STRING * 1
   DIM iData
   DIM pcxHeader AS PCXHeaderType

   f.pcx.load = TRUE

   ff = FREEFILE
   OPEN strFileName FOR BINARY AS ff: l& = LOF(ff): CLOSE ff
   IF l& = 0 THEN
      KILL strFileName
      f.pcx.load = FALSE
      EXIT FUNCTION
   END IF

   DEF SEG = segBuffer

   OPEN strFileName FOR BINARY AS ff
      GET ff, , pcxHeader

      count = 0

      WHILE (count <= CLNG(pcxHeader.width + 1) * (pcxHeader.height + 1))
         GET ff, , curData
         iData = ASC(curData)
         IF iData >= 192 AND iData <= 255 THEN
            numBytes = iData - 192
            GET ff, , curData
            iData = ASC(curData)
            WHILE (numBytes > 0)
               numBytes = numBytes - 1
               POKE count, iData
               count = count + 1
            WEND
         ELSE
            POKE count, iData
            count = count + 1
         END IF
      WEND

CLOSE ff
   
END FUNCTION

'****************************************************************************
'* Adds a bob to the bob list. Bobs are are sorted in y order in bobDraw.
'* Putfirst indicates that this bob should be drawn before all others
'****************************************************************************'
SUB s.bob.add (x, y, spr, sprindex, flipflag, putfirst)
   IF x - stSprite(spr).hotspot.x - stScr.pos.x + stSprite(spr).width - 1 >= 0 AND x - stSprite(spr).hotspot.x - stScr.pos.x < 320 - CLIPSCRX1 THEN
      IF y - stSprite(spr).hotspot.y - stScr.pos.y + stSprite(spr).hite - 1 >= 0 AND y - stSprite(spr).hotspot.y - stScr.pos.y < 200 THEN
         stBob(iBobNum).pos.x = x - stScr.pos.x + CLIPSCRX1
         stBob(iBobNum).pos.y = y - stScr.pos.y
         stBob(iBobNum).flip = flipflag
         stBob(iBobNum).spr = spr
         stBob(iBobNum).sprindex = sprindex
         stBob(iBobNum).putfirst = putfirst
         stBob(iBobNum).scale = 100
         iBobNum = iBobNum + 1
      END IF
   END IF
END SUB

'****************************************************************************
' Sorts all bobs in list in y order (unless they putfirst is true), then
' draws them on the screen.
'****************************************************************************
SUB s.bob.draw (destBuffer, destOff)
   DIM i, j, sorted

   sorted = TRUE
   FOR i = 0 TO iBobNum - 1
      FOR j = 0 TO iBobNum - 2
         IF stBob(j + 1).putfirst THEN
            SWAP stBob(j), stBob(j + 1)
            sorted = FALSE
         ELSE
            IF (stBob(j).pos.y > stBob(j + 1).pos.y AND stBob(j).putfirst = FALSE) THEN
               SWAP stBob(j), stBob(j + 1)
               sorted = FALSE
            END IF
         END IF
      NEXT j
      IF sorted THEN EXIT FOR
   NEXT i
   IF iBobNum > 1 THEN
      IF stBob(iBobNum - 1).putfirst THEN SWAP stBob(iBobNum - 1), stBob(iBobNum - 2)
   END IF
   FOR i = 0 TO iBobNum - 1
      s.bob.put destBuffer, destOff, stBob(i).pos.x, stBob(i).pos.y, stBob(i).spr, stBob(i).sprindex, BPUT, stBob(i).flip, stBob(i).scale
   NEXT i

   iBobNum = 0
END SUB

'****************************************************************************
' Places a sprite on the screen. PUTTYPE is either put (which supports
' transparency) or paste. Flipping is also supported.
'****************************************************************************
SUB s.bob.put (destBuffer, destOff, x, y, sprt, sprnum, PUTTYPE, flip, scale)
   DIM sproffset AS LONG, spr AS spriteType
   spr = stSprite(sprt)

   sproffset = sprnum * spr.width * spr.hite
   lhz.xmscopy spr.xmsOffset + sproffset, VARSEG(iSprBuffer(0)), VARPTR(iSprBuffer(0)), spr.width * spr.hite

   IF scale = 100 THEN
      IF PUTTYPE = BPUT THEN
         lhz.put destBuffer, destOff, x - spr.hotspot.x, y - spr.hotspot.y, spr.width, spr.hite, VARSEG(iSprBuffer(0)), VARPTR(iSprBuffer(0)), flip, 0
      ELSE
         lhz.paste destBuffer, destOff, x - spr.hotspot.x, y - spr.hotspot.y, spr.width, spr.hite, VARSEG(iSprBuffer(0)), VARPTR(iSprBuffer(0))
      END IF
   ELSE
      lhz.scalesprite destBuffer, destOff, x, y, spr.width, spr.hite, VARSEG(iSprBuffer(0)), VARPTR(iSprBuffer(0)), scale
   END IF
END SUB

'****************************************************************************
'* Places a font on specified buffer (wow)
'****************************************************************************
SUB s.font.put (destBuffer, destOff, BYVAL x, BYVAL y, str AS STRING, col, shadow, bTeleType)
   DIM curfont, i

   str = LTRIM$(RTRIM$(str))
   FOR i = 1 TO LEN(str)
      curfont = ASC(MID$(str, i, 1)) - 32
      IF shadow THEN
         lhz.put destBuffer, destOff, x + 1, y + 1, FONTWID, FONTHITE, VARSEG(strFont), VARPTR(strFont) + curfont * FONTWID * FONTHITE, FALSE, 15
         lhz.put destBuffer, destOff, x, y + 1, FONTWID, FONTHITE, VARSEG(strFont), VARPTR(strFont) + curfont * FONTWID * FONTHITE, FALSE, 15
      END IF
      lhz.put destBuffer, destOff, x, y, FONTWID, FONTHITE, VARSEG(strFont), VARPTR(strFont) + curfont * FONTWID * FONTHITE, FALSE, col
      x = x + iFontWidth(curfont) + 1
      IF bTeleType AND lhz.mouseb = 0 THEN
         FOR cx = 0 TO 2
            lhz.waitvbl
         NEXT cx
      END IF
   NEXT i
END SUB

REM $STATIC
SUB s.graph.fadetocol (pal AS STRING, ir, ig, ib, fade, iStart, iEnd)
   DIM i, cr, cg, cb

   IF fade = -1 THEN
      FOR i = iStart TO iEnd
         MID$(pal, i * 3 + 1, 1) = CHR$(ir)
         MID$(pal, i * 3 + 2, 1) = CHR$(ig)
         MID$(pal, i * 3 + 3, 1) = CHR$(ib)
         OUT &H3C8, i
         OUT &H3C9, ir
         OUT &H3C9, ig
         OUT &H3C9, ib
      NEXT i
   ELSE
      FOR ii = 0 TO 63
         FOR i = iStart TO iEnd
            cr = ASC(MID$(pal, i * 3 + 1, 1))
            cg = ASC(MID$(pal, i * 3 + 2, 1))
            cb = ASC(MID$(pal, i * 3 + 3, 1))
            cr = cr + SGN(ir - cr)
            cg = cg + SGN(ig - cg)
            cb = cb + SGN(ib - cb)
            MID$(pal, i * 3 + 1, 1) = CHR$(cr)
            MID$(pal, i * 3 + 2, 1) = CHR$(cg)
            MID$(pal, i * 3 + 3, 1) = CHR$(cb)

            OUT &H3C8, i
            OUT &H3C9, cr
            OUT &H3C9, cg
            OUT &H3C9, cb
         NEXT i
         IF fade > 0 THEN
            FOR i = 0 TO fade - 1
               lhz.waitvbl
            NEXT i
         END IF
      NEXT ii
   END IF
END SUB

SUB s.graph.fadetopal (pal AS STRING, newpal AS STRING, fade, iStart, iEnd)
   DIM i, cr, cg, cb, ir, ig, ib

   IF fade = -1 THEN
      FOR i = iStart TO iEnd
         OUT &H3C8, i
         OUT &H3C9, ASC(MID$(newpal, i * 3 + 1, 1))
         OUT &H3C9, ASC(MID$(newpal, i * 3 + 2, 1))
         OUT &H3C9, ASC(MID$(newpal, i * 3 + 3, 1))
      NEXT i
      pal = newpal
   ELSE
      FOR ii = 0 TO 63
         FOR i = iStart TO iEnd
            cr = ASC(MID$(pal, i * 3 + 1, 1))
            cg = ASC(MID$(pal, i * 3 + 2, 1))
            cb = ASC(MID$(pal, i * 3 + 3, 1))
            ir = ASC(MID$(newpal, i * 3 + 1, 1))
            ig = ASC(MID$(newpal, i * 3 + 2, 1))
            ib = ASC(MID$(newpal, i * 3 + 3, 1))

            cr = cr + SGN(ir - cr)
            cg = cg + SGN(ig - cg)
            cb = cb + SGN(ib - cb)
            MID$(pal, i * 3 + 1, 1) = CHR$(cr)
            MID$(pal, i * 3 + 2, 1) = CHR$(cg)
            MID$(pal, i * 3 + 3, 1) = CHR$(cb)

            OUT &H3C8, i
            OUT &H3C9, cr
            OUT &H3C9, cg
            OUT &H3C9, cb
         NEXT i
         IF fade > 0 THEN
            FOR i = 0 TO fade - 1
               lhz.waitvbl
            NEXT i
         END IF
      NEXT ii
   END IF

END SUB

SUB s.graph.setpal (pal AS STRING)
   FOR i = 0 TO 255
      OUT &H3C8, i
      OUT &H3C9, ASC(MID$(pal, i * 3 + 1, 1))
      OUT &H3C9, ASC(MID$(pal, i * 3 + 2, 1))
      OUT &H3C9, ASC(MID$(pal, i * 3 + 3, 1))
   NEXT i
END SUB

