;*_LGRPH.ASM ****************************************************************
;* Assembly graphics module for quickbasic ver 7.1
;* Version 0.1
;* Coded by Ben Bosco
;* Last updated 9th April 2002
;****************************************************************************

.model  medium, basic
.386
.stack  200h

;* constants ****************************************************************
CLIP_X1         EQU     0
CLIP_X2         EQU     319
CLIP_Y1         EQU     0
CLIP_Y2         EQU     199
FALSE           EQU     0
TRUE            EQU     0FFFFh

.data
w_bufwidth      dw      320
w_bufclipx      dw      319
.code
public  lhzscr, lhzput, lhzpaste, lhzwaitvbl, lhzfill
public  lhzplot, lhzrect, lhzsetbufwidth
public  lhzhline, lhzvline, lhzsolrect, lhzscalesprite

;****************************************************************************
;* sub lhzsetbufwidth(nwid%)
;* Sets the width of the current graphics buffer
;****************************************************************************
lhzsetbufwidth  proc    uses ds, n_wid:word
        mov     ax, n_wid
        mov     w_bufwidth, ax
        dec     ax
        mov     w_bufclipx, ax
        ret
lhzsetbufwidth  endp

;****************************************************************************
;* sub lhzscr(nmode%)
;* Sets the screen mode to value specified in hex.
;****************************************************************************
lhzscr  proc    uses ds, n_mode:word
        mov     ax, n_mode
        int     10h
        ret
lhzscr  endp

;****************************************************************************
;* sub lhzput(ndseg%, nx%, ny%, nwid%, nhite%, nsseg%, nsoff%, nFlip%
;* Places a sprite down from the specified buffer to the destination screen
;****************************************************************************
lhzput  proc    uses ds es, n_dseg:word, n_doff:word, n_x:word, n_y:word, n_wid:word, n_hite:word, n_sseg:word, n_soff:word, n_flip:word, n_solcol:word
        local   n_new_wid:word, n_new_hite:word, w_flip_dir:word
        local   w_flip_add:word
        local   t_clipx:word, t_wid:word

        mov     ax, w_bufclipx
        mov     t_clipx, ax
        mov     ax, w_bufwidth
        mov     t_wid, ax

;* es:[di] points to screen buffer (ems/conv)
        mov     ax, n_dseg
        mov     es, ax

;* set ds to sprite seg
        mov     ax, n_sseg
        mov     ds, ax
        mov     si, n_soff
        mov     ax, n_wid
        mov     n_new_wid, ax
        mov     ax, n_hite
        mov     n_new_hite, ax

        cmp     n_flip, FALSE
        je      _skip_flip1
        add     si, n_wid
        dec     si

_skip_flip1:
;* if sprite is off the screen then end
        mov     ax, n_y
        cmp     ax, CLIP_Y2
        jg      _end_lhzput

;* alter visible sprite dimensions if only part of sprite is seen
        cmp     ax, CLIP_Y1
        jge     _skip_high_adjust
        add     ax, n_hite
        dec     ax
        cmp     ax, CLIP_Y1
        jl      _end_lhzput
        inc     ax
        mov     n_new_hite, ax
        mov     ax, n_y
        mul     n_new_wid
        sub     si, ax
        mov     n_y, CLIP_Y1
   
_skip_high_adjust:
        mov     ax, n_x
        cmp     ax, t_clipx
        jg      _end_lhzput

        cmp     ax, CLIP_X1
        jge     _skip_wid_adjust
        add     ax, n_wid
        dec     ax
        cmp     ax, CLIP_X1
        jl      _end_lhzput
        inc     ax
        mov     n_new_wid, ax
        sub     si, n_x
        cmp     n_flip, FALSE
        je      _skip_flip2
        add     si, n_x
        add     si, n_x

_skip_flip2:
        mov     n_x, CLIP_X1
   
_skip_wid_adjust:
        mov     ax, n_x
        add     ax, n_wid
        dec     ax
        cmp     ax, t_clipx
        jle     _skip_xover
        mov     ax, t_wid
        sub     ax, n_x
        mov     n_new_wid, ax

_skip_xover:
        mov     ax, n_y
        add     ax, n_hite
        dec     ax
        cmp     ax, CLIP_Y2
        jle     _skip_yover
        mov     ax, 200
        sub     ax, n_y
        mov     n_new_hite, ax
    
_skip_yover:
;* determine starting offset on screen 
        mov     cx, 0
        mov     dx, 0
        mov     ax, n_y

        mul     t_wid
        mov     di, ax

        add     di, n_x
        add     di, n_doff

;* If no flipping, store default values
        mov     w_flip_dir, 1
        mov     ax, n_new_wid
        mov     w_flip_add, ax

        cmp     n_flip, FALSE
        je      _skip_flip3
        mov     w_flip_dir, -1
        neg     w_flip_add

_skip_flip3:
        cmp     n_solcol, 0
        jne     _sol_routine

_xx:
        mov     bl, [si]
        add     si, w_flip_dir
        cmp     bl, 0
        je      _skip_pix
        mov     es:[di], bl

_skip_pix:
        inc     cx
        inc     di
        cmp     cx, n_new_wid
        jl      _xx

        xor     cx, cx
        sub     di, n_new_wid

        add     si, n_wid
        sub     si, w_flip_add


        add     di, t_wid
        inc     dx
        cmp     dx, n_new_hite
        jl      _xx
        jmp     _end_lhzput

;* main routine for solid puts
_sol_routine:
        mov     bh, byte ptr n_solcol
_xx_s:
        mov     bl, [si]
        add     si, w_flip_dir
        cmp     bl, 0
        je      _skip_pix_s
        mov     es:[di], bh

_skip_pix_s:
        inc     cx
        inc     di
        cmp     cx, n_new_wid
        jl      _xx_s

        xor     cx, cx
        sub     di, n_new_wid

        add     si, n_wid
        sub     si, w_flip_add


        add     di, t_wid
        inc     dx
        cmp     dx, n_new_hite
        jl      _xx_s

_end_lhzput:
        ret
lhzput  endp

;****************************************************************************
;* sub lhzpaste(ndseg%, nx%, ny%, nwid%, nhite%, nsseg%, nsoff%
;* Places a sprite down from the specified buffer to the destination screen
;* but does not check for transparency and is faster than lhzput.
;****************************************************************************

lhzpaste  proc    uses ds es, n_dseg:word, n_doff:word, n_x:word, n_y:word, n_wid:word, n_hite:word, n_sseg:word, n_soff:word
        local   n_new_wid:word, n_new_hite:word
        local   t_clipx:word, t_wid:word

        mov     ax, w_bufclipx
        mov     t_clipx, ax
        mov     ax, w_bufwidth
        mov     t_wid, ax


;* es:[di] points to screen buffer (ems/conv)
        mov     ax, n_dseg
        mov     es, ax

;* set ds to sprite seg
        mov     ax, n_sseg
        mov     ds, ax
        mov     si, n_soff
        mov     ax, n_wid
        mov     n_new_wid, ax
        mov     ax, n_hite
        mov     n_new_hite, ax

        mov     ax, n_y
        cmp     ax, CLIP_Y2
        jg      _end_lhzputp

        cmp     ax, CLIP_Y1
        jge     _skip_high_adjustp
        add     ax, n_hite
        dec     ax
        cmp     ax, CLIP_Y1
        jl      _end_lhzputp
        inc     ax
        mov     n_new_hite, ax
        mov     ax, n_y
        mul     n_new_wid
        sub     si, ax
        mov     n_y, CLIP_Y1
   
_skip_high_adjustp:
        mov     ax, n_x
        cmp     ax, t_clipx
        jg      _end_lhzputp

        cmp     ax, CLIP_X1
        jge     _skip_wid_adjustp
        add     ax, n_wid
        dec     ax
        cmp     ax, CLIP_X1
        jl      _end_lhzputp
        inc     ax
        mov     n_new_wid, ax
        sub     si, n_x
        mov     n_x, CLIP_X1
   
_skip_wid_adjustp:
        mov     ax, n_x
        add     ax, n_wid
        dec     ax
        cmp     ax, t_clipx
        jle     _skip_xoverp
        mov     ax, t_wid
        sub     ax, n_x
        mov     n_new_wid, ax

_skip_xoverp:
        mov     ax, n_y
        add     ax, n_hite
        dec     ax
        cmp     ax, CLIP_Y2
        jle     _skip_yoverp
        mov     ax, 200
        sub     ax, n_y
        mov     n_new_hite, ax
    
_skip_yoverp:
        mov     cx, 0
        mov     dx, 0

        mov     ax, n_y

        mul     t_wid
        mov     di, ax

        add     di, n_x
        add     di, n_doff

        mov     bx, n_new_wid

;* The main loop can be speeded up by determing if word or double word copies
;* can be used...
        test    bx, 01
        jnz     _xxp_byte
        test    bx, 02
        jnz     _xxp_word_init

        shr     bx, 02
_xxp_dword:
        mov     cx, bx
        rep     movsd

        sub     di, n_new_wid
        add     si, n_wid
        sub     si, n_new_wid
        add     di, t_wid
        inc     dx
        cmp     dx, n_new_hite
        jl      _xxp_dword
        jmp     _end_lhzputp

_xxp_word_init:
        shr     bx, 01
_xxp_word:
        mov     cx, bx
        rep     movsw

        sub     di, n_new_wid
        add     si, n_wid
        sub     si, n_new_wid
        add     di, t_wid
        inc     dx
        cmp     dx, n_new_hite
        jl      _xxp_word
        jmp     _end_lhzputp

_xxp_byte:
        mov     cx, bx
        rep     movsb

        sub     di, n_new_wid
        add     si, n_wid
        sub     si, n_new_wid
        add     di, t_wid
        inc     dx
        cmp     dx, n_new_hite
        jl      _xxp_byte

_end_lhzputp:
        ret
lhzpaste        endp

;****************************************************************************
;* sub lhzwaitvbl()
;* Waits until the monitor has reached its vertical refresh state.
;****************************************************************************
lhzwaitvbl      proc
_first_vbl:
        mov     dx, 3DAh
        in      al, dx
        test    al, 8
        jnz     _first_vbl

_second_vbl:
        in      al, dx
        test    al, 8
        jz      _second_vbl
        ret
lhzwaitvbl      endp

;****************************************************************************
;* sub lhzfill()
;* Fills a variable sized buffer with the specified byte.
;* Buffer size must be divisible by 4 for this function to work reliably
;****************************************************************************
lhzfill proc    uses ds es, n_dseg:word, n_doff:word, n_bytes:dword, n_col:word
        mov     es, n_dseg
        mov     di, n_doff
        mov     dx, n_col
        mov     dh, dl
        mov     ax, dx
        shl     eax, 16
        mov     ax, dx
        mov     cx, word ptr n_bytes
        shr     cx, 02
        rep     stosd
        ret
lhzfill endp

;****************************************************************************
;* sub lhzplot(ndseg%, nx%, ny%, ncol%)
;* Plots a pixel at specified coords on specified screen buffer
;****************************************************************************
lhzplot proc    uses ds es, n_dseg:word, n_doff:word, n_x:word, n_y:word, n_col:word
        cmp     n_x, CLIP_X1
        jl      _skip_pset
        cmp     n_x, CLIP_X2
        jg      _skip_pset
        cmp     n_y, CLIP_Y1
        jl      _skip_pset
        cmp     n_y, CLIP_Y2
        jg      _skip_pset

        mov     cx, n_col
        mov     es, n_dseg
        xor     si, si
        mov     ax, n_y
        mov     bx, ax
        xchg    ah, al        
        shl     bx, 06
        add     ax, bx
        add     si, ax
        add     si, n_x
        add     si, n_doff
        mov     es:[si], cl

_skip_pset:
        ret
lhzplot EndP

;****************************************************************************
;* sub lhzrect(ndseg%, nx1%, ny1%, nx2%, ny2%, ncol%)
;* Draws a rectangle to the destination screen
;****************************************************************************
lhzrect proc    uses ds es, n_dseg:word, n_x1:word, n_y1:word, n_x2:word, n_y2:word, n_col:word
        mov     ax, n_x1
        mov     bx, n_x2
        cmp     ax, bx
        jle     _no_swap_x2
        xchg    ax, bx

_no_swap_x2:
        mov     n_x1, ax
        mov     n_x2, bx
        mov     ax, n_y1
        mov     bx, n_y2
        cmp     ax, bx
        jle     _no_swap_y2
        xchg    ax, bx

_no_swap_y2:
        mov     n_y1, ax
        mov     n_y2, bx

        mov     ax, n_dseg
        mov     es, ax

        mov     bx, n_x1
        mov     dx, n_y1
        
_box_loop:
        cmp     bx, CLIP_X1
        jl      _skip_box_plot
        cmp     bx, CLIP_X2
        jg      _skip_box_plot
        cmp     dx, CLIP_Y1
        jl      _skip_box_plot
        cmp     dx, CLIP_Y2
        jg      _skip_box_plot

        cmp     dx, n_y1
        je      _skip_box_type
        cmp     dx, n_y2
        je      _skip_box_type
        cmp     bx, n_x1
        je      _skip_box_type
        cmp     bx, n_x2
        je      _skip_box_type
        jmp     _skip_box_plot

_skip_box_type:
        mov     di, dx
        mov     si, di
        shl     di, 08
        shl     si, 06
        add     di, si
        add     di, bx
        mov     ax, n_col
        mov     es:[di], al

_skip_box_plot:
        inc     bx
        cmp     bx, n_x2
        jle     _box_loop
        mov     ax, n_x2
        sub     ax, n_x1
        sub     bx, ax
        dec     bx
        inc     dx
        cmp     dx, n_y2
        jle     _box_loop

        ret
lhzrect endp

;****************************************************************************
;* sub lhzvline(ndseg%, nx%, ny1%, ny2%, ncol%)
;* Draws a vertical line on destination screen. Does not support clipping
;* and fails to work correctly if y1>y2, so watch it =)
;****************************************************************************
lhzvline proc   uses ds es, n_dseg:word, n_doff:word, n_x:word, n_y1:word, n_y2:word, n_col:word
        mov     ax, n_y1
        mul     w_bufwidth
        mov     di, ax
        add     di, n_x
        add     di, n_doff

        mov     cx, n_y2
        sub     cx, n_y1
        inc     cx

        mov     es, n_dseg
        mov     ah, byte ptr n_col

_vertline_loop:
        mov     es:[di], ah
        add     di, w_bufwidth
        dec     cx
        jnz     _vertline_loop

        ret
lhzvline endp

;****************************************************************************
;* sub lhzhline(ndseg%, nx1%, nx2%, ny%, ncol%)
;* Draws a horizontal line on destination screen. Does not support clipping
;* and fails to work correctly if x1>x2, so watch it =)
;****************************************************************************
lhzhline proc   uses ds es, n_dseg:word, n_doff:word, n_x1:word, n_x2:word, n_y:word, n_col:word
        mov     ax, n_y
        mul     w_bufwidth
        mov     di, ax
        add     di, n_x1
        add     di, n_doff

        mov     cx, n_x2
        sub     cx, n_x1
        inc     cx

        mov     es, n_dseg
        mov     al, byte ptr n_col

        rep     stosb

        ret
lhzhline endp

;****************************************************************************
;* sub lhzsolrect(ndseg%, m_doff%, nx1%, ny1%, nx2%, ny2%, ncol%)
;* Draws a horizontal line on destination screen. Does not support clipping
;* and fails to work correctly if x1>x2, so watch it =)
;* No clipping and x1<x2 and y1<y2 (i'm soooo lazy)
;****************************************************************************
lhzsolrect proc   uses ds es, n_dseg:word, n_doff:word, n_x1:word, n_y1:word, n_x2:word, n_y2:word, n_col:word
        mov     ax, n_y1
        mul     w_bufwidth
        mov     di, ax
        add     di, n_x1
        add     di, n_doff

        mov     dx, n_y2
        sub     dx, n_y1
        inc     dx

        mov     cx, n_x2
        sub     cx, n_x1
        inc     cx
        mov     bx, cx

_sol_rect_loop:
        mov     cx, bx
        mov     es, n_dseg
        mov     al, byte ptr n_col
        rep     stosb
        add     di, w_bufWidth
        sub     di, bx
        dec     dx
        jne     _sol_rect_loop

        ret
lhzsolrect endp

;****************************************************************************
;* sub lhzscalesprite()
;* Draws a scaled sprite. Supports transparency. Only clips if x>319 or y>200 (?)
;* This is a very specific function, so don't bother using it in your own programs, because
;* It won't do everything you want it to. It's only used in the drawMap() function anyway.
;* It is not optimized either.
;****************************************************************************

lhzscalesprite proc uses ds es, n_dseg:word, n_doff:word, n_x:word, n_y:word, n_wid:word, n_hite:word, n_sseg:word, n_soff:word, n_scale:word
        local  w_scalex:word, w_scaley:word
        local  w_errx:word, w_erry:word, w_sprx:word, w_spry:word
        local  w_posx:word, w_posy:word

        mov     dx, 0                   ;* Equiv: scalex = wid*nscale/100
        mov     ax, n_wid
        mul     n_scale
        mov     bx, 100
        div     bx
        mov     w_scalex, ax

        mov     dx, 0                   ;* Equiv: scaley = hite*nscale/100
        mov     ax, n_hite
        mul     n_scale
        mov     bx, 100
        div     bx
        mov     w_scaley, ax

        cmp     w_scalex, 0
        je      _end_scale
        cmp     w_scaley, 0
        je      _end_scale

        mov     w_errx, 0
        mov     w_sprx, 0

;* es:[di] points to screen buffer (ems/conv)
        mov     ax, n_dseg
        mov     es, ax

;* set ds to sprite seg
        mov     ax, n_sseg
        mov     ds, ax
        mov     si, n_soff

        mov     ax, 320
        mul     n_y
        mov     di, ax
        add     di, n_x
        add     di, n_doff

        mov     ax, n_x
        mov     w_posx, ax
        mov     ax, n_y
        mov     w_posy, ax

        mov     cx, w_scalex

_xx_loop:
        mov     w_erry, 0
        mov     w_spry, 0

        mov     bx, w_scaley
_yy_loop:
        cmp     w_posy, 199
        jg      _skip_erry_loop

        mov     ax, w_spry
        mul     n_wid
        mov     si, n_soff
        add     si, ax
        add     si, w_sprx
        mov     dl, [si]
        cmp     dl, 0
        je      _skip_scale_plot
        mov     es:[di], dl
_skip_scale_plot:
        add     di, 320
        inc     w_posy

        mov     ax, n_hite
        add     w_erry, ax

        mov     ax, w_scaley
        cmp     w_erry, ax
        jl      _skip_erry_loop
_erry_loop:
        inc     w_spry
        sub     w_erry, ax
        cmp     w_erry, ax
        jg      _erry_loop
_skip_erry_loop:
        dec     bx
        jnz     _yy_loop

        mov     ax, n_wid
        add     w_errx, ax
        mov     ax, w_scalex
        cmp     w_errx, ax
        jl     _skip_errx_loop
_errx_loop:
        inc     w_sprx
        sub     w_errx, ax
        cmp     w_errx, ax
        jg      _errx_loop
_skip_errx_loop:
        inc     di
        inc     w_posx
        cmp     w_posx, 319
        jg      _end_scale

        mov     ax, 320
        mul     w_scaley
        sub     di, ax
        mov     ax, w_scaley
        sub     w_posy, ax

        dec     cx
        jnz     _xx_loop

_end_scale:
        ret
lhzscalesprite endp
end
