'- Unofficial Tornamnet Assembler v1.1
'- March, 2001 Created by Joe King

                                        '- declare subs
                                          DECLARE SUB Credits ()
                                          DECLARE SUB TookGame ()
                                          DECLARE SUB LoadPalette ()
                                          DECLARE SUB SerialGameSlave ()
                                          DECLARE SUB SerialGameComPort ()
                                          DECLARE SUB SerialGameMaster ()
                                          DECLARE SUB SerialGame ()
                                          DECLARE SUB MultiPlayer ()
                                          DECLARE SUB Assemble ()
                                          DECLARE SUB SinglePlayer ()
                                          DECLARE SUB Menu ()
                                          DECLARE SUB Title ()
                                          DECLARE SUB Options ()
                                          DECLARE SUB EndGame ()
                                         
                                        '- declare variables
                                          DIM SHARED NumOpponents AS INTEGER
                                          DIM SHARED You AS INTEGER
                                          DIM SHARED Map AS INTEGER
                                          DIM SHARED Serial AS INTEGER
                                          DIM SHARED Master AS INTEGER
                                          DIM SHARED ComPort AS INTEGER
                                          DIM SHARED BloodGore AS INTEGER
                                          DIM SHARED Difficulty AS INTEGER
                                          DIM SHARED TimeLimit AS INTEGER
                                          DIM SHARED Took AS INTEGER
                                          DIM SHARED You2 AS INTEGER
                                          DIM SHARED UnFairFire AS INTEGER
                                          DIM SHARED UnFairFire1 AS INTEGER
                                          DIM SHARED CoOp AS INTEGER
                                          DIM SHARED CoOp1 AS INTEGER
                                          DIM SHARED PU AS INTEGER
                                          DIM SHARED PU1 AS INTEGER
                                          DIM SHARED gd AS INTEGER
                                          DIM SHARED GD1 AS INTEGER
                                          DIM SHARED GameSpeed AS INTEGER

                                        '- declare array variables
                                          DIM SHARED Opponent(8) AS INTEGER
                                          DIM SHARED Kills(9) AS INTEGER

  '- start up
    RANDOMIZE TIMER
    BloodGore = 0
    UnFairFire = 0
    UnFairFire1 = 1
    CoOp = 0
    CoOp1 = 1
    Took = 0
    Difficulty = 2
    TimeLimit = 90
    PU = 1
    PU1 = 0
    gd = 1
    GD1 = 0
    GameSpeed = 0
    DO
      Title
      Menu
    LOOP

SUB Assemble

                                        '- declare varaibles
                                          DIM MaxPlayers AS INTEGER
                                          DIM i AS INTEGER
                                          DIM Winner AS INTEGER
                                          DIM Player(9) AS INTEGER
                                          DIM MaxKills AS INTEGER

  '- assemble
    SCREEN 2
    SCREEN 0
    CLS

    MaxPlayers = NumOpponents + 1
      Player(1) = You
    IF Took = 0 THEN
      FOR i = 2 TO MaxPlayers
        Player(i) = Opponent(i - 1)
      NEXT i
    ELSEIF Took = 1 THEN
      MaxPlayers = NumOpponents + 2
      Player(2) = You2
      FOR i = 3 TO MaxPlayers
        Player(i) = Opponent(i - 1)
      NEXT i
    END IF

    IF Serial = 1 THEN
      IF ComPort = 1 THEN OPEN "COM1: 9600,,,,CD6000" FOR RANDOM AS #1
      IF ComPort = 2 THEN OPEN "COM2: 9600,,,,CD6000" FOR RANDOM AS #1
      IF ComPort = 3 THEN OPEN "COM3: 9600,,,,CD6000" FOR RANDOM AS #1
      IF ComPort = 4 THEN OPEN "COM4: 9600,,,,CD6000" FOR RANDOM AS #1
      IF Master = 1 THEN
        WRITE #1, MaxPlayers
        WRITE #1, Map
        WRITE #1, You
        INPUT #1, Player(2)
        IF MaxPlayers > 2 THEN
          FOR i = 3 TO MaxPlayers
            WRITE #1, Player(i)
          NEXT i
        END IF
      ELSE
        INPUT #1, MaxPlayers
        INPUT #1, Map
        INPUT #1, Player(2)
        WRITE #1, You
        IF MaxPlayers > 2 THEN
          FOR i = 3 TO MaxPlayers
            INPUT #1, Player(i)
          NEXT i
        END IF
      END IF
      CLOSE #1
    END IF

    t$ = "{MaxPlayers=0" + RIGHT$(STR$(MaxPlayers), 1) + "}"
    t$ = t$ + CHR$(13)
    t$ = t$ + "{TileSet=TILES.PUT}"
    t$ = t$ + CHR$(13)
    t$ = t$ + "{ExplodeTile=13-18}"
    t$ = t$ + CHR$(13)
    t$ = t$ + "{Map=" + RIGHT$(STR$(Map), LEN(STR$(Map)) - 1) + ".UTM}"
    t$ = t$ + CHR$(13)
    t$ = t$ + "{Time=" + RIGHT$(STR$(TimeLimit), LEN(STR$(TimeLimit)) - 1) + "}"
    t$ = t$ + CHR$(13)
    t$ = t$ + "{BloodGore=" + RIGHT$(STR$(BloodGore), 1) + "}"
    t$ = t$ + CHR$(13)
    t$ = t$ + "{Difficulty=" + RIGHT$(STR$(Difficulty), 1) + "}"
    t$ = t$ + CHR$(13)
    t$ = t$ + "{GameSpeed=" + RIGHT$(STR$(GameSpeed), 1) + "}"
    t$ = t$ + CHR$(13)
    IF gd THEN t$ = t$ + "{GrassDirt=}"
    t$ = t$ + CHR$(13)
    IF PU THEN t$ = t$ + "{PopUps=}"
    t$ = t$ + CHR$(13)
    IF UnFairFire = 1 THEN t$ = t$ + "{UnFairFire=}"
    t$ = t$ + CHR$(13)
    IF CoOp = 1 THEN t$ = t$ + "{CoOp=}"
    t$ = t$ + CHR$(13)
    IF Took = 1 THEN t$ = t$ + "{TookGame=}"
    t$ = t$ + CHR$(13)
    IF Serial = 1 THEN t$ = t$ + "{Serial=}"
    t$ = t$ + CHR$(13)
    IF Master = 1 THEN t$ = t$ + "{Master=}"
    IF Serial = 1 AND Master = 0 THEN t$ = t$ + "{Slave=}"
    t$ = t$ + CHR$(13)
    IF ComPort = 1 THEN t$ = t$ + "{ComPort=1}"
    IF ComPort = 2 THEN t$ = t$ + "{ComPort=2}"
    IF ComPort = 3 THEN t$ = t$ + "{ComPort=3}"
    IF ComPort = 4 THEN t$ = t$ + "{ComPort=4}"
    t$ = t$ + CHR$(13)
    t$ = t$ + "{PlayerOne=1}"
    t$ = t$ + CHR$(13)
    IF Serial = 1 OR Modem = 1 OR Took = 1 THEN
      t$ = t$ + "{PlayerTwo=2}"
      t$ = t$ + CHR$(13)
    END IF
    FOR i = 1 TO MaxPlayers
      t$ = t$ + "[Player." + RIGHT$(STR$(i), 1) + "=" + RIGHT$(STR$(i), 1) + "]"
      t$ = t$ + CHR$(13)
    NEXT i
    FOR i = 1 TO MaxPlayers
      IF Player(i) = 1 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".SpriteFile=DAN.PUT]"
      IF Player(i) = 2 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".SpriteFile=KENDALL.PUT]"
      IF Player(i) = 3 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".SpriteFile=ROGER.PUT]"
      IF Player(i) = 4 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".SpriteFile=KEVIN.PUT]"
      IF Player(i) = 5 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".SpriteFile=JIM.PUT]"
      IF Player(i) = 6 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".SpriteFile=ROBERT.PUT]"
      IF Player(i) = 7 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".SpriteFile=JOSH.PUT]"
      IF Player(i) = 8 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".SpriteFile=DANIEL.PUT]"
      IF Player(i) = 9 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".SpriteFile=JAMES.PUT]"
      IF Player(i) = 10 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".SpriteFile=BLAINE.PUT]"
      IF Player(i) = 11 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".SpriteFile=JOE.PUT]"
      IF Player(i) = 12 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".SpriteFile=WETSPOT.PUT]"
      t$ = t$ + m$
      t$ = t$ + CHR$(13)
    NEXT i
    FOR i = 1 TO MaxPlayers
      IF Player(i) = 1 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".Speed=2]"
      IF Player(i) = 2 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".Speed=2]"
      IF Player(i) = 3 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".Speed=2]"
      IF Player(i) = 4 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".Speed=2]"
      IF Player(i) = 5 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".Speed=2]"
      IF Player(i) = 6 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".Speed=1]"
      IF Player(i) = 7 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".Speed=2]"
      IF Player(i) = 8 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".Speed=2]"
      IF Player(i) = 9 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".Speed=2]"
      IF Player(i) = 10 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".Speed=2]"
      IF Player(i) = 11 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".Speed=5]"
      IF Player(i) = 12 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".Speed=1]"
      t$ = t$ + m$
      t$ = t$ + CHR$(13)
    NEXT i
    FOR i = 1 TO MaxPlayers
      IF Player(i) = 1 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Speed:5]"
      IF Player(i) = 2 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Speed:5]"
      IF Player(i) = 3 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Speed:5]"
      IF Player(i) = 4 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Speed:5]"
      IF Player(i) = 5 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Speed:10]"
      IF Player(i) = 6 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Speed:2]"
      IF Player(i) = 7 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Speed:10]"
      IF Player(i) = 8 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Speed:5]"
      IF Player(i) = 9 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Speed:2]"
      IF Player(i) = 10 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Speed:10]"
      IF Player(i) = 11 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Speed:1]"
      IF Player(i) = 12 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Speed:5]"
      t$ = t$ + m$
      t$ = t$ + CHR$(13)
    NEXT i
    FOR i = 1 TO MaxPlayers
      IF Player(i) = 1 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Delay:5]"
      IF Player(i) = 2 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Delay:10]"
      IF Player(i) = 3 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Delay:3]"
      IF Player(i) = 4 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Delay:1]"
      IF Player(i) = 5 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Delay:10]"
      IF Player(i) = 6 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Delay:100]"
      IF Player(i) = 7 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Delay:15]"
      IF Player(i) = 8 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Delay:1]"
      IF Player(i) = 9 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Delay:2]"
      IF Player(i) = 10 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Delay:5]"
      IF Player(i) = 11 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Delay:100]"
      IF Player(i) = 12 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Delay:20]"
      t$ = t$ + m$
      t$ = t$ + CHR$(13)
    NEXT i
    FOR i = 1 TO MaxPlayers
      IF Player(i) = 1 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Explode:2]"
      IF Player(i) = 2 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Explode:1]"
      IF Player(i) = 3 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Explode:3]"
      IF Player(i) = 4 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Explode:0]"
      IF Player(i) = 5 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Explode:0]"
      IF Player(i) = 6 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Explode:7]"
      IF Player(i) = 7 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Explode:0]"
      IF Player(i) = 8 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Explode:0]"
      IF Player(i) = 9 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Explode:0]"
      IF Player(i) = 10 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Explode:0]"
      IF Player(i) = 11 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Explode:5]"
      IF Player(i) = 12 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Explode:1]"
      t$ = t$ + m$
      t$ = t$ + CHR$(13)
    NEXT i
      m$ = ""
    FOR i = 1 TO MaxPlayers
      IF Player(i) = 1 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Drunk:2]"
      IF Player(i) = 2 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Spread:3]"
      IF Player(i) = 4 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Freeze:]"
      IF Player(i) = 7 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Spread:3]"
      IF Player(i) = 9 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=Drunk:3]"
      IF Player(i) = 11 THEN m$ = "[" + RIGHT$(STR$(i), 1) + ".WeaponData=ExplodePassWalls:]"
      t$ = t$ + m$
      t$ = t$ + CHR$(13)
    NEXT i

    OPEN "UT.DAT" FOR OUTPUT AS #1
      PRINT #1, t$
    CLOSE #1
    
    SHELL "UTRUN.EXE"
    
    OPEN "UT2.DAT" FOR INPUT AS #1
      FOR i = 1 TO MaxPlayers
        INPUT #1, Kills(i)
        IF Kills(i) > MaxKills THEN MaxKills = Kills(i)
      NEXT i
    CLOSE #1

    CLS
    COLOR 9
    LOCATE 2, 32: PRINT "BATTLE COMPLETED"
    LOCATE 5, 5
    FOR i = 1 TO MaxPlayers
      LOCATE , 20
      IF Kills(i) = MaxKills THEN
        COLOR 15
        Winner = i
      ELSE
        COLOR 7
      END IF
      IF Player(i) = 1 THEN PRINT "DANIEL KUNZ      - ";
      IF Player(i) = 2 THEN PRINT "KENDALL CHAPMAN  - ";
      IF Player(i) = 3 THEN PRINT "ROGER RAPPLEYE   - ";
      IF Player(i) = 4 THEN PRINT "KEVIN OSGUTHORPE - ";
      IF Player(i) = 5 THEN PRINT "JMES HETH      - ";
      IF Player(i) = 6 THEN PRINT "ROBERT WEISHAR   - ";
      IF Player(i) = 7 THEN PRINT "JOSH SPRINGER    - ";
      IF Player(i) = 8 THEN PRINT "DANIEL KING      - ";
      IF Player(i) = 9 THEN PRINT "JAMES BISHOP     - ";
      IF Player(i) = 10 THEN PRINT "BLAINE WOOD      - ";
      IF Player(i) = 11 THEN PRINT "O KING         - ";
      IF Player(i) = 12 THEN PRINT "WETSPOT          - ";
      PRINT "PLAYER" + STR$(i) + " - KILLS ="; Kills(i)
    NEXT i
    PRINT
    IF CoOp = 0 THEN
      PRINT
    ELSE
      COLOR 15
      i% = Kills(1) + Kills(2)
      LOCATE , 24
      PRINT "CO-OP TEAM TOGETHER GOT" + STR$(i%) + " KILLS"
      IF i% < MaxKills THEN LOCATE , 35: COLOR 4: PRINT "NOT ENOUGH"
    END IF

    IF CoOp = 0 THEN
      IF Winner = 1 THEN
        LOCATE , 31
        COLOR 14
        PRINT "YOU WON THE BATTLE"
      ELSE
        LOCATE , 31
        COLOR 15
        PRINT "YOU LOST THE BATTLE"
      END IF
    ELSE
      IF i% >= MaxKills THEN
        LOCATE , 27
        PRINT "CO-OP TEAM WON THE BATTLE"
      ELSE
        LOCATE , 26
        PRINT "CO-OP TEAM LOST THE BATTLE"
      END IF
    END IF
   
    COLOR 4
    LOCATE 23, 30: PRINT "PRESS ESC TO CONTINUE"

    DO
    LOOP UNTIL INKEY$ = CHR$(27)
    CLS
  
END SUB

SUB Center (y%, t$)

  '- center text on screen
    x% = (80 - LEN(t$)) \ 2
    LOCATE y%, x%
    PRINT t$

END SUB

SUB Delay (n AS SINGLE)


                                        '- declare variables
                                          DIM t AS SINGLE

  '- delay
    t = TIMER
    DO
    LOOP UNTIL TIMER > t + n

END SUB

SUB EndGame

 
  '- declare variables
    DIM x AS INTEGER
    DIM y AS INTEGER
 
  '- end the game
    SCREEN 2: SCREEN 0
    CLS

    FOR y = 1 TO 20
      FOR x = 1 TO 80
        IF x = 1 OR y = 1 THEN
          COLOR 15
          LOCATE y, x
          PRINT ""
        ELSEIF x = 80 OR y = 20 THEN
          COLOR 8
          LOCATE y, x
          PRINT ""
        ELSE
          COLOR 7
          LOCATE y, x
          PRINT ""
        END IF
      NEXT x
    NEXT y
   
    LOCATE 3, 5
    COLOR 8, 7
    PRINT "March, 2001"
    LOCATE 3, 31
    COLOR 14, 7
    PRINT "Thanks for playing"
    LOCATE 4, 29
    COLOR 4
    PRINT "UNOFFICIAL  TOURNAMENT"
    LOCATE , 34
    COLOR 0, 7
    PRINT "by DeltaCode"
    LOCATE 8, 5
    COLOR 0, 7
    PRINT "Credits:"
    LOCATE 10, 5
    PRINT "Programming   : Joe King"
    LOCATE , 5
    PRINT "Graphics      : Joe King"
    LOCATE , 5
    PRINT "Level Design  : Joe King, Robert Weishar, Daniel King"
    LOCATE , 5
    PRINT "Testers       : James Heath, Robert Weishar, Daniel King,"
    LOCATE , 5
    PRINT "                Daniel Kunz, James Bishop"
    LOCATE , 5
    PRINT "Special Thanks: Pixel Plus 256, Absolute Assembly"
    LOCATE 17, 5
    COLOR 1
    PRINT "All characters used in this game are real people excluding crabby."
    LOCATE , 5
    PRINT "No one was hurt in the developement of this game."

    LOCATE 3, 56
    COLOR 0, 7
    PRINT "Unofficial Tournament"
    LOCATE , 56
    PRINT "anitcopyright(AC) 2001"
    LOCATE , 56
    PRINT "all rights NOT reserved"
    LOCATE , 56
    COLOR 8
    PRINT "You may freely do what"
    LOCATE , 56
    PRINT "you want with this game"
    LOCATE , 56
    PRINT "but we will not be held"
    LOCATE , 56
    PRINT "responsible for any"
    LOCATE , 56
    PRINT "damages done to you or"
    LOCATE , 56
    PRINT "your computer"
    LOCATE 14, 53
    COLOR 1
    PRINT "visit Delta Code on the web"
    LOCATE 15, 55
    COLOR 5
    PRINT "http://deltacode.cjb.net"

    LOCATE 4, 5
    COLOR 2, 7
    PRINT ""; : COLOR 4, 7: PRINT ""; : COLOR 2, 7: PRINT "": LOCATE , 5
    PRINT ""; : COLOR 4, 7: PRINT "  "; : COLOR 2, 7: PRINT "  ": LOCATE , 5
    PRINT " "; : COLOR 4, 7: PRINT ""; : COLOR 2, 7: PRINT " ": LOCATE , 5
    PRINT " "
   
    LOCATE 21, 1

    END

END SUB

SUB LoadPalette

DEFINT A-Z
REDIM PaletteArray&(0 TO 255)
FileNo = FREEFILE
OPEN "GRADIENT.PAL" FOR BINARY AS #FileNo
FOR n = 0 TO 255
GET #FileNo, , colour&
PaletteArray&(n) = colour&
NEXT n
CLOSE #FileNo
DIM RGBval(0 TO 255, 0 TO 2)
FOR n = 0 TO 255
c& = PaletteArray&(n)
b = c& \ 65536: c& = c& - b * 65536
g = c& \ 256: c& = c& - g * 256
r = c&
RGBval(n, 0) = r
RGBval(n, 1) = g
RGBval(n, 2) = b
NEXT n
WAIT &H3DA, &H8, &H8: WAIT &H3DA, &H8
FOR n = 0 TO 255
OUT &H3C8, n
OUT &H3C9, RGBval(n, 0)
OUT &H3C9, RGBval(n, 1)
OUT &H3C9, RGBval(n, 2)
NEXT n

END SUB

DEFSNG A-Z
SUB Menu

                                        '- delcare variables
                                          DIM y AS INTEGER, oy AS INTEGER

  '- the menu
    COLOR 4
    LOCATE 15, 14
    PRINT "SINGLE PLAYER"
    LOCATE 16, 14
    PRINT "MULTI PLAYER"
    LOCATE 17, 14
    PRINT "OPTIONS"
    LOCATE 18, 14
    PRINT "EXIT"

    y = 15
   
    DO
      COLOR 14
      LOCATE y, 12
      PRINT CHR$(26)

      COLOR 2
      SELECT CASE y
      CASE IS = 15
        LOCATE 15, 14: PRINT "SINGLE PLAYER"
      CASE IS = 16
        LOCATE 16, 14: PRINT "MULTI PLAYER"
      CASE IS = 17
        LOCATE 17, 14: PRINT "OPTIONS"
      CASE IS = 18
        LOCATE 18, 14: PRINT "EXIT"
      END SELECT

      DO
        a$ = INKEY$
      LOOP WHILE a$ = ""
        oy = y
        IF a$ = CHR$(0) + "P" THEN y = y + 1
        IF a$ = CHR$(0) + "H" THEN y = y - 1
        IF a$ = CHR$(13) THEN
          IF y = 15 THEN SinglePlayer: EXIT SUB
          IF y = 16 THEN MultiPlayer: EXIT SUB
          IF y = 17 THEN Options: EXIT SUB
          IF y = 18 THEN EndGame
        END IF
        IF y > 18 THEN y = 15
        IF y < 15 THEN y = 18
        IF y <> oy THEN
          LOCATE oy, 12: PRINT " "
          COLOR 4
          SELECT CASE oy
          CASE IS = 15
            LOCATE 15, 14: PRINT "SINGLE PLAYER"
          CASE IS = 16
            LOCATE 16, 14: PRINT "MULTI PLAYER"
          CASE IS = 17
            LOCATE 17, 14: PRINT "OPTIONS"
          CASE IS = 18
            LOCATE 18, 14: PRINT "EXIT"
          END SELECT
        END IF
    LOOP
END SUB

SUB MultiPlayer

                                        '- declare variable
                                          DIM y AS INTEGER, oy AS INTEGER
 
  '- multi player stuff
  CLS
  COLOR 1
  LOCATE 2, 15
  PRINT "MULTI PLAYER"

  y = 10

  COLOR 4
  LOCATE 10, 16
  PRINT "TOOK GAME"
  LOCATE , 15
  PRINT "SERIAL GAME"

  DO
    LOCATE y, 13
    COLOR 14
    PRINT CHR$(26)

    COLOR 2
    SELECT CASE y
    CASE IS = 10
      LOCATE 10, 16: PRINT "TOOK GAME"
      COLOR 7
      LOCATE 22, 1
      PRINT ""
      PRINT "TOOK(TWO-ON-ONE-KEYBOARD) GAME: TWO     "
      PRINT "PLAYERS WILL USE ONE KEYBOARD           ";
    CASE IS = 11
      LOCATE 11, 15: PRINT "SERIAL GAME"
      COLOR 7
      LOCATE 22, 1
      PRINT ""
      PRINT "SERIAL GAME: TWO COMPUTERS MUST BE      "
      PRINT "CONNECTED USING A NULL-MODEM CABLE      ";
    END SELECT

    DO
      a$ = INKEY$
    LOOP WHILE a$ = ""
      oy = y
      IF a$ = CHR$(0) + "P" THEN y = y + 1
      IF a$ = CHR$(0) + "H" THEN y = y - 1
      IF a$ = CHR$(27) THEN EXIT SUB
      IF a$ = CHR$(13) THEN
        IF y = 10 THEN Took = 1: TookGame: EXIT DO
        IF y = 11 THEN Serial = 1: SerialGame: EXIT DO
      END IF
      IF y <> oy THEN
        COLOR 4
        LOCATE oy, 13: PRINT " "
        SELECT CASE oy
        CASE IS = 10
          LOCATE 10, 16: PRINT "TOOK GAME"
        CASE IS = 11
          LOCATE 11, 15: PRINT "SERIAL GAME"
        END SELECT
      END IF
      IF y > 11 THEN y = 10
      IF y < 10 THEN y = 11
  LOOP

END SUB

SUB Options

  '- declare variables
    DIM y AS INTEGER
 
  '- options
    CLS
    LOCATE 2, 16: COLOR 2: PRINT "OPTIONS"
    y = 8
    LOCATE 8, 5: COLOR 2
    PRINT "DIFFICULTY  : ";
      COLOR 15
      IF Difficulty = 1 THEN PRINT "EASY     "
      IF Difficulty = 2 THEN PRINT "NORMAL   "
      IF Difficulty = 3 THEN PRINT "HARD     "
      IF Difficulty = 4 THEN PRINT "UNFAIR   "
      IF Difficulty = 5 THEN PRINT "NIGHTMARE"
    LOCATE , 5: COLOR 4
    PRINT "BLOOD & GORE: ";
      COLOR 7
      IF BloodGore = 0 THEN PRINT "NONE    "
      IF BloodGore = 1 THEN PRINT "LITTLE  "
      IF BloodGore = 2 THEN PRINT "SOME    "
      IF BloodGore = 3 THEN PRINT "ALOT    "
      IF BloodGore = 4 THEN PRINT "TOO MUCH"
    LOCATE , 5
    COLOR 4
    PRINT "TIME LIMIT  :";
    COLOR 7
    PRINT TimeLimit; " SECONDS  "
    LOCATE , 5
    COLOR 4
    PRINT "UNFAIR FIRE : ";
    COLOR 7
    IF UnFairFire THEN
      PRINT "YES"
    ELSE
      PRINT "NO"
    END IF
    LOCATE , 5
    COLOR 4
    PRINT "CO-OP PLAY  : ";
    COLOR 7
    IF CoOp THEN
      PRINT "YES"
    ELSE
      PRINT "NO"
    END IF
    LOCATE , 5
    COLOR 4
    PRINT "BONUS ITEMS : ";
    COLOR 7
    IF PU THEN
      PRINT "YES"
    ELSE
      PRINT "NO"
    END IF
    LOCATE , 5
    COLOR 4
    PRINT "GRASS & DIRT: ";
    COLOR 7
    IF gd THEN
      PRINT "YES"
    ELSE
      PRINT "NO"
    END IF
    LOCATE , 5: COLOR 4
    PRINT "GAME SPEED  : ";
    COLOR 7
    IF GameSpeed = 0 THEN PRINT "NORMAL   "
    IF GameSpeed = 1 THEN PRINT "TURBO    "
    IF GameSpeed = 2 THEN PRINT "OVERDRIVE"
   

    LOCATE 22, 1
    COLOR 7
    PRINT ""
  
    DO
     
      LOCATE y, 3: COLOR 14: PRINT CHR$(26)
     
      SELECT CASE y
      CASE IS = 8
        LOCATE 8, 5: COLOR 2: PRINT "DIFFICULTY  : ";
        COLOR 15
        IF Difficulty = 1 THEN PRINT "EASY     "
        IF Difficulty = 2 THEN PRINT "NORMAL   "
        IF Difficulty = 3 THEN PRINT "HARD     "
        IF Difficulty = 4 THEN PRINT "UNFAIR   "
        IF Difficulty = 5 THEN PRINT "NIGHTMARE"
        LOCATE 23, 1
        COLOR 7
        PRINT "DIFFICULTY: HOW HARD THE COMPUTERS ARE  "
        PRINT "                                        ";
      CASE IS = 9
        LOCATE 9, 5: COLOR 2: PRINT "BLOOD & GORE: ";
        COLOR 15
        IF BloodGore = 0 THEN PRINT "NONE    "
        IF BloodGore = 1 THEN PRINT "LITTLE  "
        IF BloodGore = 2 THEN PRINT "SOME    "
        IF BloodGore = 3 THEN PRINT "ALOT    "
        IF BloodGore = 4 THEN PRINT "TOO MUCH"
        LOCATE 23, 1
        COLOR 7
        PRINT "BLOOD & GORE: THE AMOUNT OF BLOOD & GORE"
        PRINT "IN THE GAME (BLOOD,GUTS,HEADS,LEGS&ARMS)";
      CASE IS = 10
        LOCATE 10, 5: COLOR 2: PRINT "TIME LIMIT  :";
        COLOR 15
        PRINT TimeLimit; " SECONDS  "
        LOCATE 23, 1
        COLOR 7
        PRINT "TIME LIMIT: HOW LONG A BATTLE IS        "
        PRINT "                                        ";
      CASE IS = 11
        LOCATE 11, 5: COLOR 2: PRINT "UNFAIR FIRE : ";
        COLOR 15
        IF UnFairFire THEN
          PRINT "YES"
        ELSE
          PRINT "NO "
        END IF
        LOCATE 23, 1
        COLOR 7
        PRINT "UNFAIR FIRE: BULLETS ARE ALLOWED TO HIT "
        PRINT "EACH OTHER                              ";
      CASE IS = 12
        LOCATE 12, 5: COLOR 2: PRINT "CO-OP PLAY  : ";
        COLOR 15
        IF CoOp THEN
          PRINT "YES"
        ELSE
          PRINT "NO "
        END IF
        LOCATE 23, 1
        COLOR 7
        PRINT "CO-OP PLAY: BOTH PLAYERS ARE A TEAM AND "
        PRINT "CANNOT HURT EACH OTHER IN MULTIPLAYER   ";
      CASE IS = 13
        LOCATE 13, 5: COLOR 2: PRINT "BONUS ITEMS : ";
        COLOR 15
        IF PU THEN
          PRINT "YES"
        ELSE
          PRINT "NO "
        END IF
        LOCATE 23, 1
        COLOR 7
        PRINT "BONUS ITEMS: ITEMS THAT RANDOMLY APPEAR "
        PRINT "ON THE MAP(ONLY WORKS FOR SINGLE PLAYER)";
      CASE IS = 14
        LOCATE 14, 5: COLOR 2: PRINT "GRASS & DIRT: ";
        COLOR 15
        IF gd THEN
          PRINT "YES"
        ELSE
          PRINT "NO "
        END IF
        LOCATE 23, 1
        COLOR 7
        PRINT "GRASS & DIRT: GRASS OR DIRT APPEAR ON   "
        PRINT "THE BATTLEGROUND                        ";
      CASE IS = 15
        LOCATE 15, 5: COLOR 2
        PRINT "GAME SPEED  : ";
        COLOR 15
        IF GameSpeed = 0 THEN PRINT "NORMAL   "
        IF GameSpeed = 1 THEN PRINT "TURBO    "
        IF GameSpeed = 2 THEN PRINT "OVERDRIVE"
        LOCATE 23, 1
        COLOR 7
        PRINT "GAME SPEED: THE SPEED OF THE GAMEPLAY   "
        PRINT "                                        ";
      END SELECT

      DO
        a$ = INKEY$
      LOOP WHILE a$ = ""
        oy = y
        IF a$ = CHR$(0) + "P" THEN y = y + 1
        IF a$ = CHR$(0) + "H" THEN y = y - 1
        IF a$ = CHR$(0) + "M" THEN
          IF y = 8 THEN Difficulty = Difficulty + 1
          IF Difficulty > 5 THEN Difficulty = 5
          IF y = 9 THEN BloodGore = BloodGore + 1
          IF BloodGore > 4 THEN BloodGore = 4
          IF y = 10 THEN TimeLimit = TimeLimit + 5
          IF TimeLimit > 32000 THEN TimeLimit = 32000
          IF y = 11 THEN SWAP UnFairFire, UnFairFire1
          IF y = 12 THEN SWAP CoOp, CoOp1
          IF y = 13 THEN SWAP PU, PU1
          IF y = 14 THEN SWAP gd, GD1
          IF y = 15 THEN GameSpeed = GameSpeed + 1
          IF GameSpeed > 2 THEN GameSpeed = 2
        END IF
        IF a$ = CHR$(0) + "K" THEN
          IF y = 8 THEN Difficulty = Difficulty - 1
          IF Difficulty < 1 THEN Difficulty = 1
          IF y = 9 THEN BloodGore = BloodGore - 1
          IF BloodGore < 0 THEN BloodGore = 0
          IF y = 10 THEN TimeLimit = TimeLimit - 5
          IF TimeLimit < 5 THEN TimeLimit = 5
          IF y = 11 THEN SWAP UnFairFire, UnFairFire1
          IF y = 12 THEN SWAP CoOp, CoOp1
          IF y = 13 THEN SWAP PU, PU1
          IF y = 14 THEN SWAP gd, GD1
          IF y = 15 THEN GameSpeed = GameSpeed - 1
          IF GameSpeed < 0 THEN GameSpeed = 0
        END IF
        IF a$ = CHR$(27) THEN EXIT SUB
        IF a$ = CHR$(13) THEN EXIT SUB
        IF y > 15 THEN y = 8
        IF y < 8 THEN y = 15
      LOCATE oy, 3: PRINT " "
      SELECT CASE oy
      CASE IS = 8
        LOCATE 8, 5: COLOR 4: PRINT "DIFFICULTY  : ";
        COLOR 7
        IF Difficulty = 1 THEN PRINT "EASY     "
        IF Difficulty = 2 THEN PRINT "NORMAL   "
        IF Difficulty = 3 THEN PRINT "HARD     "
        IF Difficulty = 4 THEN PRINT "UNFAIR   "
        IF Difficulty = 5 THEN PRINT "NIGHTMARE"
        CASE IS = 9
        LOCATE 9, 5: COLOR 4: PRINT "BLOOD & GORE: ";
      COLOR 7
        IF BloodGore = 0 THEN PRINT "NONE    "
        IF BloodGore = 1 THEN PRINT "LITTLE  "
        IF BloodGore = 2 THEN PRINT "SOME    "
        IF BloodGore = 3 THEN PRINT "ALOT    "
        IF BloodGore = 4 THEN PRINT "TOO MUCH"
      CASE IS = 10
        LOCATE 10, 5: COLOR 4: PRINT "TIME LIMIT  :";
        COLOR 7
        PRINT TimeLimit; " SECONDS  "
      CASE IS = 11
        LOCATE 11, 5: COLOR 4: PRINT "UNFAIR FIRE : ";
        COLOR 7
        IF UnFairFire THEN
          PRINT "YES"
        ELSE
          PRINT "NO "
        END IF
      CASE IS = 12
        LOCATE 12, 5: COLOR 4: PRINT "CO-OP PLAY  : ";
        COLOR 7
        IF CoOp THEN
          PRINT "YES"
        ELSE
          PRINT "NO "
        END IF
      CASE IS = 13
        LOCATE 13, 5: COLOR 4: PRINT "BONUS ITEMS : ";
        COLOR 7
        IF PU THEN
          PRINT "YES"
        ELSE
          PRINT "NO "
        END IF
      CASE IS = 14
        LOCATE 14, 5: COLOR 4: PRINT "GRASS & DIRT: ";
        COLOR 7
        IF gd THEN
          PRINT "YES"
        ELSE
          PRINT "NO "
        END IF
      CASE IS = 15
        LOCATE 15, 5: COLOR 4
        PRINT "GAME SPEED  : ";
        COLOR 7
        IF GameSpeed = 0 THEN PRINT "NORMAL   "
        IF GameSpeed = 1 THEN PRINT "TURBO    "
        IF GameSpeed = 2 THEN PRINT "OVERDRIVE"
      END SELECT
    LOOP

END SUB

SUB SerialGame

                                        '- declare variable
                                          DIM y AS INTEGER, oy AS INTEGER

  '- multi player stuff
  CLS
  COLOR 1
  LOCATE 2, 8
  PRINT "MULTI PLAYER: SERIAL GAME"

  y = 10

  COLOR 4
  LOCATE 10, 17
  PRINT "MASTER"
  LOCATE , 17
  PRINT "SLAVE"

  DO
    LOCATE y, 15
    COLOR 14
    PRINT CHR$(26)

    COLOR 2
    SELECT CASE y
    CASE IS = 10
      LOCATE 10, 17: PRINT "MASTER"
      COLOR 7
      LOCATE 22, 1
      PRINT ""
      PRINT "MASTER: CHOOSES THE MAP AND THE COMPUTER"
      PRINT "CONTROLLED OPPONENTS                    ";
    CASE IS = 11
      LOCATE 11, 17: PRINT "SLAVE"
      COLOR 7
      LOCATE 22, 1
      PRINT ""
      PRINT "SLAVE: JUST CHOOSES WHICH PERSON THEIR  "
      PRINT "GOING TO BE                             ";
    END SELECT

    DO
      a$ = INKEY$
    LOOP WHILE a$ = ""
      oy = y
      IF a$ = CHR$(0) + "P" THEN y = y + 1
      IF a$ = CHR$(0) + "H" THEN y = y - 1
      IF a$ = CHR$(27) THEN EXIT SUB
      IF a$ = CHR$(13) THEN
        IF y = 10 THEN Master = 1: SerialGameComPort: EXIT SUB
        IF y = 11 THEN Master = 0: SerialGameComPort: EXIT SUB
      END IF
      IF y <> oy THEN
        COLOR 4
        LOCATE oy, 15: PRINT " "
        SELECT CASE oy
        CASE IS = 10
          LOCATE 10, 17: PRINT "MASTER"
        CASE IS = 11
          LOCATE 11, 17: PRINT "SLAVE"
        END SELECT
      END IF
      IF y > 11 THEN y = 10
      IF y < 10 THEN y = 11
  LOOP

END SUB

SUB SerialGameComPort

                                        '- declare variable
                                          DIM y AS INTEGER, oy AS INTEGER

  '- multi player stuff
  CLS
  COLOR 1
  LOCATE 2, 3
  PRINT "MULTI PLAYER: SERIAL GAME: COMPORT"

  y = 10

  COLOR 4
  LOCATE 10, 17
  PRINT "COM 1"
  LOCATE , 17
  PRINT "COM 2"

  DO
    LOCATE y, 15
    COLOR 14
    PRINT CHR$(26)

    COLOR 2
    SELECT CASE y
    CASE IS = 10
      LOCATE 10, 17: PRINT "COM 1"
      COLOR 7
      LOCATE 22, 1
      PRINT ""
      PRINT "WHICH COMPORT WILL YOU BE USING?        "
      PRINT "                                        ";
    CASE IS = 11
      LOCATE 11, 17: PRINT "COM 2"
      COLOR 7
      LOCATE 22, 1
      PRINT ""
      PRINT "WHICH COMPORT WILL YOU BE USING?        "
      PRINT "                                        ";
    END SELECT

    DO
      a$ = INKEY$
    LOOP WHILE a$ = ""
      oy = y
      IF a$ = CHR$(0) + "P" THEN y = y + 1
      IF a$ = CHR$(0) + "H" THEN y = y - 1
      IF a$ = CHR$(27) THEN EXIT SUB
      IF a$ = CHR$(13) THEN
        IF Master = 1 THEN
          IF y = 10 THEN ComPort = 1: SerialGameMaster: EXIT SUB
          IF y = 11 THEN ComPort = 2: SerialGameMaster: EXIT SUB
        ELSE
          IF y = 10 THEN ComPort = 1: SerialGameSlave: EXIT SUB
          IF y = 11 THEN ComPort = 2: SerialGameSlave: EXIT SUB
        END IF
      END IF
      IF y <> oy THEN
        COLOR 4
        LOCATE oy, 15: PRINT " "
        SELECT CASE oy
        CASE IS = 10
          LOCATE 10, 17: PRINT "COM 1"
        CASE IS = 11
          LOCATE 11, 17: PRINT "COM 2"
        END SELECT
      END IF
      IF y > 11 THEN y = 10
      IF y < 10 THEN y = 11
  LOOP

END SUB

SUB SerialGameMaster

                                        '- declare variabls
                                          DIM y AS INTEGER, oy AS INTEGER
                                          DIM i AS INTEGER, n AS INTEGER
                                          DIM x AS INTEGER
                                          DIM c AS INTEGER, oc  AS INTEGER
                                          DIM OMap AS INTEGER

  '- single player stuff
    CLS
    NumOpponents = 1
    You = 1
    Map = 1
    OMap = 0
    FOR i = 2 TO 8
      Opponent(i) = 1
    NEXT i
    LOCATE 2, 4
    COLOR 1
    PRINT "MULTI PLAYER: SERIAL GAME: MASTER"
    y = 10

    COLOR 4
    LOCATE 10, 4
    PRINT "SELECT PLAYER      :"
    LOCATE 11, 4
    PRINT "SELECT MAP         :"
    LOCATE 12, 4
    PRINT "NUMBER OF OPPONENTS:"

    DO
      LOCATE y, 2
      COLOR 14
      PRINT CHR$(26)

      COLOR 2
      SELECT CASE y
      CASE IS = 10
        LOCATE 10, 4: PRINT "SELECT PLAYER      :"
      CASE IS = 11
        LOCATE 11, 4: PRINT "SELECT MAP         :"
      CASE IS = 12
        LOCATE 12, 4: PRINT "NUMBER OF OPPONENTS:"
      END SELECT

      IF y = 10 THEN COLOR 15 ELSE COLOR 7
      LOCATE 10, 25
      SELECT CASE You
      CASE IS = 1
        PRINT "DANIEL KUNZ     "
      CASE IS = 2
        PRINT "KENDALL CHAPMAN "
      CASE IS = 3
        PRINT "ROGER RAPPLEYE  "
      CASE IS = 4
        PRINT "KEVIN OSGUTHORPE"
      CASE IS = 5
        PRINT "JMES HETH     "
      CASE IS = 6
        PRINT "ROBERT WEISHAR  "
      CASE IS = 7
        PRINT "JOSH SPRINGER   "
      CASE IS = 8
        PRINT "DANIEL KING     "
      CASE IS = 9
        PRINT "JAMES BISHOP    "
      CASE IS = 10
        PRINT "BLAINE WOOD     "
      CASE IS = 11
        PRINT "O KING        "
      CASE IS = 12
        PRINT "CRABBY          "
      END SELECT

      IF y = 11 THEN COLOR 15 ELSE COLOR 7
      LOCATE 11, 24
      PRINT Map; "  "

      IF y = 12 THEN COLOR 15 ELSE COLOR 7
      LOCATE 12, 24
      PRINT NumOpponents
    
      LOCATE 21, 4
      IF y = 21 THEN COLOR 2 ELSE COLOR 4
      PRINT "LET THE CHAOS BEGIN!"
    
      LOCATE 22, 1
      COLOR 7
      PRINT ""
      LOCATE 23, 1
      SELECT CASE You
      CASE IS = 0
        PRINT "                                      "
        PRINT "                                      ";
      CASE IS = 1
        PRINT "SPEED : MODERATE                      "
        PRINT "WEAPON: DRUNK MISSILE LAUNCHER        ";
      CASE IS = 2
        PRINT "SPEED : MODERATE                      "
        PRINT "WEAPON: FLAME WAVEBLASTER             ";
      CASE IS = 3
        PRINT "SPEED : MODERATE                      "
        PRINT "WEAPON: FULLY AUTO MISSILE LANUCHER   ";
      CASE IS = 4
        PRINT "SPEED : MODERATE                      "
        PRINT "WEAPON: LIQUID NITROGEN GUN           ";
      CASE IS = 5
        PRINT "SPEED : MODERATE                      "
        PRINT "WEAPON: FAST BOW GUN                  ";
      CASE IS = 6
        PRINT "SPEED : SLOW                          ";
        PRINT "WEAPON: NUCLEAR BOMB                  ";
      CASE IS = 7
        PRINT "SPEED : MODERATE                      "
        PRINT "WEAPON: 3 GAGE SHOTGUN                ";
      CASE IS = 8
        PRINT "SPEED : MODERATE                      "
        PRINT "WEAPON: FLAMETHROWER                  ";
      CASE IS = 9
        PRINT "SPEED : MODERATE                      "
        PRINT "WEAPON: BEES                          ";
      CASE IS = 10
        PRINT "SPEED : MODERATE                      "
        PRINT "WEAPON: SONIC WAVEBLASTER             ";
      CASE IS = 11
        PRINT "SPEED : FAST                          "
        PRINT "WEAPON: RUBIX CUBE                    ";
      CASE IS = 12
        PRINT "SPEED : SLOW                          "
        PRINT "WEAPON: EXPLODING BRICKS              ";
      END SELECT

      FOR i = 1 TO NumOpponents
        LOCATE 12 + i, 4
        IF y = 12 + i THEN COLOR 2 ELSE COLOR 4
        PRINT "OPPONENT" + STR$(i); "         : ";
        IF y = i + 12 THEN COLOR 15 ELSE COLOR 7
        IF Opponent(i) = 0 THEN PRINT "OTHER PLAYER    "
        IF Opponent(i) = 1 THEN PRINT "DANIEL KUNZ     "
        IF Opponent(i) = 2 THEN PRINT "KENDALL CHAPMAN "
        IF Opponent(i) = 3 THEN PRINT "ROGER RAPPLEYE  "
        IF Opponent(i) = 4 THEN PRINT "KEVIN OSGUTHORPE"
        IF Opponent(i) = 5 THEN PRINT "JMES HETH     "
        IF Opponent(i) = 6 THEN PRINT "ROBERT WEISHAR  "
        IF Opponent(i) = 7 THEN PRINT "JOSH SPRINGER   "
        IF Opponent(i) = 8 THEN PRINT "DANIEL KING     "
        IF Opponent(i) = 9 THEN PRINT "JAMES BISHOP    "
        IF Opponent(i) = 10 THEN PRINT "BLAINE WOOD     "
        IF Opponent(i) = 11 THEN PRINT "O KING        "
        IF Opponent(i) = 12 THEN PRINT "CRABBY          "
      NEXT i
      FOR i = 1 TO 8 - NumOpponents
        LOCATE , 4
        PRINT "                                     "
      NEXT i

      oy = y
      IF Map <> OMap THEN
        OMap = Map
        m$ = RIGHT$(STR$(Map), LEN(STR$(Map)) - 1)
        LOCATE 1, 1
        OPEN m$ + ".UTM" FOR INPUT AS #1
          FOR y = 1 TO 20
            FOR x = 1 TO 32
              INPUT #1, c
              IF c = 0 THEN oc = 0
              IF c = 1 THEN oc = 4
              IF c = 2 THEN oc = 8
              IF c = 3 THEN oc = 6
              IF c = 4 THEN oc = 9
              IF c = 5 THEN oc = 7
              IF c = 6 THEN oc = 6
              IF c = 7 THEN oc = 0
              IF c = 8 THEN oc = 0
              IF c = 9 THEN oc = 2
              IF c = 10 THEN oc = 2
              IF c = 11 THEN oc = 2
              IF c = 21 THEN oc = 6
              IF c = 22 THEN oc = 2
              IF c = 24 THEN oc = 1
              c = oc
              LINE (x * 2 - 2 + 125, y * 2 - 2 + 25)-(x * 2 - 1 + 125, y * 2 - 1 + 25), c, BF
            NEXT x
          NEXT y
        CLOSE #1
      END IF
      y = oy

      DO
        a$ = INKEY$
      LOOP WHILE a$ = ""
        oy = y
        IF a$ = CHR$(0) + "P" THEN y = y + 1
        IF a$ = CHR$(0) + "H" THEN y = y - 1
        IF a$ = CHR$(27) THEN EXIT SUB
        IF a$ = CHR$(0) + "M" THEN
          IF y = 10 THEN
            You = You + 1
            IF You > 12 THEN You = 1
            IF You < 1 THEN You = 12
          ELSEIF y = 11 THEN
            Map = Map + 1
            IF Map > 50 THEN Map = 1
            IF Map < 1 THEN Map = 50
          ELSEIF y = 12 THEN
            NumOpponents = NumOpponents + 1
            IF NumOpponents > 7 THEN NumOpponents = 1
            IF NumOpponents < 1 THEN NumOpponents = 7
          ELSEIF y > 12 AND y < 21 THEN
            Opponent(y - 12) = Opponent(y - 12) + 1
            IF Opponent(y - 12) > 12 THEN Opponent(y - 12) = 1
            IF Opponent(y - 12) < 1 THEN Opponent(y - 12) = 12
          END IF
        END IF
        IF a$ = CHR$(0) + "K" THEN
          IF y = 10 THEN
            You = You - 1
            IF You > 12 THEN You = 1
            IF You < 1 THEN You = 12
          ELSEIF y = 11 THEN
            Map = Map - 1
            IF Map > 50 THEN Map = 1
            IF Map < 1 THEN Map = 50
          ELSEIF y = 12 THEN
            NumOpponents = NumOpponents - 1
            IF NumOpponents > 7 THEN NumOpponents = 1
            IF NumOpponents < 1 THEN NumOpponents = 7
          ELSEIF y > 12 AND y < 21 THEN
            Opponent(y - 12) = Opponent(y - 12) - 1
            IF Opponent(y - 12) > 12 THEN Opponent(y - 12) = 1
            IF Opponent(y - 12) < 1 THEN Opponent(y - 12) = 12
          END IF
        END IF
        Opponent(1) = 0
        IF a$ = CHR$(13) AND y = 21 THEN Assemble: EXIT SUB
        IF y < 10 THEN y = 21
        IF y > 21 THEN y = 10
        IF oy = 21 AND y < 21 AND y > 12 + NumOpponents THEN y = 12 + NumOpponents
        IF y > 12 + NumOpponents AND y < 21 THEN y = 21
        IF y <> oy THEN
          COLOR 4
          LOCATE oy, 2: PRINT " "
          SELECT CASE oy
          CASE IS = 10
            LOCATE 10, 4: PRINT "SELECT PLAYER      :"
          CASE IS = 11
            LOCATE 11, 4: PRINT "SELECT MAP         :"
          CASE IS = 12
            LOCATE 12, 4: PRINT "NUMBER OF OPPONENTS:"
          CASE IS > 12
            FOR i = 1 TO NumOpponents
              LOCATE 12 + i, 4
              IF y = 12 + i THEN COLOR 2 ELSE COLOR 4
              PRINT "OPPONENT" + STR$(i); "         : ";
              IF y = i + 12 THEN COLOR 15 ELSE COLOR 7
              IF Opponent(i) = 0 THEN PRINT "OTHER PLAYER    "
              IF Opponent(i) = 1 THEN PRINT "DANIEL KUNZ     "
              IF Opponent(i) = 2 THEN PRINT "KENDALL CHAPMAN "
              IF Opponent(i) = 3 THEN PRINT "ROGER RAPPLEYE  "
              IF Opponent(i) = 4 THEN PRINT "KEVIN OSGUTHORPE"
              IF Opponent(i) = 5 THEN PRINT "JMES HETH     "
              IF Opponent(i) = 6 THEN PRINT "ROBERT WEISHAR  "
              IF Opponent(i) = 7 THEN PRINT "JOSH SPRINGER   "
              IF Opponent(i) = 8 THEN PRINT "DANIEL KING     "
              IF Opponent(i) = 9 THEN PRINT "JAMES BISHOP    "
              IF Opponent(i) = 10 THEN PRINT "BLAINE WOOD     "
              IF Opponent(i) = 11 THEN PRINT "O KING        "
              IF Opponent(i) = 12 THEN PRINT "CRABBY          "
            NEXT i
            FOR i = 1 TO 8 - NumOpponents
              LOCATE , 4
              PRINT "                                     "
            NEXT i
          END SELECT
        END IF
    LOOP

END SUB

SUB SerialGameSlave

                                        '- declare variabls
                                          DIM y AS INTEGER, oy AS INTEGER
                                          DIM i AS INTEGER, n AS INTEGER
                                          DIM x AS INTEGER
                                          DIM c AS INTEGER, oc  AS INTEGER
                                          DIM OMap AS INTEGER

  '- single player stuff
    CLS
    NumOpponents = 1
    You = 1
    Map = 1
    OMap = 0
    FOR i = 2 TO 8
      Opponent(i) = 1
    NEXT i
    LOCATE 2, 4
    COLOR 1
    PRINT "MULTI PLAYER: SERIAL GAME: MASTER"
    y = 10

    COLOR 4
    LOCATE 10, 4
    PRINT "SELECT PLAYER      :"
    COLOR 8
    LOCATE 11, 4
    PRINT "SELECT MAP         :"
    LOCATE 12, 4
    PRINT "NUMBER OF OPPONENTS:"

    DO
      LOCATE y, 2
      COLOR 14
      PRINT CHR$(26)

      COLOR 4
      SELECT CASE y
      CASE IS = 10
        LOCATE 10, 4: PRINT "SELECT PLAYER      :"
      CASE IS = 11
        COLOR 8
        LOCATE 11, 4: PRINT "SELECT MAP         :"
      CASE IS = 12
        COLOR 8
        LOCATE 12, 4: PRINT "NUMBER OF OPPONENTS:"
      END SELECT

      IF y = 10 THEN COLOR 15 ELSE COLOR 7
      LOCATE 10, 25
      SELECT CASE You
      CASE IS = 1
        PRINT "DANIEL KUNZ     "
      CASE IS = 2
        PRINT "KENDALL CHAPMAN "
      CASE IS = 3
        PRINT "ROGER RAPPLEYE  "
      CASE IS = 4
        PRINT "KEVIN OSGUTHORPE"
      CASE IS = 5
        PRINT "JMES HETH     "
      CASE IS = 6
        PRINT "ROBERT WEISHAR  "
      CASE IS = 7
        PRINT "JOSH SPRINGER   "
      CASE IS = 8
        PRINT "DANIEL KING     "
      CASE IS = 9
        PRINT "JAMES BISHOP    "
      CASE IS = 10
        PRINT "BLAINE WOOD     "
      CASE IS = 11
        PRINT "O KING        "
      CASE IS = 12
        PRINT "CRABBY          "
      END SELECT

      IF y = 11 THEN COLOR 15 ELSE COLOR 7
      COLOR 8
      LOCATE 11, 24
      PRINT Map; "  "

      IF y = 12 THEN COLOR 15 ELSE COLOR 7
      LOCATE 12, 24
      COLOR 8
      PRINT NumOpponents
   
      LOCATE 21, 4
      IF y = 21 THEN COLOR 2 ELSE COLOR 4
      PRINT "LET THE CHAOS BEGIN!"
   
      LOCATE 22, 1
      COLOR 7
      PRINT ""
      LOCATE 23, 1
      SELECT CASE You
      CASE IS = 0
        PRINT "                                      "
        PRINT "                                      ";
      CASE IS = 1
        PRINT "SPEED : MODERATE                      "
        PRINT "WEAPON: DRUNK MISSILE LAUNCHER        ";
      CASE IS = 2
        PRINT "SPEED : MODERATE                      "
        PRINT "WEAPON: FLAME WAVEBLASTER             ";
      CASE IS = 3
        PRINT "SPEED : MODERATE                      "
        PRINT "WEAPON: FULLY AUTO MISSILE LANUCHER   ";
      CASE IS = 4
        PRINT "SPEED : MODERATE                      "
        PRINT "WEAPON: LIQUID NITROGEN GUN           ";
      CASE IS = 5
        PRINT "SPEED : MODERATE                      "
        PRINT "WEAPON: FAST BOW GUN                  ";
      CASE IS = 6
        PRINT "SPEED : SLOW                          ";
        PRINT "WEAPON: NUCLEAR BOMB                  ";
      CASE IS = 7
        PRINT "SPEED : MODERATE                      "
        PRINT "WEAPON: 3 GAGE SHOTGUN                ";
      CASE IS = 8
        PRINT "SPEED : MODERATE                      "
        PRINT "WEAPON: FLAMETHROWER                  ";
      CASE IS = 9
        PRINT "SPEED : MODERATE                      "
        PRINT "WEAPON: BEES                          ";
      CASE IS = 10
        PRINT "SPEED : MODERATE                      "
        PRINT "WEAPON: SONIC WAVEBLASTER             ";
      CASE IS = 11
        PRINT "SPEED : FAST                          "
        PRINT "WEAPON: RUBIX CUBE                    ";
      CASE IS = 12
        PRINT "SPEED : SLOW                          "
        PRINT "WEAPON: EXPLODING BRICKS              ";
      END SELECT

      FOR i = 1 TO NumOpponents
        LOCATE 12 + i, 4
        IF y = 12 + i THEN COLOR 2 ELSE COLOR 4
        COLOR 8
        PRINT "OPPONENT" + STR$(i); "         : ";
        IF y = i + 12 THEN COLOR 15 ELSE COLOR 7
        COLOR 8
        IF Opponent(i) = 0 THEN PRINT "OTHER PLAYER    "
        IF Opponent(i) = 1 THEN PRINT "DANIEL KUNZ     "
        IF Opponent(i) = 2 THEN PRINT "ROGER RAPPLEYE  "
        IF Opponent(i) = 3 THEN PRINT "KEVIN OSGUTHORPE"
        IF Opponent(i) = 4 THEN PRINT "JMES HETH     "
        IF Opponent(i) = 5 THEN PRINT "ROBERT WEISHAR  "
        IF Opponent(i) = 6 THEN PRINT "JOSH SPRINGER   "
        IF Opponent(i) = 7 THEN PRINT "O KING        "
      NEXT i
      FOR i = 1 TO 8 - NumOpponents
        LOCATE , 4
        PRINT "                                     "
      NEXT i

      oy = y
      IF Map <> OMap THEN
        OMap = Map
        m$ = RIGHT$(STR$(Map), LEN(STR$(Map)) - 1)
        LOCATE 1, 1
        OPEN m$ + ".UTM" FOR INPUT AS #1
          FOR y = 1 TO 20
            FOR x = 1 TO 32
              INPUT #1, c
              IF c = 0 THEN oc = 0
              IF c = 1 THEN oc = 4
              IF c = 2 THEN oc = 8
              IF c = 3 THEN oc = 6
              IF c = 4 THEN oc = 9
              IF c = 5 THEN oc = 7
              IF c = 6 THEN oc = 6
              IF c = 7 THEN oc = 0
              IF c = 8 THEN oc = 0
              IF c = 9 THEN oc = 2
              IF c = 10 THEN oc = 2
              IF c = 11 THEN oc = 2
              IF c = 21 THEN oc = 6
              IF c = 22 THEN oc = 2
              IF c = 24 THEN oc = 1
              c = oc
              LINE (x * 2 - 2 + 125, y * 2 - 2 + 25)-(x * 2 - 1 + 125, y * 2 - 1 + 25), c, BF
            NEXT x
          NEXT y
        CLOSE #1
      END IF
      y = oy

      DO
        a$ = INKEY$
      LOOP WHILE a$ = ""
        oy = y
        IF a$ = CHR$(0) + "P" THEN y = y + 1
        IF a$ = CHR$(0) + "H" THEN y = y - 1
        IF a$ = CHR$(27) THEN EXIT SUB
        IF a$ = CHR$(0) + "M" THEN
          IF y = 10 THEN
            You = You + 1
            IF You > 12 THEN You = 1
            IF You < 1 THEN You = 12
          ELSEIF y = 11 THEN
            Map = Map + 1
            IF Map > 50 THEN Map = 1
            IF Map < 1 THEN Map = 50
          ELSEIF y = 12 THEN
            NumOpponents = NumOpponents + 1
            IF NumOpponents > 8 THEN NumOpponents = 1
            IF NumOpponents < 1 THEN NumOpponents = 8
          ELSEIF y > 12 AND y < 21 THEN
            Opponent(y - 12) = Opponent(y - 12) + 1
            IF Opponent(y - 12) > 12 THEN Opponent(y - 12) = 1
            IF Opponent(y - 12) < 1 THEN Opponent(y - 12) = 12
          END IF
        END IF
        IF a$ = CHR$(0) + "K" THEN
          IF y = 10 THEN
            You = You - 1
            IF You > 12 THEN You = 1
            IF You < 1 THEN You = 12
          ELSEIF y = 11 THEN
            Map = Map - 1
            IF Map > 50 THEN Map = 1
            IF Map < 1 THEN Map = 50
          ELSEIF y = 12 THEN
            NumOpponents = NumOpponents - 1
            IF NumOpponents > 8 THEN NumOpponents = 1
            IF NumOpponents < 1 THEN NumOpponents = 8
          ELSEIF y > 12 AND y < 21 THEN
            Opponent(y - 12) = Opponent(y - 12) - 1
            IF Opponent(y - 12) > 12 THEN Opponent(y - 12) = 1
            IF Opponent(y - 12) < 1 THEN Opponent(y - 12) = 12
          END IF
        END IF
        Opponent(1) = 0
        IF a$ = CHR$(13) AND y = 21 THEN Assemble: EXIT SUB
        IF y < 10 THEN y = 21
        IF y > 21 THEN y = 10
        IF oy = 21 AND y < 21 AND y > 12 + NumOpponents THEN y = 12 + NumOpponents
        IF y > 12 + NumOpponents AND y < 21 THEN y = 21
        IF y <> 10 THEN y = 21
        IF y <> 21 THEN y = 10
        IF y <> oy THEN
          COLOR 4
          LOCATE oy, 2: PRINT " "
          SELECT CASE oy
          CASE IS = 10
            LOCATE 10, 4: PRINT "SELECT PLAYER      :"
          CASE IS = 11
            LOCATE 11, 4: PRINT "SELECT MAP         :"
          CASE IS = 12
            LOCATE 12, 4: PRINT "NUMBER OF OPPONENTS:"
          CASE IS > 12
            FOR i = 1 TO NumOpponents
              LOCATE 12 + i, 4
              IF y = 12 + i THEN COLOR 2 ELSE COLOR 4
              COLOR 8
              PRINT "OPPONENT" + STR$(i); "         : ";
              IF y = i + 12 THEN COLOR 15 ELSE COLOR 7
              COLOR 8
              IF Opponent(i) = 0 THEN PRINT "OTHER PLAYER    "
              IF Opponent(i) = 1 THEN PRINT "DANIEL KUNZ     "
              IF Opponent(i) = 2 THEN PRINT "KENDALL CHAPMAN "
              IF Opponent(i) = 3 THEN PRINT "ROGER RAPPLEYE  "
              IF Opponent(i) = 4 THEN PRINT "KEVIN OSGUTHORPE"
              IF Opponent(i) = 5 THEN PRINT "JMES HETH     "
              IF Opponent(i) = 6 THEN PRINT "ROBERT WEISHAR  "
              IF Opponent(i) = 7 THEN PRINT "JOSH SPRINGER   "
              IF Opponent(i) = 8 THEN PRINT "DANIEL KING     "
              IF Opponent(i) = 9 THEN PRINT "JAMES BISHOP    "
              IF Opponent(i) = 10 THEN PRINT "BLAINE WOOD     "
              IF Opponent(i) = 11 THEN PRINT "O KING        "
              IF Opponent(i) = 12 THEN PRINT "CRABBY          "
            NEXT i
            FOR i = 1 TO 8 - NumOpponents
              LOCATE , 4
              PRINT "                                     "
            NEXT i
          END SELECT
        END IF
    LOOP

END SUB

SUB SinglePlayer

                                        '- declare variabls
                                          DIM y AS INTEGER, oy AS INTEGER
                                          DIM i AS INTEGER, n AS INTEGER
                                          DIM x AS INTEGER
                                          DIM c AS INTEGER, oc  AS INTEGER
                                          DIM OMap AS INTEGER
 
  '- single player stuff
    CLS
    NumOpponents = 1
    You = 1
    Map = 1
    OMap = 0
    FOR i = 1 TO 8
      Opponent(i) = 1
    NEXT i
    LOCATE 2, 14
    COLOR 1
    PRINT "SINGLE PLAYER"
    y = 10

    COLOR 4
    LOCATE 10, 4
    PRINT "SELECT PLAYER      :"
    LOCATE 11, 4
    PRINT "SELECT MAP         :"
    LOCATE 12, 4
    PRINT "NUMBER OF OPPONENTS:"

    DO
      LOCATE y, 2
      COLOR 14
      PRINT CHR$(26)

      COLOR 2
      SELECT CASE y
      CASE IS = 10
        LOCATE 10, 4: PRINT "SELECT PLAYER      :"
      CASE IS = 11
        LOCATE 11, 4: PRINT "SELECT MAP         :"
      CASE IS = 12
        LOCATE 12, 4: PRINT "NUMBER OF OPPONENTS:"
      END SELECT

      IF y = 10 THEN COLOR 15 ELSE COLOR 7
      LOCATE 10, 25
      SELECT CASE You
      CASE IS = 1
        PRINT "DANIEL KUNZ     "
      CASE IS = 2
        PRINT "KENDALL CHAPMAN "
      CASE IS = 3
        PRINT "ROGER RAPPLEYE  "
      CASE IS = 4
        PRINT "KEVIN OSGUTHORPE"
      CASE IS = 5
        PRINT "JMES HETH     "
      CASE IS = 6
        PRINT "ROBERT WEISHAR  "
      CASE IS = 7
        PRINT "JOSH SPRINGER   "
      CASE IS = 8
        PRINT "DANIEL KING     "
      CASE IS = 9
        PRINT "JAMES BISHOP    "
      CASE IS = 10
        PRINT "BLAINE WOOD     "
      CASE IS = 11
        PRINT "O KING        "
      CASE IS = 12
        PRINT "CRABBY          "
      END SELECT

      IF y = 11 THEN COLOR 15 ELSE COLOR 7
      LOCATE 11, 24
      PRINT Map; "  "

      IF y = 12 THEN COLOR 15 ELSE COLOR 7
      LOCATE 12, 24
      PRINT NumOpponents
     
      LOCATE 21, 4
      IF y = 21 THEN COLOR 2 ELSE COLOR 4
      PRINT "LET THE CHAOS BEGIN!"
     
      LOCATE 22, 1
      COLOR 7
      PRINT ""
      LOCATE 23, 1
      SELECT CASE You
      CASE IS = 1
        PRINT "SPEED : MODERATE                      "
        PRINT "WEAPON: DRUNK MISSILE LAUNCHER        ";
      CASE IS = 2
        PRINT "SPEED : MODERATE                      "
        PRINT "WEAPON: FLAME WAVEBLASTER             ";
      CASE IS = 3
        PRINT "SPEED : MODERATE                      "
        PRINT "WEAPON: FULLY AUTO MISSILE LANUCHER   ";
      CASE IS = 4
        PRINT "SPEED : MODERATE                      "
        PRINT "WEAPON: LIQUID NITROGEN GUN           ";
      CASE IS = 5
        PRINT "SPEED : MODERATE                      "
        PRINT "WEAPON: FAST BOW GUN                  ";
      CASE IS = 6
        PRINT "SPEED : SLOW                          ";
        PRINT "WEAPON: NUCLEAR BOMB                  ";
      CASE IS = 7
        PRINT "SPEED : MODERATE                      "
        PRINT "WEAPON: 3 GAGE SHOTGUN                ";
      CASE IS = 8
        PRINT "SPEED : MODERATE                      "
        PRINT "WEAPON: FLAMETHROWER                  ";
      CASE IS = 9
        PRINT "SPEED : MODERATE                      "
        PRINT "WEAPON: BEES                          ";
      CASE IS = 10
        PRINT "SPEED : MODERATE                      "
        PRINT "WEAPON: SONIC WAVEBLASTER             ";
      CASE IS = 11
        PRINT "SPEED : FAST                          "
        PRINT "WEAPON: RUBIX CUBE                    ";
      CASE IS = 12
        PRINT "SPEED : SLOW                          "
        PRINT "WEAPON: EXPLODING BRICKS              ";
      END SELECT

      FOR i = 1 TO NumOpponents
        LOCATE 12 + i, 4
        IF y = 12 + i THEN COLOR 2 ELSE COLOR 4
        PRINT "OPPONENT" + STR$(i); "         : ";
        IF y = i + 12 THEN COLOR 15 ELSE COLOR 7
        IF Opponent(i) = 1 THEN PRINT "DANIEL KUNZ     "
        IF Opponent(i) = 2 THEN PRINT "KENDALL CHAPMAN "
        IF Opponent(i) = 3 THEN PRINT "ROGER RAPPLEYE  "
        IF Opponent(i) = 4 THEN PRINT "KEVIN OSGUTHORPE"
        IF Opponent(i) = 5 THEN PRINT "JMES HETH     "
        IF Opponent(i) = 6 THEN PRINT "ROBERT WEISHAR  "
        IF Opponent(i) = 7 THEN PRINT "JOSH SPRINGER   "
        IF Opponent(i) = 8 THEN PRINT "DANIEL KING     "
        IF Opponent(i) = 9 THEN PRINT "JAMES BISHOP    "
        IF Opponent(i) = 10 THEN PRINT "BLAINE WOOD     "
        IF Opponent(i) = 11 THEN PRINT "O KING        "
        IF Opponent(i) = 12 THEN PRINT "CRABBY          "
      NEXT i
      FOR i = 1 TO 8 - NumOpponents
        LOCATE , 4
        PRINT "                                     "
      NEXT i

      oy = y
      IF Map <> OMap THEN
        OMap = Map
        m$ = RIGHT$(STR$(Map), LEN(STR$(Map)) - 1)
        LOCATE 1, 1
        OPEN m$ + ".UTM" FOR INPUT AS #1
          FOR y = 1 TO 20
            FOR x = 1 TO 32
              INPUT #1, c
              IF c = 0 THEN oc = 0
              IF c = 1 THEN oc = 4
              IF c = 2 THEN oc = 8
              IF c = 3 THEN oc = 6
              IF c = 4 THEN oc = 9
              IF c = 5 THEN oc = 7
              IF c = 6 THEN oc = 6
              IF c = 7 THEN oc = 0
              IF c = 8 THEN oc = 0
              IF c = 9 THEN oc = 2
              IF c = 10 THEN oc = 2
              IF c = 11 THEN oc = 2
              IF c = 21 THEN oc = 6
              IF c = 22 THEN oc = 2
              IF c = 24 THEN oc = 1
              c = oc
              LINE (x * 2 - 2 + 125, y * 2 - 2 + 25)-(x * 2 - 1 + 125, y * 2 - 1 + 25), c, BF
            NEXT x
          NEXT y
        CLOSE #1
      END IF
      y = oy

      DO
        a$ = INKEY$
      LOOP WHILE a$ = ""
        oy = y
        IF a$ = CHR$(0) + "P" THEN y = y + 1
        IF a$ = CHR$(0) + "H" THEN y = y - 1
        IF a$ = CHR$(27) THEN EXIT SUB
        IF a$ = CHR$(0) + "M" THEN
          IF y = 10 THEN
            You = You + 1
            IF You > 12 THEN You = 1
            IF You < 1 THEN You = 12
          ELSEIF y = 11 THEN
            Map = Map + 1
            IF Map > 50 THEN Map = 1
            IF Map < 1 THEN Map = 50
          ELSEIF y = 12 THEN
            NumOpponents = NumOpponents + 1
            IF NumOpponents > 8 THEN NumOpponents = 1
            IF NumOpponents < 1 THEN NumOpponents = 8
          ELSEIF y > 12 AND y < 21 THEN
            Opponent(y - 12) = Opponent(y - 12) + 1
            IF Opponent(y - 12) > 12 THEN Opponent(y - 12) = 1
            IF Opponent(y - 12) < 1 THEN Opponent(y - 12) = 12
          END IF
        END IF
        IF a$ = CHR$(0) + "K" THEN
          IF y = 10 THEN
            You = You - 1
            IF You > 12 THEN You = 1
            IF You < 1 THEN You = 12
          ELSEIF y = 11 THEN
            Map = Map - 1
            IF Map > 50 THEN Map = 1
            IF Map < 1 THEN Map = 50
          ELSEIF y = 12 THEN
            NumOpponents = NumOpponents - 1
            IF NumOpponents > 8 THEN NumOpponents = 1
            IF NumOpponents < 1 THEN NumOpponents = 8
          ELSEIF y > 12 AND y < 21 THEN
            Opponent(y - 12) = Opponent(y - 12) - 1
            IF Opponent(y - 12) > 12 THEN Opponent(y - 12) = 1
            IF Opponent(y - 12) < 1 THEN Opponent(y - 12) = 12
          END IF
        END IF
        IF a$ = CHR$(13) AND y = 21 THEN Assemble: EXIT SUB
        IF y < 10 THEN y = 21
        IF y > 21 THEN y = 10
        IF oy = 21 AND y < 21 AND y > 12 + NumOpponents THEN y = 12 + NumOpponents
        IF y > 12 + NumOpponents AND y < 21 THEN y = 21
        IF y <> oy THEN
          COLOR 4
          LOCATE oy, 2: PRINT " "
          SELECT CASE oy
          CASE IS = 10
            LOCATE 10, 4: PRINT "SELECT PLAYER      :"
          CASE IS = 11
            LOCATE 11, 4: PRINT "SELECT MAP         :"
          CASE IS = 12
            LOCATE 12, 4: PRINT "NUMBER OF OPPONENTS:"
          CASE IS > 12
            FOR i = 1 TO NumOpponents
              LOCATE 12 + i, 4
              IF y = 12 + i THEN COLOR 2 ELSE COLOR 4
              PRINT "OPPONENT" + STR$(i); "         : ";
              IF y = i + 12 THEN COLOR 15 ELSE COLOR 7
              IF Opponent(i) = 1 THEN PRINT "DANIEL KUNZ     "
              IF Opponent(i) = 2 THEN PRINT "KENDALL CHAPMAN "
              IF Opponent(i) = 3 THEN PRINT "ROGER RAPPLEYE  "
              IF Opponent(i) = 4 THEN PRINT "KEVIN OSGUTHORPE"
              IF Opponent(i) = 5 THEN PRINT "JMES HETH     "
              IF Opponent(i) = 6 THEN PRINT "ROBERT WEISHAR  "
              IF Opponent(i) = 7 THEN PRINT "JOSH SPRINGER   "
              IF Opponent(i) = 8 THEN PRINT "DANIEL KING     "
              IF Opponent(i) = 9 THEN PRINT "JAMES BISHOP    "
              IF Opponent(i) = 10 THEN PRINT "BLAINE WOOD     "
              IF Opponent(i) = 11 THEN PRINT "O KING        "
              IF Opponent(i) = 12 THEN PRINT "CRABBY          "
            NEXT i
            FOR i = 1 TO 8 - NumOpponents
              LOCATE , 4
              PRINT "                                    "
            NEXT i
          END SELECT
        END IF
    LOOP

END SUB

SUB Title

                                        '- declare variables
                                          DIM i AS INTEGER
                                          DIM x AS INTEGER
                                          DIM y AS INTEGER
                                          STATIC First AS INTEGER

  '- the title
    SCREEN 13
    CLS
    Took = 0
    Serial = 0
    Master = 0
    ComPort = 0

    IF First = 0 THEN
      PRINT "Unofficial Tournament                  "
      PRINT "AntiCopyright(AC) 2001-2002            "
      PRINT "All Rights Not Reserved                "
      PRINT
      PRINT "Warning: A very small percentage of    "
      PRINT "individuals may experience epileptic   "
      PRINT "seizures when exposed to certain light "
      PRINT "patterns of flashing lights. Exposure  "
      PRINT "to certain patterns of backgrounds on  "
      PRINT "a television screen or while playing   "
      PRINT "video games, including Unofficial      "
      PRINT "Tornament, may induce epileptic seizure"
      PRINT "in these individuals.                  "
      PRINT
      PRINT "We will not be held responsible for any"
      PRINT "damages done to you or to your computer"
      PRINT
      PRINT
      PRINT "         YOU HAVE BEEN WARNED          "
      SLEEP (15)
      CLS
      LoadPalette

      DEF SEG = &HA000
        BLOAD "UTLOGO.BSV", 0
      DEF SEG
      SLEEP 5
      CLS
    END IF

    COLOR 15
    LOCATE 10, 10
    PRINT "UNOFFICIAL TOURNAMNT"
   
    IF First = 0 THEN
      SLEEP (1)
      FOR i = 1 TO 32000
        x = INT(320 * RND(1)) + 1
        y = INT(200 * RND(1)) + 1
        IF POINT(x, y) = 15 THEN PSET (x, y), 4
      NEXT i
      First = 1
    END IF

    LOCATE 21, 15
    COLOR 40
    PRINT "DELTA CODE"
    LOCATE , 12
    COLOR 136
    PRINT "PROGRAMMING TEAM"

    DO
    LOOP UNTIL INKEY$ = ""

END SUB

SUB TookGame

 
                                        '- declare variabls
                                          DIM y AS INTEGER, oy AS INTEGER
                                          DIM i AS INTEGER, n AS INTEGER
                                          DIM x AS INTEGER
                                          DIM c AS INTEGER, oc  AS INTEGER
                                          DIM OMap AS INTEGER

  '- Two-On-One-Keyboard Game
    CLS
    NumOpponents = 1
    You = 1
    You2 = 1
    Map = 1
    OMap = 0
    FOR i = 1 TO 8
      Opponent(i) = 1
    NEXT i
    LOCATE 2, 9
    COLOR 1
    PRINT "MULTI PLAYER: TOOK GAME"
    y = 10

    COLOR 4
    LOCATE 10, 4
    PRINT "SELECT PLAYER 1    :"
    LOCATE 11, 4
    PRINT "SELECT PLAYER 2    :"
    LOCATE 12, 4
    PRINT "SELECT MAP         :"
    LOCATE 13, 4
    PRINT "NUMBER OF OPPONENTS:"

    DO
      LOCATE y, 2
      COLOR 14
      PRINT CHR$(26)

      COLOR 2
      SELECT CASE y
      CASE IS = 10
        LOCATE 10, 4: PRINT "SELECT PLAYER 1    :"
      CASE IS = 11
        LOCATE 11, 4: PRINT "SELECT PLAYER 2    :"
      CASE IS = 12
        LOCATE 12, 4: PRINT "SELECT MAP         :"
      CASE IS = 13
        LOCATE 13, 4: PRINT "NUMBER OF OPPONENTS:"
      END SELECT

      IF y = 10 THEN COLOR 15 ELSE COLOR 7
      LOCATE 10, 25
      SELECT CASE You
      CASE IS = 1
        PRINT "DANIEL KUNZ     "
      CASE IS = 2
        PRINT "KENDALL CHAPMAN "
      CASE IS = 3
        PRINT "ROGER RAPPLEYE  "
      CASE IS = 4
        PRINT "KEVIN OSGUTHORPE"
      CASE IS = 5
        PRINT "JMES HETH     "
      CASE IS = 6
        PRINT "ROBERT WEISHAR  "
      CASE IS = 7
        PRINT "JOSH SPRINGER   "
      CASE IS = 8
        PRINT "DANIEL KING     "
      CASE IS = 9
        PRINT "JAMES BISHOP    "
      CASE IS = 10
        PRINT "BLAINE WOOD     "
      CASE IS = 11
        PRINT "O KING        "
      CASE IS = 12
        PRINT "CRABBY          "
      END SELECT

      IF y = 11 THEN COLOR 15 ELSE COLOR 7
      LOCATE 11, 25
      SELECT CASE You2
      CASE IS = 1
        PRINT "DANIEL KUNZ     "
      CASE IS = 2
        PRINT "KENDALL CHAPMAN "
      CASE IS = 3
        PRINT "ROGER RAPPLEYE  "
      CASE IS = 4
        PRINT "KEVIN OSGUTHORPE"
      CASE IS = 5
        PRINT "JMES HETH     "
      CASE IS = 6
        PRINT "ROBERT WEISHAR  "
      CASE IS = 7
        PRINT "JOSH SPRINGER   "
      CASE IS = 8
        PRINT "DANIEL KING     "
      CASE IS = 9
        PRINT "JAMES BISHOP    "
      CASE IS = 10
        PRINT "BLAINE WOOD     "
      CASE IS = 11
        PRINT "O KING        "
      CASE IS = 12
        PRINT "CRABBY          "
      END SELECT
     
      IF y = 12 THEN COLOR 15 ELSE COLOR 7
      LOCATE 12, 24
      PRINT Map; "  "

      IF y = 13 THEN COLOR 15 ELSE COLOR 7
      LOCATE 13, 24
      PRINT NumOpponents
    
      LOCATE 21, 4
      IF y = 21 THEN COLOR 2 ELSE COLOR 4
      PRINT "LET THE CHAOS BEGIN!"
    
      LOCATE 22, 1
      COLOR 7
      PRINT ""
      LOCATE 23, 1
      SELECT CASE You
      CASE IS = 1
        PRINT "SPEED : MODERATE                      "
        PRINT "WEAPON: DRUNK MISSILE LAUNCHER        ";
      CASE IS = 2
        PRINT "SPEED : MODERATE                      "
        PRINT "WEAPON: FLAME WAVEBLASTER             ";
      CASE IS = 3
        PRINT "SPEED : MODERATE                      "
        PRINT "WEAPON: FULLY AUTO MISSILE LANUCHER   ";
      CASE IS = 4
        PRINT "SPEED : MODERATE                      "
        PRINT "WEAPON: LIQUID NITROGEN GUN           ";
      CASE IS = 5
        PRINT "SPEED : MODERATE                      "
        PRINT "WEAPON: FAST BOW GUN                  ";
      CASE IS = 6
        PRINT "SPEED : SLOW                          ";
        PRINT "WEAPON: NUCLEAR BOMB                  ";
      CASE IS = 7
        PRINT "SPEED : MODERATE                      "
        PRINT "WEAPON: 3 GAGE SHOTGUN                ";
      CASE IS = 8
        PRINT "SPEED : MODERATE                      "
        PRINT "WEAPON: FLAMETHROWER                  ";
      CASE IS = 9
        PRINT "SPEED : MODERATE                      "
        PRINT "WEAPON: BEES                          ";
      CASE IS = 10
        PRINT "SPEED : MODERATE                      "
        PRINT "WEAPON: SONIC WAVEBLASTER             ";
      CASE IS = 11
        PRINT "SPEED : FAST                          "
        PRINT "WEAPON: RUBIX CUBE                    ";
      CASE IS = 12
        PRINT "SPEED : SLOW                          "
        PRINT "WEAPON: EXPLODING BRICKS              ";
      END SELECT

      FOR i = 1 TO NumOpponents
        LOCATE 13 + i, 4
        IF y = 13 + i THEN COLOR 2 ELSE COLOR 4
        PRINT "OPPONENT" + STR$(i); "         : ";
        IF y = i + 13 THEN COLOR 15 ELSE COLOR 7
        IF Opponent(i) = 1 THEN PRINT "DANIEL KUNZ     "
        IF Opponent(i) = 2 THEN PRINT "KENDALL CHAPMAN "
        IF Opponent(i) = 3 THEN PRINT "ROGER RAPPLEYE  "
        IF Opponent(i) = 4 THEN PRINT "KEVIN OSGUTHORPE"
        IF Opponent(i) = 5 THEN PRINT "JMES HETH     "
        IF Opponent(i) = 6 THEN PRINT "ROBERT WEISHAR  "
        IF Opponent(i) = 7 THEN PRINT "JOSH SPRINGER   "
        IF Opponent(i) = 8 THEN PRINT "DANIEL KING     "
        IF Opponent(i) = 9 THEN PRINT "JAMES BISHOP    "
        IF Opponent(i) = 10 THEN PRINT "BLAINE WOOD     "
        IF Opponent(i) = 11 THEN PRINT "O KING        "
        IF Opponent(i) = 12 THEN PRINT "CRABBY          "
      NEXT i
      FOR i = 1 TO 7 - NumOpponents
        LOCATE , 4
        PRINT "                                     "
      NEXT i

      oy = y
      IF Map <> OMap THEN
        OMap = Map
        m$ = RIGHT$(STR$(Map), LEN(STR$(Map)) - 1)
        LOCATE 1, 1
        OPEN m$ + ".UTM" FOR INPUT AS #1
          FOR y = 1 TO 20
            FOR x = 1 TO 32
              INPUT #1, c
              IF c = 0 THEN oc = 0
              IF c = 1 THEN oc = 4
              IF c = 2 THEN oc = 8
              IF c = 3 THEN oc = 6
              IF c = 4 THEN oc = 9
              IF c = 5 THEN oc = 7
              IF c = 6 THEN oc = 6
              IF c = 7 THEN oc = 0
              IF c = 8 THEN oc = 0
              IF c = 9 THEN oc = 2
              IF c = 10 THEN oc = 2
              IF c = 11 THEN oc = 2
              IF c = 21 THEN oc = 6
              IF c = 22 THEN oc = 2
              IF c = 24 THEN oc = 1
              c = oc
              LINE (x * 2 - 2 + 125, y * 2 - 2 + 25)-(x * 2 - 1 + 125, y * 2 - 1 + 25), c, BF
            NEXT x
          NEXT y
        CLOSE #1
      END IF
      y = oy

      DO
        a$ = INKEY$
      LOOP WHILE a$ = ""
        oy = y
        IF a$ = CHR$(0) + "P" THEN y = y + 1
        IF a$ = CHR$(0) + "H" THEN y = y - 1
        IF a$ = CHR$(27) THEN EXIT SUB
        IF a$ = CHR$(0) + "M" THEN
          IF y = 10 THEN
            You = You + 1
            IF You > 12 THEN You = 1
            IF You < 1 THEN You = 12
          ELSEIF y = 11 THEN
            You2 = You2 + 1
            IF You2 > 10 THEN You2 = 1
            IF You2 < 1 THEN You2 = 10
          ELSEIF y = 12 THEN
            Map = Map + 1
            IF Map > 50 THEN Map = 1
            IF Map < 1 THEN Map = 50
          ELSEIF y = 13 THEN
            NumOpponents = NumOpponents + 1
            IF NumOpponents > 7 THEN NumOpponents = 1
            IF NumOpponents < 1 THEN NumOpponents = 7
          ELSEIF y > 13 AND y < 21 THEN
            Opponent(y - 13) = Opponent(y - 13) + 1
            IF Opponent(y - 13) > 10 THEN Opponent(y - 13) = 1
            IF Opponent(y - 13) < 1 THEN Opponent(y - 13) = 10
          END IF
        END IF
        IF a$ = CHR$(0) + "K" THEN
          IF y = 10 THEN
            You = You - 1
            IF You > 12 THEN You = 1
            IF You < 1 THEN You = 12
          ELSEIF y = 11 THEN
            You2 = You2 - 1
            IF You2 > 10 THEN You2 = 1
            IF You2 < 1 THEN You2 = 10
          ELSEIF y = 12 THEN
            Map = Map - 1
            IF Map > 50 THEN Map = 1
            IF Map < 1 THEN Map = 50
          ELSEIF y = 13 THEN
            NumOpponents = NumOpponents - 1
            IF NumOpponents > 7 THEN NumOpponents = 1
            IF NumOpponents < 1 THEN NumOpponents = 7
          ELSEIF y > 13 AND y < 21 THEN
            Opponent(y - 13) = Opponent(y - 13) - 1
            IF Opponent(y - 13) > 10 THEN Opponent(y - 13) = 1
            IF Opponent(y - 13) < 1 THEN Opponent(y - 13) = 10
          END IF
        END IF
        IF a$ = CHR$(13) AND y = 21 THEN Assemble: EXIT SUB
        IF y < 10 THEN y = 21
        IF y > 21 THEN y = 11
        IF oy = 21 AND y < 21 AND y > 13 + NumOpponents THEN y = 13 + NumOpponents
        IF y > 13 + NumOpponents AND y < 21 THEN y = 21
        IF y <> oy THEN
          COLOR 4
          LOCATE oy, 2: PRINT " "
          SELECT CASE oy
          CASE IS = 10
            LOCATE 10, 4: PRINT "SELECT PLAYER 1    :"
          CASE IS = 11
            LOCATE 11, 4: PRINT "SELECT PLAYER 2    :"
          CASE IS = 12
            LOCATE 12, 4: PRINT "SELECT MAP         :"
          CASE IS = 13
            LOCATE 13, 4: PRINT "NUMBER OF OPPONENTS:"
          CASE IS > 13
            FOR i = 1 TO NumOpponents
              LOCATE 13 + i, 4
              IF y = 13 + i THEN COLOR 2 ELSE COLOR 4
              PRINT "OPPONENT" + STR$(i); "         : ";
              IF y = i + 13 THEN COLOR 15 ELSE COLOR 7
              IF Opponent(i) = 1 THEN PRINT "DANIEL KUNZ     "
              IF Opponent(i) = 2 THEN PRINT "KENDALL CHAPMAN "
              IF Opponent(i) = 3 THEN PRINT "ROGER RAPPLEYE  "
              IF Opponent(i) = 4 THEN PRINT "KEVIN OSGUTHORPE"
              IF Opponent(i) = 5 THEN PRINT "JMES HETH     "
              IF Opponent(i) = 6 THEN PRINT "ROBERT WEISHAR  "
              IF Opponent(i) = 7 THEN PRINT "JOSH SPRINGER   "
              IF Opponent(i) = 8 THEN PRINT "DANIEL KING     "
              IF Opponent(i) = 9 THEN PRINT "JAMES BISHOP    "
              IF Opponent(i) = 10 THEN PRINT "BLAINE WOOD     "
              IF Opponent(i) = 11 THEN PRINT "O KING        "
              IF Opponent(i) = 12 THEN PRINT "CRABBY          "
            NEXT i
            FOR i = 1 TO 7 - NumOpponents
              LOCATE , 4
              PRINT "                                    "
            NEXT i
          END SELECT
        END IF
    LOOP


END SUB

