DECLARE SUB BmpLoad (FileName$)
DECLARE SUB DisplayTitleScreen ()
DECLARE SUB DisplayDeathScreen ()
DECLARE SUB DisplayWinScreen ()
DECLARE SUB WaitVr (time%)
DECLARE SUB InfoScreen ()
DECLARE SUB CheckLevel ()
DECLARE SUB InitVariables ()
DECLARE SUB TargetItem ()
DECLARE SUB TargetedItem ()
DECLARE SUB LoadGraphics ()
DECLARE SUB LoadLevel (LevelFileName$)
DECLARE SUB DisplayLevel ()
DECLARE SUB RandomizeItems ()
DEFINT A-Z
SCREEN 13

DIM SHARED Arena(0 TO 19, 0 TO 11) AS INTEGER
DIM SHARED Graphics(7 * 202 - 1) AS INTEGER

DIM SHARED X, Y, PlayerTileX, PlayerTileY, UpDate AS INTEGER
DIM SHARED RandItem%, Target%, MaxItemsToCollect%, ArenaTime%
DIM SHARED Level, TimetoKill AS INTEGER
DIM SHARED TimeTracker!
RANDOMIZE TIMER

Level = 0

OPEN "WaitVr.txt" FOR INPUT AS #1
    INPUT #1, TimetoKill
CLOSE #1

DisplayTitleScreen
SLEEP

LoadGraphics
CheckLevel
DO
    KeyBoard = INP(&H60)
    DEF SEG = 0
    POKE 1052, PEEK(1050)
   
    IF KeyBoard = 72 THEN
        IF Arena(PlayerTileX, PlayerTileY - 1) <> 1 THEN
            PlayerTileY = PlayerTileY - 1
            UpDate = 1
        END IF
    END IF
   
    IF KeyBoard = 80 THEN
        IF Arena(PlayerTileX, PlayerTileY + 1) <> 1 THEN
            PlayerTileY = PlayerTileY + 1
            UpDate = 1
        END IF
    END IF

    IF KeyBoard = 75 THEN
        IF Arena(PlayerTileX - 1, PlayerTileY) <> 1 THEN
            PlayerTileX = PlayerTileX - 1
            UpDate = 1
        END IF
    END IF
   
    IF KeyBoard = 77 THEN
        IF Arena(PlayerTileX + 1, PlayerTileY) <> 1 THEN
            PlayerTileX = PlayerTileX + 1
            UpDate = 1
        END IF
    END IF
   
   IF KeyBoard = 57 THEN
       IF Arena(PlayerTileX, PlayerTileY) = Target% THEN
           MaxItemsToCollect% = MaxItemsToCollect% - 1
           Arena(PlayerTileX, PlayerTileY) = 0
           UpDate = 1
       END IF
   END IF
  
   IF TIMER - TimeTracker! >= 1 THEN
       ArenaTime% = ArenaTime% - 1
       TimeTracker! = TIMER
   END IF
  
   IF UpDate = 1 THEN
        IF MaxItemsToCollect% = 0 THEN CheckLevel
        DisplayLevel
        PUT (PlayerTileX * 16, PlayerTileY * 16), Graphics(6 * 130), AND
        PUT (PlayerTileX * 16, PlayerTileY * 16), Graphics(0 * 130), OR
        UpDate = 0
    END IF
    
    WaitVr TimetoKill
LOOP UNTIL KeyBoard = 1 OR ArenaTime% = 0

IF ArenaTime% = 0 THEN
    DisplayDeathScreen
    SLEEP
ELSEIF ArenaTime% <> 0 AND Level% = 5 THEN
    DisplayWinScreen
    SLEEP
END IF
END

SUB BmpLoad (FileName$)

OPEN FileName$ FOR BINARY AS #1
IF LOF(1) = 0 THEN
   COLOR 4
   PRINT "ERROR:"
   PRINT
   PRINT "The File "; FileName$; " Does Not Exist!!!"
  CLOSE #1
  KILL FileName$
  END
END IF

ValidBMP$ = SPACE$(2)
GET #1, 1, ValidBMP$
IF ValidBMP$ <> "BM" THEN
   COLOR 14
    PRINT "ERROR:"
   PRINT " THE FILE "; FileName$; " Is Not A Valid Bitmap(BMP) file."
   EXIT SUB

END IF

bmp$ = " "
GET #1, 23, bmp$
bmpy = ASC(bmp$)
bmpx = (LOF(1) - 1078) / bmpy

GET #1, 54, bmp$
bmp$ = SPACE$(1024)
GET #1, , bmp$
OUT 968, 0
FOR z = 0 TO 255
OUT 969, ASC(MID$(bmp$, z * 4 + 3, 1)) / 4.1
OUT 969, ASC(MID$(bmp$, z * 4 + 2, 1)) / 4.1
OUT 969, ASC(MID$(bmp$, z * 4 + 1, 1)) / 4.1
NEXT
bmp$ = SPACE$(bmpx)
  DEF SEG = &HA000

FOR Y = bmpy - 1 TO 0 STEP -1
GET #1, , bmp$
FOR X = 0 TO bmpx - 1
POKE Y * 320& + X, ASC(MID$(bmp$, X + 1, 1))
NEXT: NEXT
CLOSE #1

END SUB

SUB CheckLevel

Level = Level + 1
IF Level = 1 THEN LoadLevel "Level1"
IF Level = 2 THEN LoadLevel "Level2"
IF Level = 3 THEN LoadLevel "Level3"
IF Level = 4 THEN LoadLevel "Level4"

IF Level = 5 THEN
    KeyBoard = 1
    EXIT SUB
END IF

InitVariables
RandomizeItems
TargetItem
InfoScreen

END SUB

SUB DisplayDeathScreen

LINE (0, 0)-(319, 199), 0, BF
BmpLoad "Death.bmp"

END SUB

SUB DisplayLevel
FOR Y = 0 TO 11
    FOR X = 0 TO 19
        IF Arena(X, Y) = 0 THEN PUT (X * 16, Y * 16), Graphics(4 * 130), PSET
        IF Arena(X, Y) = 1 THEN PUT (X * 16, Y * 16), Graphics(5 * 130), PSET
        IF Arena(X, Y) = 2 THEN PUT (X * 16, Y * 16), Graphics(1 * 130), PSET
        IF Arena(X, Y) = 3 THEN PUT (X * 16, Y * 16), Graphics(2 * 130), PSET
        IF Arena(X, Y) = 4 THEN PUT (X * 16, Y * 16), Graphics(3 * 130), PSET
    NEXT X
NEXT Y
END SUB

SUB DisplayTitleScreen

LINE (0, 0)-(319, 199), 0, BF
BmpLoad "Title.bmp"

END SUB

SUB DisplayWinScreen

LINE (0, 0)-(319, 199), 0, BF
BmpLoad "Win.bmp"

END SUB

SUB InfoScreen

LINE (0, 0)-(319, 199), 0, BF
LINE (1, 1)-(319, 40), 15, B

LOCATE 2, 4
PRINT "Level"; Level%

LOCATE 2, 15
PRINT "Time"; ArenaTime%

LOCATE 2, 30
PRINT "Collect"
PUT (255, 20), Graphics(RandItem% * 130), PSET

SLEEP 3

END SUB

SUB InitVariables

PlayerTileX = 1
PlayerTileY = 1
UpDate = 1

TimeTracker! = TIMER

END SUB

SUB LoadGraphics

DEF SEG = VARSEG(Graphics(0))
    BLOAD "Absorb.Put", VARPTR(Graphics(0))
DEF SEG

PUT (0, 0), Graphics(0 * 130), PSET
FOR Y = 0 TO 15
    FOR X = 0 TO 15
        IF POINT(X, Y) = 0 THEN PSET (X, Y), 255 ELSE PSET (X, Y), 0
    NEXT X
NEXT Y
GET (0, 0)-(15, 15), Graphics(6 * 130)

END SUB

SUB LoadLevel (LevelFileName$)

OPEN LevelFileName$ + ".DCL" FOR INPUT AS #1
INPUT #1, ArenaTime%
FOR Y = 0 TO 11
    FOR X = 0 TO 19
        INPUT #1, Arena(X, Y)
    NEXT X
NEXT Y
CLOSE #1

END SUB

SUB RandomizeItems

FOR Y = 0 TO 11
    FOR X = 0 TO 19
        RandItem% = INT(RND * 3) + 1
        IF Arena(X, Y) = 0 THEN
            IF RandItem% = 1 THEN
                Arena(X, Y) = 2
            ELSEIF RandItem% = 2 THEN
                Arena(X, Y) = 3
            ELSEIF RandItem% = 3 THEN
                Arena(X, Y) = 4
            END IF
        END IF
    NEXT X
NEXT Y

END SUB

SUB TargetItem

RandItem% = INT(RND * 3) + 1
 IF RandItem% = 1 THEN
     Target% = 2
 ELSEIF RandItem% = 2 THEN
     Target% = 3
 ELSEIF RandItem% THEN
     Target% = 4
 END IF

FOR Y = 0 TO 11
    FOR X = 0 TO 19
        IF Arena(X, Y) = Target% THEN
            MaxItemsToCollect% = MaxItemsToCollect + 1
        END IF
    NEXT X
NEXT Y

END SUB

SUB WaitVr (time%)

FOR I = 0 TO time%
    WAIT &H3DA, 8
    WAIT &H3DA, 8, 8
NEXT I

END SUB

