'''''''''''''''''''''''''''''''''''''''''''''''''
' Sub Declarations                              '
'''''''''''''''''''''''''''''''''''''''''''''''''
DEFINT A-Z
DECLARE SUB Main ()
DECLARE SUB Convert ()
DECLARE SUB Place ()
DECLARE FUNCTION Win ()
DECLARE SUB CompTurn ()
DECLARE SUB CompTest ()
DECLARE SUB Quit ()

DECLARE SUB Suspend (delay!, speed&)
DECLARE FUNCTION GetSpeed& ()

COMMON SHARED Debugging


'''''''''''''''''''''''''''''''''''''''''''''''''
' Random Stuff                                  '
'''''''''''''''''''''''''''''''''''''''''''''''''
RANDOMIZE TIMER


'''''''''''''''''''''''''''''''''''''''''''''''''
' Error Handling                                '
'''''''''''''''''''''''''''''''''''''''''''''''''
ON ERROR GOTO ErrorHandler


'''''''''''''''''''''''''''''''''''''''''''''''''
' Variable Declarations                         '
'''''''''''''''''''''''''''''''''''''''''''''''''
DIM SHARED offs          AS INTEGER  'The x offset(80 pixels) of every graphic.

DIM SHARED CompLevel     AS INTEGER  'Determines the skill level of the AI
                                     'player.
DIM SHARED CompSpeed     AS LONG     'Determines how fast the computer is.
DIM SHARED Player(2)     AS INTEGER  '1 Human Player,      2 Computer Player.
DIM SHARED Turn          AS INTEGER  '1 Player One's Turn, 2 Player Two's Turn.
DIM SHARED Move          AS STRING   'The users input on where to move.
DIM SHARED GoAt          AS INTEGER  'The number of which column to place the
                                     'players piece.
DIM SHARED Board(11, 10) AS INTEGER  '0 Neither player has a piece on (x, y)
                                     '1 Player one has piece on (x, y)
                                     '2 Player two has piece on (x, y)


'''''''''''''''''''''''''''''''''''''''''''''''''
' Variable Initialization                       '
'''''''''''''''''''''''''''''''''''''''''''''''''
StartGame:
  SCREEN 0
  CLS
  PRINT
  PRINT "Status:  Initializing Variables."
  CompSpeed& = GetSpeed&
  PRINT "Status:  Variable 'CompSpeed' Initialized."
  CompLevel = 1
  PRINT "Status:  Variable 'CompLevel' Initialized."
  offs = 80
  PRINT "Status:  Variable 'offs'      Initialized."
  Player(1) = 1
  Player(2) = 1
  PRINT "Status:  Array    'Player'    Initialized."
  Turn = 1
  PRINT "Status:  Variable 'Turn'      Initialized."
  Move$ = ""
  PRINT "Status:  Variable 'Move$'     Initialized."
  FOR y = 1 TO 10
    FOR x = 1 TO 10
      Board(y, x) = 0
    NEXT x
  NEXT y
  FOR x = 1 TO 10
    Board(11, x) = 3
  NEXT x
  PRINT "Status:  Array    'Board'     Initialized."
  PRINT "Status:  All variables have been Initialized."
  PRINT

'''''''''''''''''''''''''''''''''''''''''''''''''
' Graphics Initialization                       '
'''''''''''''''''''''''''''''''''''''''''''''''''
  PRINT
  PRINT "Status:  Initializing Graphics."
  PRINT "Status:  No graphics to initialize."
  PRINT "Status:  All graphics have been Initialized."
  PRINT


'''''''''''''''''''''''''''''''''''''''''''''''''
' AI Initialization                             '
'''''''''''''''''''''''''''''''''''''''''''''''''
  PRINT
  PRINT "Status:  No Initialization Required."
  PRINT "Status:  Artificial Intelligence Initialized."
  PRINT



  PRINT "Press any key to continue..."
  WHILE INKEY$ = "": WEND

'''''''''''''''''''''''''''''''''''''''''''''''''
' Set up Game                                   '
'''''''''''''''''''''''''''''''''''''''''''''''''
 
  DO
    IF Player(1) = 1 THEN
      CLS
      LOCATE 25, 1: PRINT "Press 'q' to quit.";
      LOCATE 1, 1
      COLOR 7, 0, 9:  PRINT "(S)ingle Player or (M)ultiPlayer? ";
      COLOR 31, 0, 9:
      LOCATE 1, 2:    PRINT "S";
      LOCATE 1, 21:   PRINT "M";
      LOCATE 1, 35:   COLOR 15
      DO                       'Wait for a valid key.
        a$ = INKEY$
        SELECT CASE a$
          CASE "S": EXIT DO
          CASE "s": EXIT DO
          CASE "M": EXIT DO
          CASE "m": EXIT DO
          CASE "Q": Quit
          CASE "q": Quit
          CASE CHR$(27): Quit
        END SELECT
      LOOP
      PRINT a$
      COLOR 15, 0, 9:
      LOCATE 1, 2:    PRINT "S";
      LOCATE 1, 21:   PRINT "M";
      IF a$ = "Q" OR a$ = "q" THEN Quit
      IF a$ = "S" OR a$ = "s" THEN     'Start a single player game.
        Player(2) = 2
        LOCATE 2, 1
        COLOR 25, 0, 9:  PRINT "(E)asy AI"
        COLOR 31, 0, 9:  LOCATE 2, 2: PRINT "E"
        COLOR 7:  PRINT "(N)ormal AI"
        COLOR 31, 0, 9:  LOCATE 3, 2: PRINT "N"
'        COLOR 7:  PRINT "(H)ard AI"
'        COLOR 31, 0, 9:  LOCATE 4, 2: PRINT "H"
     
        DO
          DO  'Wait for a valid key.
            a$ = INKEY$
            SELECT CASE a$
              CASE CHR$(27): backup = 1: EXIT DO
              CASE "Q": COLOR 15, 0, 9: Quit
              CASE "q": COLOR 15, 0, 9: Quit
          
              CASE "E": CompLevel = 1: EXIT DO
              CASE "e": CompLevel = 1: EXIT DO
              CASE "N": CompLevel = 2: EXIT DO
              CASE "n": CompLevel = 2: EXIT DO
'              CASE "H": CompLevel = 3: EXIT DO
'              CASE "h": CompLevel = 3: EXIT DO
              CASE CHR$(13):
                Main
                GOTO StartGame
           
              CASE CHR$(0) + "H"  'Up Arrow
                CompLevel = CompLevel - 1
                IF CompLevel = 0 THEN
                  CompLevel = 2
                END IF
                EXIT DO
              CASE CHR$(0) + "P"  'Down Arrow
                CompLevel = CompLevel + 1
                IF CompLevel = 3 THEN
                  CompLevel = 1
                END IF
                EXIT DO
            END SELECT
          LOOP
          IF backup = 1 THEN
            backup = 0
            EXIT DO
          END IF
          IF CompLevel = 1 THEN 'Easy
            LOCATE 2, 1
            COLOR 25, 0, 9:  PRINT "(E)asy AI"
            COLOR 31, 0, 9:  LOCATE 2, 2: PRINT "E"
            COLOR 7:  PRINT "(N)ormal AI"
            COLOR 31, 0, 9:  LOCATE 3, 2: PRINT "N"
'            COLOR 7:  PRINT "(H)ard AI"
'            COLOR 31, 0, 9:  LOCATE 4, 2: PRINT "H"
          END IF
          IF CompLevel = 2 THEN 'Normal
            LOCATE 2, 1
            COLOR 7:  PRINT "(E)asy AI"
            COLOR 31, 0, 9:  LOCATE 2, 2: PRINT "E"
            COLOR 25, 0, 9:  PRINT "(N)ormal AI"
            COLOR 31, 0, 9:  LOCATE 3, 2: PRINT "N"
'            COLOR 7:  PRINT "(H)ard AI"
'            COLOR 31, 0, 9:  LOCATE 4, 2: PRINT "H"
          END IF
'          IF CompLevel = 3 THEN 'Hard
'            LOCATE 2, 1
'            COLOR 7:  PRINT "(E)asy AI"
'            COLOR 31, 0, 9:  LOCATE 2, 2: PRINT "E"
'            COLOR 7:  PRINT "(N)ormal AI"
'            COLOR 31, 0, 9:  LOCATE 3, 2: PRINT "N"
'            COLOR 25, 0, 9:  PRINT "(H)ard AI"
'            COLOR 31, 0, 9:  LOCATE 4, 2: PRINT "H"
'          END IF
       
          IF a$ = CHR$(13) THEN EXIT DO
          IF a$ = CHR$(27) THEN EXIT DO
          a$ = ""
        LOOP
      END IF
    END IF
    IF a$ = "M" OR a$ = "m" THEN
      Player(1) = 1: Player(2) = 1
      Main
      GOTO StartGame
    END IF
  LOOP



ErrorHandler:
  SELECT CASE ERR
    CASE 53: FileExist = FALSE
  END SELECT
  RESUME NEXT
  SYSTEM

SUB CompTest
  DIM Board2(11, 10)
  FOR y = 1 TO 11
    FOR x = 1 TO 10
      Board2(y, x) = Board(y, x)
    NEXT x
  NEXT y
  FOR y = 1 TO 11
    IF Board2(y, GoAt) > 0 THEN
      Board2(y - 1, GoAt) = Turn
    END IF
  NEXT y

  IF Turn = 1 THEN z = 2
  IF Turn = 2 THEN z = 1
  FOR y = 1 TO 10
    FOR x = 1 TO 10
      '1110 OR 0111
      IF x > 3 AND y > 3 THEN
        IF Board2(y, x) = z AND Board2(y - 1, x - 1) = z AND Board2(y - 2, x - 2) = z THEN
        IF Board2(y - 2, x - 3) > 0 AND Board2(y - 3, x - 3) = 0 THEN
          GoAt = -1
          GOTO CompTurnDone2
        END IF
        END IF
      END IF
      IF y > 3 THEN
        IF Board2(y, x) = z AND Board2(y - 1, x) = z AND Board2(y - 2, x) = z THEN
        IF Board2(y - 3, x) = 0 THEN
          GoAt = -1
          GOTO CompTurnDone2
        END IF
        END IF
      END IF
      IF x < 8 AND y > 3 THEN
        IF Board2(y, x) = z AND Board2(y - 1, x + 1) = z AND Board2(y - 2, x + 2) = z THEN
        IF Board2(y - 2, x + 3) > 0 AND Board2(y - 3, x + 3) = 0 THEN
          GoAt = -1
          GOTO CompTurnDone2
        END IF
        END IF
      END IF
      IF x < 8 THEN
        IF Board2(y, x) = z AND Board2(y, x + 1) = z AND Board2(y, x + 2) = z THEN
        IF Board2(y + 1, x + 3) > 0 AND Board2(y, x + 3) = 0 THEN
          GoAt = -1
          GOTO CompTurnDone2
        END IF
        END IF
      END IF
      IF x < 8 AND y < 8 THEN
        IF Board2(y, x) = z AND Board2(y + 1, x + 1) = z AND Board2(y + 2, x + 2) = z THEN
        IF Board2(y + 4, x + 3) > 0 AND Board2(y + 3, x + 3) = 0 THEN
          GoAt = -1
          GOTO CompTurnDone2
        END IF
        END IF
      END IF
      IF x > 3 AND y < 8 THEN
        IF Board2(y, x) = z AND Board2(y + 1, x - 1) = z AND Board2(y + 2, x - 2) = z THEN
        IF Board2(y + 4, x - 3) > 0 AND Board2(y + 3, x - 3) = 0 THEN
          GoAt = -1
          GOTO CompTurnDone2
        END IF
        END IF
      END IF
      IF x > 3 THEN
        IF Board2(y, x) = z AND Board2(y, x - 1) = z AND Board2(y, x - 2) = z THEN
        IF Board2(y + 1, x - 3) > 0 AND Board2(y, x - 3) = 0 THEN
          GoAt = -1
          GOTO CompTurnDone2
        END IF
        END IF
      END IF
    
      '1011 OR 1101
      IF x > 3 AND y > 3 THEN
        IF Board2(y, x) = z AND Board2(y - 1, x - 1) = 0 AND Board2(y - 2, x - 2) = z THEN
        IF Board2(y, x - 1) > 0 AND Board2(y - 3, x - 3) = z THEN
          GoAt = -1
          GOTO CompTurnDone2
        END IF
        END IF
      END IF
      IF x < 8 AND y > 3 THEN
        IF Board2(y, x) = z AND Board2(y - 1, x + 1) = 0 AND Board2(y - 2, x + 2) = z THEN
        IF Board2(y, x + 1) > 0 AND Board2(y - 3, x + 3) = z THEN
          GoAt = -1
          GOTO CompTurnDone2
        END IF
        END IF
      END IF
      IF x < 8 THEN
        IF Board2(y, x) = z AND Board2(y, x + 1) = 0 AND Board2(y, x + 2) = z THEN
        IF Board2(y + 1, x + 1) > 0 AND Board2(y, x + 3) = z THEN
          GoAt = -1
          GOTO CompTurnDone2
        END IF
        END IF
      END IF
      IF x < 8 AND y < 8 THEN
        IF Board2(y, x) = z AND Board2(y + 1, x + 1) = 0 AND Board2(y + 2, x + 2) = z THEN
        IF Board2(y + 2, x + 1) > 0 AND Board2(y + 3, x + 3) = z THEN
          GoAt = -1
          GOTO CompTurnDone2
        END IF
        END IF
      END IF
      IF x > 3 AND y < 8 THEN
        IF Board2(y, x) = z AND Board2(y + 1, x - 1) = 0 AND Board2(y + 2, x - 2) = z THEN
        IF Board2(y + 2, x - 1) > 0 AND Board2(y + 3, x - 3) = z THEN
          GoAt = -1
          GOTO CompTurnDone2
        END IF
        END IF
      END IF
      IF x > 3 THEN
        IF Board2(y, x) = z AND Board2(y, x - 1) = 0 AND Board2(y, x - 2) = z THEN
        IF Board2(y + 1, x - 1) > 0 AND Board2(y, x - 3) = z THEN
          GoAt = -1
          GOTO CompTurnDone2
        END IF
        END IF
      END IF
    NEXT x
  NEXT y
   
CompTurnDone2:
END SUB

SUB CompTurn
'-------------------------------------------------------------------------'
'     A few words about the AI script for Four In A Row...                '
'-------------------------------------------------------------------------'
''''' First, the AI Player will win that turn if possible.
''''' Second, the AI Player will prolongue their loss if possible.
''''' Third, the AI Player will attempt to move so that they can win the
'''''        next turn.
''''' Fourth, they will attempt to move so that they can disable your
'''''        ability to win in two ways next turn.
''''' ....., ......
''''' ?????, they will place a piece in a random column.

counter = 0


StepOne:  ''''' Win this turn if possible. '''''
  AIStep = 1
  z = Turn
  FOR y = 1 TO 10
    FOR x = 1 TO 10
      '1110 OR 0111
      IF x > 3 AND y > 3 THEN
        IF Board(y, x) = z AND Board(y - 1, x - 1) = z AND Board(y - 2, x - 2) = z THEN
        IF Board(y - 2, x - 3) > 0 AND Board(y - 3, x - 3) = 0 THEN
          GoAt = x - 3
          GOTO CompTurnDone
        END IF
        END IF
      END IF
      IF y > 3 THEN
        IF Board(y, x) = z AND Board(y - 1, x) = z AND Board(y - 2, x) = z THEN
        IF Board(y - 3, x) = 0 THEN
          GoAt = x
          GOTO CompTurnDone
        END IF
        END IF
      END IF
      IF x < 8 AND y > 3 THEN
        IF Board(y, x) = z AND Board(y - 1, x + 1) = z AND Board(y - 2, x + 2) = z THEN
        IF Board(y - 2, x + 3) > 0 AND Board(y - 3, x + 3) = 0 THEN
          GoAt = x + 3
          GOTO CompTurnDone
        END IF
        END IF
      END IF
      IF x < 8 THEN
        IF Board(y, x) = z AND Board(y, x + 1) = z AND Board(y, x + 2) = z THEN
        IF Board(y + 1, x + 3) > 0 AND Board(y, x + 3) = 0 THEN
          GoAt = x + 3
          GOTO CompTurnDone
        END IF
        END IF
      END IF
      IF x < 8 AND y < 8 THEN
        IF Board(y, x) = z AND Board(y + 1, x + 1) = z AND Board(y + 2, x + 2) = z THEN
        IF Board(y + 4, x + 3) > 0 AND Board(y + 3, x + 3) = 0 THEN
          GoAt = x + 3
          GOTO CompTurnDone
        END IF
        END IF
      END IF
      IF x > 3 AND y < 8 THEN
        IF Board(y, x) = z AND Board(y + 1, x - 1) = z AND Board(y + 2, x - 2) = z THEN
        IF Board(y + 4, x - 3) > 0 AND Board(y + 3, x - 3) = 0 THEN
          GoAt = x - 3
          GOTO CompTurnDone
        END IF
        END IF
      END IF
      IF x > 3 THEN
        IF Board(y, x) = z AND Board(y, x - 1) = z AND Board(y, x - 2) = z THEN
        IF Board(y + 1, x - 3) > 0 AND Board(y, x - 3) = 0 THEN
          GoAt = x - 3
          GOTO CompTurnDone
        END IF
        END IF
      END IF

      '1011 OR 1101
      IF x > 3 AND y > 3 THEN
        IF Board(y, x) = z AND Board(y - 1, x - 1) = 0 AND Board(y - 2, x - 2) = z THEN
        IF Board(y, x - 1) > 0 AND Board(y - 3, x - 3) = z THEN
          GoAt = x - 1
          GOTO CompTurnDone
        END IF
        END IF
      END IF
      IF x < 8 AND y > 3 THEN
        IF Board(y, x) = z AND Board(y - 1, x + 1) = 0 AND Board(y - 2, x + 2) = z THEN
        IF Board(y, x + 1) > 0 AND Board(y - 3, x + 3) = z THEN
          GoAt = x + 1
          GOTO CompTurnDone
        END IF
        END IF
      END IF
      IF x < 8 THEN
        IF Board(y, x) = z AND Board(y, x + 1) = 0 AND Board(y, x + 2) = z THEN
        IF Board(y + 1, x + 1) > 0 AND Board(y, x + 3) = z THEN
          GoAt = x + 1
          GOTO CompTurnDone
        END IF
        END IF
      END IF
      IF x < 8 AND y < 8 THEN
        IF Board(y, x) = z AND Board(y + 1, x + 1) = 0 AND Board(y + 2, x + 2) = z THEN
        IF Board(y + 2, x + 1) > 0 AND Board(y + 3, x + 3) = z THEN
          GoAt = x + 1
          GOTO CompTurnDone
        END IF
        END IF
      END IF
      IF x > 3 AND y < 8 THEN
        IF Board(y, x) = z AND Board(y + 1, x - 1) = 0 AND Board(y + 2, x - 2) = z THEN
        IF Board(y + 2, x - 1) > 0 AND Board(y + 3, x - 3) = z THEN
          GoAt = x - 1
          GOTO CompTurnDone
        END IF
        END IF
      END IF
      IF x > 3 THEN
        IF Board(y, x) = z AND Board(y, x - 1) = 0 AND Board(y, x - 2) = z THEN
        IF Board(y + 1, x - 1) > 0 AND Board(y, x - 3) = z THEN
          GoAt = x - 1
          GOTO CompTurnDone
        END IF
        END IF
      END IF
    NEXT x
  NEXT y









StepTwo:  ''''' Prevent you from winning this turn if possible. '''''
  AIStep = 2
  IF Turn = 1 THEN z = 2
  IF Turn = 2 THEN z = 1
  FOR y = 1 TO 10
    FOR x = 1 TO 10
      '1110 OR 0111
      IF x > 3 AND y > 3 THEN
        IF Board(y, x) = z AND Board(y - 1, x - 1) = z AND Board(y - 2, x - 2) = z THEN
        IF Board(y - 2, x - 3) > 0 AND Board(y - 3, x - 3) = 0 THEN
          GoAt = x - 3
          GOTO CompTurnDone
        END IF
        END IF
      END IF
      IF y > 3 THEN
        IF Board(y, x) = z AND Board(y - 1, x) = z AND Board(y - 2, x) = z THEN
        IF Board(y - 3, x) = 0 THEN
          GoAt = x
          GOTO CompTurnDone
        END IF
        END IF
      END IF
      IF x < 8 AND y > 3 THEN
        IF Board(y, x) = z AND Board(y - 1, x + 1) = z AND Board(y - 2, x + 2) = z THEN
        IF Board(y - 2, x + 3) > 0 AND Board(y - 3, x + 3) = 0 THEN
          GoAt = x + 3
          GOTO CompTurnDone
        END IF
        END IF
      END IF
      IF x < 8 THEN
        IF Board(y, x) = z AND Board(y, x + 1) = z AND Board(y, x + 2) = z THEN
        IF Board(y + 1, x + 3) > 0 AND Board(y, x + 3) = 0 THEN
          GoAt = x + 3
          GOTO CompTurnDone
        END IF
        END IF
      END IF
      IF x < 8 AND y < 8 THEN
        IF Board(y, x) = z AND Board(y + 1, x + 1) = z AND Board(y + 2, x + 2) = z THEN
        IF Board(y + 4, x + 3) > 0 AND Board(y + 3, x + 3) = 0 THEN
          GoAt = x + 3
          GOTO CompTurnDone
        END IF
        END IF
      END IF
      IF x > 3 AND y < 8 THEN
        IF Board(y, x) = z AND Board(y + 1, x - 1) = z AND Board(y + 2, x - 2) = z THEN
        IF Board(y + 4, x - 3) > 0 AND Board(y + 3, x - 3) = 0 THEN
          GoAt = x - 3
          GOTO CompTurnDone
        END IF
        END IF
      END IF
      IF x > 3 THEN
        IF Board(y, x) = z AND Board(y, x - 1) = z AND Board(y, x - 2) = z THEN
        IF Board(y + 1, x - 3) > 0 AND Board(y, x - 3) = 0 THEN
          GoAt = x - 3
          GOTO CompTurnDone
        END IF
        END IF
      END IF
     
      '1011 OR 1101
      IF x > 3 AND y > 3 THEN
        IF Board(y, x) = z AND Board(y - 1, x - 1) = 0 AND Board(y - 2, x - 2) = z THEN
        IF Board(y, x - 1) > 0 AND Board(y - 3, x - 3) = z THEN
          GoAt = x - 1
          GOTO CompTurnDone
        END IF
        END IF
      END IF
      IF x < 8 AND y > 3 THEN
        IF Board(y, x) = z AND Board(y - 1, x + 1) = 0 AND Board(y - 2, x + 2) = z THEN
        IF Board(y, x + 1) > 0 AND Board(y - 3, x + 3) = z THEN
          GoAt = x + 1
          GOTO CompTurnDone
        END IF
        END IF
      END IF
      IF x < 8 THEN
        IF Board(y, x) = z AND Board(y, x + 1) = 0 AND Board(y, x + 2) = z THEN
        IF Board(y + 1, x + 1) > 0 AND Board(y, x + 3) = z THEN
          GoAt = x + 1
          GOTO CompTurnDone
        END IF
        END IF
      END IF
      IF x < 8 AND y < 8 THEN
        IF Board(y, x) = z AND Board(y + 1, x + 1) = 0 AND Board(y + 2, x + 2) = z THEN
        IF Board(y + 2, x + 1) > 0 AND Board(y + 3, x + 3) = z THEN
          GoAt = x + 1
          GOTO CompTurnDone
        END IF
        END IF
      END IF
      IF x > 3 AND y < 8 THEN
        IF Board(y, x) = z AND Board(y + 1, x - 1) = 0 AND Board(y + 2, x - 2) = z THEN
        IF Board(y + 2, x - 1) > 0 AND Board(y + 3, x - 3) = z THEN
          GoAt = x - 1
          GOTO CompTurnDone
        END IF
        END IF
      END IF
      IF x > 3 THEN
        IF Board(y, x) = z AND Board(y, x - 1) = 0 AND Board(y, x - 2) = z THEN
        IF Board(y + 1, x - 1) > 0 AND Board(y, x - 3) = z THEN
          GoAt = x - 1
          GOTO CompTurnDone
        END IF
        END IF
      END IF
    NEXT x
  NEXT y
 










StepThree:  ''''' Enable a winning move next turn. '''''
IF CompLevel > 1 THEN
  AIStep = 3
  z = Turn
  FOR y = 1 TO 10
    FOR x = 1 TO 10
      '01100
      IF y > 4 AND x > 4 THEN
        IF Board(y, x) = 0 AND Board(y - 1, x - 1) = z AND Board(y - 2, x - 2) = z THEN
        IF Board(y - 3, x - 3) = 0 AND Board(y - 4, x - 4) = 0 THEN
          IF Board(y + 1, x) > 0 AND Board(y - 1 + 1, x - 1) > 0 AND Board(y - 2 + 1, x - 2) > 0 THEN
          IF Board(y - 3 + 1, x - 3) > 0 AND Board(y - 4 + 1, x - 4) > 0 THEN
            GoAt = x - 3
            GOTO CompTurnDone
          END IF
          END IF
        END IF
        END IF
      END IF
      IF y > 4 AND x < 7 THEN
        IF Board(y, x) = 0 AND Board(y - 1, x + 1) = z AND Board(y - 2, x + 2) = z THEN
        IF Board(y - 3, x + 3) = 0 AND Board(y - 4, x + 4) = 0 THEN
          IF Board(y + 1, x) > 0 AND Board(y - 1 + 1, x + 1) > 0 AND Board(y - 2 + 1, x + 2) > 0 THEN
          IF Board(y - 3 + 1, x + 3) > 0 AND Board(y - 4 + 1, x + 4) > 0 THEN
            GoAt = x + 3
            GOTO CompTurnDone
          END IF
          END IF
        END IF
        END IF
      END IF
      IF x < 7 THEN
        IF Board(y, x) = 0 AND Board(y, x + 1) = z AND Board(y, x + 2) = z THEN
        IF Board(y, x + 3) = 0 AND Board(y, x + 4) = 0 THEN
          IF Board(y + 1, x) > 0 AND Board(y + 1, x + 1) > 0 AND Board(y + 1, x + 2) > 0 THEN
          IF Board(y + 1, x + 3) > 0 AND Board(y + 1, x + 4) > 0 THEN
            GoAt = x + 3
            GOTO CompTurnDone
          END IF
          END IF
        END IF
        END IF
      END IF
      IF y < 7 AND x < 7 THEN
        IF Board(y, x) = 0 AND Board(y + 1, x + 1) = z AND Board(y + 2, x + 2) = z THEN
        IF Board(y + 3, x + 3) = 0 AND Board(y + 4, x + 4) = 0 THEN
          IF Board(y + 1, x) > 0 AND Board(y + 1 + 1, x + 1) > 0 AND Board(y + 2 + 1, x + 2) > 0 THEN
          IF Board(y + 3 + 1, x + 3) > 0 AND Board(y + 4 + 1, x + 4) > 0 THEN
            GoAt = x + 3
            GOTO CompTurnDone
          END IF
          END IF
        END IF
        END IF
      END IF
      IF y < 7 AND x > 4 THEN
        IF Board(y, x) = 0 AND Board(y + 1, x - 1) = z AND Board(y + 2, x - 2) = z THEN
        IF Board(y + 3, x - 3) = 0 AND Board(y + 4, x - 4) = 0 THEN
          IF Board(y + 1, x) > 0 AND Board(y + 1 + 1, x - 1) > 0 AND Board(y + 2 + 1, x - 2) > 0 THEN
          IF Board(y + 3 + 1, x - 3) > 0 AND Board(y + 4 + 1, x - 4) > 0 THEN
            GoAt = x - 3
            GOTO CompTurnDone
          END IF
          END IF
        END IF
        END IF
      END IF
      IF x > 4 THEN
        IF Board(y, x) = 0 AND Board(y, x - 1) = z AND Board(y, x - 2) = z THEN
        IF Board(y, x - 3) = 0 AND Board(y, x - 4) = 0 THEN
          IF Board(y + 1, x) > 0 AND Board(y + 1, x - 1) > 0 AND Board(y + 1, x - 2) > 0 THEN
          IF Board(y + 1, x - 3) > 0 AND Board(y + 1, x - 4) > 0 THEN
            GoAt = x - 3
            GOTO CompTurnDone
          END IF
          END IF
        END IF
        END IF
      END IF
   
      '01010
      IF y > 4 AND x > 4 THEN
        IF Board(y, x) = 0 AND Board(y - 1, x - 1) = z AND Board(y - 2, x - 2) = 0 THEN
        IF Board(y - 3, x - 3) = z AND Board(y - 4, x - 4) = 0 THEN
          IF Board(y + 1, x) > 0 AND Board(y - 1 + 1, x - 1) > 0 AND Board(y - 2 + 1, x - 2) > 0 THEN
          IF Board(y - 3 + 1, x - 3) > 0 AND Board(y - 4 + 1, x - 4) > 0 THEN
            GoAt = x - 2
            GOTO CompTurnDone
          END IF
          END IF
        END IF
        END IF
      END IF
      IF y > 4 AND x < 7 THEN
        IF Board(y, x) = 0 AND Board(y - 1, x + 1) = z AND Board(y - 2, x + 2) = 0 THEN
        IF Board(y - 3, x + 3) = z AND Board(y - 4, x + 4) = 0 THEN
          IF Board(y + 1, x) > 0 AND Board(y - 1 + 1, x + 1) > 0 AND Board(y - 2 + 1, x + 2) > 0 THEN
          IF Board(y - 3 + 1, x + 3) > 0 AND Board(y - 4 + 1, x + 4) > 0 THEN
            GoAt = x + 2
            GOTO CompTurnDone
          END IF
          END IF
        END IF
        END IF
      END IF
      IF x < 7 THEN
        IF Board(y, x) = 0 AND Board(y, x + 1) = z AND Board(y, x + 2) = 0 THEN
        IF Board(y, x + 3) = z AND Board(y, x + 4) = 0 THEN
          IF Board(y + 1, x) > 0 AND Board(y + 1, x + 1) > 0 AND Board(y + 1, x + 2) > 0 THEN
          IF Board(y + 1, x + 3) > 0 AND Board(y + 1, x + 4) > 0 THEN
            GoAt = x + 2
            GOTO CompTurnDone
          END IF
          END IF
        END IF
        END IF
      END IF
      IF y < 7 AND x < 7 THEN
        IF Board(y, x) = 0 AND Board(y + 1, x + 1) = z AND Board(y + 2, x + 2) = 0 THEN
        IF Board(y + 3, x + 3) = z AND Board(y + 4, x + 4) = 0 THEN
          IF Board(y + 1, x) > 0 AND Board(y + 1 + 1, x + 1) > 0 AND Board(y + 2 + 1, x + 2) > 0 THEN
          IF Board(y + 3 + 1, x + 3) > 0 AND Board(y + 4 + 1, x + 4) > 0 THEN
            GoAt = x + 2
            GOTO CompTurnDone
          END IF
          END IF
        END IF
        END IF
      END IF
      IF y < 7 AND x > 4 THEN
        IF Board(y, x) = 0 AND Board(y + 1, x - 1) = z AND Board(y + 2, x - 2) = 0 THEN
        IF Board(y + 3, x - 3) = z AND Board(y + 4, x - 4) = 0 THEN
          IF Board(y + 1, x) > 0 AND Board(y + 1 + 1, x - 1) > 0 AND Board(y + 2 + 1, x - 2) > 0 THEN
          IF Board(y + 3 + 1, x - 3) > 0 AND Board(y + 4 + 1, x - 4) > 0 THEN
            GoAt = x - 2
            GOTO CompTurnDone
          END IF
          END IF
        END IF
        END IF
      END IF
      IF x > 4 THEN
        IF Board(y, x) = 0 AND Board(y, x - 1) = z AND Board(y, x - 2) = 0 THEN
        IF Board(y, x - 3) = z AND Board(y, x - 4) = 0 THEN
          IF Board(y + 1, x) > 0 AND Board(y + 1, x - 1) > 0 AND Board(y + 1, x - 2) > 0 THEN
          IF Board(y + 1, x - 3) > 0 AND Board(y + 1, x - 4) > 0 THEN
            GoAt = x - 2
            GOTO CompTurnDone
          END IF
          END IF
        END IF
        END IF
      END IF
    NEXT x
  NEXT y








StepFour:  ''''' Disable your winning move next turn. '''''
  AIStep = 4
  IF Turn = 1 THEN z = 2
  IF Turn = 2 THEN z = 1
  FOR y = 1 TO 10
    FOR x = 1 TO 10
      '01100
      IF y > 4 AND x > 4 THEN
        IF Board(y, x) = 0 AND Board(y - 1, x - 1) = z AND Board(y - 2, x - 2) = z THEN
        IF Board(y - 3, x - 3) = 0 AND Board(y - 4, x - 4) = 0 THEN
          IF Board(y + 1, x) > 0 AND Board(y - 1 + 1, x - 1) > 0 AND Board(y - 2 + 1, x - 2) > 0 THEN
          IF Board(y - 3 + 1, x - 3) > 0 AND Board(y - 4 + 1, x - 4) > 0 THEN
            GoAt = x - 3
            GOTO CompTurnDone
          END IF
          END IF
        END IF
        END IF
      END IF
      IF y > 4 AND x < 7 THEN
        IF Board(y, x) = 0 AND Board(y - 1, x + 1) = z AND Board(y - 2, x + 2) = z THEN
        IF Board(y - 3, x + 3) = 0 AND Board(y - 4, x + 4) = 0 THEN
          IF Board(y + 1, x) > 0 AND Board(y - 1 + 1, x + 1) > 0 AND Board(y - 2 + 1, x + 2) > 0 THEN
          IF Board(y - 3 + 1, x + 3) > 0 AND Board(y - 4 + 1, x + 4) > 0 THEN
            GoAt = x + 3
            GOTO CompTurnDone
          END IF
          END IF
        END IF
        END IF
      END IF
      IF x < 7 THEN
        IF Board(y, x) = 0 AND Board(y, x + 1) = z AND Board(y, x + 2) = z THEN
        IF Board(y, x + 3) = 0 AND Board(y, x + 4) = 0 THEN
          IF Board(y + 1, x) > 0 AND Board(y + 1, x + 1) > 0 AND Board(y + 1, x + 2) > 0 THEN
          IF Board(y + 1, x + 3) > 0 AND Board(y + 1, x + 4) > 0 THEN
            GoAt = x + 3
            GOTO CompTurnDone
          END IF
          END IF
        END IF
        END IF
      END IF
      IF y < 7 AND x < 7 THEN
        IF Board(y, x) = 0 AND Board(y + 1, x + 1) = z AND Board(y + 2, x + 2) = z THEN
        IF Board(y + 3, x + 3) = 0 AND Board(y + 4, x + 4) = 0 THEN
          IF Board(y + 1, x) > 0 AND Board(y + 1 + 1, x + 1) > 0 AND Board(y + 2 + 1, x + 2) > 0 THEN
          IF Board(y + 3 + 1, x + 3) > 0 AND Board(y + 4 + 1, x + 4) > 0 THEN
            GoAt = x + 3
            GOTO CompTurnDone
          END IF
          END IF
        END IF
        END IF
      END IF
      IF y < 7 AND x > 4 THEN
        IF Board(y, x) = 0 AND Board(y + 1, x - 1) = z AND Board(y + 2, x - 2) = z THEN
        IF Board(y + 3, x - 3) = 0 AND Board(y + 4, x - 4) = 0 THEN
          IF Board(y + 1, x) > 0 AND Board(y + 1 + 1, x - 1) > 0 AND Board(y + 2 + 1, x - 2) > 0 THEN
          IF Board(y + 3 + 1, x - 3) > 0 AND Board(y + 4 + 1, x - 4) > 0 THEN
            GoAt = x - 3
            GOTO CompTurnDone
          END IF
          END IF
        END IF
        END IF
      END IF
      IF x > 4 THEN
        IF Board(y, x) = 0 AND Board(y, x - 1) = z AND Board(y, x - 2) = z THEN
        IF Board(y, x - 3) = 0 AND Board(y, x - 4) = 0 THEN
          IF Board(y + 1, x) > 0 AND Board(y + 1, x - 1) > 0 AND Board(y + 1, x - 2) > 0 THEN
          IF Board(y + 1, x - 3) > 0 AND Board(y + 1, x - 4) > 0 THEN
            GoAt = x - 3
            GOTO CompTurnDone
          END IF
          END IF
        END IF
        END IF
      END IF
     
      '01010
      IF y > 4 AND x > 4 THEN
        IF Board(y, x) = 0 AND Board(y - 1, x - 1) = z AND Board(y - 2, x - 2) = 0 THEN
        IF Board(y - 3, x - 3) = z AND Board(y - 4, x - 4) = 0 THEN
          IF Board(y + 1, x) > 0 AND Board(y - 1 + 1, x - 1) > 0 AND Board(y - 2 + 1, x - 2) > 0 THEN
          IF Board(y - 3 + 1, x - 3) > 0 AND Board(y - 4 + 1, x - 4) > 0 THEN
            GoAt = x - 2
            GOTO CompTurnDone
          END IF
          END IF
        END IF
        END IF
      END IF
      IF y > 4 AND x < 7 THEN
        IF Board(y, x) = 0 AND Board(y - 1, x + 1) = z AND Board(y - 2, x + 2) = 0 THEN
        IF Board(y - 3, x + 3) = z AND Board(y - 4, x + 4) = 0 THEN
          IF Board(y + 1, x) > 0 AND Board(y - 1 + 1, x + 1) > 0 AND Board(y - 2 + 1, x + 2) > 0 THEN
          IF Board(y - 3 + 1, x + 3) > 0 AND Board(y - 4 + 1, x + 4) > 0 THEN
            GoAt = x + 2
            GOTO CompTurnDone
          END IF
          END IF
        END IF
        END IF
      END IF
      IF x < 7 THEN
        IF Board(y, x) = 0 AND Board(y, x + 1) = z AND Board(y, x + 2) = 0 THEN
        IF Board(y, x + 3) = z AND Board(y, x + 4) = 0 THEN
          IF Board(y + 1, x) > 0 AND Board(y + 1, x + 1) > 0 AND Board(y + 1, x + 2) > 0 THEN
          IF Board(y + 1, x + 3) > 0 AND Board(y + 1, x + 4) > 0 THEN
            GoAt = x + 2
            GOTO CompTurnDone
          END IF
          END IF
        END IF
        END IF
      END IF
      IF y < 7 AND x < 7 THEN
        IF Board(y, x) = 0 AND Board(y + 1, x + 1) = z AND Board(y + 2, x + 2) = 0 THEN
        IF Board(y + 3, x + 3) = z AND Board(y + 4, x + 4) = 0 THEN
          IF Board(y + 1, x) > 0 AND Board(y + 1 + 1, x + 1) > 0 AND Board(y + 2 + 1, x + 2) > 0 THEN
          IF Board(y + 3 + 1, x + 3) > 0 AND Board(y + 4 + 1, x + 4) > 0 THEN
            GoAt = x + 2
            GOTO CompTurnDone
          END IF
          END IF
        END IF
        END IF
      END IF
      IF y < 7 AND x > 4 THEN
        IF Board(y, x) = 0 AND Board(y + 1, x - 1) = z AND Board(y + 2, x - 2) = 0 THEN
        IF Board(y + 3, x - 3) = z AND Board(y + 4, x - 4) = 0 THEN
          IF Board(y + 1, x) > 0 AND Board(y + 1 + 1, x - 1) > 0 AND Board(y + 2 + 1, x - 2) > 0 THEN
          IF Board(y + 3 + 1, x - 3) > 0 AND Board(y + 4 + 1, x - 4) > 0 THEN
            GoAt = x - 2
            GOTO CompTurnDone
          END IF
          END IF
        END IF
        END IF
      END IF
      IF x > 4 THEN
        IF Board(y, x) = 0 AND Board(y, x - 1) = z AND Board(y, x - 2) = 0 THEN
        IF Board(y, x - 3) = z AND Board(y, x - 4) = 0 THEN
          IF Board(y + 1, x) > 0 AND Board(y + 1, x - 1) > 0 AND Board(y + 1, x - 2) > 0 THEN
          IF Board(y + 1, x - 3) > 0 AND Board(y + 1, x - 4) > 0 THEN
            GoAt = x - 2
            GOTO CompTurnDone
          END IF
          END IF
        END IF
        END IF
      END IF
    NEXT x
  NEXT y








StepFive:  ''''' Allow a move to allow a winning move next turn. '''''
  AIStep = 5
  z = Turn
  FOR y = 1 TO 10
    FOR x = 1 TO 10
      '01000
      IF y > 4 AND x > 4 THEN
        IF Board(y, x) = 0 AND Board(y - 1, x - 1) = z AND Board(y - 2, x - 2) = 0 THEN
        IF Board(y - 3, x - 3) = 0 AND Board(y - 4, x - 4) = 0 THEN
          IF Board(y + 1, x) > 0 AND Board(y - 1 + 1, x - 1) > 0 AND Board(y - 2 + 1, x - 2) > 0 THEN
          IF Board(y - 3 + 1, x - 3) > 0 AND Board(y - 4 + 1, x - 4) > 0 THEN
            GoAt = x - 3
            GOTO CompTurnDone
          END IF
          END IF
        END IF
        END IF
      END IF
      IF y > 4 AND x < 7 THEN
        IF Board(y, x) = 0 AND Board(y - 1, x + 1) = z AND Board(y - 2, x + 2) = 0 THEN
        IF Board(y - 3, x + 3) = 0 AND Board(y - 4, x + 4) = 0 THEN
          IF Board(y + 1, x) > 0 AND Board(y - 1 + 1, x + 1) > 0 AND Board(y - 2 + 1, x + 2) > 0 THEN
          IF Board(y - 3 + 1, x + 3) > 0 AND Board(y - 4 + 1, x + 4) > 0 THEN
            GoAt = x + 3
            GOTO CompTurnDone
          END IF
          END IF
        END IF
        END IF
      END IF
      IF x < 7 THEN
        IF Board(y, x) = 0 AND Board(y, x + 1) = z AND Board(y, x + 2) = 0 THEN
        IF Board(y, x + 3) = 0 AND Board(y, x + 4) = 0 THEN
          IF Board(y + 1, x) > 0 AND Board(y + 1, x + 1) > 0 AND Board(y + 1, x + 2) > 0 THEN
          IF Board(y + 1, x + 3) > 0 AND Board(y + 1, x + 4) > 0 THEN
            GoAt = x + 3
            GOTO CompTurnDone
          END IF
          END IF
        END IF
        END IF
      END IF
      IF y < 7 AND x < 7 THEN
        IF Board(y, x) = 0 AND Board(y + 1, x + 1) = z AND Board(y + 2, x + 2) = 0 THEN
        IF Board(y + 3, x + 3) = 0 AND Board(y + 4, x + 4) = 0 THEN
          IF Board(y + 1, x) > 0 AND Board(y + 1 + 1, x + 1) > 0 AND Board(y + 2 + 1, x + 2) > 0 THEN
          IF Board(y + 3 + 1, x + 3) > 0 AND Board(y + 4 + 1, x + 4) > 0 THEN
            GoAt = x + 3
            GOTO CompTurnDone
          END IF
          END IF
        END IF
        END IF
      END IF
      IF y < 7 AND x > 4 THEN
        IF Board(y, x) = 0 AND Board(y + 1, x - 1) = z AND Board(y + 2, x - 2) = 0 THEN
        IF Board(y + 3, x - 3) = 0 AND Board(y + 4, x - 4) = 0 THEN
          IF Board(y + 1, x) > 0 AND Board(y + 1 + 1, x - 1) > 0 AND Board(y + 2 + 1, x - 2) > 0 THEN
          IF Board(y + 3 + 1, x - 3) > 0 AND Board(y + 4 + 1, x - 4) > 0 THEN
            GoAt = x - 3
            GOTO CompTurnDone
          END IF
          END IF
        END IF
        END IF
      END IF
      IF x > 4 THEN
        IF Board(y, x) = 0 AND Board(y, x - 1) = z AND Board(y, x - 2) = 0 THEN
        IF Board(y, x - 3) = 0 AND Board(y, x - 4) = 0 THEN
          IF Board(y + 1, x) > 0 AND Board(y + 1, x - 1) > 0 AND Board(y + 1, x - 2) > 0 THEN
          IF Board(y + 1, x - 3) > 0 AND Board(y + 1, x - 4) > 0 THEN
            GoAt = x - 3
            GOTO CompTurnDone
          END IF
          END IF
        END IF
        END IF
      END IF
    NEXT x
  NEXT y
END IF




PlaceRandom:
  counter = counter + 1
  AIStep = 0
  GoAt = INT(RND * 10 + 1)
  WHILE Board(1, GoAt) <> 0
    GoAt = INT(RND * 10 + 1)
  WEND
  IF counter = 5 THEN GOTO TooManyRandom
  GOTO CompTurnDone




 
 
 

CompTurnDone:
  IF AIStep > 2 OR AIStep = 0 THEN CompTest
  IF GoAt = -1 THEN
    SELECT CASE AIStep
      CASE 0:  GOTO PlaceRandom
      CASE 3:  GOTO StepFour
      CASE 4:  GOTO PlaceRandom
    END SELECT
  END IF
TooManyRandom:
  Place
END SUB

SUB Convert
  SELECT CASE Move$
    CASE "0":  GoAt = 10
    CASE "1":  GoAt = 1
    CASE "2":  GoAt = 2
    CASE "3":  GoAt = 3
    CASE "4":  GoAt = 4
    CASE "5":  GoAt = 5
    CASE "6":  GoAt = 6
    CASE "7":  GoAt = 7
    CASE "8":  GoAt = 8
    CASE "9":  GoAt = 9
    CASE "Q":  Quit
    CASE "q":  Quit
    CASE ELSE: GoAt = 0
  END SELECT
END SUB

FUNCTION GetSpeed&
'-------------------------------------------------'
'- This function returns the number of times the -'
'-  computer can increment a long int in a FOR   -'
'-  loop per second.                             -'
'-------------------------------------------------'
  Start! = TIMER
  FOR i& = 1 TO 1500
    FOR i2& = 1 TO 1500
    NEXT i2&
  NEXT i&
  EndTime! = TIMER
  TimeTaken! = (EndTime! - Start!)

  GetSpeed& = ((1500& * 1500&) / TimeTaken!)
END FUNCTION

SUB Main
'''''''''''''''''''''''''''''''''''''''''''''''''
'  Set the screen.                              '
'''''''''''''''''''''''''''''''''''''''''''''''''
  SCREEN 12
  COLOR 15
  LINE (0, 0)-(640, 480), 1, BF
  LOCATE 26, 13: PRINT "1    2    3    4    5    6    7    8    9    0"
'''''''''''''''''''''''''''''''''''''''''''''''''
'  Draw the Game Board                          '
'''''''''''''''''''''''''''''''''''''''''''''''''
  LINE (0 + offs, 0)-(400 + offs, 400), 14, BF

  FOR y = 0 TO 360 STEP 40
    FOR x = 0 TO 360 STEP 40
      LINE (x + offs, y)-(x + 40 + offs, y + 40), 0, B
    NEXT x
  NEXT y

  LINE (0 + offs, 0)-(2 + offs, 440), 4, BF
  LINE (398 + offs, 0)-(400 + offs, 440), 4, BF

  FOR y = 0 TO 9
    FOR x = 0 TO 9
      FOR i = 1 TO 18
        CIRCLE (((x * 40) + 20 + offs), ((y * 40) + 20)), i, 1
      NEXT i
    NEXT x
  NEXT y


  LOCATE 30, 1: PRINT "Press 'q' to quit.";
  LOCATE 1, 1

PlayerOneTurn:
  Move$ = ""
  LOCATE 27, 13: PRINT "Player 1 Red  "
  Turn = 1
  IF Player(1) = 2 THEN
    CompTurn
    IF Win = 1 THEN
      EXIT SUB
    END IF
  END IF
  IF Player(1) = 1 THEN
    LOCATE 28, 13: PRINT "                                              "
    LOCATE 28, 13: PRINT "Place piece in which column? "
    WHILE Move$ = "": Move$ = INKEY$: WEND
    Convert
    Move$ = ""
    IF GoAt = 0 THEN
      LOCATE 28, 13:  PRINT "                                           "
      LOCATE 28, 13:  PRINT "Invalid Choice, Choose 0 - 9."
      SLEEP 1
      LOCATE 28, 13:  PRINT "                                           "
      GOTO PlayerOneTurn
    END IF
    IF Board(1, GoAt) = 1 OR Board(1, GoAt) = 2 THEN
      LOCATE 28, 13:  PRINT "                                           "
      LOCATE 28, 13:  PRINT "Invalid Choice, Column is full."
      SLEEP 1
      LOCATE 28, 13:  PRINT "                                           "
      GOTO PlayerOneTurn
    END IF
    Place
    IF Win = 1 THEN
      EXIT SUB
    END IF
  END IF
  GOTO PlayerTwoTurn


PlayerTwoTurn:
  Move$ = ""
  LOCATE 27, 13: PRINT "Player 2 Black"
  Turn = 2
  IF Player(2) = 2 THEN
    IF Debugging = 1 THEN GOTO PlayComp
    CompTurn
    IF Win = 1 THEN
      EXIT SUB
    END IF
  END IF
  IF Player(2) = 1 THEN
PlayComp:
    LOCATE 28, 13: PRINT "                                              "
    LOCATE 28, 13: PRINT "Place piece in which column? "
    WHILE Move$ = "": Move$ = INKEY$: WEND
    IF Debugging = 1 THEN
      IF Move$ = "c" THEN
        CompTurn
        GOTO PlayerOneTurn
      END IF
    END IF
    Convert
    Move$ = ""
    IF GoAt = 0 THEN
      LOCATE 28, 13:  PRINT "                                           "
      LOCATE 28, 13:  PRINT "Invalid Choice, Choose 0 - 9."
      SLEEP 1
      LOCATE 28, 13:  PRINT "                                           "
      GOTO PlayerTwoTurn
    END IF
    IF Board(1, GoAt) = 1 OR Board(1, GoAt) = 2 THEN
      LOCATE 28, 13:  PRINT "                                           "
      LOCATE 28, 13:  PRINT "Invalid Choice, Column is full."
      SLEEP 1
      LOCATE 28, 13:  PRINT "                                           "
      GOTO PlayerTwoTurn
    END IF
    Place
    IF Win = 1 THEN
      EXIT SUB
    END IF
  END IF
  GOTO PlayerOneTurn

END SUB

SUB Place
  IF Turn = 1 THEN c = 4
  IF Turn = 2 THEN c = 0
  FOR y = 0 TO 9
    FOR i = 1 TO 18
      CIRCLE ((((GoAt - 1) * 40) + 20 + offs), ((y * 40) + 20)), i, c
    NEXT i
    IF Board(y + 1 + 1, GoAt) = 1 OR Board(y + 1 + 1, GoAt) = 2 OR y = 9 THEN
      GOTO DonePlacing
    END IF
    Suspend 75, CompSpeed&
    FOR i = 1 TO 18
      CIRCLE ((((GoAt - 1) * 40) + 20 + offs), ((y * 40) + 20)), i, 1
    NEXT i
  NEXT y

DonePlacing:
Board(y + 1, GoAt) = Turn
END SUB

SUB Quit
  IF Debugging > 0 THEN
    CHAIN "C:\WINDOWS\Profiles\Colin\Desktop\Colin\Applic~1\Progra~1\DEBUG.BAS"
  END IF
  CLS
  PRINT "BYE!"
  SYSTEM
END SUB

SUB Suspend (delay!, speed&)
'-------------------------------------------------'
'- This function suspends the process for delay! -'
'-  thousanths of a second, with speed& being    -'
'-  how many times the computer can increment a  -'
'-  long int in a FOR loop per second.           -'
'-------------------------------------------------'
  IF delay! = 0 THEN
    WHILE INKEY$ = "": WEND
    EXIT SUB
  END IF

  FOR i& = 1 TO (speed& * (delay! / 1000))
  NEXT i&
END SUB

FUNCTION Win
  FOR i = 1 TO 2
    FOR y = 1 TO 10
      FOR x = 1 TO 10
        IF x > 3 AND y > 3 THEN
          IF Board(y, x) = i AND Board(y - 1, x - 1) = i THEN
          IF Board(y - 2, x - 2) = i AND Board(y - 3, x - 3) = i THEN
            GOTO APlayerWon
          END IF
          END IF
        END IF
        IF y > 3 THEN
          IF Board(y, x) = i AND Board(y - 1, x) = i THEN
          IF Board(y - 2, x) = i AND Board(y - 3, x) = i THEN
            GOTO APlayerWon
          END IF
          END IF
        END IF
        IF x < 8 AND y > 3 THEN
          IF Board(y, x) = i AND Board(y - 1, x + 1) = i THEN
          IF Board(y - 2, x + 2) = i AND Board(y - 3, x + 3) = i THEN
            GOTO APlayerWon
          END IF
          END IF
        END IF
        IF x < 8 THEN
          IF Board(y, x) = i AND Board(y, x + 1) = i THEN
          IF Board(y, x + 2) = i AND Board(y, x + 3) = i THEN
            GOTO APlayerWon
          END IF
          END IF
        END IF
        IF x < 8 AND y < 8 THEN
          IF Board(y, x) = i AND Board(y + 1, x + 1) = i THEN
          IF Board(y + 2, x + 2) = i AND Board(y + 3, x + 3) = i THEN
            GOTO APlayerWon
          END IF
          END IF
        END IF
        IF y < 8 THEN
          IF Board(y, x) = i AND Board(y + 1, x) = i THEN
          IF Board(y + 2, x) = i AND Board(y + 3, x) = i THEN
            GOTO APlayerWon
          END IF
          END IF
        END IF
        IF x > 3 AND y < 8 THEN
          IF Board(y, x) = i AND Board(y + 1, x - 1) = i THEN
          IF Board(y + 2, x - 2) = i AND Board(y + 3, x - 3) = i THEN
            GOTO APlayerWon
          END IF
          END IF
        END IF
        IF x > 3 THEN
          IF Board(y, x) = i AND Board(y, x - 1) = i THEN
          IF Board(y, x - 2) = i AND Board(y, x - 3) = i THEN
            GOTO APlayerWon
          END IF
          END IF
        END IF
      NEXT x
    NEXT y
  NEXT i
  FOR i = 1 TO 10
    IF Board(1, i) = 0 THEN
      Win = -1
      EXIT FUNCTION
    END IF
  NEXT i


TiedGame:
  LOCATE 27, 13: PRINT "                                   "
  LOCATE 28, 13: PRINT "                                   "
  LOCATE 27, 13: PRINT "The Game Is A Draw!                "
  WHILE INKEY$ = "": WEND
  FOR i = 1 TO 3
    FOR i2 = 1 TO 360
      CIRCLE (320, 240), i2, 15
    NEXT i2
    FOR i2 = 1 TO 360
      CIRCLE (320, 240), i2, 1
    NEXT i2
  NEXT i
  CLS
  Win = 1
  EXIT FUNCTION




APlayerWon:
  LOCATE 27, 13: PRINT "                                   "
  LOCATE 28, 13: PRINT "                                   "
  LOCATE 27, 13: PRINT "Player"; i; "Has Won the Game!     "
  WHILE INKEY$ = "": WEND
  IF i = 1 THEN c = 4
  IF i = 2 THEN c = 0
  FOR i = 1 TO 3
    FOR i2 = 1 TO 360
      CIRCLE (320, 240), i2, c
    NEXT i2
    FOR i2 = 1 TO 360
      CIRCLE (320, 240), i2, 1
    NEXT i2
  NEXT i
  CLS
  Win = 1
  EXIT FUNCTION

END FUNCTION

