/* extutil.h -- Header for extutil.c  */

#ifndef EXTUTIL_H
#define EXTUTIL_H

#include "defs.h"

#include <stddef.h>

#ifdef NEED_MVWHLINE
# include <curses.h>
#endif /* NEED_MVWLINE */

#ifdef NEED_STRNLEN
size_t strnlen (const char *string, size_t count);
#endif /* need strnlen func */

void fatal (const char *errstr);
int getrand (int min, int max);
int lookup (char *item, char *list, char term, int *pos);
void shandler (int sig);
void xfree (void *ptr);
void *xmalloc (size_t size);
void *xrealloc (void *ptr, size_t size);

#ifdef NEED_MVWHLINE
int mvwhline (WINDOW * win, int row, int col, chtype ch, int n);
#endif /* NEED_MVWHLINE */

#endif /* EXTUTIL_H */
