/* main.c --- The main file of this project.
  By Michael Olson, in C.
  Original version 0.0.2 by Sverre Nilsen, in Python.
*/

#include "defs.h"

#include <curses.h>
#include <ctype.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "extutil.h"
#include "wordlist.h"
#include "graphics.h"
#include "game.h"

/* GLOBALS */

/* Length of word returned from 'choose_word' */
unsigned int word_length;

/* Lives remaining */
int lives;

/* Current score */
int score;

/* LOCALS */

char *word, *guessed_word, guess = 1;
char letter_list[27], end_it = 0;
int difficulty = 0;
WINDOW *ascii_win = 0;
WINDOW *hang_win = 0;

/* Start of Python junk that seems (somewhat) relevant
   to the project still. Namely: unimplemented features. */

/* main
from sys import argv, exit
// This grabs the startup arguments into a list.

	del argv[0]
	// Entry 0 in this list is the script name, we don't it.
if len(argv) > 0:
// This runs only if the user adds some arguments.
for item in argv:
// The following code validates the arguments.
		if item == "--python":
			from ascii import print_python
			print_asciiart = print_python

			good_end_string = "You saved the python!"
			bad_end_string = "The python was hanged."
		character = "python"
		// This will show up on game finish.

		elif item == "--tux":
			from ascii import print_tux
			print_asciiart = print_tux

			good_end_string = "You saved Tux!"
			bad_end_string = "Tux was hanged."

		elif item == "--man":
		// This is default if the user inputs a bad argument.
			from ascii import print_man
			print_asciiart = print_man 

			good_end_string = "You saved the man!"
			bad_end_string = "The man was hanged."

		elif item == "-v":
			print "Hangman version 0.0.2"
			print "http://www.gravityzone.com/~cadger/projects/hangman/"
			print "By Sverre Nilsen, <cadger@gravityzone.com>."
			print

			exit()

		  else:
		  // Runs if an illegal argument is used.
			print item, "is not a valid argument."
			print
			print "Valid arguments are:"
			print "-v               Show version number"
			print "--man            Hang a man (default)"
			print "--python         Hang a python"
			print "--tux            Hang Tux"

			exit()

		    else:
		    // Runs if there are no arguments.
	from ascii import print_man
	print_asciiart = print_man

	good_end_string = "You saved the man!"
	bad_end_string = "The man was hanged."

*/// End of python-based main

#ifdef __TEST__

int
main ()
{
  /* Note: command line args, hints, and other things to hang
     are NOT supported (yet). Maybe we could hang Gate$...
     or the Window$ logo... */

  /* Specialized 'main' to test some values */
  int i, tmp;
  char *word, buffer[20];
  puts ("Testing 'choose_word'...");
  for (i = 1; i <= 10; i++)
    {
      tmp = getrand (1, 3);
      printf ("l:%2d ", tmp);
      word = choose_word (tmp);
      printf ("s:<%s>\n", word);
    }
  return 0;
}

#else /* not TEST build */

void
init_hangit (void)
{
  /* Initialize the program.  */
  int i;

  /* Initialize globals */
  word_length = 0;
  lives = LIVES_AVAIL;
  score = 0;
  difficulty = 3;
  
  signal (SIGINT, shandler);    /* trap signals */

  for (i = 0; i < 26; i++)
    letter_list[i] = 'A' + i;	/* generate list of letters */
  letter_list[26] = 0;
}

void
make_screens ()
{
  /* Make the screen windows available.  */
  int maxlines, maxcols;
  getmaxyx (stdscr, maxlines, maxcols);

  /* where the gallows are displayed */
  hang_win = subwin (stdscr, 16, 23, 2, maxcols - 25);

  /* where we hang the thing */
  ascii_win = subwin (stdscr, 13, 17, 5, maxcols - 27);
  
  if (ascii_win == 0)
    fatal ("Could not create ascii art window");
}

void
handle_word (void)
{
  /* Handle everything related to choosing the word to use.  */
  int i, maxlines, maxcols;

  box (stdscr, 0, 0);           /* draw a box around the window */
  wnoutrefresh (stdscr);

  word = choose_word (difficulty); /* get a word from the list */

  getmaxyx (stdscr, maxlines, maxcols);
  word_length = strnlen (word, maxcols);

  if (word_length <= 0)
    fatal ("Word list is corrupted");

  if (word_length > maxcols - 4)
    fatal ("Word selected is too large for screen");

  guessed_word = (char *) xmalloc (word_length + 1);
				/* allocate mem for word */

  for (i = 0; i < word_length; i++)
    {                           /* fill guessed_word with '_' */
      if (isalpha (word[i]))
	guessed_word[i] = '_';
      else        /* print the nonalpha chars to screen immediately */
	guessed_word[i] = word[i];
    }

  guessed_word[word_length] = 0;        /* null-terminate */
}

void
draw_graphics (void)
{
  /* Prepare the initial graphical content of the program.  */
  int maxlines, maxcols;

  print_underscores (guessed_word); /* lay out the screen */
  print_score ();
  getmaxyx (stdscr, maxlines, maxcols);
  mvwhline (stdscr, maxlines - 3, 1, ACS_HLINE, maxcols - 2);
				/* horiz line at bottom */

  print_art (ascii_win, lives); /* draw first stage */
  wnoutrefresh (hang_win);
  wnoutrefresh (ascii_win);

  print_letter_list (letter_list);
				/* print letter list to screen */
}

#ifdef ALLOW_RESIZING
void
game_resize_screen ()
{
  /* Handle resize-screen signal when playing game.  */
  int maxlines, maxcols;

  global_resize_screen ();
  getmaxyx (stdscr, maxlines, maxcols);

  if (mvwin (ascii_win, 5, maxcols - 28) != OK)
    fatal ("Could not move ascii window");

  draw_graphics ();
  mvaddstr (maxlines - 4, 2, "Your guess: ");
  refresh ();
}
#endif /* resizable */

void
play_game (void)
{
  /* Main loop: will till the user guesses the word or
     runs out of lives. */
  int maxlines, maxcols;
  getmaxyx (stdscr, maxlines, maxcols);
  
  mvaddstr (maxlines - 4, 2, "Your guess: ");
  refresh ();

#ifdef NEED_RESIZING
  signal (SIGWINCH, game_resize_screen); /* trap win-resize */
#endif /* resizable */

  guess = getch ();

#ifdef NEED_RESIZING
  signal (SIGWINCH, SIG_IGN);	/* old resize settings */
#endif /* resizable */

  process_guess (ascii_win, guess, letter_list, guessed_word, word);

  if (guess != 0)
    {               /* don't update screen if an error occured prev */
      print_score ();		/* display current score */
      print_letter_list (letter_list);
				/* print letter list to screen */
      print_underscores (guessed_word); /* output unfinished word */
    }
}

void
reinit_hangit (void)
{
  /* Clean up everything for the following game.  */
  int i;
  
  word_length = 0;
  lives = 7;
  score = 0;

  xfree (guessed_word);

  for (i = 0; i < 26; i++)
    letter_list[i] = 'A' + i;	/* generate list of letters */

  letter_list[26] = 0;

  wclear (ascii_win);
  clear ();
  wnoutrefresh (ascii_win);
  wnoutrefresh (stdscr);
}

void
clean_up (void)
{
  /* Free up any windows, variables, ...  */
  if (ascii_win)
    delwin (ascii_win);
}

void
process_params (int argc, char **argv)
{
  /* Will eventually be able to handle commandline parameters.  */
}

int
main (int argc, char **argv)
{
  init_hangit ();
  init_drawings ();
  init_curses ();
  make_screens ();
  process_params (argc, argv);
  
  do
    {
      get_user_params ();
      handle_word ();
      draw_graphics ();

      /* While word isn't guessed and lives aren't depleted... */
      while (strcmp (word, guessed_word) && lives > 0)
	play_game ();

      end_it = end_game (word); /* end of game routine */
      if (end_it != 27)
	reinit_hangit ();
    } while (end_it != 27);

  clean_up ();
  restore_terminal ();          /* close down windows, etc. */

  return EXIT_SUCCESS;
}
#endif /* (not) TEST build */
