'       ...in the Nocturne
'       Created by: DarkDread (darkdread@rpgdx.net)
'
'       A game for the RPGDX Spring 2003 MiniRPG competition.
'
DEFINT A-Z
'$DYNAMIC
'$INCLUDE: 'dark.bi'

DECLARE SUB ShowEnding ()
DECLARE SUB WaitForEnter ()
DECLARE FUNCTION MultiKey% (T%)
DECLARE SUB CenterText (TextString$)
DECLARE SUB LoadSoundMusic ()
DECLARE SUB UnloadSoundMusic ()
DECLARE SUB RefreshBattle ()
DECLARE SUB ShowMagic ()
DECLARE SUB ShakeEnemy ()
DECLARE SUB ScriptCheck ()
DECLARE SUB Fade (Direction%, PaletteArray&())
DECLARE SUB SaveGame ()
DECLARE SUB LoadGame ()
DECLARE SUB DrawBattleMenu (MenuType%)
DECLARE SUB UpdateStats ()
DECLARE SUB ClearStatBox ()
DECLARE SUB SetEnemyBack (SpriteX%, SpriteY%)
DECLARE SUB ShakeScreen ()
DECLARE SUB ClearBattleDialog ()
DECLARE SUB PlayerAct ()
DECLARE SUB EnemyAct ()
DECLARE SUB Battle (BattleType%)
DECLARE SUB DarkLoadEnemies (EnemyData$)
DECLARE SUB DrawBattle ()
DECLARE SUB DescribeItem (SlotSelected%, MenuType%)
DECLARE SUB SelectMenuItem (MenuType%)
DECLARE SUB GameMenu ()
DECLARE SUB SetTile (SpriteX%, SpriteY%, SpriteNum%)
DECLARE SUB DrawGameMenu (MenuType%)
DECLARE SUB LoadArea (FromArea$, ToArea$, Pointer%)
DECLARE SUB SpriteEngine (SpriteName$, SpriteX%, SpriteY%, SpriteSize%, SpriteNum%)
DECLARE SUB PutText (Valu%, Value&, Sentence$, TextX%, TextY%, Digits%, MaxText%, TextColour%, TextType$)
DECLARE SUB LoadFont ()
DECLARE SUB CheckForPlayer ()
DECLARE SUB DaRKShow ()
DECLARE SUB ShowTitleScreen ()
DECLARE SUB LoadPal ()
DECLARE SUB Main ()
 
CLEAR , , 4096
RANDOMIZE TIMER

CONST True = -1, False = 0
DIM SHARED TileSet%(13000), Player%(1300), Buffer&(15999), Pal&(0 TO 255), ChrSet%(33 TO 122, 1 TO 8, 1 TO 11)
DIM SHARED ScreenMap%(-12 TO 23, -7 TO 16), TileMap%(-20 TO 159, -20 TO 159), DialogBox%(1170), Sprite%(4610)
DIM SHARED PlayerX%, PlayerY%, ScreenX%, ScreenY%, PlayerDir%, BattleProtect%, ScriptSafe%
DIM SHARED TileSize%, MaxXTiles%, MaxYTiles%, TileOffset%, XTiles%, YTiles%, MiddleX%
DIM SHARED CharSize%, PlayerNumber%, PlayerThere%, ExitGame%, ExitMenu%, MovedPointer%
DIM SHARED DrawMenu%, SpriteBack%(130), EnemyBack%(8192), Medallion%(1 TO 4)

DIM SHARED PlayerHP%, PlayerMaxHP%, PlayerMP%, PlayerMaxMP%, PlayerOffset%
DIM SHARED PlayerST%, PlayerDF%, PlayerAG%, PlayerMS%, PlayerMD%
DIM SHARED PlayerName$, Magic$(1 TO 10), Item$(1 TO 10), CurrentMap$
DIM SHARED MPNeed%(1 TO 10), PlayerWon%, EnemyWon%, PlayerRan%, AttackUsed$, StoryLine%

DIM SHARED NextHP%, NextMP%, NextST%, NextDF%, NextAG%, NextMS%, NextMD%
DIM SHARED ExpHP%, ExpMP%, ExpST%, ExpDF%, ExpAG%, ExpMS%, ExpMD%
DIM SHARED PointerX%, PointerY%, SlotSelected%, PlayerAction$, PlayerDamage%, EnemyDamage%, EnemyAction%

DIM SHARED PointMap$(1 TO 10), PointMapType%(1 TO 10), NumLoadPoints%, PointPlayerDir%(1 TO 10)
DIM SHARED PointX%(1 TO 10), PointY%(1 TO 10), ToLoadX%(1 TO 10), ToLoadY%(1 TO 10), FoundPoint%

DIM SHARED EnemyName$(1 TO 3), EnemyItem$(1 TO 3), EnemyMagic$(1 TO 3), EnemyMPNeed%(1 TO 3), EnemySprite$, NumEnemies%
DIM SHARED EnemyHP%(1 TO 3), EnemyMaxHP%(1 TO 3), EnemyMP%(1 TO 3), EnemyMaxMP%(1 TO 3)
DIM SHARED EnemyST%(1 TO 3), EnemyDF%(1 TO 3), EnemyAG%(1 TO 3), EnemyMS%(1 TO 3), EnemyMD%(1 TO 3)

DIM SHARED EName$, EMagic$, EItem$, EMPNeed%, BossBattle%, BeatBoss%
DIM SHARED EHP%, EMaxHP%, EMP%, EMaxMP%, EnemyX%, EnemyY%
DIM SHARED EST%, EDF%, EAG%, EMS%, EMD%, EnemySize%

DIM SHARED ChestArea$(1 TO 41), ChestX%(1 TO 41), ChestY%(1 TO 41), ChestItem$(1 TO 41), ChestFlag%(1 TO 41)

TileSize% = 16: CharSize% = 130
Z = MultiKey(-1)
SCREEN 13
DaRKInit
ShowTitleScreen
Fade 1, Pal&()
CLS
Fade 0, Pal&()
Z = MultiKey(-2)

REM $STATIC
SUB Battle (BattleType%)

    ExpHP% = 0: ExpMP% = 0: ExpST% = 0: ExpDF% = 0: ExpAG% = 0: ExpMS% = 0: ExpMD% = 0
    PlayerWon% = False: EnemyWon% = False: PlayerRan% = False: AttackUsed$ = ""
    IF BattleType% = 1 THEN
            DarkLoadEnemies "data\vlad.dat"
            EType% = 1: EnemySize% = 96 * 96 / 2 + 2: EMPNeed% = EnemyMPNeed%(EType%)
            EName$ = EnemyName$(EType%): EMagic$ = EnemyMagic$(EType%): EItem$ = EnemyItem$(EType%)
            EHP% = EnemyHP%(EType%): EMaxHP% = EnemyMaxHP%(EType%): EMP% = EnemyMP%(EType%): EMaxMP% = EnemyMaxMP%(EType%)
            EST% = EnemyST%(EType%): EDF% = EnemyDF%(EType%): EAG% = EnemyAG%(EType%): EMS% = EnemyMS%(EType%): EMD% = EnemyMD%(EType%)
            BossBattle% = True
            EnemyX% = 111: EnemyY% = 1
        ELSE
            EType% = INT(RND * NumEnemies%) + 1: EnemySize% = 64 * 64 / 2 + 2: EMPNeed% = EnemyMPNeed%(EType%)
            EName$ = EnemyName$(EType%): EMagic$ = EnemyMagic$(EType%): EItem$ = EnemyItem$(EType%)
            EHP% = EnemyHP%(EType%): EMaxHP% = EnemyMaxHP%(EType%): EMP% = EnemyMP%(EType%): EMaxMP% = EnemyMaxMP%(EType%)
            EST% = EnemyST%(EType%): EDF% = EnemyDF%(EType%): EAG% = EnemyAG%(EType%): EMS% = EnemyMS%(EType%): EMD% = EnemyMD%(EType%)
            EnemyX% = 127: EnemyY% = 30
    END IF
    Fade 1, Pal&()
    DrawBattle
    Fade 0, Pal&()

    PutText 0, 0, (EName$), 5 * 16 + 8, 9 * 16 + 1, 0, 319, 31, "text"
    PutText 0, 0, ("appears from the"), 5 * 16 + 8, 9 * 16 + 9, 0, 319, 31, "text"
    PutText 0, 0, ("shadows."), 5 * 16 + 8, 10 * 16 + 3, 0, 319, 31, "text"
    PointerX% = 0 * 16: PointerY% = 145
    DaRKShow
    GET (PointerX%, PointerY%)-(PointerX% + 15, PointerY% + 10), SpriteBack%
    SpriteEngine "pointer.set", PointerX%, PointerY%, 130, 0
    DaRKShow

    DO
        IF MultiKey(72) THEN
            gssprite PointerX%, PointerY%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(SpriteBack%(0)), VARPTR(SpriteBack%(0))
            IF PointerY% <> 145 THEN
                GET (PointerX%, PointerY% - 10)-(PointerX% + 15, PointerY% - 1), SpriteBack%
                PointerY% = PointerY% - 10
            END IF
            SpriteEngine "pointer.set", PointerX%, PointerY%, 130, 0
            DaRKShow
            WHILE MultiKey(72): WEND
        ELSEIF MultiKey(80) THEN
            gssprite PointerX%, PointerY%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(SpriteBack%(0)), VARPTR(SpriteBack%(0))
            IF PointerY% <> 185 THEN
                GET (PointerX%, PointerY% + 10)-(PointerX% + 15, PointerY% + 19), SpriteBack%
                PointerY% = PointerY% + 10
            END IF
            SpriteEngine "pointer.set", PointerX%, PointerY%, 130, 0
            DaRKShow
            WHILE MultiKey(80): WEND
        ELSEIF MultiKey(28) THEN
            WHILE MultiKey(28): WEND
            gssprite PointerX%, PointerY%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(SpriteBack%(0)), VARPTR(SpriteBack%(0))
            PlayerAction$ = "": PlayerDamage% = 0: EnemyDamage% = 0
            IF PointerY% = 145 THEN
                    PlayerAction$ = "attack": ExpST% = ExpST% + 2
                    PlayerDamage% = PlayerST% * 3 + (INT(RND * 5) + 1) - EDF% * 3 + (INT(RND * 5) + 1)
                ELSEIF PointerY% = 155 THEN
                    PlayerAction$ = "defend": ExpMD% = ExpMD% + 2: ExpDF% = ExpDF% + 2: ExpHP% = ExpHP% + 4
                    PlayerDefending% = True
                ELSEIF PointerY% = 165 THEN
                    SelectMenuItem 3
                    DrawBattle
                    IF AttackUsed$ <> "" THEN
                            PlayerAction$ = "item": ExpHP% = ExpHP% + 4
                        ELSE
                            PointerX% = 0 * 16: PointerY% = 145
                            DaRKShow
                            GET (PointerX%, PointerY%)-(PointerX% + 15, PointerY% + 10), SpriteBack%
                            SpriteEngine "pointer.set", PointerX%, PointerY%, 130, 0
                            DaRKShow
                    END IF
                ELSEIF PointerY% = 175 THEN
                    SelectMenuItem 4
                    DrawBattle
                    IF AttackUsed$ <> "" THEN
                            PlayerAction$ = "magic": ExpMS% = ExpMS% + 4: ExpMP% = ExpMP% + 4
                        ELSE
                            PointerX% = 0 * 16: PointerY% = 145
                            DaRKShow
                            GET (PointerX%, PointerY%)-(PointerX% + 15, PointerY% + 10), SpriteBack%
                            SpriteEngine "pointer.set", PointerX%, PointerY%, 130, 0
                            DaRKShow
                    END IF
                ELSEIF PointerY% = 185 THEN
                    PlayerAction$ = "escape": ExpAG% = ExpAG% + 4
                    ExitBattle% = True
            END IF
        END IF
   
        IF PlayerAction$ <> "" THEN
            PlayerNum% = INT(RND * PlayerAG%) + 1: ENum% = INT(RND * EAG%) + 1
            IF PlayerNum% >= ENum% THEN
                    ExpAG% = ExpAG% + 2
                    PlayerAct
                    IF PlayerWon% = False AND PlayerRan% = False THEN EnemyAct
                ELSE
                    EnemyAct
                    IF EnemyWon% = False THEN PlayerAct
            END IF
            PlayerAction$ = "": EnemyAction% = -1: AttackUsed$ = "": ClearBattleDialog
            IF PlayerWon% OR EnemyWon% OR PlayerRan% THEN
                    ExitBattle% = True
                    IF PlayerWon% THEN
                            DrawBattle
                            IF BossBattle% THEN BeatBoss% = True
                            NextHP% = NextHP% - ExpHP%
                            NextMP% = NextMP% - ExpMP%
                            NextST% = NextST% - ExpST%
                            NextDF% = NextDF% - ExpDF%
                            NextAG% = NextAG% - ExpAG%
                            NextMS% = NextMS% - ExpMS%
                            NextMD% = NextMD% - ExpMD%
                            ClearBattleDialog
                            PutText 0, 0, ("Valour defeated "), 5 * 16 + 8, 9 * 16 + 1, 0, 319, 31, "text"
                            PutText 0, 0, (EName$ + "!"), 5 * 16 + 8, 9 * 16 + 9, 0, 319, 31, "text"
                            DaRKShow
                            WaitForEnter
                            IF NextHP% < 1 AND PlayerMaxHP% < 999 THEN
                                HPUp% = INT(PlayerMaxHP% / 6)
                                PlayerMaxHP% = PlayerMaxHP% + HPUp%: PlayerHP% = PlayerHP% + HPUp%: NextHP% = 100
                                IF PlayerMaxHP% > 999 THEN
                                    PlayerMaxHP% = 999: PlayerHP% = 999: NextHP% = 0
                                END IF
                                ClearBattleDialog
                                PutText 0, 0, ("HP goes up!"), 5 * 16 + 8, 9 * 16 + 1, 0, 319, 31, "text"
                                DaRKShow
                                WaitForEnter
                            END IF
                            IF NextMP% < 1 AND PlayerMaxMP% < 99 THEN
                                MPUp% = INT(PlayerMaxMP% / 5)
                                PlayerMaxMP% = PlayerMaxMP% + MPUp%: PlayerMP% = PlayerMP% + MPUp%: NextMP% = 100
                                IF PlayerMaxMP% > 99 THEN
                                    PlayerMaxMP% = 99: PlayerMP% = 99: NextMP% = 0
                                END IF
                                ClearBattleDialog
                                PutText 0, 0, ("MP goes up!"), 5 * 16 + 8, 9 * 16 + 1, 0, 319, 31, "text"
                                DaRKShow
                                WaitForEnter
                            END IF
                            IF NextST% < 1 AND PlayerST% < 99 THEN
                                PlayerST% = PlayerST% + 1: NextST% = 100
                                IF PlayerST% = 99 THEN NextST% = 0
                                ClearBattleDialog
                                PutText 0, 0, ("ST goes up!"), 5 * 16 + 8, 9 * 16 + 1, 0, 319, 31, "text"
                                DaRKShow
                                WaitForEnter
                            END IF
                            IF NextDF% < 1 AND PlayerDF% < 99 THEN
                                PlayerDF% = PlayerDF% + 1: NextDF% = 100
                                IF PlayerDF% = 99 THEN NextDF% = 0
                                ClearBattleDialog
                                PutText 0, 0, ("DF goes up!"), 5 * 16 + 8, 9 * 16 + 1, 0, 319, 31, "text"
                                DaRKShow
                                WaitForEnter
                            END IF
                            IF NextAG% < 1 AND PlayerAG% < 99 THEN
                                PlayerAG% = PlayerAG% + 1: NextAG% = 100
                                IF PlayerAG% = 99 THEN NextAG% = 0
                                ClearBattleDialog
                                PutText 0, 0, ("AG goes up!"), 5 * 16 + 8, 9 * 16 + 1, 0, 319, 31, "text"
                                DaRKShow
                                WaitForEnter
                            END IF
                            IF NextMS% < 1 AND PlayerMS% < 99 THEN
                                PlayerMS% = PlayerMS% + 1: NextMS% = 100
                                IF PlayerMS% = 99 THEN NextMS% = 0
                                ClearBattleDialog
                                PutText 0, 0, ("INT goes up!"), 5 * 16 + 8, 9 * 16 + 1, 0, 319, 31, "text"
                                DaRKShow
                                WaitForEnter
                            END IF
                            IF NextMD% < 1 AND PlayerMD% < 99 THEN
                                PlayerMD% = PlayerMD% + 1: NextMD% = 100
                                IF PlayerMD% = 99 THEN NextMD% = 0
                                ClearBattleDialog
                                PutText 0, 0, ("SP goes up!"), 5 * 16 + 8, 9 * 16 + 1, 0, 319, 31, "text"
                                DaRKShow
                                WaitForEnter
                            END IF
                            IF EItem$ <> "" THEN GetItem% = INT(RND * 10) + 1
                            IF GetItem% = 4 THEN
                                FOR EmptySlot% = 1 TO 10
                                    IF Item$(EmptySlot%) = "" THEN
                                        Item$(EmptySlot%) = EItem$
                                        ClearBattleDialog
                                        PutText 0, 0, ("Got " + EItem$ + "!"), 5 * 16 + 8, 9 * 16 + 1, 0, 319, 31, "text"
                                        DaRKShow
                                        WaitForEnter
                                        GotItem% = True
                                    END IF
                                    IF GotItem% THEN EXIT FOR
                                NEXT EmptySlot%
                                GotItem% = False
                            END IF
                        ELSEIF EnemyWon% THEN
                            Fade 1, Pal&()
                            gsboxf VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), 0, 0, 319, 199, 16
                            DEF SEG = VARSEG(Buffer&(0)): BLOAD "data\over.bsv", VARPTR(Buffer&(0))
                            DaRKShow
                            Fade 0, Pal&()
                            WaitForEnter
                            ExitGame% = True
                        ELSEIF PlayerRan% THEN
                            NextAG% = NextAG% - ExpAG%
                            ClearBattleDialog
                            PutText 0, 0, ("Valour ran..."), 5 * 16 + 8, 9 * 16 + 1, 0, 319, 31, "text"
                            DaRKShow
                            IF NextAG% < 1 AND PlayerAG% < 255 THEN
                                PlayerAG% = PlayerAG% + 1: NextAG% = 100
                                IF PlayerAG% = 255 THEN NextAG% = 0
                                WaitForEnter
                                ClearBattleDialog
                                PutText 0, 0, ("AG goes up!"), 5 * 16 + 8, 9 * 16 + 1, 0, 319, 31, "text"
                            END IF
                            DaRKShow
                            WaitForEnter
                    END IF
                ELSE
                    PutText 0, 0, ("Command?"), 5 * 16 + 8, 9 * 16 + 1, 0, 319, 31, "text"
                    PointerX% = 0 * 16: PointerY% = 145
                    DaRKShow
                    GET (PointerX%, PointerY%)-(PointerX% + 15, PointerY% + 10), SpriteBack%
                    SpriteEngine "pointer.set", PointerX%, PointerY%, 130, 0
                    DaRKShow
            END IF
        END IF
   
    LOOP UNTIL ExitBattle%

END SUB

SUB CenterText (TextString$)

    NumChars% = LEN(TextString$)
    NumChars% = NumChars% * 8

    MiddleX% = 160 - INT(NumChars% / 2) - 16

END SUB

SUB ClearBattleDialog

    gsboxf VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), 6 * 16 - 8, 9 * 16, 14 * 16 + 8, 11 * 16 + 16, 72

END SUB

SUB ClearStatBox

    gsboxf VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), 16 * 16 - 8, 9 * 16 + 8, 19 * 16, 11 * 16 + 8, 72

END SUB

SUB DaRKInit

    PlayerX% = 7: PlayerY% = 37: PlayerDir% = 0: PlayerMoved% = 0: PlayerOffset% = 2

    StoryLine% = 0: BossBattle% = False: BeatBoss% = False
    MaxXTiles% = 22: MaxYTiles% = 14: TileOffset% = 130
    ScreenX% = PlayerX% - 11: ScreenY% = PlayerY% - 6
    XTiles% = 20: YTiles% = 14
    Medallion%(1) = 0: Medallion%(2) = 0: Medallion%(3) = 0: Medallion%(4) = 0

    gsinit
    LoadPal
    LoadFont

    DEF SEG = VARSEG(Player%(0)): BLOAD "data\valour.set", VARPTR(Player%(0))
    DEF SEG = VARSEG(DialogBox%(0)): BLOAD "data\dialog.set", VARPTR(DialogBox%(0))

    FileNum% = FREEFILE
    OPEN "data\chests.dat" FOR INPUT AS #FileNum%
    FOR ChestNum% = 1 TO 41
        INPUT #FileNum%, ChestArea$(ChestNum%), ChestX%(ChestNum%), ChestY%(ChestNum%), ChestItem$(ChestNum%), ChestFlag%(ChestNum%)
    NEXT ChestNum%
    CLOSE #FileNum%

    PlayerHP% = 65: PlayerMP% = 20
    PlayerMaxHP% = 65: PlayerMaxMP% = 20
    PlayerST% = 7: PlayerDF% = 7: PlayerAG% = 7: PlayerMS% = 5: PlayerMD% = 5
    PlayerName$ = "Valour"

    NextHP% = 100: NextMP% = 100: NextST% = 100: NextDF% = 100: NextAG% = 100: NextMS% = 100: NextMD% = 100

    Item$(1) = "Potion"
    Item$(2) = "Potion"
    Item$(3) = "Potion"
    Item$(4) = "Potion"

    MPNeed%(1) = 2
    MPNeed%(2) = 3
    MPNeed%(3) = 4
    MPNeed%(4) = 6
    MPNeed%(5) = 8
    MPNeed%(6) = 12
    MPNeed%(7) = 15
    MPNeed%(8) = 16
    MPNeed%(9) = 18
    MPNeed%(10) = 4

END SUB

SUB DarkLoadEnemies (EnemyData$)

    FileNum% = FREEFILE
    OPEN EnemyData$ FOR INPUT AS #FileNum%
    INPUT #FileNum%, NumEnemies%
    IF NumEnemies% > 0 THEN
        FOR Dummy% = 1 TO NumEnemies%
            INPUT #FileNum%, EnemyName$(Dummy%), EnemyMagic$(Dummy%), EnemyItem$(Dummy%), EnemyMPNeed%(Dummy%)
            INPUT #FileNum%, EnemyHP%(Dummy%), EnemyMaxHP%(Dummy%), EnemyMP%(Dummy%), EnemyMaxMP%(Dummy%)
            INPUT #FileNum%, EnemyST%(Dummy%), EnemyDF%(Dummy%), EnemyAG%(Dummy%), EnemyMS%(Dummy%), EnemyMD%(Dummy%)
        NEXT Dummy%
    END IF
    CLOSE #FileNum%

END SUB

SUB DaRKLoadMap (DaRKTileSet$, DaRKMap$)
   
    DEF SEG = VARSEG(TileSet%(0)): BLOAD DaRKTileSet$, VARPTR(TileSet%(0))

    FOR J = 1 TO 10
        PointX%(J) = -1: PointY%(J) = -1: ToLoadX%(J) = -1: ToLoadY%(J) = -1: PointMapType%(J) = -1: PointMap$(J) = "": PointPlayerDir%(J) = -1
    NEXT J
    FileNum% = FREEFILE
    OPEN DaRKMap$ FOR INPUT AS #FileNum%
    INPUT #FileNum%, MapType%, MaxX%, MaxY%
    FOR MapY% = 0 TO MaxY%
        FOR MapX% = 0 TO MaxX%
            INPUT #FileNum%, TileMap%(MapX%, MapY%)
        NEXT MapX%
    NEXT MapY%
    INPUT #FileNum%, NumLoadPoints%
    IF NumLoadPoints% > 0 THEN
        FOR J = 1 TO NumLoadPoints%
            INPUT #FileNum%, PointX%(J), PointY%(J), ToLoadX%(J), ToLoadY%(J), PointMapType%(J), PointMap$(J), PointPlayerDir%(J)
        NEXT J
    END IF
    CLOSE #FileNum%

    FOR MapY% = -20 TO -1
        FOR MapX% = -20 TO MaxX% + 20
            TileMap%(MapX%, MapY%) = 67
            TileMap%(MapX%, MapY% + (MaxY% + 21)) = 67
        NEXT MapX%
    NEXT MapY%
    FOR MapY% = -20 TO MaxY% + 20
        FOR MapX% = -20 TO -1
            TileMap%(MapX%, MapY%) = 67
            TileMap%(MapX% + (MaxX% + 21), MapY%) = 67
        NEXT MapX%
    NEXT MapY%

END SUB

SUB DaRKShow

    gspcopy VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), &HA000, 0

END SUB

SUB DaRKTileEngine (x1%, x2%, y1%, y2%, GameShow%) STATIC

    IF x1% = TileSize% - 1 THEN StepX% = -1 ELSE StepX% = 1
    IF y1% = TileSize% - 1 THEN StepY% = -1 ELSE StepY% = 1
    FOR ScrollX% = x1% TO x2% STEP StepX%
    FOR ScrollY% = y1% TO y2% STEP StepY%
    A% = -1: b% = -1
    FOR Y% = ScreenY% - 1 TO ScreenY% + MaxYTiles%
    
        FOR X% = ScreenX% + 1 TO ScreenX% + MaxXTiles%
        
            ScreenMap%(A%, b%) = TileMap%(X%, Y%)
            gssprite A% * TileSize% + ScrollX%, b% * TileSize% + ScrollY%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(TileSet%(ScreenMap%(A%, b%) * TileOffset%)), VARPTR(TileSet%(ScreenMap%(A%, b%) * TileOffset%))
            IF TileMap%(X%, Y%) = 71 THEN
                FOR ChestNum% = 1 TO 41
                    IF ChestArea$(ChestNum%) = CurrentMap$ AND ChestX%(ChestNum%) = X% AND ChestY%(ChestNum%) = Y% AND ChestFlag%(ChestNum%) = -1 THEN
                        gssprite A% * TileSize% + ScrollX%, b% * TileSize% + ScrollY%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(TileSet%(72 * TileOffset%)), VARPTR(TileSet%(72 * TileOffset%))
                    END IF
                NEXT ChestNum%
            END IF
            A% = A% + 1
            IF A% = XTiles% + 1 THEN A% = -1

        NEXT X%
        b% = b% + 1
        IF b% = YTiles% + 1 THEN b% = -1

    NEXT Y%

    IF PlayerDir% = 0 THEN
            IF ScrollY% = 0 THEN
                    gssprite TileSize * (XTiles% / 2 - 1), TileSize * (YTiles / 2 - 1) - PlayerOffset%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(Player%(3 * CharSize%)), VARPTR(Player%(3 * CharSize%))
                ELSEIF ScrollY% >= -7 AND ScrollY% <= -1 THEN
                    gssprite TileSize% * (XTiles% / 2 - 1), TileSize% * (YTiles% / 2 - 1) - PlayerOffset%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(Player%(4 * CharSize%)), VARPTR(Player%(4 * CharSize%))
                ELSEIF ScrollY% >= -15 AND ScrollY% <= -8 THEN
                    gssprite TileSize% * (XTiles% / 2 - 1), TileSize% * (YTiles% / 2 - 1) - PlayerOffset%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(Player%(5 * CharSize%)), VARPTR(Player%(5 * CharSize%))
            END IF
        ELSEIF PlayerDir% = 1 THEN
            IF ScrollY% = 0 THEN
                    gssprite TileSize% * (XTiles% / 2 - 1), TileSize% * (YTiles% / 2 - 1) - PlayerOffset%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(Player%(0 * CharSize%)), VARPTR(Player%(0 * CharSize%))
                ELSEIF ScrollY% >= 1 AND ScrollY% <= 7 THEN
                    gssprite TileSize% * (XTiles% / 2 - 1), TileSize% * (YTiles% / 2 - 1) - PlayerOffset%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(Player%(1 * CharSize%)), VARPTR(Player%(1 * CharSize%))
                ELSEIF ScrollY% >= 8 AND ScrollY% <= 15 THEN
                    gssprite TileSize% * (XTiles% / 2 - 1), TileSize% * (YTiles% / 2 - 1) - PlayerOffset%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(Player%(2 * CharSize%)), VARPTR(Player%(2 * CharSize%))
            END IF
        ELSEIF PlayerDir% = 2 THEN
            IF ScrollX% = 0 THEN
                    gssprite TileSize% * (XTiles% / 2 - 1), TileSize% * (YTiles% / 2 - 1) - PlayerOffset%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(Player%(8 * CharSize%)), VARPTR(Player%(8 * CharSize%))
                ELSEIF ScrollX% >= -7 AND ScrollX% <= -1 THEN
                    gssprite TileSize% * (XTiles% / 2 - 1), TileSize% * (YTiles% / 2 - 1) - PlayerOffset%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(Player%(9 * CharSize%)), VARPTR(Player%(9 * CharSize%))
                ELSEIF ScrollX% >= -15 AND ScrollX% <= -8 THEN
                    gssprite TileSize% * (XTiles% / 2 - 1), TileSize% * (YTiles% / 2 - 1) - PlayerOffset%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(Player%(8 * CharSize%)), VARPTR(Player%(8 * CharSize%))
            END IF
        ELSEIF PlayerDir% = 3 THEN
            IF ScrollX% = 0 THEN
                    gssprite TileSize% * (XTiles% / 2 - 1), TileSize% * (YTiles% / 2 - 1) - PlayerOffset%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(Player%(6 * CharSize%)), VARPTR(Player%(6 * CharSize%))
                ELSEIF ScrollX% >= 1 AND ScrollX% <= 7 THEN
                    gssprite TileSize% * (XTiles% / 2 - 1), TileSize% * (YTiles% / 2 - 1) - PlayerOffset%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(Player%(7 * CharSize%)), VARPTR(Player%(7 * CharSize%))
                ELSEIF ScrollX% >= 8 AND ScrollX% <= 15 THEN
                    gssprite TileSize% * (XTiles% / 2 - 1), TileSize% * (YTiles% / 2 - 1) - PlayerOffset%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(Player%(6 * CharSize%)), VARPTR(Player%(6 * CharSize%))
            END IF
    END IF

    gswait 1
    IF GameShow% = 1 THEN DaRKShow
    NEXT ScrollY%
    NEXT ScrollX%

END SUB

SUB DescribeItem (SlotSelected%, MenuType%)

    IF MenuType% > 2 THEN EXIT SUB
    gsboxf VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), 16, 8, 230, 16, 72
    IF MenuType% = 1 THEN
            IF Item$(SlotSelected%) = "Potion" THEN
                    ShowText$ = "Restores 50HP."
                ELSEIF Item$(SlotSelected%) = "ExPotion" THEN
                    ShowText$ = "Restores 100HP."
                ELSEIF Item$(SlotSelected%) = "MegaPotion" THEN
                    ShowText$ = "Restores 250HP."
                ELSEIF Item$(SlotSelected%) = "Ethere" THEN
                    ShowText$ = "Restores 10MP."
                ELSEIF Item$(SlotSelected%) = "ExEthere" THEN
                    ShowText$ = "Restores 50MP."
                ELSEIF Item$(SlotSelected%) = "MegaEthere" THEN
                    ShowText$ = "Restores 75MP."
                ELSEIF Item$(SlotSelected%) = "Elixir" THEN
                    ShowText$ = "Restores HP, MP to full."
            END IF
        ELSEIF MenuType% = 2 THEN
            IF Magic$(SlotSelected%) = "Cure" THEN
                    ShowText$ = "Restores a bit of HP."
                ELSEIF Magic$(SlotSelected%) = "Fire" THEN
                    ShowText$ = "Weak fire spell."
                ELSEIF Magic$(SlotSelected%) = "ExCure" THEN
                    ShowText$ = "Restores some HP."
                ELSEIF Magic$(SlotSelected%) = "ExFire" THEN
                    ShowText$ = "Strong fire spell."
                ELSEIF Magic$(SlotSelected%) = "MegaCure" THEN
                    ShowText$ = "Restores a lot of HP."
                ELSEIF Magic$(SlotSelected%) = "MegaFire" THEN
                    ShowText$ = "Powerful fire spell."
                ELSEIF Magic$(SlotSelected%) = "StoneRain" THEN
                    ShowText$ = "Rains boulders on foe."
                ELSEIF Magic$(SlotSelected%) = "HolyRain" THEN
                    ShowText$ = "Purifing light hits foe."
                ELSEIF Magic$(SlotSelected%) = "DarkRain" THEN
                    ShowText$ = "Shadows envelop foe."
                ELSEIF Magic$(SlotSelected%) = "Osmose" THEN
                    ShowText$ = "Drains magic from foe."
            END IF
    END IF
    PutText 0, 0, ShowText$, 1 * 16, 8, 0, 319, 31, "text"

END SUB

SUB DrawBattle

    DEF SEG = VARSEG(Buffer&(0)): BLOAD "data\battle.bsv", VARPTR(Buffer&(0))
    FOR NumBoxes% = 1 TO 2
        IF NumBoxes% = 1 THEN DialogX% = 0 ELSE DialogX% = 15
        SetTile DialogX% * 16, 8 * 16 + 8, 6
        SetTile DialogX% * 16, 9 * 16 + 8, 7
        SetTile DialogX% * 16, 10 * 16 + 8, 7
        SetTile DialogX% * 16, 11 * 16 + 8, 0
        SetTile ((DialogX% + 1) * 16), 8 * 16 + 8, 5
        SetTile ((DialogX% + 2) * 16), 8 * 16 + 8, 5
        SetTile ((DialogX% + 3) * 16), 8 * 16 + 8, 5
        SetTile ((DialogX% + 4) * 16), 8 * 16 + 8, 4
        SetTile ((DialogX% + 4) * 16), 9 * 16 + 8, 3
        SetTile ((DialogX% + 4) * 16), 10 * 16 + 8, 3
        SetTile ((DialogX% + 4) * 16), 11 * 16 + 8, 2
        SetTile ((DialogX% + 3) * 16), 11 * 16 + 8, 1
        SetTile ((DialogX% + 2) * 16), 11 * 16 + 8, 1
        SetTile ((DialogX% + 1) * 16), 11 * 16 + 8, 1
        gsboxf VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), ((DialogX% + 1) * 16), 9 * 16 + 8, ((DialogX% + 4) * 16), 11 * 16 + 8, 72
    NEXT NumBoxes%
    SetTile 5 * 16, 11 * 16 + 8, 0
    SetTile 5 * 16, 8 * 16 + 8, 6
    SetTile 14 * 16, 8 * 16 + 8, 4
    SetTile 14 * 16, 11 * 16 + 8, 2
    FOR DialogX% = 6 TO 13
        SetTile DialogX% * 16, 8 * 16 + 8, 5
        SetTile DialogX% * 16, 11 * 16 + 8, 1
    NEXT DialogX%
    FOR DialogY% = 9 TO 10
        SetTile 5 * 16, DialogY% * 16 + 8, 7
        SetTile 14 * 16, DialogY% * 16 + 8, 3
    NEXT DialogY%
    ClearBattleDialog
        
    PutText 0, 0, "Attack", 1 * 16, 9 * 16 + 1, 0, 319, 31, "text"
    PutText 0, 0, "Defend", 1 * 16, 9 * 16 + 11, 0, 319, 31, "text"
    PutText 0, 0, "Item", 1 * 16, 10 * 16 + 5, 0, 319, 31, "text"
    PutText 0, 0, "Magic", 1 * 16, 10 * 16 + 15, 0, 319, 31, "text"
    PutText 0, 0, "Escape", 1 * 16, 11 * 16 + 9, 0, 319, 31, "text"

    UpdateStats
   
    DaRKShow
    GET (111, 1)-(215, 96), EnemyBack%
    IF EName$ = "Zombie" THEN
            EnemySprite$ = "n_zombie.set"
        ELSEIF EName$ = "Bloody" THEN
            EnemySprite$ = "n_bloody.set"
        ELSEIF EName$ = "Ghoul" THEN
            EnemySprite$ = "n_ghoul.set"
        ELSEIF EName$ = "Vampyre" THEN
            EnemySprite$ = "n_vampir.set"
        ELSEIF EName$ = "Revenant" THEN
            EnemySprite$ = "n_reven.set"
        ELSEIF EName$ = "Mucus" THEN
            EnemySprite$ = "n_blob.set"
        ELSEIF EName$ = "Nocturnus" THEN
            EnemySprite$ = "n_lord.set"
        ELSEIF EName$ = "Vlad" THEN
            EnemySprite$ = "n_vlad.set"
    END IF
    IF PlayerWon% = False THEN SpriteEngine EnemySprite$, EnemyX%, EnemyY%, EnemySize%, 0

END SUB

SUB DrawBattleMenu (MenuType%)

    SetTile 0 * 16, 1 * 16, 6
    SetTile 7 * 16 + 8, 1 * 16, 4
    SetTile 7 * 16 + 8, 11 * 16 + 8, 2
    SetTile 0 * 16, 11 * 16 + 8, 0
    FOR Y% = 2 TO 11
        SetTile 0 * 16, Y% * 16, 7
        SetTile 7 * 16 + 8, Y% * 16, 3
    NEXT Y%
    FOR X% = 1 TO 7
        SetTile X% * 16, 1 * 16, 5
        SetTile X% * 16, 11 * 16 + 8, 1
    NEXT X%
    gsboxf VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), 16, 32, 7 * 16 + 8, 11 * 16 + 8, 72

    IF MenuType% = 3 THEN
            FOR ItemNumber% = 2 TO 11
                PutText 0, 0, Item$(ItemNumber% - 1), 1 * 16, ItemNumber% * 16, 0, 319, 31, "text"
            NEXT ItemNumber%
        ELSEIF MenuType% = 4 THEN
            FOR MagicNumber% = 2 TO 11
                IF Magic$(MagicNumber% - 1) <> "" THEN
                    PutText 0, 0, Magic$(MagicNumber% - 1), 1 * 16, MagicNumber% * 16, 0, 319, 31, "text"
                    PutText MPNeed%(MagicNumber% - 1), 0, "", 7 * 16 - 8, MagicNumber% * 16, 2, 319, 31, "int"
                END IF
            NEXT MagicNumber%
    END IF

END SUB

SUB DrawGameMenu (MenuType%)

    DEF SEG = VARSEG(Buffer&(0)): BLOAD "data\dialog.bsv", VARPTR(Buffer&(0))

    IF MenuType% = 1 THEN Colour% = 28 ELSE Colour% = 31
    PutText 0, 0, "Item", 16 * 16 + 8, 1 * 16, 0, 319, Colour%, "text"
    IF MenuType% = 2 THEN Colour% = 28 ELSE Colour% = 31
    PutText 0, 0, "Magic", 16 * 16 + 8, 2 * 16, 0, 319, Colour%, "text"
    PutText 0, 0, "Exit", 16 * 16 + 8, 3 * 16, 0, 319, 31, "text"
    PutText 0, 0, "Quit", 16 * 16 + 8, 4 * 16, 0, 319, 31, "text"

    IF MenuType% = 0 THEN
            SpriteEngine "valour.set", 1 * 16, 2 * 16, 130, 0
            PutText 0, 0, "Valour", 2 * 16 + 8, 2 * 16, 0, 319, 31, "text"

            PutText 0, 0, "Type", 1 * 16, 4 * 16, 0, 319, 31, "text"
            PutText 0, 0, "----", 1 * 16, 4 * 16 + 8, 0, 319, 31, "text"
            PutText 0, 0, "Stat", 8 * 16, 4 * 16, 0, 319, 31, "text"
            PutText 0, 0, "----", 8 * 16, 4 * 16 + 8, 0, 319, 31, "text"
            PutText 0, 0, "Next", 12 * 16, 4 * 16, 0, 319, 31, "text"
            PutText 0, 0, "----", 12 * 16, 4 * 16 + 8, 0, 319, 31, "text"

            PutText 0, 0, "HP", 1 * 16, 5 * 16 + 8, 0, 319, 31, "text"
            PutText 0, 0, "MP", 1 * 16, 6 * 16 + 4, 0, 319, 31, "text"
            PutText 0, 0, "Strength", 1 * 16, 7 * 16 + 8, 0, 319, 31, "text"
            PutText 0, 0, "Defense", 1 * 16, 8 * 16 + 4, 0, 319, 31, "text"
            PutText 0, 0, "Agility", 1 * 16, 9 * 16, 0, 319, 31, "text"
            PutText 0, 0, "Intelligence", 1 * 16, 10 * 16 + 4, 0, 319, 31, "text"
            PutText 0, 0, "Spirit", 1 * 16, 11 * 16, 0, 319, 31, "text"
       
            PutText PlayerMaxHP%, 0, "", 8 * 16 + 9, 5 * 16 + 8, 3, 319, 31, "int"
            PutText PlayerHP%, 0, "", 6 * 16 + 4, 5 * 16 + 8, 3, 319, 31, "int"
            PutText 0, 0, "/", 8 * 16, 5 * 16 + 8, 0, 319, 31, "text"
            PutText PlayerMaxMP%, 0, "", 9 * 16 + 2, 6 * 16 + 4, 2, 319, 31, "int"
            PutText PlayerMP%, 0, "", 7 * 16 + 6, 6 * 16 + 4, 2, 319, 31, "int"
            PutText 0, 0, "/", 8 * 16 + 8, 6 * 16 + 4, 0, 319, 31, "text"

            PutText PlayerST%, 0, "", 8 * 16 + 9, 7 * 16 + 8, 3, 319, 31, "int"
            PutText PlayerDF%, 0, "", 8 * 16 + 9, 8 * 16 + 4, 3, 319, 31, "int"
            PutText PlayerAG%, 0, "", 8 * 16 + 9, 9 * 16, 3, 319, 31, "int"
            PutText PlayerMS%, 0, "", 8 * 16 + 9, 10 * 16 + 4, 3, 319, 31, "int"
            PutText PlayerMD%, 0, "", 8 * 16 + 9, 11 * 16, 3, 319, 31, "int"

            PutText NextHP%, 0, "", 12 * 16 + 9, 5 * 16 + 8, 3, 319, 31, "int"
            PutText NextMP%, 0, "", 12 * 16 + 9, 6 * 16 + 4, 3, 319, 31, "int"
            PutText NextST%, 0, "", 12 * 16 + 9, 7 * 16 + 8, 3, 319, 31, "int"
            PutText NextDF%, 0, "", 12 * 16 + 9, 8 * 16 + 4, 3, 319, 31, "int"
            PutText NextAG%, 0, "", 12 * 16 + 9, 9 * 16, 3, 319, 31, "int"
            PutText NextMS%, 0, "", 12 * 16 + 9, 10 * 16 + 4, 3, 319, 31, "int"
            PutText NextMD%, 0, "", 12 * 16 + 9, 11 * 16, 3, 319, 31, "int"

        ELSEIF MenuType% = 1 THEN
            FOR ItemNumber% = 2 TO 11
                PutText 0, 0, Item$(ItemNumber% - 1), 1 * 16, ItemNumber% * 16, 0, 319, 31, "text"
            NEXT ItemNumber%
        ELSEIF MenuType% = 2 THEN
            FOR MagicNumber% = 2 TO 11
                IF Magic$(MagicNumber% - 1) <> "" THEN
                    PutText 0, 0, Magic$(MagicNumber% - 1), 1 * 16, MagicNumber% * 16, 0, 319, 31, "text"
                    PutText MPNeed%(MagicNumber% - 1), 0, "", 14 * 16 - 8, MagicNumber% * 16, 2, 319, 31, "int"
                END IF
            NEXT MagicNumber%
    END IF

    IF Medallion%(1) = 0 THEN
            SpriteEngine "medalion.set", 17 * 16 - 4, 7 * 16, 130, 0
        ELSE
            SpriteEngine "medalion.set", 17 * 16 - 4, 7 * 16, 130, 4
    END IF
    IF Medallion%(2) = 0 THEN
            SpriteEngine "medalion.set", 17 * 16 - 4, 8 * 16, 130, 1
        ELSE
            SpriteEngine "medalion.set", 17 * 16 - 4, 8 * 16, 130, 5
    END IF
    IF Medallion%(3) = 0 THEN
            SpriteEngine "medalion.set", 18 * 16 - 4, 8 * 16, 130, 2
        ELSE
            SpriteEngine "medalion.set", 18 * 16 - 4, 8 * 16, 130, 6
    END IF
    IF Medallion%(4) = 0 THEN
            SpriteEngine "medalion.set", 18 * 16 - 4, 7 * 16, 130, 3
        ELSE
            SpriteEngine "medalion.set", 18 * 16 - 4, 7 * 16, 130, 7
    END IF

END SUB

SUB EnemyAct

    IF EMagic$ <> "" AND EMP% >= EMPNeed% THEN EnemyChoice% = 2 ELSE EnemyChoice% = 1
    EnemyAction% = INT(RND * EnemyChoice%) + 1

    IF EnemyAction% = 1 THEN
            EnemyDamage% = EST% * 4 + (INT(RND * 5) + 1) - PlayerDF% * 2 + (INT(RND * 5) + 1)
            IF PlayerAction$ = "defend" THEN EnemyDamage% = INT(EnemyDamage% / 2)
            ExpDF% = ExpDF% + 2: ExpHP% = ExpHP% + 4
            ClearBattleDialog
            DaRKShow
            IF EnemyDamage% > 0 THEN
                    PALETTE 0, 63
                    ShakeScreen
                    PALETTE 0, 0
                    PutText 0, 0, (EName$), 5 * 16 + 8, 9 * 16 + 1, 0, 319, 31, "text"
                    PutText 0, 0, ("attacks for" + STR$(EnemyDamage%)), 5 * 16 + 8, 9 * 16 + 9, 0, 319, 31, "text"
                    PutText 0, 0, ("damage."), 5 * 16 + 8, 10 * 16 + 3, 0, 319, 31, "text"
                    PlayerHP% = PlayerHP% - EnemyDamage%
                ELSE
                    PutText 0, 0, (EName$), 5 * 16 + 8, 9 * 16 + 1, 0, 319, 31, "text"
                    PutText 0, 0, "misses!", 5 * 16 + 8, 9 * 16 + 9, 0, 319, 31, "text"
                    ExpAG% = ExpAG% + 2
            END IF
            UpdateStats
            DaRKShow
            WaitForEnter
        ELSEIF EnemyAction% = 2 THEN
            EnemyDamage% = EMS% * 6 + (INT(RND * 5) + 1) - PlayerMD% * 2 + (INT(RND * 5) + 1)
            IF PlayerAction$ = "defend" THEN EnemyDamage% = INT(EnemyDamage% / 2)
            ExpDF% = ExpDF% + 2: ExpHP% = ExpHP% + 4
            ClearBattleDialog
            DaRKShow
            IF EnemyDamage% > 0 AND EMP% >= EMPNeed% THEN
                    EMP% = EMP% - EMPNeed%
                    PALETTE 0, 63
                    ShakeScreen
                    PALETTE 0, 0
                    PutText 0, 0, (EName$), 5 * 16 + 8, 9 * 16 + 1, 0, 319, 31, "text"
                    PutText 0, 0, ("casts " + EMagic$), 5 * 16 + 8, 9 * 16 + 9, 0, 319, 31, "text"
                    PutText 0, 0, ("for" + STR$(EnemyDamage%) + " damage."), 5 * 16 + 8, 10 * 16 + 3, 0, 319, 31, "text"
                    PlayerHP% = PlayerHP% - EnemyDamage%
                    ExpMD% = ExpMD% + 5
                ELSEIF EMP% < EMPNeed% THEN
                    PutText 0, 0, (EName$), 5 * 16 + 8, 9 * 16 + 1, 0, 319, 31, "text"
                    PutText 0, 0, "failed casting!", 5 * 16 + 8, 9 * 16 + 9, 0, 319, 31, "text"
                ELSE
                    EMP% = EMP% - EMPNeed%
                    PutText 0, 0, (EName$), 5 * 16 + 8, 9 * 16 + 1, 0, 319, 31, "text"
                    PutText 0, 0, "misses!", 5 * 16 + 8, 9 * 16 + 9, 0, 319, 31, "text"
                    ExpAG% = ExpAG% + 2: ExpMD% = ExpMD% + 5
            END IF
            UpdateStats
            DaRKShow
            WaitForEnter
    END IF
    IF PlayerHP% < 1 THEN
        PlayerHP% = 0: EnemyWon% = True
    END IF
   
END SUB

SUB Fade (Direction%, PaletteArray&())

    IF Direction% = 1 THEN
        '*** Fade palette down ***

        'Break down all 256 colours into their RGB values and
        'calculate how much each will need fading down by.
        REDIM RGBval!(0 TO 255, 0 TO 2)
        REDIM SubVal!(0 TO 255, 0 TO 2)
        FOR N = 0 TO 255
            c& = PaletteArray&(N)
            b = c& \ 65536: c& = c& - b * 65536
            g = c& \ 256: c& = c& - g * 256
            r = c&
            RGBval!(N, 0) = r
            RGBval!(N, 1) = g
            RGBval!(N, 2) = b
            SubVal!(N, 0) = r / 63
            SubVal!(N, 1) = g / 63
            SubVal!(N, 2) = b / 63
        NEXT N

        'Fade down all 256 colours in 63 steps.
        FOR J = 1 TO 63
            'Calculate new faded down RGB values.
            FOR N = 0 TO 255
                RGBval!(N, 0) = RGBval!(N, 0) - SubVal!(N, 0)
                RGBval!(N, 1) = RGBval!(N, 1) - SubVal!(N, 1)
                RGBval!(N, 2) = RGBval!(N, 2) - SubVal!(N, 2)
            NEXT N

            'Write faded down colours directly to the video card.
            WAIT &H3DA, &H8, &H8: WAIT &H3DA, &H8
            FOR N = 0 TO 255
                OUT &H3C8, N             'Select attribute.
                OUT &H3C9, RGBval!(N, 0) 'Write red.
                OUT &H3C9, RGBval!(N, 1) 'Write green.
                OUT &H3C9, RGBval!(N, 2) 'Write blue.
            NEXT N
        NEXT J
    ELSE
        '*** Fade palette up ***

        'Break down all 256 colours into their RGB values and
        'calculate how much each will need fading up by.
        DIM RGBval!(0 TO 255, 0 TO 2)
        DIM AddVal!(0 TO 255, 0 TO 2)
        FOR N = 0 TO 255
            c& = PaletteArray&(N)
            b = c& \ 65536: c& = c& - b * 65536
            g = c& \ 256: c& = c& - g * 256
            r = c&
            AddVal!(N, 0) = r / 63
            AddVal!(N, 1) = g / 63
            AddVal!(N, 2) = b / 63
        NEXT N

        'Fade up all 256 colours in 63 steps.
        FOR J = 1 TO 63
            'Calculate new faded up RGB values.
            FOR N = 0 TO 255
                RGBval!(N, 0) = RGBval!(N, 0) + AddVal!(N, 0)
                RGBval!(N, 1) = RGBval!(N, 1) + AddVal!(N, 1)
                RGBval!(N, 2) = RGBval!(N, 2) + AddVal!(N, 2)
            NEXT N

            'Write faded up colours directly to the video card.
            WAIT &H3DA, &H8, &H8: WAIT &H3DA, &H8
            FOR N = 0 TO 255
                OUT &H3C8, N             'Select attribute.
                OUT &H3C9, RGBval!(N, 0) 'Write red.
                OUT &H3C9, RGBval!(N, 1) 'Write green.
                OUT &H3C9, RGBval!(N, 2) 'Write blue.
            NEXT N
        NEXT J
    END IF

END SUB

SUB GameMenu

    DrawGameMenu 0
    DaRKShow

    PointerX% = 15 * 16 + 8: PointerY% = 1 * 16
    GET (PointerX%, PointerY%)-(PointerX% + 15, PointerY% + 15), SpriteBack%
    SpriteEngine "pointer.set", PointerX%, PointerY%, 130, 0
    DaRKShow

    DO
        IF MultiKey(72) THEN
            gssprite PointerX%, PointerY%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(SpriteBack%(0)), VARPTR(SpriteBack%(0))
            IF PointerY% <> 1 * 16 THEN
                GET (PointerX%, PointerY% - 16)-(PointerX% + 15, PointerY% - 1), SpriteBack%
                PointerY% = PointerY% - 16
            END IF
            SpriteEngine "pointer.set", PointerX%, PointerY%, 130, 0
            DaRKShow
            WHILE MultiKey(72): WEND
        ELSEIF MultiKey(80) THEN
            gssprite PointerX%, PointerY%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(SpriteBack%(0)), VARPTR(SpriteBack%(0))
            IF PointerY% <> 4 * 16 THEN
                GET (PointerX%, PointerY% + 16)-(PointerX% + 15, PointerY% + 31), SpriteBack%
                PointerY% = PointerY% + 16
            END IF
            SpriteEngine "pointer.set", PointerX%, PointerY%, 130, 0
            DaRKShow
            WHILE MultiKey(80): WEND
        ELSEIF MultiKey(28) THEN
            WHILE MultiKey(28): WEND
            MadeChoice% = False
            IF PointerY% = 1 * 16 THEN
                    DrawGameMenu 1
                    SelectMenuItem 1
                    IF ExitMenu% THEN
                        DrawGameMenu 0
                        PointerX% = 15 * 16 + 8: PointerY% = 1 * 16
                        GET (PointerX%, PointerY%)-(PointerX% + 15, PointerY% + 15), SpriteBack%
                        SpriteEngine "pointer.set", PointerX%, PointerY%, 130, 0
                        DaRKShow
                    END IF
                ELSEIF PointerY% = 2 * 16 THEN
                    DrawGameMenu 2
                    SelectMenuItem 2
                    IF ExitMenu% THEN
                        DrawGameMenu 0
                        PointerX% = 15 * 16 + 8: PointerY% = 2 * 16
                        GET (PointerX%, PointerY%)-(PointerX% + 15, PointerY% + 15), SpriteBack%
                        SpriteEngine "pointer.set", PointerX%, PointerY%, 130, 0
                        DaRKShow
                    END IF
                ELSEIF PointerY% = 3 * 16 THEN
                    ' Player selected exit.
                    MadeChoice% = True
                ELSEIF PointerY% = 4 * 16 THEN
                    ' Player selected quit.
                    MadeChoice% = True: ExitGame% = True
            END IF
        END IF
    LOOP UNTIL MadeChoice%

END SUB

DEFSNG A-Z
SUB LoadArea (FromArea$, ToArea$, Pointer%)

    MapType% = PointMapType%(Pointer%): PlayerDir% = PointPlayerDir%(Pointer%)
    PlayerX% = ToLoadX%(Pointer%): PlayerY% = ToLoadY%(Pointer%)
    ScreenX% = PlayerX% - 11: ScreenY% = PlayerY% - 6
   
    NewTileSet$ = "nocturne.set": CurrentMap$ = ToArea$: BattleProtect% = 5

    DaRKLoadMap "data\" + NewTileSet$, "data\" + ToArea$ + ".map"
    DarkLoadEnemies "data\" + ToArea$ + ".dat"

END SUB

DEFINT A-Z
SUB LoadFont

    FileNum% = FREEFILE
    OPEN "data\fix_font.dat" FOR INPUT AS #FileNum%
    Font% = 32
    DO
        Font% = Font% + 1
        FOR Y% = 1 TO 8
            FOR X% = 1 TO 8
                INPUT #FileNum, ChrSet%(Font%, X%, Y%)
            NEXT X%
        NEXT Y%
    LOOP UNTIL Font = 122
    CLOSE #FileNum%

END SUB

SUB LoadGame

    FileNum% = FREEFILE
    OPEN "data\save.dat" FOR INPUT AS #FileNum%
    INPUT #FileNum%, PlayerHP%, PlayerMaxHP%, PlayerMP%, PlayerMaxMP%, StoryLine%
    INPUT #FileNum%, PlayerST%, PlayerDF%, PlayerAG%, PlayerMS%, PlayerMD%
    INPUT #FileNum%, NextHP%, NextMP%, NextST%, NextDF%, NextAG%, NextMS%, NextMD%
    FOR GetData% = 1 TO 10
        INPUT #FileNum%, Item$(GetData%), Magic$(GetData%)
    NEXT GetData%
    FOR GetData% = 1 TO 41
        INPUT #FileNum%, ChestFlag%(GetData%)
    NEXT GetData%
    INPUT #FileNum%, Medallion%(1), Medallion%(2), Medallion%(3), Medallion%(4)
    CLOSE #FileNum%

    PlayerX% = 13: PlayerY% = 7: PlayerDir% = 2: CurrentMap$ = "f1_pre_1"
    ScreenX% = PlayerX% - 11: ScreenY% = PlayerY% - 6

    DaRKLoadMap "data\nocturne.set", "data\f1_pre_1.map"
    DarkLoadEnemies "data\f1_pre_1.dat"

END SUB

SUB LoadPal

    FileNum = FREEFILE
    OPEN "data\rpg.pal" FOR BINARY AS #FileNum
    FOR N = 0 TO 255
        GET #FileNum, , Colour&
        Pal&(N) = Colour&
    NEXT N
    CLOSE #FileNum

    DIM RGBval(0 TO 255, 0 TO 2)
    FOR N = 0 TO 255
        c& = Pal&(N)
        b = c& \ 65536: c& = c& - b * 65536
        g = c& \ 256: c& = c& - g * 256
        r = c&
        RGBval(N, 0) = r
        RGBval(N, 1) = g
        RGBval(N, 2) = b
    NEXT N

    WAIT &H3DA, &H8, &H8: WAIT &H3DA, &H8
    FOR N = 0 TO 255
        OUT &H3C8, N
        OUT &H3C9, RGBval(N, 0)
        OUT &H3C9, RGBval(N, 1)
        OUT &H3C9, RGBval(N, 2)
    NEXT N
    ERASE RGBval

END SUB

SUB Main

    Fade 1, Pal&()
    ScrollX1% = 0: ScrollX2% = 0: ScrollY1% = 0: ScrollY2% = 0
    DaRKTileEngine ScrollX1%, ScrollX2%, ScrollY1%, ScrollY2%, 1
    DaRKShow
    Fade 0, Pal&()
    WHILE MultiKey(28): WEND

    DO

        IF MultiKey(72) THEN
            PlayerDir% = 0
            ScriptCheck
            IF TileMap%(PlayerX%, PlayerY% - 1) < 49 AND ScriptSafe% = True THEN
                ScreenY% = ScreenY% - 1: ShiftPlayer! = TIMER
                PlayerY% = PlayerY% - 1: Moved% = True
                ScrollY1% = -15: ScrollY2% = 0
            END IF
        ELSEIF MultiKey(80) THEN
            PlayerDir% = 1
            IF TileMap%(PlayerX%, PlayerY% + 1) < 49 THEN
                ScreenY% = ScreenY% + 1: ShiftPlayer! = TIMER
                PlayerY% = PlayerY% + 1: Moved% = True
                ScrollY1% = 15: ScrollY2% = 0
            END IF
        ELSEIF MultiKey(75) THEN
            PlayerDir% = 2
            IF TileMap%(PlayerX% - 1, PlayerY%) < 49 THEN
                ScreenX% = ScreenX% - 1: ShiftPlayer! = TIMER
                PlayerX% = PlayerX% - 1: Moved% = True
                ScrollX1% = -15: ScrollX2% = 0
            END IF
        ELSEIF MultiKey(77) THEN
            PlayerDir% = 3
            IF TileMap%(PlayerX% + 1, PlayerY%) < 49 THEN
                ScreenX% = ScreenX% + 1: ShiftPlayer! = TIMER
                PlayerX% = PlayerX% + 1: Moved% = True
                ScrollX1% = 15: ScrollX2% = 0
            END IF
        ELSEIF MultiKey(1) THEN
            GameMenu
            ScrollX1% = 0: ScrollX2% = 0: ScrollY1% = 0: ScrollY2% = 0
            DaRKTileEngine ScrollX1%, ScrollX2%, ScrollY1%, ScrollY2%, 1
        ELSEIF MultiKey(28) THEN
            WHILE MultiKey(28): WEND
            IF PlayerDir% = 0 THEN
                    CheckX% = PlayerX%: CheckY% = PlayerY% - 1
                ELSEIF PlayerDir% = 1 THEN
                    CheckX% = PlayerX%: CheckY% = PlayerY% + 1
                ELSEIF PlayerDir% = 2 THEN
                    CheckX% = PlayerX% - 1: CheckY% = PlayerY%
                ELSEIF PlayerDir% = 3 THEN
                    CheckX% = PlayerX% + 1: CheckY% = PlayerY%
            END IF
            IF PlayerX% = 13 AND PlayerY% = 7 AND PlayerDir% = 2 AND CurrentMap$ = "f1_pre_1" THEN
                    PutText 0, 0, "...this bed looks so warm.", 3 * 16, 10 * 16, 0, 319, 31, "text"
                    PutText 0, 0, "HP, MP restored.  Data saved.", 3 * 16, 10 * 16 + 8, 0, 319, 31, "text"
                    PlayerHP% = PlayerMaxHP%: PlayerMP% = PlayerMaxMP%
                    SaveGame
                    DaRKShow
                    WaitForEnter
            END IF
            FOR ChestNum% = 1 TO 41
                IF ChestArea$(ChestNum%) = CurrentMap$ AND ChestX%(ChestNum%) = CheckX% AND ChestY%(ChestNum%) = CheckY% AND ChestFlag%(ChestNum%) = 0 THEN
                    ItemType$ = ""
                    IF ChestItem$(ChestNum%) = "cure scroll" THEN
                            Magic$(1) = "Cure": ItemType$ = "magic"
                        ELSEIF ChestItem$(ChestNum%) = "fire scroll" THEN
                            Magic$(2) = "Fire": ItemType$ = "magic"
                        ELSEIF ChestItem$(ChestNum%) = "excure scroll" THEN
                            Magic$(3) = "ExCure": ItemType$ = "magic"
                        ELSEIF ChestItem$(ChestNum%) = "exfire scroll" THEN
                            Magic$(4) = "ExFire": ItemType$ = "magic"
                        ELSEIF ChestItem$(ChestNum%) = "megacure scroll" THEN
                            Magic$(5) = "MegaCure": ItemType$ = "magic"
                        ELSEIF ChestItem$(ChestNum%) = "megafire scroll" THEN
                            Magic$(6) = "MegaFire": ItemType$ = "magic"
                        ELSEIF ChestItem$(ChestNum%) = "stonerain scroll" THEN
                            Magic$(7) = "StoneRain": ItemType$ = "magic"
                        ELSEIF ChestItem$(ChestNum%) = "holyrain scroll" THEN
                            Magic$(8) = "HolyRain": ItemType$ = "magic"
                        ELSEIF ChestItem$(ChestNum%) = "darkrain scroll" THEN
                            Magic$(9) = "DarkRain": ItemType$ = "magic"
                        ELSEIF ChestItem$(ChestNum%) = "osmose scroll" THEN
                            Magic$(10) = "Osmose": ItemType$ = "magic"
                        ELSEIF LEFT$(ChestItem$(ChestNum%), 15) = "medallion piece" THEN
                            ItemType$ = "medallion"
                            IF RIGHT$(ChestItem$(ChestNum%), 1) = "1" THEN
                                   Medallion%(1) = 1
                               ELSEIF RIGHT$(ChestItem$(ChestNum%), 1) = "2" THEN
                                   Medallion%(2) = 1
                               ELSEIF RIGHT$(ChestItem$(ChestNum%), 1) = "3" THEN
                                   Medallion%(3) = 1
                               ELSEIF RIGHT$(ChestItem$(ChestNum%), 1) = "4" THEN
                                   Medallion%(4) = 1
                            END IF
                        ELSE
                            GotItem% = False
                            FOR ItemNum% = 1 TO 10
                                IF Item$(ItemNum%) = "" THEN
                                    Item$(ItemNum%) = ChestItem$(ChestNum%)
                                    GotItem% = True
                                END IF
                                IF GotItem% THEN EXIT FOR
                            NEXT ItemNum%
                    END IF
                    IF ItemType$ = "magic" OR GotItem% THEN
                            ChestFlag%(ChestNum%) = -1
                            PutText 0, 0, ("There was a " + ChestItem$(ChestNum%)), 3 * 16, 10 * 16, 0, 319, 31, "text"
                            PutText 0, 0, "inside the treasure chest.", 3 * 16, 10 * 16 + 8, 0, 319, 31, "text"
                        ELSEIF ItemType$ = "medallion" THEN
                            ChestFlag%(ChestNum%) = -1
                            PutText 0, 0, "Found a medallion piece!", 3 * 16, 10 * 16, 0, 319, 31, "text"
                            PutText 0, 0, "All four, to get inside?", 3 * 16, 10 * 16 + 8, 0, 319, 31, "text"
                        ELSE
                            PutText 0, 0, ("There was a " + ChestItem$(ChestNum%) + ","), 3 * 16, 10 * 16, 0, 319, 31, "text"
                            PutText 0, 0, "but you can't carry any more.", 3 * 16, 10 * 16 + 8, 0, 319, 31, "text"
                    END IF
                    DaRKShow
                    WaitForEnter
                END IF
            NEXT ChestNum%
        END IF

        FoundPoint% = False
        IF NumLoadPoints% > 0 THEN
            FOR K = 1 TO NumLoadPoints%
                IF PlayerX% = PointX%(K) AND PlayerY% = PointY%(K) THEN
                    NewArea$ = PointMap$(K)
                    LoadArea "dummy", NewArea$, K
                    ScrollX1% = 0: ScrollX2% = 0: ScrollY1% = 0: ScrollY2% = 0
                    Fade 1, Pal&()
                    DaRKTileEngine ScrollX1%, ScrollX2%, ScrollY1%, ScrollY2%, 1
                    Fade 0, Pal&()
                    FoundPoint% = True
                END IF
                IF FoundPoint% THEN EXIT FOR
            NEXT K
        END IF

        IF NOT ExitGame% THEN
            DaRKTileEngine ScrollX1%, ScrollX2%, ScrollY1%, ScrollY2%, 1
            ScrollX1% = 0: ScrollX2% = 0: ScrollY1% = 0: ScrollY2% = 0
        END IF

        IF LastMoved% = 0 AND Moved% THEN
                LastMoved% = 1
                PlayerMoved% = 1: ShiftedPlayer% = True
            ELSEIF LastMoved% = 1 AND Moved% THEN
                LastMoved% = 0
                PlayerMoved% = 2: ShiftedPlayer% = True
        END IF
        IF ShiftPlayer! + .25 < TIMER THEN PlayerMoved% = 0
        IF Moved% AND NumEnemies% > 0 AND BattleProtect% = 0 AND NOT ExitGame% THEN
            DoBattle% = INT(RND * 10)
            IF DoBattle% = 3 THEN
                Battle 0
                IF NOT ExitGame% THEN
                    Fade 1, Pal&()
                    ScrollX1% = 0: ScrollX2% = 0: ScrollY1% = 0: ScrollY2% = 0
                    DaRKTileEngine ScrollX1%, ScrollX2%, ScrollY1%, ScrollY2%, 1
                    DaRKShow
                    Fade 0, Pal&()
                    BattleProtect% = 5
                END IF
            END IF
        END IF
        IF Moved% AND BattleProtect% > 0 THEN BattleProtect% = BattleProtect% - 1
        Moved% = False: ScriptSafe% = True

    LOOP UNTIL ExitGame%

END SUB

FUNCTION MultiKey (T)

STATIC kbcontrol%(), kbmatrix%(), Firsttime, StatusFlag

IF Firsttime = 0 THEN          'Initalize
 DIM kbcontrol%(128)
 DIM kbmatrix%(128)
 code$ = ""
 code$ = code$ + "E91D00E93C00000000000000000000000000000000000000000000000000"
 code$ = code$ + "00001E31C08ED8BE24000E07BF1400FCA5A58CC38EC0BF2400B85600FAAB"
 code$ = code$ + "89D8ABFB1FCB1E31C08EC0BF2400BE14000E1FFCFAA5A5FB1FCBFB9C5053"
 code$ = code$ + "51521E560657E460B401A8807404B400247FD0E088C3B700B0002E031E12"
 code$ = code$ + "002E8E1E100086E08907E4610C82E661247FE661B020E6205F075E1F5A59"
 code$ = code$ + "5B589DCF"
 DEF SEG = VARSEG(kbcontrol%(0))
 FOR I% = 0 TO 155                     ' Load ASM
     d% = VAL("&h" + MID$(code$, I% * 2 + 1, 2))
     POKE VARPTR(kbcontrol%(0)) + I%, d%
 NEXT I%
 I& = 16       ' I think this stuff connects the interrupt with kbmatrix%()
 N& = VARSEG(kbmatrix%(0)): l& = N& AND 255: h& = ((N& AND &HFF00) \ 256): POKE I&, l&: POKE I& + 1, h&: I& = I& + 2
 N& = VARPTR(kbmatrix%(0)): l& = N& AND 255: h& = ((N& AND &HFF00) \ 256): POKE I&, l&: POKE I& + 1, h&: I& = I& + 2
 DEF SEG
 Firsttime = 1
END IF

SELECT CASE T
 CASE -1
  IF StatusFlag = 0 THEN
   DEF SEG = VARSEG(kbcontrol%(0))
   CALL ABSOLUTE(0)                     ' Run interrupt
   DEF SEG
   StatusFlag = 1
  END IF
 CASE -2
  IF StatusFlag = 1 THEN
   DEF SEG = VARSEG(kbcontrol%(0))      ' Turn off interrupt
   CALL ABSOLUTE(3)
   DEF SEG
   StatusFlag = 0
  END IF
 CASE 1 TO 128
  MultiKey = kbmatrix%(T)               ' Return status
 CASE ELSE
  MultiKey = 0                          ' User Supidity Error
END SELECT

END FUNCTION

SUB PlayerAct

    IF PlayerDamage% > 999 THEN PlayerDamage% = 999
    ClearBattleDialog
    IF PlayerAction$ = "attack" THEN
            Colour& = (65536 * 63) + (256 * 63) + (63)
            PALETTE 0, Colour&
            SpriteEngine "n_hit.set", 127, 28, 64 * 64 / 2 + 2, 0
            DaRKShow
            gswait 5
            PALETTE 0, 0
            SetEnemyBack 111, 1
            SpriteEngine EnemySprite$, EnemyX%, EnemyY%, EnemySize%, 0
            ShakeEnemy
            IF PlayerDamage% > 0 THEN
                    PutText 0, 0, ("Valour attacks  "), 5 * 16 + 8, 9 * 16 + 1, 0, 319, 31, "text"
                    PutText 0, 0, ("for" + STR$(PlayerDamage%) + " damage"), 5 * 16 + 8, 9 * 16 + 9, 0, 319, 31, "text"
                    PutText 0, 0, ("to " + EName$ + "."), 5 * 16 + 8, 10 * 16 + 3, 0, 319, 31, "text"
                    EHP% = EHP% - PlayerDamage%
                ELSE
                    PutText 0, 0, ("Valour misses!  "), 5 * 16 + 8, 9 * 16 + 1, 0, 319, 31, "text"
                    ExpST% = ExpST% - 2
            END IF
            DaRKShow
            WaitForEnter
            IF EHP% <= 0 THEN
                PlayerWon% = True
                ExpST% = ExpST% + 5
            END IF
        ELSEIF PlayerAction$ = "defend" THEN
            PutText 0, 0, ("Valour defends."), 5 * 16 + 8, 9 * 16 + 1, 0, 319, 31, "text"
            DaRKShow
            WaitForEnter
        ELSEIF PlayerAction$ = "item" THEN
            UpdateStats
            PutText 0, 0, ("Valour uses    "), 5 * 16 + 8, 9 * 16 + 1, 0, 319, 31, "text"
            PutText 0, 0, (AttackUsed$ + "."), 5 * 16 + 8, 9 * 16 + 9, 0, 319, 31, "text"
            DaRKShow
            WaitForEnter
        ELSEIF PlayerAction$ = "magic" THEN
            UpdateStats
            IF AttackUsed$ <> "Cure" AND AttackUsed$ <> "ExCure" AND AttackUsed$ <> "MegaCure" AND AttackUsed$ <> "Osmose" THEN
                    IF PlayerDamage% > 0 THEN
                            ShowMagic
                            PutText 0, 0, ("Valour casts    "), 5 * 16 + 8, 9 * 16 + 1, 0, 319, 31, "text"
                            PutText 0, 0, (AttackUsed$ + " for"), 5 * 16 + 8, 9 * 16 + 9, 0, 319, 31, "text"
                            PutText 0, 0, (STR$(PlayerDamage%) + " damage."), 5 * 16 + 8, 10 * 16 + 3, 0, 319, 31, "text"
                            EHP% = EHP% - PlayerDamage%
                        ELSE
                            PutText 0, 0, ("Valour misses!  "), 5 * 16 + 8, 9 * 16 + 1, 0, 319, 31, "text"
                    END IF
                    DaRKShow
                    WaitForEnter
                    IF EHP% <= 0 THEN
                        PlayerWon% = True
                        ExpMS% = ExpMS% + 5
                    END IF
                ELSEIF AttackUsed$ = "Osmose" THEN
                    IF PlayerDamage% > 0 THEN
                            ShowMagic
                            PutText 0, 0, ("Valour casts    "), 5 * 16 + 8, 9 * 16 + 1, 0, 319, 31, "text"
                            PutText 0, 0, (AttackUsed$ + " absorbing"), 5 * 16 + 8, 9 * 16 + 9, 0, 319, 31, "text"
                            PutText 0, 0, (STR$(PlayerDamage%) + " MP."), 5 * 16 + 8, 10 * 16 + 3, 0, 319, 31, "text"
                        ELSE
                            PutText 0, 0, ("No MP to osmose!"), 5 * 16 + 8, 9 * 16 + 1, 0, 319, 31, "text"
                    END IF
                    DaRKShow
                    WaitForEnter
                ELSE
                    ExpHP% = ExpHP% + 4: ExpMD% = ExpMD% + 2
                    PutText 0, 0, ("Valour casts    "), 5 * 16 + 8, 9 * 16 + 1, 0, 319, 31, "text"
                    PutText 0, 0, (AttackUsed$ + " and"), 5 * 16 + 8, 9 * 16 + 9, 0, 319, 31, "text"
                    PutText 0, 0, ("recovers" + STR$(PlayerDamage%) + " HP."), 5 * 16 + 8, 10 * 16 + 3, 0, 319, 31, "text"
                    DaRKShow
                    WaitForEnter
            END IF
        ELSEIF PlayerAction$ = "escape" THEN
            PlayerNum% = INT(RND * PlayerAG%) + 1: ENum% = INT(RND * EAG%) + 1
            IF PlayerNum% >= ENum% THEN
                PlayerRan% = True
                ExpAG% = ExpAG% + 5
            END IF
    END IF

END SUB

DEFSNG A-Z
SUB PutText (Valu%, Value&, Sentence$, TextX%, TextY%, Digits%, MaxText%, TextColour%, TextType$)

    TxtX% = TextX%
    IF TextType$ = "long" THEN
            Sentence$ = RIGHT$(STR$(Value&), LEN(STR$(Value&)) - 1)
            IF Digits% - LEN(Sentence$) > 0 THEN Sentence$ = SPACE$(Digits% - LEN(Sentence$)) + Sentence$
        ELSEIF TextType$ = "int" THEN
            Sentence$ = RIGHT$(STR$(Valu%), LEN(STR$(Valu%)) - 1)
            IF Digits% - LEN(Sentence$) > 0 THEN Sentence$ = SPACE$(Digits% - LEN(Sentence$)) + Sentence$
        ELSEIF TextType$ = "text" THEN
    END IF
    FOR Csr% = 1 TO LEN(Sentence$)
        ChrNumber% = ASC(MID$(Sentence$, Csr%, 1))
        IF ChrNumber% > 32 THEN
            IF TextColour% <> 30 THEN
                FOR X% = 1 TO 8
                    FOR Y% = 1 TO 11
                        IF ChrSet%(ChrNumber%, X%, Y%) <> 0 THEN
                            gspset TextX% + (X% - 1) + 1, TextY% + (Y% - 1) + 1, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), 16
                        END IF
                    NEXT Y%
                NEXT X%
            END IF
            FOR X% = 1 TO 8
                MoreText% = False
                FOR Y% = 1 TO 11
                    IF ChrSet%(ChrNumber%, X%, Y%) <> 0 THEN
                        gspset TextX% + (X% - 1), TextY% + (Y% - 1), VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), TextColour%
                        MoreText% = True
                    END IF
                    IF MoreText% THEN Add% = X%
                NEXT Y%
            NEXT X%
        END IF
        Add% = 8
        'IF ChrNumber% < 32 OR TextType$ <> "text" THEN Add% = 8
        TextX% = TextX% + Add% + 1
        IF TextX% >= MaxText% THEN
            TextX% = TxtX%
            TextY% = TextY% + 11
        END IF
    NEXT Csr%

END SUB

DEFINT A-Z
SUB RefreshBattle

    DEF SEG = VARSEG(Buffer&(0)): BLOAD "data\battle.bsv", VARPTR(Buffer&(0))
    FOR NumBoxes% = 1 TO 2
        IF NumBoxes% = 1 THEN DialogX% = 0 ELSE DialogX% = 15
        SetTile DialogX% * 16, 8 * 16 + 8, 6
        SetTile DialogX% * 16, 9 * 16 + 8, 7
        SetTile DialogX% * 16, 10 * 16 + 8, 7
        SetTile DialogX% * 16, 11 * 16 + 8, 0
        SetTile ((DialogX% + 1) * 16), 8 * 16 + 8, 5
        SetTile ((DialogX% + 2) * 16), 8 * 16 + 8, 5
        SetTile ((DialogX% + 3) * 16), 8 * 16 + 8, 5
        SetTile ((DialogX% + 4) * 16), 8 * 16 + 8, 4
        SetTile ((DialogX% + 4) * 16), 9 * 16 + 8, 3
        SetTile ((DialogX% + 4) * 16), 10 * 16 + 8, 3
        SetTile ((DialogX% + 4) * 16), 11 * 16 + 8, 2
        SetTile ((DialogX% + 3) * 16), 11 * 16 + 8, 1
        SetTile ((DialogX% + 2) * 16), 11 * 16 + 8, 1
        SetTile ((DialogX% + 1) * 16), 11 * 16 + 8, 1
        gsboxf VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), ((DialogX% + 1) * 16), 9 * 16 + 8, ((DialogX% + 4) * 16), 11 * 16 + 8, 72
    NEXT NumBoxes%
    SetTile 5 * 16, 11 * 16 + 8, 0
    SetTile 5 * 16, 8 * 16 + 8, 6
    SetTile 14 * 16, 8 * 16 + 8, 4
    SetTile 14 * 16, 11 * 16 + 8, 2
    FOR DialogX% = 6 TO 13
        SetTile DialogX% * 16, 8 * 16 + 8, 5
        SetTile DialogX% * 16, 11 * 16 + 8, 1
    NEXT DialogX%
    FOR DialogY% = 9 TO 10
        SetTile 5 * 16, DialogY% * 16 + 8, 7
        SetTile 14 * 16, DialogY% * 16 + 8, 3
    NEXT DialogY%
    ClearBattleDialog
       
    PutText 0, 0, "Attack", 1 * 16, 9 * 16 + 1, 0, 319, 31, "text"
    PutText 0, 0, "Defend", 1 * 16, 9 * 16 + 11, 0, 319, 31, "text"
    PutText 0, 0, "Item", 1 * 16, 10 * 16 + 5, 0, 319, 31, "text"
    PutText 0, 0, "Magic", 1 * 16, 10 * 16 + 15, 0, 319, 31, "text"
    PutText 0, 0, "Escape", 1 * 16, 11 * 16 + 9, 0, 319, 31, "text"

    UpdateStats
    IF PlayerWon% = False THEN SpriteEngine EnemySprite$, EnemyX%, EnemyY%, EnemySize%, 0

END SUB

SUB SaveGame

    FileNum% = FREEFILE
    OPEN "data\save.dat" FOR OUTPUT AS #FileNum%
    WRITE #FileNum%, PlayerHP%, PlayerMaxHP%, PlayerMP%, PlayerMaxMP%, StoryLine%
    WRITE #FileNum%, PlayerST%, PlayerDF%, PlayerAG%, PlayerMS%, PlayerMD%
    WRITE #FileNum%, NextHP%, NextMP%, NextST%, NextDF%, NextAG%, NextMS%, NextMD%
    FOR GetData% = 1 TO 10
        WRITE #FileNum%, Item$(GetData%), Magic$(GetData%)
    NEXT GetData%
    FOR GetData% = 1 TO 41
        WRITE #FileNum%, ChestFlag%(GetData%)
    NEXT GetData%
    WRITE #FileNum%, Medallion%(1), Medallion%(2), Medallion%(3), Medallion%(4)
    CLOSE #FileNum%

END SUB

SUB ScriptCheck

    IF PlayerX% = 37 AND PlayerY% = 4 AND CurrentMap$ = "f1_main" THEN
            IF Medallion%(1) <> 1 OR Medallion%(2) <> 1 OR Medallion%(3) <> 1 OR Medallion%(4) <> 1 THEN
                PutText 0, 0, "An unseen force blocks", 3 * 16, 10 * 16, 0, 319, 31, "text"
                PutText 0, 0, "the way.", 3 * 16, 10 * 16 + 8, 0, 319, 31, "text"
                DaRKShow
                WaitForEnter
                ScriptSafe% = False
            END IF
        ELSEIF PlayerX% = 20 AND PlayerY% = 15 AND CurrentMap$ = "f1_boss" THEN
            CenterText "...you seek my amulet?"
            PutText 0, 0, "...you seek my amulet?", MiddleX%, 10 * 16, 0, 319, 27, "text"
            DaRKShow
            WaitForEnter
            ScrollX1% = 0: ScrollX2% = 0: ScrollY1% = 0: ScrollY2% = 0
            DaRKTileEngine ScrollX1%, ScrollX2%, ScrollY1%, ScrollY2%, 1
            CenterText "Indeed, I do..."
            PutText 0, 0, "Indeed, I do...", MiddleX%, 10 * 16, 0, 319, 31, "text"
            CenterText "...draw your sword!"
            PutText 0, 0, "...draw your sword!", MiddleX%, 10 * 16 + 8, 0, 319, 31, "text"
            DaRKShow
            WaitForEnter
            ScrollX1% = 0: ScrollX2% = 0: ScrollY1% = 0: ScrollY2% = 0
            DaRKTileEngine ScrollX1%, ScrollX2%, ScrollY1%, ScrollY2%, 1
            CenterText "Fool, the amulet restores life..."
            PutText 0, 0, "Fool, the amulet restores life...", MiddleX%, 10 * 16, 0, 319, 27, "text"
            CenterText "...I take it!"
            PutText 0, 0, "...I take it!", MiddleX%, 10 * 16 + 8, 0, 319, 27, "text"
            DaRKShow
            WaitForEnter
            ScrollX1% = 0: ScrollX2% = 0: ScrollY1% = 0: ScrollY2% = 0
            DaRKTileEngine ScrollX1%, ScrollX2%, ScrollY1%, ScrollY2%, 1
            CenterText "Death is the cruelest of lovers."
            PutText 0, 0, "Death is the cruelest of lovers.", MiddleX%, 10 * 16, 0, 319, 27, "text"
            DaRKShow
            WaitForEnter
            Battle 1
            IF BeatBoss% THEN
                ShowEnding
                ExitGame% = True
            END IF
            ScriptSafe% = False
        ELSEIF PlayerX% = 9 AND PlayerY% = 12 AND CurrentMap$ = "f1_pre_1" AND StoryLine% = 0 THEN
            CenterText "...a voice is whispering to me..."
            PutText 0, 0, "...a voice is whispering to me...", MiddleX%, 10 * 16, 0, 319, 31, "text"
            DaRKShow
            WaitForEnter
            ScrollX1% = 0: ScrollX2% = 0: ScrollY1% = 0: ScrollY2% = 0
            DaRKTileEngine ScrollX1%, ScrollX2%, ScrollY1%, ScrollY2%, 1
            CenterText "'Stand below the table with flowers,"
            PutText 0, 0, "'Stand below the table with flowers,", MiddleX%, 10 * 16, 0, 319, 27, "text"
            CenterText "face the bed, and press <ENTER> to"
            PutText 0, 0, "face the bed, and press <ENTER> to", MiddleX%, 10 * 16 + 8, 0, 319, 27, "text"
            CenterText "rest and save.'"
            PutText 0, 0, "rest and save.'", MiddleX%, 11 * 16, 0, 319, 27, "text"
            DaRKShow
            WaitForEnter
            ScrollX1% = 0: ScrollX2% = 0: ScrollY1% = 0: ScrollY2% = 0
            DaRKTileEngine ScrollX1%, ScrollX2%, ScrollY1%, ScrollY2%, 1
            CenterText "...strange."
            PutText 0, 0, "...strange.", MiddleX%, 10 * 16, 0, 319, 31, "text"
            DaRKShow
            WaitForEnter
            StoryLine% = 1: ScriptSafe% = False
    END IF

END SUB

SUB SelectMenuItem (MenuType%)

    IF MenuType% > 2 THEN DrawBattleMenu MenuType%
    PointerX% = 0 * 16: PointerY% = 2 * 16
    DaRKShow
    GET (PointerX%, PointerY%)-(PointerX% + 15, PointerY% + 15), SpriteBack%
    SpriteEngine "pointer.set", PointerX%, PointerY%, 130, 0
    DescribeItem ((PointerY% / 16) - 1), MenuType%
    DaRKShow
    WHILE MultiKey(1): WEND

    ExitMenu% = False
    DO
        IF MultiKey(72) THEN
            gssprite PointerX%, PointerY%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(SpriteBack%(0)), VARPTR(SpriteBack%(0))
            IF PointerY% <> 2 * 16 THEN
                GET (PointerX%, PointerY% - 16)-(PointerX% + 15, PointerY% - 1), SpriteBack%
                PointerY% = PointerY% - 16
            END IF
            DescribeItem ((PointerY% / 16) - 1), MenuType%
            SpriteEngine "pointer.set", PointerX%, PointerY%, 130, 0
            DaRKShow
            WHILE MultiKey(72): WEND
        ELSEIF MultiKey(80) THEN
            gssprite PointerX%, PointerY%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(SpriteBack%(0)), VARPTR(SpriteBack%(0))
            IF PointerY% <> 11 * 16 THEN
                GET (PointerX%, PointerY% + 16)-(PointerX% + 15, PointerY% + 31), SpriteBack%
                PointerY% = PointerY% + 16
            END IF
            DescribeItem ((PointerY% / 16) - 1), MenuType%
            SpriteEngine "pointer.set", PointerX%, PointerY%, 130, 0
            DaRKShow
            WHILE MultiKey(80): WEND
        ELSEIF MultiKey(28) THEN
            WHILE MultiKey(28): WEND
            IF MenuType% = 1 OR MenuType% = 3 THEN
                    IF Item$((PointerY% / 16) - 1) <> "" THEN
                        MadeChoice% = True
                        SlotSelected% = (PointerY% / 16) - 1
                        IF Item$(SlotSelected%) = "Potion" THEN
                                PlayerHP% = PlayerHP% + 50: AttackUsed$ = "Potion"
                                IF PlayerHP% > PlayerMaxHP% THEN PlayerHP% = PlayerMaxHP%
                                Item$(SlotSelected%) = "": ExitMenu% = True
                            ELSEIF Item$(SlotSelected%) = "ExPotion" THEN
                                PlayerHP% = PlayerHP% + 100: AttackUsed$ = "ExPotion"
                                IF PlayerHP% > PlayerMaxHP% THEN PlayerHP% = PlayerMaxHP%
                                Item$(SlotSelected%) = "": ExitMenu% = True
                            ELSEIF Item$(SlotSelected%) = "MegaPotion" THEN
                                PlayerHP% = PlayerHP% + 250: AttackUsed$ = "MegaPotion"
                                IF PlayerHP% > PlayerMaxHP% THEN PlayerHP% = PlayerMaxHP%
                                Item$(SlotSelected%) = "": ExitMenu% = True
                            ELSEIF Item$(SlotSelected%) = "Ethere" THEN
                                PlayerMP% = PlayerMP% + 10: AttackUsed$ = "Ethere"
                                IF PlayerMP% > PlayerMaxMP% THEN PlayerMP% = PlayerMaxMP%
                                Item$(SlotSelected%) = "": ExitMenu% = True
                            ELSEIF Item$(SlotSelected%) = "ExEthere" THEN
                                PlayerMP% = PlayerMP% + 50: AttackUsed$ = "ExEthere"
                                IF PlayerMP% > PlayerMaxMP% THEN PlayerMP% = PlayerMaxMP%
                                Item$(SlotSelected%) = "": ExitMenu% = True
                            ELSEIF Item$(SlotSelected%) = "MegaEthere" THEN
                                PlayerMP% = PlayerMP% + 75: AttackUsed$ = "MegaEthere"
                                IF PlayerMP% > PlayerMaxMP% THEN PlayerMP% = PlayerMaxMP%
                                Item$(SlotSelected%) = "": ExitMenu% = True
                            ELSEIF Item$(SlotSelected%) = "Elixir" THEN
                                PlayerHP% = PlayerMaxHP%: AttackUsed$ = "Elixir"
                                PlayerMP% = PlayerMaxMP%
                                Item$(SlotSelected%) = "": ExitMenu% = True
                        END IF
                    END IF
                ELSEIF MenuType% = 2 OR MenuType% = 4 THEN
                    IF Magic$((PointerY% / 16) - 1) <> "" AND PlayerMP% >= MPNeed%((PointerY% / 16) - 1) THEN
                        MadeChoice% = True
                        SlotSelected% = (PointerY% / 16) - 1
                        IF Magic$(SlotSelected%) = "Cure" AND PlayerMP% >= 2 AND PlayerHP% < PlayerMaxHP% THEN
                                PlayerDamage% = PlayerMS% * 4
                                PlayerHP% = PlayerHP% + (PlayerMS% * 4)
                                IF PlayerHP% > PlayerMaxHP% THEN PlayerHP% = PlayerMaxHP%
                                PlayerMP% = PlayerMP% - 2: AttackUsed$ = "Cure": ExitMenu% = True
                            ELSEIF Magic$(SlotSelected%) = "ExCure" AND PlayerMP% >= 4 AND PlayerHP% < PlayerMaxHP% THEN
                                PlayerDamage% = PlayerMS% * 8
                                PlayerHP% = PlayerHP% + (PlayerMS% * 8)
                                IF PlayerHP% > PlayerMaxHP% THEN PlayerHP% = PlayerMaxHP%
                                PlayerMP% = PlayerMP% - 4: AttackUsed$ = "ExCure": ExitMenu% = True
                            ELSEIF Magic$(SlotSelected%) = "MegaCure" AND PlayerMP% >= 8 AND PlayerHP% < PlayerMaxHP% THEN
                                PlayerDamage% = PlayerMS% * 16
                                PlayerHP% = PlayerHP% + (PlayerMS% * 16)
                                IF PlayerHP% > PlayerMaxHP% THEN PlayerHP% = PlayerMaxHP%
                                PlayerMP% = PlayerMP% - 8: AttackUsed$ = "MegaCure": ExitMenu% = True
                            ELSEIF Magic$(SlotSelected%) = "Fire" AND PlayerMP% >= 3 AND MenuType% = 4 THEN
                                PlayerDamage% = PlayerMS% * 6 + (INT(RND * 5) + 1) - EMD% * 2 + (INT(RND * 5) + 1)
                                PlayerMP% = PlayerMP% - 3: AttackUsed$ = "Fire": ExitMenu% = True
                            ELSEIF Magic$(SlotSelected%) = "ExFire" AND PlayerMP% >= 6 AND MenuType% = 4 THEN
                                PlayerDamage% = PlayerMS% * 10 + (INT(RND * 5) + 1) - EMD% * 2 + (INT(RND * 5) + 1)
                                PlayerMP% = PlayerMP% - 6: AttackUsed$ = "ExFire": ExitMenu% = True
                            ELSEIF Magic$(SlotSelected%) = "MegaFire" AND PlayerMP% >= 12 AND MenuType% = 4 THEN
                                PlayerDamage% = PlayerMS% * 16 + (INT(RND * 5) + 1) - EMD% * 2 + (INT(RND * 5) + 1)
                                PlayerMP% = PlayerMP% - 12: AttackUsed$ = "MegaFire": ExitMenu% = True
                            ELSEIF Magic$(SlotSelected%) = "StoneRain" AND PlayerMP% >= 15 AND MenuType% = 4 THEN
                                PlayerDamage% = PlayerMS% * 19 + (INT(RND * 5) + 1) - EMD% * 2 + (INT(RND * 5) + 1)
                                PlayerMP% = PlayerMP% - 15: AttackUsed$ = "StoneRain": ExitMenu% = True
                            ELSEIF Magic$(SlotSelected%) = "HolyRain" AND PlayerMP% >= 16 AND MenuType% = 4 THEN
                                PlayerDamage% = PlayerMS% * 21 + (INT(RND * 5) + 1) - EMD% * 2 + (INT(RND * 5) + 1)
                                PlayerMP% = PlayerMP% - 16: AttackUsed$ = "HolyRain": ExitMenu% = True
                            ELSEIF Magic$(SlotSelected%) = "DarkRain" AND PlayerMP% >= 18 AND MenuType% = 4 THEN
                                PlayerDamage% = PlayerMS% * 24 + (INT(RND * 5) + 1) - EMD% * 2 + (INT(RND * 5) + 1)
                                PlayerMP% = PlayerMP% - 18: AttackUsed$ = "DarkRain": ExitMenu% = True
                            ELSEIF Magic$(SlotSelected%) = "Osmose" AND PlayerMP% >= 1 AND MenuType% = 4 THEN
                                PlayerDamage% = INT(EMP% * .5): EMP% = EMP% - INT(EMP% * .5)
                                PlayerMP% = PlayerMP% + (PlayerDamage% - 4): AttackUsed$ = "Osmose": ExitMenu% = True
                                IF PlayerMP% > PlayerMaxMP% THEN PlayerMP% = PlayerMaxMP%
                        END IF
                    END IF
            END IF
        ELSEIF MultiKey(1) THEN
            ExitMenu% = True
        END IF
    LOOP UNTIL ExitMenu%

END SUB

SUB SetEnemyBack (SpriteX%, SpriteY%)

    gssprite SpriteX%, SpriteY%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(EnemyBack%(0)), VARPTR(EnemyBack%(0))

END SUB

SUB SetTile (SpriteX%, SpriteY%, SpriteNum%)

    gssprite SpriteX%, SpriteY%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(DialogBox%(SpriteNum% * 130)), VARPTR(DialogBox%(SpriteNum% * 130))

END SUB

SUB ShakeEnemy

    DaRKShow
    SetEnemyBack 111, 1
    SpriteEngine EnemySprite$, EnemyX% - 2, EnemyY%, EnemySize%, 0
    DaRKShow
    gswait 5
    SetEnemyBack 111, 1
    SpriteEngine EnemySprite$, EnemyX% + 2, EnemyY%, EnemySize%, 0
    DaRKShow
    gswait 5
    SetEnemyBack 111, 1
    SpriteEngine EnemySprite$, EnemyX%, EnemyY%, EnemySize%, 0
    DaRKShow

END SUB

SUB ShakeScreen

    Delay% = 31999
    
    FOR Shake% = 1 TO Delay%
        Pause% = Pause% + 1
        IF Pause% = 1250 THEN
            gswait 1: Pause% = 0
        END IF
        OUT &H3D4, 8: OUT &H3D5, Shake%
    NEXT Shake%
    
    OUT &H3D4, 8: OUT &H3D5, 0

END SUB

SUB ShowEnding

    Fade 1, Pal&()
    DEF SEG = VARSEG(Buffer&(0)): BLOAD "data\outro.bsv", VARPTR(Buffer&(0))
    DaRKShow
    Fade 0, Pal&()
    WaitForEnter
    FOR Credit% = 1 TO 6
        Fade 1, Pal&()
        CreditNum$ = RTRIM$(LTRIM$(STR$(Credit%)))
        DEF SEG = VARSEG(Buffer&(0)): BLOAD "data\end" + CreditNum$ + ".bsv", VARPTR(Buffer&(0))
        DaRKShow
        Fade 0, Pal&()
        SLEEP 3
    NEXT Credit%
    Fade 1, Pal&()
    DEF SEG = VARSEG(Buffer&(0)): BLOAD "data\end.bsv", VARPTR(Buffer&(0))
    DaRKShow
    Fade 0, Pal&()
    WaitForEnter

END SUB

SUB ShowMagic

    MagicX% = 0: MagicY% = 0: MagicFrame% = 0
    IF AttackUsed$ = "Fire" THEN
            FOR MagicFrame% = 0 TO 5
                DaRKShow
                SetEnemyBack 111, 1
                SpriteEngine EnemySprite$, EnemyX%, EnemyY%, EnemySize%, 0
                SpriteEngine "n_fire.set", 143, 62, 32 * 32 / 2 + 2, MagicFrame%
                DaRKShow
                gswait 10
            NEXT MagicFrame%
        ELSEIF AttackUsed$ = "ExFire" THEN
            MagicFrame% = 2
            FOR MagicX% = 76 TO 143 STEP 2
                    IF MagicFrame% = 2 THEN MagicFrame% = 3 ELSE MagicFrame% = 2
                    RefreshBattle
                    SpriteEngine "n_exfire.set", MagicX%, MagicY%, 514, MagicFrame%
                    DaRKShow
                    gswait 1
                    MagicY% = MagicY% + 2
            NEXT MagicX%
            RefreshBattle
            FOR MagicFrame% = 0 TO 5
                DaRKShow
                SetEnemyBack 111, 1
                SpriteEngine EnemySprite$, EnemyX%, EnemyY%, EnemySize%, 0
                SpriteEngine "n_fire.set", 143, 62, 32 * 32 / 2 + 2, MagicFrame%
                DaRKShow
                gswait 10
            NEXT MagicFrame%
            MagicFrame% = 0: MagicY% = 0
            Colour& = (65536 * 63) + (256 * 63) + (63)
            PALETTE 0, Colour&
            gswait 10
            PALETTE 0, 0
            ShakeEnemy
            FOR MagicX% = 210 TO 143 STEP -2
                    IF MagicFrame% = 0 THEN MagicFrame% = 1 ELSE MagicFrame% = 0
                    RefreshBattle
                    SpriteEngine "n_exfire.set", MagicX%, MagicY%, 514, MagicFrame%
                    DaRKShow
                    gswait 1
                    MagicY% = MagicY% + 2
            NEXT MagicX%
            RefreshBattle
            FOR MagicFrame% = 0 TO 5
                DaRKShow
                SetEnemyBack 111, 1
                SpriteEngine EnemySprite$, EnemyX%, EnemyY%, EnemySize%, 0
                SpriteEngine "n_fire.set", 143, 62, 32 * 32 / 2 + 2, MagicFrame%
                DaRKShow
                gswait 10
            NEXT MagicFrame%
            Colour& = (65536 * 63) + (256 * 63) + (63)
            PALETTE 0, Colour&
            gswait 5
            PALETTE 0, 0
        ELSEIF AttackUsed$ = "MegaFire" THEN
            FOR MagicFrame% = 0 TO 2
                FOR MagicX% = 0 TO 320 STEP 32
                    SpriteEngine "n_megafi.set", MagicX%, 80, 514, MagicFrame%
                NEXT MagicX%
                DaRKShow
                gswait 30
            NEXT MagicFrame%
            FOR NumColumn% = 1 TO 4
                RefreshBattle
                FOR MagicX% = 0 TO 320 STEP 32
                    SpriteEngine "n_megafi.set", MagicX%, 80, 514, 2
                NEXT MagicX%
                IF NumColumn% = 1 THEN MagicX% = 32 * 1 ELSE IF NumColumn% = 2 THEN MagicX% = 32 * 8 ELSE IF NumColumn% = 3 THEN MagicX% = 32 * 4 ELSE MagicX% = 32 * 5
                FOR MagicY% = 80 TO -31 STEP -32
                    IF MagicY% = 80 THEN MagicFrame% = 3 ELSE MagicFrame% = 4
                    SpriteEngine "n_megafi.set", MagicX%, MagicY%, 514, MagicFrame%
                    DaRKShow
                    gswait 10
                NEXT MagicY%
                gswait 30
            NEXT NumColumn%
            FOR MagicFrame% = 2 TO 0 STEP -1
                RefreshBattle
                FOR MagicX% = 0 TO 320 STEP 32
                    SpriteEngine "n_megafi.set", MagicX%, 80, 514, MagicFrame%
                NEXT MagicX%
                DaRKShow
                gswait 30
            NEXT MagicFrame%
            RefreshBattle
        ELSEIF AttackUsed$ = "StoneRain" THEN
            FOR NumColumn% = 1 TO 4
                IF NumColumn% = 1 THEN MagicX% = 32 * 1 ELSE IF NumColumn% = 2 THEN MagicX% = 32 * 8 ELSE IF NumColumn% = 3 THEN MagicX% = 32 * 4 ELSE MagicX% = 32 * 5
                FOR MagicY% = -32 TO 62 STEP 2
                    RefreshBattle
                    SpriteEngine "n_stone.set", MagicX%, MagicY%, 514, 0
                    DaRKShow
                    gswait 1
                NEXT MagicY%
                FOR MagicFrame% = 1 TO 2
                    RefreshBattle
                    SpriteEngine "n_stone.set", MagicX%, MagicY%, 514, MagicFrame%
                    DaRKShow
                    gswait 10
                NEXT MagicFrame%
            NEXT NumColumn%
            RefreshBattle
        ELSEIF AttackUsed$ = "HolyRain" THEN
            FOR NumStars% = 1 TO 10
                MagicX% = INT(RND * 304): MagicFrame% = 0
                FOR MagicY% = -16 TO 78 STEP 2
                    RefreshBattle
                    MagicFrame% = MagicFrame% + 1
                    IF MagicFrame% = 4 THEN MagicFrame% = 0
                    SpriteEngine "n_holy.set", MagicX%, MagicY%, 130, MagicFrame%
                    DaRKShow
                    gswait 1
                NEXT MagicY%
                RefreshBattle
                FOR MagicY% = 78 TO -16 STEP -16
                    IF MagicY% = 78 THEN MagicFrame% = 4 ELSE MagicFrame% = 5
                    SpriteEngine "n_holy.set", MagicX%, MagicY%, 130, MagicFrame%
                    DaRKShow
                    gswait 1
                NEXT MagicY%
            NEXT NumStars%
            RefreshBattle
        ELSEIF AttackUsed$ = "DarkRain" THEN
            FOR NumStars% = 1 TO 10
                MagicX% = INT(RND * 304): MagicFrame% = 0
                FOR MagicY% = 0 TO 78 STEP 32
                    MagicFrame% = MagicFrame% + 1
                    IF MagicFrame% = 2 THEN MagicFrame% = 0
                    IF MagicY% >= 78 THEN MagicFrame% = 2
                    SpriteEngine "n_darkra.set", MagicX%, MagicY%, 514, MagicFrame%
                    DaRKShow
                    gswait 5
                NEXT MagicY%
                gswait 10
                RefreshBattle
            NEXT NumStars%
            RefreshBattle
        ELSEIF AttackUsed$ = "Osmose" THEN
            FOR NumTurns% = 1 TO 5
                FOR NumMagic% = 1 TO 3
                    RefreshBattle
                    SpriteEngine "n_osmose.set", 119, 64, 514, NumMagic% - 1
                    SpriteEngine "n_osmose.set", 179, 64, 514, NumMagic% + 2
                    DaRKShow
                    gswait 5
                NEXT NumMagic%
            NEXT NumTurns%
            RefreshBattle
    END IF
    ShakeEnemy

END SUB

SUB ShowTitleScreen

    Fade 1, Pal&()
    DEF SEG = VARSEG(Buffer&(0)): BLOAD "data\logo.bsv", VARPTR(Buffer&(0))
    DaRKShow
    Fade 0, Pal&()
    PointerX% = 15: PointerY% = 85
    SLEEP 3
    Fade 1, Pal&()
    DEF SEG = VARSEG(Buffer&(0)): BLOAD "data\title.bsv", VARPTR(Buffer&(0))
    DaRKShow
    Fade 0, Pal&()
    SpriteEngine "pointer.set", PointerX%, PointerY%, 130, 0
    DaRKShow

    DO
        IF MultiKey(72) THEN
            IF PointerY% <> 85 THEN
                PointerY% = PointerY% - 20
                DEF SEG = VARSEG(Buffer&(0)): BLOAD "data\title.bsv", VARPTR(Buffer&(0))
                SpriteEngine "pointer.set", PointerX%, PointerY%, 130, 0
                DaRKShow
            END IF
            WHILE MultiKey(72): WEND
        ELSEIF MultiKey(80) THEN
            IF PointerY% <> 125 THEN
                PointerY% = PointerY% + 20
                DEF SEG = VARSEG(Buffer&(0)): BLOAD "data\title.bsv", VARPTR(Buffer&(0))
                SpriteEngine "pointer.set", PointerX%, PointerY%, 130, 0
                DaRKShow
            END IF
            WHILE MultiKey(80): WEND
        ELSEIF MultiKey(28) THEN
            WHILE MultiKey(28): WEND
            IF PointerY% = 85 THEN
                    DEF SEG = VARSEG(Buffer&(0)): BLOAD "data\intro.bsv", VARPTR(Buffer&(0))
                    Fade 1, Pal&()
                    DaRKShow
                    Fade 0, Pal&()
                    WaitForEnter
                    DaRKLoadMap "data\nocturne.set", "data\f1_pre.map"
                    DarkLoadEnemies "data\f1_pre.dat"
                    Main
                    ExitMenu% = True
                ELSEIF PointerY% = 105 THEN
                    LoadGame
                    Main
                    ExitMenu% = True
                ELSEIF PointerY% = 125 THEN
                    ExitMenu% = True
            END IF
        END IF
    LOOP UNTIL ExitMenu%

END SUB

DEFSNG A-Z
SUB SpriteEngine (SpriteName$, SpriteX%, SpriteY%, SpriteSize%, SpriteNum%)

    DEF SEG = VARSEG(Sprite%(0)): BLOAD "data\" + SpriteName$, VARPTR(Sprite%(0))
    gssprite SpriteX%, SpriteY%, VARSEG(Buffer&(0)), VARPTR(Buffer&(0)), VARSEG(Sprite%(SpriteNum% * SpriteSize%)), VARPTR(Sprite%(SpriteNum% * SpriteSize%))

END SUB

DEFINT A-Z
SUB UpdateStats

    ClearStatBox
    PutText 0, 0, "HP", 16 * 16 - 8, 9 * 16 + 1, 0, 319, 31, "text"
    PutText 0, 0, "/", 18 * 16 - 9, 9 * 16 + 11, 0, 319, 31, "text"
    PutText PlayerMaxHP%, 0, "", 18 * 16, 9 * 16 + 11, 3, 319, 31, "int"
    PutText PlayerHP%, 0, "", 16 * 16 - 4, 9 * 16 + 11, 3, 319, 31, "int"
    PutText 0, 0, "MP", 16 * 16 - 8, 10 * 16 + 13, 0, 319, 31, "text"
    PutText 0, 0, "/", 18 * 16, 11 * 16 + 7, 0, 319, 31, "text"
    PutText PlayerMaxMP%, 0, "", 18 * 16 + 9, 11 * 16 + 7, 2, 319, 31, "int"
    PutText PlayerMP%, 0, "", 17 * 16 - 3, 11 * 16 + 7, 2, 319, 31, "int"

END SUB

SUB WaitForEnter

    WHILE MultiKey(28) = 0: WEND
    WHILE MultiKey(28) = 1: WEND

END SUB

