/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 2)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "door")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
/******************************************************************************/
(instance public rm002 of Rm
	(properties
		picture scriptNumber
		north 0
		east 0
		south 0
		west 0
	)
	(method (init)
		(super:init())
		(self:setScript(RoomScript))

        (send gEgo:
		  posn(164 80)
		  loop(2)
          hide()
            //ignoreControl(ctlCYAN)
            //ignoreControl(ctlBLUE)
        )
        (LockerDoor:init())

		(send gEgo:init())
        (RoomScript:changeState(10))
	)
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
    (method (changeState newState)
        (var mbResult)
        = state newState
        (switch(state)
            (case 10
                (LockerDoor:open())
                = cycles 4
            )
            (case 11
                (send gEgo:
                    show()
                    setMotion(MoveTo 160 144)
                )
                = cycles 40
            )
            (case 12
                Print("Congratulations! You have completed LockerGnome Quest!")
                Print("Make your own games for free just like this with SCI Studio!\n\nGo to: http://www.BriPro.com")
                Print("The End" #font LARGE_FONT)

  				(while(1)
  					= mbResult Print(
  						"What would you like to do now?"
  						#title "Thank you for playing!"
  						#button "Play Again"  1
  						#button "  Quit  " 2
  					)
  					(switch(mbResult)
		    			(case 1
  							(send gGame:restart())
  							return
		    			)
		    			(case 2
		    				= gQuitGame TRUE
		    				return
		    			)
		    		)
		    	)
            )
        )
    )
)
/******************************************************************************/
(instance LockerDoor of Door
  (properties
    y 104
    x 166
    view 10
  )
)
/******************************************************************************/
