-----------------------------------------------------------------------------
-- bldmap.ex                                                               --
-- Build maps for rpg.ex                                                   --
--                                                                         --
-- written by Mike Wever                                                   --
-----------------------------------------------------------------------------

include graphics.e
include image.e
include get.e
include wildcard.e

include rpgglob.e
include rpgtrn.e
include rpgmap.e
include rpgscrn.e
include rpgwin.e
include rpgitem.e
include rpgchar.e
include rpgmnstr.e
include rpggen.e
include rpgspcl.e

sequence Select
Select = 
{ {  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7 },
  {  7,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16, 7 },
  {  7,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16, 7 },
  {  7,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16, 7 },
  {  7,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16, 7 },
  {  7,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16, 7 },
  {  7,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16, 7 },
  {  7,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16, 7 },
  {  7,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16, 7 },
  {  7,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16, 7 },
  {  7,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16, 7 },
  {  7,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16, 7 },
  {  7,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16, 7 },
  {  7,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16, 7 },
  {  7,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16, 7 },
  {  7,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16, 7 },
  {  7,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16, 7 },
  {  7,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16, 7 },
  {  7,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16, 7 },
  {  7,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16, 7 },
  {  7,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16, 7 },
  {  7,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16, 7 },
  {  7,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16, 7 },
  {  7,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16, 7 },
  {  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7 } }

sequence SelPos
SelPos = {1,1}

sequence ImpassableMark
ImpassableMark = 
{ { 16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16 },
  { 16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16 },
  { 16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16 },
  { 16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16 },
  { 16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16 },
  { 16,16, 0, 0,16,16,16,16,16,16,16,16,16,16,16,16, 0, 0,16,16 },
  { 16,16, 0, 7, 0,16,16,16,16,16,16,16,16,16,16, 0, 7, 0,16,16 },
  { 16,16, 0, 7, 7, 0,16,16,16,16,16,16,16,16, 0, 7, 7, 0,16,16 },
  { 16,16,16, 0, 7, 7, 0,16,16,16,16,16,16, 0, 7, 7, 0,16,16,16 },
  { 16,16,16,16, 0, 7, 7, 0,16,16,16,16, 0, 7, 7, 0,16,16,16,16 },
  { 16,16,16,16,16, 0, 7, 7, 0,16,16, 0, 7, 7, 0,16,16,16,16,16 },
  { 16,16,16,16,16,16, 0, 7, 7, 0, 0, 7, 7, 0,16,16,16,16,16,16 },
  { 16,16,16,16,16,16,16, 0, 7, 7, 7, 7, 0,16,16,16,16,16,16,16 },
  { 16,16,16,16,16,16,16,16, 0, 7, 7, 0,16,16,16,16,16,16,16,16 },
  { 16,16,16,16,16,16,16, 0, 7, 7, 7, 7, 0,16,16,16,16,16,16,16 },
  { 16,16,16,16,16,16, 0, 7, 7, 0, 0, 7, 7, 0,16,16,16,16,16,16 },
  { 16,16,16,16,16, 0, 7, 7, 0,16,16, 0, 7, 7, 0,16,16,16,16,16 },
  { 16,16,16,16, 0, 7, 7, 0,16,16,16,16, 0, 7, 7, 0,16,16,16,16 },
  { 16,16,16, 0, 7, 7, 0,16,16,16,16,16,16, 0, 7, 7, 0,16,16,16 },
  { 16,16, 0, 7, 7, 0,16,16,16,16,16,16,16,16, 0, 7, 7, 0,16,16 },
  { 16,16, 0, 0, 0,16,16,16,16,16,16,16,16,16,16, 0, 0, 0,16,16 },
  { 16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16 },
  { 16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16 },
  { 16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16 },
  { 16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16 } }

sequence Numbers
Numbers = 
{ { "  XXX  ",
    " X   X ",
    " X   X ",
    " X   X ",
    " X   X ",
    " X   X ",
    "  XXX  " },
 {  "   X   ",
    "  XX   ",
    "   X   ",
    "   X   ",
    "   X   ",
    "   X   ",
    "  XXX  " },
 {  "  XXX  ",
    " X   X ",
    "     X ",
    "    X  ",
    "   X   ",
    "  X    ",
    " XXXXX " },
 {  "  XXX  ",
    " X   X ",
    "     X ",
    "   XX  ",
    "     X ",
    " X   X ",
    "  XXX  " },
 {  " X   X ",
    " X   X ",
    " X   X ",
    " XXXXX ",
    "     X ",
    "     X ",
    "     X " },
 {  " XXXXX ",
    " X     ",
    " X     ",
    " XXXX  ",
    "     X ",
    "     X ",
    " XXXX  " },
 {  "  XXX  ",
    " X   X ",
    " X     ",
    " XXXX  ",
    " X   X ",
    " X   X ",
    "  XXX  " },
 {  " XXXXX ",
    "     X ",
    "    X  ",
    "    X  ",
    "   X   ",
    "   X   ",
    "   X   " },
 {  "  XXX  ",
    " X   X ",
    " X   X ",
    "  XXX  ",
    " X   X ",
    " X   X ",
    "  XXX  " },
 {  "  XXX  ",
    " X   X ",
    " X   X ",
    "  XXXX ",
    "     X ",
    " X   X ",
    "  XXX  " } }


-- set resolution of time() to 1/100th of a second
tick_rate(100)

sequence Map, MapSize, MapName
Map = repeat(repeat({1,1,0,1},80),80)
MapSize = {80,80}
MapName = ""

sequence Message
Message = ""

integer LastTerrain
LastTerrain = 1

integer LastZone
LastZone = 1

integer InfoFlag
InfoFlag = 1

-----------------------------------------------------------------------------
-- Draw a tile at a given location                                         --
-----------------------------------------------------------------------------
procedure drawTile(sequence loc, integer t)
  for i = 0 to length(Terrain[t]) - 1 do
    SetPixels(BACK_SCREEN,Terrain[t][i + 1],{loc[1],loc[2] + i})
  end for
end procedure

-----------------------------------------------------------------------------
-- Change the selection position.                                          --
-----------------------------------------------------------------------------
procedure moveSel(sequence change)
  SelPos += change
  if SelPos[1] < 1 then
    SelPos[1] = 1
  elsif SelPos[1] > MapSize[1] then
    SelPos[1] = MapSize[1]
  end if
  if SelPos[2] < 1 then
    SelPos[2] = 1
  elsif SelPos[2] > MapSize[2] then
    SelPos[2] = MapSize[2]
  end if
end procedure

-----------------------------------------------------------------------------
-- Draw the selection box at a given location                              --
-----------------------------------------------------------------------------
procedure drawSel(sequence loc)
  for i = 0 to length(Select) - 1 do
    for ii = 0 to length(Select[i + 1]) - 1 do
      if Select[i + 1][ii + 1] != 16 then
        SetPixels(BACK_SCREEN,Select[i + 1][ii + 1],{loc[1] + ii,loc[2] + i})
      end if
    end for
  end for
end procedure

-----------------------------------------------------------------------------
-- Draw the impassable mark at a given location                            --
-----------------------------------------------------------------------------
procedure drawImpassableMark(sequence loc)
  for i = 0 to length(ImpassableMark) - 1 do
    for ii = 0 to length(ImpassableMark[i + 1]) - 1 do
      if ImpassableMark[i + 1][ii + 1] != 16 then
        SetPixels(BACK_SCREEN,ImpassableMark[i + 1][ii + 1],{loc[1] + ii,loc[2] + i})
      end if
    end for
  end for
end procedure

-----------------------------------------------------------------------------
-- Draw number at a given location                                         --
-----------------------------------------------------------------------------
procedure drawNumber(sequence loc, integer num, integer color)
  for i = 0 to length(Numbers[num + 1]) - 1 do
    for ii = 0 to length(Numbers[num + 1][i + 1]) - 1 do
      if Numbers[num + 1][i + 1][ii + 1] != ' ' then
        SetPixels(BACK_SCREEN,color,{loc[1] + ii,loc[2] + i})
      else
        SetPixels(BACK_SCREEN,RPG_WHITE,{loc[1] + ii,loc[2] + i})
      end if
    end for
  end for
end procedure

-----------------------------------------------------------------------------
-- Draw a large-scale map.                                                 --
-----------------------------------------------------------------------------
procedure drawLargeMap()
  atom k
  
  for y = 1 to MapSize[2] do
    for x = 1 to MapSize[1] do
      SetPixels(BACK_SCREEN,TerrainMini[Map[y][x][MAP_TERRAIN]],{x,y})
    end for
  end for
  FlipScreen()
  k = wait_key()
end procedure

-----------------------------------------------------------------------------
-- Paint the terrain and selection box on the screen.                      --
-----------------------------------------------------------------------------
procedure paintScreen()
  integer startX, endX, startY, endY
  integer x, y, x1, y1
  integer n
  
  startY = SelPos[2] - (TilesPerHalfScreen[2])
  if startY > MapSize[2] - (TilesPerScreen[2] - 1) then
    startY = MapSize[2] - (TilesPerScreen[2] - 1)
  end if
  if startY < 1 then
    startY = 1
  end if
  endY = startY + (TilesPerScreen[2] - 1)
  if endY > MapSize[2] then
    endY = MapSize[2]
  end if
  startX = SelPos[1] - (TilesPerHalfScreen[1])
  if startX > MapSize[1] - (TilesPerScreen[1] - 1) then
    startX = MapSize[1] - (TilesPerScreen[1] - 1)
  end if
  if startX < 1 then
    startX = 1
  end if
  endX = startX + (TilesPerScreen[1] - 1)
  if endX > MapSize[1] then
    endX = MapSize[1]
  end if
  x = 0
  y = 0
  for i = startY to endY do
    for ii = startX to endX do
      drawTile({x,y},Map[i][ii][MAP_TERRAIN])
      if InfoFlag then
        if Map[i][ii][MAP_PASSABLE] = IMPASSABLE then
          drawImpassableMark({x,y})
        end if
--				drawNumber({x + 1, y + 1}, Map[i][ii][MAP_ZONE],RPG_BLUE)
        x1 = x + 1
        y1 = y + 1
        if Map[i][ii][MAP_ZONE] > 9 then
          n = floor(Map[i][ii][MAP_ZONE] / 10)
          drawNumber({x1,y1},n,RPG_BLUE)
          x1 += 7
        end if
        n = remainder(Map[i][ii][MAP_ZONE],10)
        drawNumber({x1,y1},n,RPG_BLUE)
        if Map[i][ii][MAP_SPECIAL] then
          x1 = x + 1
          y1 = y + (TILE_SIZE[2] - 8)
          if Map[i][ii][MAP_SPECIAL] > 9 then
            n = floor(Map[i][ii][MAP_SPECIAL] / 10)
            drawNumber({x1,y1},n,RPG_BLACK)
            x1 += 7
          end if
          n = remainder(Map[i][ii][MAP_SPECIAL],10)
          drawNumber({x1,y1},n,RPG_BLACK)
        end if
      end if
      x += TILE_SIZE[1]
    end for
    x = 0
    y += TILE_SIZE[2]
  end for
  x = (SelPos[1] - startX) * TILE_SIZE[1]
  y = (SelPos[2] - startY) * TILE_SIZE[2]
  drawSel({x,y})
  FlipScreen()
end procedure

-----------------------------------------------------------------------------
-- Display a message in the first text line of the screen.                 --
-----------------------------------------------------------------------------
procedure bmMsg(sequence text)
  position(1,1)
  puts(1,repeat(' ',80))
  position(1,1)
  puts(1,text)
end procedure

-----------------------------------------------------------------------------
-- Prompt the user in the first text line of the screen.                   --
-----------------------------------------------------------------------------
function bmPrompt(sequence text)
  position(1,1)
  puts(1,repeat(' ',80))
  position(1,1)
  return prompt_string(text)
end function

-----------------------------------------------------------------------------
-- Prompt the user for a number in the first text line of the screen.      --
-----------------------------------------------------------------------------
function bmPromptNum(sequence text, sequence range)
  position(1,1)
  puts(1,repeat(' ',80))
  position(1,1)
  return prompt_number(text,range)
end function

-----------------------------------------------------------------------------
-- Prompt the user for yes or no in the first text line of the screen.     --
-----------------------------------------------------------------------------
function bmYesNoPrompt(sequence text)
  integer k
  
  position(1,1)
  puts(1,repeat(' ',80))
  position(1,1)
  puts(1,text & "(y/n)")
  k = 0
  while k != 'y' and k != 'n' do
    k = lower(wait_key())
  end while
  return k
end function

-----------------------------------------------------------------------------
-- Save the map                                                            --
-----------------------------------------------------------------------------
procedure saveMap(sequence fileName)
  atom fn
  sequence wFileName
  integer d, valid
  integer resp
  integer ap
  sequence l, s
  integer indent

  ap = get_active_page()
  set_active_page(get_display_page())
  
  if length(fileName) = 0 then
    fileName = bmPrompt("Save as: ")
    valid = 0
    while not valid do
      valid = 1
      d = find('.',fileName)
      if d then
        if d = 1 or d > 9 then
          valid = 0
        else
          if length(fileName) - d > 4 then
            valid = 0
          end if
        end if
      else
        if length(fileName) = 0 or length(fileName) > 8 then
          valid = 0
        end if
      end if
      if d = 0 then
        fileName &= ".e"
      end if
      if not valid then
        fileName = bmPrompt("Invalid file name.  Save as: ")
      end if
    end while
  end if
  fn = open(fileName,"r")
  if length(fileName) > 0 and not equal(fileName,MapName) then
    if fn != -1 then
      close(fn)
      resp = bmYesNoPrompt("File " & fileName & " exists.  Overwrite? ")
      if resp != 'y' then
        Message = "File not saved"
        set_active_page(ap)
        return
      end if
    end if
  end if
  fn = open(fileName,"w")
  if fn = -1 then
    bmMsg("Could not save to file " & fileName)
  else
    d = find('.',fileName)
    wFileName = fileName[1..d - 1]
    puts(fn,"global sequence " & wFileName & "\n")
    l = sprintf("%s = { { ",{wFileName})
    indent = length(l) - 2
    for i = 1 to length(Map) do
      indent += 2
      for ii = 1 to length(Map[i]) do
        s = sprintf("%s",{sprint(Map[i][ii])})
        if ii < length(Map[i]) then
          s &= ','
        end if
        if length(l) + length(s) <= 79 then
          l &= s
        else
          l &= '\n'
          puts(fn,l)
          l = repeat(' ',indent) & s
        end if
      end for
      indent -= 2
      l &= " }"
      if i < length(Map) then
        l &= ",\n"
        puts(fn,l)
        l = repeat(' ',indent) & "{ "
      else
        puts(fn,l)
      end if
    end for
    puts(fn," }")
    close(fn)
    MapName = fileName
    Message = "Saved " & fileName
  end if
  set_active_page(ap)
end procedure

-----------------------------------------------------------------------------
-- Load a map                                                              --
-----------------------------------------------------------------------------
procedure loadMap()
  atom fn
  sequence fileName
  integer d, valid
  sequence s
  integer ap

  ap = get_active_page()
  set_active_page(get_display_page())
    
  fileName = bmPrompt("File to load: ")
  valid = 0
  while not valid do
    valid = 1
    d = find('.',fileName)
    if d then
      if d = 1 or d > 9 then
        valid = 0
      else
        if length(fileName) - d > 4 then
          valid = 0
        end if
      end if
    else
      if length(fileName) = 0 or length(fileName) > 8 then
        valid = 0
      end if
    end if
    if d = 0 then
      fileName &= ".e"
    end if
    if not valid then
      fileName = bmPrompt("Invalid file name.  Load: ")
    end if
  end while
  fn = open(fileName,"r")
  if fn = -1 then
    Message = "Could not open file " & fileName
  else
    while getc(fn) != '=' do
    end while
    s = get(fn)
    if s[1] != GET_SUCCESS then
      Message = "Invalid file format."
    else
      Map = s[2]
      MapName = fileName
    end if
    Message = "Loaded " & fileName
  end if
  set_active_page(ap)
end procedure

-----------------------------------------------------------------------------
-- Set the special number for a location                                   --
-----------------------------------------------------------------------------
procedure setSpecial(sequence loc)
  atom n
  integer ap
  integer valid

  ap = get_active_page()
  set_active_page(get_display_page())
    
  n = bmPromptNum("Enter special number: (0-99) ",{0,99})
  valid = 0
  while not valid do
    valid = 1
    if not integer(n) or n < 0 or n > 99 then
      valid = 0
      n = bmPromptNum("Invalid number.  Enter special number: (0-99) ",{0,99})
    end if
  end while
  Map[loc[2]][loc[1]][MAP_SPECIAL] = n
  set_active_page(ap)
end procedure

-----------------------------------------------------------------------------
-- Set the zone number for a location                                      --
-----------------------------------------------------------------------------
procedure setZone(sequence loc)
  atom n
  integer ap
  integer valid

  ap = get_active_page()
  set_active_page(get_display_page())
    
  n = bmPromptNum("Enter the zone number: (1-99) ",{0,99})
  valid = 0
  while not valid do
    valid = 1
    if not integer(n) or n < 1 or n > 99 then
      valid = 0
      n = bmPromptNum("Invalid number.  Enter the zone number: (1-99) ",{1,99})
    end if
  end while
  Map[loc[2]][loc[1]][MAP_ZONE] = n
  set_active_page(ap)
end procedure

-----------------------------------------------------------------------------
-- Determine what to do for a keypress                                     --
-----------------------------------------------------------------------------
procedure handleKey(atom key)
  integer k, t, d
  integer valid

  k = lower(key)  
  if k    = #0148 then -- up arrow
    -- Move up
    moveSel({0,-1})
  elsif k = #0150 then -- down arrow
    -- Move down
    moveSel({0,+1})
  elsif k = #014B then -- left arrow
    -- Move left
    moveSel({-1,0})
  elsif k = #014D then -- right arrow
    -- Move right
    moveSel({+1,0})
  elsif k = #0020 then -- space
    -- Enter special number for spot
    setSpecial(SelPos)
  elsif k = #0061 then -- 'a'
    -- Save the map as a new name
    saveMap("")
  elsif k = #0063 then -- 'c'
    -- Display the coordinates of the selected tile
    Message = "Coordinates (x,y): " & sprintf("(%d,%d)",SelPos)
  elsif k = #0069 then -- 'i'
    -- Toggle displaying tile info
    if InfoFlag then
      InfoFlag = 0
    else
      InfoFlag = 1
    end if
  elsif k = #006C then -- 'l'
    -- Load a map
    loadMap()
  elsif k = #006D then -- 'm'
    -- Draw a large-scale map
    drawLargeMap()
  elsif k = #0070 then -- 'p'
    -- Toggle passability for the spot
    t = Map[SelPos[2]][SelPos[1]][MAP_PASSABLE]
    t += 1
    if t > 1 then
      t = 0
    end if
    Map[SelPos[2]][SelPos[1]][MAP_PASSABLE] = t
  elsif k = #0073 then -- 's'
    -- Save the map
    saveMap(MapName)
  elsif k = #0074 then -- 't'
    -- Change the terrain type
    t = Map[SelPos[2]][SelPos[1]][MAP_TERRAIN]
    if t = LastTerrain then
      t += 1
      if t > length(Terrain) then
        t = 1
      end if
      LastTerrain = t
    else
      t = LastTerrain
    end if
    Map[SelPos[2]][SelPos[1]][MAP_TERRAIN] = t
  elsif k = #007A then -- 'z'
    if Map[SelPos[2]][SelPos[1]][MAP_ZONE] = LastZone then
      -- Change the terrain type
      setZone(SelPos)
      LastZone = Map[SelPos[2]][SelPos[1]][MAP_ZONE]
    else
      Map[SelPos[2]][SelPos[1]][MAP_ZONE] = LastZone
    end if
  elsif k = #001B then -- ESC
    -- Exit the program (handled in main routine)
  end if
end procedure

-----------------------------------------------------------------------------
-- Main logic                                                              --
-----------------------------------------------------------------------------
integer exitFlag
integer key
atom last

InitScreen()
exitFlag = 0
key = 0
last = time()
paintScreen()
set_active_page(1)
paintScreen()
while not exitFlag do
  handleKey(key)
  if key = #001B then -- ESC key exits the program
    exitFlag = 1
    exit
  end if
  paintScreen()
  if length(Message) > 0 then
    bmMsg(Message)
    Message = ""
  end if
  if get_display_page() = 1 then
    set_display_page(0)
    set_active_page(1)
  else
    set_display_page(1)
    set_active_page(0)
  end if
  while time() - last < .067 do
  end while
  key = wait_key()
  last = time()
  -- flush out the key buffer; we don't want to let keys accumulate
  while get_key() != -1 do
  end while
end while
DefaultScreen()