-----------------------------------------------------------------------------
-- rpgchar.e                                                               --
-- Routines relating to the main character for rpg.ex                      --
--                                                                         --
-- written by Mike Wever                                                   --
-----------------------------------------------------------------------------

global sequence Character
Character = 
{ { { 16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16 },
    { 16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16 },
    { 16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16 },
    { 16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16 },
    { 16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16 },
    { 16,16,16,16,16,16,16,16,16, 1,16,16,16,16,16,16,16,16,16,16 },
    { 16,16,16,16,16,16,16,16, 1, 1, 1,16,16,16,16,16,16,16,16,16 },
    { 16,16,16,16,16,16,16,16, 4, 4, 4,16,16,16,16,16,16,16,16,16 },
    { 16,16, 0,16,16,16,16,16, 4, 4, 4,16,16,16,16,16,16,16,16,16 },
    { 16,16, 0,16,16,16,16,16,16, 4,16,16,16,16,16,16,16,16,16,16 },
    { 16,16,16, 0,16,16,16, 3, 3, 5, 5, 5, 5, 5,16,16,16,16,16,16 },
    { 16,16,16, 0,16,16,16, 3, 3, 5, 5, 1, 5, 5,16,16,16,16,16,16 },
    { 16,16,16,16, 0,16, 3,16, 3, 5, 5, 1, 5, 5,16,16,16,16,16,16 },
    { 16,16,16,16, 0, 0, 3,16, 3, 5, 1, 1, 1, 5,16,16,16,16,16,16 },
    { 16,16,16,16, 0, 4,16,16, 3, 5, 5, 1, 5, 5,16,16,16,16,16,16 },
    { 16,16,16,16,16, 0,16,16, 1, 5, 5, 1, 5, 5,16,16,16,16,16,16 },
    { 16,16,16,16,16,16,16,16, 3, 3, 5, 5, 5,16,16,16,16,16,16,16 },
    { 16,16,16,16,16,16,16,16, 3,16, 3, 5,16,16,16,16,16,16,16,16 },
    { 16,16,16,16,16,16,16,16, 3,16, 3,16,16,16,16,16,16,16,16,16 },
    { 16,16,16,16,16,16,16,16, 3,16, 3,16,16,16,16,16,16,16,16,16 },
    { 16,16,16,16,16,16,16,16, 3,16, 3,16,16,16,16,16,16,16,16,16 },
    { 16,16,16,16,16,16,16,16, 3,16, 3,16,16,16,16,16,16,16,16,16 },
    { 16,16,16,16,16,16,16, 0, 0,16, 3,16,16,16,16,16,16,16,16,16 },
    { 16,16,16,16,16,16,16,16,16,16, 0, 0,16,16,16,16,16,16,16,16 },
    { 16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16 } },
  { { 16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16 },
    { 16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16 },
    { 16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16 },
    { 16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16 },
    { 16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16 },
    { 16,16,16,16,16,16,16,16,16, 1,16,16,16,16,16,16,16,16,16,16 },
    { 16,16,16,16,16,16,16,16, 1, 1, 1,16,16,16,16,16,16,16,16,16 },
    { 16,16,16,16,16,16,16,16, 4, 4, 4,16,16,16,16,16,16,16,16,16 },
    { 16,16, 0,16,16,16,16,16, 4, 4, 4,16,16,16,16,16,16,16,16,16 },
    { 16,16, 0,16,16,16,16,16,16, 4,16,16,16,16,16,16,16,16,16,16 },
    { 16,16,16, 0,16,16,16, 3, 3, 5, 5, 5, 5, 5,16,16,16,16,16,16 },
    { 16,16,16, 0,16,16,16, 3, 3, 5, 5, 1, 5, 5,16,16,16,16,16,16 },
    { 16,16,16,16, 0,16, 3,16, 3, 5, 5, 1, 5, 5,16,16,16,16,16,16 },
    { 16,16,16,16, 0, 0, 3,16, 3, 5, 1, 1, 1, 5,16,16,16,16,16,16 },
    { 16,16,16,16, 0, 4,16,16, 3, 5, 5, 1, 5, 5,16,16,16,16,16,16 },
    { 16,16,16,16,16, 0,16,16, 1, 5, 5, 1, 5, 5,16,16,16,16,16,16 },
    { 16,16,16,16,16,16,16,16, 3, 3, 5, 5, 5,16,16,16,16,16,16,16 },
    { 16,16,16,16,16,16,16,16, 3,16, 3, 5,16,16,16,16,16,16,16,16 },
    { 16,16,16,16,16,16,16,16, 3,16, 3,16,16,16,16,16,16,16,16,16 },
    { 16,16,16,16,16,16,16,16, 3,16, 3,16,16,16,16,16,16,16,16,16 },
    { 16,16,16,16,16,16,16,16, 3,16, 3,16,16,16,16,16,16,16,16,16 },
    { 16,16,16,16,16,16,16,16, 3,16, 3,16,16,16,16,16,16,16,16,16 },
    { 16,16,16,16,16,16,16,16, 3,16, 0, 0,16,16,16,16,16,16,16,16 },
    { 16,16,16,16,16,16,16, 0, 0,16,16,16,16,16,16,16,16,16,16,16 },
    { 16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16 } } }

global integer CharPicNum
CharPicNum = 1

-- Define maximum number of character pictures (for animated movement)
global constant CHAR_PIC_MAX = 2
    
global sequence CharPos
CharPos = {1,1}

-- Define character sequence entries
global constant CH_FP     = 1  -- Fighting Points
global constant CH_FP_MAX = 2  -- Maximum Value for Fighting Points
global constant CH_WS     = 3  -- Weapon Skill
global constant CH_INV    = 4  -- Inventory (items carried)
global constant CH_DMG    = 5  -- Damage for weapon in hand
global constant CH_PROT   = 6  -- Protection for shield in hand
global constant CH_EXP    = 7  -- Character's experience
global constant CH_BITS   = 8  -- Character's gold bits
global constant CH_WPN    = 9  -- Character's weapon
global constant CH_SHLD   = 10 -- Character's shield

global sequence CharRec

-- Define maximum number of items the character may carry
global constant MAX_INVENTORY = 10

-- Define the most number of gold bits a character may carry
global constant MAX_BITS = 5000


------------------------------------------------------------------------
-- Initialize the character record for a new game.                    --
------------------------------------------------------------------------
global procedure InitChar()
  CharRec = {20,20,1,{},1,0,0,0,"a kitchen knife","no shield"}
end procedure

------------------------------------------------------------------------
-- Give the character something (add it to his items carried).        --
-- Parameters:                                                        --
--   atom: item number                                                --
-- Return Values:                                                     --
--   1 = character got the item                                       --
--   0 = character did not get the item (inventory full)              --
------------------------------------------------------------------------
global function GiveCharacter(atom item)
  if length(CharRec[CH_INV]) < MAX_INVENTORY then
    CharRec[CH_INV] = append(CharRec[CH_INV],item)
    return 1
  else
    return 0
  end if
end function

------------------------------------------------------------------------
-- Take something from the character (remove it from his items        --
-- carried).                                                          --
-- Parameters:                                                        --
--   atom: item number                                                --
-- Return Values:                                                     --
--   1 = got the item                                                 --
--   0 = did not get the item (character doesn't have it)             --
------------------------------------------------------------------------
global function TakeFromCharacter(atom item)
  integer f

  f = find(item,CharRec[CH_INV])
  if f != 0 then
    CharRec[CH_INV] = CharRec[CH_INV][1..f - 1]
                    & CharRec[CH_INV][f + 1..length(CharRec[CH_INV])]
    return 1
  else
    return 0
  end if
end function

------------------------------------------------------------------------
-- Give the character some money.                                     --
-- Parameters:                                                        --
--   atom: number of gold bits to give                                --
------------------------------------------------------------------------
global procedure GiveCharacterBits(atom amount)
  CharRec[CH_BITS] += amount
  if CharRec[CH_BITS] > MAX_BITS then
    CharRec[CH_BITS] = MAX_BITS
  end if
end procedure

------------------------------------------------------------------------
-- Select an item to drop                                             --
------------------------------------------------------------------------
global procedure DropItem()
  sequence inv
  integer item
  
  -- Drop an item out of the character's inventory
  if length(CharRec[CH_INV]) = 0 then
    MessageBox(10, 10, "You aren't carrying anything that can be dropped.")
  else
    inv = {{},{}}
    for i = 1 to length(CharRec[CH_INV]) do
      item = CharRec[CH_INV][i]
      -- Don't allow to drop important items
      if Items[item][ITEM_VAL] != -1 then
        inv[1] = append(inv[1],Items[item][ITEM_NAME])
        inv[2] = append(inv[2],item)
      end if
    end for
    item = SelectBox(10, 10, "What do you want to drop?", inv[1])
    if item > 0 then
      if TakeFromCharacter(inv[2][item]) then
        MessageBox(10, 10, "You drop the "
                         & Items[inv[2][item]][ITEM_NAME]
                         & ".")
      end if
    end if
  end if
end procedure

------------------------------------------------------------------------
-- Give something important to the character.  If there isn't room    --
-- for it, make him drop something.                                   --
-- Parameters:                                                        --
--   atom: id of item to give                                         --
------------------------------------------------------------------------
global procedure GiveCharacterImportant(atom item)
  while not GiveCharacter(item) do
    DropItem()
  end while
end procedure

------------------------------------------------------------------------
-- Take some money from the character.                                --
-- Parameters:                                                        --
--   atom: number of bits to take                                     --
-- Return Values:                                                     --
--   1 = got the money                                                --
--   0 = did not get the money (character doesn't have enough)        --
------------------------------------------------------------------------
global function TakeBitsFromCharacter(atom amount)
  if CharRec[CH_BITS] < amount then
    return 0
  else
    CharRec[CH_BITS] -= amount
    return 1
  end if
end function

------------------------------------------------------------------------
-- Change the character's fighting points.  Don't allow the value to  --
-- fall below zero or rise above the maximum amount.                  --
-- Parameters:                                                        --
--   integer: change amount                                           --
------------------------------------------------------------------------
global procedure ChangeCharFP(integer amt)
  CharRec[CH_FP] += amt
  if CharRec[CH_FP] < 0 then
    CharRec[CH_FP] = 0
  elsif CharRec[CH_FP] > CharRec[CH_FP_MAX] then
    CharRec[CH_FP] = CharRec[CH_FP_MAX]
  end if
end procedure

------------------------------------------------------------------------
-- Change the character's weapon skill.  Don't allow the value to     --
-- fall below zero.                                                   --
-- Parameters:                                                        --
--   integer: change amount                                           --
------------------------------------------------------------------------
global procedure ChangeCharWS(integer amt)
  CharRec[CH_WS] += amt
  if CharRec[CH_WS] < 0 then
    CharRec[CH_WS] = 0
  end if
end procedure

------------------------------------------------------------------------
-- Change the character's experience points.  Don't allow the value   --
-- to fall below zero.  Increase weapon skill when experience points  --
-- equal weapon skill.                                                --
-- Parameters:                                                        --
--   integer: change amount                                           --
------------------------------------------------------------------------
global procedure ChangeCharExp(integer amt)
  CharRec[CH_EXP] += amt
  if CharRec[CH_EXP] < 0 then
    CharRec[CH_EXP] = 0
  end if
  if CharRec[CH_EXP] >= CharRec[CH_WS] then
    -- Weapon skill increases when experience equals current skill
    CharRec[CH_WS] += 1
    -- Fighting points increase once for every three weapons skill
    -- increases
    if remainder(CharRec[CH_WS],3) = 0 then
      CharRec[CH_FP_MAX] += 1
    end if
    CharRec[CH_EXP] = 0
  end if
end procedure

------------------------------------------------------------------------
-- Determine if the character has an item in his inventory.           --
-- Parameters:                                                        --
--   integer: item id                                                 --
-- Returns:                                                           --
--   1 if item is in inventory, 0 if not                              --
------------------------------------------------------------------------
global function CharacterHasItem(integer item)
  if find(item,CharRec[CH_INV]) then
    return 1
  else
    return 0
  end if
end function

-----------------------------------------------------------------------------
-- Draw the character at a given location                                  --
-- Parameters:                                                             --
--   sequence: screen location to draw the character at {x,y}              --
-----------------------------------------------------------------------------
global procedure DrawCharacter(sequence loc)
  sequence charPic

  charPic = Character[CharPicNum]
  for i = 0 to length(charPic) - 1 do
    for ii = 0 to length(charPic[i + 1]) - 1 do
      if charPic[i + 1][ii + 1] != 16 then
        SetPixels(BACK_SCREEN,charPic[i + 1][ii + 1],
                  {loc[1] + ii,loc[2] + i})
      end if
    end for
  end for
end procedure

-----------------------------------------------------------------------------
-- Draw the character's fighting points meter.                             --
-- Parameters:                                                             --
--   atom: handle of window to draw in                                     --
-----------------------------------------------------------------------------
global procedure DrawCharFP(atom hWin)
  atom pct
  sequence bar
  integer fp

  bar = repeat(RPG_WHITE,20)
  pct = CharRec[CH_FP] / CharRec[CH_FP_MAX]
  fp = floor(20 * pct)
  if fp < 1 and CharRec[CH_FP] > 0 then
    fp = 1
  end if
  for i = 1 to fp by 1 do
    bar[i] = RPG_RED
  end for
  SetPixels(hWin,repeat(RPG_WHITE,20),{0, 0})
  for i = 1 to 3 do
    SetPixels(hWin,bar,{0, i})
  end for
  SetPixels(hWin,repeat(RPG_WHITE,20),{0, 4})
end procedure

-----------------------------------------------------------------------------
-- Change the character's ready weapon.                                    --
-----------------------------------------------------------------------------
global procedure ReadyCharWeapon(integer dmg, sequence wpnDesc)
  CharRec[CH_DMG] = dmg
  CharRec[CH_WPN] = wpnDesc
end procedure

-----------------------------------------------------------------------------
-- Change the character's ready shield.                                    --
-----------------------------------------------------------------------------
global procedure ReadyCharShield(integer prot, sequence shldDesc)
  CharRec[CH_PROT] = prot
  CharRec[CH_SHLD] = shldDesc
end procedure