-----------------------------------------------------------------------------
-- rpggame.e                                                               --
-- The things that make up a game for rpg.ex.                              --
-- Those things include:                                                   --
--   items                                                                 --
--   monsters                                                              --
--   zones                                                                 --
--   special events                                                        --
--                                                                         --
-- written by Mike Wever                                                   --
-----------------------------------------------------------------------------

------------------------------------------------------------------------
-- The magic flute.  When used, it will make the mean bunnies stop    --
-- appearing around Mike's house.                                     --
------------------------------------------------------------------------
global constant MAGIC_FLUTE_USED = RegisterSpecialFlag()

global procedure Magic_Flute_Used_Load()
  Zones[2] = Zones[3]
end procedure
SetSpecialFlagLoadRtn(MAGIC_FLUTE_USED,
                      routine_id("Magic_Flute_Used_Load"))

Items = append(Items,{"wooden flute",-1,-1,0,1})
global constant MAGIC_FLUTE = length(Items)

global procedure Item_Magic_Flute()
  if SpecialFlagIsOn(MAGIC_FLUTE_USED) then
    MessageBox(10,10,"You play a lilting tune on the flute.")
  else
    MessageBox(10, 10, "As you play the flute, you get the feeling\n"
                     & "that the tune pleases rabbits everywhere.")
    SetSpecialFlag(MAGIC_FLUTE_USED, ON)
  end if
end procedure
Items[MAGIC_FLUTE][ITEM_USE] = routine_id("Item_Magic_Flute")

------------------------------------------------------------------------
-- A rabbit skin.  The leftovers from killing mean bunnies.  They can --
-- be sold for money.                                                 --
------------------------------------------------------------------------
Items = append(Items,{"rabbit hide",-1,1,0,0})
global constant RABBIT_HIDE = length(Items)

------------------------------------------------------------------------
-- A healing salve.  When used, it will recover some of the           --
-- character's fighting points.                                       --
------------------------------------------------------------------------
Items = append(Items,{"healing salve",-1,5,0,1})
global constant HEALING_SALVE = length(Items)

global procedure Item_Healing_Salve()
  integer healAmt

  healAmt = floor(CharRec[CH_FP_MAX] * .25)
  if TakeFromCharacter(HEALING_SALVE) then
    ChangeCharFP(healAmt)
    DrawCharFP(hWinCFp)
  end if
  MessageBox(10, 10, "The salve feels cool on your skin and\n"
                   & "soothes your pain.")
end procedure
Items[HEALING_SALVE][ITEM_USE] = routine_id("Item_Healing_Salve")

------------------------------------------------------------------------
-- Lisa's favorite ring.  She wants it back.                          --
------------------------------------------------------------------------
Items = append(Items,{"ornate gold ring",-1,-1,0,0})
global constant LISAS_RING = length(Items)

------------------------------------------------------------------------
-- The minotaur's horns.  Proof that you killed it.                   --
------------------------------------------------------------------------
Items = append(Items,{"minotaur's horns",-1,-1,0,0})
global constant MINOTAUR_HORNS = length(Items)

------------------------------------------------------------------------
-- A heavy sword that can do a good amount of damage.                 --
------------------------------------------------------------------------
Items = append(Items,{"heavy sword",-1,-1,0,1})
global constant HEAVY_SWORD = length(Items)

global procedure Item_Heavy_Sword()
  integer n
  
  ReadyCharWeapon(8, "a heavy sword")
  n = TakeFromCharacter(HEAVY_SWORD)
  MessageBox(10, 10, "You take a few practice swings with the sword.\n"
                   & "It feels well-balanced and capable of dealing\n"
                   & "out a lot of damage.")
end procedure
Items[HEAVY_SWORD][ITEM_USE] = routine_id("Item_Heavy_Sword")

------------------------------------------------------------------------
-- A small wooden shield.                                             --
------------------------------------------------------------------------
Items = append(Items,{"small wooden shield",-1,25,0,1})
global constant SMALL_WOOD_SHIELD = length(Items)

global procedure Item_Small_Wood_Shield()
  integer n
  
  ReadyCharShield(1, "a small wooden shield")
  n = TakeFromCharacter(SMALL_WOOD_SHIELD)
  MessageBox(10, 10, "You strap the shield onto your arm, hoping\n"
                   & "you don't get any splinters.")
end procedure
Items[SMALL_WOOD_SHIELD][ITEM_USE] = routine_id("Item_Small_Wood_Shield")

------------------------------------------------------------------------
-- Stamina pill.  Used to recover FP during combat.  Short-term gain  --
-- only; FP disappears after combat (but will not leave char dead).   --
------------------------------------------------------------------------
Items = append(Items,{"stamina pill",-1,10,1,0})
global constant STAMINA_PILL = length(Items)

global procedure Item_Stamina_Pill()
  integer healAmt

  healAmt = floor(CharRec[CH_FP_MAX] * .25)
  if TakeFromCharacter(STAMINA_PILL) then
    ChangeCharFP(healAmt)
    StaminaPillAmount += healAmt
    DrawCharFP(hWinCFp)
    MessageBox(10, 10, "You pop a pill in your mouth and you\n"
                     & "immediately feel stronger.")
  end if
end procedure
Items[STAMINA_PILL][ITEM_USE] = routine_id("Item_Stamina_Pill")

------------------------------------------------------------------------
-- A jewelled necklace.  Sell it for money.                           --
------------------------------------------------------------------------
Items = append(Items,{"jewelled necklace",-1,25,0,0})
global constant NECKLACE = length(Items)

------------------------------------------------------------------------
-- The bandit chief's ring.                                           --
------------------------------------------------------------------------
Items = append(Items,{"Jared's ring",-1,100,0,0})
global constant BANDIT_RING = length(Items)

------------------------------------------------------------------------
-- A round metal shield.                                              --
------------------------------------------------------------------------
Items = append(Items,{"round iron shield",-1,100,0,1})
global constant ROUND_IRON_SHIELD = length(Items)

global procedure Item_Round_Iron_Shield()
  integer n
  
  ReadyCharShield(3, "a round iron shield")
  n = TakeFromCharacter(ROUND_IRON_SHIELD)
  MessageBox(10, 10, "The weight of the shield on you arm\n"
                   & "makes you feel safer already.")
end procedure
Items[ROUND_IRON_SHIELD][ITEM_USE] = routine_id("Item_Round_Iron_Shield")

------------------------------------------------------------------------
-- A letter from David to Bob.                                        --
------------------------------------------------------------------------
Items = append(Items,{"David's letter",-1,-1,0,1})
global constant DAVIDS_LETTER = length(Items)

global constant DAVID_ASKED = RegisterSpecialFlag()
global constant DAVIDS_LETTER_OPENED = RegisterSpecialFlag()
global constant DAVIDS_LETTER_READ = RegisterSpecialFlag()
global constant DAVID_PAID_REWARD = RegisterSpecialFlag()

global procedure Item_Davids_Letter()
  integer r
  
  if not SpecialFlagIsOn(DAVIDS_LETTER_OPENED) then
    r = SelectBox(10, 10, "The letter is held closed by a wax seal.",
                          {"Break the seal and read the letter",
                           "Leave the letter alone"})
    if r = 1 then
      SetSpecialFlag(DAVIDS_LETTER_OPENED, ON)
    end if
  end if
  if SpecialFlagIsOn(DAVIDS_LETTER_OPENED) then
    MessageBox(10, 10, "Dear Bob,\n"
                     & "\n"
                     & "The young man carrying this letter was able\n"
                     & "to travel the main highway from your town\n"
                     & "to mine.  He is obviously brave and strong.\n"
                     & "I hope he is also trustworthy.  If this\n"
                     & "letter arrives to you still sealed, I want\n"
                     & "you to make him the following offer.")
    MessageBox(10, 10, "I have been unable to trade with your town\n"
                     & "since the bandits overran the main\n"
                     & "highway.  Those highwaymen are loyal to a\n"
                     & "criminal named Jared.  If Jared is killed,\n"
                     & "I am sure the bandits will disperse.  I\n"
                     & "will pay a reward of 200 gold bits to the\n"
                     & "man who removes Jared and brings me his\n"
                     & "ring as proof.")
    MessageBox(10, 10, "I am confident that this young man is up to\n"
                     & "the task.  I look forward to doing business\n"
                     & "with you once again, Bob.\n"
                     & "\n"
                     & "Yours,\n"
                     & "  D.")
  end if
end procedure
Items[DAVIDS_LETTER][ITEM_USE] = routine_id("Item_Davids_Letter")

------------------------------------------------------------------------
-- A dragon scale.  Worth lots of money.                              --
------------------------------------------------------------------------
Items = append(Items,{"dragon scale",-1,250,0,0})
global constant DRAGON_SCALE = length(Items)

------------------------------------------------------------------------
-- A magical crystal that makes your opponent clumsy.                 --
------------------------------------------------------------------------
Items = append(Items,{"stumble crystal",-1,150,1,0})
global constant STUMBLE_CRYSTAL = length(Items)

global procedure Item_Stumble_Crystal()
  integer n

  if TakeFromCharacter(STUMBLE_CRYSTAL) then
    n = 0 - floor(MonsterRec[MN_WS] * .25)
    ChangeMonsterWS(n)
    MessageBox(10, 10, "Your opponent begins to act\n"
                     & "a bit clumsier.")
  end if
end procedure
Items[STUMBLE_CRYSTAL][ITEM_USE] = routine_id("Item_Stumble_Crystal")

------------------------------------------------------------------------
-- A powerful sword.                                                  --
------------------------------------------------------------------------
Items = append(Items,{"greatsword",-1,200,0,1})
global constant GREATSWORD = length(Items)

global procedure Item_Greatsword()
  integer n
  
  ReadyCharWeapon(12, "a greatsword")
  n = TakeFromCharacter(GREATSWORD)
  MessageBox(10, 10, "The sword is very heavy, but you\n"
                   & "are sure it will serve you well.")
end procedure
Items[GREATSWORD][ITEM_USE] = routine_id("Item_Greatsword")

------------------------------------------------------------------------
-- A small metal shield                                               --
------------------------------------------------------------------------
Items = append(Items,{"steel buckler",-1,50,0,1})
global constant STEEL_BUCKLER = length(Items)

global procedure Item_Steel_Buckler()
  integer n
  
  ReadyCharShield(2, "a steel buckler")
  n = TakeFromCharacter(STEEL_BUCKLER)
  MessageBox(10, 10, "You strap on the small but sturdy shield.")
end procedure
Items[STEEL_BUCKLER][ITEM_USE] = routine_id("Item_Steel_Buckler")

------------------------------------------------------------------------
-- A full-length shield.                                              --
------------------------------------------------------------------------
Items = append(Items,{"tower shield",-1,250,0,1})
global constant TOWER_SHIELD = length(Items)

global procedure Item_Tower_Shield()
  integer n
  
  ReadyCharShield(6, "a tower shield")
  n = TakeFromCharacter(TOWER_SHIELD)
  MessageBox(10, 10, "The shield covers the full length\n"
                   & "of your body.")
end procedure
Items[TOWER_SHIELD][ITEM_USE] = routine_id("Item_Tower_Shield")

------------------------------------------------------------------------
-- A wolf skin.  The leftovers from a dead wolf.  They can be sold    --
-- for money.                                                         --
------------------------------------------------------------------------
Items = append(Items,{"wolf hide",-1,6,0,0})
global constant WOLF_HIDE = length(Items)




------------------------------------------------------------------------
-- The list of monsters a character may encounter                     --
------------------------------------------------------------------------
global constant MEAN_BUNNY_1 =
RegisterMonster({"mean bunny",      -- name
                 5, 5,              -- fighting points
                 1,                 -- skill
                 {},                -- items carried
                 {0,0,0},           -- bits carried
                 1,                 -- damage
                 0})                -- protection

global constant MEAN_BUNNY_2 =
RegisterMonster({"mean bunny",      -- name
                 5, 5,              -- fighting points
                 1,                 -- skill
                 {RABBIT_HIDE},     -- items carried
                 {0,0,0},           -- bits carried
                 1,                 -- damage
                 0})                -- protection

global constant GOBLIN =
RegisterMonster({"goblin",          -- name
                 20, 20,            -- fighting points
                 10,                -- skill
                 {},                -- items carried
                 {1,6,0},           -- bits carried
                 4,                 -- damage
                 1})                -- protection

global constant WOLF =
RegisterMonster({"wolf",            -- name
                 25, 25,            -- fighting points
                 15,                -- skill
                 {WOLF_HIDE},       -- items carried
                 {0,0,0},           -- bits carried
                 4,                 -- damage
                 0})                -- protection

global constant DWARF_1 =
RegisterMonster({"dwarf",           -- name
                 25, 25,            -- fighting points
                 15,                -- skill
                 {},                -- items carried
                 {2,8,2},           -- bits carried
                 4,                 -- damage
                 2})                -- protection

global constant DWARF_2 =
RegisterMonster({"dwarf",           -- name
                 25, 25,            -- fighting points
                 15,                -- skill
                 {STAMINA_PILL},    -- items carried
                 {2,8,2},           -- bits carried
                 4,                 -- damage
                 2})                -- protection

global constant SKELETON =
RegisterMonster({"skeleton",        -- name
                 20, 20,            -- fighting points
                 20,                -- skill
                 {},                -- items carried
                 {2,4,0},           -- bits carried
                 4,                 -- damage
                 1})                -- protection

global constant MINOTAUR =
RegisterMonster({"minotaur",        -- name
                 50, 50,            -- fighting points
                 25,                -- skill
                 {},                -- items carried
                 {0,0,0},           -- bits carried
                 6,                 -- damage
                 2})                -- protection

global constant TAN_ELF_1 =
RegisterMonster({"elf with a tan hat",  -- name
                 30, 30,                -- fighting points
                 25,                    -- skill
                 {},                    -- items carried
                 {1,6,2},               -- bits carried
                 4,                     -- damage
                 2})                    -- protection

global constant TAN_ELF_2 =
RegisterMonster({"elf with a tan hat", -- name
                 35, 35,               -- fighting points
                 25,                   -- skill
                 {HEALING_SALVE},      -- items carried
                 {2,6,0},              -- bits carried
                 4,                    -- damage
                 2})                   -- protection

global constant TAN_ELF_GUARD =
RegisterMonster({"elf guard",       -- name
                 50, 50,            -- fighting points
                 30,                -- skill
                 {},                -- items carried
                 {2,6,0},           -- bits carried
                 6,                 -- damage
                 3})                -- protection

global constant BANDIT_1 =
RegisterMonster({"bandit",          -- name
                 30, 30,            -- fighting points
                 35,                -- skill
                 {},                -- items carried
                 {3,6,0},           -- bits carried
                 4,                 -- damage
                 2})                -- protection

global constant BANDIT_2 =
RegisterMonster({"bandit",          -- name
                 35, 35,            -- fighting points
                 35,                -- skill
                 {NECKLACE},        -- items carried
                 {3,6,0},           -- bits carried
                 4,                 -- damage
                 2})                -- protection

global constant BANDIT_3 =
RegisterMonster({"bandit",          -- name
                 35, 35,            -- fighting points
                 37,                -- skill
                 {},                -- items carried
                 {3,6,2},           -- bits carried
                 4,                 -- damage
                 2})                -- protection

global constant JARED =
RegisterMonster({"Jared",           -- name
                 60, 60,            -- fighting points
                 45,                -- skill
                 {},                -- items carried
                 {0,0,0},           -- bits carried
                 6,                 -- damage
                 4})                -- protection

global constant ORC_1 =
RegisterMonster({"orc",             -- name
                 50, 50,            -- fighting points
                 40,                -- skill
                 {},                -- items carried
                 {2,6,0},           -- bits carried
                 6,                 -- damage
                 4})                -- protection

global constant ORC_2 =
RegisterMonster({"orc",             -- name
                 55, 55,            -- fighting points
                 40,                -- skill
                 {HEALING_SALVE},   -- items carried
                 {2,6,0},           -- bits carried
                 6,                 -- damage
                 4})                -- protection

global constant ORC_CHIEF =
RegisterMonster({"orc chief",       -- name
                 60, 60,            -- fighting points
                 45,                -- skill
                 {},                -- items carried
                 {3,6,0},           -- bits carried
                 6,                 -- damage
                 6})                -- protection

global constant OGRE =
RegisterMonster({"ogre",            -- name
                 60, 60,            -- fighting points
                 50,                -- skill
                 {},                -- items carried
                 {0,0,0},           -- bits carried
                 7,                 -- damage
                 3})                -- protection

global constant GIANT =
RegisterMonster({"giant",           -- name
                 70, 70,            -- fighting points
                 50,                -- skill
                 {},                -- items carried
                 {0,0,0},           -- bits carried
                 8,                 -- damage
                 4})                -- protection

global constant DRAGON =
RegisterMonster({"dragon",          -- name
                 100, 100,          -- fighting points
                 75,                -- skill
                 {DRAGON_SCALE},    -- items carried
                 {0,0,0},           -- bits carried
                 10,                 -- damage
                 6})                -- protection




------------------------------------------------------------------------
-- The table of zones.                                                --
------------------------------------------------------------------------
constant NO_MONSTER = 0

Zones =

-- Zone 1 (default)
{ { {  1,  90, NO_MONSTER},
    { 91,  95, GOBLIN},
    { 96,  98, WOLF},
    { 99,  99, DWARF_1},
    {100, 100, DWARF_2} },

-- Zone 2 (near home)
  { {  1,  50, NO_MONSTER},
    { 51,  90, MEAN_BUNNY_1},
    { 91, 100, MEAN_BUNNY_2} },
    
-- Zone 3 (safe)
  { {  1, 100, NO_MONSTER} },

-- Zone 4 (minotaur's maze)
  { {  1,  75, NO_MONSTER},
    { 76, 100, SKELETON} },

-- Zone 5 (bandit zone)
  { {  1,  75, NO_MONSTER},
    { 76,  90, BANDIT_1},
    { 91,  95, BANDIT_2},
    { 96, 100, BANDIT_3} },

-- Zone 6 (tan elf zone)
  { {  1,  50, NO_MONSTER},
    { 51,  80, TAN_ELF_1},
    { 81,  95, TAN_ELF_2},
    { 96, 100, TAN_ELF_GUARD} },

-- Zone 7 (default zone 2)
  { {  1,  75, NO_MONSTER},
    { 76,  85, ORC_1},
    { 86,  93, ORC_2},
    { 94,  97, ORC_CHIEF},
    { 98,  98, OGRE},
    { 99,  99, GIANT},
    {100, 100, DRAGON} } }




------------------------------------------------------------------------
-- Special Event 01                                                   --
-- Mike visits his house                                              --
------------------------------------------------------------------------
global constant ELF_NOTE_DELIVERED = RegisterSpecialFlag()

global procedure Special_01()
  if SpecialFlagIsOn(MAGIC_FLUTE_USED)
      and not SpecialFlagIsOn(ELF_NOTE_DELIVERED) then
    MessageBox(10, 10, "You return home to find your fields ripped up\n"
                     & "and your entire carrot crop shredded.  All of\n"
                     & "your precious carrot seeds are gone as well.\n"
                     & "\n"
                     & "A message is carved into your door.")
    MessageBox(10, 10, "\"We know that you have found our mystical\n"
                     & "flute and used it for your own greedy and\n"
                     & "inconsequential purposes.  We have prevented\n"
                     & "you from abusing its power any more, so it is\n"
                     & "worthless to you.  We demand that you return\n"
                     & "it immediately!  We have your pathetic carrot\n"
                     & "seeds safely stored away but you will never\n"
                     & "see them again until you return the flute to\n"
                     & "us.\"\n"
                     & "\n"
                     & "Signed,\n"
                     & "  The Brown Elves")
    MessageBox(10, 10, "The brown elves!  You thought they were just\n"
                     & "a legend.  But it seems they are real and\n"
                     & "have your carrot seeds.  Without those seeds\n"
                     & "you will be forced to live as a pauper, or\n"
                     & "worse, as some kind of wandering adventurer\n"
                     & "with no home and no money that didn't come\n"
                     & "covered in blood.  You must return the flute\n"
                     & "as soon as possible!\n"
                     & "\n"
                     & "It's too bad the legends never mentioned where\n"
                     & "the brown elves live.")
    SetSpecialFlag(ELF_NOTE_DELIVERED, ON)
  end if
  ChangeCharFP(+100)
  MessageBox(10, 10, "You spend a night in your own bed.")
  DrawCharFP(hWinCFp)
end procedure
SpecialRoutines[1] = routine_id("Special_01")

------------------------------------------------------------------------
-- Special Event 02                                                   --
-- Mike finds the magic flute                                         --
------------------------------------------------------------------------
global constant MAGIC_FLUTE_GIVEN = RegisterSpecialFlag()

global procedure Special_02()
  integer response
  
  if not SpecialFlagIsOn(MAGIC_FLUTE_GIVEN) then
    response = SelectBox(10, 10, "You find a small wooden flute.",
                                {"Pick it up.","Leave it."})
    if response = 1 then
      if GiveCharacter(MAGIC_FLUTE) then
        SetSpecialFlag(MAGIC_FLUTE_GIVEN, ON)
        MessageBox(10, 10, "You pick up the flute.")
      else
        MessageBox(10, 10, "Your inventory is too full.")
      end if
    end if
  end if
end procedure
SpecialRoutines[2] = routine_id("Special_02")

------------------------------------------------------------------------
-- Special Event 03                                                   --
-- Mike finds the goblin sword                                        --
------------------------------------------------------------------------
global constant GOBLIN_SWORD_GIVEN = RegisterSpecialFlag()

global procedure Special_03()
  integer response
  
  if not SpecialFlagIsOn(GOBLIN_SWORD_GIVEN) then
    response = SelectBox(10, 10,
                        "You find a sword stuck into the trunk of a tree.",
                        {"Pull it out.", "Leave it."})
    if response = 1 then
      if CharRec[CH_WS] < 5 then
        MessageBox(10,10,"Try as you might, you can not pull it out.")
      else
        ReadyCharWeapon(4, "a wooden-hilted sword")
        SetSpecialFlag(GOBLIN_SWORD_GIVEN, ON)
        MessageBox(10,10,"You pull the sword from the trunk of the tree.")
      end if
    end if
  end if
end procedure
SpecialRoutines[3] = routine_id("Special_03")

------------------------------------------------------------------------
-- Special Event 04                                                   --
-- Bob's General Store                                                --
------------------------------------------------------------------------
global procedure Special_04()
  sequence msg
  integer r
  
  if CharacterHasItem(DAVIDS_LETTER)
      and not SpecialFlagIsOn(DAVIDS_LETTER_READ) then
    msg = "Bob takes the letter and looks it over.\n"
        & "Then he looks up at you.\n"
        & "\n"
    if SpecialFlagIsOn(DAVIDS_LETTER_OPENED) then
      msg &= "\"Shame on you,\" he says.  \"Now\n"
           & "we know how trustworthy you really\n"
           & "are, don't we?\"\n"
           & "\n"
           & "Bob rips the letter up in disgust."
      r = TakeFromCharacter(DAVIDS_LETTER)
    else
      SetSpecialFlag(DAVIDS_LETTER_OPENED, ON)
      msg &= "\"I see,\" he says.  \"Maybe you\n"
           & "should read this yourself later.\"\n"
           & "\n"
           & "He hands the letter back to you."
    end if
    MessageBox(10, 10, msg)
    SetSpecialFlag(DAVIDS_LETTER_READ, ON)
  end if
  ShowStore("You are at Bob's General Store.",
            {HEALING_SALVE, STAMINA_PILL, SMALL_WOOD_SHIELD, STEEL_BUCKLER})
end procedure
SpecialRoutines[4] = routine_id("Special_04")

------------------------------------------------------------------------
-- Special Event 05                                                   --
-- Trainers                                                           --
------------------------------------------------------------------------
global procedure Special_05()
  ShowTrainer("You are at Grady's Physical Fitness.", {10, 30, 60})
end procedure
SpecialRoutines[5] = routine_id("Special_05")

------------------------------------------------------------------------
-- Special Event 06                                                   --
-- Mike visits the mayor                                              --
------------------------------------------------------------------------
global constant LISAS_RING_FOUND = RegisterSpecialFlag()
global constant LISA_GAVE_THANKS = RegisterSpecialFlag()
global constant MAYOR_PAID_REWARD = RegisterSpecialFlag()

global procedure Special_06()
  integer n
  sequence msg

  if SpecialFlagIsOn(LISAS_RING_FOUND)
      and SpecialFlagIsOn(LISA_GAVE_THANKS)
      and not SpecialFlagIsOn(MAYOR_PAID_REWARD) then
    MessageBox(10, 10, "The mayor pats you on the back.  \"I\n"
                     & "want to thank you for finding Lisa's\n"
                     & "ring,\" he says.  \"Take this as a\n"
                     & "reward.\"\n"
                     & "\n"
                     & "The mayor gives you 50 gold bits.")
    GiveCharacterBits(50)
    SetSpecialFlag(MAYOR_PAID_REWARD, ON)
    return
  end if
  
  msg = "The mayor rises to greet you.\n\n"
  n = rand(3)
  if n = 1 then
    msg &= "\"Well, if it isn't my good friend Mike,\" he\n"
         & "says.\n\n"
  elsif n = 2 then
    msg &= "\"Good to see you, Mike,\" he says.\n\n"
  elsif n = 3 then
    msg &= "\"Greetings, Mike,\" he says.  \"Hope life is\n"
         & "treating you well.\"\n\n"
  end if
  n = rand(3)
  if n = 1 then
    if SpecialFlagIsOn(MAGIC_FLUTE_USED) then
      if SpecialFlagIsOn(GOBLIN_SWORD_GIVEN) then
        msg &= "\"That's quite a sword you have there.  I'm\n"
             & "glad you're on our side!\""
      else
        msg &= "\"I see that flute of yours did the trick.\""
      end if
    else
      msg &= "\"I hear those pesky rabbits are giving\n"
           & "you quite a problem.\""
    end if
  elsif n = 2 then
    if SpecialFlagIsOn(ELF_NOTE_DELIVERED) then
      msg &= "\"You'd better return that flute to the\n"
           & "elves before they do something nasty.  I\n"
           & "think they live south of here.\""
    else
      msg &= "\"How are you and Lisa getting along\n"
           & "these days?  I remember when you used\n"
           & "to play together as kids."
    end if
  else
    msg &= "\"It's always nice of you to visit.\""
  end if
  MessageBox(10, 10, msg)
end procedure
SpecialRoutines[6] = routine_id("Special_06")

------------------------------------------------------------------------
-- Special Event 07                                                   --
-- Mike visits Lisa, the mayor's daughter                             --
------------------------------------------------------------------------
global procedure Special_07()
  integer n
  sequence msg
  
  if SpecialFlagIsOn(LISAS_RING_FOUND) then
    n = TakeFromCharacter(LISAS_RING)
    if not SpecialFlagIsOn(LISA_GAVE_THANKS) then
      msg = "Lisa screams in delight when she sees her\n"
          & "ring.  \"Oh, thank you!\" she cries and\n"
      n = CharRec[CH_WS]
      if n < 15 then
        msg &= "kisses you long and hard.\n\n"
      elsif n < 30 then
        msg &= "wraps her arms around you in a big hug.\n\n"
      else
        msg &= "shakes your hand.\n\n"
      end if
      msg &= "\"I must have lost it when I was running\n"
           & "from that horrible minotaur!  You were so\n"
           & "brave to get it back for me.\""
      SetSpecialFlag(LISA_GAVE_THANKS, ON)
    else
      msg = "Lisa smiles at you and says, \"I'm so glad  you\n"
          & "found my ring.\""
    end if
  else
    n = rand(3)
    if n = 1 then
      msg = "Lisa is digging through her laundry as you\n"
          & "enter.\n\n"
    elsif n = 2 then
      msg = "Lisa is searching through her cupboards when\n"
          & "you walk in.\n\n"
    elsif n = 3 then
      msg = "You see Lisa's legs sticking out from under her\n"
          & "bed.\n\n"
    end if
    msg &= "\"I'm sorry, but I can't talk right now,\" she\n"
         & "says.  \"I've lost my favorite ring.  Oh, where\n"
         & "could it be?\""
  end if
  MessageBox(10, 10, msg)
end procedure
SpecialRoutines[7] = routine_id("Special_07")

------------------------------------------------------------------------
-- Special Event 08                                                   --
-- Mike finds Lisa's ring                                             --
------------------------------------------------------------------------
global constant ENTERED_MAZE = RegisterSpecialFlag()

global procedure Special_08()
  integer r

  if not SpecialFlagIsOn(ENTERED_MAZE) then
    SetSpecialFlag(ENTERED_MAZE, ON)
  end if  
  if not SpecialFlagIsOn(LISAS_RING_FOUND) then
    r = SelectBox(10, 10,
                  "You find a fancy gold ring laying on the ground.",
                  {"Pick it up.","Leave it"})
    if r = 1 then
      if GiveCharacter(LISAS_RING) then
        SetSpecialFlag(LISAS_RING_FOUND, ON)
      else
        MessageBox(10, 10, "There isn't room in your inventory.")
      end if
    end if
  end if
end procedure
SpecialRoutines[8] = routine_id("Special_08")

------------------------------------------------------------------------
-- Special Event 09                                                   --
-- Mike meets the minotaur                                            --
------------------------------------------------------------------------
global constant MINOTAUR_KILLED = RegisterSpecialFlag()

global procedure Minotaur_Killed_Load()
  Zones[4] = Zones[1] -- Minotaur maze reverts to default zone
end procedure
SetSpecialFlagLoadRtn(MINOTAUR_KILLED,
                      routine_id("Minotaur_Killed_Load"))

global procedure Special_09()
  if not SpecialFlagIsOn(MINOTAUR_KILLED) then
    MessageBox(10, 10, "You hear a crunching noise in the trees.\n"
                     & "As you turn to look, you see a strange\n"
                     & "beast like a giant bull walking upright.\n"
                     & "It is the minotaur and it is charging\n"
                     & "at you!")
    Combat(MINOTAUR) -- Battle the minotaur
    if MonsterRec[MN_FP] > 0 then
      -- Mike ran away (smart boy)
      MoveCharacter({1,0})
    else
      MessageBox(10, 10, "The minotaur lays dead at your feet.\n"
                       & "You take its horns as a trophy.")
      GiveCharacterImportant(MINOTAUR_HORNS)
      SetSpecialFlag(MINOTAUR_KILLED, ON)
    end if
  end if
end procedure
SpecialRoutines[9] = routine_id("Special_09")

------------------------------------------------------------------------
-- Special Event 10                                                   --
-- Jason's house                                                      --
------------------------------------------------------------------------
global constant JASON_TOLD_STORY = RegisterSpecialFlag()
global constant JASON_GAVE_SWORD = RegisterSpecialFlag()

global procedure Special_10()
  integer r
  sequence msg

  r = rand(3)
  if r = 1 then
    msg = "Jason is polishing his sword when you walk\n"
        & "in.  He quickly puts his sword away and\n"
        & "welcomes you in.\n\n"
  elsif r = 2 then
    msg = "Jason is looking over some maps at his\n"
        & "table.  He waves you over to sit with him.\n\n"
  elsif r = 3 then
    msg = "You find Jason reading a book.  He puts\n"
        & "the book down and tells you to come in.\n\n"
  end if
  if SpecialFlagIsOn(MINOTAUR_KILLED) then
    if CharacterHasItem(MINOTAUR_HORNS) then
      msg = "\"You really killed the minotaur, huh?\n"
          & "I guess I was wrong about you.\n"
          & "\n"
          & "\"Would you let me see the horns?\""
      r = SelectBox(10, 10, msg, {"\"Sure.\"","\"No way!\""})
      if r = 1 then
        r = TakeFromCharacter(MINOTAUR_HORNS)
        msg = "\"Cool.  Let me give you something.\n"
            & "It's a sword my dad gave me.  It's\n"
            & "too heavy for me, but maybe you\n"
            & "can use it.\""
        GiveCharacterImportant(HEAVY_SWORD)
        SetSpecialFlag(JASON_GAVE_SWORD, ON)
      else
        msg = "\"Fine!  Be that way.\""
      end if
      MessageBox(10, 10, msg)
    else
      msg = "\"I'm glad the minotaur is dead.\n"
          & "Now I don't have to worry about\n"
          & "him coming out of his maze to\n"
          & "get me.\""
      MessageBox(10, 10, msg)
    end if
  elsif SpecialFlagIsOn(LISAS_RING_FOUND) then
    msg &= "\"I hear you found Lisa's ring, but the\n"
         & "minotaur is still out there.  I guess\n"
         & "you found Lisa's secret path.\n"
         & "\n"
         & "\"I knew you wouldn't try to take on\n"
         & "the minotaur either.\""
    MessageBox(10, 10, msg)
  else
    msg &= "\"Are you out looking for that ring of\n"
         & "Lisa's?\""
    r = SelectBox(10, 10, msg, {"\"Yes.\"","\"No.\""})
    if r = 1 then
      msg = "Jason sighs.  \"You should let her find\n"
          & "her own ring,\" he says.  \"It would do\n"
          & "her good to do something herself.\n"
          & "\n"
          & "\"But if you really want to help her, I\n"
          & "can tell you a secret that will make it\n"
          & "much easier.  Wanna hear it?\""
      r = SelectBox(10, 10, msg, {"\"Sure.\"", "\"Not right now.\""})
      if r = 1 then
        msg = "\"Okay.  Lisa was always fascinated by\n"
            & "the maze north of here.  She always\n"
            & "wanted to go in there, but she's\n"
            & "afraid of the minotaur who lives in\n"
            & "the maze.\n"
            & "\n"
            & "\"One day we were talking about it and\n"
            & "she asked me if I knew how she could\n"
            & "see the maze without worrying about\n"
            & "the minotaur.\n"
            & "\n"
            & "\"I thought about it and came up with an\n"
            & "idea.\""
        MessageBox(10, 10, msg)
        msg = "\"I cut out a secret path from Lisa's\n"
            & "house to the maze.  Lisa was so happy\n"
            & "she kissed me!\n"
            & "\n"
            & "\"We went down the path one afternoon\n"
            & "and walked a little ways into the\n"
            & "maze.  Lisa looked at all of the\n"
            & "flowers growing there and wanted to\n"
            & "take some back home with her.  She\n"
            & "talked me into helping her pick some\n"
            & "of them.\""
        MessageBox(10, 10, msg)
        msg = "\"Then we heard something coming.  We\n"
            & "looked up to see the minotaur\n"
            & "charging at us.  We ran away and\n"
            & "managed to sneak down the secret path\n"
            & "before the minotaur could catch us.\n"
            & "\n"
            & "\"I bet Lisa lost her ring when we\n"
            & "were running from the minotaur.\""
        MessageBox(10, 10, msg)
        msg = "\"The worst part is that she called me\n"
            & "a coward because I ran from the\n"
            & "minotaur.  She thought I should have\n"
            & "fought that thing to give her a\n"
            & "better chance to escape.  Can you\n"
            & "believe that?\n"
            & "\n"
            & "\"Anyway, that's my story.  I\n"
            & "wouldn't help her if I was you.  But\n"
            & "if you plan on looking for her ring,\n"
            & "then remember what I told you.\""
      else
        msg = "\"Fine!  Be that way.\""
      end if
      MessageBox(10, 10, msg)
    else
      msg = "Jason smiles and says, \"Good for you.\n"
          & "Let her find that ring herself, I say!\""
      MessageBox(10, 10, msg)
    end if
  end if
end procedure
SpecialRoutines[10] = routine_id("Special_10")

------------------------------------------------------------------------
-- Special Event 11                                                   --
-- The Traveller's Rest North                                         --
------------------------------------------------------------------------
global procedure Special_11()
  ShowInn("You are at the Traveller's Rest.", 10, 20)
end procedure
SpecialRoutines[11] = routine_id("Special_11")

------------------------------------------------------------------------
-- Special Event 12                                                   --
-- Tan Elf Warning Signs                                              --
------------------------------------------------------------------------
global procedure Special_12()
  integer r

  MessageBox(10, 10, "A sign here reads\n"
                   & "\n"
                   & "Elven Territory\n"
                   & "NO HUMANS ALLOWED!")
end procedure
SpecialRoutines[12] = routine_id("Special_12")

------------------------------------------------------------------------
-- Special Event 13                                                   --
-- General Tan Elf House                                              --
------------------------------------------------------------------------
global procedure Special_13()
  MessageBox(10, 10, "The door is bolted shut.  A voice calls out\n"
                   & "from the other side.\n"
                   & "\n"
                   & "\"No humans allowed!  Only the elf chief can\n"
                   & "make exceptions!\"")
end procedure
SpecialRoutines[13] = routine_id("Special_13")

------------------------------------------------------------------------
-- Special Event 14                                                   --
-- Tan Elf Chief's House                                              --
------------------------------------------------------------------------
global procedure Special_14()
  MessageBox(10, 10, "The door is bolted shut.  A voice calls out\n"
                   & "from the other side.\n"
                   & "\n"
                   & "\"The chief is busy!  Go bother the brown\n"
                   & "elves and leave us tan elves in peace!\"")
end procedure
SpecialRoutines[14] = routine_id("Special_14")

------------------------------------------------------------------------
-- Special Event 15                                                   --
-- The Oracle                                                         --
------------------------------------------------------------------------
global procedure Special_15()
  integer r
  sequence msg

  r = SelectBox(10, 10, "You enter a cabin that is completely bare save\n"
                      & "for a simple chair in the center of the room.\n"
                      & "A voice whispers in your ear, inviting you to\n"
                      & "sit.\n",
                        {"Sit","Leave"})
  if r = 1 then
    msg = "The voice whispers in your ear as you sit.\n\n"
    if not SpecialFlagIsOn(MAGIC_FLUTE_USED) then
      msg &= "\"The flute eagerly awaits your discovery.\""
    elsif not SpecialFlagIsOn(LISAS_RING_FOUND) then
      msg &= "\"Lisa seeks her precious.\""
    elsif not SpecialFlagIsOn(MINOTAUR_KILLED) then
      msg &= "\"The maze is cursed by an abomination.\""
    elsif not SpecialFlagIsOn(JASON_GAVE_SWORD) then
      msg &= "\"Jason seeks a hero.\""
    else
      msg &= "\"Return the flute, as it does not belong "
           & "to you.\""
    end if
    MessageBox(10, 10, msg)
  end if
end procedure
SpecialRoutines[15] = routine_id("Special_15")

------------------------------------------------------------------------
-- Special Event 16                                                   --
-- Entrance to the maze                                               --
------------------------------------------------------------------------
global procedure Special_16()
  if not SpecialFlagIsOn(ENTERED_MAZE) then
    MessageBox(10, 10, "You stand at the entrance to a maze.  Paths\n"
                     & "are cut between the trees and beautiful\n"
                     & "flowers grow in the open spots.  But there\n"
                     & "are bones among the flowers, the remains\n"
                     & "of people brave or foolish enough to enter\n"
                     & "the maze.")
    SetSpecialFlag(ENTERED_MAZE, ON)
  end if
end procedure
SpecialRoutines[16] = routine_id("Special_16")


------------------------------------------------------------------------
-- Special Event 17                                                   --
-- The brown elves                                                    --
------------------------------------------------------------------------
global procedure Special_17()
  MessageBox(10, 10, "You hear the pitter-patter of soft little\n"
                   & "feet approaching.  Several dirty elves\n"
                   & "wearing only potato sacks scuttle out of\n"
                   & "the trees.\n"
                   & "\n"
                   & "\"Stop staring,\" one of them snaps.\n"
                   & "\"Haven't you ever seen a brown elf\n"
                   & "before?  Geez.\"\n"
                   & "\n"
                   & "\"Never mind,\" another one says.\n\"Just"
                   & "\"give me the flute.\"")
  MessageBox(10, 10, "You start to hand the flute over and he\n"
                   & "snatches it from your hand.\n"
                   & "\n"
                   & "\"Finally!\" he cries.  \"The mystical flute\n"
                   & "has returned.  Our beautiful music will once\n"
                   & "again be the envy of the entire forest.\n"
                   & "\n"
                   & "The elf begins playing the flute very badly.\n"
                   & "You are forced to listen to it and smile\n"
                   & "encouragingly for several minutes.")
  MessageBox(10, 10, "Finally, the elf stops assaulting your ear\n"
                   & "drums.  He motions to the others who slip\n"
                   & "into the trees and return with two sacks.\n"
                   & "\n"
                   & "\"A deal's a deal,\" the leader says.  \"We\n"
                   & "had to plant some of your seeds to feed us\n"
                   & "since you took so long.  But the rest of\n"
                   & "them are there.")
  MessageBox(10, 10, "You remember having fifteen sacks of seeds\n"
                   & "when you left to find the flute.  You are\n"
                   & "tempted to start knocking some elven heads\n"
                   & "around, but then you get worried that they\n"
                   & "might start trying to play the flute again.\n"
                   & "You smile and thank them for returning\n"
                   & "your seeds and begin the long walk back\n"
                   & "home where a simple life of carrot farming\n"
                   & "awaits you once again.")
  GameWon = 1
end procedure
SpecialRoutines[17] = routine_id("Special_17")

------------------------------------------------------------------------
-- Special Event 18                                                   --
-- Challenging Jared, the head bandit                                 --
------------------------------------------------------------------------
global constant JARED_KILLED = RegisterSpecialFlag()

global procedure Jared_Killed_Load()
  Zones[5] = Zones[1] -- Bandit area reverts to default zone
end procedure
SetSpecialFlagLoadRtn(JARED_KILLED,
                      routine_id("Jared_Killed_Load"))

global procedure Special_18()
  if not SpecialFlagIsOn(JARED_KILLED) then
    MessageBox(10, 10, "The house appears to be empty.  Then.\n"
                     & "you hear a sound above you.  You look\n"
                     & "up to see a man jumping on you from\n"
                     & "the rafters.  This must be the\n"
                     & "bandits' leader.")
    Combat(JARED) -- Battle Jared
    if MonsterRec[MN_FP] > 0 then
      -- Mike ran away (smart boy)
      MoveCharacter({-1,0})
    else
      MessageBox(10, 10, "You hear gasps as Jared falls dead.\n"
                       & "at your feet.  Six bandits are\n"
                       & "standing in the door.  But they\n"
                       & "turn and run as soon as your gaze\n"
                       & "falls on them.\n"
                       & "\n"
                       & "You slip Jared's ring into your\n"
                       & "pocket.  You search the rest of the\n"
                       & "house, hoping for a horde of loot,\n"
                       & "but there is none to be found.")
      GiveCharacterImportant(BANDIT_RING)
      SetSpecialFlag(JARED_KILLED, ON)
    end if
  end if
end procedure
SpecialRoutines[18] = routine_id("Special_18")

------------------------------------------------------------------------
-- Special Event 19                                                   --
-- Seaview houses                                                     --
------------------------------------------------------------------------
global procedure Special_19()
  integer r

  r = rand(7)
  if r = 1 then
    MessageBox(10, 10, "Seaview is a nice town, but you should\n"
                     & "stay out of the badlands to the\n"
                     & "southeast.")
  elsif r = 2 then
    MessageBox(10, 10, "I really like it here in Seaview.  The\n"
                     & "sunset over the ocean is so beautiful.")
  elsif r = 3 then
    MessageBox(10, 10, "The forest is dangerous, but there are\n"
                     & "never any monsters in Seaview.")
  elsif r = 4 then
    MessageBox(10, 10, "Seaview is probably the nicest place\n"
                     & "in the whole world.")
  elsif r = 5 then
    MessageBox(10, 10, "Living in Seaview can be a little\n"
                     & "expensive, but the quality of life is\n"
                     & "worth it.")
  elsif r = 6 then
    MessageBox(10, 10, "I wonder if I'm the only one who gets\n"
                     & "a little sick of hearing how great\n"
                     & "Seaview is.")
  elsif r = 7 then
    MessageBox(10, 10, "I'm not going to listen to all that\n"
                     & "blathering any more.")
  end if
end procedure
SpecialRoutines[19] = routine_id("Special_19")

------------------------------------------------------------------------
-- Special Event 20                                                   --
-- Seaview Fitness Center                                             --
------------------------------------------------------------------------
global procedure Special_20()
  ShowTrainer("You are at Seaview Fitness Center.", {20, 50, 100})
end procedure
SpecialRoutines[20] = routine_id("Special_20")

------------------------------------------------------------------------
-- Special Event 21                                                   --
-- David's Trading Post                                               --
------------------------------------------------------------------------
global procedure Special_21()
  sequence msg
  integer r

  if not SpecialFlagIsOn(DAVID_ASKED) then
    r = SelectBox(10, 10, "The shopkeeper seems pleased to\n"
                        & "see you.  \"You are from Graun\n"
                        & "forest, aren't you,\" he asks.\n"
                        & "\"Would you deliver a letter from\n"
                        & "me to Bob the shopkeeper on your\n"
                        & "way back?\"",
                         {"Of course", "No, I'm too busy."})
    SetSpecialFlag(DAVID_ASKED, ON)
    if r = 1 then
      MessageBox(10, 10, "\"Great!  Here you go.\"\n"
                       & "\n"
                       & "The shopkeeper hands you a sealed\n"
                       & "letter.")
      GiveCharacterImportant(DAVIDS_LETTER)
    else
      MessageBox(10, 10, "I see.  Very well.")
    end if
  elsif SpecialFlagIsOn(DAVIDS_LETTER_READ)
      and not SpecialFlagIsOn(DAVID_PAID_REWARD)
      and CharacterHasItem(DAVIDS_LETTER)
      and CharacterHasItem(BANDIT_RING) then
    MessageBox(10, 10, "David smiles when he sees you.  \"I see\n"
                     & "you defeated Jared,\" he says.  \"Good\n"
                     & "for you.  Here is your reward, as\n"
                     & "promised.\"\n"
                     & "\n"
                     & "David gives you 200 bits and takes the\n"
                     & "letter back.")
    GiveCharacterBits(200)
    r = TakeFromCharacter(DAVIDS_LETTER)
    SetSpecialFlag(DAVID_PAID_REWARD, ON)
  end if
  ShowStore("You are at David's Trading Post.",
            {HEALING_SALVE, STAMINA_PILL, ROUND_IRON_SHIELD})
end procedure
SpecialRoutines[21] = routine_id("Special_21")

------------------------------------------------------------------------
-- Special Event 22                                                   --
-- Eddie's Emporium                                                   --
------------------------------------------------------------------------
global procedure Special_22()
  ShowStore("You are at Eddie's Emporium",
            {STUMBLE_CRYSTAL, GREATSWORD, TOWER_SHIELD})
end procedure
SpecialRoutines[22] = routine_id("Special_22")

------------------------------------------------------------------------
-- Special Event 23                                                   --
-- Traveller's Rest South                                             --
------------------------------------------------------------------------
global procedure Special_23()
  ShowInn("You are at the Traveller's Rest.", 15, 20)
end procedure
SpecialRoutines[23] = routine_id("Special_23")

------------------------------------------------------------------------
-- Special Event 24                                                   --
-- Seaside Inn                                                        --
------------------------------------------------------------------------
global procedure Special_24()
  ShowInn("You are at the Seaside Inn.", 25, 25)
end procedure
SpecialRoutines[24] = routine_id("Special_24")