-----------------------------------------------------------------------------
-- rpggen.e                                                                --
-- General routines for rpg.ex.  They are declared here to make them       --
-- available in other include members.                                     --
--                                                                         --
-- written by Mike Wever                                                   --
-----------------------------------------------------------------------------

------------------------------------------------------------------------
-- Use an item.                                                       --
-- Parameters:                                                        --
--   sequence: top left corner for item selection box                 --
------------------------------------------------------------------------
global procedure UseItem(sequence topLeft)
  sequence inv
  sequence list
  integer item

  inv = {}
  for i = 1 to length(CharRec[CH_INV]) do
    item = CharRec[CH_INV][i]
    if (InCombat and Items[item][ITEM_CBT_USE])
        or (not InCombat and Items[item][ITEM_NONCBT_USE]) then
      inv = append(inv,item)
    end if
  end for
  if length(inv) = 0 then
    MessageBox(topLeft[1], topLeft[2],
               "You have nothing that is useful now.")
  else  
    list = {}
    for i = 1 to length(inv) do
      list = append(list,Items[inv[i]][ITEM_NAME])
    end for
    item = SelectBox(topLeft[1], topLeft[2], "What do you want to use?", list)
    if item > 0 then
      if Items[inv[item]][ITEM_USE] = -1 then
        MessageBox(topLeft[1], topLeft[2], "You can't use that.")
      else
        call_proc(Items[inv[item]][ITEM_USE],{})
      end if
    end if
  end if
end procedure

------------------------------------------------------------------------
-- Handle combat between the character and a monster                  --
-- Parameters:                                                        --
--   integer: monster to fight                                        --
------------------------------------------------------------------------
global procedure Combat(integer monster)
  sequence msg1, msg2
  integer r
  integer rollLimit,roll
  integer dmg
  atom hWin1, hWin2, hWinMFp

  InCombat = 1  
  MonsterRec = MonsterList[monster]
  rollLimit = CharRec[CH_WS] + MonsterRec[MN_WS]
  msg1 = "You have encountered"
  -- Avoid putting the in front of proper names
  if MonsterRec[MN_NAME][1] >= 'A' and MonsterRec[MN_NAME][1] <= 'Z' then
    msg1 &= " " & MonsterRec[MN_NAME] & "."
  else
    if find(MonsterRec[MN_NAME][1],"aeiou") then
      msg1 &= " an " & MonsterRec[MN_NAME] & "."
    else
      msg1 &= " a " & MonsterRec[MN_NAME] & "."
    end if
  end if
  msg2 = ""
  hWinMFp = LoadWindow(ScreenWidth - 24, 15, ScreenWidth - 5, 19)
  DrawMonsterFP(hWinMFp)
  hWin1 = DrawMessageBox(10, 10, msg1)
  while 1 = 1 do
    if length(msg2) != 0 then
      MessageBox(10, 40, msg2)
    end if
    msg2 = ""
    r = SelectBox(10, 40, "What do you want to do?",
                          {"Attack", "Run Away", "Use Item"})
    if r = 1 then
      -- Attack
      roll = rand(rollLimit)
      if roll > CharRec[CH_WS] then
        msg2 = "You miss."
        -- better chance of learning something from an opponent more skilled than you
        roll = rand(100) + (MonsterRec[MN_WS] - CharRec[CH_WS])
        if roll <= 5 then
          ChangeCharExp(+1)
        end if
      else
        -- Avoid putting the in front of proper names
        if MonsterRec[MN_NAME][1] >= 'A' and MonsterRec[MN_NAME][1] <= 'Z' then
          msg2 = "You hit " & MonsterRec[MN_NAME] & "."
        else
          msg2 = "You hit the " & MonsterRec[MN_NAME] & "."
        end if
        dmg = floor(CharRec[CH_DMG] * (roll * (CharRec[CH_WS] / 100)))
        if dmg = 0 then
          dmg = 1
        end if
        dmg -= floor(MonsterRec[MN_PROT] * (roll * (MonsterRec[MN_WS] / 100)))
        -- better chance of learning something from an opponent more skilled than you
        roll = rand(100) + (MonsterRec[MN_WS] - CharRec[CH_WS])
        if roll <= (100 - CharRec[CH_WS]) then
          ChangeCharExp(+1)
        end if
        if dmg < 0 then
          dmg = 0
        end if
        MonsterRec[MN_FP] -= dmg
        DrawMonsterFP(hWinMFp)
        if MonsterRec[MN_FP] < 1 then
          InCombat = 0
          exit
        end if
      end if
    elsif r = 2 then
      -- Run away
      roll = rand(rollLimit)
      if roll <= CharRec[CH_WS] then
        -- Avoid putting the in front of proper names
        if MonsterRec[MN_NAME][1] >= 'A' and MonsterRec[MN_NAME][1] <= 'Z' then
          msg2 = "You escape from " & MonsterRec[MN_NAME] & "."
        else
          msg2 = "You escape from the " & MonsterRec[MN_NAME] & "."
        end if
        InCombat = 0
        exit
      else
        msg2 = "You could not escape."
      end if
    elsif r = 3 then
      -- Use Item
      UseItem({10, 40})
    end if
    roll = rand(rollLimit)
    if length(msg2) > 0 then
      msg2 &= "\n\n"
    end if
    if roll > MonsterRec[MN_WS] then
      -- Avoid putting the in front of proper names
      -- (such as "The Jared misses.")
      if MonsterRec[MN_NAME][1] >= 'A' and MonsterRec[MN_NAME][1] <= 'Z' then
        msg2 &= MonsterRec[MN_NAME] & " misses."
      else
        msg2 &= "The " & MonsterRec[MN_NAME] & " misses."
      end if
    else
      -- Avoid putting the in front of proper names
      -- (such as "The Jared hits you.")
      if MonsterRec[MN_NAME][1] >= 'A' and MonsterRec[MN_NAME][1] <= 'Z' then
        msg2 &= MonsterRec[MN_NAME] & " hits you."
      else
        msg2 &= "The " & MonsterRec[MN_NAME] & " hits you."
      end if
      dmg = floor(MonsterRec[MN_DMG] * (roll * (MonsterRec[MN_WS] / 100)))
      if dmg = 0 then
        dmg = 1
      end if
      dmg -= floor(CharRec[CH_PROT] * (roll * (CharRec[CH_WS] / 100)))
      if dmg < 0 then
        dmg = 0
      end if
      CharRec[CH_FP] -= dmg
      DrawCharFP(hWinCFp)
      if CharRec[CH_FP] < 1 then
        InCombat = 0
        exit
      end if
    end if
  end while
  if CharRec[CH_FP] < 1 then
    UnloadWindow(hWin1)
    return
  else
    if MonsterRec[MN_FP] < 1 then
      UnloadWindow(hWin1)
      MonsterKilled()
    else
      MessageBox(10, 40, msg2)
      UnloadWindow(hWin1)
    end if
    -- Remove effects of any stamina pills taken
    if StaminaPillAmount > 0 then
      CharRec[CH_FP] -= StaminaPillAmount
      if CharRec[CH_FP] < 1 then
        CharRec[CH_FP] = 1
      end if
      DrawCharFP(hWinCFp)
      MessageBox(10, 10, "Increased stamina wears off.")
    end if
  end if
  StaminaPillAmount = 0
  InCombat = 0
  UnloadWindow(hWinMFp)
end procedure

-----------------------------------------------------------------------------
-- Change the character's position.                                        --
-- Parameters:                                                             --
--   sequence: changes {map x change, map y change}                        --
-----------------------------------------------------------------------------
global procedure MoveCharacter(sequence change)
  sequence origPos
  integer special
  integer z, roll

  origPos = CharPos
  CharPos += change
  if CharPos[1] < 1 then
    CharPos[1] = 1
  elsif CharPos[1] > MapSize[1] then
    CharPos[1] = MapSize[1]
  end if
  if CharPos[2] < 1 then
    CharPos[2] = 1
  elsif CharPos[2] > MapSize[2] then
    CharPos[2] = MapSize[2]
  end if
  -- Check if character walked into a special area
  special = Map[CharPos[2]][CharPos[1]][MAP_SPECIAL]
  if special then
    DoSpecial = special
  end if
  if Map[CharPos[2]][CharPos[1]][MAP_PASSABLE] = IMPASSABLE then
    CharPos = origPos
  else
    CharPicNum += 1
    if CharPicNum > CHAR_PIC_MAX then
      CharPicNum = 1
    end if
  end if
  PaintScreen()
  -- Check if a monster appears
  z = Map[CharPos[2]][CharPos[1]][MAP_ZONE]
  roll = rand(100)
  for i = 1 to length(Zones[z]) do
    if roll >= Zones[z][i][ZONE_RANGE_BEG]
        and roll <= Zones[z][i][ZONE_RANGE_END] then
      if Zones[z][i][ZONE_MONSTER] then
        Combat(Zones[z][i][ZONE_MONSTER])
        if CharRec[CH_FP] < 1 then
          return
        end if
      end if
      exit
    end if
  end for
end procedure

-----------------------------------------------------------------------------
-- Run a store's buy and sell options.                                     --
-- Parameters:                                                             --
--   sequence: the first line for the store (you are at ...)               --
--   sequence: a list of items the store offers                            --
-----------------------------------------------------------------------------
global procedure ShowStore(sequence storeMsg, sequence stock)
  sequence options
  integer rMain, rSub1
  integer optOut
  sequence bitsMsg
  sequence msg
  integer itemNum
  sequence item
  integer sellVal
  sequence sellList

  rMain = 0
  while rMain != 3 do
    bitsMsg = sprintf("You have %d gold bits.",{CharRec[CH_BITS]})
    rMain = SelectBox(10, 10, storeMsg & "\n" & bitsMsg,
                             {"Buy Items", "Sell Items", "Leave"})
    if rMain = 1 then
      -- Buy items
      options = {}
      for i = 1 to length(stock) do
        options = append(options,Items[stock[i]][ITEM_NAME]
                                 & sprintf(" (%d bits)",
                                           {Items[stock[i]][ITEM_VAL]}))
      end for
      options = append(options,"Finished")
      optOut = length(options)
      rSub1 = 0
      while rSub1 != optOut do
        bitsMsg = sprintf("You have %d gold bit",{CharRec[CH_BITS]})
        if CharRec[CH_BITS] != 1 then
          bitsMsg &= "s."
        else
          bitsMsg &= '.'
        end if
        rSub1 = SelectBox(10, 10, storeMsg & "\n" & bitsMsg
                                  & "\nWhat would you like to buy?",
                                  options)
        if rSub1 != optOut then
          itemNum = stock[rSub1]
          item = Items[itemNum]
          if TakeBitsFromCharacter(item[ITEM_VAL]) then
            if GiveCharacter(itemNum) then
              msg = "You buy a"
              if find(item[ITEM_NAME][1],"aeiou") then
                msg &= "n " & item[ITEM_NAME] & '.'
              else
                msg &= ' ' & item[ITEM_NAME] & '.'
              end if
              MessageBox(20, 20, msg)
            else
              GiveCharacterBits(item[ITEM_VAL])
              MessageBox(20, 20,
                         "You don't have enough room in your inventory.")
            end if
          else
            MessageBox(20, 20, "You don't have enough gold bits.")
          end if
        end if
      end while
    elsif rMain = 2 then
      -- Sell items
      rSub1 = 0
      optOut = -1
      while rSub1 != optOut do
        sellList = {}
        options = {}
        for i = 1 to length(CharRec[CH_INV]) do
          item = Items[CharRec[CH_INV][i]]
          if item[ITEM_VAL] != -1 then
            msg = item[ITEM_NAME]
            sellVal = floor(item[ITEM_VAL] / 2)
            if sellVal = 0 then
              sellVal = 1
            end if
            msg &= sprintf(" (%d bits)",{sellVal})
            options = append(options, msg)
            sellList = append(sellList,{CharRec[CH_INV][i],sellVal})
          end if
        end for
        options = append(options,"Finished")
        optOut = length(options)
        bitsMsg = sprintf("You have %d gold bits.",{CharRec[CH_BITS]})
        rSub1 = SelectBox(10, 10, storeMsg & "\n" & bitsMsg
                                  & "\nWhat would you like to sell?",
                                  options)
        if rSub1 != optOut then
          itemNum = sellList[rSub1][1]
          item = Items[itemNum]
          if TakeFromCharacter(itemNum) then
            GiveCharacterBits(sellList[rSub1][2])
            msg = "You sell a"
            if find(item[ITEM_NAME][1],"aeiou") then
              msg &= "n " & item[ITEM_NAME] & '.'
            else
              msg &= ' ' & item[ITEM_NAME] & '.'
            end if
            MessageBox(20, 20, msg)
          end if
        end if
      end while
    end if
  end while
end procedure

-----------------------------------------------------------------------------
-- Run a trainer.                                                          --
-- Parameters:                                                             --
--   sequence: the first line of the trainer (you are at...)               --
--   sequence: the rates for services performed in the following order     --
--               (if a service is not available, its rate should be -1)    --
--             1) rate skills                                              --
--             2) practice weapon skills (increase WS)                     --
--             3) get combat training (increase FP)                        --
-----------------------------------------------------------------------------
constant SERVICES = {"Get a rating of your skills",
                     "Practice with your weapon",
                     "Get combat training"}
constant RATE_SKILLS = 1
constant PRACTICE_WPN = 2
constant COMBAT_TRN = 3
global procedure ShowTrainer(sequence trainerMsg, sequence rates)
  integer r
  sequence msg
  sequence bitsMsg
  sequence options, optionNums
  integer rating
  integer optOut
  integer roll, increase, possibleIncr
  atom pct

  options = {}
  optionNums = {}
  for i = 1 to length(rates) do
    if rates[i] >= 0 then
      options = append(options,
                       SERVICES[i] & sprintf(" (%d bits)",{rates[i]}))
      optionNums = append(optionNums,i)
    end if
  end for
  options = append(options, "Leave")
  optOut = length(options)
  r = 1
  while r != optOut do
    bitsMsg = sprintf("You have %d gold bits.",{CharRec[CH_BITS]})
    msg = trainerMsg & "\n"
        & bitsMsg & "\n"
        & "What would you like to do?"
    r = SelectBox(10, 10, msg, options)
    if r != optOut then
      if not TakeBitsFromCharacter(rates[optionNums[r]]) then
        MessageBox(10, 10, "You don't have enough money.")
      else
        if optionNums[r] = RATE_SKILLS then
          -- get a rating of your weapon skill level
          rating = CharRec[CH_WS]
          if rating < 0 then
            rating = 0
          end if
          MessageBox(10, 10, "The trainer looks you over and runs you\n"
                           & "through a gamut of tests.  He consults\n"
                           & "some charts and thinks it over.  Then\n"
                           & "he gives you a rating of "
                           & sprintf("%d",{rating}) & " percent.")
        elsif optionNums[r] = PRACTICE_WPN then
          -- weapon training to increase weapon skill
          increase = 0
          for i = 1 to 10 do
            roll = rand(CharRec[CH_WS] * 2)
            if roll > CharRec[CH_WS] then
              roll = rand(100)
              if roll <= 5 then
                ChangeCharExp(+2)
                increase += 2
              end if
            else
              roll = rand(100)
              if roll <= (100 - CharRec[CH_WS]) then
                ChangeCharExp(+2)
                increase += 2
              end if
            end if
          end for
          msg = "You spar with a training dummy for\n"
              & "half an hour, while the trainer\n"
              & "yells to you about what you are doing\n"
              & "wrong.\n\n"
          if increase >= 15 then
            msg &= "You feel you have learned a lot."
          elsif increase >= 7 then
            msg &= "You feel the lesson was worth the effort."
          elsif increase >= 3 then
            msg &= "You leave frustrated."
          else
            msg &= "You are sure you have wasted your time."
          end if
          MessageBox(10, 10, msg)
        elsif optionNums[r] = COMBAT_TRN then
          -- Combat training to increase fighting points
          -- Increase is 0 - 25% of (100 - current FP)
          possibleIncr = 100 - CharRec[CH_FP]
          roll = rand(possibleIncr)
          pct = (roll / 400)
          increase = floor((possibleIncr * pct) + .5)
          CharRec[CH_FP_MAX] += increase
          CharRec[CH_FP] += increase
          msg = "You and the trainer spar with wooden\n"
              & "swords for half an hour.\n\n"
          if increase > 10 then
            msg &= "You learn some excellent defensive\n"
                 & "manuevers."
          elsif increase > 5 then
            msg &= "You feel more confident about your\n"
                 & "ability to take on foes stronger\n"
                 & "than yourself."
          elsif increase > 0 then
            msg &= "You are tired and sweaty at the end\n"
                 & "of the session, and you wonder if\n"
                 & "you really learned anything."
          else
            msg &= "You leave with nothing more than a\n"
                 & "bruised body and spirit."
          end if
          MessageBox(10, 10, msg)
        end if
      end if
    end if
  end while
end procedure

-----------------------------------------------------------------------------
-- Run an inn.                                                             --
-- Parameters:                                                             --
--   sequence: first line of inn (You are at...)                           --
--   integer:  rate for a bed for one night                                --
--   integer:  FP recovery amount                                          --
-----------------------------------------------------------------------------
global procedure ShowInn(sequence innMsg, integer rate, integer recover)
  integer r

  r = SelectBox(10, 10, innMsg & "\n"
                      & "Would you like to stay the night?\n"
                      & sprintf("A bed costs %d bits.\n",{rate}),
                       {"Yes", "No"})
  if r = 1 then
    if TakeBitsFromCharacter(rate) then
      ChangeCharFP(recover)
      MessageBox(10,10,"You wake feeling refreshed.")
      DrawCharFP(hWinCFp)
    else
      MessageBox(10, 10, "This isn't a charity.  Come back when you\n"
                       & "have the money.")
    end if
  end if
end procedure
