-----------------------------------------------------------------------------
-- rpgmnstr.e                                                              --
-- Routines relating to the monsters for rpg.ex                            --
--                                                                         --
-- written by Mike Wever                                                   --
-----------------------------------------------------------------------------

-- Define monster sequence entries
global constant MN_NAME   = 1 -- Monster's name
global constant MN_FP     = 2 -- Fighting Points
global constant MN_FP_MAX = 3 -- Maximum Fighting Points
global constant MN_WS     = 4 -- Weapon Skill
global constant MN_INV    = 5 -- Inventory (items carried)
global constant MN_BITS   = 6 -- Bits carried {num dice, num sides, addtl}
global constant MN_DMG    = 7 -- Damage for weapon in hand
global constant MN_PROT   = 8 -- Protection for thick hide and/or shield

-- Monster record
global sequence MonsterRec
MonsterRec = {"", 0, 0, 0, {}, 0, 0}

-- This will hold the list of monsters for the game.
global sequence MonsterList
MonsterList = {}

------------------------------------------------------------------------
-- Register a new monster.                                            --
-- Parameters:                                                        --
--   sequence: monster record information                             --
-- Returns:                                                           --
--   id for monster                                                   --
------------------------------------------------------------------------
global function RegisterMonster(sequence mon)
  MonsterList = append(MonsterList, mon)
  return length(MonsterList)
end function
  
------------------------------------------------------------------------
-- When a monster dies, the character automatically gets the items    --
-- from the dead monster's inventory                                  --
------------------------------------------------------------------------
global procedure MonsterKilled()
  sequence msg
  sequence bitsPossible
  integer b

  if MonsterRec[MN_NAME][1] >= 'A' and MonsterRec[MN_NAME][1] <= 'Z' then
    msg = MonsterRec[MN_NAME] & " dies."
  else
    msg = "The " & MonsterRec[MN_NAME] & " dies."
  end if
  bitsPossible = MonsterRec[MN_BITS]
  b = 0
  for i = 1 to bitsPossible[1] do
    b += rand(bitsPossible[2])
  end for
  b += bitsPossible[3]
  if b < 0 then
    b =0
  end if
  if length(MonsterRec[MN_INV]) > 0 or b > 0 then
    msg &= "\n\nYou find..."
    for i = 1 to length(MonsterRec[MN_INV]) do
      msg &= "\n  " & Items[MonsterRec[MN_INV][i]][ITEM_NAME]
      if not GiveCharacter(MonsterRec[MN_INV][i]) then
        msg &= " (will not fit in inventory)"
      end if
    end for
    if b > 0 then
      msg &= sprintf("\n%d gold bit",{b})
      if b > 1 then
        msg &= 's'
      end if
      GiveCharacterBits(b)
    end if
  end if
  MessageBox(10, 10, msg)
  MonsterRec = {"", 0, 0, 0, {}, 0, 0}
end procedure

-----------------------------------------------------------------------------
-- Draw the monster's fighting points meter.                               --
-- Parameters:                                                             --
--   atom: handle of window to draw in                                     --
-----------------------------------------------------------------------------
global procedure DrawMonsterFP(atom hWin)
  atom pct
  sequence bar
  integer fp

  bar = repeat(RPG_WHITE,20)
  pct = MonsterRec[MN_FP] / MonsterRec[MN_FP_MAX]
  fp = floor(20 * pct)
  if fp < 1 and MonsterRec[MN_FP] > 0 then
    fp = 1
  end if
  for i = 1 to fp by 1 do
    bar[i] = RPG_BLUE
  end for
  SetPixels(hWin,repeat(RPG_WHITE,20),{0,0})
  for i = 1 to 3 do
    SetPixels(hWin,bar,{0,i})
  end for
  SetPixels(hWin,repeat(RPG_WHITE,20),{0,4})
end procedure

-----------------------------------------------------------------------------
-- Change the monster's skill                                              --
-- Parameters:                                                             --
--   atom: amount of change                                                --
-----------------------------------------------------------------------------
global procedure ChangeMonsterWS(atom amt)
  MonsterRec[MN_WS] += amt
end procedure
