------------------------------------------------------------------------
-- rpgspcl.e                                                          --
-- Special event routines for rpg.ex                                  --
--                                                                    --
-- Written by Mike Wever                                              --
------------------------------------------------------------------------


-- This will hold routine ids for the special event routines
global sequence SpecialRoutines
SpecialRoutines = repeat(-1,99)

global constant SPCF_VAL = 1
global constant SPCF_LOAD = 2

-- Flags relating to special events
global sequence SpecialFlags
SpecialFlags = {}

global constant ON = 1
global constant OFF = 0

------------------------------------------------------------------------
-- Initialize all special flags to off for a new game.                --
------------------------------------------------------------------------
global procedure InitSpecial()
  for i = 1 to length(SpecialFlags) do
    SpecialFlags[i][1] = OFF
  end for
end procedure

------------------------------------------------------------------------
-- Register a special event flag.                                     --
-- Returns:                                                           --
--   integer: handle of special flag                                  --
------------------------------------------------------------------------
global function RegisterSpecialFlag()
  SpecialFlags = append(SpecialFlags,{0,-1})
  return length(SpecialFlags)
end function

------------------------------------------------------------------------
-- Specify the routine to be done when a special flag is on for a     --
-- game that is being loaded.
-- Parameters:                                                        --
--   integer: handle of special flag                                  --
--   integer: id of routine to be done                                --
------------------------------------------------------------------------
global procedure SetSpecialFlagLoadRtn(integer sfId, atom rtn)
  SpecialFlags[sfId][SPCF_LOAD] = rtn
end procedure

------------------------------------------------------------------------
-- Perform the required processing when a flag is on for a game that  --
-- is being loaded.                                                   --
-- Parameters:                                                        --
--   integer: handle of special flag                                  --
------------------------------------------------------------------------
global procedure DoSpecialFlagLoadRtn(integer sfId)
  if SpecialFlags[sfId][SPCF_LOAD] != -1 then
    call_proc(SpecialFlags[sfId][SPCF_LOAD],{})
  end if
end procedure

------------------------------------------------------------------------
-- Check if a special flag is on or not.                              --
-- Parameters:                                                        --
--   integer: handle of special flag                                  --
-- Returns:                                                           --
--   integer: value of special flag                                   --
------------------------------------------------------------------------
global function SpecialFlagIsOn(atom sfId)
  return SpecialFlags[sfId][SPCF_VAL]
end function

------------------------------------------------------------------------
-- Set value of a special flag.                                       --
-- Parameters:                                                        --
--   integer: handle of special flag                                  --
--   integer: value to set flag to                                    --
------------------------------------------------------------------------
global procedure SetSpecialFlag(integer sfId, integer val)
  SpecialFlags[sfId][SPCF_VAL] = val
  if val then
    DoSpecialFlagLoadRtn(sfId)
  end if
end procedure