'                           MISSION IN SOLAR SYSTEM
'                         Programmed by: Lukman Hakim
'                 This program is distributed for education only
'         Free Download it from http://www.angelfire.com/comics/lukman

DECLARE SUB makesprite ()

'*** IMPORTANT! Change this constant to adjust this game with your CPU speed
CONST waittime = 500

CONST maxstar = 10
CONST maxenemy = 10
CONST xoffset = 5
CONST yoffset = 5
CONST laseroffset = 5
CONST maxlaser = 10
CONST maxbomb = 5

TYPE enemydata
 x AS INTEGER
 y AS INTEGER
 xoffset AS INTEGER
 yoffset AS INTEGER
 oldx AS INTEGER
 oldy AS INTEGER
 active AS INTEGER
END TYPE

TYPE laserdata
 x AS INTEGER
 y AS INTEGER
 oldy AS INTEGER
 active AS INTEGER
END TYPE

TYPE bombdata
 x AS INTEGER
 y AS INTEGER
 oldx AS INTEGER
 oldy AS INTEGER
 xoffset AS INTEGER
 yoffset AS INTEGER
 active AS INTEGER
END TYPE

TYPE stardata
 x AS INTEGER
 y AS INTEGER
 yoffset AS INTEGER
 oldx AS INTEGER
 oldy AS INTEGER
END TYPE

DIM SHARED ship(500), alien(500), laserSP(100), bombSP(70), starSP(1)
DIM SHARED enemywidth AS INTEGER, enemyheight AS INTEGER
DIM SHARED shipwidth AS INTEGER, shipheight AS INTEGER
DIM SHARED laserwidth AS INTEGER, laserheight AS INTEGER
DIM SHARED bombwidth AS INTEGER, bombheight AS INTEGER

DIM gameover AS INTEGER
DIM oldx AS INTEGER, oldy AS INTEGER
DIM xpos AS INTEGER, ypos AS INTEGER
DIM enemy(maxenemy - 1) AS enemydata
DIM waiting AS SINGLE
DIM i AS INTEGER, j AS INTEGER
DIM star(maxstar - 1) AS stardata
DIM keypressed AS STRING, keydown AS INTEGER
DIM laser(maxlaser - 1) AS laserdata
DIM shouldmakebomb AS INTEGER
DIM bomb(maxbomb - 1) AS bombdata
DIM power AS INTEGER, aliendestroy AS INTEGER
DIM char(10) AS STRING

SCREEN 12: CLS
char(0) = "Mission in Solar System"
char(1) = "Programmed by: Lukman Hakim"
char(2) = "Distributed for education only"
char(3) = ""
char(4) = "In the year of 20XX, the population of alien has grown enough"
char(5) = "to make them think that it is a good idea to start invasion on earth"
char(6) = "Earth has sent an old-ugly spaceship to show the alien that human"
char(7) = "can defeat them easily only by using this junk machine."
char(8) = "Your mission is to create natural fear to those of them"
char(9) = "by destroying 300 aliens. The rest will be taken by other ship"
char(10) = "Good luck!"

FOR i = 0 TO 10
 LOCATE i + 1, (80 - LEN(char(i))) / 2: PRINT char(i)
NEXT i
a$ = INPUT$(1)

SCREEN 13: CLS

' *** Draw and get the star
PSET (0, 0), 14: GET (0, 0)-(0, 0), starSP
' *** Load the sprite
CALL makesprite
' ** Draw Game Board
LINE (0, 10)-(319, 10), 10

' *** First data
xpos = 140
ypos = 140
power = 100
aliendestroy = 0
gameover = 0
GOSUB displaystatus
PUT (xpos, ypos), ship

FOR i = 0 TO maxstar - 1
 star(i).x = INT(RND * 310) + 5
 star(i).y = 10
 star(i).yoffset = INT(RND * 2) + 2
 PUT (star(i).x, star(i).y), starSP
NEXT i

DO
GOSUB delay
keypressed = INKEY$
IF keypressed <> "" THEN GOSUB checkkeyboard

GOSUB movelaser
GOSUB moveenemy
GOSUB movebomb

GOSUB starmove
LOOP UNTIL gameover = 1 OR power <= 0 OR aliendestroy >= 300

IF aliendestroy >= 300 THEN
   LOCATE 11, 12: PRINT "Mission Completed"
   a$ = INPUT$(1)
END IF

LOCATE 11, 12: PRINT "G A M E   O V E R"
a$ = INPUT$(1)

END

displaystatus:
LOCATE 1, 1: PRINT "Power : "; power
LOCATE 1, 15: PRINT "Alien Destroyed : "; aliendestroy
RETURN

movebomb:
FOR i = 0 TO maxbomb - 1
 RANDOMIZE TIMER
  IF bomb(i).active = 1 THEN
     bomb(i).oldx = bomb(i).x: bomb(i).oldy = bomb(i).y
     bomb(i).x = bomb(i).x + bomb(i).xoffset
     bomb(i).y = bomb(i).y + bomb(i).yoffset
     PUT (bomb(i).oldx, bomb(i).oldy), bombSP
     IF bomb(i).y > 180 OR bomb(i).x < 0 OR bomb(i).x > 300 THEN
        bomb(i).active = 0
     ELSE : PUT (bomb(i).x, bomb(i).y), bombSP
            GOSUB checkbombship
     END IF
  END IF
NEXT i
RETURN

checkbombship:
IF bomb(i).x < (xpos + shipwidth) AND (bomb(i).x + bombwidth) > xpos THEN
   IF bomb(i).y < (ypos + shipheight) AND (bomb(i).y + bombheight) > ypos THEN
      bomb(i).active = 0
      PUT (bomb(i).x, bomb(i).y), bombSP
      SOUND 500, .1: SOUND 100, .1: SOUND 1000, .1
      power = power - 1: GOSUB displaystatus
   END IF
END IF
RETURN

makebomb:
RANDOMIZE TIMER
shouldmakebomb = INT(RND * 20)
 IF shouldmakebomb = 0 THEN

    FOR j = 0 TO maxbomb - 1
      RANDOMIZE TIMER
      IF bomb(j).active = 0 THEN
         bomb(j).active = 1
         bomb(j).x = enemy(i).x + 5
         bomb(j).y = enemy(i).y + 10
         bomb(j).xoffset = (INT(RND * 2) + 2) * (1 - INT(RND * 2) * 2)
         bomb(j).yoffset = (INT(RND * 2) + 2)
         PUT (bomb(j).x, bomb(j).y), bombSP
         EXIT FOR
      END IF
    NEXT j
 END IF
RETURN

moveenemy:
FOR i = 0 TO maxenemy - 1
 RANDOMIZE TIMER
 IF enemy(i).active = 0 THEN
    enemy(i).active = 1
    enemy(i).x = INT(RND * 290)
    enemy(i).y = 10
    enemy(i).xoffset = (INT(RND * 2) + 1) * (1 - INT(RND * 2) * 2)
    enemy(i).yoffset = (INT(RND * 2) + 1)
    PUT (enemy(i).x, enemy(i).y), alien
 ELSE :
    enemy(i).oldx = enemy(i).x
    enemy(i).oldy = enemy(i).y
    enemy(i).x = enemy(i).x + enemy(i).xoffset
    enemy(i).y = enemy(i).y + enemy(i).yoffset
    PUT (enemy(i).oldx, enemy(i).oldy), alien
    IF enemy(i).x < 0 OR enemy(i).y > 170 OR enemy(i).x > 290 THEN
       enemy(i).active = false
    ELSE : PUT (enemy(i).x, enemy(i).y), alien
           GOSUB checkenemyship
    END IF
    GOSUB makebomb
 END IF
NEXT i
            
RETURN

checkenemyship:
IF enemy(i).x < (xpos + shipwidth) AND (enemy(i).x + enemywidth) > xpos THEN
   IF enemy(i).y < (ypos + shipheight) AND (enemy(i).y + enemyheight) > ypos THEN
      enemy(i).active = 0
      PUT (enemy(i).x, enemy(i).y), alien
      SOUND 5000, .1: SOUND 1000, .1: SOUND 3000, .1
      power = power - 2
      aliendestroy = aliendestroy + 1: GOSUB displaystatus
   END IF
END IF
RETURN


makelaser:
FOR i = 0 TO maxlaser - 1
 IF laser(i).active = 0 THEN
    laser(i).active = 1
    laser(i).x = xpos + 3
    laser(i).y = ypos
    PUT (laser(i).x, laser(i).y), laserSP
    SOUND 4000, .3
    EXIT FOR
 END IF
NEXT i
RETURN

movelaser:
FOR i = 0 TO maxlaser - 1
 IF laser(i).active = 1 THEN
    laser(i).oldy = laser(i).y
    laser(i).y = laser(i).y - laseroffset
    PUT (laser(i).x, laser(i).oldy), laserSP
    IF laser(i).y <= 10 THEN
       laser(i).active = 0
    ELSE : PUT (laser(i).x, laser(i).y), laserSP
           GOSUB checklaserenemy
    END IF
 END IF
NEXT i
RETURN

checklaserenemy:
FOR j = 0 TO maxenemy - 1
 IF laser(i).x < (enemy(j).x + enemywidth) AND (laser(i).x + laserwidth) > enemy(j).x THEN
   IF laser(i).y < (enemy(j).y + enemyheight) AND (laser(i).y + laserheight) > enemy(j).y THEN
      laser(i).active = 0
      enemy(j).active = 0
      PUT (laser(i).x, laser(i).y), laserSP
      PUT (enemy(j).x, enemy(j).y), alien
      SOUND 1000, .1: SOUND 500, .1: SOUND 2000, .1
      aliendestroy = aliendestroy + 1: GOSUB displaystatus
      EXIT FOR
   END IF
 END IF
NEXT j

RETURN

starmove:
FOR i = 0 TO maxstar - 1
 star(i).oldx = star(i).x
 star(i).oldy = star(i).y
 star(i).y = star(i).y + star(i).yoffset
  IF star(i).y >= 199 THEN
     RANDOMIZE TIMER
     star(i).x = INT(RND * 310) + 5
     star(i).yoffset = INT(RND * 2) + 2
     star(i).y = 10
  END IF
 PUT (star(i).oldx, star(i).oldy), starSP
 PUT (star(i).x, star(i).y), starSP
NEXT i

delay:
 FOR waiting = 1 TO waittime STEP .1
 NEXT waiting
RETURN

checkkeyboard:

IF keypressed = "q" OR keypressed = "Q" THEN
   gameover = 1
 ELSE :
 oldx = xpos
 oldy = ypos

 keydown = ASC(RIGHT$(keypressed, 1))  '*** see the ASCII arrow pad value

 IF keydown = 72 THEN
   ypos = ypos - yoffset
 END IF

 IF keydown = 80 THEN
   ypos = ypos + yoffset
 END IF

 IF keydown = 77 THEN
   xpos = xpos + xoffset
 END IF
  
 IF keydown = 75 THEN
   xpos = xpos - xoffset
 END IF

 IF xpos > 290 THEN
   xpos = 290
   ELSE : IF xpos < 0 THEN xpos = 0
 END IF

 IF ypos > 179 THEN
   ypos = 179
   ELSE : IF ypos < 10 THEN ypos = 10
 END IF

 PUT (oldx, oldy), ship
 PUT (xpos, ypos), ship
END IF

IF keypressed = " " THEN GOSUB makelaser

RETURN

SUB makesprite

DIM grid(30, 30) AS INTEGER
DIM spritenum AS INTEGER
DIM i AS INTEGER, j AS INTEGER
DIM maxrow AS INTEGER, maxcol AS INTEGER

spritenum = 0
SCREEN 13

DO
CLS
spritenum = spritenum + 1
SELECT CASE spritenum
 CASE 1 'ship
  OPEN "Ship" FOR RANDOM AS #1
  GOSUB displaysprite
  GET (0, 0)-(maxcol, maxrow), ship
 
 CASE 2 'alien
  OPEN "alien" FOR RANDOM AS #1
  GOSUB displaysprite
  GET (0, 0)-(maxcol, maxrow), alien

 CASE 3
  OPEN "laser" FOR RANDOM AS #1
  GOSUB displaysprite
  GET (0, 0)-(maxcol, maxrow), laserSP
 
 CASE 4
  OPEN "bomb" FOR RANDOM AS #1
  GOSUB displaysprite
  GET (0, 0)-(maxcol, maxrow), bombSP
 
END SELECT

LOOP UNTIL spritenum = 4
CLS
EXIT SUB

displaysprite:
   GET #1, 1, maxrow
   GET #1, 2, maxcol
  
   SELECT CASE spritenum
    CASE 1: shipwidth = maxcol: shipheight = maxrow
    CASE 2: enemywidth = maxcol: enemyheight = maxrow
    CASE 3: laserwidth = maxcol: laserheight = maxrow
    CASE 4: bombwidth = maxcol: bombheight = maxrow
   END SELECT

    FOR i = 0 TO maxrow - 1
     FOR j = 0 TO maxcol - 1
      GET #1, 3 + j + (i * maxcol), grid(j, i)
      PSET (j, i), grid(j, i)
     NEXT j
    NEXT i
 CLOSE #1
RETURN


END SUB

