DECLARE SUB BmpWrite (prefix$, start%)

'$DYNAMIC

DEFINT A-Z

TYPE respawnobj
freq AS SINGLE
spr AS INTEGER
oname AS STRING * 16
bounty AS INTEGER
pid AS INTEGER
runhp AS INTEGER
attackhp AS INTEGER
tid AS INTEGER
statid AS INTEGER
pgun AS INTEGER
sgun AS INTEGER
END TYPE
TYPE BITMAPHEADER
identifier AS STRING * 2
filesize AS LONG
reserved AS LONG
bitmapdataoffset AS LONG
bitmapheadersize AS LONG
width AS LONG
height AS LONG
planes AS INTEGER
bpp AS INTEGER
compression AS LONG
bitmapdatasize AS LONG
HresolutionPel AS LONG
VresolutionPel AS LONG
colors AS LONG
importantcolors AS LONG
END TYPE

TYPE gun
tpid AS INTEGER   'weapon type of main gun
ammo AS INTEGER    '# of ammo of primary gun
firerate AS LONG  'how fast the gun fires
frame AS LONG
hp AS INTEGER
END TYPE

TYPE human
aburn AS INTEGER
freq AS INTEGER
spr AS INTEGER
statid AS INTEGER
tid AS INTEGER
attackhp AS INTEGER
runhp AS INTEGER
wins AS INTEGER      'how many kills this object has in a fight
losses AS INTEGER    'how many deaths this object has in a fight
state AS INTEGER 'state for the ai state machine
focus AS INTEGER 'object of focus for the ai state
oname AS STRING * 16 'name!%#
pid AS INTEGER     ' person id
size AS LONG    'size of the person

hp AS INTEGER        'health
maxhp AS INTEGER ' max health
bounty AS INTEGER    'tracked kills
confirmed AS INTEGER 'confirmed kills
score AS INTEGER   'score
velocity AS INTEGER ' velocity
angle AS SINGLE   'angle the shippy faces

x AS LONG         'location of center point in subpixels
y AS LONG         'location of center point in subpixels

maxrate AS INTEGER ' maximum speeed!
dx AS INTEGER      'amount of subpixels to move on each axis per frame
dy AS INTEGER

burst AS INTEGER     'acceleration speed on each axis in subpixels
turn AS SINGLE 'turn rate

olevel AS INTEGER
blevel AS INTEGER
mlevel AS INTEGER
weapon(2) AS gun
nodex AS LONG
nodey AS LONG

END TYPE



TYPE proj

trailframe AS INTEGER
tpid AS INTEGER
pid AS INTEGER     ' person id of the person who shot this projectile
size AS LONG   'size of the bullet
ttl AS INTEGER
bonk AS LONG

velocity AS INTEGER ' velocity
angle AS SINGLE   'angle the bullet faces

x AS LONG         'location of center point in subpixels
y AS LONG         'location of center point in subpixels


maxrate AS INTEGER ' maximum speeed!
dx AS INTEGER     'amount of subpixels to move on each axis per frame
dy AS INTEGER


burst AS INTEGER     'acceleration speed on each axis in subpixels
END TYPE


TYPE doopt
x AS LONG
y AS LONG
rangey AS LONG
t AS INTEGER
delayframes AS INTEGER
END TYPE

TYPE splodat
x AS LONG
y AS LONG
t AS INTEGER
d AS INTEGER
sframe AS LONG
currframe AS INTEGER
END TYPE


TYPE framedat
delay AS INTEGER
frames AS INTEGER
END TYPE

TYPE respawninfo
rframes AS LONG
ship AS INTEGER
END TYPE

TYPE camerax
x AS LONG
y AS LONG
Z AS LONG
END TYPE

TYPE unf
x AS INTEGER
END TYPE

DECLARE SUB AddConsoleLine (text$, col%)
DECLARE SUB fontprint (x%, y%, text$, col%)
DECLARE SUB LoadBots ()
DECLARE SUB AddDoop (x AS LONG, y AS LONG, dx AS INTEGER, dy AS INTEGER, t AS INTEGER)
DECLARE SUB Addshippy (oname AS STRING, freq AS SINGLE, spr%, x AS LONG, y AS LONG, pid AS INTEGER, prim%, sec%, rhp%, ahp%, score AS INTEGER, tid AS INTEGER, statid%)
DECLARE FUNCTION IsHitD& (x1 AS LONG, y1 AS LONG, r1 AS LONG, x2 AS LONG, y2 AS LONG, r2 AS LONG)
DECLARE FUNCTION IsHit% (x1 AS LONG, y1 AS LONG, r1 AS LONG, x2 AS LONG, y2 AS LONG, r2 AS LONG)
DECLARE SUB rotspr2 (segm%, offs%, x%, y%, theta!)
DECLARE SUB UpSplo ()
DECLARE SUB DrawHpBand (objnum%)
DECLARE SUB TransBox (TransBoxX1%, TransBoxY1%, TransBoxX2%, TransBoxY2%, TransBoxColor%)
DECLARE SUB DoProjectiles ()
DECLARE SUB DoAi (obj%)
DECLARE SUB SendMessage (MsgNum%, destobj%, fromobj%, d1%)
DECLARE SUB AddShot (objnum%, blonk%)
DECLARE SUB AddSplo (x AS LONG, y AS LONG, d%, t%)
DECLARE SUB Killshippy (kobject%, fromobj%)
DECLARE SUB MoveTehShippy (objnum%)
DECLARE SUB DisplayMap (c AS ANY)
DECLARE SUB FocusCamera ()
DECLARE SUB CalcNewVectorP (objid%, vel%)
DECLARE SUB calcNewVector (obj AS ANY, velii AS INTEGER)
DECLARE SUB rotspr (segm%, offs%, x%, y%, theta!)
DECLARE SUB ExecObjects ()
DECLARE SUB erplines (x1%, y1%, x2%, y2%)
DECLARE SUB setpal (file$)
DECLARE SUB put13h (BYVAL OBJSegm%, BYVAL OBJOffs%, BYVAL x%, BYVAL y%, BYVAL col%)
DECLARE SUB setsegments13h (BYVAL SSegm%, BYVAL DSegm%)
DECLARE SUB initkbd ALIAS "installisr" (BYVAL arrayseg%, BYVAL arrayofs%)
DECLARE SUB deinitkbd ALIAS "removeisr" ()
DECLARE SUB copy13h ()
DECLARE SUB DoEngineGlobals ()
DECLARE SUB DrawOverlay ()
DECLARE SUB fadein (Redval%, GreenVal%, BlueVal%, frames%)
DECLARE SUB fadeout (Redval%, GreenVal%, BlueVal%, frames%)
DECLARE SUB Intro ()
DECLARE SUB NewGame ()


CONST pi = 3.14159


RANDOMIZE TIMER


DIM SHARED gamestate
DIM SHARED r(255), g(255), b(255)
DIM SHARED dbuffer(32766) AS INTEGER
DIM SHARED keyboard(255) AS INTEGER
DIM SHARED ytable(199) AS LONG
DIM SHARED objects(31) AS human
DIM SHARED rdelay(31) AS respawninfo
DIM SHARED rholder(579)
DIM SHARED cachemap(127, 127)
DIM SHARED splosions(150) AS splodat
DIM SHARED SPLOMAX
DIM SHARED ptime AS INTEGER
DIM SHARED lasttime AS INTEGER
SPLOMAX = UBOUND(splosions, 1)
DIM SHARED projectiles(127) AS proj
DIM SHARED PROMAX
PROMAX = UBOUND(projectiles, 1)

DIM SHARED splo(513, 3, 4)
DIM SHARED usedobjects
DIM SHARED UsedProj
DIM SHARED UsedSplo
DIM SHARED font(14, 127)
DIM SHARED fontg(14, 127)
DIM SHARED camera AS camerax
DIM SHARED player AS INTEGER

DIM SHARED maxobjects

DIM SHARED vsync
DIM SHARED vsyncframes&
DIM SHARED overlayframes&
DIM SHARED cacheTile(129, 49, 3)
DIM SHARED overlay
DIM SHARED ConsoleC(4) AS INTEGER
DIM SHARED Console(4, 1) AS STRING
DIM SHARED rd(UBOUND(objects, 1)) AS respawnobj

DIM SHARED blarf
DIM SHARED c2frames AS LONG
DIM SHARED TransPal(255)

DIM SHARED maxpixelx AS LONG, maxpixely AS LONG
DIM SHARED teamfreq(2) AS SINGLE
DIM SHARED teamscore(2) AS INTEGER
DIM SHARED TypeConsoleFlag AS INTEGER

DIM SHARED radar(31, 31)
DIM SHARED players(129, 4) AS INTEGER
DIM SHARED sprite(32, 32)
DIM SHARED st(200) AS unf, en(200) AS unf
DIM SHARED frames&
DIM SHARED doop(33, 30)
DIM SHARED fraglimit
DIM SHARED rdp
DIM SHARED GameDone
DIM SHARED animcap
DIM SHARED animcapframes

animcap = -1
animcapframes = 0

overlay = 1

FOR i = 0 TO 199
ytable(i) = 320& * i
NEXT

DEF SEG = VARSEG(doop(0, 0))
BLOAD "doop.put", VARPTR(doop(0, 0))
DEF SEG = VARSEG(rholder(0))
BLOAD "holder.put", VARPTR(rholder(0))

DEF SEG = VARSEG(cacheTile(0, 0, 0))
BLOAD "game.put", VARPTR(cacheTile(0, 0, 0))
DEF SEG = VARSEG(splo(0, 0, 0))
BLOAD "splo.put", VARPTR(splo(0, 0, 0))

setsegments13h VARSEG(dbuffer(0)), &HA000
maxpixelx = 127 * 16 * 128& + 127
maxpixely = 127 * 16 * 128& + 127

SCREEN 13
DEF SEG = VARSEG(font(0, 0))
BLOAD "font.put", VARPTR(font(0, 0))
DEF SEG = VARSEG(fontg(0, 0))
BLOAD "fontg.put", VARPTR(fontg(0, 0))
DEF SEG = VARSEG(players(0, 0))
BLOAD "ship1.put", VARPTR(players(0, 0))


Intro
vsync = 1
initkbd VARSEG(keyboard(0)), VARPTR(keyboard(0))


NewGame


AddConsoleLine "TAB fires orb thing", 1
AddConsoleLine "SPACE fires bullets", 1
AddConsoleLine "F2 Toggles Console", 1
AddConsoleLine "CTRL layes mine", 1

a! = TIMER
c! = TIMER

DO
IF lasttime <> TIMER THEN ptime = ptime + 1

DoEngineGlobals
DoProjectiles
ExecObjects
UpSplo
camera.x = objects(player).x
camera.y = objects(player).y
FocusCamera
DisplayMap camera
DrawOverlay
IF (frames& AND 255) = 17 THEN AddDoop maxpixelx * RND, maxpixely * RND, 0, 0, 4
FOR i = 0 TO 31
IF frames& > rdelay(i).rframes AND rdelay(i).ship <> -1 THEN
rdp = rdelay(i).ship
Addshippy rd(rdp).oname, rd(rdp).freq, rd(rdp).spr, maxpixelx * RND, maxpixely * RND, rd(rdp).pid, rd(rdp).pgun, rd(rdp).sgun, rd(rdp).runhp, rd(rdp).attackhp, rd(rdp).bounty, rd(rdp).tid, rd(rdp).statid
rdelay(i).ship = -1
END IF
NEXT


put13h VARSEG(rholder(0)), VARPTR(rholder(0)), 286, 166, -1
offs& = ytable(167) + 287
FOR i = 0 TO 31
FOR j = 0 TO 31
IF radar(j, i) > 0 THEN
POKE ytable(i) + offs& + j, radar(j, i): radar(j, i) = 0
ELSE
boink = j * 4
FOR bink = (i * 4) TO (i * 4) + 3
FOR boink = (j * 4) TO (j * 4) + 3
IF cachemap(boink, bink) = 2 THEN POKE ytable(i) + offs& + j, 8
NEXT
NEXT
END IF
NEXT j, i
b! = TIMER - c!
IF vsync = 1 THEN WAIT &H3DA, 8
copy13h
IF (keyboard(87)) THEN
animcap = -animcap
DO: LOOP UNTIL keyboard(87) = 0
END IF
IF animcap = 1 THEN
BmpWrite "anim", animcapframes
animcapframes = animcapframes + 1
END IF
IF keyboard(88) THEN
BmpWrite "sshot", 0
DO: LOOP UNTIL keyboard(88) = 0
END IF



IF frames& = 0 THEN fadein 0, 0, 0, 32
IF frames& > 4000000 THEN frames& = 0
frames& = frames& + 1
LOOP UNTIL GameDone
deinitkbd
SCREEN 0
WIDTH 80, 25
PRINT "Shippy Gold by Ryan Broomfield 2001"

REM $STATIC
SUB AddConsoleLine (text$, col)
c2frames = frames& + 210
Console(0, 1) = Console(1, 1)
Console(1, 1) = Console(2, 1)
Console(2, 1) = Console(3, 1)
Console(3, 1) = Console(4, 1)
ConsoleC(0) = ConsoleC(1)
ConsoleC(1) = ConsoleC(2)
ConsoleC(2) = ConsoleC(3)
ConsoleC(3) = ConsoleC(4)

Console(4, 1) = text$
ConsoleC(4) = col

END SUB

SUB AddDoop (x AS LONG, y AS LONG, dx AS INTEGER, dy AS INTEGER, t AS INTEGER)

FOR k = 0 TO PROMAX
IF projectiles(k).pid = -1 THEN f% = k: EXIT FOR
NEXT
IF f% = -1 THEN EXIT SUB

projectiles(f%).tpid = t
projectiles(f%).dx = dx
projectiles(f%).dy = dy
projectiles(f%).ttl = 90
IF t = 4 THEN projectiles(f%).ttl = 2000
IF t = 6 THEN projectiles(f%).ttl = 30 * RND + 10
projectiles(f%).bonk = frames& + projectiles(f%).ttl
projectiles(f%).x = x
projectiles(f%).y = y
projectiles(f%).pid = 32
projectiles(f%).size = 1 * 128
projectiles(f%).angle = .1
projectiles(f%).burst = (3 - blonk) * objects(objnum).maxrate
UsedProj = UsedProj + 1
END SUB

SUB Addshippy (oname AS STRING, freq AS SINGLE, spr, x AS LONG, y AS LONG, pid AS INTEGER, prim, sec, rhp, ahp, score AS INTEGER, tid AS INTEGER, statid)
IF statid = -1 THEN
blah = -1
FOR i = 0 TO 31
IF objects(i).pid = -1 THEN blah = i: EXIT FOR
NEXT
IF blah = -1 THEN EXIT SUB
i = blah
ELSE
i = statid
END IF
objects(i).confirmed = 0
objects(i).freq = freq
objects(i).turn = .07
objects(i).spr = spr
objects(i).statid = i
objects(i).blevel = 0
objects(i).olevel = 0
objects(i).mlevel = 0
objects(i).tid = tid
objects(i).focus = -1
objects(i).runhp = rhp
objects(i).attackhp = ahp
objects(i).bounty = 1
objects(i).score = score
objects(i).oname = oname
objects(i).hp = 200
objects(i).maxhp = 200
objects(i).size = 9 * 128
objects(i).dx = 0
objects(i).dy = 0
objects(i).x = x
objects(i).y = y
objects(i).pid = pid

objects(i).maxrate = 256
objects(i).burst = 8
objects(i).weapon(0).tpid = prim
objects(i).weapon(0).firerate = 15
objects(i).weapon(0).frame = frames&
objects(i).weapon(0).hp = 5

objects(i).weapon(1).tpid = sec
objects(i).weapon(1).ammo = -1
objects(i).weapon(1).firerate = 30
objects(i).weapon(1).frame = frames&
objects(i).weapon(1).hp = 50

objects(i).weapon(2).tpid = 3
objects(i).weapon(2).ammo = 2
objects(i).weapon(2).firerate = 30
objects(i).weapon(2).frame = frames&
objects(i).weapon(2).hp = 25


AddSplo objects(i).x, objects(i).y, 8, 2
usedobjects = usedobjects + 1
END SUB

SUB AddShot (objnum, blonk)

dtype = blonk - 1

IF dtype = 2 AND objects(objnum).weapon(dtype).ammo > -1 THEN IF objects(objnum).weapon(dtype).ammo <= 0 THEN EXIT SUB
IF objects(objnum).weapon(dtype).frame > frames& THEN EXIT SUB
IF objects(objnum).hp < objects(objnum).weapon(dtype).hp + 1 THEN EXIT SUB

f% = -1
FOR k = 0 TO PROMAX
IF projectiles(k).pid = -1 THEN f% = k: EXIT FOR
NEXT
IF f% = -1 THEN EXIT SUB

projectiles(f%).tpid = objects(objnum).weapon(dtype).tpid

IF objects(objnum).weapon(dtype).tpid = 3 THEN
projectiles(f%).dx = 0
projectiles(f%).dy = 0
projectiles(f%).ttl = 210
ELSE
projectiles(f%).dx = objects(objnum).dx
projectiles(f%).dy = objects(objnum).dy
projectiles(f%).ttl = 140
END IF
projectiles(f%).bonk = frames& + projectiles(f%).ttl
projectiles(f%).x = objects(objnum).x
projectiles(f%).y = objects(objnum).y
projectiles(f%).pid = objnum
projectiles(f%).size = 1 * 128
projectiles(f%).angle = objects(objnum).angle
projectiles(f%).burst = (3 - objects(objnum).weapon(dtype).tpid) * objects(objnum).maxrate

IF objects(objnum).weapon(dtype).tpid = 3 THEN
ELSE
CalcNewVectorP f%, projectiles(f%).burst
END IF

IF dtype = 2 AND objects(objnum).weapon(dtype).ammo > -1 THEN objects(objnum).weapon(dtype).ammo = objects(objnum).weapon(dtype).ammo - 1
objects(objnum).weapon(dtype).frame = frames& + objects(objnum).weapon(dtype).firerate
objects(objnum).hp = objects(objnum).hp - objects(objnum).weapon(dtype).hp

END SUB

SUB AddSplo (x AS LONG, y AS LONG, d, t)

FOR i = 0 TO SPLOMAX
IF splosions(i).t = 0 THEN
splosions(i).y = y
splosions(i).currframe = 0
splosions(i).x = x
splosions(i).t = t
splosions(i).sframe = frames&
splosions(i).d = d
EXIT FOR
END IF
NEXT


END SUB

SUB BmpWrite (prefix$, start%)
DEF SEG = &HA00

DIM info AS BITMAPHEADER
info.identifier = "BM"
info.filesize = 65078
info.reserved = 0
info.bitmapdataoffset = 1078
info.bitmapheadersize = 40
info.width = 320
info.height = 200
info.planes = 1
info.bpp = 8
info.compression = 0
info.bitmapdatasize = 64000
info.HresolutionPel = 2835
info.VresolutionPel = 2835
info.colors = 256
info.importantcolors = 256

a$ = " "
FOR i = start TO 31337
a$ = prefix$ + LTRIM$(RTRIM$(STR$(i))) + ".bmp"
a = FREEFILE
OPEN a$ FOR BINARY AS #a
l& = LOF(a)
CLOSE #a
IF l& = 0 THEN EXIT FOR
NEXT

OPEN a$ FOR BINARY AS #1
PUT #1, , info
FOR i = 0 TO 255
OUT &H3C7, i
r% = INP(&H3C9) * 4
r$ = CHR$(r%)
g% = INP(&H3C9) * 4
g$ = CHR$(g%)
b% = INP(&H3C9) * 4
b$ = CHR$(b%)
PUT #1, , b$
PUT #1, , g$
PUT #1, , r$
a$ = " "
PUT #1, , a$
NEXT
a$ = " "
FOR i& = 199 TO 0 STEP -1
FOR j& = 0 TO 319
b$ = CHR$(POINT(j&, i&))
PUT #1, , b$
NEXT j&, i&

CLOSE #1

END SUB

SUB calcNewVector (objid, vel)
boink = vel
testx& = objects(objid).dx + (COS(objects(objid).angle) * boink)
testy& = objects(objid).dy + (SIN(objects(objid).angle) * boink)
maxr = SQR(testx& * testx& + testy& * testy&)
IF objects(objid).aburn = 1 THEN maxr2 = objects(objid).maxrate * 2 ELSE maxr2 = objects(objid).maxrate
IF maxr > maxr2 THEN
testx& = testx& * maxr2 / maxr
testy& = testy& * maxr2 / maxr
maxr = maxr2
END IF
objects(objid).velocity = maxr
objects(objid).dx = testx&
objects(objid).dy = testy&
END SUB

SUB CalcNewVectorP (objid, vel)
testx& = projectiles(objid).dx + (COS(projectiles(objid).angle) * vel)
testy& = projectiles(objid).dy + (SIN(projectiles(objid).angle) * vel)
maxr = SQR(testx& * testx& + testy& * testy&)
IF maxr > projectiles(objid).maxrate AND maxr < -projectiles(objid).maxrate THEN EXIT SUB
projectiles(objid).velocity = maxr
projectiles(objid).dx = testx&
projectiles(objid).dy = testy&
END SUB

SUB DisplayMap (c AS camerax)

lrx = c.x \ 4096
lry = c.y \ 4096
offx = ((c.x \ 2) AND 2047) \ 128
offy = ((c.y \ 2) AND 2047) \ 128
trx = 20 - (offx = 0)
try = 13 - (offy = 0)
startx = -offx
starty = -offy

FOR DrawY = 0 TO try
FOR DrawX = 0 TO trx
til = cachemap((DrawX + lrx) AND 127, (DrawY + lry) AND 127) AND 255
IF til = 1 THEN put13h VARSEG(cacheTile(0, til, 0)), VARPTR(cacheTile(0, til, 0)), startx, starty, -1 ELSE put13h VARSEG(cacheTile(0, 0, 0)), VARPTR(cacheTile(0, 0, 0)), startx, starty, -1
startx = startx + 16
NEXT DrawX
starty = starty + 16
startx = -offx
NEXT DrawY



lrx = c.x \ 2048
lry = c.y \ 2048
offx = (c.x AND 2047) \ 128
offy = (c.y AND 2047) \ 128
trx = 20 - (offx = 0)
try = 13 - (offy = 0)
startx = -offx
starty = -offy

FOR DrawY = 0 TO try
FOR DrawX = 0 TO trx
til = cachemap((DrawX + lrx) AND 127, (DrawY + lry) AND 127) AND 255
IF til = 2 THEN put13h VARSEG(cacheTile(0, til, 0)), VARPTR(cacheTile(0, til, 0)), startx, starty, 0
startx = startx + 16
NEXT DrawX
starty = starty + 16
startx = -offx
NEXT DrawY





FOR i = 0 TO 31
IF objects(i).pid <> -1 THEN
blah = (objects(i).x - c.x) \ 128
blah2 = (objects(i).y - c.y) \ 128
blah3 = (objects(i).x \ 8192)
blah4 = (objects(i).y \ 8192)
IF player > -1 THEN
col = 10
IF objects(i).freq <> objects(player).freq THEN col = 12
IF player = i THEN col = 15
radar(blah3, blah4) = col
ELSE
radar(blah3, blah4) = 12
END IF


IF blah >= -4 AND blah <= 324 THEN
IF blah2 >= -4 AND blah2 <= 204 THEN
rotspr VARSEG(players(0, objects(i).spr)), VARPTR(players(0, objects(i).spr)), blah, blah2, objects(i).angle
f$ = LTRIM$(RTRIM$(objects(i).oname)) + "(" + LTRIM$(RTRIM$(STR$(objects(i).bounty))) + ")"
blah3 = LEN(f$) * 6
IF i <> player THEN fontprint blah - (blah3 \ 2), blah2 + 8, f$, 1
END IF
END IF
'END IF
END IF
NEXT


FOR i = 0 TO PROMAX
IF projectiles(i).pid <> -1 THEN
IF projectiles(i).tpid = 4 THEN
blah3 = (projectiles(i).x \ 8192)
blah4 = (projectiles(i).y \ 8192)
radar(blah3, blah4) = 104
END IF

blah = (projectiles(i).x - c.x) \ 128
blah2 = (projectiles(i).y - c.y) \ 128
IF blah >= 0 AND blah <= 319 AND blah2 >= 0 AND blah2 <= 199 THEN
rotspr2 VARSEG(doop(0, projectiles(i).tpid - 1)), VARPTR(doop(0, projectiles(i).tpid - 1)), blah, blah2, projectiles(i).angle
END IF
END IF
NEXT


FOR i = 0 TO SPLOMAX
IF splosions(i).t > 0 THEN
testx = (splosions(i).x - c.x - 2048) \ 128
testy = (splosions(i).y - c.y - 2048) \ 128
IF testx > -31 AND testx < 320 AND testy > -31 AND testy < 200 THEN
put13h VARSEG(splo(0, splosions(i).currframe, splosions(i).t - 1)), VARPTR(splo(0, splosions(i).currframe, splosions(i).t - 1)), testx, testy, 0
END IF
END IF
NEXT

END SUB

SUB DoAi (obj)

SELECT CASE objects(obj).pid

CASE 1

 'IF keyboard(49) THEN NewGame: EXIT SUB

 IF keyboard(44) THEN objects(obj).aburn = 1 ELSE objects(obj).aburn = 0
 IF keyboard(46) AND obj = player THEN objects(obj).pid = 2
 IF keyboard(57) THEN AddShot obj, 1
 IF keyboard(15) THEN AddShot obj, 2
 IF keyboard(29) THEN AddShot obj, 3
 IF keyboard(72) THEN calcNewVector obj, objects(obj).burst
 IF keyboard(80) THEN calcNewVector obj, -objects(obj).burst
 IF keyboard(75) THEN objects(obj).angle = objects(obj).angle - objects(obj).turn
 IF keyboard(77) THEN objects(obj).angle = objects(obj).angle + objects(obj).turn
 IF objects(obj).angle < 0 THEN objects(obj).angle = objects(obj).angle + 6.28318
 IF objects(obj).angle > 6.28318 THEN objects(obj).angle = objects(obj).angle - 6.28318


CASE 2
IF keyboard(47) AND obj = player THEN objects(obj).pid = 1
IF objects(obj).hp > objects(obj).attackhp AND objects(obj).bounty > objects(obj).tid THEN objects(obj).state = 1
IF objects(obj).hp < objects(obj).runhp THEN
objects(obj).state = 2
ELSE
objects(obj).aburn = 0
END IF

IF objects(obj).focus = -1 THEN
objects(obj).state = 3
ELSE
IF objects(objects(obj).focus).pid = -1 THEN
objects(obj).state = 3
ELSE
boink& = (objects(objects(obj).focus).y - objects(obj).y)
boinkx& = (objects(objects(obj).focus).x - objects(obj).x)
IF IsHit(objects(obj).x, objects(obj).y, objects(obj).size + 38400, objects(objects(obj).focus).x, objects(objects(obj).focus).y, objects(objects(obj).focus).size) = 0 THEN objects(obj).focus = -1: objects(obj).state = 3
END IF
END IF

SELECT CASE objects(obj).state
CASE 1
'fontprint 220, 8 * obj, RTRIM$(objects(obj).oname) + " attack"
IF boinkx& <> 0 AND boink& <> 0 THEN

blahang! = ATN(boink& / boinkx&)
IF boinkx& < 0 THEN blahang! = blahang! + 3.141593

IF objects(obj).angle > blahang! + (objects(obj).turn - .01) THEN objects(obj).angle = objects(obj).angle - objects(obj).turn
IF objects(obj).angle < blahang! - (objects(obj).turn - .01) THEN objects(obj).angle = objects(obj).angle + objects(obj).turn
IF objects(obj).angle >= blahang! - (objects(obj).turn - .01) AND objects(obj).angle <= blahang! + (objects(obj).turn - .01) THEN
AddShot obj, 2
AddShot obj, 1
END IF

END IF
IF RND(1) > .7 THEN calcNewVector obj, -objects(obj).burst ELSE calcNewVector obj, objects(obj).burst

CASE 2

IF boinkx& <> 0 AND boink& <> 0 THEN
IF objects(objects(obj).focus).x - objects(obj).x < 2048 AND objects(objects(obj).focus).x - objects(obj).x > -2048 THEN blahang! = ATN(-boink& / boinkx&) ELSE blahang! = ATN(-boinkx& / boink&)

IF boinkx& < 0 THEN blahang! = blahang! + 3.141593

IF objects(obj).angle > blahang! + (objects(obj).turn - .01) THEN objects(obj).angle = objects(obj).angle - objects(obj).turn
IF objects(obj).angle < blahang! - (objects(obj).turn - .01) THEN objects(obj).angle = objects(obj).angle + objects(obj).turn
END IF

calcNewVector obj, -objects(obj).burst
AddShot obj, 3
CASE 3



less& = -1
booko = -1
FOR i = 0 TO 31
IF objects(i).pid <> -1 THEN
IF i <> obj AND objects(obj).freq <> objects(i).freq THEN
IF IsHit(objects(obj).x, objects(obj).y, objects(obj).size + 20480, objects(i).x, objects(i).y, objects(i).size) = 1 THEN
blah& = IsHitD&(objects(obj).x, objects(obj).y, objects(obj).size + 20480, objects(i).x, objects(i).y, objects(i).size)
IF less& = -1 THEN less& = blah: booko = i
IF blah& < less& THEN less& = blah: booko = i
END IF
END IF
END IF
NEXT
IF booko <> -1 THEN objects(obj).focus = booko

less& = -1
booko = -1

FOR i = 0 TO PROMAX
IF projectiles(i).tpid = 4 AND projectiles(i).pid <> -1 THEN
blah& = IsHitD&(objects(obj).x \ 128, objects(obj).y \ 128, objects(obj).size + 20480, projectiles(i).x \ 128, projectiles(i).y \ 128, projectiles(i).size \ 128)
IF less& = -1 THEN less& = blah&: booko = i
IF blah& < less& THEN less& = blah&: booko = i
END IF
NEXT
IF booko > -1 THEN
IF RND(1) > .5 THEN
objects(obj).nodex = projectiles(booko).x
objects(obj).nodey = projectiles(booko).y
END IF
END IF
IF objects(obj).freq = objects(player).freq AND obj <> player THEN objects(obj).nodex = objects(player).x: objects(obj).nodey = objects(player).y
boink& = (objects(obj).nodey - objects(obj).y)
boinkx& = (objects(obj).nodex - objects(obj).x)
IF boinkx& <> 0 AND boink& <> 0 THEN
blahang! = ATN(boink& / boinkx&)
IF boinkx& < 0 THEN blahang! = blahang! + 3.141593

IF objects(obj).angle > blahang! + (objects(obj).turn - .01) THEN objects(obj).angle = objects(obj).angle - objects(obj).turn
IF objects(obj).angle < blahang! - (objects(obj).turn - .01) THEN objects(obj).angle = objects(obj).angle + objects(obj).turn
IF objects(obj).angle < blahang! + (objects(obj).turn - .01) AND objects(obj).angle > blahang! - (objects(obj).turn - .01) THEN
IF objects(obj).velocity > 0 THEN calcNewVector obj, objects(obj).burst * SGN(objects(obj).velocity) ELSE calcNewVector obj, objects(obj).burst
END IF
END IF



END SELECT


END SELECT





END SUB

SUB DoEngineGlobals
k = INP(&H60)
SELECT CASE k
CASE 49
fontprint 100, 92, "DOING THIS WILL START A NEW GAME", 2
fontprint 100, 98, "CONTINUE?  (Y/N)", 2
copy13h
DO: LOOP UNTIL INP(&H60) <> 49
DO: p = INP(&H60): LOOP UNTIL p = 49 OR p = 21
IF p = 21 THEN NewGame
CASE 25
fontprint 100, 92, "GAME PAUSED - PRESS U TO UNPAUSE", 2
copy13h
DO: LOOP UNTIL INP(&H60) <> 25
DO: LOOP UNTIL INP(&H60) = 22
CASE 1
GameDone = 1
CASE 60
IF frames& > overlayframes& THEN
overlay = 1 - overlay
overlayframes& = frames& + 15
END IF
CASE 19
IF frames& > vsyncframes& THEN
vsync = -vsync
IF vsync = 1 THEN
AddConsoleLine "***VSYNC ENABLED***", 2
ELSE
AddConsoleLine "***VSYNC DISABLED***", 2

END IF
vsyncframes& = frames& + 15
END IF
END SELECT
END SUB

SUB DoProjectiles

FOR i = 0 TO PROMAX
 IF projectiles(i).pid <> -1 THEN
  IF projectiles(i).tpid = 3 THEN projectiles(i).angle = projectiles(i).angle + .1: IF projectiles(i).angle > 6.28 THEN projectiles(i).angle = projectiles(i).angle - 6.28
  testx& = projectiles(i).x + projectiles(i).dx
  testy& = projectiles(i).y + projectiles(i).dy
  blah% = 0
  IF testx& < 0 OR testx& > maxpixelx AND blah% = 0 THEN projectiles(i).dx = -projectiles(i).dx: blah% = 1
  IF testy& < 0 OR testy& > maxpixely AND blah% = 0 THEN projectiles(i).dy = -projectiles(i).dy: blah% = 1
  IF blah% = 0 THEN
  bonk = testx& \ 2048
  bonky = testy& \ 2048
  bonko = projectiles(i).x \ 2048
  bonkoy = projectiles(i).y \ 2048
 
IF cachemap(bonk AND 127, bonkoy AND 127) = 2 AND blah% = 0 THEN
IF projectiles(i).tpid = 1 OR projectiles(i).tpid = 5 THEN
projectiles(i).dx = -projectiles(i).dx: blah% = 1
ELSE
blah% = 1
projectiles(i).pid = -1
cachemap(bonk AND 127, bonkoy AND 127) = 0
AddDoop testx&, testy&, -128, 128, 6
AddDoop testx&, testy&, 128, -128, 6
AddDoop testx&, testy&, 128, 128, 6
AddDoop testx&, testy&, -128, -128, 6
AddSplo testx&, testy&, 8, 1
END IF
END IF



IF cachemap(bonko AND 127, bonky AND 127) = 2 AND blah% = 0 THEN
IF projectiles(i).tpid = 1 OR projectiles(i).tpid = 5 THEN
projectiles(i).dy = -projectiles(i).dy: blah% = 1
ELSE
projectiles(i).pid = -1
blah% = 1
cachemap(bonk AND 127, bonkoy AND 127) = 0
AddDoop testx&, testy&, -128, 128, 6
AddDoop testx&, testy&, 128, -128, 6
AddDoop testx&, testy&, 128, 128, 6
AddDoop testx&, testy&, -128, -128, 6
AddSplo testx&, testy&, 8, 1
END IF

END IF
END IF
 
 
 
 
  IF blah% = 0 THEN projectiles(i).x = testx&: projectiles(i).y = testy&
  
   FOR j = 0 TO 31
    IF objects(j).pid <> -1 THEN
     IF IsHit%(projectiles(i).x, projectiles(i).y, projectiles(i).size, objects(j).x, objects(j).y, objects(j).size) AND projectiles(i).pid <> j AND objects(projectiles(i).pid).freq <> objects(j).freq THEN
      SendMessage 1, j, projectiles(i).pid, i
      UsedProj = UsedProj - 1
      projectiles(i).pid = -1
       END IF
     END IF
    IF projectiles(i).bonk < frames& AND projectiles(i).pid <> -1 THEN projectiles(i).pid = -1: UsedProj = UsedProj - 1
  NEXT
 END IF
NEXT


END SUB

SUB DrawHpBand (objnum)
DEF SEG = VARSEG(dbuffer(0))
offs& = VARPTR(dbuffer(0))
dbuffer(54) = CVI(CHR$(15) + CHR$(15))
dbuffer(105) = dbuffer(54)
boink = (objects(objnum).hp / objects(objnum).maxhp) * 49
FOR i = 0 TO boink
IF boink < 30 THEN col = 137 ELSE col = 57
IF boink < 10 THEN col = 41
dbuffer(55 + i) = CVI(CHR$(col) + CHR$(col))
NEXT

END SUB

SUB DrawOverlay

put13h VARSEG(doop(0, 2)), VARPTR(doop(0, 2)), 44, 0, 0
fontprint 50, 0, STR$(objects(player).weapon(2).ammo), 1
fontprint 70, 0, STR$(objects(player).maxhp), 1
DrawHpBand player
fontprint 220, 0, LTRIM$(RTRIM$(objects(player).oname)) + "(" + LTRIM$(RTRIM$(STR$(objects(player).bounty))) + ")", 1

SELECT CASE overlay
CASE 1
FOR i = 0 TO 31
IF objects(i).pid <> -1 THEN
fontprint 0, 8, "NAME", 2
fontprint 80, 8, "B", 2
fontprint 100, 8, "W/L", 2
fontprint 140, 8, "F", 2
fontprint 170, 8, "K", 2
fontprint 0, 8 * i + 16, LTRIM$(RTRIM$(objects(i).oname)), 1
fontprint 80, 8 * i + 16, LTRIM$(RTRIM$(STR$(objects(i).bounty))), 1
fontprint 100, 8 * i + 16, LTRIM$(RTRIM$(STR$(objects(i).wins))) + "-" + LTRIM$(RTRIM$(STR$(objects(i).losses))), 1
fontprint 140, 8 * i + 16, LTRIM$(RTRIM$(STR$(objects(i).freq))), 1
fontprint 170, 8 * i + 16, LTRIM$(RTRIM$(STR$(objects(i).confirmed))), 1
END IF

NEXT

FOR i = 0 TO 4
fontprint 0, 160 + (i * 6), Console(i, 1), ConsoleC(i)
NEXT
CASE 0
IF frames& <= c2frames THEN
FOR i = 0 TO 3
fontprint 70, 34 + (i * 6), Console(i, 1), ConsoleC(i)
NEXT
fontprint 58, 58, "->" + Console(4, 1), ConsoleC(4)
END IF



END SELECT
fontprint 273, 160, TIME$, 1


END SUB

SUB erplines (x1, y1, x2, y2)

IF y2 < y1 THEN
 SWAP x1, x2
 SWAP y1, y2
END IF
deltay = y2 - y1
'IF deltay > 0 THEN
 deltax = x2 - x1
 x = x1
 IF ABS(deltax) > deltay THEN
  IF x2 < x1 THEN
   SWAP x1, x2
   SWAP y1, y2
  END IF
  deltay = y2 - y1
  deltax = x2 - x1
  y = y1 + 100
  FOR x = x1 TO x2
   ey = ey + deltay
   IF ey > deltax THEN y = y + 1: ey = ey - deltax
   IF -ey > deltax THEN y = y - 1: ey = ey + deltax
   IF y >= 0 AND y < 200 THEN
    IF x < st(y).x THEN
     st(y).x = x
    END IF
    IF x > en(y).x THEN
     en(y).x = x
    END IF
   END IF
  NEXT
 ELSE
  FOR y = y1 + 100 TO y2 + 100
   ex = ex + deltax
   IF ex > deltay THEN x = x + 1: ex = ex - deltay
   IF -ex > deltay THEN x = x - 1: ex = ex + deltay
   IF y >= 0 AND y < 200 THEN
    IF x < st(y).x THEN
     st(y).x = x
    END IF
    IF x > en(y).x THEN
     en(y).x = x
    END IF
   END IF
  NEXT
 END IF
'ELSE
 'IF x1 < st(y).x THEN
 ' st(y).x = x1
 'END IF
 'IF x1 > en(y).x THEN
 ' en(y).x = x1
 'END IF
 'IF x2 < st(y).x THEN
 ' st(y).x = x2
 'END IF
 'IF x2 > en(y).x THEN
 ' en(y).x = x2
 'END IF
'END IF

END SUB

SUB ExecObjects
blarf = -1
FOR doobj = 0 TO 31
 IF objects(doobj).wins > fraglimit AND fraglimit > 0 THEN blarf = doobj
 DoAi doobj
 IF objects(doobj).pid <> -1 THEN
 IF (frames& AND 3) = 2 THEN
 objects(doobj).hp = objects(doobj).hp + 1
 IF objects(doobj).aburn = 1 AND objects(doobj).hp - 2 > 5 THEN objects(doobj).hp = objects(doobj).hp - 2
 END IF
 IF objects(doobj).hp > objects(doobj).maxhp THEN objects(doobj).hp = objects(doobj).maxhp
 MoveTehShippy doobj
 END IF
NEXT

IF blarf <> -1 THEN
player = blarf
camera.x = objects(blarf).x
camera.y = objects(blarf).y
FocusCamera
DisplayMap camera


a$ = LTRIM$(RTRIM$(objects(blarf).oname)) + " IS THE WINNAR"
fontprint 160 - LEN(a$) * 3, 80, a$, 2
a$ = "Press Enter to Start a new Game"
fontprint 160 - LEN(a$) * 3, 130, a$, 1
copy13h
DO
LOOP UNTIL INP(&H60) = 28

NewGame
IF blarf <> player THEN m$ = "GAME WON BY " + LTRIM$(RTRIM$(objects(blarf).oname)) + "!" ELSE m$ = "YOU ARE THE WINNAR!!!"

AddConsoleLine m$, 1
END IF
END SUB

SUB fadein (Redval, GreenVal, BlueVal, frames)

FOR fade = 0 TO frames
WAIT &H3DA, 8
WAIT &H3DA, 8, 8
OUT &H3C8, 0

FOR Pal = 0 TO 255
OUT &H3C9, Redval - (Redval - r(Pal)) * fade \ frames
OUT &H3C9, GreenVal - (GreenVal - g(Pal)) * fade \ frames
OUT &H3C9, BlueVal - (BlueVal - b(Pal)) * fade \ frames
NEXT

NEXT


END SUB

SUB fadeout (Redval, GreenVal, BlueVal, frames)

FOR fade = frames TO 0 STEP -1
WAIT &H3DA, 8
WAIT &H3DA, 8, 8
OUT &H3C8, 0

FOR Pal = 0 TO 255
OUT &H3C9, Redval - (Redval - r(Pal)) * fade \ frames
OUT &H3C9, GreenVal - (GreenVal - g(Pal)) * fade \ frames
OUT &H3C9, BlueVal - (BlueVal - b(Pal)) * fade \ frames
NEXT

NEXT

END SUB

SUB FocusCamera
camera.x = camera.x - 20480
camera.y = camera.y - 12800
IF camera.x < 0 THEN camera.x = 0
IF camera.x > maxpixelx - 40959 THEN camera.x = maxpixelx - 40959
IF camera.y > maxpixely - 25599 THEN camera.y = maxpixely - 25599
IF camera.y < 0 THEN camera.y = 0

END SUB

SUB fontprint (x, y, text$, col)
SELECT CASE col

CASE 1, 0
startx = x
FOR i = 1 TO LEN(text$)
put13h VARSEG(font(0, ASC(MID$(text$, i, 1)))), VARPTR(font(0, ASC(MID$(text$, i, 1)))), startx, y, 0
startx = startx + 6
NEXT

CASE 2
startx = x
FOR i = 1 TO LEN(text$)
put13h VARSEG(fontg(0, ASC(MID$(text$, i, 1)))), VARPTR(fontg(0, ASC(MID$(text$, i, 1)))), startx, y, 0
startx = startx + 6
NEXT

END SELECT
END SUB

SUB Intro

'Main execution loop for the Intro.  Use dynamic allocation only.

fadeout 0, 0, 0, 1
CLS
setpal "title.pal"
DEF SEG = VARSEG(dbuffer(0))
BLOAD "title.img", VARPTR(dbuffer(0))
copy13h
fadein 0, 0, 0, 64
DO
keyb = INP(&H60)
LOOP UNTIL (keyb = 1 OR keyb = 28)
fadeout 0, 0, 0, 64
FOR i = 0 TO 32766
dbuffer(i) = 0
NEXT
copy13h
IF keyb = 1 THEN GameDone = 1
setpal "game.pal"
END SUB

FUNCTION IsHit% (x1 AS LONG, y1 AS LONG, r1 AS LONG, x2 AS LONG, y2 AS LONG, r2 AS LONG)
d& = r1 + r2: a& = x2 - x1: b& = y2 - y1
 IF a& > d& OR a& < -d& OR b& > d& OR b& < -d& THEN IsHit% = 0 ELSE IF (a& * a& + b& * b&) < (d& * d&) THEN IsHit% = 1 ELSE IsHit% = 0
END FUNCTION

FUNCTION IsHitD& (x1 AS LONG, y1 AS LONG, r1 AS LONG, x2 AS LONG, y2 AS LONG, r2 AS LONG)
d& = r1 + r2: a& = x2 - x1: b& = y2 - y1
IsHitD& = SQR(a& * a& + b& * b&)

END FUNCTION

SUB Killshippy (kobject, fromobj)

'IF fromobj = -1 THEN EXIT SUB
FOR i = 0 TO 2
IF teamfreq(i) = objects(fromobj).freq THEN blonk = i
NEXT
teamscore(blonk) = teamscore(blonk) + 1
FOR i = 0 TO 3
bonk = ((2048 * RND) * INT(3 * RND - 1))
bonk2 = ((2048 * RND) * INT(3 * RND - 1))
AddSplo (objects(kobject).x + bonk), (objects(kobject).y + bonk), 8, 1
NEXT
AddDoop objects(kobject).x, objects(kobject).y, 0, 0, 4

blah1$ = LTRIM$(RTRIM$(STR$(objects(kobject).bounty)))
blah2$ = LTRIM$(RTRIM$(STR$(objects(fromobj).bounty)))

m$ = LTRIM$(RTRIM$(objects(kobject).oname)) + "(" + blah1$ + ")" + " was 0wned by " + LTRIM$(RTRIM$(objects(fromobj).oname)) + "(" + blah2$ + ")"

AddConsoleLine m$, 2
objects(fromobj).confirmed = objects(fromobj).confirmed + 1

SELECT CASE objects(fromobj).confirmed
CASE IS <= 3
CASE 4
m$ = LTRIM$(RTRIM$(objects(fromobj).oname)) + " IS ON A KILLING SPREE! (4 KILLS)"
AddConsoleLine m$, 2
objects(fromobj).maxhp = objects(fromobj).maxhp + 100
CASE 8
m$ = LTRIM$(RTRIM$(objects(fromobj).oname)) + " IS ON AN UBER KILLING SPREE! (8 KILLS)"
AddConsoleLine m$, 2
objects(fromobj).maxhp = objects(fromobj).maxhp + 100
CASE 16
m$ = LTRIM$(RTRIM$(objects(fromobj).oname)) + " IS ON AN UBER LEET KILLING SPREE! (16 KILLS)"
AddConsoleLine m$, 2
objects(fromobj).maxhp = objects(fromobj).maxhp + 100
CASE 32
m$ = LTRIM$(RTRIM$(objects(fromobj).oname)) + " IS ON A GODLIKE KILLING SPREE! (32 KILLS)"
AddConsoleLine m$, 2
objects(fromobj).maxhp = objects(fromobj).maxhp + 100
CASE 64
m$ = LTRIM$(RTRIM$(objects(fromobj).oname)) + " IS ON A RIDICULOUSLY DOMINATING KILLING SPREE! (64 KILLS)"
AddConsoleLine m$, 2
objects(fromobj).maxhp = objects(fromobj).maxhp + 100
END SELECT

objects(fromobj).wins = objects(fromobj).wins + 1
objects(kobject).losses = objects(kobject).losses + 1
objects(fromobj).score = objects(fromobj).score + (objects(kobject).bounty \ 3) + 1
objects(fromobj).bounty = objects(fromobj).bounty + (objects(kobject).bounty \ 3) + 1


rdelay(kobject).ship = kobject
rdelay(kobject).rframes = frames& + 210
rd(kobject).freq = objects(kobject).freq
rd(kobject).spr = objects(kobject).spr
rd(kobject).pgun = objects(kobject).weapon(0).tpid
rd(kobject).sgun = objects(kobject).weapon(1).tpid
rd(kobject).statid = objects(kobject).statid
rd(kobject).tid = objects(kobject).tid
rd(kobject).oname = objects(kobject).oname
rd(kobject).bounty = objects(kobject).score
rd(kobject).pid = objects(kobject).pid
rd(kobject).runhp = objects(kobject).runhp
rd(kobject).attackhp = objects(kobject).attackhp
objects(kobject).pid = -1
END SUB

SUB LoadBots

a = FREEFILE
OPEN "bot\bot.cfg" FOR INPUT AS #a

DO
LINE INPUT #a, a$
LOOP UNTIL a$ = "START"

DO

  DO
  LINE INPUT #a, a$
  LOOP UNTIL LEFT$(a$, 4) = "NAME" OR LEFT$(a$, 3) = "END"
  IF LEFT$(a$, 3) = "END" THEN EXIT DO
  shippyname$ = RIGHT$(a$, LEN(a$) - 5)  ' "NAME "
  a$ = "": LINE INPUT #a, a$
  shippytype = VAL(RIGHT$(a$, LEN(a$) - 5)) ' "TYPE "
  a$ = "": LINE INPUT #a, a$
  shippyfreq! = VAL(RIGHT$(a$, LEN(a$) - 5)) ' "FREQ "
  a$ = "": LINE INPUT #a, a$
  shippyrun = VAL(RIGHT$(a$, LEN(a$) - 6)) ' "RUNHP "
  a$ = "": LINE INPUT #a, a$
  shippyatt = VAL(RIGHT$(a$, LEN(a$) - 9)) ' "ATTACKHP "

  Addshippy shippyname$, shippyfreq!, shippytype - 1, maxpixelx * RND, maxpixely * RND, 2, 1, 2, shippyrun, shippyatt, 1, 0, -1

LOOP

CLOSE #a
END SUB

SUB MoveTehShippy (objnum)
testx& = objects(objnum).x + objects(objnum).dx
testy& = objects(objnum).y + objects(objnum).dy
blah% = 0
bonk = testx& \ 2048
bonky = testy& \ 2048
bonko = objects(objnum).x \ 2048
bonkoy = objects(objnum).y \ 2048


IF (testx& < 0 OR testx& > maxpixelx) AND blah% = 0 THEN objects(objnum).dx = -objects(objnum).dx: blah% = 1
IF (testy& < 0 OR testy& > maxpixely) AND blah% = 0 THEN objects(objnum).dy = -objects(objnum).dy: blah% = 1

IF cachemap(bonk AND 127, bonkoy AND 127) = 2 AND blah% = 0 THEN

objects(objnum).dx = -objects(objnum).dx: blah% = 1

END IF
IF cachemap(bonko AND 127, bonky AND 127) = 2 AND blah% = 0 THEN

objects(objnum).dy = -objects(objnum).dy: blah% = 1

END IF

IF blah% = 0 THEN
objects(objnum).x = testx&
objects(objnum).y = testy&
END IF
END SUB

SUB NewGame

rdp = -1
FOR i = 0 TO 31
rdelay(i).ship = -1
objects(i).wins = 0
objects(i).losses = 0
objects(i).pid = -1
objects(i).hp = 0
NEXT
FOR i = 0 TO PROMAX
projectiles(i).pid = -1
projectiles(i).maxrate = 1024
NEXT


FOR i = 0 TO 127
FOR j = 0 TO 127
cachemap(i, j) = 0
IF RND(1) > .98 THEN cachemap(i, j) = 1
IF RND(1) > .99 THEN cachemap(i, j) = 2
NEXT j, i



Addshippy "Happyfez", 333, 0, maxpixelx * RND, maxpixely * RND, 1, 1, 2, 40, 80, 1, 0, -1
player = 0
LoadBots

fraglimit = -1

teamfreq(0) = 333
teamfreq(1) = 334
teamfreq(2) = 66


m$ = "New game started by the Server"

AddConsoleLine m$, 1

fadeout 0, 0, 0, 32
FOR i = 0 TO 32766
dbuffer(i) = 0
NEXT
copy13h
fadein 0, 0, 0, 32
fontprint 16, 8, "How to play Shippy", 2
fontprint 16, 16, "==================", 1
fontprint 16, 24, "P PAUSES THE GAME", 2
fontprint 16, 32, "F2 toggles different overlays", 1
fontprint 16, 40, "SPACE fires bullets", 1
fontprint 16, 48, "TAB fires an orb", 1
fontprint 16, 56, "CTRL lays a mine (limited number)", 1
fontprint 16, 64, "  (Second number on the top right is mines)", 1
fontprint 16, 72, "Z fires afterburner (takes energy)", 1
fontprint 16, 80, "C toggles Computer Control - V restores", 1
fontprint 16, 88, "R toggles VSYNC", 1
fontprint 16, 96, "N STARTS A NEW GAME", 2
fontprint 16, 104, "ESC QUITS THE GAME", 2
fontprint 16, 150, "PRESS N TO START A NEW GAME", 2
copy13h
DO: LOOP UNTIL INP(&H60) <> 49
DO: LOOP UNTIL INP(&H60) = 49
DO: LOOP UNTIL INP(&H60) <> 49
END SUB

SUB rotspr (segm, offs, x, y, theta!)

DIM rsprite(31, 31)
DEF SEG = segm
offsd& = offs + 4
FOR i = 0 TO 15
FOR j = 0 TO 15
c = PEEK(offsd& + j)
rsprite(j, i) = c
'rsprite(j * 2 + 1, i * 2 + 1) = c
'rsprite(j * 2, i * 2) = c
'rsprite(j * 2 + 1, i * 2) = c
NEXT
offsd& = offsd& + 16
NEXT
sine = 32 * SIN(theta!)
cosine = 32 * COS(theta!)
x1 = ((-8) * cosine - (-8) * sine) \ 32 '+ x
y1 = ((-8) * sine + (-8) * cosine) \ 32' + y
x2 = ((-8) * cosine - (7) * sine) \ 32 '+ x
y2 = ((-8) * sine + (7) * cosine) \ 32 '+ y
x3 = ((7) * cosine - (7) * sine) \ 32'+ x
y3 = ((7) * sine + (7) * cosine) \ 32 '+ y
x4 = ((7) * cosine - (-8) * sine) \ 32 '+ x
y4 = ((7) * sine + (-8) * cosine) \ 32 '+ y

FOR cy = 0 TO 200
st(cy).x = 160
en(cy).x = -160
NEXT
erplines (x1), (y1), (x2), (y2)
erplines (x2), (y2), (x3), (y3)
erplines (x3), (y3), (x4), (y4)
erplines (x4), (y4), (x1), (y1)
ya = y1
yb = y1
IF y2 < ya THEN ya = y2
IF y3 < ya THEN ya = y3
IF y4 < ya THEN ya = y4
IF y2 > yb THEN yb = y2
IF y3 > yb THEN yb = y3
IF y4 > yb THEN yb = y4
xa = x1
xb = x1
IF x2 < xa THEN xa = x2
IF x3 < xa THEN xa = x3
IF x4 < xa THEN xa = x4
IF x2 > xb THEN xb = x2
IF x3 > xb THEN xb = x3
IF x4 > xb THEN xb = x4
ya = ya + y
yb = yb + y
sine = -sine
DEF SEG = VARSEG(dbuffer(0))
DIM xc1(xa + x TO xb + x), xc2(xa + x TO xb + x)
FOR cx = (xa) TO (xb)
xc1(cx + x) = (cx) * cosine - 512
xc2(cx + x) = (cx) * sine - 512
NEXT
IF ya < 0 THEN ya = 0
IF yb > 199 THEN yb = 199
cy2 = ya - y + 100
FOR cy = (ya) TO (yb)
 IF en(cy2).x > 319 - x THEN en(cy2).x = 319 - x
 IF st(cy2).x < -x THEN st(cy2).x = -x
 deltax = en(cy2).x - st(cy2).x
 IF deltax > 0 THEN
  yc1 = sine * (cy - y)
  yc2 = cosine * (cy - y)
  o& = st(cy2).x + x + ytable(cy) + VARPTR(dbuffer(0))
  FOR cx = (st(cy2).x + x) TO (en(cy2).x + x)
   u = (xc1(cx) - yc1) \ 32 - 8
   v = (xc2(cx) + yc2) \ 32 - 8
   c = rsprite((u) AND 31, (v) AND 31)
   IF c > 0 THEN POKE o&, c
   o& = o& + 1
  NEXT
 END IF
 cy2 = cy2 + 1
NEXT

END SUB

SUB rotspr2 (segm, offs, x, y, theta!)
DIM rsprite(31, 31)
DEF SEG = segm
offsd& = offs + 4
FOR i = 0 TO 7
FOR j = 0 TO 7
c = PEEK(offsd& + j)
rsprite(j, i) = c
'rsprite(j * 2 + 1, i * 2 + 1) = c
'rsprite(j * 2, i * 2) = c
'rsprite(j * 2 + 1, i * 2) = c
NEXT
offsd& = offsd& + 8
NEXT
sine = 32 * SIN(theta!)
cosine = 32 * COS(theta!)
x1 = ((-4) * cosine - (-4) * sine) \ 32 '+ x
y1 = ((-4) * sine + (-4) * cosine) \ 32' + y
x2 = ((-4) * cosine - (3) * sine) \ 32 '+ x
y2 = ((-4) * sine + (3) * cosine) \ 32 '+ y
x3 = ((3) * cosine - (3) * sine) \ 32'+ x
y3 = ((3) * sine + (3) * cosine) \ 32 '+ y
x4 = ((3) * cosine - (-4) * sine) \ 32 '+ x
y4 = ((3) * sine + (-4) * cosine) \ 32 '+ y

FOR cy = 0 TO 200
st(cy).x = 160
en(cy).x = -160
NEXT
erplines (x1), (y1), (x2), (y2)
erplines (x2), (y2), (x3), (y3)
erplines (x3), (y3), (x4), (y4)
erplines (x4), (y4), (x1), (y1)
ya = y1
yb = y1
IF y2 < ya THEN ya = y2
IF y3 < ya THEN ya = y3
IF y4 < ya THEN ya = y4
IF y2 > yb THEN yb = y2
IF y3 > yb THEN yb = y3
IF y4 > yb THEN yb = y4
xa = x1
xb = x1
IF x2 < xa THEN xa = x2
IF x3 < xa THEN xa = x3
IF x4 < xa THEN xa = x4
IF x2 > xb THEN xb = x2
IF x3 > xb THEN xb = x3
IF x4 > xb THEN xb = x4
ya = ya + y
yb = yb + y
sine = -sine
DEF SEG = VARSEG(dbuffer(0))
DIM xc1(xa + x TO xb + x), xc2(xa + x TO xb + x)
FOR cx = (xa) TO (xb)
xc1(cx + x) = (cx) * cosine - 512
xc2(cx + x) = (cx) * sine - 512
NEXT
IF ya < 0 THEN ya = 0
IF yb > 199 THEN yb = 199
cy2 = ya - y + 100
FOR cy = (ya) TO (yb)
 IF en(cy2).x > 319 - x THEN en(cy2).x = 319 - x
 IF st(cy2).x < -x THEN st(cy2).x = -x
 deltax = en(cy2).x - st(cy2).x
 IF deltax > 0 THEN
  yc1 = sine * (cy - y)
  yc2 = cosine * (cy - y)
  o& = st(cy2).x + x + ytable(cy) + VARPTR(dbuffer(0))
  FOR cx = (st(cy2).x + x) TO (en(cy2).x + x)
   u = (xc1(cx) - yc1) \ 32 - 12
   v = (xc2(cx) + yc2) \ 32 - 12
   c = rsprite((u) AND 31, (v) AND 31)
   IF c > 0 THEN POKE o&, c
   o& = o& + 1
  NEXT
 END IF
 cy2 = cy2 + 1
NEXT

END SUB

SUB SendMessage (MsgNum, destobj, fromobj, d1)
'SendMessage 1, j, projectiles(i).pid, i
IF objects(destobj).freq = objects(fromobj).freq THEN EXIT SUB


IF fromobj = -1 THEN EXIT SUB
SELECT CASE MsgNum
CASE 1
    SELECT CASE projectiles(d1).tpid
    CASE 1
    objects(destobj).hp = objects(destobj).hp - 10 - (10 * objects(fromobj).blevel)
    AddSplo objects(destobj).x, objects(destobj).y, 4, 3
    CASE 2
    objects(destobj).hp = objects(destobj).hp - 70 - (20 * objects(fromobj).olevel)
    AddSplo objects(destobj).x, objects(destobj).y, 8, 1
    CASE 3
    objects(destobj).hp = objects(destobj).hp - 35 - (30 * objects(fromobj).mlevel)
    AddSplo objects(destobj).x, objects(destobj).y, 8, 1
    CASE 6
    AddSplo objects(destobj).x, objects(destobj).y, 4, 3
    CASE 5
    objects(destobj).hp = objects(destobj).hp - 10 - (10 * objects(fromobj).blevel)
    AddSplo objects(destobj).x, objects(destobj).y, 4, 3
   
    CASE 4
    objects(destobj).score = objects(destobj).score + 1
    objects(destobj).bounty = objects(destobj).bounty + 1
    a! = RND(1)
    SELECT CASE a!
    CASE 0 TO .16
    IF destobj = player THEN AddConsoleLine "FULL HP RECHARGE", 1
    objects(destobj).hp = objects(destobj).maxhp
    CASE .17 TO .3
    IF objects(destobj).blevel <= 3 THEN objects(destobj).blevel = objects(destobj).blevel + 1
    IF destobj = player THEN AddConsoleLine "LEVEL " + LTRIM$(RTRIM$(STR$(objects(destobj).blevel))) + " BULLETS", 1
    CASE .31 TO .43
    IF objects(destobj).olevel <= 3 THEN objects(destobj).olevel = objects(destobj).olevel + 1
    IF destobj = player THEN AddConsoleLine "LEVEL " + LTRIM$(RTRIM$(STR$(objects(destobj).olevel))) + " ORBS", 1
    CASE .43 TO .57
    IF objects(destobj).mlevel <= 3 THEN objects(destobj).mlevel = objects(destobj).mlevel + 1
    IF destobj = player THEN AddConsoleLine "LEVEL " + LTRIM$(RTRIM$(STR$(objects(destobj).mlevel))) + " MINES", 1
    CASE .58 TO .71
    objects(destobj).weapon(2).ammo = objects(destobj).weapon(2).ammo + 1
    IF destobj = player THEN AddConsoleLine "EXTRA MINE", 1
    CASE .72 TO .77
    objects(destobj).x = maxpixelx * RND
    objects(destobj).y = maxpixely * RND
    AddSplo objects(destobj).x, objects(destobj).y, 8, 2
    IF destobj = player THEN AddConsoleLine "RANDOM TRANSPORT BAHHAHAH!", 0
    CASE ELSE
    IF destobj = player THEN AddConsoleLine "10 MAXHP BONUS", 0
    objects(destobj).maxhp = objects(destobj).maxhp + 10
    END SELECT
    END SELECT
IF objects(destobj).hp <= 0 THEN Killshippy destobj, fromobj: objects(destobj).pid = -1
END SELECT

END SUB

SUB setpal (file$)
a = FREEFILE
OPEN file$ FOR BINARY AS #a

FOR i = 0 TO 255
r(i) = ASC(INPUT$(1, 1))
g(i) = ASC(INPUT$(1, 1))
b(i) = ASC(INPUT$(1, 1))

NEXT i
CLOSE #a

END SUB

SUB TransBox (TransBoxX1, TransBoxY1, TransBoxX2, TransBoxY2, TransBoxColor)


  FOR Pal = 0 TO 255
         TransPal(Pal) = TransPal(Pal) + TransBoxColor + 5
  NEXT


  DEF SEG = VARSEG(dbuffer(0))

  add = 320 - TransBoxX2 + TransBoxX1 - 1
  PointToDraw& = TransBoxY1 * 320& + TransBoxX1 + VARPTR(dbuffer(0))

  FOR DrawY = TransBoxY1 TO TransBoxY2

         FOR DrawX = TransBoxX1 TO TransBoxX2

                POKE PointToDraw&, TransPal(PEEK(PointToDraw&))
                PointToDraw& = PointToDraw& + 1
                                                                                
         NEXT
 
         PointToDraw& = PointToDraw& + add

  NEXT

  DEF SEG

  FOR Pal = 0 TO 255
         TransPal(Pal) = TransPal(Pal) - TransBoxColor - 5
  NEXT

  EXIT SUB


END SUB

SUB UpSplo
FOR i = 0 TO SPLOMAX
IF splosions(i).t > 0 THEN
boink& = frames& - splosions(i).sframe
IF boink& > splosions(i).d * 4 - 1 THEN splosions(i).t = 0
IF boink& > 0 THEN splosions(i).currframe = boink& \ splosions(i).d ELSE splosions(i).currframe = 0
END IF
NEXT

END SUB

