'Finish adding instructions.

'ͻ'
' ͻ '
'                                                                      '
'                                                                      '
'      ͻͻ      '
'       ͼͻ       '
'                                                                  '
'                 ͻ                 '
'                  ͻ                  '
'                       COLLAPSE ver. 1                        '
'                   CREATED BY: COLIN MORGAN                   '
'                         ARCADE  GAME                         '
'                  ͼ                  '
'                 ͼ                 '
'                                                                  '
'       ͼ       '
'      ͼ      '
'                                                                      '
'                                                                      '
' ͻͼ '
'ͼͼ'
DEFINT A-Z
DECLARE SUB Credits ()
TYPE POINTER
  y AS INTEGER
  x AS INTEGER
END TYPE
'--------------
'- Large Subs -
' Subs/Functions over 99 Lines Long.
DECLARE SUB Main ()
DECLARE SUB CollapseSquare (y, x)
DECLARE SUB PutBmp (scrx, scry, filename$, skew)
DECLARE SUB DrawBackground (Num, x1, y1, x2, y2)


'--------------
'- Short Subs -
' Subs/Functions less than 100 Lines Long.
DECLARE SUB DrawCircle (Array() AS POINTER, y, x, radius, DegStart, DegEnd)
DECLARE SUB RefreshScreen ()
DECLARE SUB RefreshBoard ()
DECLARE SUB ShiftUp ()
DECLARE SUB Lose ()
DECLARE SUB NewBlock ()
DECLARE SUB ShiftDown ()
DECLARE SUB DrawBox (y, x, c)
DECLARE SUB PUTPIC (y, x, c)
DECLARE SUB SetColors ()
DECLARE SUB Suspend (delay!, Speed&)
DECLARE SUB ShiftLeftRight ()
DECLARE SUB NextLevel ()
DECLARE SUB ShowStats ()
DECLARE SUB EndMessage ()
DECLARE SUB HighScores ()
DECLARE SUB Instructions ()
DECLARE SUB SaveGame ()
DECLARE SUB LoadGame ()
DECLARE FUNCTION GetSpeed& ()


  '------------------------------------------------'
  '------------------------------------------------'
  '- Mouse Sub\Function Declarations              -'
  '- Everything Mouse Like                        -'
  '------------------------------------------------'
  DECLARE SUB zzMouse (Num, x, y)
  DECLARE FUNCTION zzMouseIn (x1, y1, x2, y2)

  DIM SHARED MOUSE$
  DIM SHARED lb, rb
  DIM SHARED mpnt   AS POINTER

  'Constant Variables
  CONST MOUSEINIT = 1   'No return - Initialize the Mouse(Only do this once!)
  CONST MOUSEHIDE = 2   'No return - Hide the mouse from view.
  CONST MOUSESHOW = 3   'No return - Show the mouse again.
  CONST MOUSEGPOS = 4   'Get the current mouse coordinates through x and y.
  CONST MOUSESPOS = 5   'No return - Move the mouse somewhere on the screen.
  CONST MOUSEGBUT = 6   'Get whether the mouse buttons are pressed or not
                        '  through x for left-clikc and y for right-click.
  CONST MOUSEZONEX = 7  'Uses y as left bound and x as right.
  CONST MOUSEZONEY = 8  'Uses y as top bound and x as bottom.
                            'ZoneX and ZoneY set the area that the can move
                            '  about in.

  DATA 55,89,E5,8B,5E,0C,8B,07,50,8B,5E,0A,8B,07,50,8B
  DATA 5E,08,8B,0F,8B,5E,06,8B,17,5B,58,1E,07,CD,33,53
  DATA 8B,5E,0C,89,07,58,8B,5E,0A,89,07,8B,5E,08,89,0F
  DATA 8B,5E,06,89,17,5D,CA,08,00
  '------------------------------------------------'



'------------
'- Contants -
' Declare all Constants.
CONST FALSE = 0
CONST TRUE = NOT FALSE
CONST xoff = 9
CONST yoff = 0
CONST xoff2 = 1
CONST yoff2 = 1


'--------------------
'- Global Variables -
' Declare all Variables to be Shared Globally.
  RANDOMIZE TIMER

DIM SHARED CompSpeed     AS LONG
DIM SHARED Board(18, 13) AS INTEGER
DIM SHARED Destroy(160)  AS POINTER
DIM SHARED xBlock        AS INTEGER
DIM SHARED Pic(10, 10)   AS INTEGER
'This is how many points are left to add to the players score.
DIM SHARED add           AS INTEGER
'Make a var to tell when the mouse has been clicked
DIM SHARED begin         AS INTEGER
DIM SHARED msgtm         AS SINGLE
DIM SHARED msgtmlen      AS SINGLE
DIM SHARED Bckgrnd       AS INTEGER
DIM BmpData(10)          AS STRING
TYPE Stats
  Level  AS INTEGER
  Lines  AS INTEGER
  Points AS LONG
END TYPE
'-------------------------
DIM SHARED Stat AS Stats
    Stat.Level = 0
    Stat.Lines = -1
    Stat.Points& = -100
'-------------------------


'-------------------------------------------------
  'Load Block.MP
  OPEN "BLOCK.MP" FOR INPUT AS #1
    FOR y = 1 TO 10
      LINE INPUT #1, BmpData(y)
    NEXT y
  CLOSE #1

  FOR y = 1 TO 10
    FOR x = 1 TO 10
      Char$ = MID$(BmpData(y), (x * 3 - 2), 3)
      Pic(y, x) = VAL(Char$)
    NEXT x
  NEXT y


  CompSpeed& = GetSpeed&


  zzMouse MOUSEINIT, 170, 85

'-------------------------------'
'- Enter The Main Program Loop -'
'-------------------------------'
  Main
  SYSTEM

SUB CollapseSquare (y, x)
  'Find all blocks of the same color connected to selected block.
  DIM count AS INTEGER
  DIM ffile AS INTEGER
  DIM sc    AS INTEGER  '(Starting Color)
  count = 0
  sc = Board(y, x)

  'I have to basically "force" recursion because QBasic doesn't have enough
  '  stack space.
  ffile = FREEFILE
  OPEN "~$Stack.dat" FOR OUTPUT AS #ffile  'Erase the file.
  CLOSE #ffile
  OPEN "~$Stack.dat" FOR RANDOM AS #ffile
    count = count + 1
    PUT #ffile, , x
    PUT #ffile, , y
    Destroy(count).x = x:  Destroy(count).y = y

    'Loop until we get all the back to the beginning of the file.
    DO UNTIL SEEK(ffile) = 1
CollapseSquareRunBlock:
      'Get the x and y values to use now.
      SEEK #ffile, SEEK(ffile) - 2
      GET #ffile, , x
      GET #ffile, , y

      'Set this block to destroyed.
      Board(y, x) = 0

      'Now test each pixel adjacent to this one and "run" it.
      'Up
      IF y > 1 THEN
        IF Board(y - 1, x) = sc THEN
          y = y - 1
          count = count + 1
          Destroy(count).x = x:  Destroy(count).y = y
          PUT #ffile, , x
          PUT #ffile, , y
          GOTO CollapseSquareRunBlock
        END IF
      END IF
      'Left
      IF x > 1 THEN
        IF Board(y, x - 1) = sc THEN
          x = x - 1
          count = count + 1
          Destroy(count).x = x:  Destroy(count).y = y
          PUT #ffile, , x
          PUT #ffile, , y
          GOTO CollapseSquareRunBlock
        END IF
      END IF
      'Down
      IF y < 16 THEN
        IF Board(y + 1, x) = sc THEN
          y = y + 1
          count = count + 1
          Destroy(count).x = x:  Destroy(count).y = y
          PUT #ffile, , x
          PUT #ffile, , y
          GOTO CollapseSquareRunBlock
        END IF
      END IF
      'Right
      IF x < 12 THEN
        IF Board(y, x + 1) = sc THEN
          x = x + 1
          count = count + 1
          Destroy(count).x = x:  Destroy(count).y = y
          PUT #ffile, , x
          PUT #ffile, , y
          GOTO CollapseSquareRunBlock
        END IF
      END IF

      'Go back to the last pixel.
      SEEK #ffile, SEEK(ffile) - 2
    LOOP

  CLOSE #ffile
  KILL "~$Stack.dat"


  'If there are only two blocks then don't collapse them.
  IF count < 3 THEN
    Board(y, x) = sc
    IF count = 2 THEN
      Board(Destroy(2).y, Destroy(2).x) = sc
    END IF
    'Empty Destroy Array
    FOR i = 1 TO 160
      Destroy(i).x = 0
      Destroy(i).y = 0
    NEXT i
    EXIT SUB
  END IF

  'Hide Mouse
  zzMouse MOUSEHIDE, 0, 0
 
  'Make them blow up.
  FOR i4 = 1 TO 5
    FOR i2 = 5 TO 1 STEP -1
      FOR i3 = 1 TO count - 1
        desx = ((Destroy(i3).x + xoff) * 10)
        desy = ((Destroy(i3).y + yoff) * 10)
        LINE (desx + i2 - 1, desy + i2 - 1)-(desx + 10 - i2, desy + 10 - i2), 0, B
      NEXT i3
    NEXT i2
    FOR i2 = 5 TO 1 STEP -1
      FOR i3 = 1 TO count - 1
        desx = ((Destroy(i3).x + xoff) * 10)
        desy = ((Destroy(i3).y + yoff) * 10)
        LINE (desx + i2 - 1, desy + i2 - 1)-(desx + 10 - i2, desy + 10 - i2), 15, B
      NEXT i3
    NEXT i2
  NEXT i4

  'Show Mouse
  zzMouse MOUSESHOW, 0, 0

  ShiftDown

  ShiftLeftRight

  addb4 = add
  FOR i = 1 TO count
    SELECT CASE i
      CASE 1 TO 3:    add = add + 10
      CASE 4 TO 6:    add = add + 20
      CASE 7 TO 9:    add = add + 35
      CASE 10 TO 12:  add = add + 50
      CASE 13 TO 18:  add = add + 75
      CASE 19 TO 25:  add = add + 100
      CASE 26 TO 32:  add = add + 133
      CASE 33 TO 41:  add = add + 166
      CASE 42 TO 160: add = add + 200
      CASE ELSE
        LOCATE 10, 20: PRINT "OOPS, an error has occurred."
        END
    END SELECT
  NEXT i

  'If they got enough points give a message saying "WOW" basically.
  IF count >= 20 THEN
    add = add + 5

    'Give them a message.
    IF msgtmlen > 0 THEN :  msgtmlen = -1
    EndMessage
    SELECT CASE count
      CASE 20 TO 24:   LOCATE 6, 1:  PRINT "Nice!"
      CASE 25 TO 29:   LOCATE 6, 1:  PRINT "Wow!"
      CASE 30 TO 34:   LOCATE 6, 1:  PRINT "Awesome!"
      CASE 35 TO 40:   LOCATE 6, 1:  PRINT "Incredible!"
      CASE 40 TO 160
        LOCATE 6, 1:  PRINT "MASSIVE"
        LOCATE 7, 1:  PRINT "COLLAPSE!"
        add = add + 1246
    END SELECT
    LOCATE 8, 1:  PRINT "+ " + LTRIM$(RTRIM$(STR$(add - addb4)))
    LOCATE 9, 1:  PRINT " pnts!"
    msgtmlen = 2
    msgtm = TIMER
    FOR i = 1 TO 50
      SOUND INT(RND * 50) + 150, .15
    NEXT i
  END IF

  'If the whole board is empty then give 1000 points for each level.
  count = 0
  FOR i = 1 TO 12
    IF Board(16, i) > 0 THEN
      count = 1
      EXIT FOR
    END IF
  NEXT i
  'The whole board is clear!(if)
  IF count = 0 THEN
    add = add + (1000 * Stat.Level)
    'Give them a message.
    IF msgtmlen > 0 THEN :  msgtmlen = -1
    EndMessage
    LOCATE 6, 1:  PRINT "Board"
    LOCATE 7, 1:  PRINT "Cleared!"
    LOCATE 8, 1:  PRINT "+ " + LTRIM$(RTRIM$(STR$(1000 * Stat.Level)))
    LOCATE 9, 1:  PRINT " pnts!"
    msgtmlen = 2
    msgtm = TIMER
    FOR i = 1 TO 250
      SOUND 100 + i, .05
    NEXT i
  END IF

  'Empty Destroy Array
  FOR i = 1 TO 160
    Destroy(i).x = 0
    Destroy(i).y = 0
  NEXT i
END SUB

SUB Credits
  'I List 'Unknown' Simply To Inform You When The Credit Is NOT Mine.
  LOCATE 1, 1:    PRINT "" + STRING$(74, "") + "ͻ";
  LOCATE 2, 1:    PRINT " " + STRING$(74, "") + " ";
  FOR i = 3 TO 28
    LOCATE i, 1:  PRINT " " + STRING$(74, " ") + " ";
  NEXT i
  LOCATE 29, 1:   PRINT " " + STRING$(74, "") + " ";
  LOCATE 30, 1:   PRINT "" + STRING$(74, "") + "ͼ";

  LOCATE 8, 1
  PRINT "   COLLAPSE ver. 1:                                   ";
  PRINT "     Designed By:    COPIED Extensively From Collapse ";
  PRINT "     Created By:     Colin Morgan                     ";
  PRINT "     Programmed By:  Colin Morgan                     ";
  PRINT "     Graphics By:    Colin Morgan                     ";
  PRINT "     Tested By:      Colin Morgan                     ";
  PRINT "                                                      ";
  PRINT "   Collapse:                                          ";
  PRINT "     Designed By:    Unknown                          ";
  PRINT "     Created By:     Unknown                          ";
  PRINT "     Programmed By:  Unknown                          ";
  PRINT "     Graphics By:    Unknown                          ";
  PRINT "     Tested By:      Unknown                          ";
END SUB

SUB DrawBackground (Num, x1, y1, x2, y2)
  IF Num = 1 THEN 'Chain Mail
    c1 = 0: c2 = 7
    FOR y = y1 TO y2 STEP 2
      FOR x = x1 TO x2 STEP 2
        PSET (x, y), c1
        PSET (x + 1, y), c2
      NEXT x
      SWAP c1, c2
    NEXT y
    c1 = 8: c2 = 15
    FOR y = y1 + 1 TO y2 STEP 2
      FOR x = x1 TO x2 STEP 2
        PSET (x, y), c1
        PSET (x + 1, y), c2
      NEXT x
      SWAP c1, c2
    NEXT y


  ELSEIF Num = 2 THEN 'Pitted PSET
    LINE (x1, y1)-(x2, y2), 7, BF
    area& = (((x2 - x1) / 100) * ((y2 - y1) / 100))
    FOR i& = 1 TO (area& * 500)
      x = FIX(RND * (x2 - x1) + x1)
      y = FIX(RND * (y2 - y1) + y1)
      IF POINT(x, y) = 7 THEN
        PSET (x, y), 8
      END IF
      IF POINT(x + 1, y + 1) = 7 THEN
        PSET (x + 1, y + 1), 15
      END IF
    NEXT i&


  ELSEIF Num = 3 OR Num = 4 THEN 'Circle Chain Mail
    DIM CArray(125) AS POINTER

    'Red background vertical grid (lines left and right).
    FOR i = y1 + 7 TO y2 STEP 8
      LINE (x1, i)-(x2, i), 4
    NEXT i

    'Red background horizontal grid (lines up and down).
    FOR i = x1 + 7 TO x2 STEP 8
      LINE (i, y1)-(i, y2), 4
    NEXT i

    IF Num = 3 THEN
      'Blue Circles.
      DrawCircle CArray(), x1, y1, 7, 0, 360
      FOR y = y1 + 8 TO y2 + 8 STEP 16
        FOR x = x1 + 7 TO x2 STEP 16
          FOR i = 2 TO CArray(1).x
            PSET (CArray(i).x + x, CArray(i).y + y - 1), 1
          NEXT i
        NEXT x
      NEXT y
    END IF

    'Green Circles.
    DrawCircle CArray(), x1, y1, 7, 0, 360
    FOR y = y1 - 1 TO y2 - 7 STEP 16
      FOR x = x1 - 9 TO x2 - 7 STEP 16
        FOR i = 2 TO CArray(1).x
          PSET (CArray(i).x + 7 + x + 1, CArray(i).y + y), 2
        NEXT i
      NEXT x
    NEXT y

    IF Num = 4 THEN
      'Blue Circles.
      DrawCircle CArray(), x1, y1, 7, 0, 360
      FOR y = y1 + 8 TO y2 + 8 STEP 16
        FOR x = x1 + 7 TO x2 STEP 16
          FOR i = 2 TO CArray(1).x
            PSET (CArray(i).x + x, CArray(i).y + y - 1), 1
          NEXT i
        NEXT x
      NEXT y
    END IF


  ELSEIF Num = 5 THEN 'Weave
    DIM CArray(125) AS POINTER
    DrawCircle CArray(), x1, y1, 7, 0, 360
    FOR y = y1 + 8 TO y2 STEP 12
      FOR x = x1 + 8 TO x2 - 8 STEP 12
        FOR i = 2 TO CArray(1).x
          PSET (CArray(i).x + x, CArray(i).y + y), 1
        NEXT i
      NEXT x
    NEXT y


  ELSEIF Num = 6 THEN 'Double Weave
    DIM CArray(125) AS POINTER
    DrawCircle CArray(), x1, y1, 7, 0, 360
    FOR y = y1 + 8 TO y2 STEP 12
      FOR x = x1 + 8 TO x2 - 8 STEP 12
        FOR i = 2 TO CArray(1).x
          PSET (CArray(i).x + x - 1, CArray(i).y + y - 1), 1
        NEXT i
        FOR i = 2 TO CArray(1).x
          PSET (CArray(i).x + x + 5, CArray(i).y + y + 5), 2
        NEXT i
      NEXT x
    NEXT y


  ELSEIF Num = 7 THEN 'Random Pixels
    FOR y = y1 TO y2
      FOR x = x1 TO x2
        PSET (x, y), INT(RND * 256)
      NEXT x
    NEXT y


  ELSEIF Num = 8 THEN 'Random Lines
    direc = INT(RND * 2)
    IF direc = 0 THEN
      FOR y = y1 TO y2
        LINE (x1, y)-(x2, y), INT(RND * 256)
      NEXT y
    ELSEIF direc = 1 THEN
      FOR x = x1 TO x2
        LINE (x, y1)-(x, y2), INT(RND * 256)
      NEXT x
    END IF


  END IF
END SUB

SUB DrawBox (y, x, c)
  'Draws a 10x10 box of the specified color at the specified location.

  'Calculate the screen coordinates from the grid coordinates.
  xpos = (x + xoff) * 10 - 10
  ypos = (y + yoff) * 10 - 10

  'Draw the colored box, and add a black border to it.
  PUTPIC ypos, xpos, c
  IF y = 18 AND x <> 1 AND x <> 14 THEN
    LINE (xpos, ypos)-(xpos + 9, ypos + 9), 250, B
  END IF

END SUB

SUB DrawCircle (Array() AS POINTER, y, x, radius, DegStart, DegEnd)
' THIS SUB WILL DRAW PART OF A CIRCLE IN POLAR COORDINATES.
  IF DegStart > DegEnd THEN
    DegStart = DegStart - 360
  END IF
  count = 1
  FOR t# = (DegStart * (radius / 45)) TO (DegEnd * (radius / 45))
    count = count + 1

    'T# is the angle measured in degrees
    RD# = 3.141592653589# * t# / (radius * 8)

    'RD# is the angle measured in radians
    r# = (radius * 2) * SIN(RD#)

    'Now convert to rectangular coordinates.
    x2 = r# * COS(RD#)
    y2 = r# * SIN(RD#) - radius

    'Set the point.
    Array(count).x = (x + x2)
    Array(count).y = (y + y2)
  NEXT t#
  Array(1).x = (count - 1)
END SUB

SUB EndMessage
  IF (TIMER - msgtm > msgtmlen AND msgtmlen > 0) OR msgtmlen = -1 THEN
    'Erase the message.
    LINE (0, 0)-(89, 189), 0, BF
    'Draw the background over the message.
    DrawBackground Bckgrnd, 0, 0, 89, 189
    RefreshBoard
    msgtmlen = 0
  END IF
END SUB

FUNCTION GetSpeed&
'-------------------------------------------------'
'- This function returns the number of times the -'
'-  computer can increment a long int in a FOR   -'
'-  loop per second.                             -'
'-------------------------------------------------'
  start! = TIMER
  FOR i& = 1 TO 1500
    FOR i2& = 1 TO 1500
    NEXT i2&
  NEXT i&
  EndTime! = TIMER
  TimeTaken! = (EndTime! - start!)

  GetSpeed& = ((1500& * 1500&) / TimeTaken!)
END FUNCTION

SUB HighScores
  CLS
  PRINT "HIGH SCORES"
  PRINT ""
  PRINT "Player:            Level:     Score:"
  ofile = FREEFILE
  OPEN "Collapse\SCORES.DAT" FOR INPUT AS #ofile
    COLOR 2
    FOR i = 4 TO 13
      INPUT #ofile, a$:  LOCATE i, 1:   PRINT LEFT$(a$, 18)
      INPUT #ofile, b:  a$ = LTRIM$(STR$(b))
        LOCATE i, 26 - LEN(a$): PRINT a$
      INPUT #ofile, b&:  a$ = LTRIM$(STR$(b&))
        LOCATE i, 37 - LEN(a$): PRINT a$
      COLOR 15
    NEXT i
  CLOSE #ofile

  LOCATE 25, 1:  PRINT "Press Return or Escape to continue";

  a$ = ""
  WHILE a$ <> CHR$(13) AND a$ <> CHR$(27)
    a$ = INKEY$
  WEND
END SUB

SUB Instructions
  '38 + 38 + 23 + 23 Positions Possible (122 : 0-121)
  DIM StarPos(24, 3) AS INTEGER
    FOR i = 1 TO UBOUND(StarPos, 1)
      StarPos(i, 1) = INT(RND * 117)
      StarPos(i, 2) = INT(RND * 14) + 1
      StarPos(i, 3) = INT(RND * 2)
      IF StarPos(i, 3) = 0 THEN :  StarPos(i, 3) = -1
    NEXT i

   KLeft$ = CHR$(0) + "K"
  KRight$ = CHR$(0) + "M"
    KEsc$ = CHR$(27)

  SetColors

  LOCATE 1, 1:    PRINT "" + STRING$(34, "") + "ͻ";
  LOCATE 2, 1:    PRINT "  " + STRING$(34, " ") + "  ";
  LOCATE 3, 1:    PRINT " " + STRING$(34, "") + " ";
  FOR i = 4 TO 22
    LOCATE i, 1:  PRINT " " + STRING$(34, " ") + " ";
  NEXT i
  LOCATE 23, 1:   PRINT " " + STRING$(34, "") + " ";
  LOCATE 24, 1:   PRINT "  " + STRING$(34, " ") + "  ";
  LOCATE 25, 1:   PRINT "" + STRING$(34, "") + "ͼ";

InstructionsScreen1:
  LINE (24, 24)-(320 - 24, 200 - 24), 0, BF
  LOCATE 5, 5:   PRINT "How To Play:                    "
  LOCATE 6, 5:   PRINT "->Destroy blocks by clicking    "
  LOCATE 7, 5:   PRINT "  groups of three or more blocks"
  LOCATE 8, 5:   PRINT "  of the same color.            "
    PUTPIC 72, 52, 2:   PUTPIC 82, 52, 1:   PUTPIC 92, 52, 1
                                            PUTPIC 92, 62, 1
    LOCATE 13, 10:  PRINT ",";
                        PUTPIC 82, 82, 3:   PUTPIC 92, 82, 2
    PUTPIC 72, 92, 3:   PUTPIC 82, 92, 2:   PUTPIC 92, 92, 2
                        PUTPIC 82, 102, 2:  PUTPIC 92, 102, 2
    LOCATE 13, 15:  PRINT ",";
                        PUTPIC 82, 122, 3:  PUTPIC 92, 122, 3
    PUTPIC 72, 132, 3:  PUTPIC 82, 132, 1:  PUTPIC 92, 132, 3
    PUTPIC 72, 142, 3:  PUTPIC 82, 142, 3:  PUTPIC 92, 142, 3
                        PUTPIC 82, 152, 3:  PUTPIC 92, 152, 3
    PUTPIC 72, 162, 2:  PUTPIC 82, 162, 3:  PUTPIC 92, 162, 3
    PUTPIC 72, 172, 2:  PUTPIC 82, 172, 3:  PUTPIC 92, 172, 1
                        PUTPIC 82, 182, 3:  PUTPIC 92, 182, 3

  LOCATE 20, 5:  PRINT
  LOCATE 21, 5:  PRINT "Next:       Right Arrow"
  LOCATE 22, 5:  PRINT "Main Menu:  Escape     "

  a$ = ""
  DO
    a$ = INKEY$
    SELECT CASE a$
      CASE KEsc$:    EXIT SUB
      CASE KRight$:  GOTO InstructionsScreen2
    END SELECT
    FOR i = 1 TO UBOUND(StarPos, 1)
      GOSUB SetPos:  LOCATE stary, starx:  PRINT " ";
      StarPos(i, 1) = StarPos(i, 1) + StarPos(i, 3)
      IF StarPos(i, 1) = 121 THEN :  StarPos(i, 1) = 0
      IF StarPos(i, 1) = -1 THEN :   StarPos(i, 1) = 121
      GOSUB SetPos:  COLOR StarPos(i, 2)
                     LOCATE stary, starx:  PRINT "*";
    NEXT i
    COLOR 15
    Suspend 15, CompSpeed&
  LOOP


InstructionsScreen2:
  LINE (24, 24)-(320 - 24, 200 - 24), 0, BF
  LOCATE 5, 5:   PRINT "Winning/Losing:                 "
  LOCATE 6, 5:   PRINT "->There is no end to this game, "
  LOCATE 7, 5:   PRINT "  so you win by getting the     "
  LOCATE 8, 5:   PRINT "  highest score.                "
  LOCATE 9, 5:   PRINT
  LOCATE 10, 5:  PRINT "->You lose the game when the    "
  LOCATE 11, 5:  PRINT "  blocks pass the top line.     "
    'Left Exclamation Mark
    FOR i = 0 TO 4
      IF i = 3 THEN :  i = 4
      PUTPIC 96 + (10 * i), 82, 15
    NEXT i
    'Left Edge
    FOR i = 0 TO 4
      PUTPIC 96 + (10 * i), 102, 4
    NEXT i
    'Top Edge
    FOR i = 0 TO 11
      PUTPIC 96, 112 + (10 * i), 4
    NEXT i
    'Right Edge
    FOR i = 0 TO 4
      PUTPIC 96 + (10 * i), 232, 4
    NEXT i
    'Right Exclamation Mark
    FOR i = 0 TO 4
      IF i = 3 THEN :  i = 4
      PUTPIC 96 + (10 * i), 252, 15
    NEXT i
    'Middle Top-Row
    FOR i = 0 TO 11
      IF INT(RND * 2) = 1 THEN
        PUTPIC 96, 112 + (10 * i), INT(RND * 3) + 1
      END IF
    NEXT i
    'Middle
    FOR i = 0 TO 3
      FOR i2 = 0 TO 11
        PUTPIC 106 + (10 * i), 112 + (10 * i2), INT(RND * 3) + 1
      NEXT i2
    NEXT i

  LOCATE 20, 5:  PRINT "Next:       Right Arrow"
  LOCATE 21, 5:  PRINT "Previous:   Left Arrow "
  LOCATE 22, 5:  PRINT "Main Menu:  Escape     "

  a$ = ""
  DO
    a$ = INKEY$
    SELECT CASE a$
      CASE KEsc$:    EXIT SUB
      CASE KRight$:  GOTO InstructionsScreen3
      CASE KLeft$:   GOTO InstructionsScreen1
    END SELECT
    FOR i = 1 TO UBOUND(StarPos, 1)
      GOSUB SetPos:  LOCATE stary, starx:  PRINT " ";
      StarPos(i, 1) = StarPos(i, 1) + StarPos(i, 3)
      IF StarPos(i, 1) = 121 THEN :  StarPos(i, 1) = 0
      IF StarPos(i, 1) = -1 THEN :   StarPos(i, 1) = 121
      GOSUB SetPos:  COLOR StarPos(i, 2)
                     LOCATE stary, starx:  PRINT "*";
    NEXT i
    COLOR 15
    Suspend 15, CompSpeed&
  LOOP


InstructionsScreen3:
  LINE (24, 24)-(320 - 24, 200 - 24), 0, BF
  LOCATE 5, 5:   PRINT "Pausing:                        "
  LOCATE 6, 5:   PRINT "->To pause press 'p', then any  "
  LOCATE 7, 5:   PRINT "  key to continue.              "
  LOCATE 8, 5:   PRINT
  LOCATE 9, 5:   PRINT "Quitting:                       "
  LOCATE 10, 5:  PRINT "->To quit during play, press    "
  LOCATE 11, 5:  PRINT "  'Esc'.  When you quit, your   "
  LOCATE 12, 5:  PRINT "  game is automatically saved.  "
  LOCATE 13, 5:  PRINT
  LOCATE 14, 5:  PRINT "Continuing a Game:              "
  LOCATE 15, 5:  PRINT "->Only one game is saved at a   "
  LOCATE 16, 5:  PRINT "  time so this automatically    "
  LOCATE 17, 5:  PRINT "  loads the last game.          "
  LOCATE 18, 5:  PRINT
  LOCATE 19, 5:  PRINT "       :-> !HAVE FUN! <-:       "
  LOCATE 20, 5:  PRINT
  LOCATE 21, 5:  PRINT "Previous:   Left Arrow "
  LOCATE 22, 5:  PRINT "Main Menu:  Escape     "

  a$ = ""
  DO
    a$ = INKEY$
    SELECT CASE a$
      CASE KEsc$:    EXIT SUB
      CASE KLeft$:   GOTO InstructionsScreen2
    END SELECT
    FOR i = 1 TO UBOUND(StarPos, 1)
      GOSUB SetPos:  LOCATE stary, starx:  PRINT " ";
      StarPos(i, 1) = StarPos(i, 1) + StarPos(i, 3)
      IF StarPos(i, 1) = 121 THEN :  StarPos(i, 1) = 0
      IF StarPos(i, 1) = -1 THEN :   StarPos(i, 1) = 121
      GOSUB SetPos:  COLOR StarPos(i, 2)
                     LOCATE stary, starx:  PRINT "*";
    NEXT i
    Suspend 15, CompSpeed&
    COLOR 15
  LOOP



  EXIT SUB
SetPos:
  SELECT CASE StarPos(i, 1)
    CASE 0 TO 37
      starx = StarPos(i, 1) - 0 + 2
      stary = 2
    CASE 38 TO 60
      starx = 39
      stary = StarPos(i, 1) - 38 + 2
    CASE 61 TO 98
      starx = 40 - (StarPos(i, 1) - 61 + 1)
      stary = 24
    CASE 99 TO 121
      starx = 2
      stary = 25 - (StarPos(i, 1) - 99 + 1)
  END SELECT
  RETURN
END SUB

SUB LoadGame
  lfile = FREEFILE
  OPEN "Collapse\SAVED.DAT" FOR INPUT AS #lfile
    'Save Current Info
    INPUT #lfile, Stat.Level
    INPUT #lfile, Stat.Lines
    INPUT #lfile, Stat.Points&
    'Save Current Board
    FOR y = 1 TO 17
      LINE INPUT #lfile, a$
      FOR x = 1 TO 12
        Board(y, x) = ASC(MID$(a$, x, 1)) - 1
      NEXT x
    NEXT y
  CLOSE #lfile
  'Find out which block the game was on in row 17.
  FOR x = 1 TO 12
    IF ASC(MID$(a$, x, 1)) = 1 THEN
      xBlock = x - 1: EXIT FOR
    END IF
  NEXT x
END SUB

SUB Lose
  LOCATE 20, 10: PRINT "GAME OVER!"

  zzMouse MOUSEHIDE, 0, 0

  'High Scores
  'Set high score if applicable.
  DIM Names(10)  AS STRING
  DIM Scores(10) AS LONG
  DIM Levels(10)  AS INTEGER

  ofile = FREEFILE
  OPEN "Collapse\SCORES.DAT" FOR INPUT AS #ofile
    'Read in each one.
    FOR i = 1 TO 10
      LINE INPUT #ofile, Names$(i)
      LINE INPUT #ofile, a$:  Levels(i) = VAL(a$)
      LINE INPUT #ofile, a$:  Scores&(i) = VAL(a$)
    NEXT i
  CLOSE #ofile

  'Sort high scores.
  IF Scores&(10) < Stat.Points& THEN
      LOCATE 6, 3:   PRINT "ͻ"
      LOCATE 7, 3:   PRINT " ͻ "
      LOCATE 8, 3:   PRINT "  Collapse Score:               "
      LOCATE 9, 3:   PRINT "                                "
      LOCATE 10, 3:  PRINT "    Level Reached:              "
      LOCATE 11, 3:  PRINT "                                "
      LOCATE 12, 3:  PRINT "    Score:                      "
      LOCATE 13, 3:  PRINT "                                "
      LOCATE 14, 3:  PRINT "    Name:                       "
      LOCATE 15, 3:  PRINT "                                "
      LOCATE 16, 3:  PRINT " ͼ "
      LOCATE 17, 3:  PRINT "ͼ"
      LOCATE 10, 25:  PRINT LTRIM$(STR$(Stat.Level))
      LOCATE 12, 17:  PRINT LTRIM$(STR$(Stat.Points&))
      LOCATE 15, 14:  PRINT "High Score!"
      LOCATE 14, 16:  INPUT "", UserName$
      Name$ = LEFT$(UserName$, 18)
    Names$(10) = Name$
    Levels(10) = Stat.Level
    Scores&(10) = Stat.Points&
  END IF
  FOR i = 9 TO 1 STEP -1
    IF Scores&(i) < Scores&(i + 1) THEN
      SWAP Names$(i), Names$(i + 1)
      SWAP Levels(i), Levels(i + 1)
      SWAP Scores&(i), Scores&(i + 1)
    END IF
  NEXT i

  'Write options and high scores into the file.
  ofile = FREEFILE
  OPEN "Collapse\SCORES.DAT" FOR OUTPUT AS #ofile
    'Scores
    FOR i = 1 TO 10
      PRINT #ofile, Names$(i)
      PRINT #ofile, Levels(i)
      PRINT #ofile, Scores&(i)
    NEXT i
  CLOSE #ofile


  'Display High Scores
  HighScores

  SYSTEM
END SUB

SUB Main
'''''''''''''''''''''''''''''''''''''''''''''''''''
'-------------------------------------------------'
'- Main Loop/Routine                             -'
'-------------------------------------------------'
'''''''''''''''''''''''''''''''''''''''''''''''''''
  'True or false, is there a game that can be continued or not.
  DIM SavedGame AS INTEGER

  'Menu Selector
  DIM MSel AS INTEGER

     KUp$ = CHR$(0) + "H"
   KDown$ = CHR$(0) + "P"
  KEnter$ = CHR$(13)

  'MAIN MENU BEGIN'
MainMenuBegin:
  rs = FALSE  '(rs = refresh screen)
  Stat.Level = 0
  Stat.Lines = -1
  Stat.Points& = -100
  SCREEN 12
  COLOR 15
  'Determine if there is a previously saved game.
  SavedGame = TRUE
  OPEN "SAVED.DAT" FOR INPUT AS #1
    IF EOF(1) THEN
      SavedGame = FALSE
    END IF
  CLOSE #1

  Credits
  'Display the Menu Items
  LOCATE 11, 39:   PRINT "" + STRING$(30, "") + "ͻ";
  LOCATE 12, 39:   PRINT " " + STRING$(30, "") + " ";
  FOR i = 13 TO 24
    LOCATE i, 39:  PRINT " " + STRING$(30, " ") + " ";
  NEXT i
  LOCATE 25, 39:   PRINT " " + STRING$(30, "") + " ";
  LOCATE 26, 39:   PRINT "" + STRING$(30, "") + "ͼ";
  MSel = 2
  IF SavedGame = TRUE THEN
    LOCATE 14, 51:   PRINT " ontinue Game"
      COLOR 2:  LOCATE 14, 51:  PRINT "C":  COLOR 15
    MSel = 1
  END IF
  LOCATE 15 - SavedGame, 53:  PRINT " ew Game"
    COLOR 2:  LOCATE 15 - SavedGame, 53:  PRINT "N":  COLOR 15
  LOCATE 17 - SavedGame, 52:  PRINT " igh Scores"
    COLOR 2:  LOCATE 17 - SavedGame, 52:  PRINT "H":  COLOR 15
  LOCATE 19 - SavedGame, 51:  PRINT " nstructions"
    COLOR 2:  LOCATE 19 - SavedGame, 51:  PRINT "I":  COLOR 15
  LOCATE 21 - SavedGame, 55:  PRINT " uit"
    COLOR 2:  LOCATE 21 - SavedGame, 55:  PRINT "Q":  COLOR 15

  xpos = 0
  forward = TRUE
  DO
    SELECT CASE MSel
      CASE 1
        LOCATE 14, 48:  PRINT "->"
      CASE 2
        LOCATE 15 - SavedGame, 50:  PRINT "->"
      CASE 3
        LOCATE 17 - SavedGame, 49:  PRINT "->"
      CASE 4
        LOCATE 19 - SavedGame, 48:  PRINT "->"
      CASE 5
        LOCATE 21 - SavedGame, 52:  PRINT "->"
    END SELECT

    a$ = ""
    WHILE a$ = ""
      a$ = INKEY$
'      'Draw the COLLAPSE Pic on the screen.
'      pfile = FREEFILE
'      OPEN "Collapse\COLLAPSE.MP" FOR INPUT AS #pfile
'        FOR y = 0 TO 15
'          LINE INPUT #pfile, b$
'           FOR x = (16 * 8) + 9 - 1 TO 0 STEP -1
'            x2 = (x * 2):  y2 = (y * 2)
'            IF VAL(MID$(b$, x + 1, 1)) = 1 THEN
'              LINE (40 + x2, 48 + y2)-(43 + x2 + 1, 48 + y2 + 1), INT(RND * 14) + 1, BF
'            END IF
'          NEXT x
'        NEXT y
'      CLOSE #pfile
      'Draw the COLLAPSE Pic on the screen.
      pfile = FREEFILE
      OPEN "COLLAPSE.MP" FOR INPUT AS #pfile
        FOR y = 0 TO 15
          LINE INPUT #pfile, b$
           FOR x = 0 TO (16 * 8) + 9 - 1
            x2 = (x * 2) + xpos:  y2 = (y * 2)
            IF VAL(MID$(b$, x + 1, 1)) = 1 THEN
              LINE (40 + x2, 48 + y2)-(40 + x2 + 1, 48 + y2 + 1), INT(RND * 14) + 1, BF
            ELSE
              LINE (40 + x2, 48 + y2)-(40 + x2 + 1, 48 + y2 + 1), 0, BF
            END IF
          NEXT x
        NEXT y
      CLOSE #pfile
      IF forward = TRUE THEN
        xpos = xpos + 1
        IF xpos = 250 THEN :  forward = FALSE
      ELSEIF forward = FALSE THEN
        xpos = xpos - 1
        IF xpos = 0 THEN :    forward = TRUE
      END IF
    WEND

    LOCATE 14, 48:  PRINT "  "
    LOCATE 15 - SavedGame, 50:  PRINT "  "
    LOCATE 17 - SavedGame, 49:  PRINT "  "
    LOCATE 19 - SavedGame, 48:  PRINT "  "
    LOCATE 21 - SavedGame, 52:  PRINT "  "

    SELECT CASE UCASE$(a$)
      CASE KUp$
        MSel = MSel - 1
        IF SavedGame = TRUE THEN
          IF MSel = 0 THEN :  MSel = 5
        ELSE
          IF MSel = 1 THEN :  MSel = 5
        END IF
      CASE KDown$
        MSel = MSel + 1
        IF SavedGame = TRUE THEN
          IF MSel = 6 THEN :  MSel = 1
        ELSE
          IF MSel = 6 THEN :  MSel = 2
        END IF
      CASE KEnter$
        SELECT CASE MSel
          CASE 1:  LoadGame:  rs = TRUE:  EXIT DO  '(rs = refresh screen)
          CASE 2:  EXIT DO
          CASE 3:  SCREEN 13:  HighScores:    GOTO MainMenuBegin
          CASE 4:  SCREEN 13:  Instructions:  GOTO MainMenuBegin
          CASE 5:  SYSTEM
        END SELECT
      CASE "I"
        SCREEN 13:  Instructions: GOTO MainMenuBegin
      CASE "C"
        IF SavedGame = TRUE THEN
          LoadGame
          rs = TRUE  '(rs = refresh screen)
          EXIT DO
        END IF
      CASE "N"
        EXIT DO
      CASE "H"
        SCREEN 13:  HighScores:    GOTO MainMenuBegin
      CASE "Q"
        SYSTEM
      CASE CHR$(27)
        SYSTEM
    END SELECT

  LOOP

  'MAIN MENU END'

  SetColors

  'Whether they continued their game or started a new one, erase the file.
  OPEN "SAVED.DAT" FOR OUTPUT AS #1
  CLOSE #1

  'Set the screen mode.
  SCREEN 13

  'Set the mouse dimensions.
  zzMouse MOUSEZONEX, ((xoff + 1) * 10), ((xoff + 1) * 22) - 1
  zzMouse MOUSEZONEY, 10, 179
  'Center Mouse
  zzMouse MOUSESPOS, 170, 85
  zzMouse MOUSESHOW, 0, 0

  NextLevel

  IF rs = TRUE THEN
    RefreshScreen
  END IF

  TIMER ON
'Main Loop
  start! = TIMER
  begin = 0
  DO
    IF begin = 0 THEN
      DO
        a$ = INKEY$
        IF LCASE$(a$) = "p" THEN
          zzMouse MOUSEHIDE, 0, 0
          LINE (((xoff + 1) * 10), 10)-(((xoff + 1) * 22) - 1, 179), 0, BF
          a$ = ""
          WHILE INKEY$ = "": WEND
          RefreshBoard
          zzMouse MOUSESHOW, 0, 0
        END IF
        IF a$ = CHR$(27) THEN
          zzMouse MOUSEHIDE, 0, 0
          LINE (((xoff + 1) * 10), 10)-(((xoff + 1) * 22) - 1, 179), 0, BF
          LOCATE 4, 14:   PRINT "/-----------\"
          LOCATE 5, 14:   PRINT "| Press Esc |"
          LOCATE 6, 14:   PRINT "| again to  |"
          LOCATE 7, 14:   PRINT "| exit, or  |"
          LOCATE 8, 14:   PRINT "| any other |"
          LOCATE 9, 14:   PRINT "| key to    |"
          LOCATE 10, 14:  PRINT "| continue. |"
          LOCATE 11, 14:  PRINT "\-----------/"

          a$ = ""
          WHILE a$ = ""
            a$ = INKEY$
          WEND
          IF a$ = CHR$(27) THEN
            IF add > 0 THEN
              Stat.Points& = Stat.Points& + add
              add = 0
            END IF
            SaveGame
            GOTO MainMenuBegin
          END IF
          RefreshBoard
          zzMouse MOUSESHOW, 0, 0
        END IF

        'Get Current Mouse Status
        zzMouse MOUSEGBUT, lb, rb
        zzMouse MOUSEGPOS, PositionX, PositionY

        'If the left mouse button is down.
        IF lb = -1 THEN
          DO UNTIL lb = 0
            'Get Current Mouse Status
            zzMouse MOUSEGBUT, lb, rb
            zzMouse MOUSEGPOS, PositionX, PositionY

          LOOP
          EXIT DO
        END IF
      LOOP
      zzMouse MOUSEGBUT, lb, rb
      zzMouse MOUSEGPOS, PositionX, PositionY
      xpos = INT(PositionX / 10)      'Divide x and y coords
      ypos = INT(PositionY / 10)      'by the size of squares.
      xpos = xpos - 9                 'Account for X offset.

      IF ypos = 17 THEN
        DO
          NewBlock
        LOOP UNTIL xBlock <= 1
        add = add + (5 * Stat.Level)
      ELSEIF Board(ypos, xpos) > 0 THEN
        CollapseSquare ypos, xpos
      END IF
      begin = 1

    ELSEIF begin = 1 THEN
      EndMessage

        a$ = INKEY$
        IF LCASE$(a$) = "p" THEN
          zzMouse MOUSEHIDE, 0, 0
          LINE (((xoff + 1) * 10), 10)-(((xoff + 1) * 22) - 1, 179), 0, BF
          a$ = ""
          WHILE INKEY$ = "": WEND
          RefreshBoard
          zzMouse MOUSESHOW, 0, 0
        END IF
        IF a$ = CHR$(27) THEN
          zzMouse MOUSEHIDE, 0, 0
          LINE (((xoff + 1) * 10), 10)-(((xoff + 1) * 22) - 1, 179), 0, BF
          LOCATE 4, 14:   PRINT "/-----------\"
          LOCATE 5, 14:   PRINT "| Press Esc |"
          LOCATE 6, 14:   PRINT "| again to  |"
          LOCATE 7, 14:   PRINT "| exit, or  |"
          LOCATE 8, 14:   PRINT "| any other |"
          LOCATE 9, 14:   PRINT "| key to    |"
          LOCATE 10, 14:  PRINT "| continue. |"
          LOCATE 11, 14:  PRINT "\-----------/"

          a$ = ""
          WHILE a$ = ""
            a$ = INKEY$
          WEND
          IF a$ = CHR$(27) THEN
            IF add > 0 THEN
              Stat.Points& = Stat.Points& + add
              add = 0
            END IF
            SaveGame
            GOTO MainMenuBegin
          END IF
          RefreshBoard
          zzMouse MOUSESHOW, 0, 0
        END IF

      'Get Current Mouse Status
      zzMouse MOUSEGBUT, lb, rb
      zzMouse MOUSEGPOS, PositionX, PositionY

      'If the left mouse button is down.
      IF lb = -1 THEN
        DO UNTIL lb = 0
          'Get Current Mouse Status
          zzMouse MOUSEGBUT, lb, rb
          zzMouse MOUSEGPOS, PositionX, PositionY

          IF (TIMER - start!) > (.5 / Stat.Level) THEN
            NewBlock
            start! = TIMER
          END IF
        LOOP
        zzMouse MOUSEGBUT, lb, rb
        zzMouse MOUSEGPOS, PositionX, PositionY
        xpos = INT(PositionX / 10)      'Divide x and y coords
        ypos = INT(PositionY / 10)      'by the size of squares.
        xpos = xpos - 9                 'Account for X offset.

        IF ypos = 17 THEN
          DO
            NewBlock
          LOOP UNTIL xBlock <= 1
          add = add + (5 * Stat.Level)
        ELSEIF Board(ypos, xpos) > 0 THEN
          CollapseSquare ypos, xpos
        END IF
      END IF

      IF add >= 100 THEN
        Stat.Points& = Stat.Points& + 100
        add = add - 100
        LOCATE 25, 40 - LEN(LTRIM$(STR$(Stat.Points&)))
                        PRINT LTRIM$(STR$(Stat.Points&));
      ELSEIF add >= 10 AND add < 100 THEN
        Stat.Points& = Stat.Points& + 10
        add = add - 10
        LOCATE 25, 40 - LEN(LTRIM$(STR$(Stat.Points&)))
                        PRINT LTRIM$(STR$(Stat.Points&));
      ELSEIF add >= 1 AND add < 10 THEN
        Stat.Points& = Stat.Points& + 1
        add = add - 1
        LOCATE 25, 40 - LEN(LTRIM$(STR$(Stat.Points&)))
                        PRINT LTRIM$(STR$(Stat.Points&));
      END IF

      IF begin = 1 AND Stat.Level < 13 AND (TIMER - start!) > (.5 / Stat.Level) THEN
        NewBlock
        start! = TIMER
      ELSEIF begin = 1 AND Stat.Level > 12 THEN
        IF (TIMER - start!) > (.5 / (Stat.Level - 5)) THEN
          NewBlock
          NewBlock
          start! = TIMER
        END IF
      END IF
    END IF
  LOOP

  GOTO MainMenuBegin
END SUB

SUB NewBlock
  'Puts a new block in line to be placed on the board.

  'Create a var to remember what color the last block was.
  STATIC LastBlock AS INTEGER

  'If needed, add this row and begin a new one.
  IF xBlock = 12 THEN
    xBlock = 0
    IF Stat.Lines > 0 THEN
      ShiftUp
    END IF
    Stat.Lines = Stat.Lines - 1
    'Test if we want to increase level.
    NextLevel
    EXIT SUB
  END IF

  'Increment the block number.
  xBlock = xBlock + 1

  'Get a random color, and set the block into the array.
  '  (How random it is is according to the level you are on.)
  DIM numBlocks  AS INTEGER
  DIM startBlock AS INTEGER
  '(notsame - 1 means different color from last time.)
  notsame = 0
  numBlocks = 3
  startBlock = 0
      IF INT(RND * 200 + 1) < Stat.Level * 2 THEN
        notsame = 1
      END IF
      IF notsame = 1 THEN
        numBlocks = 2
        startBlock = LastBlock
      END IF

  randc = INT(RND * numBlocks + startBlock + 1)
  IF randc = 4 THEN randc = 1
  IF randc = 5 THEN randc = 2
  IF Stat.Lines = 0 THEN randc = 4
  SELECT CASE randc
    CASE 1: Board(17, xBlock) = 1 'Red
    CASE 2: Board(17, xBlock) = 2 'Green
    CASE 3: Board(17, xBlock) = 3 'Blue
    CASE 4: Board(17, xBlock) = 4 'Grey (Last line in the level.)
  END SELECT
  LastBlock = randc
 
  'Hide Mouse
  zzMouse MOUSEHIDE, 0, 0

  'Draw the box.
  DrawBox 17 + yoff2, xBlock + xoff2, Board(17, xBlock)

  'Show Mouse
  zzMouse MOUSESHOW, 0, 0

END SUB

SUB NextLevel

  IF Stat.Lines < 0 THEN
    Num = ((Stat.Level * 4) + 24)
    Num = Num + 4

    Stat.Level = Stat.Level + 1
    Stat.Lines = Num
    Stat.Points& = Stat.Points& + 100

    IF Stat.Level > 1 THEN
      zzMouse MOUSEHIDE, 0, 0
      'Was the Whole Line clear?  If so, give them extra points.
      wline = 0
      'Erase the board.
      FOR y = 1 TO 16
        FOR x = 1 TO 12
          'Add points for blank blocks.
          IF Board(y, x) = 0 THEN
            'Make it blow up.
            FOR i4 = 1 TO 5
              FOR i2 = 5 TO 1 STEP -1
                  desx = (x + xoff) * 10
                  desy = (y + yoff) * 10
                  LINE (desx + i2 - 1, desy + i2 - 1)-(desx + 10 - i2, desy + 10 - i2), 0, B
              NEXT i2
              FOR i2 = 5 TO 1 STEP -1
                  desx = (x + xoff) * 10
                  desy = (y + yoff) * 10
                  LINE (desx + i2 - 1, desy + i2 - 1)-(desx + 10 - i2, desy + 10 - i2), 15, B
              NEXT i2
            NEXT i4

            Stat.Points& = Stat.Points& + (5 * Stat.Level)
            LOCATE 25, 40 - LEN(LTRIM$(STR$(Stat.Points&)))
                            PRINT LTRIM$(STR$(Stat.Points&));

            Board(y, x) = 0
            Suspend 25, CompSpeed&
            FOR i2 = 5 TO 1 STEP -1
                  desx = (x + xoff) * 10
                  desy = (y + yoff) * 10
                  LINE (desx + i2 - 1, desy + i2 - 1)-(desx + 10 - i2, desy + 10 - i2), 0, B
            NEXT i2
          ELSE
            wline = 1
          END IF

        NEXT x

        'Give them an extra 50 points for each level if this line was clear.
        IF wline = 0 THEN
          Stat.Points& = Stat.Points& + (50 * Stat.Level)
          LOCATE 25, 40 - LEN(LTRIM$(STR$(Stat.Points&)))
                          PRINT LTRIM$(STR$(Stat.Points&));

          'Also, put a little green check on each side of the line.
          'Left
          LINE (1 + (xoff * 10), (y * 10) + 5)-(4 + (xoff * 10), (y * 10) + 7), 2
          LINE (4 + (xoff * 10), (y * 10) + 7)-(8 + (xoff * 10), (y * 10) + 1), 2
          'Right
          LINE (131 + (xoff * 10), (y * 10 + 10) - 5)-(134 + (xoff * 10), (y * 10 + 10) - 2), 2
          LINE (134 + (xoff * 10), (y * 10 + 10) - 2)-(138 + (xoff * 10), (y * 10 + 10) - 9), 2
          '(Line throught the middle.)
          LINE (15 + (xoff * 10), (y * 10) + 5)-(125 + (xoff * 10), (y * 10) + 5), 2


        'Otherwise, use red X's and red lines and give no points.
        ELSEIF wline = 1 THEN
          'Left
          LINE (1 + (xoff * 10), (y * 10) + 1)-(8 + (xoff * 10), (y * 10) + 8), 4
          LINE (1 + (xoff * 10), (y * 10) + 8)-(8 + (xoff * 10), (y * 10) + 1), 4
          'Right
          LINE (131 + (xoff * 10), (y * 10) + 1)-(138 + (xoff * 10), (y * 10) + 8), 4
          LINE (131 + (xoff * 10), (y * 10) + 8)-(138 + (xoff * 10), (y * 10) + 1), 4
          '(Line throught the middle.)
          LINE (15 + (xoff * 10), (y * 10) + 5)-(125 + (xoff * 10), (y * 10) + 5), 4
        END IF
      NEXT y

      'Display you win.
      LOCATE 6, 19:  PRINT "YOU"
      LOCATE 7, 19:  PRINT "WON!"
      LOCATE 10, 14: PRINT "Click or press"
      LOCATE 11, 14: PRINT "any key to"
      LOCATE 12, 14: PRINT "continue..."
      zzMouse MOUSESHOW, 0, 0
      DO WHILE INKEY$ = ""
          'Get Current Mouse Status
          zzMouse MOUSEGBUT, lb, rb
          zzMouse MOUSEGPOS, PositionX, PositionY

          'If the left mouse button is down.
          IF lb = -1 THEN
            DO UNTIL lb = 0
              'Get Current Mouse Status
              zzMouse MOUSEGBUT, lb, rb
              zzMouse MOUSEGPOS, PositionX, PositionY

            LOOP
            EXIT DO
          END IF
      LOOP

      'Erase the board.
      FOR y = 1 TO 17
        FOR x = 1 TO 12
          Board(y, x) = 0
        NEXT x
      NEXT y

    END IF
    RefreshScreen

    'Set the first several lines to full.
    i2 = 52
    FOR i = 1 TO i2
      NewBlock
    NEXT i
    begin = 0
  END IF

  ShowStats
END SUB

SUB PUTPIC (y, x, c)
  '-----------------------------------------------
  ' Puts a picture on the screen, disallowing transparency.
  '-----------------------------------------------
  '(c = 0) = Black
  '(c = 1) = Blue
  '(c = 2) = Red
  '(c = 3) = Green
  '(c = 4) = Grey

  cc = 256 - (c * 3) + 1

  IF c = 0 THEN
    LINE (x, y)-(x + 9, y + 9), 0, BF
    EXIT SUB
  END IF
  FOR i = 1 TO 10
    FOR i2 = 1 TO 10
      PSET ((i2 + x - 1), (i + y - 1)), cc - Pic(i2, i)
    NEXT i2
  NEXT i
END SUB

SUB RefreshBoard
  'Redraws all of the squares in the board.

  'Hide Mouse
  zzMouse MOUSEHIDE, 0, 0

  'Draw the border.
  FOR y = 1 TO 19
    DrawBox y, 1, 4
    DrawBox y, 14, 4
  NEXT y
  FOR x = 1 TO 14
    DrawBox 1, x, 4
    DrawBox 19, x, 4
  NEXT x

  'Draw the inside.
  FOR y = 1 TO 16
    FOR x = 1 TO 12
      DrawBox y + xoff2, x + xoff2, Board(y, x)
    NEXT x
  NEXT y

  FOR x = 1 TO 12
    DrawBox 17 + yoff2, x + xoff2, Board(17, x)
  NEXT x
 
  ShowStats

  'Show Mouse
  zzMouse MOUSESHOW, 0, 0
END SUB

SUB RefreshScreen
  'Redraws all of the stuff on the screen.

  'Hide Mouse
  zzMouse MOUSEHIDE, 0, 0

  CLS
  'Draw the background.
  Bckgrnd = INT(RND * 8) + 1
  DrawBackground Bckgrnd, 0, 0, 319, 199

  SetColors

  'Draw the board.
  RefreshBoard

  'Show Mouse
  zzMouse MOUSESHOW, 0, 0
END SUB

SUB SaveGame
  sfile = FREEFILE
  OPEN "Collapse\SAVED.DAT" FOR OUTPUT AS #sfile
    'Save Current Info
    PRINT #sfile, Stat.Level
    PRINT #sfile, Stat.Lines
    PRINT #sfile, Stat.Points&
    'Save Current Board
    a$ = ""
    FOR y = 1 TO 17
      FOR x = 1 TO 12
        a$ = a$ + CHR$(Board(y, x) + 1)
      NEXT x
      PRINT #sfile, a$
      a$ = ""
    NEXT y
  CLOSE #sfile
END SUB

SUB SetColors
'  hue = 0:  r = 0:   g = 0:   B = 0:   GOSUB OutValues  'Black
'  hue = 1:  r = 0:   g = 0:   B = 35:  GOSUB OutValues  'Blue
'  hue = 2:  r = 0:   g = 0:   B = 32:  GOSUB OutValues  '
'  hue = 3:  r = 0:   g = 0:   B = 29:  GOSUB OutValues  '
'  hue = 4:  r = 35:  g = 0:   B = 0:   GOSUB OutValues  'Red
'  hue = 5:  r = 32:  g = 0:   B = 0:   GOSUB OutValues  '
'  hue = 6:  r = 29:  g = 0:   B = 0:   GOSUB OutValues  '
'  hue = 7:  r = 0:   g = 35:  B = 0:   GOSUB OutValues  'Green
'  hue = 8:  r = 0:   g = 32:  B = 0:   GOSUB OutValues  '
'  hue = 9:  r = 0:   g = 29:  B = 0:   GOSUB OutValues  '
'  hue = 10: r = 35:  g = 35:  B = 35:  GOSUB OutValues  'Grey
'  hue = 11: r = 34:  g = 34:  B = 34:  GOSUB OutValues  '
'  hue = 12: r = 33:  g = 33:  B = 33:  GOSUB OutValues  '
 
  hue = 255: r = 0:   g = 0:   b = 0:   GOSUB OutValues  'Black
  hue = 254: r = 0:   g = 0:   b = 35:  GOSUB OutValues  'Blue
  hue = 253: r = 0:   g = 0:   b = 32:  GOSUB OutValues  '
  hue = 252: r = 0:   g = 0:   b = 29:  GOSUB OutValues  '
  hue = 251: r = 35:  g = 0:   b = 0:   GOSUB OutValues  'Red
  hue = 250: r = 32:  g = 0:   b = 0:   GOSUB OutValues  '
  hue = 249: r = 29:  g = 0:   b = 0:   GOSUB OutValues  '
  hue = 248: r = 0:   g = 35:  b = 0:   GOSUB OutValues  'Green
  hue = 247: r = 0:   g = 32:  b = 0:   GOSUB OutValues  '
  hue = 246: r = 0:   g = 29:  b = 0:   GOSUB OutValues  '
  hue = 245: r = 35:  g = 35:  b = 35:  GOSUB OutValues  'Grey
  hue = 244: r = 34:  g = 34:  b = 34:  GOSUB OutValues  '
  hue = 243: r = 33:  g = 33:  b = 33:  GOSUB OutValues  '

  EXIT SUB

OutValues:
  OUT &H3C8, hue
  OUT &H3C9, r
  OUT &H3C9, g
  OUT &H3C9, b
  RETURN
END SUB

SUB ShiftDown
  'Moves any blocks that are above empty spaces, down.

  'Go from bottom to top, left to right.
  ' If there is an empty space, then move all of the blocks above it down one.
  FOR i = 1 TO 20
    FOR y = 16 TO 1 STEP -1
      FOR x = 1 TO 12
        IF Board(y, x) = 0 THEN
          FOR y2 = y TO 1 STEP -1
            Board(y2, x) = Board(y2 - 1, x)
          NEXT y2
          Board(1, x) = 0
        END IF
      NEXT x
    NEXT y
  NEXT i

  RefreshBoard
END SUB

SUB ShiftLeftRight
  'Shifts all blocks to the left or right if there is an empty column.

  'Check for an empty column.
  FOR i = 6 TO 1 STEP -1
    IF Board(16, i) = 0 THEN
      FOR x = i TO 1 STEP -1
        FOR y = 1 TO 16
          Board(y, x) = Board(y, x - 1)
        NEXT y
      NEXT x
      z = 0
      FOR i2 = i TO 1 STEP -1
        IF Board(16, i2) <> 0 THEN z = 1
      NEXT i2
      IF z = 0 THEN EXIT FOR
      i = i + 1
    END IF
  NEXT i
  FOR i = 7 TO 12
    IF Board(16, i) = 0 THEN
      FOR x = i TO 12
        FOR y = 1 TO 16
          Board(y, x) = Board(y, x + 1)
        NEXT y
      NEXT x
      z = 0
      FOR i2 = i TO 12
        IF Board(16, i2) <> 0 THEN z = 1
      NEXT i2
      IF z = 0 THEN EXIT FOR
      i = i - 1
    END IF
  NEXT i

  RefreshBoard
END SUB

SUB ShiftUp
  'Shifts all the blocks on the board up one line.

  'Check to see if the player loses.
  FOR x = 1 TO 12
    IF Board(1, x) > 0 THEN
      Lose
    END IF
  NEXT x
 
  'Shift all rows up one.
  FOR y = 1 TO 16
    FOR x = 1 TO 12
      Board(y, x) = Board(y + 1, x)
    NEXT x
  NEXT y

  'Empty bottom row.
  FOR x = 1 TO 12
    Board(17, x) = 0
  NEXT x

  RefreshBoard
END SUB

SUB ShowStats
  LOCATE 25, 1:  PRINT "Level: 00";
  LOCATE 25, 10 - LEN(LTRIM$(STR$(Stat.Level)))
                 PRINT LTRIM$(STR$(Stat.Level));
 
  LOCATE 25, 11: PRINT "Lines: 000";
  LOCATE 25, 21 - LEN(LTRIM$(STR$(Stat.Lines)))
                 PRINT LTRIM$(STR$(Stat.Lines));

  LOCATE 25, 22: PRINT "Points: 0000000000";
  LOCATE 25, 40 - LEN(LTRIM$(STR$(Stat.Points&)))
                 PRINT LTRIM$(STR$(Stat.Points&));
END SUB

SUB Suspend (delay!, Speed&)
'-------------------------------------------------'
'- This function suspends the process for delay! -'
'-  thousanths of a second, with speed& being    -'
'-  how many times the computer can increment a  -'
'-  long int in a FOR loop per second.           -'
'-------------------------------------------------'
  IF delay! = 0 THEN
    WHILE INKEY$ = "": WEND
    EXIT SUB
  END IF

  FOR i& = 1 TO (Speed& * (delay! / 1000))
  NEXT i&
END SUB

SUB zzMouse (Num, x, y)
  Mouse2% = SADD(MOUSE$)
  SELECT CASE Num
    CASE MOUSEINIT:
      '-------------------------------------------------
        'Initialize the Mouse
        IF MOUSE$ = "" THEN
          'Setup the Mouse
          RESTORE
          MOUSE$ = SPACE$(57)
          FOR i = 1 TO 57
            READ a$
            h$ = CHR$(VAL("&H" + a$))
            MID$(MOUSE$, i, 1) = h$
          NEXT i

          DEF SEG = VARSEG(MOUSE$)
          Mouse2% = SADD(MOUSE$)
          ax% = 0:  bx% = 0:  cx% = 0:  dx% = 0
          CALL Absolute(ax%, bx%, cx%, dx%, Mouse2%)
          DEF SEG
          IF NOT ax% THEN
            PRINT "Mouse not found!": SYSTEM
          END IF
          LET AMOUSE$ = "YES"
        END IF
        zzMouse MOUSESPOS, x, y
        zzMouse MOUSESHOW, 0, 0
      '-------------------------------------------------

    CASE MOUSESHOW:
        DEF SEG = VARSEG(MOUSE$)
        ax% = 1:  bx% = 0:  cx% = 0:  dx% = 0
        CALL Absolute(ax%, bx%, cx%, dx%, Mouse2%)

    CASE MOUSEHIDE:
        DEF SEG = VARSEG(MOUSE$)
        ax% = 2:  bx% = 0:  cx% = 0:  dx% = 0
        CALL Absolute(ax%, bx%, cx%, dx%, Mouse2%)

    CASE MOUSEGPOS:
        DEF SEG = VARSEG(MOUSE$)
        ax% = 3:  bx% = 0:  cx% = 0:  dx% = 0
        CALL Absolute(ax%, bx%, cx%, dx%, Mouse2%)
        x = (cx% / 2)
        y = dx%

    CASE MOUSESPOS:
        DEF SEG = VARSEG(MOUSE$)
        ax% = 4:  bx% = 0:  cx% = x * 2: dx% = y
        CALL Absolute(ax%, bx%, cx%, dx%, Mouse2%)

    CASE MOUSEGBUT:
        DEF SEG = VARSEG(MOUSE$)
        ax% = 3:  bx% = 0:  cx% = 0:  dx% = 0
        CALL Absolute(ax%, bx%, cx%, dx%, Mouse2%)
        x = ((bx% AND 1) <> 0)
        y = ((bx% AND 2) <> 0)

    CASE MOUSEZONEX:
        DEF SEG = VARSEG(MOUSE$)
        ax% = 7:  bx% = 0:  cx% = x * 2: dx% = y * 2
        CALL Absolute(ax%, bx%, cx%, dx%, Mouse2%)

    CASE MOUSEZONEY:
        DEF SEG = VARSEG(MOUSE$)
        ax% = 8:  bx% = 0:  cx% = x:  dx% = y
        CALL Absolute(ax%, bx%, cx%, dx%, Mouse2%)

  END SELECT
END SUB

FUNCTION zzMouseIn (x1, y1, x2, y2)
  'Return Values:
  '0 - Mouse is NOT in the box.
  '1 - Mouse is on the border.
  '2 - Mouse is in the box.
  zzMouse MOUSEGET, yloc, xloc
  'Is it inside?
  IF yloc > y1 AND yloc < y2 THEN
    IF xloc > x1 AND xloc < x2 THEN
      zzMouseIn = 2
      EXIT FUNCTION
    END IF
  END IF
  'Is it on the border?  (or inside but that was already found if it was)
  IF yloc >= y1 AND yloc <= y2 THEN
    IF xloc >= x1 AND xloc <= x2 THEN
      zzMouseIn = 1
      EXIT FUNCTION
    END IF
  END IF
  'Not in the box at all.
  zzMouseIn = 0
  EXIT FUNCTION
END FUNCTION

