/******************************************************************************
 SCI Template Game
 By Brian Provinciano
 ******************************************************************************
 main.sc
 Contains the game's main instance and inventory items.
 ******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script MAIN_SCRIPT)
/******************************************************************************/
(use "controls")
(use "sound")
(use "syswindow")
(use "cycle")
(use "game")
(use "inv")
(use "user")
(use "menubar")
(use "feature")
(use "obj")
(use "disposeload")
/******************************************************************************
 * These are the global variables. You can access them from any script as long
 * as it "use"es this script
 ******************************************************************************/
(local
	gEgo					/* points to the ego's class */
	gGame					/* points to the game instance */
	gRoom					/* points to the current room instance */
	gSpeed 					/* the game speed (delay each interpreter cycle) */
	gQuitGame = FALSE		/* if set to TRUE, the game will exit */
	
	gCast					/* points to the cast class (list of actors) */
	gRegions				/* points to the regions class (list of regions) */
	gLocales 				/* points to the locales class (list of locales) */
	gTimers					/* points to the timers class (list of timers) */
	gSounds					/* points to the sounds class (list of sounds) */
	gInv					/* points to the inventory class */
	gAddToPics				/* points to the add to pics class */
	gFeatures				/* points to the add to features class */		
	gSFeatures				/* points to the add to sfeatures class */
	
	gRoomNumberExit			/* room number exit */
	gPreviousRoomNumber		/* the number of the previous room */
	gRoomNumber				/* the number of the current room */ 
	gDebugOnExit = FALSE	/* enter debug mode on room exit */ 
	
	gScore = 0				/* the game score */		
	gMaxScore = 169			/* the maximum game score */
	gOldScore				/* previous score */
	
	gCurrentCursor			/* the number of the current cursor */
	gNormalCursor = 999		/* the number of the normal cursor (ie. arrow) */
	gLoadingCursor = 997	/* the number of the loading cursor (ie. hand) */
	
	gDefaultFont = 1		/* the number of the default font */
	gSaveRestoreFont = 0	/* the number of the font for the save/restore dialogs*/
	gDeadFont = 0			/* the number of the font for the dialog when ego dies */
	
	gUserEvent				/* points to the user's event object */
	gPrintDlg				/* points to the current Print() window */
	gVolume					/* the sound volume */
	gVersion				/* the version string */
	gSaveDirPtr				/* points to the save directory string */
	gCheckAniWait			/* the checkAni delay */
	gSetRegions				/* a flag -- see User:doit() */
	
	gPicAngle				/* the room's pic angle */
	gOverlay = -1			/* whether to overlay the picture when drawing */
	gDefaultPicAni			/* the default pic animation */
	gDefaultPalette			/* the default palette to use for the pictures (0-3) */
	gCastMotionCue			/* if set, the cast's motionCue() is called */
	
	gTheWindow				/* points to the window class */
	gWndColor				/* the colour of the game's windows foreground (ie. text) */
	gWndBack				/* the colour of the game's windows background */

	gOldPort				/* the previous port */
	
	gEgoView				/* ego's current view number */
	
	/* hh:mm:ss | gTimeHours:gTimeMinutes:gTimeSeconds */
	/* the time elapsed since the game started */
	gTimeSeconds			/* the seconds */
	gTimeMinutes			/* the minutes */
	gTimeHours				/* the hours */
	
	gCurrentTime				/* the current time in seconds */
	
	gTheMusic				/* points to the music class */
	gTheSoundFX				/* points to the sound fx class */
	gProgramControl 		/* states whether the program has control or the user */
    worm = 0
    wormGrew = FALSE
    shaved = 1
    holedug = 0
    kidtrapped  = 1
    ridingscooter = FALSE
    desertcount = 0
    alarmdisabled = FALSE
    wearingtie = FALSE
    usedladder = FALSE
    usedchips = FALSE
    usedtimecard = FALSE
    usedcheck = FALSE
    windowstate = 0 // 0=normal, 1=taped, 2=broken
    wormgone = FALSE
    cupfull = FALSE
    houseon = TRUE
    wincount = 0
    poleswinging = 0 //0=unswung, 1=swinging, 2=stopped
    xx1 = 0
    yy1 = 0
    xx2 = 0
    yy2 = 0
    xx3 = 0
    yy3 = 0
    xx4 = 0
    yy4 = 0
    givenfruit = FALSE
    givenball = FALSE
    givenpez = FALSE
)
/******************************************************************************/
(instance public Template of Game
	(properties)
	(method (init)
        // Set up the base window
		= gTheWindow theWindow
		= gWndColor clBLACK
		= gWndBack clWHITE
		(send gTheWindow:
			color(gWndColor)
		    back(gWndBack)
		)

        // Initialize
		(super:init())

        /******************************
         * Set your game version here *
         ******************************/
		= gVersion "1.0"
		    
		// General initialization stuff
	    = gVolume 15
	    DoSound(sndVOLUME gVolume)
		    
	    (SL:code(statusCode))
	    (TheMenuBar:init())
    
	    (scoreSound:
	    	owner(self)
	    	init()
	    )
	    = gTheMusic theMusic
	    (send gTheMusic:
	    	owner(self)
	    	init()
	    )
		= gTheSoundFX theSoundFX
	    (send gTheSoundFX:
	    	owner(self)
	    	init()
	    )
	    
	    = gEgo ego
	    (User:
	    	alterEgo(gEgo)
	    	blocks(0)
	    	y(150)
	    )
			
		Load(rsFONT		gDeadFont)
		Load(rsFONT		gDefaultFont)
		Load(rsFONT		gSaveRestoreFont)
	
		Load(rsCURSOR	gNormalCursor)
		Load(rsCURSOR	gLoadingCursor)
			
	    (if(HaveMouse())
	    	(send gGame:setCursor(gNormalCursor SET_CURSOR_VISIBLE))
		)(else
	    	(send gGame:setCursor(gNormalCursor SET_CURSOR_VISIBLE 304 174))
		)
			
        /*************************************************
         * Initialize the inventory with it's items here *
         *************************************************/
		(Inv:
			add(
				{Nothing}
				{tape}
                {goop}
                {magnet}
                {six cents}
                {shovel}
                {scooter}
                {fruit}
                {watership down}
                {tie}
                {ladder}
                {pez}
                {chips}
                {timecard}
                {check}
                {pants}
                {card}
                {dollar}
                {cup}
                {ticket}
                {club}
                {taped club}
                {golf ball}
			)
		)
			
		// Start the room
		(if(GameIsRestarting())
	    	(self:newRoom(INITROOMS_SCRIPT))
	    )(else
	    	(self:newRoom(TITLESCREEN_SCRIPT))
		)
	)
	(method (doit)
		(super:doit())
		(if(gProgramControl)
			(User:
				canControl(FALSE)
				canInput(FALSE)
			)
		)
		(if(<> gCurrentTime (= gCurrentTime GetTime(gtTIME_OF_DAY)))
		    (if(>= ++gTimeSeconds 60)
		    	= gTimeSeconds 0
		    	++ gTimeMinutes
		    	(if(>= gTimeMinutes 60)
		    		= gTimeMinutes 0
		    		++ gTimeHours
		    	)
			)
		)
  		(if(> gOldScore gScore)
		    	= gOldScore gScore
				(SL:doit())
		)
		(if(< gOldScore gScore)
		    = gOldScore gScore
			(SL:doit())
		)
	)
	(method (replay)
  		(TheMenuBar:draw())
  		(SL:enable())
  		
  		(if(DoSound(sndSET_SOUND))
		    SetMenu(MENU_TOGGLESOUND #text "Turn Off")
		)(else
		    SetMenu(MENU_TOGGLESOUND #text "Turn On")
		)
		(super:replay())
	)
	(method (newRoom roomNum picAni)
  			DisposePrintDlg()
  			Load(rsFONT		gDeadFont)
  			Load(rsFONT		gDefaultFont)
  			Load(rsFONT		gSaveRestoreFont)

  			Load(rsCURSOR	gNormalCursor)
  			Load(rsCURSOR	gLoadingCursor)
     
			(super:newRoom(roomNum))
			(if(< paramTotal 2)
				= gDefaultPicAni Random(0 5)
			)(else
				= gDefaultPicAni picAni
			)
	)
	(method (startRoom roomNum)
		DisposeLoad(
			NULL
			FILEIO_SCRIPT JUMP_SCRIPT EXTRA_SCRIPT WINDOW_SCRIPT
		        TIMER_SCRIPT FOLLOW_SCRIPT REV_SCRIPT DCICON_SCRIPT
		        DOOR_SCRIPT AUTODOOR_SCRIPT
		)
		DisposeScript(DISPOSELOAD_SCRIPT)
		(if(gDebugOnExit)
			= gDebugOnExit FALSE
			SetDebug()
		)
		(send gTheSoundFX:
			stop()
			number(1)
		)
		(super:startRoom(roomNum))
		(if(== gTheSoundFX 11)
		 	(send gEgo:baseSetter(NormalBase))
		)
	)
	(method (changeScore addScore)
		= gScore + gScore addScore
		(if(> addScore 0)
			(scoreSound:playMaybe())
		)
	)
  	(method (handleEvent pEvent)
		(super:handleEvent(pEvent))
		(if((<> (send pEvent:type) evSAID) or (send pEvent:claimed))
		    return(TRUE)
		)

        /***********************************/
        /* Add global said statements here */
        /***********************************/
        
        (if(Said('hi'))
            Print("Well hello to you too!")
        )
        (if(Said('look/self'))
            Print("Curt, you handsome devil!")
        )
        (if(Said('wear,use/tie'))
           (if(== (send gRoom:number()) 265 )

             (if(== wearingtie TRUE)
                Print("You're already wearing it!")
             )(else
                (if(send gEgo:has(INV_TIE))
                   (send gEgo:view(22))
                   (= wearingtie TRUE)
                )(else
                  Print("You don't have one")
                 )
             )
           )(else
                 Print("not now.")

            )
        )
        (if(Said('look>'))
               (if(Said('<in/pants,pocket'))
                 (if(send gEgo:has(INV_CARD))
                    Print("There's nothing else in the pockets.")
                 )(else
                   (if(send gEgo:has(INV_PANTS))
                      Print("Hey! How about that? You found your Harmon's card!")
                      (send gEgo:get(INV_CARD))
                      (send gGame:changeScore(5))
                     
                   )(else
                     Print("you ain't got no other pair of pants")
                    )


                  )
               )(else
                 (if(Said('/pants'))
                    Print("Blue jeans, straight from the dryer.")

                 )(else
                   (if(Said('/cup'))
                      (if(send gEgo:has(INV_CUP))
                         Print("There's a pull tab attached!")
                      )(else
                           Print("You don't have a cup")
                       )


                   )(else
                     (if(Said('[ /* , !* ]'))
                       Print("Try \"look around\"")
                     )
                    )
                  )
                )
                
        )
        (if(Said('wear/pants'))
           (if(send gEgo:has(INV_PANTS))
              Print("The ones you're wearing will be fine for now.")
           )(else
             Print("You ain't got no other pair of pants.")
            )
        )
        (if(Said('drink,get/coke,drink'))
           (if(== cupfull TRUE)
              (Print("ok"))
              (send gGame:changeScore(1))
              = cupfull FALSE
           )(else
              Print("You have no coke to drink")
             )
        )
        (if(Said('pull,get/tab'))
          (if(send gEgo:has(INV_CUP))
           (if(not(send gEgo:has(INV_TICKET)))
              (Print("You've won a ticket to the fundome!"))
              (send gGame:changeScore(5))
              (Print("You throw away the now useless cup."))
              (send gEgo:put(INV_CUP))
              (send gEgo:get(INV_TICKET))
           )(else
              Print("There was only one on the cup")
             )
          )(else
            Print("Do what now?")
           )
        )
        (if(Said('put,use/tape/club'))
           (if(send gEgo:has(INV_CLUB))
              (if(send gEgo:has(INV_TAPE))
                 Print("Good idea!")
                 (send gEgo:put(INV_CLUB))
                 (send gEgo:get(INV_TAPECLUB))
              )(else
                 Print("you careless person, you've run out of tape!")
               )
           )(else
              Print("You need a club.")
            )
        )
        (if(Said('use/anyword'))
            Print("That won't work")
        )
        (if(Said('get/anyword'))
            Print("You don't need it.")
        )
        (if(Said('buy/anyword'))
            Print("You don't need it.")
        )
        (if(Said('ride/scooter'))
            Print("not now.")
        )
		return(FALSE)
  	)
)
/******************************************************************************/
(class Iitem of InvI
	(properties
		said 0
		description 0
		owner 0
		view 0
		loop 0
		cel 0
		script 0
	)
	(method (showSelf)
		Print(
            description
			#title objectName
			#icon view 0 0
		)
	)
)
/******************************************************************************/
(instance statusCode  of Code
	(properties)
 	(method (doit param1)
  		Format(param1 " Score: %d of %-3d                      Curt's Quest " gScore gMaxScore)
 	)
)
/******************************************************************************/
(instance ego of Ego
	(properties
		y 1111
		x 0
		z 0
		heading 0
		yStep 2
		view 0
		loop 0
		cel 0
		priority 0
		underBits 0
		signal $2000
		nsTop 0
		nsLeft 0
		nsBottom 0
		nsRight 0
		lsTop 0
		lsLeft 0
		lsBottom 0
		lsRight 0
		brTop 0
		brLeft 0
		brBottom 0
		brRight 0
		cycleSpeed 0
		script 0
		cycler 0
		timer 0
		illegalBits $8000
		xLast 0
		yLast 0
		xStep 3
		moveSpeed 0
		blocks 0
		baseSetter 0
		mover 0
		looper 0
		viewer 0
		avoider 0
		edgeHit 0
	)
)
/******************************************************************************/
(instance scoreSound of Sound
	(properties
		state 0
		number SCORE_SOUND
		priority 10
		loop 1
		handle 0
		signal 0
		prevSignal 0
		client 0
		owner 0
	)
)
/******************************************************************************/
(instance theMusic  of Sound
	(properties
		state 0
		number 1
		priority 0
		loop 1
		handle 0
		signal 0
		prevSignal 0
		client 0
		owner 0
	)
)
/******************************************************************************/
(instance theSoundFX  of Sound
	(properties
		state 0
		number 1
		priority 5
		loop 1
		handle 0
		signal 0
		prevSignal 0
		client 0
		owner 0
	)
)
/******************************************************************************/
(instance theWindow  of SysWindow
	(properties)
	(method (open)
		(if(< Graph(grGET_COLOURS) 9)
			(if( (< color 7) or (== color 8) )
				= color 0
				= back  15
			)(else
				= color 15
				= back  0
			)
  		)
  		(super:open())
	)
)
/******************************************************************************/
(instance NormalBase of Code
	(properties)
	(method (doit)
		(var temp0)
		(if(== gRoomNumberExit 253)
		    = temp0 22
		)(else
  			= temp0 10
		)
		(send gEgo:
			brBottom(
				(+ (send gEgo:y) 1)
			)
		)
		(send gEgo:
			brTop(
				(- (send gEgo:brBottom) (send gEgo:yStep))
			)
		)
		(send gEgo:
			brLeft(
				(- (send gEgo:x) temp0)
			)
		)
		(send gEgo:
			brRight(
				(+ (send gEgo:x) temp0)
			)
		)
	)
)

/******************************************************************************
 * THE PUBLIC PROCEDURES
 ******************************************************************************/
(procedure public (SetUpEgo theLoop theView)
	PlayerControl()
	(send gEgo:edgeHit(EDGE_NONE))
	(switch(paramTotal)
		(case 0
			SetUpActor(gEgo (send gEgo:loop) gEgoView)
		)
  		(case 1
			SetUpActor(gEgo theLoop gEgoView)
		)
  		(case 2
		    SetUpActor(gEgo theLoop theView)
  		)
	)
)
/******************************************************************************/
(procedure public (SetUpActor pActor theLoop theView)
	(if(> paramTotal 1)
		(send pActor:loop(theLoop))
	)
	(if(> paramTotal 2)
		(send pActor:view(theView))
	)
	(send pActor:
		setLoop(-1)
		setPri(-1)
		setStep(3 2)
		setCycle(Walk)
		illegalBits($8000)
		cycleSpeed(0)
		moveSpeed(0)
		ignoreActors(0)
	)
)
/******************************************************************************/
(procedure public (ProgramControl)
	(User:
		canControl(FALSE)
		canInput(FALSE)
	)
	(send gEgo:setMotion(NULL))
)
/******************************************************************************/
(procedure public (PlayerControl)
	(User:
		canControl(TRUE)
		canInput(TRUE)
	)
	(send gEgo:setMotion(NULL))
)
/******************************************************************************/
(procedure public (DisposePrintDlg)
	(if(gPrintDlg)
		(send gPrintDlg:dispose())
	)
)
/******************************************************************************/
(procedure public (PrintOK)
	Print("O.K.")
)
/******************************************************************************/
(procedure public (PrintItIs)
	Print("It is.")
)
/******************************************************************************/
(procedure public (PrintYouAre)
	Print("You are.")
)
/******************************************************************************/
(procedure public (PrintGoodIdea)
	Print("Good idea. You might try that again later.")
)
/******************************************************************************/
(procedure public (PrintNotCloseEnough)
	Print("You're not close enough.")
)
/******************************************************************************/
(procedure public (PrintAlreadyTookIt)
	Print("You already took it.")
)
/******************************************************************************/
(procedure public (PrintDontHaveIt)
	Print("You don't have it.")
)
/******************************************************************************/
(procedure public (PrintCantDoThat mem)
	(if(> MemoryInfo(miLARGESTPTR) mem)
		return(TRUE)
	)(else
		Print("You can't do that here; at least, not now.")
		return(FALSE)
	)
)
/******************************************************************************/
(procedure public (AddViewToPic pView)
	(var hView)
	(if(pView)
		= hView (View:new())
		(send hView:
		  	view(send pView:view)
			loop(send pView:loop)
			cel(send pView:cel)
			priority(send pView:priority)
			posn( (send pView:x) (send pView:y) )
			addToPic()
		)
		(send pView:
			posn( (send pView:x) (+ 1000 (send pView:y)) )
		)
	)
)
/******************************************************************************/
(procedure public (SetInvIOwner index owner)
	(var hInvI)
	= hInvI (send gInv:at(index))
	(if(< paramTotal 2)
		(send hInvI:owner(gRoomNumberExit))
	)(else
		(send hInvI:owner(owner))
	)
)


/******************************************************************************
 * THE INVENTORY ITEMS                                                        *
 ******************************************************************************/
(instance Nothing  of Iitem
	(properties)
)
/******************************************************************************/
(instance {tape} of Iitem
	(properties
		said 'tape'
		description
             "This is wonderful lucky tape."
		//owner 0
		view 400
		//loop 0
		//cel 0
		//script 0
	)
)
(instance {goop} of Iitem
         (properties
              said 'goop'
              description
                     "this is some scary stuff."
              view 402
          )
)
(instance {magnet} of Iitem
          (properties
              said 'magnet'
              description
                    "a magnet found while wire sorting. finders keepers"
               view 403
           )
)
(instance {six cents} of Iitem
          (properties
              said 'penny'
              description
                    "The equivalent of 17 minutes of work in the shed."
               view 407
           )
)
(instance {shovel} of Iitem
          (properties
              said 'shovel'
              description
                    "A small hand shovel."
               view 409
           )
)
(instance {scooter} of Iitem
          (properties
              said 'scooter'
              description
                    "A Razor-brand scooter acquired by conning a kid."
               view 410
           )
)
(instance {fruit} of Iitem
          (properties
              said 'fruit'
              description
                    "The fruit of the wire tree."
               view 512
           )
)
(instance {watership down} of Iitem
          (properties
              said 'watership/down'
              description
                    "The greatest novel ever written."
               view 412
           )
)
(instance {tie} of Iitem
          (properties
              said 'tie'
              description
                    "A clip-on tie."
               view 413
           )
)
(instance {ladder} of Iitem
          (properties
              said 'ladder'
              description "a ladder."
              view 414

          )
)
(instance {pez} of Iitem
          (properties
              said 'pez'
              description "a golden pez dispenser."
              view 514

          )
)
(instance {chips} of Iitem
          (properties
              said 'chips'
              description "a bag of cheetos."
              view 408

          )
)
(instance {timecard} of Iitem
          (properties
              said 'timecard'
              description "a timecard, filled out by Boey"
              view 415

          )
)
(instance {check} of Iitem
          (properties
              said 'check'
              description "a check, written for the amount of one dollar!"
              view 416

          )
)
(instance {pants} of Iitem
          (properties
              said 'pants'
              description "a pair of pants, fresh from the dryer!"
              view 417

          )
)
(instance {card} of Iitem
          (properties
              said 'card'
              description "Your Harmon's card. It's in pretty good shape, all things considered."
              view 418

          )
)
(instance {dollar} of Iitem
          (properties
              said 'dollar'
              description "This represents a week of wire sorting."
              view 419

          )
)
(instance {cup} of Iitem
          (properties
              said 'cup'
              description "One more holiday cup for your collection."
              view 420

          )
)
(instance {ticket} of Iitem
          (properties
              said 'ticket'
              description "Good for one free round of golf, or one game of bowling at the fun dome."
              view 421

          )
)
(instance {club} of Iitem
          (properties
              said 'club'
              description "A golf club."
              view 422

          )
)
(instance {taped club} of Iitem
          (properties
              said 'club'
              description "A golf club with orange electrical tape attached."
              view 423

          )
)
(instance {golf ball} of Iitem
          (properties
              said 'ball'
              description "An orange golf ball."
              view 424

          )
)
/******************************************************************************/

