/******************************************************************************
 SCI Template Game
 By Brian Provinciano
 ******************************************************************************
 rm001.sc
 Contains the first room of your game. 
 ******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 1)
/******************************************************************************/
(use "main")
(use "wander")
(use "controls")
(use "cycle")
(use "game")
(use "feature")
(use "obj")
(use "inv")
(use "door")
(use "jump")
(use "dpath")
(use "rm002")
(local askedColor=TRUE)
/******************************************************************************/
(instance public rm001 of Rm
	(properties
		picture scriptNumber
		// Set up the rooms to go to/come from here
		north 0
		east 0
		south 0
		west 2
	)
	(method (init)
		// same in every script, starts things up
  		(super:init())
  		(self:setScript(RoomScript))
  		
  		// Check which room ego came from and position it
  		(switch(gPreviousRoomNumber)
            /******************************************************
             * Put the cases here for the rooms ego can come from *
             ******************************************************/ /*
            (case north
  				(send gEgo:
  					posn(210 110)
  					loop(2)
  				)
  			)*/
            // Set up ego's position if it hasn't come from any room
  			(default
  				(send gEgo:
  					posn(150 130)
  					loop(1)
  				)
  			)
            (case 2
                  (send gEgo:
                     posn(50 150)
                     loop(0)
                  )
             )
             (case 31
                  (send gEgo:
                     posn(249 39)
                     loop(2)
                  )
             )
          )
		
		// Set up the ego
		SetUpEgo()		
		(send gEgo:init())

        /****************************************
         * Set up the room's music to play here *
         ****************************************/ /*
		(send gTheMusic:
			prevSignal(0)
			stop()
			number(scriptNumber)
			loop(-1)
			play()
		)*/

        /**************************************************
         * Add the rest of your initialization stuff here *
         **************************************************/
  (if(not(send gEgo:has (INV_TAPE)))(orangeTape:init()))
  (greenTape:init())
  (if(not(send gEgo:has (INV_GOOP)))
      (if(not(== wormGrew TRUE))
               (goop:init()
               setCycle(Fwd)
               cycleSpeed(1))))
  (if(== windowstate 1)
     (windowtape:init())
  )
  (if(== usedladder TRUE)
     (ladder:init())
  )
  (boey:init()
   setCycle(Walk)
   setMotion(Wander)
  )
  )
)
/******************************************************************************/
(instance RoomScript of Script
    (properties)
    (method (doit)
            (if(== (send gEgo:onControl()) ctlYELLOW)
                   (send gRoom:newRoom(2))
           )
    )

    (method (handleEvent pEvent)
         (var dyingScript)//, askedColor=FALSE)

        (super:handleEvent(pEvent))

        /*****************************************
         * Handle the possible said phrases here *
         *****************************************/
 /*looks*/  (if(Said('look/box'))
            Print("there's wire in it!")
        )
        (if(Said('look/hole'))
            Print("There's something very strange about that hole!")
        )
        (if(Said('look/shed'))
            Print("It's remarkably clean. You are really earning your 2.50 an hour!")
        )
        (if(Said('look/shelf'))
            Print("there's the usual assortment of wire, junk, tape, and goop.")
        )
        (if(Said('look/boey,man'))
            Print("Yep. Boey's here too.")
        )
        (if(Said('look/tape'))
            Print("tough choice")
        )
        (if(Said('look/tape'))
            Print("it looks like heaven itself.")
        )
        (if(Said('look/around'))
            Print("You are still in the shed")
        )

         (if(Said('change'))
            (send gEgo:view(5))
         )
/*get*/ (if(Said('take/tape'))

              (if(send gEgo:has(INV_TAPE))
                       Print("You already have it!")
              )(else
                    (if(send gEgo:inRect(205 120 292 135))
                      Print("only one logical choice here!")
                      (send gGame:changeScore(2))
                      (send gEgo:get(INV_TAPE))
                      (orangeTape:hide())
                    )(else
                      Print("You're not close enough!")
                      )
                )

        )
        (if(Said('take/goop'))
             (if(send gEgo:has(INV_GOOP))
                      Print("You already have it!")
                )(else
                   (if(send gEgo:inRect(77 119 170 138))
                    Print("You know, I'm taking an aweful risk here.")
                    (send gGame:changeScore(3))
                    (send gEgo:get(INV_GOOP))
                    (goop:hide())
                    )(else
                      Print("You're not close enough!")
                      )
                  )
         )
        (if(Said('take/wire'))
              Print ("It doesn't do you any good.")
              Print ("unless you're going to Idaho.")
              Print ("(you're not!)")
        )
        (if(Said('take'))
              Print ("Look, you've already taken an exit sign...")
              Print ("4 boxes of ivory p-18's, a broom...")
              Print ("the boots of fury, 26 circuit breakers...")
              Print ("a pole you thought would make a good soap box axle...")
              Print ("and 7 smoke alarms. LEAVE IT!")
          )
        (if(Said('sort/wire'))
            (if(send gEgo:has(INV_MAGNET))
                      Print("You've already done it!")
             )(else
                   (if(send gEgo:inRect(6 120 46 139))
                    Print("While sorting you found a magnet.")
                    //Print("you keep in just in case.")
                    (send gGame:changeScore(3))
                    (send gEgo:get(INV_MAGNET))

                    )(else
                      Print("You're not close enough!")
                      )
                  )
         )
        (if(Said('climb/shelf'))
            (send gEgo:hide())
            (egoClimb:init())
            Print("The shelf collapses, causing a painful death")
           = dyingScript ScriptID(DYING_SCRIPT)
           (send dyingScript:
            caller(3)
            register("And you don't even have worker's comp!")
            )
            (send gGame:setScript(dyingScript))
        )
        (if(Said('climb/ladder'))
           (if(== usedladder TRUE)
              (if(send gEgo:inRect(259 121 269 131))
                 (send gEgo:posn(252 40))
              )(else
                 Print("get closer")
               )
           )(else
              (if(send gEgo:has(INV_LADDER))
                Print("Place it where you need it.")
              )(else
                 Print("You don't have a ladder to climb.")
               )
            )
        )
        (if(Said('climb/down'))
           (if(send gEgo:inRect(205 36 299 43))
              (send gEgo:posn(264 130))
           )(else
            Print("Do what now?")
            )
        )
        (if(Said('talk'))
           (Print("This sucks." #title "Boey says")
            Print("Yeah, we gotta get outta here." #title "You reply"))
        )
        (if(Said('ask [<for,about]/timecard,time,card'))
           (if((send gEgo:has(INV_TIMECARD)) or (== usedtimecard TRUE))
               Print("I gave you the only one I have." #title "Boey says")
           )(else
               Print("I've only got one left, and I need it." #title "Boey says")
            )
        )
        (if(Said('ask [<for,about]/fruit,wire,tree'))
            Print("I've heard tell that a wire tree grows across an uncrossable desert." #title "Boey says")
        )
        (if(Said('ask [<for,about]/golf'))
            Print("If I needed one, I'd go golfing." #title "Boey says")
        )
        (if(Said('ask [<for,about]/pez'))
            Print("I don't know about that, but it would make one great milkshake." #title "Boey says")
        )
        (if(Said('ask [<for,about]/window,hole'))
            Print("It is one of the great mysteries of the shed." #title "Boey says")
        )
        (if(Said('ask [<for,about]/roy'))
            Print("I think he's mad at me." #title "Boey says")
        )
        (if(Said('ask [<for,about]/neighbor'))
            Print("I'd help you booby-trap your yard, but I need to finish here." #title "Boey says")
        )
        (if(Said('ask [<for,about]/holiday'))
            Print("I'm short on cash." #title "Boey says")
        )
        (if(Said('ask [<for,about]/anyword'))
            Print("I don't know much about that." #title "Boey says")
        )
        (if(Said('tell/boey/roy'))
           Print("uh oh." #title "Boey says")
        )
        (if(Said('give/chips'))
           (if(send gEgo:has(INV_CHIPS))
              (if(== usedchips FALSE)
                 Print ("Ohh, cheetos! You can have my timecard!" #title "Boey says")
                 (send gEgo:get(INV_TIMECARD))
                 (send gEgo:put(INV_CHIPS))
                 (= usedchips TRUE)
                 (send gGame:changeScore(4))

              )(else
                  Print ("You have no more cheetos to give.")
               )
           )(else
             Print ("you don't have them.")
            )
        )
        (if(Said('sing/song'))
            Print("Look at this stuff, isn't it neat...")
        )
        //(if(Said('go/hole'))
        //    Print("you can't reach it")
        //)
        (if(Said('ride'))
            (send gRoom:newRoom(31))
        )
        (if(Said('use/ladder'))
            (if(send gEgo:inRect(205 119 299 153))
                     (if(send gEgo:has(INV_LADDER))
                              (if(== usedladder FALSE)
                                     Print ("o.k.")
                                     (send gGame:changeScore(3))
                                     (ladder:init())// view 1)

                                     (send gEgo:put(INV_LADDER))
                                     = usedladder TRUE
                                 )(else
                                       Print ("you already have.")
                                   )
                     )(else
                           Print ("you don't have one.")
                       )
            )(else
                  Print("you're not close enough!")
             )
        )
        (if(Said('go/window,hole'))
            (if(send gEgo:inRect (205 36 299 43))
                (if(< windowstate 2)
                   Print("There is a pane of glass blocking your way!")
                )(else
                  (send gRoom:newRoom(31))
                 )
            )(else
              Print("You're not close enough!")
             )
        )
        (if(Said('break/glass'))
          (if(send gEgo:inRect(205 36 299 43))
           (switch (windowstate)
               (case 0
                  Print("You just tore yourself to shreds!")
                  = dyingScript ScriptID(DYING_SCRIPT)
                  (send dyingScript:
                   caller(3)
                   register("And you don't even have worker's comp!")
                  )
                  (send gGame:setScript(dyingScript))
               )
               (case 1
                  Print("Well now we're getting somewhere!")
                  Print("(But exactly where are we getting?)")
                  = windowstate 2
                  windowtape:hide()
                  (send gGame:changeScore(2))
               )
               (case 2
                   Print("just how many times would you like me to break it?")
               )
           )
         )(else
              Print("You're not close enough!")
             )
        )
        (if(Said('use/tape'))
         (if(send gEgo:has(INV_TAPE))
          (if(send gEgo:inRect(205 36 299 43))
           (switch (windowstate)
               (case 0
                  Print("Great idea!")
                  (send gGame:changeScore(5))
                  = windowstate 1
                  windowtape:init()
               )
               (case 1
                  Print("It's already taped.")

               )
               (case 2
                   Print("You don't need to tape anymore windows.")
               )
           )
          )(else
              Print("You're not close enough!")
           )
         )(else
              Print("you need some tape!")
          )
        )

  )
)
/**************defining OTHER STUFF***********************************/
(instance orangeTape of Prop
 (properties
     y 80
     x 231
     view 400
 )
)
(instance greenTape of Prop
 (properties
     y 80
     x 241
     view 401
 )
)
(instance goop of Prop
 (properties
     y 80
     x 150
     view 402
 )
)
(instance boey of Act
 (properties
     y 292
     x 135
     view 4
 )
)
(instance egoClimb of Act
 (properties
     y 85
     x 240
     view 2
 )
)
(instance ladder of Prop
 (properties
     x 264
     y 126
     view 414
     loop 1
 )
)
(instance windowtape of Prop
 (properties
     x 282
     y 19
     view 513
 )
)

