/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 6)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "door")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
/******************************************************************************/
(instance public rm006 of Rm
	(properties
		picture scriptNumber
		north 0
		east 0
		south 0
		west 0
	)
	(method (init)
		(super:init())
		(self:setScript(RoomScript))

		(switch(gPreviousRoomNumber)
			(default
				(send gEgo:
					posn(150 130)
					loop(1)
				)
			)
		)

		SetUpEgo()
		(send gEgo:init())

        (guard:init()
         setCycle(Walk)
         )
         
        (lady:init())


	)
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
      (method (doit)
            (if(== (send gEgo:onControl()) ctlMAROON)
                   (send gRoom:newRoom(5))
            )
       )
      (method (handleEvent pEvent)
       (var dyingScript)
      (super:handleEvent(pEvent))

           (if(Said('look/guard,man'))
               Print("He's watching you!")
           )
           (if(Said('look/candy'))
               Print("It looks tempting. Especially the colored stuff")
           )
           (if(Said('look/lady,counter'))
               Print("The woman is waiting to be helpful")
           )
           (if(Said('look/shelves'))
            Print("These are the seasonal shelves.")
            Print("Nobody needs this crap.")
           )
           (if(Said('look/around'))
               Print("You find yourself inside Harmon's, in between the candy and the customer service counter. ")
               Print("A guard is here as well. Just in case you need him.")
           )
           (if(Said('talk/guard'))
               Print("\"If only they would let us use guns.\"")
           )
           (if(Said('talk/lady'))
             (if(send gEgo:inRect(20 90 63 156))
                    Print("\"What can I do for you?\"")
             )(else
                  Print("You're not close enough!")
              )
           )
           (if(Said('talk'))
               Print("To whom?")
           )
           (if(Said('eat,take/candy'))
             (if(send gEgo:inRect(228 72 319 160))
                    (guard:setMotion(MoveTo 229 109 RoomScript))
                     = dyingScript ScriptID(DYING_SCRIPT)

                    (send dyingScript:
                     caller(3)
                     register("Stupid is as stupid does. And you is stupid.")
            )
            (send gGame:setScript(dyingScript))
             )(else
                  Print("You're not close enough!")
              )
           )
           (if(Said('ask [<for,about]/ check'))
             (if(send gEgo:inRect(20 90 63 156))
                    Print("\"You will of course need your Harmon's card.\"")
             )(else
                  Print("You're not close enough!")
              )
           )
           (if(Said('ask [<for,about]/ card'))
             (if(send gEgo:inRect(20 90 63 156))
                    Print("\"I show you already have one. Bring it to me, and I'll cash you check.\"")
             )(else
                  Print("You're not close enough!")
              )
           )
           (if(Said('cash/check'))
             (if(send gEgo:inRect(20 90 63 156))
                (if(send gEgo:has(INV_CHECK))
                    (if(send gEgo:has(INV_CARD))
                        Print("\"All right. Here is one dollar!\"" #title "the teller responds")
                        (= usedcheck TRUE)
                        (send gGame:changeScore(4))
                        (send gEgo:put(INV_CHECK))
                        (send gEgo:get(INV_DOLLAR))
                    )(else
                       Print("\"You just need your Harmon's card.\"" #title "the teller replies")
                     )
                )(else
                    Print("You don't have a check to cash.")
                 )
             )(else
                  Print("You're not close enough!")
              )
           )
      )

)
/******************************************************************************/
(instance guard of Act
 (properties
     y 60
     x 60
     view 7
 )
)
(instance lady of Act
 (properties
     y 133
     x 6
     view 8
 )
)
