/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 8)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "door")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
/******************************************************************************/
(instance public rm008 of Rm
	(properties
		picture scriptNumber
		north 0
		east 0
		south 0
		west 0
	)
	(method (init)
		(super:init())
		(self:setScript(RoomScript))

		(switch(gPreviousRoomNumber)
			(case 7
				(send gEgo:
					posn(139 165)
					loop(3)
				)
			)
		)

		SetUpEgo()
		(send gEgo:init())
        (librarian:init())
	)
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
    (method (doit)
            (if(== (send gEgo:onControl()) 2)
                   (send gRoom:newRoom(7))
            )
            (if(== (send gEgo:onControl()) ctlMAROON)
               (if(send gEgo:has(INV_BOOK))
                  (if(== alarmdisabled FALSE)
                   Print("BEEP! BEEP! BEEP!")
                   (librarian:setCycle(End))
                   Print("\"Get out of here!\"")
                   //Wait(180)
                   (send gEgo:put(INV_BOOK))
                   (send gRoom:newRoom(7))
                  )
               )
            )
    )
    
    (method (handleEvent pEvent)
            (super:handleEvent(pEvent))
            (if(Said('look/shelf,shelves,book,books'))
               (if(send gEgo:inRect(0 0 96 42))
                  Print("\"Astrophysics For Dummies\"")
                  Print("\"Avoiding Programming misteaks\"")
                  Print("\"Einstein: He's all relative\"")
                )(else
                  (if(send gEgo:inRect(97 0 182 42))
                     Print("\"Mike Atlas' Encyclopedia of Dictionaries\"")
                  )(else
                    (if(send gEgo:inRect(183 0 276 38))
                       Print("\"Animal Farm \"")
                       Print("\"Huckleberry Finn \"")
                       Print("\"Watership Down \"")
                       Print("and 17 volumes of \"Harry Potter\"")
                    )(else
                        Print("get closer")
                     )
                   )
                  )
           )
           (if(Said('look/man,librarian'))
              Print("He's a little, grumpy man")
           )
           (if(Said('look/alarm'))
              Print("The alarm bars stand guard. Watching. Always watching.")
           )
           (if(Said('look/carpet'))
              Print("It's tacky, but then again, it's paid for by the county")
           )
           (if(Said('look/desk'))
              Print("There is nothing of interest on the desk.")
           )
           (if(Said('look/around,library'))
              Print("You are in the public library. A old librarian is half asleep at his desk. Shelfs of different genres of books line the back wall.")
           )
           (if(Said('get/book,books'))
              Print("Which one?")
           )
           (if(Said('get [<watership]/down'))

              (if(send gEgo:has(INV_BOOK))
                      Print("You already have it!")
              )(else
                 (if(send gEgo:inRect(183 0 276 38))
                    Print("Good choice.")
                    (send gGame:changeScore(3))
                    (send gEgo:get(INV_BOOK))

                 )(else
                      Print("Get closer!")
                  )

               )
           )
           (if(Said('talk'))
              Print("We're closing soon")
           )
           (if(Said('get/card'))
             (if(send gEgo:inRect(113 95 195 120))
                    Print("\"We're not giving those out now. Come back tomorrow.\"")
             )(else
                  Print("You're not close enough!")
              )
        )
           (if(Said('get/anyword'))
              Print("This is not the one you need")
           )
           (if(Said('use/magnet'))
              (if(send gEgo:has(INV_MAGNET))
                 (if(== alarmdisabled TRUE)
                      Print("There's no need now!")
             )(else
                   (if(send gEgo:inRect(103 54 191 189))
                    Print("The dull hum of the alarm dies, fried by your ingenuity.")
                    (send gGame:changeScore(5))
                    (= alarmdisabled TRUE)

                   )(else
                      Print("not from here!")
                    )
              )
            )(else
              Print("You don't have one.")
             )
           )
        (if(Said('ask [<for,about]/ card'))
             (if(send gEgo:inRect(113 95 195 120))
                    Print("\"We're not giving those out now. Come back tomorrow.\"")
             )(else
                  Print("You're not close enough!")
              )
        )
        (if(Said('ask [<for,about]/ book'))
             (if(send gEgo:inRect(113 95 195 120))
                    Print("\"Do you have your card?\"")
             )(else
                  Print("You're not close enough!")
              )
        )
        (if(Said('check/book'))
             (if(send gEgo:inRect(113 95 195 120))
                    Print("\"Do you have your card?\"")
             )(else
                  Print("You're not close enough!")
              )
        )
    )
)
/******************************************************************************/
(instance librarian of Act
 (properties
     y 84
     x 149
     view 12
 )
)
