/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 10)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "door")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
/******************************************************************************/
(instance public rm010 of Rm
	(properties
		picture scriptNumber
		north 0
		east 0
		south 0
		west 0
	)
	(method (init)
        (var dyingScript)
		(super:init())
		(self:setScript(RoomScript))

		(switch(gPreviousRoomNumber)
			(case 9
				(send gEgo:
					posn(156 176)
					loop(3)
				)
			)
            (case 11
				(send gEgo:
					posn(290 60)
					loop(1)
				)
                (if(not(send gEgo:has(INV_BALL)))
                   Print("You didn't get the ball, and there are no more tickets. sorry, man. Enjoy wire sorting.")
                   = dyingScript ScriptID(DYING_SCRIPT)
                   (send dyingScript:
                     caller(3)
                     register("Next time, look harder.")
                   )
                   (send gGame:setScript(dyingScript))
                )
			)
            (case 13
				(send gEgo:
					posn(290 60)
					loop(1)
				)
                (if(not(send gEgo:has(INV_BALL)))
                   Print("You didn't get the ball, and there are no more tickets. sorry, man. Enjoy wire sorting.")
                   = dyingScript ScriptID(DYING_SCRIPT)
                   (send dyingScript:
                     caller(3)
                     register("Next time, look harder.")
                   )
                   (send gGame:setScript(dyingScript))
                )
			)
		)

		SetUpEgo()
		(send gEgo:init())
        (ticketman:init())
        (ticketman1:init())
        (ride:init()
         setCycle(Fwd)
         cycleSpeed(30)
         ignoreActors())
	)
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
    (method (doit)
            (if(== (send gEgo:onControl()) 2)
                   (send gRoom:newRoom(9))
            )
            (if(== (send gEgo:onControl()) ctlMAROON)
               (if(send gEgo:has(INV_TICKET))
                  (Print("You give the kid your ticket,and he gives you a golf club in return."))
                  (send gEgo:put(INV_TICKET))
                  (send gEgo:get(INV_CLUB))
                  (send gRoom:newRoom(11))
               )(else
                  Print("Sorry dude, you need a ticket.")
                  (send gEgo:posn(156 176) loop(3))
                )
            )
            (if(== (send gEgo:onControl()) ctlYELLOW)
                   (if(send gEgo:has(INV_TICKET))
                  (send gRoom:newRoom(14))
               )(else
                  Print("I'm Sorry, you need a ticket.")
                  (send gEgo:posn(156 176) loop(3))
                )
            )
        )
        (method (handleEvent pEvent)
            (super:handleEvent(pEvent))
            (if(Said('look/around'))
               Print("There are two ticket takers, one for bowling, to the left, and one for golf, to the right.")
            )
            (if(Said('look/man,guard,boy'))
               Print("One is a weenie, the other may be stoned.")
            )
            (if(Said('look/ride'))
               Print("It's a motion simulator, and you can't get to it. I programmed it that way.")
            )
            (if(Said('look/golf'))
               Print("It's off to the right.")
            )
            (if(Said('look/bowling'))
               Print("It's off to the left.")
            )
            (if(Said('give,use/ticket'))
               Print("Just walk through, he'll take your ticket.")
            )
            (if(Said('play/golf'))
               Print("You need a ticket.")
            )
            (if(Said('ride/anyword'))
               Print("If you can get there, go ahead. I'll wait until you're done.")
            )
            (if(Said('talk'))
             (if(send gEgo:inRect(200 1 319 86))
                    Print("\"Yo. You need a ticket.\"")
             )(else
                (if(send gEgo:inRect(1 1 111 99))
                   Print("\"If you have a ticket, you can bowl!\"")
                )(else
                     Print("Don't shout!")
                 )
              )
            )

            (if(Said('ask [<for,about]/ ticket'))
             (if(send gEgo:inRect(200 1 319 86))
                    Print("\"Dunno.\"")
             )(else
                (if(send gEgo:inRect(1 1 111 99))
                   Print("\"They are available for six dollars.\"")
                )(else
                     Print("Don't shout!")
                 )
              )
            )

            (if(Said('ask [<for,about]/ golf'))
             (if(send gEgo:inRect(200 1 319 86))
                    Print("\"This way.\"")
             )(else
                (if(send gEgo:inRect(1 1 111 99))
                   Print("\"You need to speak to the gentleman across from me.\"")
                )(else
                     Print("Don't shout!")
                 )
              )
            )
            (if(Said('ask [<for,about]/ bowling'))
             (if(send gEgo:inRect(200 1 319 86))
                    Print("the ticket taker points in the general direction of the other ticket taker.")
             )(else
                (if(send gEgo:inRect(1 1 111 99))
                   Print("\"It's loads of fun!\"")
                )(else
                     Print("Don't shout!")
                 )
              )
            )
            (if(Said('ask [<for,about]/ ball'))
             (if(send gEgo:inRect(200 1 319 86))
                    Print("\"There are some scattered around.\"")
             )(else
                (if(send gEgo:inRect(1 1 111 99))
                   Print("\"You need to speak to the gentleman across from me.\"")
                )(else
                     Print("Don't shout!")
                 )
              )
            )
            (if(Said('ask [<for,about]/ ticket'))
             (if(send gEgo:inRect(200 1 319 86))
                    Print("\"I don't have any.\"")
             )(else
                (if(send gEgo:inRect(1 1 111 99))
                   Print("\"They need to be purchased in advance.\"")
                )(else
                     Print("Don't shout!")
                 )
              )
            )
            (if(Said('buy/ticket'))
             (if(send gEgo:inRect(200 1 319 86))
                    Print("\"I don't have 'em.\"")
             )(else
                (if(send gEgo:inRect(1 1 111 99))
                   Print("\"They need to be purchased in advance.\"")
                )(else
                     Print("Don't shout!")
                 )
              )
            )
            (if(Said('ask [<for,about]/ anyword'))
             (if(send gEgo:inRect(200 1 319 86))
                    Print("\"Dunno.\"")
             )(else
                (if(send gEgo:inRect(1 1 111 99))
                   Print("\"Umm... I could ask my manager.\"")
                )(else
                     Print("Don't shout!")
                 )
              )
            )
         )

)
/******************************************************************************/
(instance ticketman of Act
 (properties
     y 40
     x 311
     view 17
 )
)
(instance ticketman1 of Act
 (properties
     y 45
     x 5
     view 18
 )
)
(instance ride of Prop
 (properties
     y 162
     x 268
     view 502
 )
)
