/******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script 12)
/******************************************************************************/
(use "controls")
(use "cycle")
(use "door")
(use "feature")
(use "game")
(use "inv")
(use "main")
(use "obj")
/******************************************************************************/
(instance public rm012 of Rm
	(properties
		picture scriptNumber
		north 0
		east 0
		south 0
		west 0
	)
	(method (init)
		(super:init())
		(self:setScript(RoomScript))

		(switch(gPreviousRoomNumber)
			(case 11
				(send gEgo:
					posn(26 175)
					loop(0)
				)
                = poleswinging 0
			)
            (case 13
				(send gEgo:
					posn(297 43)
					loop(2)
				)
                = poleswinging 0
			)
		)

		SetUpEgo()
		(send gEgo:init())
        (pole:init())
	)
)
/******************************************************************************/
(instance RoomScript of Script
	(properties)
    (method (doit)

            (if(== (send gEgo:onControl()) 2)
                   (send gRoom:newRoom(11))
            )
            (if(== (send gEgo:onControl()) ctlMAROON)
                   (send gRoom:newRoom(13))
            )
        )
    (method (handleEvent pEvent)

            (super:handleEvent(pEvent))
            (if(Said('move,swing/pole,post'))
               (if(send gEgo:inRect(198 72 265 123))
                    (pole:setCycle(Fwd))
                    = poleswinging 1
                    (send gGame:changeScore(1))
               )(else
                  Print("get closer.")
                )
            )
            (if(Said('stop/pole,post'))
               (if(send gEgo:inRect(198 72 265 123))
                    (pole:setCycle(End))
                    = poleswinging 2
                    (send gGame:changeScore(1))
               )(else
                  Print("get closer.")
                )
            )
            (if(Said('look>'))
               (if(Said('<in/hole'))
                  (if(send gEgo:inRect(198 72 265 123))
                     (if(== poleswinging 0)

                             Print("The post is blocking your way")
                     )(else
                         (if(== poleswinging 1)

                             Print("Good heavens no")
                         )(else
                           (if(== poleswinging 2)
                              Print("You have found a golf ball!")
                              (send gGame:changeScore(5))
                              Print("But it's pink.")
                           )
                          )
                      )
                  )(else
                      Print("Get closer")
                   )
               )(else
                  (if(Said('/hole'))
                     Print("Try 'look in hole'")
                  )
                )
            )
            (if(Said('look/around'))
               Print("Hole number 9, a post that must be swung to reveal the hole. Par 2. I recommend a putter.")
            )
            (if(Said('look/post'))
               Print("It's large. it's heavy. It's a post")
            )
            (if(Said('get/ball'))
               Print("it's the wrong color")
            )
            (if(Said('use/putter'))
                Print("Normally, I'd agree, but we're in a hurry here.")
            )
            (if(Said('golf'))
                Print("No time.")
            )
        )
)
/******************************************************************************/
 (instance pole of Prop
 (properties
     y 97
     x 230
     view 503
 )
)
